package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.enums.ErrorCode;
import odata.msgraph.client.beta.enums.PolicySetStatus;


/**
 * <i>“A class containing the properties used for mdm windows information protection
 * policy PolicySetItem.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MdmWindowsInformationProtectionPolicyPolicySetItem extends PolicySetItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mdmWindowsInformationProtectionPolicyPolicySetItem";
    }

    protected MdmWindowsInformationProtectionPolicyPolicySetItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMdmWindowsInformationProtectionPolicyPolicySetItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String payloadId;
        private String itemType;
        private String displayName;
        private PolicySetStatus status;
        private ErrorCode errorCode;
        private List<String> guidedDeploymentTags;
        private String guidedDeploymentTagsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder payloadId(String payloadId) {
            this.payloadId = payloadId;
            this.changedFields = changedFields.add("payloadId");
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            this.changedFields = changedFields.add("itemType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder status(PolicySetStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder guidedDeploymentTags(List<String> guidedDeploymentTags) {
            this.guidedDeploymentTags = guidedDeploymentTags;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        public Builder guidedDeploymentTags(String... guidedDeploymentTags) {
            return guidedDeploymentTags(Arrays.asList(guidedDeploymentTags));
        }

        public Builder guidedDeploymentTagsNextLink(String guidedDeploymentTagsNextLink) {
            this.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        public MdmWindowsInformationProtectionPolicyPolicySetItem build() {
            MdmWindowsInformationProtectionPolicyPolicySetItem _x = new MdmWindowsInformationProtectionPolicyPolicySetItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mdmWindowsInformationProtectionPolicyPolicySetItem";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.payloadId = payloadId;
            _x.itemType = itemType;
            _x.displayName = displayName;
            _x.status = status;
            _x.errorCode = errorCode;
            _x.guidedDeploymentTags = guidedDeploymentTags;
            _x.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MdmWindowsInformationProtectionPolicyPolicySetItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MdmWindowsInformationProtectionPolicyPolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MdmWindowsInformationProtectionPolicyPolicySetItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MdmWindowsInformationProtectionPolicyPolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MdmWindowsInformationProtectionPolicyPolicySetItem _copy() {
        MdmWindowsInformationProtectionPolicyPolicySetItem _x = new MdmWindowsInformationProtectionPolicyPolicySetItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.payloadId = payloadId;
        _x.itemType = itemType;
        _x.displayName = displayName;
        _x.status = status;
        _x.errorCode = errorCode;
        _x.guidedDeploymentTags = guidedDeploymentTags;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MdmWindowsInformationProtectionPolicyPolicySetItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("payloadId=");
        b.append(this.payloadId);
        b.append(", ");
        b.append("itemType=");
        b.append(this.itemType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("guidedDeploymentTags=");
        b.append(this.guidedDeploymentTags);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
