package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.WindowsInformationProtectionApp;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionDataRecoveryCertificate;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionIPRangeCollection;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionProxiedDomainCollection;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionResourceCollection;
import odata.msgraph.client.beta.enums.WindowsInformationProtectionEnforcementLevel;


/**
 * <i>“Policy for Windows information protection with MDM”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MdmWindowsInformationProtectionPolicy extends WindowsInformationProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mdmWindowsInformationProtectionPolicy";
    }

    protected MdmWindowsInformationProtectionPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMdmWindowsInformationProtectionPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private WindowsInformationProtectionEnforcementLevel enforcementLevel;
        private String enterpriseDomain;
        private List<WindowsInformationProtectionResourceCollection> enterpriseProtectedDomainNames;
        private String enterpriseProtectedDomainNamesNextLink;
        private Boolean protectionUnderLockConfigRequired;
        private WindowsInformationProtectionDataRecoveryCertificate dataRecoveryCertificate;
        private Boolean revokeOnUnenrollDisabled;
        private String rightsManagementServicesTemplateId;
        private Boolean azureRightsManagementServicesAllowed;
        private Boolean iconsVisible;
        private List<WindowsInformationProtectionApp> protectedApps;
        private String protectedAppsNextLink;
        private List<WindowsInformationProtectionApp> exemptApps;
        private String exemptAppsNextLink;
        private List<WindowsInformationProtectionResourceCollection> enterpriseNetworkDomainNames;
        private String enterpriseNetworkDomainNamesNextLink;
        private List<WindowsInformationProtectionProxiedDomainCollection> enterpriseProxiedDomains;
        private String enterpriseProxiedDomainsNextLink;
        private List<WindowsInformationProtectionIPRangeCollection> enterpriseIPRanges;
        private String enterpriseIPRangesNextLink;
        private Boolean enterpriseIPRangesAreAuthoritative;
        private List<WindowsInformationProtectionResourceCollection> enterpriseProxyServers;
        private String enterpriseProxyServersNextLink;
        private List<WindowsInformationProtectionResourceCollection> enterpriseInternalProxyServers;
        private String enterpriseInternalProxyServersNextLink;
        private Boolean enterpriseProxyServersAreAuthoritative;
        private List<WindowsInformationProtectionResourceCollection> neutralDomainResources;
        private String neutralDomainResourcesNextLink;
        private Boolean indexingEncryptedStoresOrItemsBlocked;
        private List<WindowsInformationProtectionResourceCollection> smbAutoEncryptedFileExtensions;
        private String smbAutoEncryptedFileExtensionsNextLink;
        private Boolean isAssigned;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder enforcementLevel(WindowsInformationProtectionEnforcementLevel enforcementLevel) {
            this.enforcementLevel = enforcementLevel;
            this.changedFields = changedFields.add("enforcementLevel");
            return this;
        }

        public Builder enterpriseDomain(String enterpriseDomain) {
            this.enterpriseDomain = enterpriseDomain;
            this.changedFields = changedFields.add("enterpriseDomain");
            return this;
        }

        public Builder enterpriseProtectedDomainNames(List<WindowsInformationProtectionResourceCollection> enterpriseProtectedDomainNames) {
            this.enterpriseProtectedDomainNames = enterpriseProtectedDomainNames;
            this.changedFields = changedFields.add("enterpriseProtectedDomainNames");
            return this;
        }

        public Builder enterpriseProtectedDomainNames(WindowsInformationProtectionResourceCollection... enterpriseProtectedDomainNames) {
            return enterpriseProtectedDomainNames(Arrays.asList(enterpriseProtectedDomainNames));
        }

        public Builder enterpriseProtectedDomainNamesNextLink(String enterpriseProtectedDomainNamesNextLink) {
            this.enterpriseProtectedDomainNamesNextLink = enterpriseProtectedDomainNamesNextLink;
            this.changedFields = changedFields.add("enterpriseProtectedDomainNames");
            return this;
        }

        public Builder protectionUnderLockConfigRequired(Boolean protectionUnderLockConfigRequired) {
            this.protectionUnderLockConfigRequired = protectionUnderLockConfigRequired;
            this.changedFields = changedFields.add("protectionUnderLockConfigRequired");
            return this;
        }

        public Builder dataRecoveryCertificate(WindowsInformationProtectionDataRecoveryCertificate dataRecoveryCertificate) {
            this.dataRecoveryCertificate = dataRecoveryCertificate;
            this.changedFields = changedFields.add("dataRecoveryCertificate");
            return this;
        }

        public Builder revokeOnUnenrollDisabled(Boolean revokeOnUnenrollDisabled) {
            this.revokeOnUnenrollDisabled = revokeOnUnenrollDisabled;
            this.changedFields = changedFields.add("revokeOnUnenrollDisabled");
            return this;
        }

        public Builder rightsManagementServicesTemplateId(String rightsManagementServicesTemplateId) {
            this.rightsManagementServicesTemplateId = rightsManagementServicesTemplateId;
            this.changedFields = changedFields.add("rightsManagementServicesTemplateId");
            return this;
        }

        public Builder azureRightsManagementServicesAllowed(Boolean azureRightsManagementServicesAllowed) {
            this.azureRightsManagementServicesAllowed = azureRightsManagementServicesAllowed;
            this.changedFields = changedFields.add("azureRightsManagementServicesAllowed");
            return this;
        }

        public Builder iconsVisible(Boolean iconsVisible) {
            this.iconsVisible = iconsVisible;
            this.changedFields = changedFields.add("iconsVisible");
            return this;
        }

        public Builder protectedApps(List<WindowsInformationProtectionApp> protectedApps) {
            this.protectedApps = protectedApps;
            this.changedFields = changedFields.add("protectedApps");
            return this;
        }

        public Builder protectedApps(WindowsInformationProtectionApp... protectedApps) {
            return protectedApps(Arrays.asList(protectedApps));
        }

        public Builder protectedAppsNextLink(String protectedAppsNextLink) {
            this.protectedAppsNextLink = protectedAppsNextLink;
            this.changedFields = changedFields.add("protectedApps");
            return this;
        }

        public Builder exemptApps(List<WindowsInformationProtectionApp> exemptApps) {
            this.exemptApps = exemptApps;
            this.changedFields = changedFields.add("exemptApps");
            return this;
        }

        public Builder exemptApps(WindowsInformationProtectionApp... exemptApps) {
            return exemptApps(Arrays.asList(exemptApps));
        }

        public Builder exemptAppsNextLink(String exemptAppsNextLink) {
            this.exemptAppsNextLink = exemptAppsNextLink;
            this.changedFields = changedFields.add("exemptApps");
            return this;
        }

        public Builder enterpriseNetworkDomainNames(List<WindowsInformationProtectionResourceCollection> enterpriseNetworkDomainNames) {
            this.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
            this.changedFields = changedFields.add("enterpriseNetworkDomainNames");
            return this;
        }

        public Builder enterpriseNetworkDomainNames(WindowsInformationProtectionResourceCollection... enterpriseNetworkDomainNames) {
            return enterpriseNetworkDomainNames(Arrays.asList(enterpriseNetworkDomainNames));
        }

        public Builder enterpriseNetworkDomainNamesNextLink(String enterpriseNetworkDomainNamesNextLink) {
            this.enterpriseNetworkDomainNamesNextLink = enterpriseNetworkDomainNamesNextLink;
            this.changedFields = changedFields.add("enterpriseNetworkDomainNames");
            return this;
        }

        public Builder enterpriseProxiedDomains(List<WindowsInformationProtectionProxiedDomainCollection> enterpriseProxiedDomains) {
            this.enterpriseProxiedDomains = enterpriseProxiedDomains;
            this.changedFields = changedFields.add("enterpriseProxiedDomains");
            return this;
        }

        public Builder enterpriseProxiedDomains(WindowsInformationProtectionProxiedDomainCollection... enterpriseProxiedDomains) {
            return enterpriseProxiedDomains(Arrays.asList(enterpriseProxiedDomains));
        }

        public Builder enterpriseProxiedDomainsNextLink(String enterpriseProxiedDomainsNextLink) {
            this.enterpriseProxiedDomainsNextLink = enterpriseProxiedDomainsNextLink;
            this.changedFields = changedFields.add("enterpriseProxiedDomains");
            return this;
        }

        public Builder enterpriseIPRanges(List<WindowsInformationProtectionIPRangeCollection> enterpriseIPRanges) {
            this.enterpriseIPRanges = enterpriseIPRanges;
            this.changedFields = changedFields.add("enterpriseIPRanges");
            return this;
        }

        public Builder enterpriseIPRanges(WindowsInformationProtectionIPRangeCollection... enterpriseIPRanges) {
            return enterpriseIPRanges(Arrays.asList(enterpriseIPRanges));
        }

        public Builder enterpriseIPRangesNextLink(String enterpriseIPRangesNextLink) {
            this.enterpriseIPRangesNextLink = enterpriseIPRangesNextLink;
            this.changedFields = changedFields.add("enterpriseIPRanges");
            return this;
        }

        public Builder enterpriseIPRangesAreAuthoritative(Boolean enterpriseIPRangesAreAuthoritative) {
            this.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
            this.changedFields = changedFields.add("enterpriseIPRangesAreAuthoritative");
            return this;
        }

        public Builder enterpriseProxyServers(List<WindowsInformationProtectionResourceCollection> enterpriseProxyServers) {
            this.enterpriseProxyServers = enterpriseProxyServers;
            this.changedFields = changedFields.add("enterpriseProxyServers");
            return this;
        }

        public Builder enterpriseProxyServers(WindowsInformationProtectionResourceCollection... enterpriseProxyServers) {
            return enterpriseProxyServers(Arrays.asList(enterpriseProxyServers));
        }

        public Builder enterpriseProxyServersNextLink(String enterpriseProxyServersNextLink) {
            this.enterpriseProxyServersNextLink = enterpriseProxyServersNextLink;
            this.changedFields = changedFields.add("enterpriseProxyServers");
            return this;
        }

        public Builder enterpriseInternalProxyServers(List<WindowsInformationProtectionResourceCollection> enterpriseInternalProxyServers) {
            this.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
            this.changedFields = changedFields.add("enterpriseInternalProxyServers");
            return this;
        }

        public Builder enterpriseInternalProxyServers(WindowsInformationProtectionResourceCollection... enterpriseInternalProxyServers) {
            return enterpriseInternalProxyServers(Arrays.asList(enterpriseInternalProxyServers));
        }

        public Builder enterpriseInternalProxyServersNextLink(String enterpriseInternalProxyServersNextLink) {
            this.enterpriseInternalProxyServersNextLink = enterpriseInternalProxyServersNextLink;
            this.changedFields = changedFields.add("enterpriseInternalProxyServers");
            return this;
        }

        public Builder enterpriseProxyServersAreAuthoritative(Boolean enterpriseProxyServersAreAuthoritative) {
            this.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
            this.changedFields = changedFields.add("enterpriseProxyServersAreAuthoritative");
            return this;
        }

        public Builder neutralDomainResources(List<WindowsInformationProtectionResourceCollection> neutralDomainResources) {
            this.neutralDomainResources = neutralDomainResources;
            this.changedFields = changedFields.add("neutralDomainResources");
            return this;
        }

        public Builder neutralDomainResources(WindowsInformationProtectionResourceCollection... neutralDomainResources) {
            return neutralDomainResources(Arrays.asList(neutralDomainResources));
        }

        public Builder neutralDomainResourcesNextLink(String neutralDomainResourcesNextLink) {
            this.neutralDomainResourcesNextLink = neutralDomainResourcesNextLink;
            this.changedFields = changedFields.add("neutralDomainResources");
            return this;
        }

        public Builder indexingEncryptedStoresOrItemsBlocked(Boolean indexingEncryptedStoresOrItemsBlocked) {
            this.indexingEncryptedStoresOrItemsBlocked = indexingEncryptedStoresOrItemsBlocked;
            this.changedFields = changedFields.add("indexingEncryptedStoresOrItemsBlocked");
            return this;
        }

        public Builder smbAutoEncryptedFileExtensions(List<WindowsInformationProtectionResourceCollection> smbAutoEncryptedFileExtensions) {
            this.smbAutoEncryptedFileExtensions = smbAutoEncryptedFileExtensions;
            this.changedFields = changedFields.add("smbAutoEncryptedFileExtensions");
            return this;
        }

        public Builder smbAutoEncryptedFileExtensions(WindowsInformationProtectionResourceCollection... smbAutoEncryptedFileExtensions) {
            return smbAutoEncryptedFileExtensions(Arrays.asList(smbAutoEncryptedFileExtensions));
        }

        public Builder smbAutoEncryptedFileExtensionsNextLink(String smbAutoEncryptedFileExtensionsNextLink) {
            this.smbAutoEncryptedFileExtensionsNextLink = smbAutoEncryptedFileExtensionsNextLink;
            this.changedFields = changedFields.add("smbAutoEncryptedFileExtensions");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public MdmWindowsInformationProtectionPolicy build() {
            MdmWindowsInformationProtectionPolicy _x = new MdmWindowsInformationProtectionPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mdmWindowsInformationProtectionPolicy";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.enforcementLevel = enforcementLevel;
            _x.enterpriseDomain = enterpriseDomain;
            _x.enterpriseProtectedDomainNames = enterpriseProtectedDomainNames;
            _x.enterpriseProtectedDomainNamesNextLink = enterpriseProtectedDomainNamesNextLink;
            _x.protectionUnderLockConfigRequired = protectionUnderLockConfigRequired;
            _x.dataRecoveryCertificate = dataRecoveryCertificate;
            _x.revokeOnUnenrollDisabled = revokeOnUnenrollDisabled;
            _x.rightsManagementServicesTemplateId = rightsManagementServicesTemplateId;
            _x.azureRightsManagementServicesAllowed = azureRightsManagementServicesAllowed;
            _x.iconsVisible = iconsVisible;
            _x.protectedApps = protectedApps;
            _x.protectedAppsNextLink = protectedAppsNextLink;
            _x.exemptApps = exemptApps;
            _x.exemptAppsNextLink = exemptAppsNextLink;
            _x.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
            _x.enterpriseNetworkDomainNamesNextLink = enterpriseNetworkDomainNamesNextLink;
            _x.enterpriseProxiedDomains = enterpriseProxiedDomains;
            _x.enterpriseProxiedDomainsNextLink = enterpriseProxiedDomainsNextLink;
            _x.enterpriseIPRanges = enterpriseIPRanges;
            _x.enterpriseIPRangesNextLink = enterpriseIPRangesNextLink;
            _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
            _x.enterpriseProxyServers = enterpriseProxyServers;
            _x.enterpriseProxyServersNextLink = enterpriseProxyServersNextLink;
            _x.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
            _x.enterpriseInternalProxyServersNextLink = enterpriseInternalProxyServersNextLink;
            _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
            _x.neutralDomainResources = neutralDomainResources;
            _x.neutralDomainResourcesNextLink = neutralDomainResourcesNextLink;
            _x.indexingEncryptedStoresOrItemsBlocked = indexingEncryptedStoresOrItemsBlocked;
            _x.smbAutoEncryptedFileExtensions = smbAutoEncryptedFileExtensions;
            _x.smbAutoEncryptedFileExtensionsNextLink = smbAutoEncryptedFileExtensionsNextLink;
            _x.isAssigned = isAssigned;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MdmWindowsInformationProtectionPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MdmWindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MdmWindowsInformationProtectionPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MdmWindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MdmWindowsInformationProtectionPolicy _copy() {
        MdmWindowsInformationProtectionPolicy _x = new MdmWindowsInformationProtectionPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.enforcementLevel = enforcementLevel;
        _x.enterpriseDomain = enterpriseDomain;
        _x.enterpriseProtectedDomainNames = enterpriseProtectedDomainNames;
        _x.protectionUnderLockConfigRequired = protectionUnderLockConfigRequired;
        _x.dataRecoveryCertificate = dataRecoveryCertificate;
        _x.revokeOnUnenrollDisabled = revokeOnUnenrollDisabled;
        _x.rightsManagementServicesTemplateId = rightsManagementServicesTemplateId;
        _x.azureRightsManagementServicesAllowed = azureRightsManagementServicesAllowed;
        _x.iconsVisible = iconsVisible;
        _x.protectedApps = protectedApps;
        _x.exemptApps = exemptApps;
        _x.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
        _x.enterpriseProxiedDomains = enterpriseProxiedDomains;
        _x.enterpriseIPRanges = enterpriseIPRanges;
        _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
        _x.enterpriseProxyServers = enterpriseProxyServers;
        _x.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
        _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
        _x.neutralDomainResources = neutralDomainResources;
        _x.indexingEncryptedStoresOrItemsBlocked = indexingEncryptedStoresOrItemsBlocked;
        _x.smbAutoEncryptedFileExtensions = smbAutoEncryptedFileExtensions;
        _x.isAssigned = isAssigned;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MdmWindowsInformationProtectionPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("enforcementLevel=");
        b.append(this.enforcementLevel);
        b.append(", ");
        b.append("enterpriseDomain=");
        b.append(this.enterpriseDomain);
        b.append(", ");
        b.append("enterpriseProtectedDomainNames=");
        b.append(this.enterpriseProtectedDomainNames);
        b.append(", ");
        b.append("protectionUnderLockConfigRequired=");
        b.append(this.protectionUnderLockConfigRequired);
        b.append(", ");
        b.append("dataRecoveryCertificate=");
        b.append(this.dataRecoveryCertificate);
        b.append(", ");
        b.append("revokeOnUnenrollDisabled=");
        b.append(this.revokeOnUnenrollDisabled);
        b.append(", ");
        b.append("rightsManagementServicesTemplateId=");
        b.append(this.rightsManagementServicesTemplateId);
        b.append(", ");
        b.append("azureRightsManagementServicesAllowed=");
        b.append(this.azureRightsManagementServicesAllowed);
        b.append(", ");
        b.append("iconsVisible=");
        b.append(this.iconsVisible);
        b.append(", ");
        b.append("protectedApps=");
        b.append(this.protectedApps);
        b.append(", ");
        b.append("exemptApps=");
        b.append(this.exemptApps);
        b.append(", ");
        b.append("enterpriseNetworkDomainNames=");
        b.append(this.enterpriseNetworkDomainNames);
        b.append(", ");
        b.append("enterpriseProxiedDomains=");
        b.append(this.enterpriseProxiedDomains);
        b.append(", ");
        b.append("enterpriseIPRanges=");
        b.append(this.enterpriseIPRanges);
        b.append(", ");
        b.append("enterpriseIPRangesAreAuthoritative=");
        b.append(this.enterpriseIPRangesAreAuthoritative);
        b.append(", ");
        b.append("enterpriseProxyServers=");
        b.append(this.enterpriseProxyServers);
        b.append(", ");
        b.append("enterpriseInternalProxyServers=");
        b.append(this.enterpriseInternalProxyServers);
        b.append(", ");
        b.append("enterpriseProxyServersAreAuthoritative=");
        b.append(this.enterpriseProxyServersAreAuthoritative);
        b.append(", ");
        b.append("neutralDomainResources=");
        b.append(this.neutralDomainResources);
        b.append(", ");
        b.append("indexingEncryptedStoresOrItemsBlocked=");
        b.append(this.indexingEncryptedStoresOrItemsBlocked);
        b.append(", ");
        b.append("smbAutoEncryptedFileExtensions=");
        b.append(this.smbAutoEncryptedFileExtensions);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
