package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IosDeviceType;
import odata.msgraph.client.beta.complex.IosMinimumOperatingSystem;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.ManagedAppAvailability;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for an iOS store app that you can
 * manage with an Intune app protection policy.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bundleId", 
    "appStoreUrl", 
    "applicableDeviceType", 
    "minimumSupportedOperatingSystem"})
@JsonInclude(Include.NON_NULL)
public class ManagedIOSStoreApp extends ManagedApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedIOSStoreApp";
    }

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("appStoreUrl")
    protected String appStoreUrl;

    @JsonProperty("applicableDeviceType")
    protected IosDeviceType applicableDeviceType;

    @JsonProperty("minimumSupportedOperatingSystem")
    protected IosMinimumOperatingSystem minimumSupportedOperatingSystem;

    protected ManagedIOSStoreApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedIOSStoreApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private ManagedAppAvailability appAvailability;
        private String version;
        private String bundleId;
        private String appStoreUrl;
        private IosDeviceType applicableDeviceType;
        private IosMinimumOperatingSystem minimumSupportedOperatingSystem;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder appAvailability(ManagedAppAvailability appAvailability) {
            this.appAvailability = appAvailability;
            this.changedFields = changedFields.add("appAvailability");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“The app's Bundle ID.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“The Apple AppStoreUrl.”</i>
         * 
         * @param appStoreUrl
         *            value of {@code appStoreUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            this.changedFields = changedFields.add("appStoreUrl");
            return this;
        }

        /**
         * <i>“The iOS architecture for which this app can run on.”</i>
         * 
         * @param applicableDeviceType
         *            value of {@code applicableDeviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicableDeviceType(IosDeviceType applicableDeviceType) {
            this.applicableDeviceType = applicableDeviceType;
            this.changedFields = changedFields.add("applicableDeviceType");
            return this;
        }

        /**
         * <i>“The value for the minimum supported operating system.”</i>
         * 
         * @param minimumSupportedOperatingSystem
         *            value of {@code minimumSupportedOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedOperatingSystem(IosMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        public ManagedIOSStoreApp build() {
            ManagedIOSStoreApp _x = new ManagedIOSStoreApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedIOSStoreApp";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.appAvailability = appAvailability;
            _x.version = version;
            _x.bundleId = bundleId;
            _x.appStoreUrl = appStoreUrl;
            _x.applicableDeviceType = applicableDeviceType;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The app's Bundle ID.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app's Bundle ID.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public ManagedIOSStoreApp withBundleId(String bundleId) {
        ManagedIOSStoreApp _x = _copy();
        _x.changedFields = changedFields.add("bundleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSStoreApp");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“The Apple AppStoreUrl.”</i>
     * 
     * @return property appStoreUrl
     */
    @Property(name="appStoreUrl")
    @JsonIgnore
    public Optional<String> getAppStoreUrl() {
        return Optional.ofNullable(appStoreUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appStoreUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Apple AppStoreUrl.”</i>
     * 
     * @param appStoreUrl
     *            new value of {@code appStoreUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreUrl} field changed
     */
    public ManagedIOSStoreApp withAppStoreUrl(String appStoreUrl) {
        ManagedIOSStoreApp _x = _copy();
        _x.changedFields = changedFields.add("appStoreUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSStoreApp");
        _x.appStoreUrl = appStoreUrl;
        return _x;
    }

    /**
     * <i>“The iOS architecture for which this app can run on.”</i>
     * 
     * @return property applicableDeviceType
     */
    @Property(name="applicableDeviceType")
    @JsonIgnore
    public Optional<IosDeviceType> getApplicableDeviceType() {
        return Optional.ofNullable(applicableDeviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicableDeviceType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The iOS architecture for which this app can run on.”</i>
     * 
     * @param applicableDeviceType
     *            new value of {@code applicableDeviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicableDeviceType} field changed
     */
    public ManagedIOSStoreApp withApplicableDeviceType(IosDeviceType applicableDeviceType) {
        ManagedIOSStoreApp _x = _copy();
        _x.changedFields = changedFields.add("applicableDeviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSStoreApp");
        _x.applicableDeviceType = applicableDeviceType;
        return _x;
    }

    /**
     * <i>“The value for the minimum supported operating system.”</i>
     * 
     * @return property minimumSupportedOperatingSystem
     */
    @Property(name="minimumSupportedOperatingSystem")
    @JsonIgnore
    public Optional<IosMinimumOperatingSystem> getMinimumSupportedOperatingSystem() {
        return Optional.ofNullable(minimumSupportedOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedOperatingSystem} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum supported operating system.”</i>
     * 
     * @param minimumSupportedOperatingSystem
     *            new value of {@code minimumSupportedOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedOperatingSystem} field changed
     */
    public ManagedIOSStoreApp withMinimumSupportedOperatingSystem(IosMinimumOperatingSystem minimumSupportedOperatingSystem) {
        ManagedIOSStoreApp _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedIOSStoreApp");
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedIOSStoreApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedIOSStoreApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedIOSStoreApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedIOSStoreApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedIOSStoreApp _copy() {
        ManagedIOSStoreApp _x = new ManagedIOSStoreApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.appAvailability = appAvailability;
        _x.version = version;
        _x.bundleId = bundleId;
        _x.appStoreUrl = appStoreUrl;
        _x.applicableDeviceType = applicableDeviceType;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedIOSStoreApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("appAvailability=");
        b.append(this.appAvailability);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("appStoreUrl=");
        b.append(this.appStoreUrl);
        b.append(", ");
        b.append("applicableDeviceType=");
        b.append(this.applicableDeviceType);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
