package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceExchangeAccessStateSummary;
import odata.msgraph.client.beta.complex.DeviceOperatingSystemSummary;
import odata.msgraph.client.beta.complex.ManagedDeviceModelsAndManufacturers;


/**
 * <i>“Summary data for managed devices”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enrolledDeviceCount", 
    "mdmEnrolledCount", 
    "dualEnrolledDeviceCount", 
    "deviceOperatingSystemSummary", 
    "deviceExchangeAccessStateSummary", 
    "managedDeviceModelsAndManufacturers", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceOverview extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceOverview";
    }

    @JsonProperty("enrolledDeviceCount")
    protected Integer enrolledDeviceCount;

    @JsonProperty("mdmEnrolledCount")
    protected Integer mdmEnrolledCount;

    @JsonProperty("dualEnrolledDeviceCount")
    protected Integer dualEnrolledDeviceCount;

    @JsonProperty("deviceOperatingSystemSummary")
    protected DeviceOperatingSystemSummary deviceOperatingSystemSummary;

    @JsonProperty("deviceExchangeAccessStateSummary")
    protected DeviceExchangeAccessStateSummary deviceExchangeAccessStateSummary;

    @JsonProperty("managedDeviceModelsAndManufacturers")
    protected ManagedDeviceModelsAndManufacturers managedDeviceModelsAndManufacturers;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected ManagedDeviceOverview() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDeviceOverview() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer enrolledDeviceCount;
        private Integer mdmEnrolledCount;
        private Integer dualEnrolledDeviceCount;
        private DeviceOperatingSystemSummary deviceOperatingSystemSummary;
        private DeviceExchangeAccessStateSummary deviceExchangeAccessStateSummary;
        private ManagedDeviceModelsAndManufacturers managedDeviceModelsAndManufacturers;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Total enrolled device count. Does not include PC devices managed via Intune PC
         * Agent”</i>
         * 
         * @param enrolledDeviceCount
         *            value of {@code enrolledDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrolledDeviceCount(Integer enrolledDeviceCount) {
            this.enrolledDeviceCount = enrolledDeviceCount;
            this.changedFields = changedFields.add("enrolledDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices enrolled in MDM”</i>
         * 
         * @param mdmEnrolledCount
         *            value of {@code mdmEnrolledCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmEnrolledCount(Integer mdmEnrolledCount) {
            this.mdmEnrolledCount = mdmEnrolledCount;
            this.changedFields = changedFields.add("mdmEnrolledCount");
            return this;
        }

        /**
         * <i>“The number of devices enrolled in both MDM and EAS”</i>
         * 
         * @param dualEnrolledDeviceCount
         *            value of {@code dualEnrolledDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dualEnrolledDeviceCount(Integer dualEnrolledDeviceCount) {
            this.dualEnrolledDeviceCount = dualEnrolledDeviceCount;
            this.changedFields = changedFields.add("dualEnrolledDeviceCount");
            return this;
        }

        /**
         * <i>“Device operating system summary.”</i>
         * 
         * @param deviceOperatingSystemSummary
         *            value of {@code deviceOperatingSystemSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceOperatingSystemSummary(DeviceOperatingSystemSummary deviceOperatingSystemSummary) {
            this.deviceOperatingSystemSummary = deviceOperatingSystemSummary;
            this.changedFields = changedFields.add("deviceOperatingSystemSummary");
            return this;
        }

        /**
         * <i>“Distribution of Exchange Access State in Intune”</i>
         * 
         * @param deviceExchangeAccessStateSummary
         *            value of {@code deviceExchangeAccessStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceExchangeAccessStateSummary(DeviceExchangeAccessStateSummary deviceExchangeAccessStateSummary) {
            this.deviceExchangeAccessStateSummary = deviceExchangeAccessStateSummary;
            this.changedFields = changedFields.add("deviceExchangeAccessStateSummary");
            return this;
        }

        /**
         * <i>“Models and Manufactures meatadata for managed devices in the account”</i>
         * 
         * @param managedDeviceModelsAndManufacturers
         *            value of {@code managedDeviceModelsAndManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceModelsAndManufacturers(ManagedDeviceModelsAndManufacturers managedDeviceModelsAndManufacturers) {
            this.managedDeviceModelsAndManufacturers = managedDeviceModelsAndManufacturers;
            this.changedFields = changedFields.add("managedDeviceModelsAndManufacturers");
            return this;
        }

        /**
         * <i>“Last modified date time of device overview”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public ManagedDeviceOverview build() {
            ManagedDeviceOverview _x = new ManagedDeviceOverview();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDeviceOverview";
            _x.id = id;
            _x.enrolledDeviceCount = enrolledDeviceCount;
            _x.mdmEnrolledCount = mdmEnrolledCount;
            _x.dualEnrolledDeviceCount = dualEnrolledDeviceCount;
            _x.deviceOperatingSystemSummary = deviceOperatingSystemSummary;
            _x.deviceExchangeAccessStateSummary = deviceExchangeAccessStateSummary;
            _x.managedDeviceModelsAndManufacturers = managedDeviceModelsAndManufacturers;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Total enrolled device count. Does not include PC devices managed via Intune PC
     * Agent”</i>
     * 
     * @return property enrolledDeviceCount
     */
    @Property(name="enrolledDeviceCount")
    @JsonIgnore
    public Optional<Integer> getEnrolledDeviceCount() {
        return Optional.ofNullable(enrolledDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrolledDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total enrolled device count. Does not include PC devices managed via Intune PC
     * Agent”</i>
     * 
     * @param enrolledDeviceCount
     *            new value of {@code enrolledDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrolledDeviceCount} field changed
     */
    public ManagedDeviceOverview withEnrolledDeviceCount(Integer enrolledDeviceCount) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("enrolledDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.enrolledDeviceCount = enrolledDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices enrolled in MDM”</i>
     * 
     * @return property mdmEnrolledCount
     */
    @Property(name="mdmEnrolledCount")
    @JsonIgnore
    public Optional<Integer> getMdmEnrolledCount() {
        return Optional.ofNullable(mdmEnrolledCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mdmEnrolledCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of devices enrolled in MDM”</i>
     * 
     * @param mdmEnrolledCount
     *            new value of {@code mdmEnrolledCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmEnrolledCount} field changed
     */
    public ManagedDeviceOverview withMdmEnrolledCount(Integer mdmEnrolledCount) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("mdmEnrolledCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.mdmEnrolledCount = mdmEnrolledCount;
        return _x;
    }

    /**
     * <i>“The number of devices enrolled in both MDM and EAS”</i>
     * 
     * @return property dualEnrolledDeviceCount
     */
    @Property(name="dualEnrolledDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDualEnrolledDeviceCount() {
        return Optional.ofNullable(dualEnrolledDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dualEnrolledDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The number of devices enrolled in both MDM and EAS”</i>
     * 
     * @param dualEnrolledDeviceCount
     *            new value of {@code dualEnrolledDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dualEnrolledDeviceCount} field changed
     */
    public ManagedDeviceOverview withDualEnrolledDeviceCount(Integer dualEnrolledDeviceCount) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("dualEnrolledDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.dualEnrolledDeviceCount = dualEnrolledDeviceCount;
        return _x;
    }

    /**
     * <i>“Device operating system summary.”</i>
     * 
     * @return property deviceOperatingSystemSummary
     */
    @Property(name="deviceOperatingSystemSummary")
    @JsonIgnore
    public Optional<DeviceOperatingSystemSummary> getDeviceOperatingSystemSummary() {
        return Optional.ofNullable(deviceOperatingSystemSummary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceOperatingSystemSummary} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device operating system summary.”</i>
     * 
     * @param deviceOperatingSystemSummary
     *            new value of {@code deviceOperatingSystemSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceOperatingSystemSummary} field changed
     */
    public ManagedDeviceOverview withDeviceOperatingSystemSummary(DeviceOperatingSystemSummary deviceOperatingSystemSummary) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("deviceOperatingSystemSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.deviceOperatingSystemSummary = deviceOperatingSystemSummary;
        return _x;
    }

    /**
     * <i>“Distribution of Exchange Access State in Intune”</i>
     * 
     * @return property deviceExchangeAccessStateSummary
     */
    @Property(name="deviceExchangeAccessStateSummary")
    @JsonIgnore
    public Optional<DeviceExchangeAccessStateSummary> getDeviceExchangeAccessStateSummary() {
        return Optional.ofNullable(deviceExchangeAccessStateSummary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceExchangeAccessStateSummary} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Distribution of Exchange Access State in Intune”</i>
     * 
     * @param deviceExchangeAccessStateSummary
     *            new value of {@code deviceExchangeAccessStateSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceExchangeAccessStateSummary} field changed
     */
    public ManagedDeviceOverview withDeviceExchangeAccessStateSummary(DeviceExchangeAccessStateSummary deviceExchangeAccessStateSummary) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("deviceExchangeAccessStateSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.deviceExchangeAccessStateSummary = deviceExchangeAccessStateSummary;
        return _x;
    }

    /**
     * <i>“Models and Manufactures meatadata for managed devices in the account”</i>
     * 
     * @return property managedDeviceModelsAndManufacturers
     */
    @Property(name="managedDeviceModelsAndManufacturers")
    @JsonIgnore
    public Optional<ManagedDeviceModelsAndManufacturers> getManagedDeviceModelsAndManufacturers() {
        return Optional.ofNullable(managedDeviceModelsAndManufacturers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceModelsAndManufacturers} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Models and Manufactures meatadata for managed devices in the account”</i>
     * 
     * @param managedDeviceModelsAndManufacturers
     *            new value of {@code managedDeviceModelsAndManufacturers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceModelsAndManufacturers} field changed
     */
    public ManagedDeviceOverview withManagedDeviceModelsAndManufacturers(ManagedDeviceModelsAndManufacturers managedDeviceModelsAndManufacturers) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceModelsAndManufacturers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.managedDeviceModelsAndManufacturers = managedDeviceModelsAndManufacturers;
        return _x;
    }

    /**
     * <i>“Last modified date time of device overview”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified date time of device overview”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ManagedDeviceOverview withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceOverview");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceOverview patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceOverview put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceOverview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceOverview _copy() {
        ManagedDeviceOverview _x = new ManagedDeviceOverview();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.enrolledDeviceCount = enrolledDeviceCount;
        _x.mdmEnrolledCount = mdmEnrolledCount;
        _x.dualEnrolledDeviceCount = dualEnrolledDeviceCount;
        _x.deviceOperatingSystemSummary = deviceOperatingSystemSummary;
        _x.deviceExchangeAccessStateSummary = deviceExchangeAccessStateSummary;
        _x.managedDeviceModelsAndManufacturers = managedDeviceModelsAndManufacturers;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceOverview[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("enrolledDeviceCount=");
        b.append(this.enrolledDeviceCount);
        b.append(", ");
        b.append("mdmEnrolledCount=");
        b.append(this.mdmEnrolledCount);
        b.append(", ");
        b.append("dualEnrolledDeviceCount=");
        b.append(this.dualEnrolledDeviceCount);
        b.append(", ");
        b.append("deviceOperatingSystemSummary=");
        b.append(this.deviceOperatingSystemSummary);
        b.append(", ");
        b.append("deviceExchangeAccessStateSummary=");
        b.append(this.deviceExchangeAccessStateSummary);
        b.append(", ");
        b.append("managedDeviceModelsAndManufacturers=");
        b.append(this.managedDeviceModelsAndManufacturers);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
