package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationDeviceSummaryRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationUserSummaryRequest;


/**
 * <i>“An abstract class for Mobile app configuration for enrolled devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "targetedMobileApps", 
    "roleScopeTagIds", 
    "createdDateTime", 
    "description", 
    "lastModifiedDateTime", 
    "displayName", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceMobileAppConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceMobileAppConfiguration";
    }

    @JsonProperty("targetedMobileApps")
    protected List<String> targetedMobileApps;

    @JsonProperty("targetedMobileApps@nextLink")
    protected String targetedMobileAppsNextLink;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("version")
    protected Integer version;

    protected ManagedDeviceMobileAppConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“the associated app.”</i>
     * 
     * @return property targetedMobileApps
     */
    @Property(name="targetedMobileApps")
    @JsonIgnore
    public CollectionPage<String> getTargetedMobileApps() {
        return new CollectionPage<String>(contextPath, String.class, targetedMobileApps, Optional.ofNullable(targetedMobileAppsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“the associated app.”</i>
     * 
     * @return property targetedMobileApps
     */
    @Property(name="targetedMobileApps")
    @JsonIgnore
    public CollectionPage<String> getTargetedMobileApps(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, targetedMobileApps, Optional.ofNullable(targetedMobileAppsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List of Scope Tags for this App configuration entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this App configuration entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ManagedDeviceMobileAppConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ManagedDeviceMobileAppConfiguration withDescription(String description) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ManagedDeviceMobileAppConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ManagedDeviceMobileAppConfiguration withDisplayName(String displayName) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public ManagedDeviceMobileAppConfiguration withVersion(Integer version) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“The list of group assignemenets for app configration.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest getAssignments() {
        return new ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    /**
     * <i>“List of ManagedDeviceMobileAppConfigurationDeviceStatus.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest getDeviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    /**
     * <i>“List of ManagedDeviceMobileAppConfigurationUserStatus.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest getUserStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"));
    }

    /**
     * <i>“App configuration device status summary.”</i>
     * 
     * @return navigational property deviceStatusSummary
     */
    @NavigationProperty(name="deviceStatusSummary")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationDeviceSummaryRequest getDeviceStatusSummary() {
        return new ManagedDeviceMobileAppConfigurationDeviceSummaryRequest(contextPath.addSegment("deviceStatusSummary"));
    }

    /**
     * <i>“App configuration user status summary.”</i>
     * 
     * @return navigational property userStatusSummary
     */
    @NavigationProperty(name="userStatusSummary")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationUserSummaryRequest getUserStatusSummary() {
        return new ManagedDeviceMobileAppConfigurationUserSummaryRequest(contextPath.addSegment("userStatusSummary"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceMobileAppConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceMobileAppConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceMobileAppConfiguration _copy() {
        ManagedDeviceMobileAppConfiguration _x = new ManagedDeviceMobileAppConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.targetedMobileApps = targetedMobileApps;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.displayName = displayName;
        _x.version = version;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<ManagedDeviceMobileAppConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.managedDeviceMobileAppConfigurationAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceMobileAppConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetedMobileApps=");
        b.append(this.targetedMobileApps);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
