package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EncryptionReportPolicyDetails;
import odata.msgraph.client.beta.enums.AdvancedBitLockerState;
import odata.msgraph.client.beta.enums.ComplianceStatus;
import odata.msgraph.client.beta.enums.DeviceTypes;
import odata.msgraph.client.beta.enums.EncryptionReadinessState;
import odata.msgraph.client.beta.enums.EncryptionState;
import odata.msgraph.client.beta.enums.FileVaultState;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Encryption report per device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userPrincipalName", 
    "deviceType", 
    "osVersion", 
    "tpmSpecificationVersion", 
    "deviceName", 
    "encryptionReadinessState", 
    "encryptionState", 
    "encryptionPolicySettingState", 
    "advancedBitLockerStates", 
    "fileVaultStates", 
    "policyDetails"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceEncryptionState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceEncryptionState";
    }

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("deviceType")
    protected DeviceTypes deviceType;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("tpmSpecificationVersion")
    protected String tpmSpecificationVersion;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("encryptionReadinessState")
    protected EncryptionReadinessState encryptionReadinessState;

    @JsonProperty("encryptionState")
    protected EncryptionState encryptionState;

    @JsonProperty("encryptionPolicySettingState")
    protected ComplianceStatus encryptionPolicySettingState;

    @JsonProperty("advancedBitLockerStates")
    protected AdvancedBitLockerState advancedBitLockerStates;

    @JsonProperty("fileVaultStates")
    protected FileVaultState fileVaultStates;

    @JsonProperty("policyDetails")
    protected List<EncryptionReportPolicyDetails> policyDetails;

    @JsonProperty("policyDetails@nextLink")
    protected String policyDetailsNextLink;

    protected ManagedDeviceEncryptionState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDeviceEncryptionState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userPrincipalName;
        private DeviceTypes deviceType;
        private String osVersion;
        private String tpmSpecificationVersion;
        private String deviceName;
        private EncryptionReadinessState encryptionReadinessState;
        private EncryptionState encryptionState;
        private ComplianceStatus encryptionPolicySettingState;
        private AdvancedBitLockerState advancedBitLockerStates;
        private FileVaultState fileVaultStates;
        private List<EncryptionReportPolicyDetails> policyDetails;
        private String policyDetailsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“User name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Platform of the device.”</i>
         * 
         * @param deviceType
         *            value of {@code deviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceType(DeviceTypes deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        /**
         * <i>“Operating system version of the device”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“Device TPM Version”</i>
         * 
         * @param tpmSpecificationVersion
         *            value of {@code tpmSpecificationVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmSpecificationVersion(String tpmSpecificationVersion) {
            this.tpmSpecificationVersion = tpmSpecificationVersion;
            this.changedFields = changedFields.add("tpmSpecificationVersion");
            return this;
        }

        /**
         * <i>“Device name”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Encryption readiness state”</i>
         * 
         * @param encryptionReadinessState
         *            value of {@code encryptionReadinessState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionReadinessState(EncryptionReadinessState encryptionReadinessState) {
            this.encryptionReadinessState = encryptionReadinessState;
            this.changedFields = changedFields.add("encryptionReadinessState");
            return this;
        }

        /**
         * <i>“Device encryption state”</i>
         * 
         * @param encryptionState
         *            value of {@code encryptionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionState(EncryptionState encryptionState) {
            this.encryptionState = encryptionState;
            this.changedFields = changedFields.add("encryptionState");
            return this;
        }

        /**
         * <i>“Encryption policy setting state”</i>
         * 
         * @param encryptionPolicySettingState
         *            value of {@code encryptionPolicySettingState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionPolicySettingState(ComplianceStatus encryptionPolicySettingState) {
            this.encryptionPolicySettingState = encryptionPolicySettingState;
            this.changedFields = changedFields.add("encryptionPolicySettingState");
            return this;
        }

        /**
         * <i>“Advanced BitLocker State”</i>
         * 
         * @param advancedBitLockerStates
         *            value of {@code advancedBitLockerStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedBitLockerStates(AdvancedBitLockerState advancedBitLockerStates) {
            this.advancedBitLockerStates = advancedBitLockerStates;
            this.changedFields = changedFields.add("advancedBitLockerStates");
            return this;
        }

        /**
         * <i>“FileVault State”</i>
         * 
         * @param fileVaultStates
         *            value of {@code fileVaultStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileVaultStates(FileVaultState fileVaultStates) {
            this.fileVaultStates = fileVaultStates;
            this.changedFields = changedFields.add("fileVaultStates");
            return this;
        }

        /**
         * <i>“Policy Details”</i>
         * 
         * @param policyDetails
         *            value of {@code policyDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyDetails(List<EncryptionReportPolicyDetails> policyDetails) {
            this.policyDetails = policyDetails;
            this.changedFields = changedFields.add("policyDetails");
            return this;
        }

        /**
         * <i>“Policy Details”</i>
         * 
         * @param policyDetails
         *            value of {@code policyDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyDetails(EncryptionReportPolicyDetails... policyDetails) {
            return policyDetails(Arrays.asList(policyDetails));
        }

        /**
         * <i>“Policy Details”</i>
         * 
         * @param policyDetailsNextLink
         *            value of {@code policyDetails@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyDetailsNextLink(String policyDetailsNextLink) {
            this.policyDetailsNextLink = policyDetailsNextLink;
            this.changedFields = changedFields.add("policyDetails");
            return this;
        }

        public ManagedDeviceEncryptionState build() {
            ManagedDeviceEncryptionState _x = new ManagedDeviceEncryptionState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDeviceEncryptionState";
            _x.id = id;
            _x.userPrincipalName = userPrincipalName;
            _x.deviceType = deviceType;
            _x.osVersion = osVersion;
            _x.tpmSpecificationVersion = tpmSpecificationVersion;
            _x.deviceName = deviceName;
            _x.encryptionReadinessState = encryptionReadinessState;
            _x.encryptionState = encryptionState;
            _x.encryptionPolicySettingState = encryptionPolicySettingState;
            _x.advancedBitLockerStates = advancedBitLockerStates;
            _x.fileVaultStates = fileVaultStates;
            _x.policyDetails = policyDetails;
            _x.policyDetailsNextLink = policyDetailsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“User name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public ManagedDeviceEncryptionState withUserPrincipalName(String userPrincipalName) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Platform of the device.”</i>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<DeviceTypes> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platform of the device.”</i>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public ManagedDeviceEncryptionState withDeviceType(DeviceTypes deviceType) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“Operating system version of the device”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operating system version of the device”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public ManagedDeviceEncryptionState withOsVersion(String osVersion) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“Device TPM Version”</i>
     * 
     * @return property tpmSpecificationVersion
     */
    @Property(name="tpmSpecificationVersion")
    @JsonIgnore
    public Optional<String> getTpmSpecificationVersion() {
        return Optional.ofNullable(tpmSpecificationVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tpmSpecificationVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device TPM Version”</i>
     * 
     * @param tpmSpecificationVersion
     *            new value of {@code tpmSpecificationVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmSpecificationVersion} field changed
     */
    public ManagedDeviceEncryptionState withTpmSpecificationVersion(String tpmSpecificationVersion) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("tpmSpecificationVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.tpmSpecificationVersion = tpmSpecificationVersion;
        return _x;
    }

    /**
     * <i>“Device name”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public ManagedDeviceEncryptionState withDeviceName(String deviceName) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Encryption readiness state”</i>
     * 
     * @return property encryptionReadinessState
     */
    @Property(name="encryptionReadinessState")
    @JsonIgnore
    public Optional<EncryptionReadinessState> getEncryptionReadinessState() {
        return Optional.ofNullable(encryptionReadinessState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * encryptionReadinessState} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Encryption readiness state”</i>
     * 
     * @param encryptionReadinessState
     *            new value of {@code encryptionReadinessState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionReadinessState} field changed
     */
    public ManagedDeviceEncryptionState withEncryptionReadinessState(EncryptionReadinessState encryptionReadinessState) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("encryptionReadinessState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.encryptionReadinessState = encryptionReadinessState;
        return _x;
    }

    /**
     * <i>“Device encryption state”</i>
     * 
     * @return property encryptionState
     */
    @Property(name="encryptionState")
    @JsonIgnore
    public Optional<EncryptionState> getEncryptionState() {
        return Optional.ofNullable(encryptionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device encryption state”</i>
     * 
     * @param encryptionState
     *            new value of {@code encryptionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionState} field changed
     */
    public ManagedDeviceEncryptionState withEncryptionState(EncryptionState encryptionState) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("encryptionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.encryptionState = encryptionState;
        return _x;
    }

    /**
     * <i>“Encryption policy setting state”</i>
     * 
     * @return property encryptionPolicySettingState
     */
    @Property(name="encryptionPolicySettingState")
    @JsonIgnore
    public Optional<ComplianceStatus> getEncryptionPolicySettingState() {
        return Optional.ofNullable(encryptionPolicySettingState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * encryptionPolicySettingState} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Encryption policy setting state”</i>
     * 
     * @param encryptionPolicySettingState
     *            new value of {@code encryptionPolicySettingState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionPolicySettingState} field changed
     */
    public ManagedDeviceEncryptionState withEncryptionPolicySettingState(ComplianceStatus encryptionPolicySettingState) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("encryptionPolicySettingState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.encryptionPolicySettingState = encryptionPolicySettingState;
        return _x;
    }

    /**
     * <i>“Advanced BitLocker State”</i>
     * 
     * @return property advancedBitLockerStates
     */
    @Property(name="advancedBitLockerStates")
    @JsonIgnore
    public Optional<AdvancedBitLockerState> getAdvancedBitLockerStates() {
        return Optional.ofNullable(advancedBitLockerStates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedBitLockerStates} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Advanced BitLocker State”</i>
     * 
     * @param advancedBitLockerStates
     *            new value of {@code advancedBitLockerStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedBitLockerStates} field changed
     */
    public ManagedDeviceEncryptionState withAdvancedBitLockerStates(AdvancedBitLockerState advancedBitLockerStates) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("advancedBitLockerStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.advancedBitLockerStates = advancedBitLockerStates;
        return _x;
    }

    /**
     * <i>“FileVault State”</i>
     * 
     * @return property fileVaultStates
     */
    @Property(name="fileVaultStates")
    @JsonIgnore
    public Optional<FileVaultState> getFileVaultStates() {
        return Optional.ofNullable(fileVaultStates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileVaultStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“FileVault State”</i>
     * 
     * @param fileVaultStates
     *            new value of {@code fileVaultStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileVaultStates} field changed
     */
    public ManagedDeviceEncryptionState withFileVaultStates(FileVaultState fileVaultStates) {
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = changedFields.add("fileVaultStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceEncryptionState");
        _x.fileVaultStates = fileVaultStates;
        return _x;
    }

    /**
     * <i>“Policy Details”</i>
     * 
     * @return property policyDetails
     */
    @Property(name="policyDetails")
    @JsonIgnore
    public CollectionPage<EncryptionReportPolicyDetails> getPolicyDetails() {
        return new CollectionPage<EncryptionReportPolicyDetails>(contextPath, EncryptionReportPolicyDetails.class, policyDetails, Optional.ofNullable(policyDetailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Policy Details”</i>
     * 
     * @return property policyDetails
     */
    @Property(name="policyDetails")
    @JsonIgnore
    public CollectionPage<EncryptionReportPolicyDetails> getPolicyDetails(HttpRequestOptions options) {
        return new CollectionPage<EncryptionReportPolicyDetails>(contextPath, EncryptionReportPolicyDetails.class, policyDetails, Optional.ofNullable(policyDetailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceEncryptionState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceEncryptionState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceEncryptionState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceEncryptionState _copy() {
        ManagedDeviceEncryptionState _x = new ManagedDeviceEncryptionState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userPrincipalName = userPrincipalName;
        _x.deviceType = deviceType;
        _x.osVersion = osVersion;
        _x.tpmSpecificationVersion = tpmSpecificationVersion;
        _x.deviceName = deviceName;
        _x.encryptionReadinessState = encryptionReadinessState;
        _x.encryptionState = encryptionState;
        _x.encryptionPolicySettingState = encryptionPolicySettingState;
        _x.advancedBitLockerStates = advancedBitLockerStates;
        _x.fileVaultStates = fileVaultStates;
        _x.policyDetails = policyDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceEncryptionState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("tpmSpecificationVersion=");
        b.append(this.tpmSpecificationVersion);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("encryptionReadinessState=");
        b.append(this.encryptionReadinessState);
        b.append(", ");
        b.append("encryptionState=");
        b.append(this.encryptionState);
        b.append(", ");
        b.append("encryptionPolicySettingState=");
        b.append(this.encryptionPolicySettingState);
        b.append(", ");
        b.append("advancedBitLockerStates=");
        b.append(this.advancedBitLockerStates);
        b.append(", ");
        b.append("fileVaultStates=");
        b.append(this.fileVaultStates);
        b.append(", ");
        b.append("policyDetails=");
        b.append(this.policyDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
