package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CertificateIssuanceStates;
import odata.msgraph.client.beta.enums.CertificateRevocationStatus;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.DevicePlatformType;
import odata.msgraph.client.beta.enums.KeyStorageProviderOption;
import odata.msgraph.client.beta.enums.KeyUsages;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;
import odata.msgraph.client.beta.enums.SubjectNameFormat;

@JsonPropertyOrder({
    "@odata.type", 
    "devicePlatform", 
    "certificateKeyUsage", 
    "certificateValidityPeriodUnits", 
    "certificateIssuanceState", 
    "certificateKeyStorageProvider", 
    "certificateSubjectNameFormat", 
    "certificateSubjectAlternativeNameFormat", 
    "certificateRevokeStatus", 
    "certificateProfileDisplayName", 
    "deviceDisplayName", 
    "userDisplayName", 
    "certificateExpirationDateTime", 
    "certificateLastIssuanceStateChangedDateTime", 
    "lastCertificateStateChangeDateTime", 
    "certificateIssuer", 
    "certificateThumbprint", 
    "certificateSerialNumber", 
    "certificateKeyLength", 
    "certificateEnhancedKeyUsage", 
    "certificateValidityPeriod", 
    "certificateSubjectNameFormatString", 
    "certificateSubjectAlternativeNameFormatString", 
    "certificateIssuanceDateTime", 
    "certificateErrorCode"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceCertificateState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceCertificateState";
    }

    @JsonProperty("devicePlatform")
    protected DevicePlatformType devicePlatform;

    @JsonProperty("certificateKeyUsage")
    protected KeyUsages certificateKeyUsage;

    @JsonProperty("certificateValidityPeriodUnits")
    protected CertificateValidityPeriodScale certificateValidityPeriodUnits;

    @JsonProperty("certificateIssuanceState")
    protected CertificateIssuanceStates certificateIssuanceState;

    @JsonProperty("certificateKeyStorageProvider")
    protected KeyStorageProviderOption certificateKeyStorageProvider;

    @JsonProperty("certificateSubjectNameFormat")
    protected SubjectNameFormat certificateSubjectNameFormat;

    @JsonProperty("certificateSubjectAlternativeNameFormat")
    protected SubjectAlternativeNameType certificateSubjectAlternativeNameFormat;

    @JsonProperty("certificateRevokeStatus")
    protected CertificateRevocationStatus certificateRevokeStatus;

    @JsonProperty("certificateProfileDisplayName")
    protected String certificateProfileDisplayName;

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("certificateExpirationDateTime")
    protected OffsetDateTime certificateExpirationDateTime;

    @JsonProperty("certificateLastIssuanceStateChangedDateTime")
    protected OffsetDateTime certificateLastIssuanceStateChangedDateTime;

    @JsonProperty("lastCertificateStateChangeDateTime")
    protected OffsetDateTime lastCertificateStateChangeDateTime;

    @JsonProperty("certificateIssuer")
    protected String certificateIssuer;

    @JsonProperty("certificateThumbprint")
    protected String certificateThumbprint;

    @JsonProperty("certificateSerialNumber")
    protected String certificateSerialNumber;

    @JsonProperty("certificateKeyLength")
    protected Integer certificateKeyLength;

    @JsonProperty("certificateEnhancedKeyUsage")
    protected String certificateEnhancedKeyUsage;

    @JsonProperty("certificateValidityPeriod")
    protected Integer certificateValidityPeriod;

    @JsonProperty("certificateSubjectNameFormatString")
    protected String certificateSubjectNameFormatString;

    @JsonProperty("certificateSubjectAlternativeNameFormatString")
    protected String certificateSubjectAlternativeNameFormatString;

    @JsonProperty("certificateIssuanceDateTime")
    protected OffsetDateTime certificateIssuanceDateTime;

    @JsonProperty("certificateErrorCode")
    protected Integer certificateErrorCode;

    protected ManagedDeviceCertificateState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDeviceCertificateState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DevicePlatformType devicePlatform;
        private KeyUsages certificateKeyUsage;
        private CertificateValidityPeriodScale certificateValidityPeriodUnits;
        private CertificateIssuanceStates certificateIssuanceState;
        private KeyStorageProviderOption certificateKeyStorageProvider;
        private SubjectNameFormat certificateSubjectNameFormat;
        private SubjectAlternativeNameType certificateSubjectAlternativeNameFormat;
        private CertificateRevocationStatus certificateRevokeStatus;
        private String certificateProfileDisplayName;
        private String deviceDisplayName;
        private String userDisplayName;
        private OffsetDateTime certificateExpirationDateTime;
        private OffsetDateTime certificateLastIssuanceStateChangedDateTime;
        private OffsetDateTime lastCertificateStateChangeDateTime;
        private String certificateIssuer;
        private String certificateThumbprint;
        private String certificateSerialNumber;
        private Integer certificateKeyLength;
        private String certificateEnhancedKeyUsage;
        private Integer certificateValidityPeriod;
        private String certificateSubjectNameFormatString;
        private String certificateSubjectAlternativeNameFormatString;
        private OffsetDateTime certificateIssuanceDateTime;
        private Integer certificateErrorCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device platform”</i>
         * 
         * @param devicePlatform
         *            value of {@code devicePlatform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicePlatform(DevicePlatformType devicePlatform) {
            this.devicePlatform = devicePlatform;
            this.changedFields = changedFields.add("devicePlatform");
            return this;
        }

        /**
         * <i>“Key usage”</i>
         * 
         * @param certificateKeyUsage
         *            value of {@code certificateKeyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateKeyUsage(KeyUsages certificateKeyUsage) {
            this.certificateKeyUsage = certificateKeyUsage;
            this.changedFields = changedFields.add("certificateKeyUsage");
            return this;
        }

        /**
         * <i>“Validity period units”</i>
         * 
         * @param certificateValidityPeriodUnits
         *            value of {@code certificateValidityPeriodUnits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateValidityPeriodUnits(CertificateValidityPeriodScale certificateValidityPeriodUnits) {
            this.certificateValidityPeriodUnits = certificateValidityPeriodUnits;
            this.changedFields = changedFields.add("certificateValidityPeriodUnits");
            return this;
        }

        /**
         * <i>“Issuance State”</i>
         * 
         * @param certificateIssuanceState
         *            value of {@code certificateIssuanceState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateIssuanceState(CertificateIssuanceStates certificateIssuanceState) {
            this.certificateIssuanceState = certificateIssuanceState;
            this.changedFields = changedFields.add("certificateIssuanceState");
            return this;
        }

        /**
         * <i>“Key Storage Provider”</i>
         * 
         * @param certificateKeyStorageProvider
         *            value of {@code certificateKeyStorageProvider} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateKeyStorageProvider(KeyStorageProviderOption certificateKeyStorageProvider) {
            this.certificateKeyStorageProvider = certificateKeyStorageProvider;
            this.changedFields = changedFields.add("certificateKeyStorageProvider");
            return this;
        }

        /**
         * <i>“Subject name format”</i>
         * 
         * @param certificateSubjectNameFormat
         *            value of {@code certificateSubjectNameFormat} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSubjectNameFormat(SubjectNameFormat certificateSubjectNameFormat) {
            this.certificateSubjectNameFormat = certificateSubjectNameFormat;
            this.changedFields = changedFields.add("certificateSubjectNameFormat");
            return this;
        }

        /**
         * <i>“Subject alternative name format”</i>
         * 
         * @param certificateSubjectAlternativeNameFormat
         *            value of {@code certificateSubjectAlternativeNameFormat} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSubjectAlternativeNameFormat(SubjectAlternativeNameType certificateSubjectAlternativeNameFormat) {
            this.certificateSubjectAlternativeNameFormat = certificateSubjectAlternativeNameFormat;
            this.changedFields = changedFields.add("certificateSubjectAlternativeNameFormat");
            return this;
        }

        /**
         * <i>“Revoke status”</i>
         * 
         * @param certificateRevokeStatus
         *            value of {@code certificateRevokeStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateRevokeStatus(CertificateRevocationStatus certificateRevokeStatus) {
            this.certificateRevokeStatus = certificateRevokeStatus;
            this.changedFields = changedFields.add("certificateRevokeStatus");
            return this;
        }

        /**
         * <i>“Certificate profile display name”</i>
         * 
         * @param certificateProfileDisplayName
         *            value of {@code certificateProfileDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateProfileDisplayName(String certificateProfileDisplayName) {
            this.certificateProfileDisplayName = certificateProfileDisplayName;
            this.changedFields = changedFields.add("certificateProfileDisplayName");
            return this;
        }

        /**
         * <i>“Device display name”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“User display name”</i>
         * 
         * @param userDisplayName
         *            value of {@code userDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        /**
         * <i>“Certificate expiry date”</i>
         * 
         * @param certificateExpirationDateTime
         *            value of {@code certificateExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateExpirationDateTime(OffsetDateTime certificateExpirationDateTime) {
            this.certificateExpirationDateTime = certificateExpirationDateTime;
            this.changedFields = changedFields.add("certificateExpirationDateTime");
            return this;
        }

        /**
         * <i>“Last certificate issuance state change”</i>
         * 
         * @param certificateLastIssuanceStateChangedDateTime
         *            value of {@code certificateLastIssuanceStateChangedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateLastIssuanceStateChangedDateTime(OffsetDateTime certificateLastIssuanceStateChangedDateTime) {
            this.certificateLastIssuanceStateChangedDateTime = certificateLastIssuanceStateChangedDateTime;
            this.changedFields = changedFields.add("certificateLastIssuanceStateChangedDateTime");
            return this;
        }

        /**
         * <i>“Last certificate issuance state change”</i>
         * 
         * @param lastCertificateStateChangeDateTime
         *            value of {@code lastCertificateStateChangeDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCertificateStateChangeDateTime(OffsetDateTime lastCertificateStateChangeDateTime) {
            this.lastCertificateStateChangeDateTime = lastCertificateStateChangeDateTime;
            this.changedFields = changedFields.add("lastCertificateStateChangeDateTime");
            return this;
        }

        /**
         * <i>“Issuer”</i>
         * 
         * @param certificateIssuer
         *            value of {@code certificateIssuer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateIssuer(String certificateIssuer) {
            this.certificateIssuer = certificateIssuer;
            this.changedFields = changedFields.add("certificateIssuer");
            return this;
        }

        /**
         * <i>“Thumbprint”</i>
         * 
         * @param certificateThumbprint
         *            value of {@code certificateThumbprint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateThumbprint(String certificateThumbprint) {
            this.certificateThumbprint = certificateThumbprint;
            this.changedFields = changedFields.add("certificateThumbprint");
            return this;
        }

        /**
         * <i>“Serial number”</i>
         * 
         * @param certificateSerialNumber
         *            value of {@code certificateSerialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSerialNumber(String certificateSerialNumber) {
            this.certificateSerialNumber = certificateSerialNumber;
            this.changedFields = changedFields.add("certificateSerialNumber");
            return this;
        }

        /**
         * <i>“Key length”</i>
         * 
         * @param certificateKeyLength
         *            value of {@code certificateKeyLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateKeyLength(Integer certificateKeyLength) {
            this.certificateKeyLength = certificateKeyLength;
            this.changedFields = changedFields.add("certificateKeyLength");
            return this;
        }

        /**
         * <i>“Extended key usage”</i>
         * 
         * @param certificateEnhancedKeyUsage
         *            value of {@code certificateEnhancedKeyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateEnhancedKeyUsage(String certificateEnhancedKeyUsage) {
            this.certificateEnhancedKeyUsage = certificateEnhancedKeyUsage;
            this.changedFields = changedFields.add("certificateEnhancedKeyUsage");
            return this;
        }

        /**
         * <i>“Validity period”</i>
         * 
         * @param certificateValidityPeriod
         *            value of {@code certificateValidityPeriod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateValidityPeriod(Integer certificateValidityPeriod) {
            this.certificateValidityPeriod = certificateValidityPeriod;
            this.changedFields = changedFields.add("certificateValidityPeriod");
            return this;
        }

        /**
         * <i>“Subject name format string for custom subject name formats”</i>
         * 
         * @param certificateSubjectNameFormatString
         *            value of {@code certificateSubjectNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSubjectNameFormatString(String certificateSubjectNameFormatString) {
            this.certificateSubjectNameFormatString = certificateSubjectNameFormatString;
            this.changedFields = changedFields.add("certificateSubjectNameFormatString");
            return this;
        }

        /**
         * <i>“Subject alternative name format string for custom formats”</i>
         * 
         * @param certificateSubjectAlternativeNameFormatString
         *            value of {@code certificateSubjectAlternativeNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSubjectAlternativeNameFormatString(String certificateSubjectAlternativeNameFormatString) {
            this.certificateSubjectAlternativeNameFormatString = certificateSubjectAlternativeNameFormatString;
            this.changedFields = changedFields.add("certificateSubjectAlternativeNameFormatString");
            return this;
        }

        /**
         * <i>“Issuance date”</i>
         * 
         * @param certificateIssuanceDateTime
         *            value of {@code certificateIssuanceDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateIssuanceDateTime(OffsetDateTime certificateIssuanceDateTime) {
            this.certificateIssuanceDateTime = certificateIssuanceDateTime;
            this.changedFields = changedFields.add("certificateIssuanceDateTime");
            return this;
        }

        /**
         * <i>“Error code”</i>
         * 
         * @param certificateErrorCode
         *            value of {@code certificateErrorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateErrorCode(Integer certificateErrorCode) {
            this.certificateErrorCode = certificateErrorCode;
            this.changedFields = changedFields.add("certificateErrorCode");
            return this;
        }

        public ManagedDeviceCertificateState build() {
            ManagedDeviceCertificateState _x = new ManagedDeviceCertificateState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDeviceCertificateState";
            _x.id = id;
            _x.devicePlatform = devicePlatform;
            _x.certificateKeyUsage = certificateKeyUsage;
            _x.certificateValidityPeriodUnits = certificateValidityPeriodUnits;
            _x.certificateIssuanceState = certificateIssuanceState;
            _x.certificateKeyStorageProvider = certificateKeyStorageProvider;
            _x.certificateSubjectNameFormat = certificateSubjectNameFormat;
            _x.certificateSubjectAlternativeNameFormat = certificateSubjectAlternativeNameFormat;
            _x.certificateRevokeStatus = certificateRevokeStatus;
            _x.certificateProfileDisplayName = certificateProfileDisplayName;
            _x.deviceDisplayName = deviceDisplayName;
            _x.userDisplayName = userDisplayName;
            _x.certificateExpirationDateTime = certificateExpirationDateTime;
            _x.certificateLastIssuanceStateChangedDateTime = certificateLastIssuanceStateChangedDateTime;
            _x.lastCertificateStateChangeDateTime = lastCertificateStateChangeDateTime;
            _x.certificateIssuer = certificateIssuer;
            _x.certificateThumbprint = certificateThumbprint;
            _x.certificateSerialNumber = certificateSerialNumber;
            _x.certificateKeyLength = certificateKeyLength;
            _x.certificateEnhancedKeyUsage = certificateEnhancedKeyUsage;
            _x.certificateValidityPeriod = certificateValidityPeriod;
            _x.certificateSubjectNameFormatString = certificateSubjectNameFormatString;
            _x.certificateSubjectAlternativeNameFormatString = certificateSubjectAlternativeNameFormatString;
            _x.certificateIssuanceDateTime = certificateIssuanceDateTime;
            _x.certificateErrorCode = certificateErrorCode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Device platform”</i>
     * 
     * @return property devicePlatform
     */
    @Property(name="devicePlatform")
    @JsonIgnore
    public Optional<DevicePlatformType> getDevicePlatform() {
        return Optional.ofNullable(devicePlatform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code devicePlatform}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device platform”</i>
     * 
     * @param devicePlatform
     *            new value of {@code devicePlatform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code devicePlatform} field changed
     */
    public ManagedDeviceCertificateState withDevicePlatform(DevicePlatformType devicePlatform) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("devicePlatform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.devicePlatform = devicePlatform;
        return _x;
    }

    /**
     * <i>“Key usage”</i>
     * 
     * @return property certificateKeyUsage
     */
    @Property(name="certificateKeyUsage")
    @JsonIgnore
    public Optional<KeyUsages> getCertificateKeyUsage() {
        return Optional.ofNullable(certificateKeyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateKeyUsage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Key usage”</i>
     * 
     * @param certificateKeyUsage
     *            new value of {@code certificateKeyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateKeyUsage} field changed
     */
    public ManagedDeviceCertificateState withCertificateKeyUsage(KeyUsages certificateKeyUsage) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateKeyUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateKeyUsage = certificateKeyUsage;
        return _x;
    }

    /**
     * <i>“Validity period units”</i>
     * 
     * @return property certificateValidityPeriodUnits
     */
    @Property(name="certificateValidityPeriodUnits")
    @JsonIgnore
    public Optional<CertificateValidityPeriodScale> getCertificateValidityPeriodUnits() {
        return Optional.ofNullable(certificateValidityPeriodUnits);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodUnits} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Validity period units”</i>
     * 
     * @param certificateValidityPeriodUnits
     *            new value of {@code certificateValidityPeriodUnits} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodUnits} field changed
     */
    public ManagedDeviceCertificateState withCertificateValidityPeriodUnits(CertificateValidityPeriodScale certificateValidityPeriodUnits) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodUnits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateValidityPeriodUnits = certificateValidityPeriodUnits;
        return _x;
    }

    /**
     * <i>“Issuance State”</i>
     * 
     * @return property certificateIssuanceState
     */
    @Property(name="certificateIssuanceState")
    @JsonIgnore
    public Optional<CertificateIssuanceStates> getCertificateIssuanceState() {
        return Optional.ofNullable(certificateIssuanceState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateIssuanceState} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Issuance State”</i>
     * 
     * @param certificateIssuanceState
     *            new value of {@code certificateIssuanceState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateIssuanceState} field changed
     */
    public ManagedDeviceCertificateState withCertificateIssuanceState(CertificateIssuanceStates certificateIssuanceState) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateIssuanceState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateIssuanceState = certificateIssuanceState;
        return _x;
    }

    /**
     * <i>“Key Storage Provider”</i>
     * 
     * @return property certificateKeyStorageProvider
     */
    @Property(name="certificateKeyStorageProvider")
    @JsonIgnore
    public Optional<KeyStorageProviderOption> getCertificateKeyStorageProvider() {
        return Optional.ofNullable(certificateKeyStorageProvider);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateKeyStorageProvider} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Key Storage Provider”</i>
     * 
     * @param certificateKeyStorageProvider
     *            new value of {@code certificateKeyStorageProvider} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateKeyStorageProvider} field changed
     */
    public ManagedDeviceCertificateState withCertificateKeyStorageProvider(KeyStorageProviderOption certificateKeyStorageProvider) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateKeyStorageProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateKeyStorageProvider = certificateKeyStorageProvider;
        return _x;
    }

    /**
     * <i>“Subject name format”</i>
     * 
     * @return property certificateSubjectNameFormat
     */
    @Property(name="certificateSubjectNameFormat")
    @JsonIgnore
    public Optional<SubjectNameFormat> getCertificateSubjectNameFormat() {
        return Optional.ofNullable(certificateSubjectNameFormat);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSubjectNameFormat} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Subject name format”</i>
     * 
     * @param certificateSubjectNameFormat
     *            new value of {@code certificateSubjectNameFormat} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSubjectNameFormat} field changed
     */
    public ManagedDeviceCertificateState withCertificateSubjectNameFormat(SubjectNameFormat certificateSubjectNameFormat) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSubjectNameFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateSubjectNameFormat = certificateSubjectNameFormat;
        return _x;
    }

    /**
     * <i>“Subject alternative name format”</i>
     * 
     * @return property certificateSubjectAlternativeNameFormat
     */
    @Property(name="certificateSubjectAlternativeNameFormat")
    @JsonIgnore
    public Optional<SubjectAlternativeNameType> getCertificateSubjectAlternativeNameFormat() {
        return Optional.ofNullable(certificateSubjectAlternativeNameFormat);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSubjectAlternativeNameFormat} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Subject alternative name format”</i>
     * 
     * @param certificateSubjectAlternativeNameFormat
     *            new value of {@code certificateSubjectAlternativeNameFormat} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSubjectAlternativeNameFormat} field changed
     */
    public ManagedDeviceCertificateState withCertificateSubjectAlternativeNameFormat(SubjectAlternativeNameType certificateSubjectAlternativeNameFormat) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSubjectAlternativeNameFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateSubjectAlternativeNameFormat = certificateSubjectAlternativeNameFormat;
        return _x;
    }

    /**
     * <i>“Revoke status”</i>
     * 
     * @return property certificateRevokeStatus
     */
    @Property(name="certificateRevokeStatus")
    @JsonIgnore
    public Optional<CertificateRevocationStatus> getCertificateRevokeStatus() {
        return Optional.ofNullable(certificateRevokeStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateRevokeStatus} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Revoke status”</i>
     * 
     * @param certificateRevokeStatus
     *            new value of {@code certificateRevokeStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateRevokeStatus} field changed
     */
    public ManagedDeviceCertificateState withCertificateRevokeStatus(CertificateRevocationStatus certificateRevokeStatus) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateRevokeStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateRevokeStatus = certificateRevokeStatus;
        return _x;
    }

    /**
     * <i>“Certificate profile display name”</i>
     * 
     * @return property certificateProfileDisplayName
     */
    @Property(name="certificateProfileDisplayName")
    @JsonIgnore
    public Optional<String> getCertificateProfileDisplayName() {
        return Optional.ofNullable(certificateProfileDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateProfileDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate profile display name”</i>
     * 
     * @param certificateProfileDisplayName
     *            new value of {@code certificateProfileDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateProfileDisplayName} field changed
     */
    public ManagedDeviceCertificateState withCertificateProfileDisplayName(String certificateProfileDisplayName) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateProfileDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateProfileDisplayName = certificateProfileDisplayName;
        return _x;
    }

    /**
     * <i>“Device display name”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device display name”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public ManagedDeviceCertificateState withDeviceDisplayName(String deviceDisplayName) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“User display name”</i>
     * 
     * @return property userDisplayName
     */
    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User display name”</i>
     * 
     * @param userDisplayName
     *            new value of {@code userDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDisplayName} field changed
     */
    public ManagedDeviceCertificateState withUserDisplayName(String userDisplayName) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    /**
     * <i>“Certificate expiry date”</i>
     * 
     * @return property certificateExpirationDateTime
     */
    @Property(name="certificateExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificateExpirationDateTime() {
        return Optional.ofNullable(certificateExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateExpirationDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate expiry date”</i>
     * 
     * @param certificateExpirationDateTime
     *            new value of {@code certificateExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateExpirationDateTime} field changed
     */
    public ManagedDeviceCertificateState withCertificateExpirationDateTime(OffsetDateTime certificateExpirationDateTime) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateExpirationDateTime = certificateExpirationDateTime;
        return _x;
    }

    /**
     * <i>“Last certificate issuance state change”</i>
     * 
     * @return property certificateLastIssuanceStateChangedDateTime
     */
    @Property(name="certificateLastIssuanceStateChangedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificateLastIssuanceStateChangedDateTime() {
        return Optional.ofNullable(certificateLastIssuanceStateChangedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateLastIssuanceStateChangedDateTime} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Last certificate issuance state change”</i>
     * 
     * @param certificateLastIssuanceStateChangedDateTime
     *            new value of {@code certificateLastIssuanceStateChangedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateLastIssuanceStateChangedDateTime} field changed
     */
    public ManagedDeviceCertificateState withCertificateLastIssuanceStateChangedDateTime(OffsetDateTime certificateLastIssuanceStateChangedDateTime) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateLastIssuanceStateChangedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateLastIssuanceStateChangedDateTime = certificateLastIssuanceStateChangedDateTime;
        return _x;
    }

    /**
     * <i>“Last certificate issuance state change”</i>
     * 
     * @return property lastCertificateStateChangeDateTime
     */
    @Property(name="lastCertificateStateChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCertificateStateChangeDateTime() {
        return Optional.ofNullable(lastCertificateStateChangeDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCertificateStateChangeDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Last certificate issuance state change”</i>
     * 
     * @param lastCertificateStateChangeDateTime
     *            new value of {@code lastCertificateStateChangeDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCertificateStateChangeDateTime} field changed
     */
    public ManagedDeviceCertificateState withLastCertificateStateChangeDateTime(OffsetDateTime lastCertificateStateChangeDateTime) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("lastCertificateStateChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.lastCertificateStateChangeDateTime = lastCertificateStateChangeDateTime;
        return _x;
    }

    /**
     * <i>“Issuer”</i>
     * 
     * @return property certificateIssuer
     */
    @Property(name="certificateIssuer")
    @JsonIgnore
    public Optional<String> getCertificateIssuer() {
        return Optional.ofNullable(certificateIssuer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certificateIssuer
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Issuer”</i>
     * 
     * @param certificateIssuer
     *            new value of {@code certificateIssuer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateIssuer} field changed
     */
    public ManagedDeviceCertificateState withCertificateIssuer(String certificateIssuer) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateIssuer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateIssuer = certificateIssuer;
        return _x;
    }

    /**
     * <i>“Thumbprint”</i>
     * 
     * @return property certificateThumbprint
     */
    @Property(name="certificateThumbprint")
    @JsonIgnore
    public Optional<String> getCertificateThumbprint() {
        return Optional.ofNullable(certificateThumbprint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateThumbprint} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Thumbprint”</i>
     * 
     * @param certificateThumbprint
     *            new value of {@code certificateThumbprint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateThumbprint} field changed
     */
    public ManagedDeviceCertificateState withCertificateThumbprint(String certificateThumbprint) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateThumbprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateThumbprint = certificateThumbprint;
        return _x;
    }

    /**
     * <i>“Serial number”</i>
     * 
     * @return property certificateSerialNumber
     */
    @Property(name="certificateSerialNumber")
    @JsonIgnore
    public Optional<String> getCertificateSerialNumber() {
        return Optional.ofNullable(certificateSerialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSerialNumber} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Serial number”</i>
     * 
     * @param certificateSerialNumber
     *            new value of {@code certificateSerialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSerialNumber} field changed
     */
    public ManagedDeviceCertificateState withCertificateSerialNumber(String certificateSerialNumber) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSerialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateSerialNumber = certificateSerialNumber;
        return _x;
    }

    /**
     * <i>“Key length”</i>
     * 
     * @return property certificateKeyLength
     */
    @Property(name="certificateKeyLength")
    @JsonIgnore
    public Optional<Integer> getCertificateKeyLength() {
        return Optional.ofNullable(certificateKeyLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateKeyLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Key length”</i>
     * 
     * @param certificateKeyLength
     *            new value of {@code certificateKeyLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateKeyLength} field changed
     */
    public ManagedDeviceCertificateState withCertificateKeyLength(Integer certificateKeyLength) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateKeyLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateKeyLength = certificateKeyLength;
        return _x;
    }

    /**
     * <i>“Extended key usage”</i>
     * 
     * @return property certificateEnhancedKeyUsage
     */
    @Property(name="certificateEnhancedKeyUsage")
    @JsonIgnore
    public Optional<String> getCertificateEnhancedKeyUsage() {
        return Optional.ofNullable(certificateEnhancedKeyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateEnhancedKeyUsage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Extended key usage”</i>
     * 
     * @param certificateEnhancedKeyUsage
     *            new value of {@code certificateEnhancedKeyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateEnhancedKeyUsage} field changed
     */
    public ManagedDeviceCertificateState withCertificateEnhancedKeyUsage(String certificateEnhancedKeyUsage) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateEnhancedKeyUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateEnhancedKeyUsage = certificateEnhancedKeyUsage;
        return _x;
    }

    /**
     * <i>“Validity period”</i>
     * 
     * @return property certificateValidityPeriod
     */
    @Property(name="certificateValidityPeriod")
    @JsonIgnore
    public Optional<Integer> getCertificateValidityPeriod() {
        return Optional.ofNullable(certificateValidityPeriod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriod} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Validity period”</i>
     * 
     * @param certificateValidityPeriod
     *            new value of {@code certificateValidityPeriod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriod} field changed
     */
    public ManagedDeviceCertificateState withCertificateValidityPeriod(Integer certificateValidityPeriod) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateValidityPeriod = certificateValidityPeriod;
        return _x;
    }

    /**
     * <i>“Subject name format string for custom subject name formats”</i>
     * 
     * @return property certificateSubjectNameFormatString
     */
    @Property(name="certificateSubjectNameFormatString")
    @JsonIgnore
    public Optional<String> getCertificateSubjectNameFormatString() {
        return Optional.ofNullable(certificateSubjectNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSubjectNameFormatString} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Subject name format string for custom subject name formats”</i>
     * 
     * @param certificateSubjectNameFormatString
     *            new value of {@code certificateSubjectNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSubjectNameFormatString} field changed
     */
    public ManagedDeviceCertificateState withCertificateSubjectNameFormatString(String certificateSubjectNameFormatString) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSubjectNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateSubjectNameFormatString = certificateSubjectNameFormatString;
        return _x;
    }

    /**
     * <i>“Subject alternative name format string for custom formats”</i>
     * 
     * @return property certificateSubjectAlternativeNameFormatString
     */
    @Property(name="certificateSubjectAlternativeNameFormatString")
    @JsonIgnore
    public Optional<String> getCertificateSubjectAlternativeNameFormatString() {
        return Optional.ofNullable(certificateSubjectAlternativeNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSubjectAlternativeNameFormatString} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Subject alternative name format string for custom formats”</i>
     * 
     * @param certificateSubjectAlternativeNameFormatString
     *            new value of {@code certificateSubjectAlternativeNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSubjectAlternativeNameFormatString} field changed
     */
    public ManagedDeviceCertificateState withCertificateSubjectAlternativeNameFormatString(String certificateSubjectAlternativeNameFormatString) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSubjectAlternativeNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateSubjectAlternativeNameFormatString = certificateSubjectAlternativeNameFormatString;
        return _x;
    }

    /**
     * <i>“Issuance date”</i>
     * 
     * @return property certificateIssuanceDateTime
     */
    @Property(name="certificateIssuanceDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificateIssuanceDateTime() {
        return Optional.ofNullable(certificateIssuanceDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateIssuanceDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Issuance date”</i>
     * 
     * @param certificateIssuanceDateTime
     *            new value of {@code certificateIssuanceDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateIssuanceDateTime} field changed
     */
    public ManagedDeviceCertificateState withCertificateIssuanceDateTime(OffsetDateTime certificateIssuanceDateTime) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateIssuanceDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateIssuanceDateTime = certificateIssuanceDateTime;
        return _x;
    }

    /**
     * <i>“Error code”</i>
     * 
     * @return property certificateErrorCode
     */
    @Property(name="certificateErrorCode")
    @JsonIgnore
    public Optional<Integer> getCertificateErrorCode() {
        return Optional.ofNullable(certificateErrorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateErrorCode} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Error code”</i>
     * 
     * @param certificateErrorCode
     *            new value of {@code certificateErrorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateErrorCode} field changed
     */
    public ManagedDeviceCertificateState withCertificateErrorCode(Integer certificateErrorCode) {
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateErrorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCertificateState");
        _x.certificateErrorCode = certificateErrorCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceCertificateState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceCertificateState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceCertificateState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceCertificateState _copy() {
        ManagedDeviceCertificateState _x = new ManagedDeviceCertificateState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.devicePlatform = devicePlatform;
        _x.certificateKeyUsage = certificateKeyUsage;
        _x.certificateValidityPeriodUnits = certificateValidityPeriodUnits;
        _x.certificateIssuanceState = certificateIssuanceState;
        _x.certificateKeyStorageProvider = certificateKeyStorageProvider;
        _x.certificateSubjectNameFormat = certificateSubjectNameFormat;
        _x.certificateSubjectAlternativeNameFormat = certificateSubjectAlternativeNameFormat;
        _x.certificateRevokeStatus = certificateRevokeStatus;
        _x.certificateProfileDisplayName = certificateProfileDisplayName;
        _x.deviceDisplayName = deviceDisplayName;
        _x.userDisplayName = userDisplayName;
        _x.certificateExpirationDateTime = certificateExpirationDateTime;
        _x.certificateLastIssuanceStateChangedDateTime = certificateLastIssuanceStateChangedDateTime;
        _x.lastCertificateStateChangeDateTime = lastCertificateStateChangeDateTime;
        _x.certificateIssuer = certificateIssuer;
        _x.certificateThumbprint = certificateThumbprint;
        _x.certificateSerialNumber = certificateSerialNumber;
        _x.certificateKeyLength = certificateKeyLength;
        _x.certificateEnhancedKeyUsage = certificateEnhancedKeyUsage;
        _x.certificateValidityPeriod = certificateValidityPeriod;
        _x.certificateSubjectNameFormatString = certificateSubjectNameFormatString;
        _x.certificateSubjectAlternativeNameFormatString = certificateSubjectAlternativeNameFormatString;
        _x.certificateIssuanceDateTime = certificateIssuanceDateTime;
        _x.certificateErrorCode = certificateErrorCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceCertificateState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("devicePlatform=");
        b.append(this.devicePlatform);
        b.append(", ");
        b.append("certificateKeyUsage=");
        b.append(this.certificateKeyUsage);
        b.append(", ");
        b.append("certificateValidityPeriodUnits=");
        b.append(this.certificateValidityPeriodUnits);
        b.append(", ");
        b.append("certificateIssuanceState=");
        b.append(this.certificateIssuanceState);
        b.append(", ");
        b.append("certificateKeyStorageProvider=");
        b.append(this.certificateKeyStorageProvider);
        b.append(", ");
        b.append("certificateSubjectNameFormat=");
        b.append(this.certificateSubjectNameFormat);
        b.append(", ");
        b.append("certificateSubjectAlternativeNameFormat=");
        b.append(this.certificateSubjectAlternativeNameFormat);
        b.append(", ");
        b.append("certificateRevokeStatus=");
        b.append(this.certificateRevokeStatus);
        b.append(", ");
        b.append("certificateProfileDisplayName=");
        b.append(this.certificateProfileDisplayName);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("certificateExpirationDateTime=");
        b.append(this.certificateExpirationDateTime);
        b.append(", ");
        b.append("certificateLastIssuanceStateChangedDateTime=");
        b.append(this.certificateLastIssuanceStateChangedDateTime);
        b.append(", ");
        b.append("lastCertificateStateChangeDateTime=");
        b.append(this.lastCertificateStateChangeDateTime);
        b.append(", ");
        b.append("certificateIssuer=");
        b.append(this.certificateIssuer);
        b.append(", ");
        b.append("certificateThumbprint=");
        b.append(this.certificateThumbprint);
        b.append(", ");
        b.append("certificateSerialNumber=");
        b.append(this.certificateSerialNumber);
        b.append(", ");
        b.append("certificateKeyLength=");
        b.append(this.certificateKeyLength);
        b.append(", ");
        b.append("certificateEnhancedKeyUsage=");
        b.append(this.certificateEnhancedKeyUsage);
        b.append(", ");
        b.append("certificateValidityPeriod=");
        b.append(this.certificateValidityPeriod);
        b.append(", ");
        b.append("certificateSubjectNameFormatString=");
        b.append(this.certificateSubjectNameFormatString);
        b.append(", ");
        b.append("certificateSubjectAlternativeNameFormatString=");
        b.append(this.certificateSubjectAlternativeNameFormatString);
        b.append(", ");
        b.append("certificateIssuanceDateTime=");
        b.append(this.certificateIssuanceDateTime);
        b.append(", ");
        b.append("certificateErrorCode=");
        b.append(this.certificateErrorCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
