package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ConfigurationManagerAction;
import odata.msgraph.client.beta.complex.ConfigurationManagerClientEnabledFeatures;
import odata.msgraph.client.beta.complex.ConfigurationManagerClientHealthState;
import odata.msgraph.client.beta.complex.ConfigurationManagerClientInformation;
import odata.msgraph.client.beta.complex.DeviceActionResult;
import odata.msgraph.client.beta.complex.DeviceCompliancePolicySettingState;
import odata.msgraph.client.beta.complex.DeviceHealthAttestationState;
import odata.msgraph.client.beta.complex.DeviceLogCollectionRequest;
import odata.msgraph.client.beta.complex.HardwareInformation;
import odata.msgraph.client.beta.complex.LoggedOnUser;
import odata.msgraph.client.beta.complex.UpdateWindowsDeviceAccountActionParameter;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceLogCollectionResponseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceCategoryRequest;
import odata.msgraph.client.beta.entity.request.WindowsProtectionStateRequest;
import odata.msgraph.client.beta.enums.AdministratorConfiguredDeviceComplianceState;
import odata.msgraph.client.beta.enums.ChassisType;
import odata.msgraph.client.beta.enums.ComplianceState;
import odata.msgraph.client.beta.enums.DeviceEnrollmentType;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessState;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessStateReason;
import odata.msgraph.client.beta.enums.DeviceRegistrationState;
import odata.msgraph.client.beta.enums.DeviceType;
import odata.msgraph.client.beta.enums.JoinType;
import odata.msgraph.client.beta.enums.LostModeState;
import odata.msgraph.client.beta.enums.ManagedDeviceArchitecture;
import odata.msgraph.client.beta.enums.ManagedDeviceOwnerType;
import odata.msgraph.client.beta.enums.ManagedDevicePartnerReportedHealthState;
import odata.msgraph.client.beta.enums.ManagementAgentType;
import odata.msgraph.client.beta.enums.ManagementState;
import odata.msgraph.client.beta.enums.OwnerType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Devices that are managed or pre-enrolled through Intune”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userId", 
    "deviceName", 
    "hardwareInformation", 
    "ownerType", 
    "managedDeviceOwnerType", 
    "deviceActionResults", 
    "managementState", 
    "enrolledDateTime", 
    "lastSyncDateTime", 
    "chassisType", 
    "operatingSystem", 
    "deviceType", 
    "complianceState", 
    "jailBroken", 
    "managementAgent", 
    "osVersion", 
    "easActivated", 
    "easDeviceId", 
    "easActivationDateTime", 
    "aadRegistered", 
    "azureADRegistered", 
    "deviceEnrollmentType", 
    "lostModeState", 
    "activationLockBypassCode", 
    "emailAddress", 
    "azureActiveDirectoryDeviceId", 
    "azureADDeviceId", 
    "deviceRegistrationState", 
    "deviceCategoryDisplayName", 
    "isSupervised", 
    "exchangeLastSuccessfulSyncDateTime", 
    "exchangeAccessState", 
    "exchangeAccessStateReason", 
    "remoteAssistanceSessionUrl", 
    "remoteAssistanceSessionErrorDetails", 
    "isEncrypted", 
    "userPrincipalName", 
    "model", 
    "manufacturer", 
    "imei", 
    "complianceGracePeriodExpirationDateTime", 
    "serialNumber", 
    "phoneNumber", 
    "androidSecurityPatchLevel", 
    "userDisplayName", 
    "configurationManagerClientEnabledFeatures", 
    "wiFiMacAddress", 
    "deviceHealthAttestationState", 
    "subscriberCarrier", 
    "meid", 
    "totalStorageSpaceInBytes", 
    "freeStorageSpaceInBytes", 
    "managedDeviceName", 
    "partnerReportedThreatState", 
    "retireAfterDateTime", 
    "usersLoggedOn", 
    "preferMdmOverGroupPolicyAppliedDateTime", 
    "autopilotEnrolled", 
    "requireUserEnrollmentApproval", 
    "managementCertificateExpirationDate", 
    "iccid", 
    "udid", 
    "roleScopeTagIds", 
    "windowsActiveMalwareCount", 
    "windowsRemediatedMalwareCount", 
    "notes", 
    "configurationManagerClientHealthState", 
    "configurationManagerClientInformation", 
    "ethernetMacAddress", 
    "physicalMemoryInBytes", 
    "processorArchitecture", 
    "specificationVersion", 
    "joinType", 
    "skuFamily"})
@JsonInclude(Include.NON_NULL)
public class ManagedDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDevice";
    }

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("hardwareInformation")
    protected HardwareInformation hardwareInformation;

    @JsonProperty("ownerType")
    protected OwnerType ownerType;

    @JsonProperty("managedDeviceOwnerType")
    protected ManagedDeviceOwnerType managedDeviceOwnerType;

    @JsonProperty("deviceActionResults")
    protected List<DeviceActionResult> deviceActionResults;

    @JsonProperty("deviceActionResults@nextLink")
    protected String deviceActionResultsNextLink;

    @JsonProperty("managementState")
    protected ManagementState managementState;

    @JsonProperty("enrolledDateTime")
    protected OffsetDateTime enrolledDateTime;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("chassisType")
    protected ChassisType chassisType;

    @JsonProperty("operatingSystem")
    protected String operatingSystem;

    @JsonProperty("deviceType")
    protected DeviceType deviceType;

    @JsonProperty("complianceState")
    protected ComplianceState complianceState;

    @JsonProperty("jailBroken")
    protected String jailBroken;

    @JsonProperty("managementAgent")
    protected ManagementAgentType managementAgent;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("easActivated")
    protected Boolean easActivated;

    @JsonProperty("easDeviceId")
    protected String easDeviceId;

    @JsonProperty("easActivationDateTime")
    protected OffsetDateTime easActivationDateTime;

    @JsonProperty("aadRegistered")
    protected Boolean aadRegistered;

    @JsonProperty("azureADRegistered")
    protected Boolean azureADRegistered;

    @JsonProperty("deviceEnrollmentType")
    protected DeviceEnrollmentType deviceEnrollmentType;

    @JsonProperty("lostModeState")
    protected LostModeState lostModeState;

    @JsonProperty("activationLockBypassCode")
    protected String activationLockBypassCode;

    @JsonProperty("emailAddress")
    protected String emailAddress;

    @JsonProperty("azureActiveDirectoryDeviceId")
    protected String azureActiveDirectoryDeviceId;

    @JsonProperty("azureADDeviceId")
    protected String azureADDeviceId;

    @JsonProperty("deviceRegistrationState")
    protected DeviceRegistrationState deviceRegistrationState;

    @JsonProperty("deviceCategoryDisplayName")
    protected String deviceCategoryDisplayName;

    @JsonProperty("isSupervised")
    protected Boolean isSupervised;

    @JsonProperty("exchangeLastSuccessfulSyncDateTime")
    protected OffsetDateTime exchangeLastSuccessfulSyncDateTime;

    @JsonProperty("exchangeAccessState")
    protected DeviceManagementExchangeAccessState exchangeAccessState;

    @JsonProperty("exchangeAccessStateReason")
    protected DeviceManagementExchangeAccessStateReason exchangeAccessStateReason;

    @JsonProperty("remoteAssistanceSessionUrl")
    protected String remoteAssistanceSessionUrl;

    @JsonProperty("remoteAssistanceSessionErrorDetails")
    protected String remoteAssistanceSessionErrorDetails;

    @JsonProperty("isEncrypted")
    protected Boolean isEncrypted;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("imei")
    protected String imei;

    @JsonProperty("complianceGracePeriodExpirationDateTime")
    protected OffsetDateTime complianceGracePeriodExpirationDateTime;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("androidSecurityPatchLevel")
    protected String androidSecurityPatchLevel;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("configurationManagerClientEnabledFeatures")
    protected ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures;

    @JsonProperty("wiFiMacAddress")
    protected String wiFiMacAddress;

    @JsonProperty("deviceHealthAttestationState")
    protected DeviceHealthAttestationState deviceHealthAttestationState;

    @JsonProperty("subscriberCarrier")
    protected String subscriberCarrier;

    @JsonProperty("meid")
    protected String meid;

    @JsonProperty("totalStorageSpaceInBytes")
    protected Long totalStorageSpaceInBytes;

    @JsonProperty("freeStorageSpaceInBytes")
    protected Long freeStorageSpaceInBytes;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("partnerReportedThreatState")
    protected ManagedDevicePartnerReportedHealthState partnerReportedThreatState;

    @JsonProperty("retireAfterDateTime")
    protected OffsetDateTime retireAfterDateTime;

    @JsonProperty("usersLoggedOn")
    protected List<LoggedOnUser> usersLoggedOn;

    @JsonProperty("usersLoggedOn@nextLink")
    protected String usersLoggedOnNextLink;

    @JsonProperty("preferMdmOverGroupPolicyAppliedDateTime")
    protected OffsetDateTime preferMdmOverGroupPolicyAppliedDateTime;

    @JsonProperty("autopilotEnrolled")
    protected Boolean autopilotEnrolled;

    @JsonProperty("requireUserEnrollmentApproval")
    protected Boolean requireUserEnrollmentApproval;

    @JsonProperty("managementCertificateExpirationDate")
    protected OffsetDateTime managementCertificateExpirationDate;

    @JsonProperty("iccid")
    protected String iccid;

    @JsonProperty("udid")
    protected String udid;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("windowsActiveMalwareCount")
    protected Integer windowsActiveMalwareCount;

    @JsonProperty("windowsRemediatedMalwareCount")
    protected Integer windowsRemediatedMalwareCount;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("configurationManagerClientHealthState")
    protected ConfigurationManagerClientHealthState configurationManagerClientHealthState;

    @JsonProperty("configurationManagerClientInformation")
    protected ConfigurationManagerClientInformation configurationManagerClientInformation;

    @JsonProperty("ethernetMacAddress")
    protected String ethernetMacAddress;

    @JsonProperty("physicalMemoryInBytes")
    protected Long physicalMemoryInBytes;

    @JsonProperty("processorArchitecture")
    protected ManagedDeviceArchitecture processorArchitecture;

    @JsonProperty("specificationVersion")
    protected String specificationVersion;

    @JsonProperty("joinType")
    protected JoinType joinType;

    @JsonProperty("skuFamily")
    protected String skuFamily;

    protected ManagedDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userId;
        private String deviceName;
        private HardwareInformation hardwareInformation;
        private OwnerType ownerType;
        private ManagedDeviceOwnerType managedDeviceOwnerType;
        private List<DeviceActionResult> deviceActionResults;
        private String deviceActionResultsNextLink;
        private ManagementState managementState;
        private OffsetDateTime enrolledDateTime;
        private OffsetDateTime lastSyncDateTime;
        private ChassisType chassisType;
        private String operatingSystem;
        private DeviceType deviceType;
        private ComplianceState complianceState;
        private String jailBroken;
        private ManagementAgentType managementAgent;
        private String osVersion;
        private Boolean easActivated;
        private String easDeviceId;
        private OffsetDateTime easActivationDateTime;
        private Boolean aadRegistered;
        private Boolean azureADRegistered;
        private DeviceEnrollmentType deviceEnrollmentType;
        private LostModeState lostModeState;
        private String activationLockBypassCode;
        private String emailAddress;
        private String azureActiveDirectoryDeviceId;
        private String azureADDeviceId;
        private DeviceRegistrationState deviceRegistrationState;
        private String deviceCategoryDisplayName;
        private Boolean isSupervised;
        private OffsetDateTime exchangeLastSuccessfulSyncDateTime;
        private DeviceManagementExchangeAccessState exchangeAccessState;
        private DeviceManagementExchangeAccessStateReason exchangeAccessStateReason;
        private String remoteAssistanceSessionUrl;
        private String remoteAssistanceSessionErrorDetails;
        private Boolean isEncrypted;
        private String userPrincipalName;
        private String model;
        private String manufacturer;
        private String imei;
        private OffsetDateTime complianceGracePeriodExpirationDateTime;
        private String serialNumber;
        private String phoneNumber;
        private String androidSecurityPatchLevel;
        private String userDisplayName;
        private ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures;
        private String wiFiMacAddress;
        private DeviceHealthAttestationState deviceHealthAttestationState;
        private String subscriberCarrier;
        private String meid;
        private Long totalStorageSpaceInBytes;
        private Long freeStorageSpaceInBytes;
        private String managedDeviceName;
        private ManagedDevicePartnerReportedHealthState partnerReportedThreatState;
        private OffsetDateTime retireAfterDateTime;
        private List<LoggedOnUser> usersLoggedOn;
        private String usersLoggedOnNextLink;
        private OffsetDateTime preferMdmOverGroupPolicyAppliedDateTime;
        private Boolean autopilotEnrolled;
        private Boolean requireUserEnrollmentApproval;
        private OffsetDateTime managementCertificateExpirationDate;
        private String iccid;
        private String udid;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer windowsActiveMalwareCount;
        private Integer windowsRemediatedMalwareCount;
        private String notes;
        private ConfigurationManagerClientHealthState configurationManagerClientHealthState;
        private ConfigurationManagerClientInformation configurationManagerClientInformation;
        private String ethernetMacAddress;
        private Long physicalMemoryInBytes;
        private ManagedDeviceArchitecture processorArchitecture;
        private String specificationVersion;
        private JoinType joinType;
        private String skuFamily;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Unique Identifier for the user associated with the device. This property is read
         * -only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“Name of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The hardward details for the device.  Includes information such as storage space
         * , manufacturer, serial number, etc. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param hardwareInformation
         *            value of {@code hardwareInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hardwareInformation(HardwareInformation hardwareInformation) {
            this.hardwareInformation = hardwareInformation;
            this.changedFields = changedFields.add("hardwareInformation");
            return this;
        }

        /**
         * <i>“Ownership of the device. Can be 'company' or 'personal'”</i>
         * 
         * @param ownerType
         *            value of {@code ownerType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerType(OwnerType ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        /**
         * <i>“Ownership of the device. Can be 'company' or 'personal'”</i>
         * 
         * @param managedDeviceOwnerType
         *            value of {@code managedDeviceOwnerType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceOwnerType(ManagedDeviceOwnerType managedDeviceOwnerType) {
            this.managedDeviceOwnerType = managedDeviceOwnerType;
            this.changedFields = changedFields.add("managedDeviceOwnerType");
            return this;
        }

        /**
         * <i>“List of ComplexType deviceActionResult objects. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceActionResults
         *            value of {@code deviceActionResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceActionResults(List<DeviceActionResult> deviceActionResults) {
            this.deviceActionResults = deviceActionResults;
            this.changedFields = changedFields.add("deviceActionResults");
            return this;
        }

        /**
         * <i>“List of ComplexType deviceActionResult objects. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceActionResults
         *            value of {@code deviceActionResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceActionResults(DeviceActionResult... deviceActionResults) {
            return deviceActionResults(Arrays.asList(deviceActionResults));
        }

        /**
         * <i>“List of ComplexType deviceActionResult objects. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceActionResultsNextLink
         *            value of {@code deviceActionResults@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceActionResultsNextLink(String deviceActionResultsNextLink) {
            this.deviceActionResultsNextLink = deviceActionResultsNextLink;
            this.changedFields = changedFields.add("deviceActionResults");
            return this;
        }

        /**
         * <i>“Management state of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param managementState
         *            value of {@code managementState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementState(ManagementState managementState) {
            this.managementState = managementState;
            this.changedFields = changedFields.add("managementState");
            return this;
        }

        /**
         * <i>“Enrollment time of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param enrolledDateTime
         *            value of {@code enrolledDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrolledDateTime(OffsetDateTime enrolledDateTime) {
            this.enrolledDateTime = enrolledDateTime;
            this.changedFields = changedFields.add("enrolledDateTime");
            return this;
        }

        /**
         * <i>“The date and time that the device last completed a successful sync with Intune.
         * This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Chassis type of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param chassisType
         *            value of {@code chassisType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder chassisType(ChassisType chassisType) {
            this.chassisType = chassisType;
            this.changedFields = changedFields.add("chassisType");
            return this;
        }

        /**
         * <i>“Operating system of the device. Windows, iOS, etc. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param operatingSystem
         *            value of {@code operatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        /**
         * <i>“Platform of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceType
         *            value of {@code deviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        /**
         * <i>“Compliance state of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param complianceState
         *            value of {@code complianceState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceState(ComplianceState complianceState) {
            this.complianceState = complianceState;
            this.changedFields = changedFields.add("complianceState");
            return this;
        }

        /**
         * <i>“whether the device is jail broken or rooted. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param jailBroken
         *            value of {@code jailBroken} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder jailBroken(String jailBroken) {
            this.jailBroken = jailBroken;
            this.changedFields = changedFields.add("jailBroken");
            return this;
        }

        /**
         * <i>“Management channel of the device. Intune, EAS, etc. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param managementAgent
         *            value of {@code managementAgent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementAgent(ManagementAgentType managementAgent) {
            this.managementAgent = managementAgent;
            this.changedFields = changedFields.add("managementAgent");
            return this;
        }

        /**
         * <i>“Operating system version of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“Whether the device is Exchange ActiveSync activated. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param easActivated
         *            value of {@code easActivated} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder easActivated(Boolean easActivated) {
            this.easActivated = easActivated;
            this.changedFields = changedFields.add("easActivated");
            return this;
        }

        /**
         * <i>“Exchange ActiveSync Id of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param easDeviceId
         *            value of {@code easDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder easDeviceId(String easDeviceId) {
            this.easDeviceId = easDeviceId;
            this.changedFields = changedFields.add("easDeviceId");
            return this;
        }

        /**
         * <i>“Exchange ActivationSync activation time of the device. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param easActivationDateTime
         *            value of {@code easActivationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder easActivationDateTime(OffsetDateTime easActivationDateTime) {
            this.easActivationDateTime = easActivationDateTime;
            this.changedFields = changedFields.add("easActivationDateTime");
            return this;
        }

        /**
         * <i>“Whether the device is Azure Active Directory registered. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param aadRegistered
         *            value of {@code aadRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder aadRegistered(Boolean aadRegistered) {
            this.aadRegistered = aadRegistered;
            this.changedFields = changedFields.add("aadRegistered");
            return this;
        }

        /**
         * <i>“Whether the device is Azure Active Directory registered. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param azureADRegistered
         *            value of {@code azureADRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureADRegistered(Boolean azureADRegistered) {
            this.azureADRegistered = azureADRegistered;
            this.changedFields = changedFields.add("azureADRegistered");
            return this;
        }

        /**
         * <i>“Enrollment type of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceEnrollmentType
         *            value of {@code deviceEnrollmentType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentType(DeviceEnrollmentType deviceEnrollmentType) {
            this.deviceEnrollmentType = deviceEnrollmentType;
            this.changedFields = changedFields.add("deviceEnrollmentType");
            return this;
        }

        /**
         * <i>“Indicates if Lost mode is enabled or disabled. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lostModeState
         *            value of {@code lostModeState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lostModeState(LostModeState lostModeState) {
            this.lostModeState = lostModeState;
            this.changedFields = changedFields.add("lostModeState");
            return this;
        }

        /**
         * <i>“Code that allows the Activation Lock on a device to be bypassed. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param activationLockBypassCode
         *            value of {@code activationLockBypassCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activationLockBypassCode(String activationLockBypassCode) {
            this.activationLockBypassCode = activationLockBypassCode;
            this.changedFields = changedFields.add("activationLockBypassCode");
            return this;
        }

        /**
         * <i>“Email(s) for the user associated with the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param emailAddress
         *            value of {@code emailAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        /**
         * <i>“The unique identifier for the Azure Active Directory device. Read only. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param azureActiveDirectoryDeviceId
         *            value of {@code azureActiveDirectoryDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureActiveDirectoryDeviceId(String azureActiveDirectoryDeviceId) {
            this.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
            this.changedFields = changedFields.add("azureActiveDirectoryDeviceId");
            return this;
        }

        /**
         * <i>“The unique identifier for the Azure Active Directory device. Read only. This
         * property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param azureADDeviceId
         *            value of {@code azureADDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureADDeviceId(String azureADDeviceId) {
            this.azureADDeviceId = azureADDeviceId;
            this.changedFields = changedFields.add("azureADDeviceId");
            return this;
        }

        /**
         * <i>“Device registration state. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceRegistrationState
         *            value of {@code deviceRegistrationState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRegistrationState(DeviceRegistrationState deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            this.changedFields = changedFields.add("deviceRegistrationState");
            return this;
        }

        /**
         * <i>“Device category display name. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceCategoryDisplayName
         *            value of {@code deviceCategoryDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCategoryDisplayName(String deviceCategoryDisplayName) {
            this.deviceCategoryDisplayName = deviceCategoryDisplayName;
            this.changedFields = changedFields.add("deviceCategoryDisplayName");
            return this;
        }

        /**
         * <i>“Device supervised status. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param isSupervised
         *            value of {@code isSupervised} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSupervised(Boolean isSupervised) {
            this.isSupervised = isSupervised;
            this.changedFields = changedFields.add("isSupervised");
            return this;
        }

        /**
         * <i>“Last time the device contacted Exchange. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param exchangeLastSuccessfulSyncDateTime
         *            value of {@code exchangeLastSuccessfulSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeLastSuccessfulSyncDateTime(OffsetDateTime exchangeLastSuccessfulSyncDateTime) {
            this.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
            this.changedFields = changedFields.add("exchangeLastSuccessfulSyncDateTime");
            return this;
        }

        /**
         * <i>“The Access State of the device in Exchange. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param exchangeAccessState
         *            value of {@code exchangeAccessState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeAccessState(DeviceManagementExchangeAccessState exchangeAccessState) {
            this.exchangeAccessState = exchangeAccessState;
            this.changedFields = changedFields.add("exchangeAccessState");
            return this;
        }

        /**
         * <i>“The reason for the device's access state in Exchange. This property is read-only
         * .”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param exchangeAccessStateReason
         *            value of {@code exchangeAccessStateReason} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exchangeAccessStateReason(DeviceManagementExchangeAccessStateReason exchangeAccessStateReason) {
            this.exchangeAccessStateReason = exchangeAccessStateReason;
            this.changedFields = changedFields.add("exchangeAccessStateReason");
            return this;
        }

        /**
         * <i>“Url that allows a Remote Assistance session to be established with the device.
         * This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param remoteAssistanceSessionUrl
         *            value of {@code remoteAssistanceSessionUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAssistanceSessionUrl(String remoteAssistanceSessionUrl) {
            this.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
            this.changedFields = changedFields.add("remoteAssistanceSessionUrl");
            return this;
        }

        /**
         * <i>“An error string that identifies issues when creating Remote Assistance session
         * objects. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param remoteAssistanceSessionErrorDetails
         *            value of {@code remoteAssistanceSessionErrorDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteAssistanceSessionErrorDetails(String remoteAssistanceSessionErrorDetails) {
            this.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
            this.changedFields = changedFields.add("remoteAssistanceSessionErrorDetails");
            return this;
        }

        /**
         * <i>“Device encryption status. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param isEncrypted
         *            value of {@code isEncrypted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.changedFields = changedFields.add("isEncrypted");
            return this;
        }

        /**
         * <i>“Device user principal name. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Model of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“Manufacturer of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“IMEI. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param imei
         *            value of {@code imei} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder imei(String imei) {
            this.imei = imei;
            this.changedFields = changedFields.add("imei");
            return this;
        }

        /**
         * <i>“The DateTime when device compliance grace period expires. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param complianceGracePeriodExpirationDateTime
         *            value of {@code complianceGracePeriodExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceGracePeriodExpirationDateTime(OffsetDateTime complianceGracePeriodExpirationDateTime) {
            this.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
            this.changedFields = changedFields.add("complianceGracePeriodExpirationDateTime");
            return this;
        }

        /**
         * <i>“SerialNumber. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“Phone number of the device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param phoneNumber
         *            value of {@code phoneNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        /**
         * <i>“Android security patch level. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param androidSecurityPatchLevel
         *            value of {@code androidSecurityPatchLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidSecurityPatchLevel(String androidSecurityPatchLevel) {
            this.androidSecurityPatchLevel = androidSecurityPatchLevel;
            this.changedFields = changedFields.add("androidSecurityPatchLevel");
            return this;
        }

        /**
         * <i>“User display name. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param userDisplayName
         *            value of {@code userDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        /**
         * <i>“ConfigrMgr client enabled features. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param configurationManagerClientEnabledFeatures
         *            value of {@code configurationManagerClientEnabledFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationManagerClientEnabledFeatures(ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures) {
            this.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
            this.changedFields = changedFields.add("configurationManagerClientEnabledFeatures");
            return this;
        }

        /**
         * <i>“Wi-Fi MAC. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param wiFiMacAddress
         *            value of {@code wiFiMacAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiMacAddress(String wiFiMacAddress) {
            this.wiFiMacAddress = wiFiMacAddress;
            this.changedFields = changedFields.add("wiFiMacAddress");
            return this;
        }

        /**
         * <i>“The device health attestation state. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param deviceHealthAttestationState
         *            value of {@code deviceHealthAttestationState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceHealthAttestationState(DeviceHealthAttestationState deviceHealthAttestationState) {
            this.deviceHealthAttestationState = deviceHealthAttestationState;
            this.changedFields = changedFields.add("deviceHealthAttestationState");
            return this;
        }

        /**
         * <i>“Subscriber Carrier. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param subscriberCarrier
         *            value of {@code subscriberCarrier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriberCarrier(String subscriberCarrier) {
            this.subscriberCarrier = subscriberCarrier;
            this.changedFields = changedFields.add("subscriberCarrier");
            return this;
        }

        /**
         * <i>“MEID. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param meid
         *            value of {@code meid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meid(String meid) {
            this.meid = meid;
            this.changedFields = changedFields.add("meid");
            return this;
        }

        /**
         * <i>“Total Storage in Bytes. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param totalStorageSpaceInBytes
         *            value of {@code totalStorageSpaceInBytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalStorageSpaceInBytes(Long totalStorageSpaceInBytes) {
            this.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
            this.changedFields = changedFields.add("totalStorageSpaceInBytes");
            return this;
        }

        /**
         * <i>“Free Storage in Bytes. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param freeStorageSpaceInBytes
         *            value of {@code freeStorageSpaceInBytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder freeStorageSpaceInBytes(Long freeStorageSpaceInBytes) {
            this.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
            this.changedFields = changedFields.add("freeStorageSpaceInBytes");
            return this;
        }

        /**
         * <i>“Automatically generated name to identify a device. Can be overwritten to a user
         * friendly name.”</i>
         * 
         * @param managedDeviceName
         *            value of {@code managedDeviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        /**
         * <i>“Indicates the threat state of a device when a Mobile Threat Defense partner is
         * in use by the account and device. Read Only. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param partnerReportedThreatState
         *            value of {@code partnerReportedThreatState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerReportedThreatState(ManagedDevicePartnerReportedHealthState partnerReportedThreatState) {
            this.partnerReportedThreatState = partnerReportedThreatState;
            this.changedFields = changedFields.add("partnerReportedThreatState");
            return this;
        }

        /**
         * <i>“Indicates the time after when a device will be auto retired because of scheduled
         * action. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param retireAfterDateTime
         *            value of {@code retireAfterDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder retireAfterDateTime(OffsetDateTime retireAfterDateTime) {
            this.retireAfterDateTime = retireAfterDateTime;
            this.changedFields = changedFields.add("retireAfterDateTime");
            return this;
        }

        /**
         * <i>“Indicates the last logged on users of a device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param usersLoggedOn
         *            value of {@code usersLoggedOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usersLoggedOn(List<LoggedOnUser> usersLoggedOn) {
            this.usersLoggedOn = usersLoggedOn;
            this.changedFields = changedFields.add("usersLoggedOn");
            return this;
        }

        /**
         * <i>“Indicates the last logged on users of a device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param usersLoggedOn
         *            value of {@code usersLoggedOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usersLoggedOn(LoggedOnUser... usersLoggedOn) {
            return usersLoggedOn(Arrays.asList(usersLoggedOn));
        }

        /**
         * <i>“Indicates the last logged on users of a device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param usersLoggedOnNextLink
         *            value of {@code usersLoggedOn@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usersLoggedOnNextLink(String usersLoggedOnNextLink) {
            this.usersLoggedOnNextLink = usersLoggedOnNextLink;
            this.changedFields = changedFields.add("usersLoggedOn");
            return this;
        }

        /**
         * <i>“Reports the DateTime the preferMdmOverGroupPolicy setting was set.  When set,
         * the Intune MDM settings will override Group Policy settings if there is a
         * conflict. Read Only. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param preferMdmOverGroupPolicyAppliedDateTime
         *            value of {@code preferMdmOverGroupPolicyAppliedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder preferMdmOverGroupPolicyAppliedDateTime(OffsetDateTime preferMdmOverGroupPolicyAppliedDateTime) {
            this.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
            this.changedFields = changedFields.add("preferMdmOverGroupPolicyAppliedDateTime");
            return this;
        }

        /**
         * <i>“Reports if the managed device is enrolled via auto-pilot. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param autopilotEnrolled
         *            value of {@code autopilotEnrolled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autopilotEnrolled(Boolean autopilotEnrolled) {
            this.autopilotEnrolled = autopilotEnrolled;
            this.changedFields = changedFields.add("autopilotEnrolled");
            return this;
        }

        /**
         * <i>“Reports if the managed iOS device is user approval enrollment. This property is
         * read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param requireUserEnrollmentApproval
         *            value of {@code requireUserEnrollmentApproval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireUserEnrollmentApproval(Boolean requireUserEnrollmentApproval) {
            this.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
            this.changedFields = changedFields.add("requireUserEnrollmentApproval");
            return this;
        }

        /**
         * <i>“Reports device management certificate expiration date. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param managementCertificateExpirationDate
         *            value of {@code managementCertificateExpirationDate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementCertificateExpirationDate(OffsetDateTime managementCertificateExpirationDate) {
            this.managementCertificateExpirationDate = managementCertificateExpirationDate;
            this.changedFields = changedFields.add("managementCertificateExpirationDate");
            return this;
        }

        /**
         * <i>“Integrated Circuit Card Identifier, it is A SIM card's unique identification
         * number. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param iccid
         *            value of {@code iccid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iccid(String iccid) {
            this.iccid = iccid;
            this.changedFields = changedFields.add("iccid");
            return this;
        }

        /**
         * <i>“Unique Device Identifier for iOS and macOS devices. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param udid
         *            value of {@code udid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder udid(String udid) {
            this.udid = udid;
            this.changedFields = changedFields.add("udid");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for this Device instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for this Device instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tag IDs for this Device instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Count of active malware for this windows device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param windowsActiveMalwareCount
         *            value of {@code windowsActiveMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsActiveMalwareCount(Integer windowsActiveMalwareCount) {
            this.windowsActiveMalwareCount = windowsActiveMalwareCount;
            this.changedFields = changedFields.add("windowsActiveMalwareCount");
            return this;
        }

        /**
         * <i>“Count of remediated malware for this windows device. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param windowsRemediatedMalwareCount
         *            value of {@code windowsRemediatedMalwareCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsRemediatedMalwareCount(Integer windowsRemediatedMalwareCount) {
            this.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
            this.changedFields = changedFields.add("windowsRemediatedMalwareCount");
            return this;
        }

        /**
         * <i>“Notes on the device created by IT Admin”</i>
         * 
         * @param notes
         *            value of {@code notes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        /**
         * <i>“Configuration manager client health state, valid only for devices managed by MDM
         * /ConfigMgr Agent”</i>
         * 
         * @param configurationManagerClientHealthState
         *            value of {@code configurationManagerClientHealthState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationManagerClientHealthState(ConfigurationManagerClientHealthState configurationManagerClientHealthState) {
            this.configurationManagerClientHealthState = configurationManagerClientHealthState;
            this.changedFields = changedFields.add("configurationManagerClientHealthState");
            return this;
        }

        /**
         * <i>“Configuration manager client information, valid only for devices managed, duel-
         * managed or tri-managed by ConfigMgr Agent”</i>
         * 
         * @param configurationManagerClientInformation
         *            value of {@code configurationManagerClientInformation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationManagerClientInformation(ConfigurationManagerClientInformation configurationManagerClientInformation) {
            this.configurationManagerClientInformation = configurationManagerClientInformation;
            this.changedFields = changedFields.add("configurationManagerClientInformation");
            return this;
        }

        /**
         * <i>“Ethernet MAC. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param ethernetMacAddress
         *            value of {@code ethernetMacAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ethernetMacAddress(String ethernetMacAddress) {
            this.ethernetMacAddress = ethernetMacAddress;
            this.changedFields = changedFields.add("ethernetMacAddress");
            return this;
        }

        /**
         * <i>“Total Memory in Bytes. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param physicalMemoryInBytes
         *            value of {@code physicalMemoryInBytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder physicalMemoryInBytes(Long physicalMemoryInBytes) {
            this.physicalMemoryInBytes = physicalMemoryInBytes;
            this.changedFields = changedFields.add("physicalMemoryInBytes");
            return this;
        }

        /**
         * <i>“Processor architecture. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param processorArchitecture
         *            value of {@code processorArchitecture} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorArchitecture(ManagedDeviceArchitecture processorArchitecture) {
            this.processorArchitecture = processorArchitecture;
            this.changedFields = changedFields.add("processorArchitecture");
            return this;
        }

        /**
         * <i>“Specification version. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param specificationVersion
         *            value of {@code specificationVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder specificationVersion(String specificationVersion) {
            this.specificationVersion = specificationVersion;
            this.changedFields = changedFields.add("specificationVersion");
            return this;
        }

        /**
         * <i>“Device join type”</i>
         * 
         * @param joinType
         *            value of {@code joinType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder joinType(JoinType joinType) {
            this.joinType = joinType;
            this.changedFields = changedFields.add("joinType");
            return this;
        }

        /**
         * <i>“Device sku family”</i>
         * 
         * @param skuFamily
         *            value of {@code skuFamily} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder skuFamily(String skuFamily) {
            this.skuFamily = skuFamily;
            this.changedFields = changedFields.add("skuFamily");
            return this;
        }

        public ManagedDevice build() {
            ManagedDevice _x = new ManagedDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDevice";
            _x.id = id;
            _x.userId = userId;
            _x.deviceName = deviceName;
            _x.hardwareInformation = hardwareInformation;
            _x.ownerType = ownerType;
            _x.managedDeviceOwnerType = managedDeviceOwnerType;
            _x.deviceActionResults = deviceActionResults;
            _x.deviceActionResultsNextLink = deviceActionResultsNextLink;
            _x.managementState = managementState;
            _x.enrolledDateTime = enrolledDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.chassisType = chassisType;
            _x.operatingSystem = operatingSystem;
            _x.deviceType = deviceType;
            _x.complianceState = complianceState;
            _x.jailBroken = jailBroken;
            _x.managementAgent = managementAgent;
            _x.osVersion = osVersion;
            _x.easActivated = easActivated;
            _x.easDeviceId = easDeviceId;
            _x.easActivationDateTime = easActivationDateTime;
            _x.aadRegistered = aadRegistered;
            _x.azureADRegistered = azureADRegistered;
            _x.deviceEnrollmentType = deviceEnrollmentType;
            _x.lostModeState = lostModeState;
            _x.activationLockBypassCode = activationLockBypassCode;
            _x.emailAddress = emailAddress;
            _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
            _x.azureADDeviceId = azureADDeviceId;
            _x.deviceRegistrationState = deviceRegistrationState;
            _x.deviceCategoryDisplayName = deviceCategoryDisplayName;
            _x.isSupervised = isSupervised;
            _x.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
            _x.exchangeAccessState = exchangeAccessState;
            _x.exchangeAccessStateReason = exchangeAccessStateReason;
            _x.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
            _x.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
            _x.isEncrypted = isEncrypted;
            _x.userPrincipalName = userPrincipalName;
            _x.model = model;
            _x.manufacturer = manufacturer;
            _x.imei = imei;
            _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
            _x.serialNumber = serialNumber;
            _x.phoneNumber = phoneNumber;
            _x.androidSecurityPatchLevel = androidSecurityPatchLevel;
            _x.userDisplayName = userDisplayName;
            _x.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
            _x.wiFiMacAddress = wiFiMacAddress;
            _x.deviceHealthAttestationState = deviceHealthAttestationState;
            _x.subscriberCarrier = subscriberCarrier;
            _x.meid = meid;
            _x.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
            _x.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
            _x.managedDeviceName = managedDeviceName;
            _x.partnerReportedThreatState = partnerReportedThreatState;
            _x.retireAfterDateTime = retireAfterDateTime;
            _x.usersLoggedOn = usersLoggedOn;
            _x.usersLoggedOnNextLink = usersLoggedOnNextLink;
            _x.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
            _x.autopilotEnrolled = autopilotEnrolled;
            _x.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
            _x.managementCertificateExpirationDate = managementCertificateExpirationDate;
            _x.iccid = iccid;
            _x.udid = udid;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.windowsActiveMalwareCount = windowsActiveMalwareCount;
            _x.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
            _x.notes = notes;
            _x.configurationManagerClientHealthState = configurationManagerClientHealthState;
            _x.configurationManagerClientInformation = configurationManagerClientInformation;
            _x.ethernetMacAddress = ethernetMacAddress;
            _x.physicalMemoryInBytes = physicalMemoryInBytes;
            _x.processorArchitecture = processorArchitecture;
            _x.specificationVersion = specificationVersion;
            _x.joinType = joinType;
            _x.skuFamily = skuFamily;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Unique Identifier for the user associated with the device. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique Identifier for the user associated with the device. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public ManagedDevice withUserId(String userId) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“Name of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public ManagedDevice withDeviceName(String deviceName) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The hardward details for the device.  Includes information such as storage space
     * , manufacturer, serial number, etc. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property hardwareInformation
     */
    @Property(name="hardwareInformation")
    @JsonIgnore
    public Optional<HardwareInformation> getHardwareInformation() {
        return Optional.ofNullable(hardwareInformation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hardwareInformation} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The hardward details for the device.  Includes information such as storage space
     * , manufacturer, serial number, etc. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param hardwareInformation
     *            new value of {@code hardwareInformation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hardwareInformation} field changed
     */
    public ManagedDevice withHardwareInformation(HardwareInformation hardwareInformation) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("hardwareInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.hardwareInformation = hardwareInformation;
        return _x;
    }

    /**
     * <i>“Ownership of the device. Can be 'company' or 'personal'”</i>
     * 
     * @return property ownerType
     */
    @Property(name="ownerType")
    @JsonIgnore
    public Optional<OwnerType> getOwnerType() {
        return Optional.ofNullable(ownerType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ownerType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Ownership of the device. Can be 'company' or 'personal'”</i>
     * 
     * @param ownerType
     *            new value of {@code ownerType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerType} field changed
     */
    public ManagedDevice withOwnerType(OwnerType ownerType) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("ownerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.ownerType = ownerType;
        return _x;
    }

    /**
     * <i>“Ownership of the device. Can be 'company' or 'personal'”</i>
     * 
     * @return property managedDeviceOwnerType
     */
    @Property(name="managedDeviceOwnerType")
    @JsonIgnore
    public Optional<ManagedDeviceOwnerType> getManagedDeviceOwnerType() {
        return Optional.ofNullable(managedDeviceOwnerType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceOwnerType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Ownership of the device. Can be 'company' or 'personal'”</i>
     * 
     * @param managedDeviceOwnerType
     *            new value of {@code managedDeviceOwnerType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceOwnerType} field changed
     */
    public ManagedDevice withManagedDeviceOwnerType(ManagedDeviceOwnerType managedDeviceOwnerType) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceOwnerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.managedDeviceOwnerType = managedDeviceOwnerType;
        return _x;
    }

    /**
     * <i>“List of ComplexType deviceActionResult objects. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceActionResults
     */
    @Property(name="deviceActionResults")
    @JsonIgnore
    public CollectionPage<DeviceActionResult> getDeviceActionResults() {
        return new CollectionPage<DeviceActionResult>(contextPath, DeviceActionResult.class, deviceActionResults, Optional.ofNullable(deviceActionResultsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of ComplexType deviceActionResult objects. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceActionResults
     */
    @Property(name="deviceActionResults")
    @JsonIgnore
    public CollectionPage<DeviceActionResult> getDeviceActionResults(HttpRequestOptions options) {
        return new CollectionPage<DeviceActionResult>(contextPath, DeviceActionResult.class, deviceActionResults, Optional.ofNullable(deviceActionResultsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Management state of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property managementState
     */
    @Property(name="managementState")
    @JsonIgnore
    public Optional<ManagementState> getManagementState() {
        return Optional.ofNullable(managementState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managementState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Management state of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param managementState
     *            new value of {@code managementState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementState} field changed
     */
    public ManagedDevice withManagementState(ManagementState managementState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("managementState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.managementState = managementState;
        return _x;
    }

    /**
     * <i>“Enrollment time of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property enrolledDateTime
     */
    @Property(name="enrolledDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnrolledDateTime() {
        return Optional.ofNullable(enrolledDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrolledDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enrollment time of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param enrolledDateTime
     *            new value of {@code enrolledDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrolledDateTime} field changed
     */
    public ManagedDevice withEnrolledDateTime(OffsetDateTime enrolledDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("enrolledDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.enrolledDateTime = enrolledDateTime;
        return _x;
    }

    /**
     * <i>“The date and time that the device last completed a successful sync with Intune.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time that the device last completed a successful sync with Intune.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public ManagedDevice withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Chassis type of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property chassisType
     */
    @Property(name="chassisType")
    @JsonIgnore
    public Optional<ChassisType> getChassisType() {
        return Optional.ofNullable(chassisType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code chassisType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Chassis type of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param chassisType
     *            new value of {@code chassisType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code chassisType} field changed
     */
    public ManagedDevice withChassisType(ChassisType chassisType) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("chassisType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.chassisType = chassisType;
        return _x;
    }

    /**
     * <i>“Operating system of the device. Windows, iOS, etc. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property operatingSystem
     */
    @Property(name="operatingSystem")
    @JsonIgnore
    public Optional<String> getOperatingSystem() {
        return Optional.ofNullable(operatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operatingSystem}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Operating system of the device. Windows, iOS, etc. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param operatingSystem
     *            new value of {@code operatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystem} field changed
     */
    public ManagedDevice withOperatingSystem(String operatingSystem) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("operatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.operatingSystem = operatingSystem;
        return _x;
    }

    /**
     * <i>“Platform of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<DeviceType> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platform of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public ManagedDevice withDeviceType(DeviceType deviceType) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“Compliance state of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property complianceState
     */
    @Property(name="complianceState")
    @JsonIgnore
    public Optional<ComplianceState> getComplianceState() {
        return Optional.ofNullable(complianceState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code complianceState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Compliance state of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param complianceState
     *            new value of {@code complianceState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceState} field changed
     */
    public ManagedDevice withComplianceState(ComplianceState complianceState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("complianceState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.complianceState = complianceState;
        return _x;
    }

    /**
     * <i>“whether the device is jail broken or rooted. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property jailBroken
     */
    @Property(name="jailBroken")
    @JsonIgnore
    public Optional<String> getJailBroken() {
        return Optional.ofNullable(jailBroken);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code jailBroken} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“whether the device is jail broken or rooted. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param jailBroken
     *            new value of {@code jailBroken} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code jailBroken} field changed
     */
    public ManagedDevice withJailBroken(String jailBroken) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("jailBroken");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.jailBroken = jailBroken;
        return _x;
    }

    /**
     * <i>“Management channel of the device. Intune, EAS, etc. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property managementAgent
     */
    @Property(name="managementAgent")
    @JsonIgnore
    public Optional<ManagementAgentType> getManagementAgent() {
        return Optional.ofNullable(managementAgent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managementAgent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Management channel of the device. Intune, EAS, etc. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param managementAgent
     *            new value of {@code managementAgent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementAgent} field changed
     */
    public ManagedDevice withManagementAgent(ManagementAgentType managementAgent) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("managementAgent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.managementAgent = managementAgent;
        return _x;
    }

    /**
     * <i>“Operating system version of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Operating system version of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public ManagedDevice withOsVersion(String osVersion) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“Whether the device is Exchange ActiveSync activated. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property easActivated
     */
    @Property(name="easActivated")
    @JsonIgnore
    public Optional<Boolean> getEasActivated() {
        return Optional.ofNullable(easActivated);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code easActivated}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the device is Exchange ActiveSync activated. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param easActivated
     *            new value of {@code easActivated} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code easActivated} field changed
     */
    public ManagedDevice withEasActivated(Boolean easActivated) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("easActivated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.easActivated = easActivated;
        return _x;
    }

    /**
     * <i>“Exchange ActiveSync Id of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property easDeviceId
     */
    @Property(name="easDeviceId")
    @JsonIgnore
    public Optional<String> getEasDeviceId() {
        return Optional.ofNullable(easDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code easDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Exchange ActiveSync Id of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param easDeviceId
     *            new value of {@code easDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code easDeviceId} field changed
     */
    public ManagedDevice withEasDeviceId(String easDeviceId) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("easDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.easDeviceId = easDeviceId;
        return _x;
    }

    /**
     * <i>“Exchange ActivationSync activation time of the device. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property easActivationDateTime
     */
    @Property(name="easActivationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEasActivationDateTime() {
        return Optional.ofNullable(easActivationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * easActivationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Exchange ActivationSync activation time of the device. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param easActivationDateTime
     *            new value of {@code easActivationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code easActivationDateTime} field changed
     */
    public ManagedDevice withEasActivationDateTime(OffsetDateTime easActivationDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("easActivationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.easActivationDateTime = easActivationDateTime;
        return _x;
    }

    /**
     * <i>“Whether the device is Azure Active Directory registered. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property aadRegistered
     */
    @Property(name="aadRegistered")
    @JsonIgnore
    public Optional<Boolean> getAadRegistered() {
        return Optional.ofNullable(aadRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code aadRegistered}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the device is Azure Active Directory registered. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param aadRegistered
     *            new value of {@code aadRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code aadRegistered} field changed
     */
    public ManagedDevice withAadRegistered(Boolean aadRegistered) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("aadRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.aadRegistered = aadRegistered;
        return _x;
    }

    /**
     * <i>“Whether the device is Azure Active Directory registered. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property azureADRegistered
     */
    @Property(name="azureADRegistered")
    @JsonIgnore
    public Optional<Boolean> getAzureADRegistered() {
        return Optional.ofNullable(azureADRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureADRegistered
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the device is Azure Active Directory registered. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param azureADRegistered
     *            new value of {@code azureADRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureADRegistered} field changed
     */
    public ManagedDevice withAzureADRegistered(Boolean azureADRegistered) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("azureADRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.azureADRegistered = azureADRegistered;
        return _x;
    }

    /**
     * <i>“Enrollment type of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceEnrollmentType
     */
    @Property(name="deviceEnrollmentType")
    @JsonIgnore
    public Optional<DeviceEnrollmentType> getDeviceEnrollmentType() {
        return Optional.ofNullable(deviceEnrollmentType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceEnrollmentType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enrollment type of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceEnrollmentType
     *            new value of {@code deviceEnrollmentType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceEnrollmentType} field changed
     */
    public ManagedDevice withDeviceEnrollmentType(DeviceEnrollmentType deviceEnrollmentType) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceEnrollmentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.deviceEnrollmentType = deviceEnrollmentType;
        return _x;
    }

    /**
     * <i>“Indicates if Lost mode is enabled or disabled. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lostModeState
     */
    @Property(name="lostModeState")
    @JsonIgnore
    public Optional<LostModeState> getLostModeState() {
        return Optional.ofNullable(lostModeState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lostModeState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Lost mode is enabled or disabled. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lostModeState
     *            new value of {@code lostModeState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lostModeState} field changed
     */
    public ManagedDevice withLostModeState(LostModeState lostModeState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("lostModeState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.lostModeState = lostModeState;
        return _x;
    }

    /**
     * <i>“Code that allows the Activation Lock on a device to be bypassed. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property activationLockBypassCode
     */
    @Property(name="activationLockBypassCode")
    @JsonIgnore
    public Optional<String> getActivationLockBypassCode() {
        return Optional.ofNullable(activationLockBypassCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activationLockBypassCode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Code that allows the Activation Lock on a device to be bypassed. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param activationLockBypassCode
     *            new value of {@code activationLockBypassCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activationLockBypassCode} field changed
     */
    public ManagedDevice withActivationLockBypassCode(String activationLockBypassCode) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("activationLockBypassCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.activationLockBypassCode = activationLockBypassCode;
        return _x;
    }

    /**
     * <i>“Email(s) for the user associated with the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property emailAddress
     */
    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code emailAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Email(s) for the user associated with the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param emailAddress
     *            new value of {@code emailAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailAddress} field changed
     */
    public ManagedDevice withEmailAddress(String emailAddress) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.emailAddress = emailAddress;
        return _x;
    }

    /**
     * <i>“The unique identifier for the Azure Active Directory device. Read only. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property azureActiveDirectoryDeviceId
     */
    @Property(name="azureActiveDirectoryDeviceId")
    @JsonIgnore
    public Optional<String> getAzureActiveDirectoryDeviceId() {
        return Optional.ofNullable(azureActiveDirectoryDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * azureActiveDirectoryDeviceId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The unique identifier for the Azure Active Directory device. Read only. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param azureActiveDirectoryDeviceId
     *            new value of {@code azureActiveDirectoryDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureActiveDirectoryDeviceId} field changed
     */
    public ManagedDevice withAzureActiveDirectoryDeviceId(String azureActiveDirectoryDeviceId) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("azureActiveDirectoryDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
        return _x;
    }

    /**
     * <i>“The unique identifier for the Azure Active Directory device. Read only. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property azureADDeviceId
     */
    @Property(name="azureADDeviceId")
    @JsonIgnore
    public Optional<String> getAzureADDeviceId() {
        return Optional.ofNullable(azureADDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureADDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The unique identifier for the Azure Active Directory device. Read only. This
     * property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param azureADDeviceId
     *            new value of {@code azureADDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureADDeviceId} field changed
     */
    public ManagedDevice withAzureADDeviceId(String azureADDeviceId) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("azureADDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.azureADDeviceId = azureADDeviceId;
        return _x;
    }

    /**
     * <i>“Device registration state. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceRegistrationState
     */
    @Property(name="deviceRegistrationState")
    @JsonIgnore
    public Optional<DeviceRegistrationState> getDeviceRegistrationState() {
        return Optional.ofNullable(deviceRegistrationState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceRegistrationState} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device registration state. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceRegistrationState
     *            new value of {@code deviceRegistrationState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRegistrationState} field changed
     */
    public ManagedDevice withDeviceRegistrationState(DeviceRegistrationState deviceRegistrationState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceRegistrationState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.deviceRegistrationState = deviceRegistrationState;
        return _x;
    }

    /**
     * <i>“Device category display name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceCategoryDisplayName
     */
    @Property(name="deviceCategoryDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceCategoryDisplayName() {
        return Optional.ofNullable(deviceCategoryDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCategoryDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device category display name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceCategoryDisplayName
     *            new value of {@code deviceCategoryDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCategoryDisplayName} field changed
     */
    public ManagedDevice withDeviceCategoryDisplayName(String deviceCategoryDisplayName) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceCategoryDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.deviceCategoryDisplayName = deviceCategoryDisplayName;
        return _x;
    }

    /**
     * <i>“Device supervised status. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property isSupervised
     */
    @Property(name="isSupervised")
    @JsonIgnore
    public Optional<Boolean> getIsSupervised() {
        return Optional.ofNullable(isSupervised);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSupervised}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device supervised status. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param isSupervised
     *            new value of {@code isSupervised} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSupervised} field changed
     */
    public ManagedDevice withIsSupervised(Boolean isSupervised) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("isSupervised");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.isSupervised = isSupervised;
        return _x;
    }

    /**
     * <i>“Last time the device contacted Exchange. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property exchangeLastSuccessfulSyncDateTime
     */
    @Property(name="exchangeLastSuccessfulSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExchangeLastSuccessfulSyncDateTime() {
        return Optional.ofNullable(exchangeLastSuccessfulSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeLastSuccessfulSyncDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Last time the device contacted Exchange. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param exchangeLastSuccessfulSyncDateTime
     *            new value of {@code exchangeLastSuccessfulSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeLastSuccessfulSyncDateTime} field changed
     */
    public ManagedDevice withExchangeLastSuccessfulSyncDateTime(OffsetDateTime exchangeLastSuccessfulSyncDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("exchangeLastSuccessfulSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
        return _x;
    }

    /**
     * <i>“The Access State of the device in Exchange. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property exchangeAccessState
     */
    @Property(name="exchangeAccessState")
    @JsonIgnore
    public Optional<DeviceManagementExchangeAccessState> getExchangeAccessState() {
        return Optional.ofNullable(exchangeAccessState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeAccessState} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Access State of the device in Exchange. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param exchangeAccessState
     *            new value of {@code exchangeAccessState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeAccessState} field changed
     */
    public ManagedDevice withExchangeAccessState(DeviceManagementExchangeAccessState exchangeAccessState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("exchangeAccessState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.exchangeAccessState = exchangeAccessState;
        return _x;
    }

    /**
     * <i>“The reason for the device's access state in Exchange. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property exchangeAccessStateReason
     */
    @Property(name="exchangeAccessStateReason")
    @JsonIgnore
    public Optional<DeviceManagementExchangeAccessStateReason> getExchangeAccessStateReason() {
        return Optional.ofNullable(exchangeAccessStateReason);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exchangeAccessStateReason} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The reason for the device's access state in Exchange. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param exchangeAccessStateReason
     *            new value of {@code exchangeAccessStateReason} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exchangeAccessStateReason} field changed
     */
    public ManagedDevice withExchangeAccessStateReason(DeviceManagementExchangeAccessStateReason exchangeAccessStateReason) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("exchangeAccessStateReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.exchangeAccessStateReason = exchangeAccessStateReason;
        return _x;
    }

    /**
     * <i>“Url that allows a Remote Assistance session to be established with the device.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property remoteAssistanceSessionUrl
     */
    @Property(name="remoteAssistanceSessionUrl")
    @JsonIgnore
    public Optional<String> getRemoteAssistanceSessionUrl() {
        return Optional.ofNullable(remoteAssistanceSessionUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remoteAssistanceSessionUrl} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Url that allows a Remote Assistance session to be established with the device.
     * This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param remoteAssistanceSessionUrl
     *            new value of {@code remoteAssistanceSessionUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteAssistanceSessionUrl} field changed
     */
    public ManagedDevice withRemoteAssistanceSessionUrl(String remoteAssistanceSessionUrl) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("remoteAssistanceSessionUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
        return _x;
    }

    /**
     * <i>“An error string that identifies issues when creating Remote Assistance session
     * objects. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property remoteAssistanceSessionErrorDetails
     */
    @Property(name="remoteAssistanceSessionErrorDetails")
    @JsonIgnore
    public Optional<String> getRemoteAssistanceSessionErrorDetails() {
        return Optional.ofNullable(remoteAssistanceSessionErrorDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remoteAssistanceSessionErrorDetails} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“An error string that identifies issues when creating Remote Assistance session
     * objects. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param remoteAssistanceSessionErrorDetails
     *            new value of {@code remoteAssistanceSessionErrorDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteAssistanceSessionErrorDetails} field changed
     */
    public ManagedDevice withRemoteAssistanceSessionErrorDetails(String remoteAssistanceSessionErrorDetails) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("remoteAssistanceSessionErrorDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
        return _x;
    }

    /**
     * <i>“Device encryption status. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property isEncrypted
     */
    @Property(name="isEncrypted")
    @JsonIgnore
    public Optional<Boolean> getIsEncrypted() {
        return Optional.ofNullable(isEncrypted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isEncrypted}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device encryption status. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param isEncrypted
     *            new value of {@code isEncrypted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEncrypted} field changed
     */
    public ManagedDevice withIsEncrypted(Boolean isEncrypted) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("isEncrypted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.isEncrypted = isEncrypted;
        return _x;
    }

    /**
     * <i>“Device user principal name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device user principal name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public ManagedDevice withUserPrincipalName(String userPrincipalName) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Model of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Model of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public ManagedDevice withModel(String model) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“Manufacturer of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Manufacturer of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public ManagedDevice withManufacturer(String manufacturer) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“IMEI. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property imei
     */
    @Property(name="imei")
    @JsonIgnore
    public Optional<String> getImei() {
        return Optional.ofNullable(imei);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code imei} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“IMEI. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param imei
     *            new value of {@code imei} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code imei} field changed
     */
    public ManagedDevice withImei(String imei) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("imei");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.imei = imei;
        return _x;
    }

    /**
     * <i>“The DateTime when device compliance grace period expires. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property complianceGracePeriodExpirationDateTime
     */
    @Property(name="complianceGracePeriodExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getComplianceGracePeriodExpirationDateTime() {
        return Optional.ofNullable(complianceGracePeriodExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * complianceGracePeriodExpirationDateTime} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The DateTime when device compliance grace period expires. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param complianceGracePeriodExpirationDateTime
     *            new value of {@code complianceGracePeriodExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceGracePeriodExpirationDateTime} field changed
     */
    public ManagedDevice withComplianceGracePeriodExpirationDateTime(OffsetDateTime complianceGracePeriodExpirationDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("complianceGracePeriodExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        return _x;
    }

    /**
     * <i>“SerialNumber. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SerialNumber. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public ManagedDevice withSerialNumber(String serialNumber) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“Phone number of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property phoneNumber
     */
    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code phoneNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Phone number of the device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param phoneNumber
     *            new value of {@code phoneNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code phoneNumber} field changed
     */
    public ManagedDevice withPhoneNumber(String phoneNumber) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    /**
     * <i>“Android security patch level. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property androidSecurityPatchLevel
     */
    @Property(name="androidSecurityPatchLevel")
    @JsonIgnore
    public Optional<String> getAndroidSecurityPatchLevel() {
        return Optional.ofNullable(androidSecurityPatchLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidSecurityPatchLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android security patch level. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param androidSecurityPatchLevel
     *            new value of {@code androidSecurityPatchLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidSecurityPatchLevel} field changed
     */
    public ManagedDevice withAndroidSecurityPatchLevel(String androidSecurityPatchLevel) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("androidSecurityPatchLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.androidSecurityPatchLevel = androidSecurityPatchLevel;
        return _x;
    }

    /**
     * <i>“User display name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property userDisplayName
     */
    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User display name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param userDisplayName
     *            new value of {@code userDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDisplayName} field changed
     */
    public ManagedDevice withUserDisplayName(String userDisplayName) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    /**
     * <i>“ConfigrMgr client enabled features. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property configurationManagerClientEnabledFeatures
     */
    @Property(name="configurationManagerClientEnabledFeatures")
    @JsonIgnore
    public Optional<ConfigurationManagerClientEnabledFeatures> getConfigurationManagerClientEnabledFeatures() {
        return Optional.ofNullable(configurationManagerClientEnabledFeatures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationManagerClientEnabledFeatures} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“ConfigrMgr client enabled features. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param configurationManagerClientEnabledFeatures
     *            new value of {@code configurationManagerClientEnabledFeatures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationManagerClientEnabledFeatures} field changed
     */
    public ManagedDevice withConfigurationManagerClientEnabledFeatures(ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("configurationManagerClientEnabledFeatures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
        return _x;
    }

    /**
     * <i>“Wi-Fi MAC. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property wiFiMacAddress
     */
    @Property(name="wiFiMacAddress")
    @JsonIgnore
    public Optional<String> getWiFiMacAddress() {
        return Optional.ofNullable(wiFiMacAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wiFiMacAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Wi-Fi MAC. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param wiFiMacAddress
     *            new value of {@code wiFiMacAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiMacAddress} field changed
     */
    public ManagedDevice withWiFiMacAddress(String wiFiMacAddress) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("wiFiMacAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.wiFiMacAddress = wiFiMacAddress;
        return _x;
    }

    /**
     * <i>“The device health attestation state. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property deviceHealthAttestationState
     */
    @Property(name="deviceHealthAttestationState")
    @JsonIgnore
    public Optional<DeviceHealthAttestationState> getDeviceHealthAttestationState() {
        return Optional.ofNullable(deviceHealthAttestationState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceHealthAttestationState} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The device health attestation state. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param deviceHealthAttestationState
     *            new value of {@code deviceHealthAttestationState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceHealthAttestationState} field changed
     */
    public ManagedDevice withDeviceHealthAttestationState(DeviceHealthAttestationState deviceHealthAttestationState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceHealthAttestationState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.deviceHealthAttestationState = deviceHealthAttestationState;
        return _x;
    }

    /**
     * <i>“Subscriber Carrier. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property subscriberCarrier
     */
    @Property(name="subscriberCarrier")
    @JsonIgnore
    public Optional<String> getSubscriberCarrier() {
        return Optional.ofNullable(subscriberCarrier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriberCarrier
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Subscriber Carrier. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param subscriberCarrier
     *            new value of {@code subscriberCarrier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriberCarrier} field changed
     */
    public ManagedDevice withSubscriberCarrier(String subscriberCarrier) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("subscriberCarrier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.subscriberCarrier = subscriberCarrier;
        return _x;
    }

    /**
     * <i>“MEID. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property meid
     */
    @Property(name="meid")
    @JsonIgnore
    public Optional<String> getMeid() {
        return Optional.ofNullable(meid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code meid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“MEID. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param meid
     *            new value of {@code meid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meid} field changed
     */
    public ManagedDevice withMeid(String meid) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("meid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.meid = meid;
        return _x;
    }

    /**
     * <i>“Total Storage in Bytes. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property totalStorageSpaceInBytes
     */
    @Property(name="totalStorageSpaceInBytes")
    @JsonIgnore
    public Optional<Long> getTotalStorageSpaceInBytes() {
        return Optional.ofNullable(totalStorageSpaceInBytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalStorageSpaceInBytes} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Total Storage in Bytes. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param totalStorageSpaceInBytes
     *            new value of {@code totalStorageSpaceInBytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalStorageSpaceInBytes} field changed
     */
    public ManagedDevice withTotalStorageSpaceInBytes(Long totalStorageSpaceInBytes) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("totalStorageSpaceInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
        return _x;
    }

    /**
     * <i>“Free Storage in Bytes. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property freeStorageSpaceInBytes
     */
    @Property(name="freeStorageSpaceInBytes")
    @JsonIgnore
    public Optional<Long> getFreeStorageSpaceInBytes() {
        return Optional.ofNullable(freeStorageSpaceInBytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * freeStorageSpaceInBytes} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Free Storage in Bytes. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param freeStorageSpaceInBytes
     *            new value of {@code freeStorageSpaceInBytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code freeStorageSpaceInBytes} field changed
     */
    public ManagedDevice withFreeStorageSpaceInBytes(Long freeStorageSpaceInBytes) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("freeStorageSpaceInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
        return _x;
    }

    /**
     * <i>“Automatically generated name to identify a device. Can be overwritten to a user
     * friendly name.”</i>
     * 
     * @return property managedDeviceName
     */
    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Automatically generated name to identify a device. Can be overwritten to a user
     * friendly name.”</i>
     * 
     * @param managedDeviceName
     *            new value of {@code managedDeviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceName} field changed
     */
    public ManagedDevice withManagedDeviceName(String managedDeviceName) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    /**
     * <i>“Indicates the threat state of a device when a Mobile Threat Defense partner is
     * in use by the account and device. Read Only. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property partnerReportedThreatState
     */
    @Property(name="partnerReportedThreatState")
    @JsonIgnore
    public Optional<ManagedDevicePartnerReportedHealthState> getPartnerReportedThreatState() {
        return Optional.ofNullable(partnerReportedThreatState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * partnerReportedThreatState} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates the threat state of a device when a Mobile Threat Defense partner is
     * in use by the account and device. Read Only. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param partnerReportedThreatState
     *            new value of {@code partnerReportedThreatState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerReportedThreatState} field changed
     */
    public ManagedDevice withPartnerReportedThreatState(ManagedDevicePartnerReportedHealthState partnerReportedThreatState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("partnerReportedThreatState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.partnerReportedThreatState = partnerReportedThreatState;
        return _x;
    }

    /**
     * <i>“Indicates the time after when a device will be auto retired because of scheduled
     * action. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property retireAfterDateTime
     */
    @Property(name="retireAfterDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRetireAfterDateTime() {
        return Optional.ofNullable(retireAfterDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * retireAfterDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the time after when a device will be auto retired because of scheduled
     * action. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param retireAfterDateTime
     *            new value of {@code retireAfterDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code retireAfterDateTime} field changed
     */
    public ManagedDevice withRetireAfterDateTime(OffsetDateTime retireAfterDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("retireAfterDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.retireAfterDateTime = retireAfterDateTime;
        return _x;
    }

    /**
     * <i>“Indicates the last logged on users of a device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property usersLoggedOn
     */
    @Property(name="usersLoggedOn")
    @JsonIgnore
    public CollectionPage<LoggedOnUser> getUsersLoggedOn() {
        return new CollectionPage<LoggedOnUser>(contextPath, LoggedOnUser.class, usersLoggedOn, Optional.ofNullable(usersLoggedOnNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Indicates the last logged on users of a device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property usersLoggedOn
     */
    @Property(name="usersLoggedOn")
    @JsonIgnore
    public CollectionPage<LoggedOnUser> getUsersLoggedOn(HttpRequestOptions options) {
        return new CollectionPage<LoggedOnUser>(contextPath, LoggedOnUser.class, usersLoggedOn, Optional.ofNullable(usersLoggedOnNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Reports the DateTime the preferMdmOverGroupPolicy setting was set.  When set,
     * the Intune MDM settings will override Group Policy settings if there is a
     * conflict. Read Only. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property preferMdmOverGroupPolicyAppliedDateTime
     */
    @Property(name="preferMdmOverGroupPolicyAppliedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getPreferMdmOverGroupPolicyAppliedDateTime() {
        return Optional.ofNullable(preferMdmOverGroupPolicyAppliedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * preferMdmOverGroupPolicyAppliedDateTime} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Reports the DateTime the preferMdmOverGroupPolicy setting was set.  When set,
     * the Intune MDM settings will override Group Policy settings if there is a
     * conflict. Read Only. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param preferMdmOverGroupPolicyAppliedDateTime
     *            new value of {@code preferMdmOverGroupPolicyAppliedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code preferMdmOverGroupPolicyAppliedDateTime} field changed
     */
    public ManagedDevice withPreferMdmOverGroupPolicyAppliedDateTime(OffsetDateTime preferMdmOverGroupPolicyAppliedDateTime) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("preferMdmOverGroupPolicyAppliedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
        return _x;
    }

    /**
     * <i>“Reports if the managed device is enrolled via auto-pilot. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property autopilotEnrolled
     */
    @Property(name="autopilotEnrolled")
    @JsonIgnore
    public Optional<Boolean> getAutopilotEnrolled() {
        return Optional.ofNullable(autopilotEnrolled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autopilotEnrolled
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Reports if the managed device is enrolled via auto-pilot. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param autopilotEnrolled
     *            new value of {@code autopilotEnrolled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autopilotEnrolled} field changed
     */
    public ManagedDevice withAutopilotEnrolled(Boolean autopilotEnrolled) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("autopilotEnrolled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.autopilotEnrolled = autopilotEnrolled;
        return _x;
    }

    /**
     * <i>“Reports if the managed iOS device is user approval enrollment. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property requireUserEnrollmentApproval
     */
    @Property(name="requireUserEnrollmentApproval")
    @JsonIgnore
    public Optional<Boolean> getRequireUserEnrollmentApproval() {
        return Optional.ofNullable(requireUserEnrollmentApproval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireUserEnrollmentApproval} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Reports if the managed iOS device is user approval enrollment. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param requireUserEnrollmentApproval
     *            new value of {@code requireUserEnrollmentApproval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireUserEnrollmentApproval} field changed
     */
    public ManagedDevice withRequireUserEnrollmentApproval(Boolean requireUserEnrollmentApproval) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("requireUserEnrollmentApproval");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
        return _x;
    }

    /**
     * <i>“Reports device management certificate expiration date. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property managementCertificateExpirationDate
     */
    @Property(name="managementCertificateExpirationDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getManagementCertificateExpirationDate() {
        return Optional.ofNullable(managementCertificateExpirationDate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managementCertificateExpirationDate} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Reports device management certificate expiration date. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param managementCertificateExpirationDate
     *            new value of {@code managementCertificateExpirationDate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementCertificateExpirationDate} field changed
     */
    public ManagedDevice withManagementCertificateExpirationDate(OffsetDateTime managementCertificateExpirationDate) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("managementCertificateExpirationDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.managementCertificateExpirationDate = managementCertificateExpirationDate;
        return _x;
    }

    /**
     * <i>“Integrated Circuit Card Identifier, it is A SIM card's unique identification
     * number. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property iccid
     */
    @Property(name="iccid")
    @JsonIgnore
    public Optional<String> getIccid() {
        return Optional.ofNullable(iccid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iccid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Integrated Circuit Card Identifier, it is A SIM card's unique identification
     * number. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param iccid
     *            new value of {@code iccid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iccid} field changed
     */
    public ManagedDevice withIccid(String iccid) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("iccid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.iccid = iccid;
        return _x;
    }

    /**
     * <i>“Unique Device Identifier for iOS and macOS devices. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property udid
     */
    @Property(name="udid")
    @JsonIgnore
    public Optional<String> getUdid() {
        return Optional.ofNullable(udid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code udid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique Device Identifier for iOS and macOS devices. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param udid
     *            new value of {@code udid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code udid} field changed
     */
    public ManagedDevice withUdid(String udid) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("udid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.udid = udid;
        return _x;
    }

    /**
     * <i>“List of Scope Tag IDs for this Device instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tag IDs for this Device instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Count of active malware for this windows device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property windowsActiveMalwareCount
     */
    @Property(name="windowsActiveMalwareCount")
    @JsonIgnore
    public Optional<Integer> getWindowsActiveMalwareCount() {
        return Optional.ofNullable(windowsActiveMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsActiveMalwareCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Count of active malware for this windows device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param windowsActiveMalwareCount
     *            new value of {@code windowsActiveMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsActiveMalwareCount} field changed
     */
    public ManagedDevice withWindowsActiveMalwareCount(Integer windowsActiveMalwareCount) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("windowsActiveMalwareCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.windowsActiveMalwareCount = windowsActiveMalwareCount;
        return _x;
    }

    /**
     * <i>“Count of remediated malware for this windows device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property windowsRemediatedMalwareCount
     */
    @Property(name="windowsRemediatedMalwareCount")
    @JsonIgnore
    public Optional<Integer> getWindowsRemediatedMalwareCount() {
        return Optional.ofNullable(windowsRemediatedMalwareCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsRemediatedMalwareCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Count of remediated malware for this windows device. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param windowsRemediatedMalwareCount
     *            new value of {@code windowsRemediatedMalwareCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsRemediatedMalwareCount} field changed
     */
    public ManagedDevice withWindowsRemediatedMalwareCount(Integer windowsRemediatedMalwareCount) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("windowsRemediatedMalwareCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
        return _x;
    }

    /**
     * <i>“Notes on the device created by IT Admin”</i>
     * 
     * @return property notes
     */
    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code notes} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Notes on the device created by IT Admin”</i>
     * 
     * @param notes
     *            new value of {@code notes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notes} field changed
     */
    public ManagedDevice withNotes(String notes) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.notes = notes;
        return _x;
    }

    /**
     * <i>“Configuration manager client health state, valid only for devices managed by MDM
     * /ConfigMgr Agent”</i>
     * 
     * @return property configurationManagerClientHealthState
     */
    @Property(name="configurationManagerClientHealthState")
    @JsonIgnore
    public Optional<ConfigurationManagerClientHealthState> getConfigurationManagerClientHealthState() {
        return Optional.ofNullable(configurationManagerClientHealthState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationManagerClientHealthState} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configuration manager client health state, valid only for devices managed by MDM
     * /ConfigMgr Agent”</i>
     * 
     * @param configurationManagerClientHealthState
     *            new value of {@code configurationManagerClientHealthState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationManagerClientHealthState} field changed
     */
    public ManagedDevice withConfigurationManagerClientHealthState(ConfigurationManagerClientHealthState configurationManagerClientHealthState) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("configurationManagerClientHealthState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.configurationManagerClientHealthState = configurationManagerClientHealthState;
        return _x;
    }

    /**
     * <i>“Configuration manager client information, valid only for devices managed, duel-
     * managed or tri-managed by ConfigMgr Agent”</i>
     * 
     * @return property configurationManagerClientInformation
     */
    @Property(name="configurationManagerClientInformation")
    @JsonIgnore
    public Optional<ConfigurationManagerClientInformation> getConfigurationManagerClientInformation() {
        return Optional.ofNullable(configurationManagerClientInformation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationManagerClientInformation} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configuration manager client information, valid only for devices managed, duel-
     * managed or tri-managed by ConfigMgr Agent”</i>
     * 
     * @param configurationManagerClientInformation
     *            new value of {@code configurationManagerClientInformation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationManagerClientInformation} field changed
     */
    public ManagedDevice withConfigurationManagerClientInformation(ConfigurationManagerClientInformation configurationManagerClientInformation) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("configurationManagerClientInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.configurationManagerClientInformation = configurationManagerClientInformation;
        return _x;
    }

    /**
     * <i>“Ethernet MAC. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property ethernetMacAddress
     */
    @Property(name="ethernetMacAddress")
    @JsonIgnore
    public Optional<String> getEthernetMacAddress() {
        return Optional.ofNullable(ethernetMacAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ethernetMacAddress} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Ethernet MAC. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param ethernetMacAddress
     *            new value of {@code ethernetMacAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ethernetMacAddress} field changed
     */
    public ManagedDevice withEthernetMacAddress(String ethernetMacAddress) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("ethernetMacAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.ethernetMacAddress = ethernetMacAddress;
        return _x;
    }

    /**
     * <i>“Total Memory in Bytes. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property physicalMemoryInBytes
     */
    @Property(name="physicalMemoryInBytes")
    @JsonIgnore
    public Optional<Long> getPhysicalMemoryInBytes() {
        return Optional.ofNullable(physicalMemoryInBytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * physicalMemoryInBytes} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total Memory in Bytes. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param physicalMemoryInBytes
     *            new value of {@code physicalMemoryInBytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code physicalMemoryInBytes} field changed
     */
    public ManagedDevice withPhysicalMemoryInBytes(Long physicalMemoryInBytes) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("physicalMemoryInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.physicalMemoryInBytes = physicalMemoryInBytes;
        return _x;
    }

    /**
     * <i>“Processor architecture. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property processorArchitecture
     */
    @Property(name="processorArchitecture")
    @JsonIgnore
    public Optional<ManagedDeviceArchitecture> getProcessorArchitecture() {
        return Optional.ofNullable(processorArchitecture);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorArchitecture} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Processor architecture. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param processorArchitecture
     *            new value of {@code processorArchitecture} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorArchitecture} field changed
     */
    public ManagedDevice withProcessorArchitecture(ManagedDeviceArchitecture processorArchitecture) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("processorArchitecture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.processorArchitecture = processorArchitecture;
        return _x;
    }

    /**
     * <i>“Specification version. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property specificationVersion
     */
    @Property(name="specificationVersion")
    @JsonIgnore
    public Optional<String> getSpecificationVersion() {
        return Optional.ofNullable(specificationVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * specificationVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specification version. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param specificationVersion
     *            new value of {@code specificationVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code specificationVersion} field changed
     */
    public ManagedDevice withSpecificationVersion(String specificationVersion) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("specificationVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.specificationVersion = specificationVersion;
        return _x;
    }

    /**
     * <i>“Device join type”</i>
     * 
     * @return property joinType
     */
    @Property(name="joinType")
    @JsonIgnore
    public Optional<JoinType> getJoinType() {
        return Optional.ofNullable(joinType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code joinType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device join type”</i>
     * 
     * @param joinType
     *            new value of {@code joinType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code joinType} field changed
     */
    public ManagedDevice withJoinType(JoinType joinType) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("joinType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.joinType = joinType;
        return _x;
    }

    /**
     * <i>“Device sku family”</i>
     * 
     * @return property skuFamily
     */
    @Property(name="skuFamily")
    @JsonIgnore
    public Optional<String> getSkuFamily() {
        return Optional.ofNullable(skuFamily);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code skuFamily} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device sku family”</i>
     * 
     * @param skuFamily
     *            new value of {@code skuFamily} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code skuFamily} field changed
     */
    public ManagedDevice withSkuFamily(String skuFamily) {
        ManagedDevice _x = _copy();
        _x.changedFields = changedFields.add("skuFamily");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDevice");
        _x.skuFamily = skuFamily;
        return _x;
    }

    /**
     * <i>“Security baseline states for this device.”</i>
     * 
     * @return navigational property securityBaselineStates
     */
    @NavigationProperty(name="securityBaselineStates")
    @JsonIgnore
    public SecurityBaselineStateCollectionRequest getSecurityBaselineStates() {
        return new SecurityBaselineStateCollectionRequest(
                        contextPath.addSegment("securityBaselineStates"));
    }

    /**
     * <i>“Device configuration states for this device.”</i>
     * 
     * @return navigational property deviceConfigurationStates
     */
    @NavigationProperty(name="deviceConfigurationStates")
    @JsonIgnore
    public DeviceConfigurationStateCollectionRequest getDeviceConfigurationStates() {
        return new DeviceConfigurationStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationStates"));
    }

    /**
     * <i>“Device compliance policy states for this device.”</i>
     * 
     * @return navigational property deviceCompliancePolicyStates
     */
    @NavigationProperty(name="deviceCompliancePolicyStates")
    @JsonIgnore
    public DeviceCompliancePolicyStateCollectionRequest getDeviceCompliancePolicyStates() {
        return new DeviceCompliancePolicyStateCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicyStates"));
    }

    /**
     * <i>“Managed device mobile app configuration states for this device.”</i>
     * 
     * @return navigational property managedDeviceMobileAppConfigurationStates
     */
    @NavigationProperty(name="managedDeviceMobileAppConfigurationStates")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationStateCollectionRequest getManagedDeviceMobileAppConfigurationStates() {
        return new ManagedDeviceMobileAppConfigurationStateCollectionRequest(
                        contextPath.addSegment("managedDeviceMobileAppConfigurationStates"));
    }

    /**
     * <i>“All applications currently installed on the device”</i>
     * 
     * @return navigational property detectedApps
     */
    @NavigationProperty(name="detectedApps")
    @JsonIgnore
    public DetectedAppCollectionRequest getDetectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"));
    }

    /**
     * <i>“Device category”</i>
     * 
     * @return navigational property deviceCategory
     */
    @NavigationProperty(name="deviceCategory")
    @JsonIgnore
    public DeviceCategoryRequest getDeviceCategory() {
        return new DeviceCategoryRequest(contextPath.addSegment("deviceCategory"));
    }

    /**
     * <i>“The device protection status.”</i>
     * 
     * @return navigational property windowsProtectionState
     */
    @NavigationProperty(name="windowsProtectionState")
    @JsonIgnore
    public WindowsProtectionStateRequest getWindowsProtectionState() {
        return new WindowsProtectionStateRequest(contextPath.addSegment("windowsProtectionState"));
    }

    /**
     * <i>“The primary users associated with the managed device.”</i>
     * 
     * @return navigational property users
     */
    @NavigationProperty(name="users")
    @JsonIgnore
    public UserCollectionRequest getUsers() {
        return new UserCollectionRequest(
                        contextPath.addSegment("users"));
    }

    /**
     * <i>“List of log collection requests”</i>
     * 
     * @return navigational property logCollectionRequests
     */
    @NavigationProperty(name="logCollectionRequests")
    @JsonIgnore
    public DeviceLogCollectionResponseCollectionRequest getLogCollectionRequests() {
        return new DeviceLogCollectionResponseCollectionRequest(
                        contextPath.addSegment("logCollectionRequests"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDevice _copy() {
        ManagedDevice _x = new ManagedDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userId = userId;
        _x.deviceName = deviceName;
        _x.hardwareInformation = hardwareInformation;
        _x.ownerType = ownerType;
        _x.managedDeviceOwnerType = managedDeviceOwnerType;
        _x.deviceActionResults = deviceActionResults;
        _x.managementState = managementState;
        _x.enrolledDateTime = enrolledDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.chassisType = chassisType;
        _x.operatingSystem = operatingSystem;
        _x.deviceType = deviceType;
        _x.complianceState = complianceState;
        _x.jailBroken = jailBroken;
        _x.managementAgent = managementAgent;
        _x.osVersion = osVersion;
        _x.easActivated = easActivated;
        _x.easDeviceId = easDeviceId;
        _x.easActivationDateTime = easActivationDateTime;
        _x.aadRegistered = aadRegistered;
        _x.azureADRegistered = azureADRegistered;
        _x.deviceEnrollmentType = deviceEnrollmentType;
        _x.lostModeState = lostModeState;
        _x.activationLockBypassCode = activationLockBypassCode;
        _x.emailAddress = emailAddress;
        _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
        _x.azureADDeviceId = azureADDeviceId;
        _x.deviceRegistrationState = deviceRegistrationState;
        _x.deviceCategoryDisplayName = deviceCategoryDisplayName;
        _x.isSupervised = isSupervised;
        _x.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
        _x.exchangeAccessState = exchangeAccessState;
        _x.exchangeAccessStateReason = exchangeAccessStateReason;
        _x.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
        _x.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
        _x.isEncrypted = isEncrypted;
        _x.userPrincipalName = userPrincipalName;
        _x.model = model;
        _x.manufacturer = manufacturer;
        _x.imei = imei;
        _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        _x.serialNumber = serialNumber;
        _x.phoneNumber = phoneNumber;
        _x.androidSecurityPatchLevel = androidSecurityPatchLevel;
        _x.userDisplayName = userDisplayName;
        _x.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
        _x.wiFiMacAddress = wiFiMacAddress;
        _x.deviceHealthAttestationState = deviceHealthAttestationState;
        _x.subscriberCarrier = subscriberCarrier;
        _x.meid = meid;
        _x.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
        _x.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
        _x.managedDeviceName = managedDeviceName;
        _x.partnerReportedThreatState = partnerReportedThreatState;
        _x.retireAfterDateTime = retireAfterDateTime;
        _x.usersLoggedOn = usersLoggedOn;
        _x.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
        _x.autopilotEnrolled = autopilotEnrolled;
        _x.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
        _x.managementCertificateExpirationDate = managementCertificateExpirationDate;
        _x.iccid = iccid;
        _x.udid = udid;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.windowsActiveMalwareCount = windowsActiveMalwareCount;
        _x.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
        _x.notes = notes;
        _x.configurationManagerClientHealthState = configurationManagerClientHealthState;
        _x.configurationManagerClientInformation = configurationManagerClientInformation;
        _x.ethernetMacAddress = ethernetMacAddress;
        _x.physicalMemoryInBytes = physicalMemoryInBytes;
        _x.processorArchitecture = processorArchitecture;
        _x.specificationVersion = specificationVersion;
        _x.joinType = joinType;
        _x.skuFamily = skuFamily;
        return _x;
    }

    @Action(name = "overrideComplianceState")
    @JsonIgnore
    public ActionRequestNoReturn overrideComplianceState(AdministratorConfiguredDeviceComplianceState complianceState, String remediationUrl) {
        Preconditions.checkNotNull(complianceState, "complianceState cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("complianceState", "microsoft.graph.administratorConfiguredDeviceComplianceState", complianceState)
            .put("remediationUrl", "Edm.String", Checks.checkIsAscii(remediationUrl))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.overrideComplianceState"), _parameters);
    }

    @Action(name = "enableLostMode")
    @JsonIgnore
    public ActionRequestNoReturn enableLostMode(String message, String phoneNumber, String footer) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("phoneNumber", "Edm.String", Checks.checkIsAscii(phoneNumber))
            .put("footer", "Edm.String", Checks.checkIsAscii(footer))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLostMode"), _parameters);
    }

    @Action(name = "playLostModeSound")
    @JsonIgnore
    public ActionRequestNoReturn playLostModeSound() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.playLostModeSound"), _parameters);
    }

    @Action(name = "setDeviceName")
    @JsonIgnore
    public ActionRequestNoReturn setDeviceName(String deviceName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceName", "Edm.String", Checks.checkIsAscii(deviceName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setDeviceName"), _parameters);
    }

    @Action(name = "rotateFileVaultKey")
    @JsonIgnore
    public ActionRequestNoReturn rotateFileVaultKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rotateFileVaultKey"), _parameters);
    }

    @Action(name = "createDeviceLogCollectionRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceLogCollectionResponse> createDeviceLogCollectionRequest(DeviceLogCollectionRequest templateType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateType", "microsoft.graph.deviceLogCollectionRequest", templateType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceLogCollectionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDeviceLogCollectionRequest"), DeviceLogCollectionResponse.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "retire")
    @JsonIgnore
    public ActionRequestNoReturn retire() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.retire"), _parameters);
    }

    @Action(name = "wipe")
    @JsonIgnore
    public ActionRequestNoReturn wipe(Boolean keepEnrollmentData, Boolean keepUserData, String macOsUnlockCode, Boolean useProtectedWipe) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keepEnrollmentData", "Edm.Boolean", keepEnrollmentData)
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .put("macOsUnlockCode", "Edm.String", Checks.checkIsAscii(macOsUnlockCode))
            .put("useProtectedWipe", "Edm.Boolean", useProtectedWipe)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipe"), _parameters);
    }

    @Action(name = "resetPasscode")
    @JsonIgnore
    public ActionRequestNoReturn resetPasscode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetPasscode"), _parameters);
    }

    @Action(name = "remoteLock")
    @JsonIgnore
    public ActionRequestNoReturn remoteLock() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remoteLock"), _parameters);
    }

    @Action(name = "requestRemoteAssistance")
    @JsonIgnore
    public ActionRequestNoReturn requestRemoteAssistance() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestRemoteAssistance"), _parameters);
    }

    @Action(name = "disableLostMode")
    @JsonIgnore
    public ActionRequestNoReturn disableLostMode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disableLostMode"), _parameters);
    }

    @Action(name = "locateDevice")
    @JsonIgnore
    public ActionRequestNoReturn locateDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.locateDevice"), _parameters);
    }

    @Action(name = "bypassActivationLock")
    @JsonIgnore
    public ActionRequestNoReturn bypassActivationLock() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bypassActivationLock"), _parameters);
    }

    @Action(name = "rebootNow")
    @JsonIgnore
    public ActionRequestNoReturn rebootNow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rebootNow"), _parameters);
    }

    @Action(name = "shutDown")
    @JsonIgnore
    public ActionRequestNoReturn shutDown() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.shutDown"), _parameters);
    }

    @Action(name = "recoverPasscode")
    @JsonIgnore
    public ActionRequestNoReturn recoverPasscode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recoverPasscode"), _parameters);
    }

    @Action(name = "cleanWindowsDevice")
    @JsonIgnore
    public ActionRequestNoReturn cleanWindowsDevice(Boolean keepUserData) {
        Preconditions.checkNotNull(keepUserData, "keepUserData cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cleanWindowsDevice"), _parameters);
    }

    @Action(name = "logoutSharedAppleDeviceActiveUser")
    @JsonIgnore
    public ActionRequestNoReturn logoutSharedAppleDeviceActiveUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logoutSharedAppleDeviceActiveUser"), _parameters);
    }

    @Action(name = "deleteUserFromSharedAppleDevice")
    @JsonIgnore
    public ActionRequestNoReturn deleteUserFromSharedAppleDevice(String userPrincipalName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deleteUserFromSharedAppleDevice"), _parameters);
    }

    @Action(name = "syncDevice")
    @JsonIgnore
    public ActionRequestNoReturn syncDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncDevice"), _parameters);
    }

    @Action(name = "windowsDefenderScan")
    @JsonIgnore
    public ActionRequestNoReturn windowsDefenderScan(Boolean quickScan) {
        Preconditions.checkNotNull(quickScan, "quickScan cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("quickScan", "Edm.Boolean", quickScan)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsDefenderScan"), _parameters);
    }

    @Action(name = "windowsDefenderUpdateSignatures")
    @JsonIgnore
    public ActionRequestNoReturn windowsDefenderUpdateSignatures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsDefenderUpdateSignatures"), _parameters);
    }

    @Action(name = "updateWindowsDeviceAccount")
    @JsonIgnore
    public ActionRequestNoReturn updateWindowsDeviceAccount(UpdateWindowsDeviceAccountActionParameter updateWindowsDeviceAccountActionParameter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateWindowsDeviceAccountActionParameter", "microsoft.graph.updateWindowsDeviceAccountActionParameter", updateWindowsDeviceAccountActionParameter)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateWindowsDeviceAccount"), _parameters);
    }

    @Action(name = "revokeAppleVppLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeAppleVppLicenses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeAppleVppLicenses"), _parameters);
    }

    @Action(name = "rotateBitLockerKeys")
    @JsonIgnore
    public ActionRequestNoReturn rotateBitLockerKeys() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rotateBitLockerKeys"), _parameters);
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody) {
        Preconditions.checkNotNull(notificationTitle, "notificationTitle cannot be null");
        Preconditions.checkNotNull(notificationBody, "notificationBody cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Action(name = "triggerConfigurationManagerAction")
    @JsonIgnore
    public ActionRequestNoReturn triggerConfigurationManagerAction(ConfigurationManagerAction configurationManagerAction) {
        Preconditions.checkNotNull(configurationManagerAction, "configurationManagerAction cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("configurationManagerAction", "microsoft.graph.configurationManagerAction", configurationManagerAction)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.triggerConfigurationManagerAction"), _parameters);
    }

    @Function(name = "getNonCompliantSettings")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceCompliancePolicySettingState> getNonCompliantSettings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getNonCompliantSettings"), DeviceCompliancePolicySettingState.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getFileVaultKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getFileVaultKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFileVaultKey"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("hardwareInformation=");
        b.append(this.hardwareInformation);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append(", ");
        b.append("managedDeviceOwnerType=");
        b.append(this.managedDeviceOwnerType);
        b.append(", ");
        b.append("deviceActionResults=");
        b.append(this.deviceActionResults);
        b.append(", ");
        b.append("managementState=");
        b.append(this.managementState);
        b.append(", ");
        b.append("enrolledDateTime=");
        b.append(this.enrolledDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("chassisType=");
        b.append(this.chassisType);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("complianceState=");
        b.append(this.complianceState);
        b.append(", ");
        b.append("jailBroken=");
        b.append(this.jailBroken);
        b.append(", ");
        b.append("managementAgent=");
        b.append(this.managementAgent);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("easActivated=");
        b.append(this.easActivated);
        b.append(", ");
        b.append("easDeviceId=");
        b.append(this.easDeviceId);
        b.append(", ");
        b.append("easActivationDateTime=");
        b.append(this.easActivationDateTime);
        b.append(", ");
        b.append("aadRegistered=");
        b.append(this.aadRegistered);
        b.append(", ");
        b.append("azureADRegistered=");
        b.append(this.azureADRegistered);
        b.append(", ");
        b.append("deviceEnrollmentType=");
        b.append(this.deviceEnrollmentType);
        b.append(", ");
        b.append("lostModeState=");
        b.append(this.lostModeState);
        b.append(", ");
        b.append("activationLockBypassCode=");
        b.append(this.activationLockBypassCode);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("azureActiveDirectoryDeviceId=");
        b.append(this.azureActiveDirectoryDeviceId);
        b.append(", ");
        b.append("azureADDeviceId=");
        b.append(this.azureADDeviceId);
        b.append(", ");
        b.append("deviceRegistrationState=");
        b.append(this.deviceRegistrationState);
        b.append(", ");
        b.append("deviceCategoryDisplayName=");
        b.append(this.deviceCategoryDisplayName);
        b.append(", ");
        b.append("isSupervised=");
        b.append(this.isSupervised);
        b.append(", ");
        b.append("exchangeLastSuccessfulSyncDateTime=");
        b.append(this.exchangeLastSuccessfulSyncDateTime);
        b.append(", ");
        b.append("exchangeAccessState=");
        b.append(this.exchangeAccessState);
        b.append(", ");
        b.append("exchangeAccessStateReason=");
        b.append(this.exchangeAccessStateReason);
        b.append(", ");
        b.append("remoteAssistanceSessionUrl=");
        b.append(this.remoteAssistanceSessionUrl);
        b.append(", ");
        b.append("remoteAssistanceSessionErrorDetails=");
        b.append(this.remoteAssistanceSessionErrorDetails);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("imei=");
        b.append(this.imei);
        b.append(", ");
        b.append("complianceGracePeriodExpirationDateTime=");
        b.append(this.complianceGracePeriodExpirationDateTime);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("androidSecurityPatchLevel=");
        b.append(this.androidSecurityPatchLevel);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("configurationManagerClientEnabledFeatures=");
        b.append(this.configurationManagerClientEnabledFeatures);
        b.append(", ");
        b.append("wiFiMacAddress=");
        b.append(this.wiFiMacAddress);
        b.append(", ");
        b.append("deviceHealthAttestationState=");
        b.append(this.deviceHealthAttestationState);
        b.append(", ");
        b.append("subscriberCarrier=");
        b.append(this.subscriberCarrier);
        b.append(", ");
        b.append("meid=");
        b.append(this.meid);
        b.append(", ");
        b.append("totalStorageSpaceInBytes=");
        b.append(this.totalStorageSpaceInBytes);
        b.append(", ");
        b.append("freeStorageSpaceInBytes=");
        b.append(this.freeStorageSpaceInBytes);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("partnerReportedThreatState=");
        b.append(this.partnerReportedThreatState);
        b.append(", ");
        b.append("retireAfterDateTime=");
        b.append(this.retireAfterDateTime);
        b.append(", ");
        b.append("usersLoggedOn=");
        b.append(this.usersLoggedOn);
        b.append(", ");
        b.append("preferMdmOverGroupPolicyAppliedDateTime=");
        b.append(this.preferMdmOverGroupPolicyAppliedDateTime);
        b.append(", ");
        b.append("autopilotEnrolled=");
        b.append(this.autopilotEnrolled);
        b.append(", ");
        b.append("requireUserEnrollmentApproval=");
        b.append(this.requireUserEnrollmentApproval);
        b.append(", ");
        b.append("managementCertificateExpirationDate=");
        b.append(this.managementCertificateExpirationDate);
        b.append(", ");
        b.append("iccid=");
        b.append(this.iccid);
        b.append(", ");
        b.append("udid=");
        b.append(this.udid);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("windowsActiveMalwareCount=");
        b.append(this.windowsActiveMalwareCount);
        b.append(", ");
        b.append("windowsRemediatedMalwareCount=");
        b.append(this.windowsRemediatedMalwareCount);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("configurationManagerClientHealthState=");
        b.append(this.configurationManagerClientHealthState);
        b.append(", ");
        b.append("configurationManagerClientInformation=");
        b.append(this.configurationManagerClientInformation);
        b.append(", ");
        b.append("ethernetMacAddress=");
        b.append(this.ethernetMacAddress);
        b.append(", ");
        b.append("physicalMemoryInBytes=");
        b.append(this.physicalMemoryInBytes);
        b.append(", ");
        b.append("processorArchitecture=");
        b.append(this.processorArchitecture);
        b.append(", ");
        b.append("specificationVersion=");
        b.append(this.specificationVersion);
        b.append(", ");
        b.append("joinType=");
        b.append(this.joinType);
        b.append(", ");
        b.append("skuFamily=");
        b.append(this.skuFamily);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
