package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;


/**
 * <i>“Represents an un-typed status report about organizations app protection and
 * configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "content"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppStatusRaw extends ManagedAppStatus implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppStatusRaw";
    }

    @JsonProperty("content")
    protected Json content;

    protected ManagedAppStatusRaw() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedAppStatusRaw() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String version;
        private Json content;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Status report content.”</i>
         * 
         * @param content
         *            value of {@code content} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder content(Json content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public ManagedAppStatusRaw build() {
            ManagedAppStatusRaw _x = new ManagedAppStatusRaw();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedAppStatusRaw";
            _x.id = id;
            _x.displayName = displayName;
            _x.version = version;
            _x.content = content;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Status report content.”</i>
     * 
     * @return property content
     */
    @Property(name="content")
    @JsonIgnore
    public Optional<Json> getContent() {
        return Optional.ofNullable(content);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code content} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Status report content.”</i>
     * 
     * @param content
     *            new value of {@code content} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code content} field changed
     */
    public ManagedAppStatusRaw withContent(Json content) {
        ManagedAppStatusRaw _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppStatusRaw");
        _x.content = content;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppStatusRaw patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedAppStatusRaw _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppStatusRaw put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedAppStatusRaw _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedAppStatusRaw _copy() {
        ManagedAppStatusRaw _x = new ManagedAppStatusRaw();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.version = version;
        _x.content = content;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppStatusRaw[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
