package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ManagedAppPolicyDeploymentSummaryPerApp;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The ManagedAppEntity is the base entity type for all other entity types under
 * app management workflow.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "configurationDeployedUserCount", 
    "lastRefreshTime", 
    "configurationDeploymentSummaryPerApp", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppPolicyDeploymentSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppPolicyDeploymentSummary";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("configurationDeployedUserCount")
    protected Integer configurationDeployedUserCount;

    @JsonProperty("lastRefreshTime")
    protected OffsetDateTime lastRefreshTime;

    @JsonProperty("configurationDeploymentSummaryPerApp")
    protected List<ManagedAppPolicyDeploymentSummaryPerApp> configurationDeploymentSummaryPerApp;

    @JsonProperty("configurationDeploymentSummaryPerApp@nextLink")
    protected String configurationDeploymentSummaryPerAppNextLink;

    @JsonProperty("version")
    protected String version;

    protected ManagedAppPolicyDeploymentSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedAppPolicyDeploymentSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Integer configurationDeployedUserCount;
        private OffsetDateTime lastRefreshTime;
        private List<ManagedAppPolicyDeploymentSummaryPerApp> configurationDeploymentSummaryPerApp;
        private String configurationDeploymentSummaryPerAppNextLink;
        private String version;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder configurationDeployedUserCount(Integer configurationDeployedUserCount) {
            this.configurationDeployedUserCount = configurationDeployedUserCount;
            this.changedFields = changedFields.add("configurationDeployedUserCount");
            return this;
        }

        public Builder lastRefreshTime(OffsetDateTime lastRefreshTime) {
            this.lastRefreshTime = lastRefreshTime;
            this.changedFields = changedFields.add("lastRefreshTime");
            return this;
        }

        public Builder configurationDeploymentSummaryPerApp(List<ManagedAppPolicyDeploymentSummaryPerApp> configurationDeploymentSummaryPerApp) {
            this.configurationDeploymentSummaryPerApp = configurationDeploymentSummaryPerApp;
            this.changedFields = changedFields.add("configurationDeploymentSummaryPerApp");
            return this;
        }

        public Builder configurationDeploymentSummaryPerApp(ManagedAppPolicyDeploymentSummaryPerApp... configurationDeploymentSummaryPerApp) {
            return configurationDeploymentSummaryPerApp(Arrays.asList(configurationDeploymentSummaryPerApp));
        }

        public Builder configurationDeploymentSummaryPerAppNextLink(String configurationDeploymentSummaryPerAppNextLink) {
            this.configurationDeploymentSummaryPerAppNextLink = configurationDeploymentSummaryPerAppNextLink;
            this.changedFields = changedFields.add("configurationDeploymentSummaryPerApp");
            return this;
        }

        /**
         * <i>“Version of the entity.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public ManagedAppPolicyDeploymentSummary build() {
            ManagedAppPolicyDeploymentSummary _x = new ManagedAppPolicyDeploymentSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedAppPolicyDeploymentSummary";
            _x.id = id;
            _x.displayName = displayName;
            _x.configurationDeployedUserCount = configurationDeployedUserCount;
            _x.lastRefreshTime = lastRefreshTime;
            _x.configurationDeploymentSummaryPerApp = configurationDeploymentSummaryPerApp;
            _x.configurationDeploymentSummaryPerAppNextLink = configurationDeploymentSummaryPerAppNextLink;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagedAppPolicyDeploymentSummary withDisplayName(String displayName) {
        ManagedAppPolicyDeploymentSummary _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicyDeploymentSummary");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="configurationDeployedUserCount")
    @JsonIgnore
    public Optional<Integer> getConfigurationDeployedUserCount() {
        return Optional.ofNullable(configurationDeployedUserCount);
    }

    public ManagedAppPolicyDeploymentSummary withConfigurationDeployedUserCount(Integer configurationDeployedUserCount) {
        ManagedAppPolicyDeploymentSummary _x = _copy();
        _x.changedFields = changedFields.add("configurationDeployedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicyDeploymentSummary");
        _x.configurationDeployedUserCount = configurationDeployedUserCount;
        return _x;
    }

    @Property(name="lastRefreshTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshTime() {
        return Optional.ofNullable(lastRefreshTime);
    }

    public ManagedAppPolicyDeploymentSummary withLastRefreshTime(OffsetDateTime lastRefreshTime) {
        ManagedAppPolicyDeploymentSummary _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicyDeploymentSummary");
        _x.lastRefreshTime = lastRefreshTime;
        return _x;
    }

    @Property(name="configurationDeploymentSummaryPerApp")
    @JsonIgnore
    public CollectionPage<ManagedAppPolicyDeploymentSummaryPerApp> getConfigurationDeploymentSummaryPerApp() {
        return new CollectionPage<ManagedAppPolicyDeploymentSummaryPerApp>(contextPath, ManagedAppPolicyDeploymentSummaryPerApp.class, configurationDeploymentSummaryPerApp, Optional.ofNullable(configurationDeploymentSummaryPerAppNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="configurationDeploymentSummaryPerApp")
    @JsonIgnore
    public CollectionPage<ManagedAppPolicyDeploymentSummaryPerApp> getConfigurationDeploymentSummaryPerApp(HttpRequestOptions options) {
        return new CollectionPage<ManagedAppPolicyDeploymentSummaryPerApp>(contextPath, ManagedAppPolicyDeploymentSummaryPerApp.class, configurationDeploymentSummaryPerApp, Optional.ofNullable(configurationDeploymentSummaryPerAppNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Version of the entity.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the entity.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public ManagedAppPolicyDeploymentSummary withVersion(String version) {
        ManagedAppPolicyDeploymentSummary _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicyDeploymentSummary");
        _x.version = version;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppPolicyDeploymentSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedAppPolicyDeploymentSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppPolicyDeploymentSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedAppPolicyDeploymentSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedAppPolicyDeploymentSummary _copy() {
        ManagedAppPolicyDeploymentSummary _x = new ManagedAppPolicyDeploymentSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.configurationDeployedUserCount = configurationDeployedUserCount;
        _x.lastRefreshTime = lastRefreshTime;
        _x.configurationDeploymentSummaryPerApp = configurationDeploymentSummaryPerApp;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppPolicyDeploymentSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("configurationDeployedUserCount=");
        b.append(this.configurationDeployedUserCount);
        b.append(", ");
        b.append("lastRefreshTime=");
        b.append(this.lastRefreshTime);
        b.append(", ");
        b.append("configurationDeploymentSummaryPerApp=");
        b.append(this.configurationDeploymentSummaryPerApp);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
