package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Configuration used to deliver a set of custom settings as-is to apps for users
 * to whom the configuration is scoped”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "customSettings"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppConfiguration extends ManagedAppPolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppConfiguration";
    }

    @JsonProperty("customSettings")
    protected List<KeyValuePair> customSettings;

    @JsonProperty("customSettings@nextLink")
    protected String customSettingsNextLink;

    protected ManagedAppConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“A set of string key and string value pairs to be sent to apps for users to whom
     * the configuration is scoped, unalterned by this service”</i>
     * 
     * @return property customSettings
     */
    @Property(name="customSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomSettings() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, customSettings, Optional.ofNullable(customSettingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A set of string key and string value pairs to be sent to apps for users to whom
     * the configuration is scoped, unalterned by this service”</i>
     * 
     * @return property customSettings
     */
    @Property(name="customSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomSettings(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, customSettings, Optional.ofNullable(customSettingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedAppConfiguration _copy() {
        ManagedAppConfiguration _x = new ManagedAppConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.customSettings = customSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("customSettings=");
        b.append(this.customSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
