package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CertificateRevocationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "certificateRevokeStatus", 
    "certificateRevokeStatusLastChangeDateTime", 
    "managedDeviceDisplayName", 
    "userPrincipalName", 
    "certificateExpirationDateTime", 
    "certificateIssuerName", 
    "certificateThumbprint", 
    "certificateSerialNumber", 
    "certificateSubjectName", 
    "certificateKeyUsages", 
    "certificateExtendedKeyUsages", 
    "certificateIssuanceDateTime"})
@JsonInclude(Include.NON_NULL)
public class ManagedAllDeviceCertificateState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAllDeviceCertificateState";
    }

    @JsonProperty("certificateRevokeStatus")
    protected CertificateRevocationStatus certificateRevokeStatus;

    @JsonProperty("certificateRevokeStatusLastChangeDateTime")
    protected OffsetDateTime certificateRevokeStatusLastChangeDateTime;

    @JsonProperty("managedDeviceDisplayName")
    protected String managedDeviceDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("certificateExpirationDateTime")
    protected OffsetDateTime certificateExpirationDateTime;

    @JsonProperty("certificateIssuerName")
    protected String certificateIssuerName;

    @JsonProperty("certificateThumbprint")
    protected String certificateThumbprint;

    @JsonProperty("certificateSerialNumber")
    protected String certificateSerialNumber;

    @JsonProperty("certificateSubjectName")
    protected String certificateSubjectName;

    @JsonProperty("certificateKeyUsages")
    protected Integer certificateKeyUsages;

    @JsonProperty("certificateExtendedKeyUsages")
    protected String certificateExtendedKeyUsages;

    @JsonProperty("certificateIssuanceDateTime")
    protected OffsetDateTime certificateIssuanceDateTime;

    protected ManagedAllDeviceCertificateState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedAllDeviceCertificateState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CertificateRevocationStatus certificateRevokeStatus;
        private OffsetDateTime certificateRevokeStatusLastChangeDateTime;
        private String managedDeviceDisplayName;
        private String userPrincipalName;
        private OffsetDateTime certificateExpirationDateTime;
        private String certificateIssuerName;
        private String certificateThumbprint;
        private String certificateSerialNumber;
        private String certificateSubjectName;
        private Integer certificateKeyUsages;
        private String certificateExtendedKeyUsages;
        private OffsetDateTime certificateIssuanceDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Revoke status”</i>
         * 
         * @param certificateRevokeStatus
         *            value of {@code certificateRevokeStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateRevokeStatus(CertificateRevocationStatus certificateRevokeStatus) {
            this.certificateRevokeStatus = certificateRevokeStatus;
            this.changedFields = changedFields.add("certificateRevokeStatus");
            return this;
        }

        /**
         * <i>“The time the revoke status was last changed”</i>
         * 
         * @param certificateRevokeStatusLastChangeDateTime
         *            value of {@code certificateRevokeStatusLastChangeDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateRevokeStatusLastChangeDateTime(OffsetDateTime certificateRevokeStatusLastChangeDateTime) {
            this.certificateRevokeStatusLastChangeDateTime = certificateRevokeStatusLastChangeDateTime;
            this.changedFields = changedFields.add("certificateRevokeStatusLastChangeDateTime");
            return this;
        }

        /**
         * <i>“Device display name”</i>
         * 
         * @param managedDeviceDisplayName
         *            value of {@code managedDeviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceDisplayName(String managedDeviceDisplayName) {
            this.managedDeviceDisplayName = managedDeviceDisplayName;
            this.changedFields = changedFields.add("managedDeviceDisplayName");
            return this;
        }

        /**
         * <i>“User principal name”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Certificate expiry date”</i>
         * 
         * @param certificateExpirationDateTime
         *            value of {@code certificateExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateExpirationDateTime(OffsetDateTime certificateExpirationDateTime) {
            this.certificateExpirationDateTime = certificateExpirationDateTime;
            this.changedFields = changedFields.add("certificateExpirationDateTime");
            return this;
        }

        /**
         * <i>“Issuer”</i>
         * 
         * @param certificateIssuerName
         *            value of {@code certificateIssuerName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateIssuerName(String certificateIssuerName) {
            this.certificateIssuerName = certificateIssuerName;
            this.changedFields = changedFields.add("certificateIssuerName");
            return this;
        }

        /**
         * <i>“Thumbprint”</i>
         * 
         * @param certificateThumbprint
         *            value of {@code certificateThumbprint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateThumbprint(String certificateThumbprint) {
            this.certificateThumbprint = certificateThumbprint;
            this.changedFields = changedFields.add("certificateThumbprint");
            return this;
        }

        /**
         * <i>“Serial number”</i>
         * 
         * @param certificateSerialNumber
         *            value of {@code certificateSerialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSerialNumber(String certificateSerialNumber) {
            this.certificateSerialNumber = certificateSerialNumber;
            this.changedFields = changedFields.add("certificateSerialNumber");
            return this;
        }

        /**
         * <i>“Certificate subject name”</i>
         * 
         * @param certificateSubjectName
         *            value of {@code certificateSubjectName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSubjectName(String certificateSubjectName) {
            this.certificateSubjectName = certificateSubjectName;
            this.changedFields = changedFields.add("certificateSubjectName");
            return this;
        }

        /**
         * <i>“Key Usage”</i>
         * 
         * @param certificateKeyUsages
         *            value of {@code certificateKeyUsages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateKeyUsages(Integer certificateKeyUsages) {
            this.certificateKeyUsages = certificateKeyUsages;
            this.changedFields = changedFields.add("certificateKeyUsages");
            return this;
        }

        /**
         * <i>“Enhanced Key Usage”</i>
         * 
         * @param certificateExtendedKeyUsages
         *            value of {@code certificateExtendedKeyUsages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateExtendedKeyUsages(String certificateExtendedKeyUsages) {
            this.certificateExtendedKeyUsages = certificateExtendedKeyUsages;
            this.changedFields = changedFields.add("certificateExtendedKeyUsages");
            return this;
        }

        /**
         * <i>“Issuance date”</i>
         * 
         * @param certificateIssuanceDateTime
         *            value of {@code certificateIssuanceDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateIssuanceDateTime(OffsetDateTime certificateIssuanceDateTime) {
            this.certificateIssuanceDateTime = certificateIssuanceDateTime;
            this.changedFields = changedFields.add("certificateIssuanceDateTime");
            return this;
        }

        public ManagedAllDeviceCertificateState build() {
            ManagedAllDeviceCertificateState _x = new ManagedAllDeviceCertificateState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedAllDeviceCertificateState";
            _x.id = id;
            _x.certificateRevokeStatus = certificateRevokeStatus;
            _x.certificateRevokeStatusLastChangeDateTime = certificateRevokeStatusLastChangeDateTime;
            _x.managedDeviceDisplayName = managedDeviceDisplayName;
            _x.userPrincipalName = userPrincipalName;
            _x.certificateExpirationDateTime = certificateExpirationDateTime;
            _x.certificateIssuerName = certificateIssuerName;
            _x.certificateThumbprint = certificateThumbprint;
            _x.certificateSerialNumber = certificateSerialNumber;
            _x.certificateSubjectName = certificateSubjectName;
            _x.certificateKeyUsages = certificateKeyUsages;
            _x.certificateExtendedKeyUsages = certificateExtendedKeyUsages;
            _x.certificateIssuanceDateTime = certificateIssuanceDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Revoke status”</i>
     * 
     * @return property certificateRevokeStatus
     */
    @Property(name="certificateRevokeStatus")
    @JsonIgnore
    public Optional<CertificateRevocationStatus> getCertificateRevokeStatus() {
        return Optional.ofNullable(certificateRevokeStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateRevokeStatus} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Revoke status”</i>
     * 
     * @param certificateRevokeStatus
     *            new value of {@code certificateRevokeStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateRevokeStatus} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateRevokeStatus(CertificateRevocationStatus certificateRevokeStatus) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateRevokeStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateRevokeStatus = certificateRevokeStatus;
        return _x;
    }

    /**
     * <i>“The time the revoke status was last changed”</i>
     * 
     * @return property certificateRevokeStatusLastChangeDateTime
     */
    @Property(name="certificateRevokeStatusLastChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificateRevokeStatusLastChangeDateTime() {
        return Optional.ofNullable(certificateRevokeStatusLastChangeDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateRevokeStatusLastChangeDateTime} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The time the revoke status was last changed”</i>
     * 
     * @param certificateRevokeStatusLastChangeDateTime
     *            new value of {@code certificateRevokeStatusLastChangeDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateRevokeStatusLastChangeDateTime} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateRevokeStatusLastChangeDateTime(OffsetDateTime certificateRevokeStatusLastChangeDateTime) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateRevokeStatusLastChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateRevokeStatusLastChangeDateTime = certificateRevokeStatusLastChangeDateTime;
        return _x;
    }

    /**
     * <i>“Device display name”</i>
     * 
     * @return property managedDeviceDisplayName
     */
    @Property(name="managedDeviceDisplayName")
    @JsonIgnore
    public Optional<String> getManagedDeviceDisplayName() {
        return Optional.ofNullable(managedDeviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceDisplayName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device display name”</i>
     * 
     * @param managedDeviceDisplayName
     *            new value of {@code managedDeviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceDisplayName} field changed
     */
    public ManagedAllDeviceCertificateState withManagedDeviceDisplayName(String managedDeviceDisplayName) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.managedDeviceDisplayName = managedDeviceDisplayName;
        return _x;
    }

    /**
     * <i>“User principal name”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User principal name”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public ManagedAllDeviceCertificateState withUserPrincipalName(String userPrincipalName) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Certificate expiry date”</i>
     * 
     * @return property certificateExpirationDateTime
     */
    @Property(name="certificateExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificateExpirationDateTime() {
        return Optional.ofNullable(certificateExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateExpirationDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate expiry date”</i>
     * 
     * @param certificateExpirationDateTime
     *            new value of {@code certificateExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateExpirationDateTime} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateExpirationDateTime(OffsetDateTime certificateExpirationDateTime) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateExpirationDateTime = certificateExpirationDateTime;
        return _x;
    }

    /**
     * <i>“Issuer”</i>
     * 
     * @return property certificateIssuerName
     */
    @Property(name="certificateIssuerName")
    @JsonIgnore
    public Optional<String> getCertificateIssuerName() {
        return Optional.ofNullable(certificateIssuerName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateIssuerName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Issuer”</i>
     * 
     * @param certificateIssuerName
     *            new value of {@code certificateIssuerName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateIssuerName} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateIssuerName(String certificateIssuerName) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateIssuerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateIssuerName = certificateIssuerName;
        return _x;
    }

    /**
     * <i>“Thumbprint”</i>
     * 
     * @return property certificateThumbprint
     */
    @Property(name="certificateThumbprint")
    @JsonIgnore
    public Optional<String> getCertificateThumbprint() {
        return Optional.ofNullable(certificateThumbprint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateThumbprint} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Thumbprint”</i>
     * 
     * @param certificateThumbprint
     *            new value of {@code certificateThumbprint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateThumbprint} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateThumbprint(String certificateThumbprint) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateThumbprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateThumbprint = certificateThumbprint;
        return _x;
    }

    /**
     * <i>“Serial number”</i>
     * 
     * @return property certificateSerialNumber
     */
    @Property(name="certificateSerialNumber")
    @JsonIgnore
    public Optional<String> getCertificateSerialNumber() {
        return Optional.ofNullable(certificateSerialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSerialNumber} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Serial number”</i>
     * 
     * @param certificateSerialNumber
     *            new value of {@code certificateSerialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSerialNumber} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateSerialNumber(String certificateSerialNumber) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSerialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateSerialNumber = certificateSerialNumber;
        return _x;
    }

    /**
     * <i>“Certificate subject name”</i>
     * 
     * @return property certificateSubjectName
     */
    @Property(name="certificateSubjectName")
    @JsonIgnore
    public Optional<String> getCertificateSubjectName() {
        return Optional.ofNullable(certificateSubjectName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSubjectName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate subject name”</i>
     * 
     * @param certificateSubjectName
     *            new value of {@code certificateSubjectName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSubjectName} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateSubjectName(String certificateSubjectName) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateSubjectName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateSubjectName = certificateSubjectName;
        return _x;
    }

    /**
     * <i>“Key Usage”</i>
     * 
     * @return property certificateKeyUsages
     */
    @Property(name="certificateKeyUsages")
    @JsonIgnore
    public Optional<Integer> getCertificateKeyUsages() {
        return Optional.ofNullable(certificateKeyUsages);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateKeyUsages} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Key Usage”</i>
     * 
     * @param certificateKeyUsages
     *            new value of {@code certificateKeyUsages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateKeyUsages} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateKeyUsages(Integer certificateKeyUsages) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateKeyUsages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateKeyUsages = certificateKeyUsages;
        return _x;
    }

    /**
     * <i>“Enhanced Key Usage”</i>
     * 
     * @return property certificateExtendedKeyUsages
     */
    @Property(name="certificateExtendedKeyUsages")
    @JsonIgnore
    public Optional<String> getCertificateExtendedKeyUsages() {
        return Optional.ofNullable(certificateExtendedKeyUsages);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateExtendedKeyUsages} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enhanced Key Usage”</i>
     * 
     * @param certificateExtendedKeyUsages
     *            new value of {@code certificateExtendedKeyUsages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateExtendedKeyUsages} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateExtendedKeyUsages(String certificateExtendedKeyUsages) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateExtendedKeyUsages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateExtendedKeyUsages = certificateExtendedKeyUsages;
        return _x;
    }

    /**
     * <i>“Issuance date”</i>
     * 
     * @return property certificateIssuanceDateTime
     */
    @Property(name="certificateIssuanceDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertificateIssuanceDateTime() {
        return Optional.ofNullable(certificateIssuanceDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateIssuanceDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Issuance date”</i>
     * 
     * @param certificateIssuanceDateTime
     *            new value of {@code certificateIssuanceDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateIssuanceDateTime} field changed
     */
    public ManagedAllDeviceCertificateState withCertificateIssuanceDateTime(OffsetDateTime certificateIssuanceDateTime) {
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = changedFields.add("certificateIssuanceDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAllDeviceCertificateState");
        _x.certificateIssuanceDateTime = certificateIssuanceDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAllDeviceCertificateState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAllDeviceCertificateState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedAllDeviceCertificateState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedAllDeviceCertificateState _copy() {
        ManagedAllDeviceCertificateState _x = new ManagedAllDeviceCertificateState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.certificateRevokeStatus = certificateRevokeStatus;
        _x.certificateRevokeStatusLastChangeDateTime = certificateRevokeStatusLastChangeDateTime;
        _x.managedDeviceDisplayName = managedDeviceDisplayName;
        _x.userPrincipalName = userPrincipalName;
        _x.certificateExpirationDateTime = certificateExpirationDateTime;
        _x.certificateIssuerName = certificateIssuerName;
        _x.certificateThumbprint = certificateThumbprint;
        _x.certificateSerialNumber = certificateSerialNumber;
        _x.certificateSubjectName = certificateSubjectName;
        _x.certificateKeyUsages = certificateKeyUsages;
        _x.certificateExtendedKeyUsages = certificateExtendedKeyUsages;
        _x.certificateIssuanceDateTime = certificateIssuanceDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAllDeviceCertificateState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("certificateRevokeStatus=");
        b.append(this.certificateRevokeStatus);
        b.append(", ");
        b.append("certificateRevokeStatusLastChangeDateTime=");
        b.append(this.certificateRevokeStatusLastChangeDateTime);
        b.append(", ");
        b.append("managedDeviceDisplayName=");
        b.append(this.managedDeviceDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("certificateExpirationDateTime=");
        b.append(this.certificateExpirationDateTime);
        b.append(", ");
        b.append("certificateIssuerName=");
        b.append(this.certificateIssuerName);
        b.append(", ");
        b.append("certificateThumbprint=");
        b.append(this.certificateThumbprint);
        b.append(", ");
        b.append("certificateSerialNumber=");
        b.append(this.certificateSerialNumber);
        b.append(", ");
        b.append("certificateSubjectName=");
        b.append(this.certificateSubjectName);
        b.append(", ");
        b.append("certificateKeyUsages=");
        b.append(this.certificateKeyUsages);
        b.append(", ");
        b.append("certificateExtendedKeyUsages=");
        b.append(this.certificateExtendedKeyUsages);
        b.append(", ");
        b.append("certificateIssuanceDateTime=");
        b.append(this.certificateIssuanceDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
