package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "displayName", 
    "isDeleted", 
    "deletedDate", 
    "createdDate", 
    "lastActivityDate", 
    "itemCount", 
    "storageUsedInBytes", 
    "deletedItemCount", 
    "deletedItemSizeInBytes", 
    "issueWarningQuotaInBytes", 
    "prohibitSendQuotaInBytes", 
    "prohibitSendReceiveQuotaInBytes", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class MailboxUsageDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailboxUsageDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("createdDate")
    protected LocalDate createdDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("itemCount")
    protected Long itemCount;

    @JsonProperty("storageUsedInBytes")
    protected Long storageUsedInBytes;

    @JsonProperty("deletedItemCount")
    protected Long deletedItemCount;

    @JsonProperty("deletedItemSizeInBytes")
    protected Long deletedItemSizeInBytes;

    @JsonProperty("issueWarningQuotaInBytes")
    protected Long issueWarningQuotaInBytes;

    @JsonProperty("prohibitSendQuotaInBytes")
    protected Long prohibitSendQuotaInBytes;

    @JsonProperty("prohibitSendReceiveQuotaInBytes")
    protected Long prohibitSendReceiveQuotaInBytes;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected MailboxUsageDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMailboxUsageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private String displayName;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private LocalDate createdDate;
        private LocalDate lastActivityDate;
        private Long itemCount;
        private Long storageUsedInBytes;
        private Long deletedItemCount;
        private Long deletedItemSizeInBytes;
        private Long issueWarningQuotaInBytes;
        private Long prohibitSendQuotaInBytes;
        private Long prohibitSendReceiveQuotaInBytes;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder createdDate(LocalDate createdDate) {
            this.createdDate = createdDate;
            this.changedFields = changedFields.add("createdDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            this.changedFields = changedFields.add("itemCount");
            return this;
        }

        public Builder storageUsedInBytes(Long storageUsedInBytes) {
            this.storageUsedInBytes = storageUsedInBytes;
            this.changedFields = changedFields.add("storageUsedInBytes");
            return this;
        }

        public Builder deletedItemCount(Long deletedItemCount) {
            this.deletedItemCount = deletedItemCount;
            this.changedFields = changedFields.add("deletedItemCount");
            return this;
        }

        public Builder deletedItemSizeInBytes(Long deletedItemSizeInBytes) {
            this.deletedItemSizeInBytes = deletedItemSizeInBytes;
            this.changedFields = changedFields.add("deletedItemSizeInBytes");
            return this;
        }

        public Builder issueWarningQuotaInBytes(Long issueWarningQuotaInBytes) {
            this.issueWarningQuotaInBytes = issueWarningQuotaInBytes;
            this.changedFields = changedFields.add("issueWarningQuotaInBytes");
            return this;
        }

        public Builder prohibitSendQuotaInBytes(Long prohibitSendQuotaInBytes) {
            this.prohibitSendQuotaInBytes = prohibitSendQuotaInBytes;
            this.changedFields = changedFields.add("prohibitSendQuotaInBytes");
            return this;
        }

        public Builder prohibitSendReceiveQuotaInBytes(Long prohibitSendReceiveQuotaInBytes) {
            this.prohibitSendReceiveQuotaInBytes = prohibitSendReceiveQuotaInBytes;
            this.changedFields = changedFields.add("prohibitSendReceiveQuotaInBytes");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public MailboxUsageDetail build() {
            MailboxUsageDetail _x = new MailboxUsageDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mailboxUsageDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.displayName = displayName;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.createdDate = createdDate;
            _x.lastActivityDate = lastActivityDate;
            _x.itemCount = itemCount;
            _x.storageUsedInBytes = storageUsedInBytes;
            _x.deletedItemCount = deletedItemCount;
            _x.deletedItemSizeInBytes = deletedItemSizeInBytes;
            _x.issueWarningQuotaInBytes = issueWarningQuotaInBytes;
            _x.prohibitSendQuotaInBytes = prohibitSendQuotaInBytes;
            _x.prohibitSendReceiveQuotaInBytes = prohibitSendReceiveQuotaInBytes;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public MailboxUsageDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public MailboxUsageDetail withUserPrincipalName(String userPrincipalName) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MailboxUsageDetail withDisplayName(String displayName) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public MailboxUsageDetail withIsDeleted(Boolean isDeleted) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public MailboxUsageDetail withDeletedDate(LocalDate deletedDate) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="createdDate")
    @JsonIgnore
    public Optional<LocalDate> getCreatedDate() {
        return Optional.ofNullable(createdDate);
    }

    public MailboxUsageDetail withCreatedDate(LocalDate createdDate) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("createdDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.createdDate = createdDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public MailboxUsageDetail withLastActivityDate(LocalDate lastActivityDate) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="itemCount")
    @JsonIgnore
    public Optional<Long> getItemCount() {
        return Optional.ofNullable(itemCount);
    }

    public MailboxUsageDetail withItemCount(Long itemCount) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("itemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.itemCount = itemCount;
        return _x;
    }

    @Property(name="storageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getStorageUsedInBytes() {
        return Optional.ofNullable(storageUsedInBytes);
    }

    public MailboxUsageDetail withStorageUsedInBytes(Long storageUsedInBytes) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("storageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.storageUsedInBytes = storageUsedInBytes;
        return _x;
    }

    @Property(name="deletedItemCount")
    @JsonIgnore
    public Optional<Long> getDeletedItemCount() {
        return Optional.ofNullable(deletedItemCount);
    }

    public MailboxUsageDetail withDeletedItemCount(Long deletedItemCount) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.deletedItemCount = deletedItemCount;
        return _x;
    }

    @Property(name="deletedItemSizeInBytes")
    @JsonIgnore
    public Optional<Long> getDeletedItemSizeInBytes() {
        return Optional.ofNullable(deletedItemSizeInBytes);
    }

    public MailboxUsageDetail withDeletedItemSizeInBytes(Long deletedItemSizeInBytes) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedItemSizeInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.deletedItemSizeInBytes = deletedItemSizeInBytes;
        return _x;
    }

    @Property(name="issueWarningQuotaInBytes")
    @JsonIgnore
    public Optional<Long> getIssueWarningQuotaInBytes() {
        return Optional.ofNullable(issueWarningQuotaInBytes);
    }

    public MailboxUsageDetail withIssueWarningQuotaInBytes(Long issueWarningQuotaInBytes) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("issueWarningQuotaInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.issueWarningQuotaInBytes = issueWarningQuotaInBytes;
        return _x;
    }

    @Property(name="prohibitSendQuotaInBytes")
    @JsonIgnore
    public Optional<Long> getProhibitSendQuotaInBytes() {
        return Optional.ofNullable(prohibitSendQuotaInBytes);
    }

    public MailboxUsageDetail withProhibitSendQuotaInBytes(Long prohibitSendQuotaInBytes) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("prohibitSendQuotaInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.prohibitSendQuotaInBytes = prohibitSendQuotaInBytes;
        return _x;
    }

    @Property(name="prohibitSendReceiveQuotaInBytes")
    @JsonIgnore
    public Optional<Long> getProhibitSendReceiveQuotaInBytes() {
        return Optional.ofNullable(prohibitSendReceiveQuotaInBytes);
    }

    public MailboxUsageDetail withProhibitSendReceiveQuotaInBytes(Long prohibitSendReceiveQuotaInBytes) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("prohibitSendReceiveQuotaInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.prohibitSendReceiveQuotaInBytes = prohibitSendReceiveQuotaInBytes;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public MailboxUsageDetail withReportPeriod(String reportPeriod) {
        MailboxUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxUsageDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailboxUsageDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MailboxUsageDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailboxUsageDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MailboxUsageDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MailboxUsageDetail _copy() {
        MailboxUsageDetail _x = new MailboxUsageDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.displayName = displayName;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.createdDate = createdDate;
        _x.lastActivityDate = lastActivityDate;
        _x.itemCount = itemCount;
        _x.storageUsedInBytes = storageUsedInBytes;
        _x.deletedItemCount = deletedItemCount;
        _x.deletedItemSizeInBytes = deletedItemSizeInBytes;
        _x.issueWarningQuotaInBytes = issueWarningQuotaInBytes;
        _x.prohibitSendQuotaInBytes = prohibitSendQuotaInBytes;
        _x.prohibitSendReceiveQuotaInBytes = prohibitSendReceiveQuotaInBytes;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailboxUsageDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("createdDate=");
        b.append(this.createdDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("itemCount=");
        b.append(this.itemCount);
        b.append(", ");
        b.append("storageUsedInBytes=");
        b.append(this.storageUsedInBytes);
        b.append(", ");
        b.append("deletedItemCount=");
        b.append(this.deletedItemCount);
        b.append(", ");
        b.append("deletedItemSizeInBytes=");
        b.append(this.deletedItemSizeInBytes);
        b.append(", ");
        b.append("issueWarningQuotaInBytes=");
        b.append(this.issueWarningQuotaInBytes);
        b.append(", ");
        b.append("prohibitSendQuotaInBytes=");
        b.append(this.prohibitSendQuotaInBytes);
        b.append(", ");
        b.append("prohibitSendReceiveQuotaInBytes=");
        b.append(this.prohibitSendReceiveQuotaInBytes);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
