package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isSupported", 
    "includeNestedFolders", 
    "sourceFolderIds", 
    "filterQuery"})
@JsonInclude(Include.NON_NULL)
public class MailSearchFolder extends MailFolder implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailSearchFolder";
    }

    @JsonProperty("isSupported")
    protected Boolean isSupported;

    @JsonProperty("includeNestedFolders")
    protected Boolean includeNestedFolders;

    @JsonProperty("sourceFolderIds")
    protected List<String> sourceFolderIds;

    @JsonProperty("sourceFolderIds@nextLink")
    protected String sourceFolderIdsNextLink;

    @JsonProperty("filterQuery")
    protected String filterQuery;

    protected MailSearchFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMailSearchFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String parentFolderId;
        private Integer childFolderCount;
        private Integer unreadItemCount;
        private Integer totalItemCount;
        private String wellKnownName;
        private Boolean isSupported;
        private Boolean includeNestedFolders;
        private List<String> sourceFolderIds;
        private String sourceFolderIdsNextLink;
        private String filterQuery;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder childFolderCount(Integer childFolderCount) {
            this.childFolderCount = childFolderCount;
            this.changedFields = changedFields.add("childFolderCount");
            return this;
        }

        public Builder unreadItemCount(Integer unreadItemCount) {
            this.unreadItemCount = unreadItemCount;
            this.changedFields = changedFields.add("unreadItemCount");
            return this;
        }

        public Builder totalItemCount(Integer totalItemCount) {
            this.totalItemCount = totalItemCount;
            this.changedFields = changedFields.add("totalItemCount");
            return this;
        }

        public Builder wellKnownName(String wellKnownName) {
            this.wellKnownName = wellKnownName;
            this.changedFields = changedFields.add("wellKnownName");
            return this;
        }

        public Builder isSupported(Boolean isSupported) {
            this.isSupported = isSupported;
            this.changedFields = changedFields.add("isSupported");
            return this;
        }

        public Builder includeNestedFolders(Boolean includeNestedFolders) {
            this.includeNestedFolders = includeNestedFolders;
            this.changedFields = changedFields.add("includeNestedFolders");
            return this;
        }

        public Builder sourceFolderIds(List<String> sourceFolderIds) {
            this.sourceFolderIds = sourceFolderIds;
            this.changedFields = changedFields.add("sourceFolderIds");
            return this;
        }

        public Builder sourceFolderIds(String... sourceFolderIds) {
            return sourceFolderIds(Arrays.asList(sourceFolderIds));
        }

        public Builder sourceFolderIdsNextLink(String sourceFolderIdsNextLink) {
            this.sourceFolderIdsNextLink = sourceFolderIdsNextLink;
            this.changedFields = changedFields.add("sourceFolderIds");
            return this;
        }

        public Builder filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            this.changedFields = changedFields.add("filterQuery");
            return this;
        }

        public MailSearchFolder build() {
            MailSearchFolder _x = new MailSearchFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mailSearchFolder";
            _x.id = id;
            _x.displayName = displayName;
            _x.parentFolderId = parentFolderId;
            _x.childFolderCount = childFolderCount;
            _x.unreadItemCount = unreadItemCount;
            _x.totalItemCount = totalItemCount;
            _x.wellKnownName = wellKnownName;
            _x.isSupported = isSupported;
            _x.includeNestedFolders = includeNestedFolders;
            _x.sourceFolderIds = sourceFolderIds;
            _x.sourceFolderIdsNextLink = sourceFolderIdsNextLink;
            _x.filterQuery = filterQuery;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="isSupported")
    @JsonIgnore
    public Optional<Boolean> getIsSupported() {
        return Optional.ofNullable(isSupported);
    }

    public MailSearchFolder withIsSupported(Boolean isSupported) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("isSupported");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.isSupported = isSupported;
        return _x;
    }

    @Property(name="includeNestedFolders")
    @JsonIgnore
    public Optional<Boolean> getIncludeNestedFolders() {
        return Optional.ofNullable(includeNestedFolders);
    }

    public MailSearchFolder withIncludeNestedFolders(Boolean includeNestedFolders) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("includeNestedFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.includeNestedFolders = includeNestedFolders;
        return _x;
    }

    @Property(name="sourceFolderIds")
    @JsonIgnore
    public CollectionPage<String> getSourceFolderIds() {
        return new CollectionPage<String>(contextPath, String.class, sourceFolderIds, Optional.ofNullable(sourceFolderIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sourceFolderIds")
    @JsonIgnore
    public CollectionPage<String> getSourceFolderIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sourceFolderIds, Optional.ofNullable(sourceFolderIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="filterQuery")
    @JsonIgnore
    public Optional<String> getFilterQuery() {
        return Optional.ofNullable(filterQuery);
    }

    public MailSearchFolder withFilterQuery(String filterQuery) {
        MailSearchFolder _x = _copy();
        _x.changedFields = changedFields.add("filterQuery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailSearchFolder");
        _x.filterQuery = filterQuery;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailSearchFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MailSearchFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailSearchFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MailSearchFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MailSearchFolder _copy() {
        MailSearchFolder _x = new MailSearchFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.parentFolderId = parentFolderId;
        _x.childFolderCount = childFolderCount;
        _x.unreadItemCount = unreadItemCount;
        _x.totalItemCount = totalItemCount;
        _x.wellKnownName = wellKnownName;
        _x.isSupported = isSupported;
        _x.includeNestedFolders = includeNestedFolders;
        _x.sourceFolderIds = sourceFolderIds;
        _x.filterQuery = filterQuery;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailSearchFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("childFolderCount=");
        b.append(this.childFolderCount);
        b.append(", ");
        b.append("unreadItemCount=");
        b.append(this.unreadItemCount);
        b.append(", ");
        b.append("totalItemCount=");
        b.append(this.totalItemCount);
        b.append(", ");
        b.append("wellKnownName=");
        b.append(this.wellKnownName);
        b.append(", ");
        b.append("isSupported=");
        b.append(this.isSupported);
        b.append(", ");
        b.append("includeNestedFolders=");
        b.append(this.includeNestedFolders);
        b.append(", ");
        b.append("sourceFolderIds=");
        b.append(this.sourceFolderIds);
        b.append(", ");
        b.append("filterQuery=");
        b.append(this.filterQuery);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
