package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserConfigurationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "parentFolderId", 
    "childFolderCount", 
    "unreadItemCount", 
    "totalItemCount", 
    "wellKnownName"})
@JsonInclude(Include.NON_NULL)
public class MailFolder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailFolder";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("childFolderCount")
    protected Integer childFolderCount;

    @JsonProperty("unreadItemCount")
    protected Integer unreadItemCount;

    @JsonProperty("totalItemCount")
    protected Integer totalItemCount;

    @JsonProperty("wellKnownName")
    protected String wellKnownName;

    protected MailFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMailFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String parentFolderId;
        private Integer childFolderCount;
        private Integer unreadItemCount;
        private Integer totalItemCount;
        private String wellKnownName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder childFolderCount(Integer childFolderCount) {
            this.childFolderCount = childFolderCount;
            this.changedFields = changedFields.add("childFolderCount");
            return this;
        }

        public Builder unreadItemCount(Integer unreadItemCount) {
            this.unreadItemCount = unreadItemCount;
            this.changedFields = changedFields.add("unreadItemCount");
            return this;
        }

        public Builder totalItemCount(Integer totalItemCount) {
            this.totalItemCount = totalItemCount;
            this.changedFields = changedFields.add("totalItemCount");
            return this;
        }

        public Builder wellKnownName(String wellKnownName) {
            this.wellKnownName = wellKnownName;
            this.changedFields = changedFields.add("wellKnownName");
            return this;
        }

        public MailFolder build() {
            MailFolder _x = new MailFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mailFolder";
            _x.id = id;
            _x.displayName = displayName;
            _x.parentFolderId = parentFolderId;
            _x.childFolderCount = childFolderCount;
            _x.unreadItemCount = unreadItemCount;
            _x.totalItemCount = totalItemCount;
            _x.wellKnownName = wellKnownName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MailFolder withDisplayName(String displayName) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public MailFolder withParentFolderId(String parentFolderId) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="childFolderCount")
    @JsonIgnore
    public Optional<Integer> getChildFolderCount() {
        return Optional.ofNullable(childFolderCount);
    }

    public MailFolder withChildFolderCount(Integer childFolderCount) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("childFolderCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.childFolderCount = childFolderCount;
        return _x;
    }

    @Property(name="unreadItemCount")
    @JsonIgnore
    public Optional<Integer> getUnreadItemCount() {
        return Optional.ofNullable(unreadItemCount);
    }

    public MailFolder withUnreadItemCount(Integer unreadItemCount) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("unreadItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.unreadItemCount = unreadItemCount;
        return _x;
    }

    @Property(name="totalItemCount")
    @JsonIgnore
    public Optional<Integer> getTotalItemCount() {
        return Optional.ofNullable(totalItemCount);
    }

    public MailFolder withTotalItemCount(Integer totalItemCount) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("totalItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.totalItemCount = totalItemCount;
        return _x;
    }

    @Property(name="wellKnownName")
    @JsonIgnore
    public Optional<String> getWellKnownName() {
        return Optional.ofNullable(wellKnownName);
    }

    public MailFolder withWellKnownName(String wellKnownName) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("wellKnownName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.wellKnownName = wellKnownName;
        return _x;
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property messages
     */
    @NavigationProperty(name="messages")
    @JsonIgnore
    public MessageCollectionRequest getMessages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property messageRules
     */
    @NavigationProperty(name="messageRules")
    @JsonIgnore
    public MessageRuleCollectionRequest getMessageRules() {
        return new MessageRuleCollectionRequest(
                        contextPath.addSegment("messageRules"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * 
     * @return navigational property childFolders
     */
    @NavigationProperty(name="childFolders")
    @JsonIgnore
    public MailFolderCollectionRequest getChildFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("childFolders"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property userConfigurations
     */
    @NavigationProperty(name="userConfigurations")
    @JsonIgnore
    public UserConfigurationCollectionRequest getUserConfigurations() {
        return new UserConfigurationCollectionRequest(
                        contextPath.addSegment("userConfigurations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MailFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MailFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MailFolder _copy() {
        MailFolder _x = new MailFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.parentFolderId = parentFolderId;
        _x.childFolderCount = childFolderCount;
        _x.unreadItemCount = unreadItemCount;
        _x.totalItemCount = totalItemCount;
        _x.wellKnownName = wellKnownName;
        return _x;
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MailFolder> copy(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MailFolder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), MailFolder.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MailFolder> move(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MailFolder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), MailFolder.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("childFolderCount=");
        b.append(this.childFolderCount);
        b.append(", ");
        b.append("unreadItemCount=");
        b.append(this.unreadItemCount);
        b.append(", ");
        b.append("totalItemCount=");
        b.append(this.totalItemCount);
        b.append(", ");
        b.append("wellKnownName=");
        b.append(this.wellKnownName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
