package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.VpnOnDemandRule;
import odata.msgraph.client.beta.complex.VpnProxyServer;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.entity.request.MacOSCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.AppleVpnConnectionType;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;


/**
 * <i>“By providing the configurations in this profile you can instruct the Mac device
 * to connect to desired VPN endpoint. By specifying the authentication method and
 * security types expected by VPN endpoint you can make the VPN connection seamless
 * for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MacOSVpnConfiguration extends AppleVpnConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSVpnConfiguration";
    }

    protected MacOSVpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSVpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String connectionName;
        private AppleVpnConnectionType connectionType;
        private String loginGroupOrDomain;
        private String role;
        private String realm;
        private VpnServer server;
        private String identifier;
        private List<KeyValue> customData;
        private String customDataNextLink;
        private List<KeyValuePair> customKeyValueData;
        private String customKeyValueDataNextLink;
        private Boolean enableSplitTunneling;
        private VpnAuthenticationMethod authenticationMethod;
        private Boolean enablePerApp;
        private List<String> safariDomains;
        private String safariDomainsNextLink;
        private List<VpnOnDemandRule> onDemandRules;
        private String onDemandRulesNextLink;
        private VpnProxyServer proxyServer;
        private Boolean optInToDeviceIdSharing;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        public Builder connectionType(AppleVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        public Builder loginGroupOrDomain(String loginGroupOrDomain) {
            this.loginGroupOrDomain = loginGroupOrDomain;
            this.changedFields = changedFields.add("loginGroupOrDomain");
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            this.changedFields = changedFields.add("realm");
            return this;
        }

        public Builder server(VpnServer server) {
            this.server = server;
            this.changedFields = changedFields.add("server");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        public Builder customData(List<KeyValue> customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder customData(KeyValue... customData) {
            return customData(Arrays.asList(customData));
        }

        public Builder customDataNextLink(String customDataNextLink) {
            this.customDataNextLink = customDataNextLink;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder customKeyValueData(List<KeyValuePair> customKeyValueData) {
            this.customKeyValueData = customKeyValueData;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        public Builder customKeyValueData(KeyValuePair... customKeyValueData) {
            return customKeyValueData(Arrays.asList(customKeyValueData));
        }

        public Builder customKeyValueDataNextLink(String customKeyValueDataNextLink) {
            this.customKeyValueDataNextLink = customKeyValueDataNextLink;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        public Builder enableSplitTunneling(Boolean enableSplitTunneling) {
            this.enableSplitTunneling = enableSplitTunneling;
            this.changedFields = changedFields.add("enableSplitTunneling");
            return this;
        }

        public Builder authenticationMethod(VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        public Builder enablePerApp(Boolean enablePerApp) {
            this.enablePerApp = enablePerApp;
            this.changedFields = changedFields.add("enablePerApp");
            return this;
        }

        public Builder safariDomains(List<String> safariDomains) {
            this.safariDomains = safariDomains;
            this.changedFields = changedFields.add("safariDomains");
            return this;
        }

        public Builder safariDomains(String... safariDomains) {
            return safariDomains(Arrays.asList(safariDomains));
        }

        public Builder safariDomainsNextLink(String safariDomainsNextLink) {
            this.safariDomainsNextLink = safariDomainsNextLink;
            this.changedFields = changedFields.add("safariDomains");
            return this;
        }

        public Builder onDemandRules(List<VpnOnDemandRule> onDemandRules) {
            this.onDemandRules = onDemandRules;
            this.changedFields = changedFields.add("onDemandRules");
            return this;
        }

        public Builder onDemandRules(VpnOnDemandRule... onDemandRules) {
            return onDemandRules(Arrays.asList(onDemandRules));
        }

        public Builder onDemandRulesNextLink(String onDemandRulesNextLink) {
            this.onDemandRulesNextLink = onDemandRulesNextLink;
            this.changedFields = changedFields.add("onDemandRules");
            return this;
        }

        public Builder proxyServer(VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        public Builder optInToDeviceIdSharing(Boolean optInToDeviceIdSharing) {
            this.optInToDeviceIdSharing = optInToDeviceIdSharing;
            this.changedFields = changedFields.add("optInToDeviceIdSharing");
            return this;
        }

        public MacOSVpnConfiguration build() {
            MacOSVpnConfiguration _x = new MacOSVpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSVpnConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.connectionName = connectionName;
            _x.connectionType = connectionType;
            _x.loginGroupOrDomain = loginGroupOrDomain;
            _x.role = role;
            _x.realm = realm;
            _x.server = server;
            _x.identifier = identifier;
            _x.customData = customData;
            _x.customDataNextLink = customDataNextLink;
            _x.customKeyValueData = customKeyValueData;
            _x.customKeyValueDataNextLink = customKeyValueDataNextLink;
            _x.enableSplitTunneling = enableSplitTunneling;
            _x.authenticationMethod = authenticationMethod;
            _x.enablePerApp = enablePerApp;
            _x.safariDomains = safariDomains;
            _x.safariDomainsNextLink = safariDomainsNextLink;
            _x.onDemandRules = onDemandRules;
            _x.onDemandRulesNextLink = onDemandRulesNextLink;
            _x.proxyServer = proxyServer;
            _x.optInToDeviceIdSharing = optInToDeviceIdSharing;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Identity certificate for client authentication when authentication method is
     * certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public MacOSCertificateProfileBaseRequest getIdentityCertificate() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSVpnConfiguration _copy() {
        MacOSVpnConfiguration _x = new MacOSVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.connectionType = connectionType;
        _x.loginGroupOrDomain = loginGroupOrDomain;
        _x.role = role;
        _x.realm = realm;
        _x.server = server;
        _x.identifier = identifier;
        _x.customData = customData;
        _x.customKeyValueData = customKeyValueData;
        _x.enableSplitTunneling = enableSplitTunneling;
        _x.authenticationMethod = authenticationMethod;
        _x.enablePerApp = enablePerApp;
        _x.safariDomains = safariDomains;
        _x.onDemandRules = onDemandRules;
        _x.proxyServer = proxyServer;
        _x.optInToDeviceIdSharing = optInToDeviceIdSharing;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("loginGroupOrDomain=");
        b.append(this.loginGroupOrDomain);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("server=");
        b.append(this.server);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("customKeyValueData=");
        b.append(this.customKeyValueData);
        b.append(", ");
        b.append("enableSplitTunneling=");
        b.append(this.enableSplitTunneling);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("enablePerApp=");
        b.append(this.enablePerApp);
        b.append(", ");
        b.append("safariDomains=");
        b.append(this.safariDomains);
        b.append(", ");
        b.append("onDemandRules=");
        b.append(this.onDemandRules);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("optInToDeviceIdSharing=");
        b.append(this.optInToDeviceIdSharing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
