package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.MacOSPrivacyAccessControlItem;
import odata.msgraph.client.beta.enums.AppListType;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the macOSGeneralDeviceConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "compliantAppsList", 
    "compliantAppListType", 
    "emailInDomainSuffixes", 
    "passwordBlockSimple", 
    "passwordExpirationDays", 
    "passwordMinimumCharacterSetCount", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeLock", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordPreviousPasswordBlockCount", 
    "passwordRequiredType", 
    "passwordRequired", 
    "keychainBlockCloudSync", 
    "airPrintBlocked", 
    "airPrintForceTrustedTLS", 
    "airPrintBlockiBeaconDiscovery", 
    "safariBlockAutofill", 
    "cameraBlocked", 
    "iTunesBlockMusicService", 
    "spotlightBlockInternetResults", 
    "keyboardBlockDictation", 
    "definitionLookupBlocked", 
    "appleWatchBlockAutoUnlock", 
    "iTunesBlockFileSharing", 
    "iCloudBlockDocumentSync", 
    "iCloudBlockMail", 
    "iCloudBlockAddressBook", 
    "iCloudBlockCalendar", 
    "iCloudBlockReminders", 
    "iCloudBlockBookmarks", 
    "iCloudBlockNotes", 
    "airDropBlocked", 
    "passwordBlockModification", 
    "passwordBlockFingerprintUnlock", 
    "passwordBlockAutoFill", 
    "passwordBlockProximityRequests", 
    "passwordBlockAirDropSharing", 
    "softwareUpdatesEnforcedDelayInDays", 
    "softwareUpdatesForceDelayed", 
    "contentCachingBlocked", 
    "iCloudBlockPhotoLibrary", 
    "screenCaptureBlocked", 
    "classroomAppBlockRemoteScreenObservation", 
    "classroomAppForceUnpromptedScreenObservation", 
    "classroomForceAutomaticallyJoinClasses", 
    "classroomForceRequestPermissionToLeaveClasses", 
    "classroomForceUnpromptedAppAndDeviceLock", 
    "iCloudBlockActivityContinuation", 
    "privacyAccessControls"})
@JsonInclude(Include.NON_NULL)
public class MacOSGeneralDeviceConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSGeneralDeviceConfiguration";
    }

    @JsonProperty("compliantAppsList")
    protected List<AppListItem> compliantAppsList;

    @JsonProperty("compliantAppsList@nextLink")
    protected String compliantAppsListNextLink;

    @JsonProperty("compliantAppListType")
    protected AppListType compliantAppListType;

    @JsonProperty("emailInDomainSuffixes")
    protected List<String> emailInDomainSuffixes;

    @JsonProperty("emailInDomainSuffixes@nextLink")
    protected String emailInDomainSuffixesNextLink;

    @JsonProperty("passwordBlockSimple")
    protected Boolean passwordBlockSimple;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeLock")
    protected Integer passwordMinutesOfInactivityBeforeLock;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("keychainBlockCloudSync")
    protected Boolean keychainBlockCloudSync;

    @JsonProperty("airPrintBlocked")
    protected Boolean airPrintBlocked;

    @JsonProperty("airPrintForceTrustedTLS")
    protected Boolean airPrintForceTrustedTLS;

    @JsonProperty("airPrintBlockiBeaconDiscovery")
    protected Boolean airPrintBlockiBeaconDiscovery;

    @JsonProperty("safariBlockAutofill")
    protected Boolean safariBlockAutofill;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("iTunesBlockMusicService")
    protected Boolean iTunesBlockMusicService;

    @JsonProperty("spotlightBlockInternetResults")
    protected Boolean spotlightBlockInternetResults;

    @JsonProperty("keyboardBlockDictation")
    protected Boolean keyboardBlockDictation;

    @JsonProperty("definitionLookupBlocked")
    protected Boolean definitionLookupBlocked;

    @JsonProperty("appleWatchBlockAutoUnlock")
    protected Boolean appleWatchBlockAutoUnlock;

    @JsonProperty("iTunesBlockFileSharing")
    protected Boolean iTunesBlockFileSharing;

    @JsonProperty("iCloudBlockDocumentSync")
    protected Boolean iCloudBlockDocumentSync;

    @JsonProperty("iCloudBlockMail")
    protected Boolean iCloudBlockMail;

    @JsonProperty("iCloudBlockAddressBook")
    protected Boolean iCloudBlockAddressBook;

    @JsonProperty("iCloudBlockCalendar")
    protected Boolean iCloudBlockCalendar;

    @JsonProperty("iCloudBlockReminders")
    protected Boolean iCloudBlockReminders;

    @JsonProperty("iCloudBlockBookmarks")
    protected Boolean iCloudBlockBookmarks;

    @JsonProperty("iCloudBlockNotes")
    protected Boolean iCloudBlockNotes;

    @JsonProperty("airDropBlocked")
    protected Boolean airDropBlocked;

    @JsonProperty("passwordBlockModification")
    protected Boolean passwordBlockModification;

    @JsonProperty("passwordBlockFingerprintUnlock")
    protected Boolean passwordBlockFingerprintUnlock;

    @JsonProperty("passwordBlockAutoFill")
    protected Boolean passwordBlockAutoFill;

    @JsonProperty("passwordBlockProximityRequests")
    protected Boolean passwordBlockProximityRequests;

    @JsonProperty("passwordBlockAirDropSharing")
    protected Boolean passwordBlockAirDropSharing;

    @JsonProperty("softwareUpdatesEnforcedDelayInDays")
    protected Integer softwareUpdatesEnforcedDelayInDays;

    @JsonProperty("softwareUpdatesForceDelayed")
    protected Boolean softwareUpdatesForceDelayed;

    @JsonProperty("contentCachingBlocked")
    protected Boolean contentCachingBlocked;

    @JsonProperty("iCloudBlockPhotoLibrary")
    protected Boolean iCloudBlockPhotoLibrary;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("classroomAppBlockRemoteScreenObservation")
    protected Boolean classroomAppBlockRemoteScreenObservation;

    @JsonProperty("classroomAppForceUnpromptedScreenObservation")
    protected Boolean classroomAppForceUnpromptedScreenObservation;

    @JsonProperty("classroomForceAutomaticallyJoinClasses")
    protected Boolean classroomForceAutomaticallyJoinClasses;

    @JsonProperty("classroomForceRequestPermissionToLeaveClasses")
    protected Boolean classroomForceRequestPermissionToLeaveClasses;

    @JsonProperty("classroomForceUnpromptedAppAndDeviceLock")
    protected Boolean classroomForceUnpromptedAppAndDeviceLock;

    @JsonProperty("iCloudBlockActivityContinuation")
    protected Boolean iCloudBlockActivityContinuation;

    @JsonProperty("privacyAccessControls")
    protected List<MacOSPrivacyAccessControlItem> privacyAccessControls;

    @JsonProperty("privacyAccessControls@nextLink")
    protected String privacyAccessControlsNextLink;

    protected MacOSGeneralDeviceConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSGeneralDeviceConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private List<AppListItem> compliantAppsList;
        private String compliantAppsListNextLink;
        private AppListType compliantAppListType;
        private List<String> emailInDomainSuffixes;
        private String emailInDomainSuffixesNextLink;
        private Boolean passwordBlockSimple;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumCharacterSetCount;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeLock;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private Integer passwordPreviousPasswordBlockCount;
        private RequiredPasswordType passwordRequiredType;
        private Boolean passwordRequired;
        private Boolean keychainBlockCloudSync;
        private Boolean airPrintBlocked;
        private Boolean airPrintForceTrustedTLS;
        private Boolean airPrintBlockiBeaconDiscovery;
        private Boolean safariBlockAutofill;
        private Boolean cameraBlocked;
        private Boolean iTunesBlockMusicService;
        private Boolean spotlightBlockInternetResults;
        private Boolean keyboardBlockDictation;
        private Boolean definitionLookupBlocked;
        private Boolean appleWatchBlockAutoUnlock;
        private Boolean iTunesBlockFileSharing;
        private Boolean iCloudBlockDocumentSync;
        private Boolean iCloudBlockMail;
        private Boolean iCloudBlockAddressBook;
        private Boolean iCloudBlockCalendar;
        private Boolean iCloudBlockReminders;
        private Boolean iCloudBlockBookmarks;
        private Boolean iCloudBlockNotes;
        private Boolean airDropBlocked;
        private Boolean passwordBlockModification;
        private Boolean passwordBlockFingerprintUnlock;
        private Boolean passwordBlockAutoFill;
        private Boolean passwordBlockProximityRequests;
        private Boolean passwordBlockAirDropSharing;
        private Integer softwareUpdatesEnforcedDelayInDays;
        private Boolean softwareUpdatesForceDelayed;
        private Boolean contentCachingBlocked;
        private Boolean iCloudBlockPhotoLibrary;
        private Boolean screenCaptureBlocked;
        private Boolean classroomAppBlockRemoteScreenObservation;
        private Boolean classroomAppForceUnpromptedScreenObservation;
        private Boolean classroomForceAutomaticallyJoinClasses;
        private Boolean classroomForceRequestPermissionToLeaveClasses;
        private Boolean classroomForceUnpromptedAppAndDeviceLock;
        private Boolean iCloudBlockActivityContinuation;
        private List<MacOSPrivacyAccessControlItem> privacyAccessControls;
        private String privacyAccessControlsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(List<AppListItem> compliantAppsList) {
            this.compliantAppsList = compliantAppsList;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(AppListItem... compliantAppsList) {
            return compliantAppsList(Arrays.asList(compliantAppsList));
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsListNextLink
         *            value of {@code compliantAppsList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsListNextLink(String compliantAppsListNextLink) {
            this.compliantAppsListNextLink = compliantAppsListNextLink;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“List that is in the CompliantAppsList.”</i>
         * 
         * @param compliantAppListType
         *            value of {@code compliantAppListType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppListType(AppListType compliantAppListType) {
            this.compliantAppListType = compliantAppListType;
            this.changedFields = changedFields.add("compliantAppListType");
            return this;
        }

        /**
         * <i>“An email address lacking a suffix that matches any of these strings will be
         * considered out-of-domain.”</i>
         * 
         * @param emailInDomainSuffixes
         *            value of {@code emailInDomainSuffixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailInDomainSuffixes(List<String> emailInDomainSuffixes) {
            this.emailInDomainSuffixes = emailInDomainSuffixes;
            this.changedFields = changedFields.add("emailInDomainSuffixes");
            return this;
        }

        /**
         * <i>“An email address lacking a suffix that matches any of these strings will be
         * considered out-of-domain.”</i>
         * 
         * @param emailInDomainSuffixes
         *            value of {@code emailInDomainSuffixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailInDomainSuffixes(String... emailInDomainSuffixes) {
            return emailInDomainSuffixes(Arrays.asList(emailInDomainSuffixes));
        }

        /**
         * <i>“An email address lacking a suffix that matches any of these strings will be
         * considered out-of-domain.”</i>
         * 
         * @param emailInDomainSuffixesNextLink
         *            value of {@code emailInDomainSuffixes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailInDomainSuffixesNextLink(String emailInDomainSuffixesNextLink) {
            this.emailInDomainSuffixesNextLink = emailInDomainSuffixesNextLink;
            this.changedFields = changedFields.add("emailInDomainSuffixes");
            return this;
        }

        /**
         * <i>“Block simple passwords.”</i>
         * 
         * @param passwordBlockSimple
         *            value of {@code passwordBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockSimple(Boolean passwordBlockSimple) {
            this.passwordBlockSimple = passwordBlockSimple;
            this.changedFields = changedFields.add("passwordBlockSimple");
            return this;
        }

        /**
         * <i>“Number of days before the password expires.”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Number of character sets a password must contain. Valid values 0 to 4”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“Minimum length of passwords.”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity required before a password is required.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeLock
         *            value of {@code passwordMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
            this.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“Minutes of inactivity required before the screen times out.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Number of previous passwords to block.”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Type of password that is required.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Whether or not to require a password.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Indicates whether or not iCloud keychain synchronization is blocked (macOS 10.12
         * and later).”</i>
         * 
         * @param keychainBlockCloudSync
         *            value of {@code keychainBlockCloudSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keychainBlockCloudSync(Boolean keychainBlockCloudSync) {
            this.keychainBlockCloudSync = keychainBlockCloudSync;
            this.changedFields = changedFields.add("keychainBlockCloudSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not AirPrint is blocked (macOS 10.12 and later).”</i>
         * 
         * @param airPrintBlocked
         *            value of {@code airPrintBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintBlocked(Boolean airPrintBlocked) {
            this.airPrintBlocked = airPrintBlocked;
            this.changedFields = changedFields.add("airPrintBlocked");
            return this;
        }

        /**
         * <i>“Indicates if trusted certificates are required for TLS printing communication (
         * macOS 10.13 and later).”</i>
         * 
         * @param airPrintForceTrustedTLS
         *            value of {@code airPrintForceTrustedTLS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintForceTrustedTLS(Boolean airPrintForceTrustedTLS) {
            this.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
            this.changedFields = changedFields.add("airPrintForceTrustedTLS");
            return this;
        }

        /**
         * <i>“Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This
         * prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (
         * macOS 10.3 and later).”</i>
         * 
         * @param airPrintBlockiBeaconDiscovery
         *            value of {@code airPrintBlockiBeaconDiscovery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintBlockiBeaconDiscovery(Boolean airPrintBlockiBeaconDiscovery) {
            this.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
            this.changedFields = changedFields.add("airPrintBlockiBeaconDiscovery");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using Auto fill in Safari.”</i>
         * 
         * @param safariBlockAutofill
         *            value of {@code safariBlockAutofill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariBlockAutofill(Boolean safariBlockAutofill) {
            this.safariBlockAutofill = safariBlockAutofill;
            this.changedFields = changedFields.add("safariBlockAutofill");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from accessing the camera of the
         * device.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Music service and revert Music app to classic
         * mode.”</i>
         * 
         * @param iTunesBlockMusicService
         *            value of {@code iTunesBlockMusicService} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesBlockMusicService(Boolean iTunesBlockMusicService) {
            this.iTunesBlockMusicService = iTunesBlockMusicService;
            this.changedFields = changedFields.add("iTunesBlockMusicService");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Spotlight from returning any results from an
         * Internet search.”</i>
         * 
         * @param spotlightBlockInternetResults
         *            value of {@code spotlightBlockInternetResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder spotlightBlockInternetResults(Boolean spotlightBlockInternetResults) {
            this.spotlightBlockInternetResults = spotlightBlockInternetResults;
            this.changedFields = changedFields.add("spotlightBlockInternetResults");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using dictation input.”</i>
         * 
         * @param keyboardBlockDictation
         *            value of {@code keyboardBlockDictation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardBlockDictation(Boolean keyboardBlockDictation) {
            this.keyboardBlockDictation = keyboardBlockDictation;
            this.changedFields = changedFields.add("keyboardBlockDictation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block definition lookup.”</i>
         * 
         * @param definitionLookupBlocked
         *            value of {@code definitionLookupBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder definitionLookupBlocked(Boolean definitionLookupBlocked) {
            this.definitionLookupBlocked = definitionLookupBlocked;
            this.changedFields = changedFields.add("definitionLookupBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or to block users from unlocking their Mac with Apple Watch.”</i>
         * 
         * @param appleWatchBlockAutoUnlock
         *            value of {@code appleWatchBlockAutoUnlock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleWatchBlockAutoUnlock(Boolean appleWatchBlockAutoUnlock) {
            this.appleWatchBlockAutoUnlock = appleWatchBlockAutoUnlock;
            this.changedFields = changedFields.add("appleWatchBlockAutoUnlock");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block files from being transferred using iTunes.”</i>
         * 
         * @param iTunesBlockFileSharing
         *            value of {@code iTunesBlockFileSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesBlockFileSharing(Boolean iTunesBlockFileSharing) {
            this.iTunesBlockFileSharing = iTunesBlockFileSharing;
            this.changedFields = changedFields.add("iTunesBlockFileSharing");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud document sync.”</i>
         * 
         * @param iCloudBlockDocumentSync
         *            value of {@code iCloudBlockDocumentSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockDocumentSync(Boolean iCloudBlockDocumentSync) {
            this.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
            this.changedFields = changedFields.add("iCloudBlockDocumentSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud from syncing mail.”</i>
         * 
         * @param iCloudBlockMail
         *            value of {@code iCloudBlockMail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockMail(Boolean iCloudBlockMail) {
            this.iCloudBlockMail = iCloudBlockMail;
            this.changedFields = changedFields.add("iCloudBlockMail");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud from syncing contacts.”</i>
         * 
         * @param iCloudBlockAddressBook
         *            value of {@code iCloudBlockAddressBook} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockAddressBook(Boolean iCloudBlockAddressBook) {
            this.iCloudBlockAddressBook = iCloudBlockAddressBook;
            this.changedFields = changedFields.add("iCloudBlockAddressBook");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud from syncing calendars.”</i>
         * 
         * @param iCloudBlockCalendar
         *            value of {@code iCloudBlockCalendar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockCalendar(Boolean iCloudBlockCalendar) {
            this.iCloudBlockCalendar = iCloudBlockCalendar;
            this.changedFields = changedFields.add("iCloudBlockCalendar");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud from syncing reminders.”</i>
         * 
         * @param iCloudBlockReminders
         *            value of {@code iCloudBlockReminders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockReminders(Boolean iCloudBlockReminders) {
            this.iCloudBlockReminders = iCloudBlockReminders;
            this.changedFields = changedFields.add("iCloudBlockReminders");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud from syncing bookmarks.”</i>
         * 
         * @param iCloudBlockBookmarks
         *            value of {@code iCloudBlockBookmarks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockBookmarks(Boolean iCloudBlockBookmarks) {
            this.iCloudBlockBookmarks = iCloudBlockBookmarks;
            this.changedFields = changedFields.add("iCloudBlockBookmarks");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud from syncing notes.”</i>
         * 
         * @param iCloudBlockNotes
         *            value of {@code iCloudBlockNotes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockNotes(Boolean iCloudBlockNotes) {
            this.iCloudBlockNotes = iCloudBlockNotes;
            this.changedFields = changedFields.add("iCloudBlockNotes");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow AirDrop.”</i>
         * 
         * @param airDropBlocked
         *            value of {@code airDropBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airDropBlocked(Boolean airDropBlocked) {
            this.airDropBlocked = airDropBlocked;
            this.changedFields = changedFields.add("airDropBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow passcode modification.”</i>
         * 
         * @param passwordBlockModification
         *            value of {@code passwordBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockModification(Boolean passwordBlockModification) {
            this.passwordBlockModification = passwordBlockModification;
            this.changedFields = changedFields.add("passwordBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block fingerprint unlock.”</i>
         * 
         * @param passwordBlockFingerprintUnlock
         *            value of {@code passwordBlockFingerprintUnlock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockFingerprintUnlock(Boolean passwordBlockFingerprintUnlock) {
            this.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
            this.changedFields = changedFields.add("passwordBlockFingerprintUnlock");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the AutoFill Passwords feature.”</i>
         * 
         * @param passwordBlockAutoFill
         *            value of {@code passwordBlockAutoFill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockAutoFill(Boolean passwordBlockAutoFill) {
            this.passwordBlockAutoFill = passwordBlockAutoFill;
            this.changedFields = changedFields.add("passwordBlockAutoFill");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block requesting passwords from nearby devices.”</i>
         * 
         * @param passwordBlockProximityRequests
         *            value of {@code passwordBlockProximityRequests} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockProximityRequests(Boolean passwordBlockProximityRequests) {
            this.passwordBlockProximityRequests = passwordBlockProximityRequests;
            this.changedFields = changedFields.add("passwordBlockProximityRequests");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block sharing passwords with the AirDrop passwords
         * feature.”</i>
         * 
         * @param passwordBlockAirDropSharing
         *            value of {@code passwordBlockAirDropSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockAirDropSharing(Boolean passwordBlockAirDropSharing) {
            this.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
            this.changedFields = changedFields.add("passwordBlockAirDropSharing");
            return this;
        }

        /**
         * <i>“Sets how many days a software update will be delyed for a supervised device.
         * Valid values 0 to 90”</i>
         * 
         * @param softwareUpdatesEnforcedDelayInDays
         *            value of {@code softwareUpdatesEnforcedDelayInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder softwareUpdatesEnforcedDelayInDays(Integer softwareUpdatesEnforcedDelayInDays) {
            this.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
            this.changedFields = changedFields.add("softwareUpdatesEnforcedDelayInDays");
            return this;
        }

        /**
         * <i>“Indicates whether or not to delay user visibility of software updates when the
         * device is in supervised mode.”</i>
         * 
         * @param softwareUpdatesForceDelayed
         *            value of {@code softwareUpdatesForceDelayed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder softwareUpdatesForceDelayed(Boolean softwareUpdatesForceDelayed) {
            this.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
            this.changedFields = changedFields.add("softwareUpdatesForceDelayed");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow content caching.”</i>
         * 
         * @param contentCachingBlocked
         *            value of {@code contentCachingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingBlocked(Boolean contentCachingBlocked) {
            this.contentCachingBlocked = contentCachingBlocked;
            this.changedFields = changedFields.add("contentCachingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud Photo Library.”</i>
         * 
         * @param iCloudBlockPhotoLibrary
         *            value of {@code iCloudBlockPhotoLibrary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockPhotoLibrary(Boolean iCloudBlockPhotoLibrary) {
            this.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
            this.changedFields = changedFields.add("iCloudBlockPhotoLibrary");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from taking Screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow remote screen observation by Classroom app.
         * Requires MDM enrollment via Apple School Manager or Apple Business Manager.”</i>
         * 
         * @param classroomAppBlockRemoteScreenObservation
         *            value of {@code classroomAppBlockRemoteScreenObservation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomAppBlockRemoteScreenObservation(Boolean classroomAppBlockRemoteScreenObservation) {
            this.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
            this.changedFields = changedFields.add("classroomAppBlockRemoteScreenObservation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to automatically give permission to the teacher of a
         * managed course on the Classroom app to view a student's screen without prompting
         * . Requires MDM enrollment via Apple School Manager or Apple Business Manager.”</i>
         * 
         * @param classroomAppForceUnpromptedScreenObservation
         *            value of {@code classroomAppForceUnpromptedScreenObservation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomAppForceUnpromptedScreenObservation(Boolean classroomAppForceUnpromptedScreenObservation) {
            this.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
            this.changedFields = changedFields.add("classroomAppForceUnpromptedScreenObservation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to automatically give permission to the teacher's
         * requests, without prompting the student. Requires MDM enrollment via Apple
         * School Manager or Apple Business Manager.”</i>
         * 
         * @param classroomForceAutomaticallyJoinClasses
         *            value of {@code classroomForceAutomaticallyJoinClasses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomForceAutomaticallyJoinClasses(Boolean classroomForceAutomaticallyJoinClasses) {
            this.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
            this.changedFields = changedFields.add("classroomForceAutomaticallyJoinClasses");
            return this;
        }

        /**
         * <i>“Indicates whether a student enrolled in an unmanaged course via Classroom will
         * be required to request permission from the teacher when attempting to leave the
         * course. Requires MDM enrollment via Apple School Manager or Apple Business
         * Manager.”</i>
         * 
         * @param classroomForceRequestPermissionToLeaveClasses
         *            value of {@code classroomForceRequestPermissionToLeaveClasses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomForceRequestPermissionToLeaveClasses(Boolean classroomForceRequestPermissionToLeaveClasses) {
            this.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
            this.changedFields = changedFields.add("classroomForceRequestPermissionToLeaveClasses");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the teacher to lock apps or the device without
         * prompting the student. Requires MDM enrollment via Apple School Manager or Apple
         * Business Manager.”</i>
         * 
         * @param classroomForceUnpromptedAppAndDeviceLock
         *            value of {@code classroomForceUnpromptedAppAndDeviceLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomForceUnpromptedAppAndDeviceLock(Boolean classroomForceUnpromptedAppAndDeviceLock) {
            this.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
            this.changedFields = changedFields.add("classroomForceUnpromptedAppAndDeviceLock");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from continuing work that they
         * started on a MacOS device on another iOS or MacOS device (MacOS 10.15 or later).”</i>
         * 
         * @param iCloudBlockActivityContinuation
         *            value of {@code iCloudBlockActivityContinuation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockActivityContinuation(Boolean iCloudBlockActivityContinuation) {
            this.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
            this.changedFields = changedFields.add("iCloudBlockActivityContinuation");
            return this;
        }

        /**
         * <i>“List of privacy preference policy controls. This collection can contain a
         * maximum of 10000 elements.”</i>
         * 
         * @param privacyAccessControls
         *            value of {@code privacyAccessControls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAccessControls(List<MacOSPrivacyAccessControlItem> privacyAccessControls) {
            this.privacyAccessControls = privacyAccessControls;
            this.changedFields = changedFields.add("privacyAccessControls");
            return this;
        }

        /**
         * <i>“List of privacy preference policy controls. This collection can contain a
         * maximum of 10000 elements.”</i>
         * 
         * @param privacyAccessControls
         *            value of {@code privacyAccessControls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAccessControls(MacOSPrivacyAccessControlItem... privacyAccessControls) {
            return privacyAccessControls(Arrays.asList(privacyAccessControls));
        }

        /**
         * <i>“List of privacy preference policy controls. This collection can contain a
         * maximum of 10000 elements.”</i>
         * 
         * @param privacyAccessControlsNextLink
         *            value of {@code privacyAccessControls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAccessControlsNextLink(String privacyAccessControlsNextLink) {
            this.privacyAccessControlsNextLink = privacyAccessControlsNextLink;
            this.changedFields = changedFields.add("privacyAccessControls");
            return this;
        }

        public MacOSGeneralDeviceConfiguration build() {
            MacOSGeneralDeviceConfiguration _x = new MacOSGeneralDeviceConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSGeneralDeviceConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.compliantAppsList = compliantAppsList;
            _x.compliantAppsListNextLink = compliantAppsListNextLink;
            _x.compliantAppListType = compliantAppListType;
            _x.emailInDomainSuffixes = emailInDomainSuffixes;
            _x.emailInDomainSuffixesNextLink = emailInDomainSuffixesNextLink;
            _x.passwordBlockSimple = passwordBlockSimple;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordRequired = passwordRequired;
            _x.keychainBlockCloudSync = keychainBlockCloudSync;
            _x.airPrintBlocked = airPrintBlocked;
            _x.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
            _x.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
            _x.safariBlockAutofill = safariBlockAutofill;
            _x.cameraBlocked = cameraBlocked;
            _x.iTunesBlockMusicService = iTunesBlockMusicService;
            _x.spotlightBlockInternetResults = spotlightBlockInternetResults;
            _x.keyboardBlockDictation = keyboardBlockDictation;
            _x.definitionLookupBlocked = definitionLookupBlocked;
            _x.appleWatchBlockAutoUnlock = appleWatchBlockAutoUnlock;
            _x.iTunesBlockFileSharing = iTunesBlockFileSharing;
            _x.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
            _x.iCloudBlockMail = iCloudBlockMail;
            _x.iCloudBlockAddressBook = iCloudBlockAddressBook;
            _x.iCloudBlockCalendar = iCloudBlockCalendar;
            _x.iCloudBlockReminders = iCloudBlockReminders;
            _x.iCloudBlockBookmarks = iCloudBlockBookmarks;
            _x.iCloudBlockNotes = iCloudBlockNotes;
            _x.airDropBlocked = airDropBlocked;
            _x.passwordBlockModification = passwordBlockModification;
            _x.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
            _x.passwordBlockAutoFill = passwordBlockAutoFill;
            _x.passwordBlockProximityRequests = passwordBlockProximityRequests;
            _x.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
            _x.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
            _x.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
            _x.contentCachingBlocked = contentCachingBlocked;
            _x.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
            _x.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
            _x.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
            _x.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
            _x.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
            _x.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
            _x.privacyAccessControls = privacyAccessControls;
            _x.privacyAccessControlsNextLink = privacyAccessControlsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List that is in the CompliantAppsList.”</i>
     * 
     * @return property compliantAppListType
     */
    @Property(name="compliantAppListType")
    @JsonIgnore
    public Optional<AppListType> getCompliantAppListType() {
        return Optional.ofNullable(compliantAppListType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantAppListType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List that is in the CompliantAppsList.”</i>
     * 
     * @param compliantAppListType
     *            new value of {@code compliantAppListType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantAppListType} field changed
     */
    public MacOSGeneralDeviceConfiguration withCompliantAppListType(AppListType compliantAppListType) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("compliantAppListType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.compliantAppListType = compliantAppListType;
        return _x;
    }

    /**
     * <i>“An email address lacking a suffix that matches any of these strings will be
     * considered out-of-domain.”</i>
     * 
     * @return property emailInDomainSuffixes
     */
    @Property(name="emailInDomainSuffixes")
    @JsonIgnore
    public CollectionPage<String> getEmailInDomainSuffixes() {
        return new CollectionPage<String>(contextPath, String.class, emailInDomainSuffixes, Optional.ofNullable(emailInDomainSuffixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“An email address lacking a suffix that matches any of these strings will be
     * considered out-of-domain.”</i>
     * 
     * @return property emailInDomainSuffixes
     */
    @Property(name="emailInDomainSuffixes")
    @JsonIgnore
    public CollectionPage<String> getEmailInDomainSuffixes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, emailInDomainSuffixes, Optional.ofNullable(emailInDomainSuffixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Block simple passwords.”</i>
     * 
     * @return property passwordBlockSimple
     */
    @Property(name="passwordBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockSimple() {
        return Optional.ofNullable(passwordBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Block simple passwords.”</i>
     * 
     * @param passwordBlockSimple
     *            new value of {@code passwordBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockSimple} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordBlockSimple(Boolean passwordBlockSimple) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordBlockSimple = passwordBlockSimple;
        return _x;
    }

    /**
     * <i>“Number of days before the password expires.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before the password expires.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordExpirationDays(Integer passwordExpirationDays) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Number of character sets a password must contain. Valid values 0 to 4”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of character sets a password must contain. Valid values 0 to 4”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“Minimum length of passwords.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum length of passwords.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity required before a password is required.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeLock
     */
    @Property(name="passwordMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity required before a password is required.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeLock
     *            new value of {@code passwordMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeLock} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity required before the screen times out.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity required before the screen times out.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Number of previous passwords to block.”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of previous passwords to block.”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Type of password that is required.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of password that is required.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Whether or not to require a password.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to require a password.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordRequired(Boolean passwordRequired) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Indicates whether or not iCloud keychain synchronization is blocked (macOS 10.12
     * and later).”</i>
     * 
     * @return property keychainBlockCloudSync
     */
    @Property(name="keychainBlockCloudSync")
    @JsonIgnore
    public Optional<Boolean> getKeychainBlockCloudSync() {
        return Optional.ofNullable(keychainBlockCloudSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keychainBlockCloudSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not iCloud keychain synchronization is blocked (macOS 10.12
     * and later).”</i>
     * 
     * @param keychainBlockCloudSync
     *            new value of {@code keychainBlockCloudSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keychainBlockCloudSync} field changed
     */
    public MacOSGeneralDeviceConfiguration withKeychainBlockCloudSync(Boolean keychainBlockCloudSync) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keychainBlockCloudSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.keychainBlockCloudSync = keychainBlockCloudSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not AirPrint is blocked (macOS 10.12 and later).”</i>
     * 
     * @return property airPrintBlocked
     */
    @Property(name="airPrintBlocked")
    @JsonIgnore
    public Optional<Boolean> getAirPrintBlocked() {
        return Optional.ofNullable(airPrintBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code airPrintBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not AirPrint is blocked (macOS 10.12 and later).”</i>
     * 
     * @param airPrintBlocked
     *            new value of {@code airPrintBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintBlocked} field changed
     */
    public MacOSGeneralDeviceConfiguration withAirPrintBlocked(Boolean airPrintBlocked) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.airPrintBlocked = airPrintBlocked;
        return _x;
    }

    /**
     * <i>“Indicates if trusted certificates are required for TLS printing communication (
     * macOS 10.13 and later).”</i>
     * 
     * @return property airPrintForceTrustedTLS
     */
    @Property(name="airPrintForceTrustedTLS")
    @JsonIgnore
    public Optional<Boolean> getAirPrintForceTrustedTLS() {
        return Optional.ofNullable(airPrintForceTrustedTLS);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintForceTrustedTLS} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if trusted certificates are required for TLS printing communication (
     * macOS 10.13 and later).”</i>
     * 
     * @param airPrintForceTrustedTLS
     *            new value of {@code airPrintForceTrustedTLS} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintForceTrustedTLS} field changed
     */
    public MacOSGeneralDeviceConfiguration withAirPrintForceTrustedTLS(Boolean airPrintForceTrustedTLS) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintForceTrustedTLS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
        return _x;
    }

    /**
     * <i>“Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This
     * prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (
     * macOS 10.3 and later).”</i>
     * 
     * @return property airPrintBlockiBeaconDiscovery
     */
    @Property(name="airPrintBlockiBeaconDiscovery")
    @JsonIgnore
    public Optional<Boolean> getAirPrintBlockiBeaconDiscovery() {
        return Optional.ofNullable(airPrintBlockiBeaconDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintBlockiBeaconDiscovery} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This
     * prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (
     * macOS 10.3 and later).”</i>
     * 
     * @param airPrintBlockiBeaconDiscovery
     *            new value of {@code airPrintBlockiBeaconDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintBlockiBeaconDiscovery} field changed
     */
    public MacOSGeneralDeviceConfiguration withAirPrintBlockiBeaconDiscovery(Boolean airPrintBlockiBeaconDiscovery) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintBlockiBeaconDiscovery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using Auto fill in Safari.”</i>
     * 
     * @return property safariBlockAutofill
     */
    @Property(name="safariBlockAutofill")
    @JsonIgnore
    public Optional<Boolean> getSafariBlockAutofill() {
        return Optional.ofNullable(safariBlockAutofill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * safariBlockAutofill} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using Auto fill in Safari.”</i>
     * 
     * @param safariBlockAutofill
     *            new value of {@code safariBlockAutofill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariBlockAutofill} field changed
     */
    public MacOSGeneralDeviceConfiguration withSafariBlockAutofill(Boolean safariBlockAutofill) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariBlockAutofill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.safariBlockAutofill = safariBlockAutofill;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from accessing the camera of the
     * device.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from accessing the camera of the
     * device.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public MacOSGeneralDeviceConfiguration withCameraBlocked(Boolean cameraBlocked) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Music service and revert Music app to classic
     * mode.”</i>
     * 
     * @return property iTunesBlockMusicService
     */
    @Property(name="iTunesBlockMusicService")
    @JsonIgnore
    public Optional<Boolean> getITunesBlockMusicService() {
        return Optional.ofNullable(iTunesBlockMusicService);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iTunesBlockMusicService} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Music service and revert Music app to classic
     * mode.”</i>
     * 
     * @param iTunesBlockMusicService
     *            new value of {@code iTunesBlockMusicService} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesBlockMusicService} field changed
     */
    public MacOSGeneralDeviceConfiguration withITunesBlockMusicService(Boolean iTunesBlockMusicService) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iTunesBlockMusicService");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iTunesBlockMusicService = iTunesBlockMusicService;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Spotlight from returning any results from an
     * Internet search.”</i>
     * 
     * @return property spotlightBlockInternetResults
     */
    @Property(name="spotlightBlockInternetResults")
    @JsonIgnore
    public Optional<Boolean> getSpotlightBlockInternetResults() {
        return Optional.ofNullable(spotlightBlockInternetResults);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * spotlightBlockInternetResults} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Spotlight from returning any results from an
     * Internet search.”</i>
     * 
     * @param spotlightBlockInternetResults
     *            new value of {@code spotlightBlockInternetResults} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code spotlightBlockInternetResults} field changed
     */
    public MacOSGeneralDeviceConfiguration withSpotlightBlockInternetResults(Boolean spotlightBlockInternetResults) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("spotlightBlockInternetResults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.spotlightBlockInternetResults = spotlightBlockInternetResults;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using dictation input.”</i>
     * 
     * @return property keyboardBlockDictation
     */
    @Property(name="keyboardBlockDictation")
    @JsonIgnore
    public Optional<Boolean> getKeyboardBlockDictation() {
        return Optional.ofNullable(keyboardBlockDictation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardBlockDictation} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using dictation input.”</i>
     * 
     * @param keyboardBlockDictation
     *            new value of {@code keyboardBlockDictation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardBlockDictation} field changed
     */
    public MacOSGeneralDeviceConfiguration withKeyboardBlockDictation(Boolean keyboardBlockDictation) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyboardBlockDictation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.keyboardBlockDictation = keyboardBlockDictation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block definition lookup.”</i>
     * 
     * @return property definitionLookupBlocked
     */
    @Property(name="definitionLookupBlocked")
    @JsonIgnore
    public Optional<Boolean> getDefinitionLookupBlocked() {
        return Optional.ofNullable(definitionLookupBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * definitionLookupBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block definition lookup.”</i>
     * 
     * @param definitionLookupBlocked
     *            new value of {@code definitionLookupBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code definitionLookupBlocked} field changed
     */
    public MacOSGeneralDeviceConfiguration withDefinitionLookupBlocked(Boolean definitionLookupBlocked) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("definitionLookupBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.definitionLookupBlocked = definitionLookupBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or to block users from unlocking their Mac with Apple Watch.”</i>
     * 
     * @return property appleWatchBlockAutoUnlock
     */
    @Property(name="appleWatchBlockAutoUnlock")
    @JsonIgnore
    public Optional<Boolean> getAppleWatchBlockAutoUnlock() {
        return Optional.ofNullable(appleWatchBlockAutoUnlock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appleWatchBlockAutoUnlock} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or to block users from unlocking their Mac with Apple Watch.”</i>
     * 
     * @param appleWatchBlockAutoUnlock
     *            new value of {@code appleWatchBlockAutoUnlock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleWatchBlockAutoUnlock} field changed
     */
    public MacOSGeneralDeviceConfiguration withAppleWatchBlockAutoUnlock(Boolean appleWatchBlockAutoUnlock) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appleWatchBlockAutoUnlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.appleWatchBlockAutoUnlock = appleWatchBlockAutoUnlock;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block files from being transferred using iTunes.”</i>
     * 
     * @return property iTunesBlockFileSharing
     */
    @Property(name="iTunesBlockFileSharing")
    @JsonIgnore
    public Optional<Boolean> getITunesBlockFileSharing() {
        return Optional.ofNullable(iTunesBlockFileSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iTunesBlockFileSharing} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block files from being transferred using iTunes.”</i>
     * 
     * @param iTunesBlockFileSharing
     *            new value of {@code iTunesBlockFileSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesBlockFileSharing} field changed
     */
    public MacOSGeneralDeviceConfiguration withITunesBlockFileSharing(Boolean iTunesBlockFileSharing) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iTunesBlockFileSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iTunesBlockFileSharing = iTunesBlockFileSharing;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud document sync.”</i>
     * 
     * @return property iCloudBlockDocumentSync
     */
    @Property(name="iCloudBlockDocumentSync")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockDocumentSync() {
        return Optional.ofNullable(iCloudBlockDocumentSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockDocumentSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud document sync.”</i>
     * 
     * @param iCloudBlockDocumentSync
     *            new value of {@code iCloudBlockDocumentSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockDocumentSync} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockDocumentSync(Boolean iCloudBlockDocumentSync) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockDocumentSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud from syncing mail.”</i>
     * 
     * @return property iCloudBlockMail
     */
    @Property(name="iCloudBlockMail")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockMail() {
        return Optional.ofNullable(iCloudBlockMail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iCloudBlockMail}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud from syncing mail.”</i>
     * 
     * @param iCloudBlockMail
     *            new value of {@code iCloudBlockMail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockMail} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockMail(Boolean iCloudBlockMail) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockMail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockMail = iCloudBlockMail;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud from syncing contacts.”</i>
     * 
     * @return property iCloudBlockAddressBook
     */
    @Property(name="iCloudBlockAddressBook")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockAddressBook() {
        return Optional.ofNullable(iCloudBlockAddressBook);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockAddressBook} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud from syncing contacts.”</i>
     * 
     * @param iCloudBlockAddressBook
     *            new value of {@code iCloudBlockAddressBook} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockAddressBook} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockAddressBook(Boolean iCloudBlockAddressBook) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockAddressBook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockAddressBook = iCloudBlockAddressBook;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud from syncing calendars.”</i>
     * 
     * @return property iCloudBlockCalendar
     */
    @Property(name="iCloudBlockCalendar")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockCalendar() {
        return Optional.ofNullable(iCloudBlockCalendar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockCalendar} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud from syncing calendars.”</i>
     * 
     * @param iCloudBlockCalendar
     *            new value of {@code iCloudBlockCalendar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockCalendar} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockCalendar(Boolean iCloudBlockCalendar) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockCalendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockCalendar = iCloudBlockCalendar;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud from syncing reminders.”</i>
     * 
     * @return property iCloudBlockReminders
     */
    @Property(name="iCloudBlockReminders")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockReminders() {
        return Optional.ofNullable(iCloudBlockReminders);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockReminders} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud from syncing reminders.”</i>
     * 
     * @param iCloudBlockReminders
     *            new value of {@code iCloudBlockReminders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockReminders} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockReminders(Boolean iCloudBlockReminders) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockReminders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockReminders = iCloudBlockReminders;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud from syncing bookmarks.”</i>
     * 
     * @return property iCloudBlockBookmarks
     */
    @Property(name="iCloudBlockBookmarks")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockBookmarks() {
        return Optional.ofNullable(iCloudBlockBookmarks);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockBookmarks} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud from syncing bookmarks.”</i>
     * 
     * @param iCloudBlockBookmarks
     *            new value of {@code iCloudBlockBookmarks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockBookmarks} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockBookmarks(Boolean iCloudBlockBookmarks) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockBookmarks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockBookmarks = iCloudBlockBookmarks;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud from syncing notes.”</i>
     * 
     * @return property iCloudBlockNotes
     */
    @Property(name="iCloudBlockNotes")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockNotes() {
        return Optional.ofNullable(iCloudBlockNotes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iCloudBlockNotes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud from syncing notes.”</i>
     * 
     * @param iCloudBlockNotes
     *            new value of {@code iCloudBlockNotes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockNotes} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockNotes(Boolean iCloudBlockNotes) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockNotes = iCloudBlockNotes;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow AirDrop.”</i>
     * 
     * @return property airDropBlocked
     */
    @Property(name="airDropBlocked")
    @JsonIgnore
    public Optional<Boolean> getAirDropBlocked() {
        return Optional.ofNullable(airDropBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code airDropBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to allow AirDrop.”</i>
     * 
     * @param airDropBlocked
     *            new value of {@code airDropBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airDropBlocked} field changed
     */
    public MacOSGeneralDeviceConfiguration withAirDropBlocked(Boolean airDropBlocked) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airDropBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.airDropBlocked = airDropBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow passcode modification.”</i>
     * 
     * @return property passwordBlockModification
     */
    @Property(name="passwordBlockModification")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockModification() {
        return Optional.ofNullable(passwordBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow passcode modification.”</i>
     * 
     * @param passwordBlockModification
     *            new value of {@code passwordBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockModification} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordBlockModification(Boolean passwordBlockModification) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordBlockModification = passwordBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block fingerprint unlock.”</i>
     * 
     * @return property passwordBlockFingerprintUnlock
     */
    @Property(name="passwordBlockFingerprintUnlock")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockFingerprintUnlock() {
        return Optional.ofNullable(passwordBlockFingerprintUnlock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockFingerprintUnlock} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block fingerprint unlock.”</i>
     * 
     * @param passwordBlockFingerprintUnlock
     *            new value of {@code passwordBlockFingerprintUnlock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockFingerprintUnlock} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordBlockFingerprintUnlock(Boolean passwordBlockFingerprintUnlock) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockFingerprintUnlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the AutoFill Passwords feature.”</i>
     * 
     * @return property passwordBlockAutoFill
     */
    @Property(name="passwordBlockAutoFill")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockAutoFill() {
        return Optional.ofNullable(passwordBlockAutoFill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockAutoFill} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the AutoFill Passwords feature.”</i>
     * 
     * @param passwordBlockAutoFill
     *            new value of {@code passwordBlockAutoFill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockAutoFill} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordBlockAutoFill(Boolean passwordBlockAutoFill) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockAutoFill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordBlockAutoFill = passwordBlockAutoFill;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block requesting passwords from nearby devices.”</i>
     * 
     * @return property passwordBlockProximityRequests
     */
    @Property(name="passwordBlockProximityRequests")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockProximityRequests() {
        return Optional.ofNullable(passwordBlockProximityRequests);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockProximityRequests} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block requesting passwords from nearby devices.”</i>
     * 
     * @param passwordBlockProximityRequests
     *            new value of {@code passwordBlockProximityRequests} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockProximityRequests} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordBlockProximityRequests(Boolean passwordBlockProximityRequests) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockProximityRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordBlockProximityRequests = passwordBlockProximityRequests;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block sharing passwords with the AirDrop passwords
     * feature.”</i>
     * 
     * @return property passwordBlockAirDropSharing
     */
    @Property(name="passwordBlockAirDropSharing")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockAirDropSharing() {
        return Optional.ofNullable(passwordBlockAirDropSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockAirDropSharing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block sharing passwords with the AirDrop passwords
     * feature.”</i>
     * 
     * @param passwordBlockAirDropSharing
     *            new value of {@code passwordBlockAirDropSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockAirDropSharing} field changed
     */
    public MacOSGeneralDeviceConfiguration withPasswordBlockAirDropSharing(Boolean passwordBlockAirDropSharing) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockAirDropSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
        return _x;
    }

    /**
     * <i>“Sets how many days a software update will be delyed for a supervised device.
     * Valid values 0 to 90”</i>
     * 
     * @return property softwareUpdatesEnforcedDelayInDays
     */
    @Property(name="softwareUpdatesEnforcedDelayInDays")
    @JsonIgnore
    public Optional<Integer> getSoftwareUpdatesEnforcedDelayInDays() {
        return Optional.ofNullable(softwareUpdatesEnforcedDelayInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * softwareUpdatesEnforcedDelayInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Sets how many days a software update will be delyed for a supervised device.
     * Valid values 0 to 90”</i>
     * 
     * @param softwareUpdatesEnforcedDelayInDays
     *            new value of {@code softwareUpdatesEnforcedDelayInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code softwareUpdatesEnforcedDelayInDays} field changed
     */
    public MacOSGeneralDeviceConfiguration withSoftwareUpdatesEnforcedDelayInDays(Integer softwareUpdatesEnforcedDelayInDays) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("softwareUpdatesEnforcedDelayInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to delay user visibility of software updates when the
     * device is in supervised mode.”</i>
     * 
     * @return property softwareUpdatesForceDelayed
     */
    @Property(name="softwareUpdatesForceDelayed")
    @JsonIgnore
    public Optional<Boolean> getSoftwareUpdatesForceDelayed() {
        return Optional.ofNullable(softwareUpdatesForceDelayed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * softwareUpdatesForceDelayed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to delay user visibility of software updates when the
     * device is in supervised mode.”</i>
     * 
     * @param softwareUpdatesForceDelayed
     *            new value of {@code softwareUpdatesForceDelayed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code softwareUpdatesForceDelayed} field changed
     */
    public MacOSGeneralDeviceConfiguration withSoftwareUpdatesForceDelayed(Boolean softwareUpdatesForceDelayed) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("softwareUpdatesForceDelayed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow content caching.”</i>
     * 
     * @return property contentCachingBlocked
     */
    @Property(name="contentCachingBlocked")
    @JsonIgnore
    public Optional<Boolean> getContentCachingBlocked() {
        return Optional.ofNullable(contentCachingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow content caching.”</i>
     * 
     * @param contentCachingBlocked
     *            new value of {@code contentCachingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingBlocked} field changed
     */
    public MacOSGeneralDeviceConfiguration withContentCachingBlocked(Boolean contentCachingBlocked) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.contentCachingBlocked = contentCachingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud Photo Library.”</i>
     * 
     * @return property iCloudBlockPhotoLibrary
     */
    @Property(name="iCloudBlockPhotoLibrary")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockPhotoLibrary() {
        return Optional.ofNullable(iCloudBlockPhotoLibrary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockPhotoLibrary} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud Photo Library.”</i>
     * 
     * @param iCloudBlockPhotoLibrary
     *            new value of {@code iCloudBlockPhotoLibrary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockPhotoLibrary} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockPhotoLibrary(Boolean iCloudBlockPhotoLibrary) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockPhotoLibrary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from taking Screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from taking Screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public MacOSGeneralDeviceConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow remote screen observation by Classroom app.
     * Requires MDM enrollment via Apple School Manager or Apple Business Manager.”</i>
     * 
     * @return property classroomAppBlockRemoteScreenObservation
     */
    @Property(name="classroomAppBlockRemoteScreenObservation")
    @JsonIgnore
    public Optional<Boolean> getClassroomAppBlockRemoteScreenObservation() {
        return Optional.ofNullable(classroomAppBlockRemoteScreenObservation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomAppBlockRemoteScreenObservation} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow remote screen observation by Classroom app.
     * Requires MDM enrollment via Apple School Manager or Apple Business Manager.”</i>
     * 
     * @param classroomAppBlockRemoteScreenObservation
     *            new value of {@code classroomAppBlockRemoteScreenObservation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomAppBlockRemoteScreenObservation} field changed
     */
    public MacOSGeneralDeviceConfiguration withClassroomAppBlockRemoteScreenObservation(Boolean classroomAppBlockRemoteScreenObservation) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomAppBlockRemoteScreenObservation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to automatically give permission to the teacher of a
     * managed course on the Classroom app to view a student's screen without prompting
     * . Requires MDM enrollment via Apple School Manager or Apple Business Manager.”</i>
     * 
     * @return property classroomAppForceUnpromptedScreenObservation
     */
    @Property(name="classroomAppForceUnpromptedScreenObservation")
    @JsonIgnore
    public Optional<Boolean> getClassroomAppForceUnpromptedScreenObservation() {
        return Optional.ofNullable(classroomAppForceUnpromptedScreenObservation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomAppForceUnpromptedScreenObservation} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to automatically give permission to the teacher of a
     * managed course on the Classroom app to view a student's screen without prompting
     * . Requires MDM enrollment via Apple School Manager or Apple Business Manager.”</i>
     * 
     * @param classroomAppForceUnpromptedScreenObservation
     *            new value of {@code classroomAppForceUnpromptedScreenObservation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomAppForceUnpromptedScreenObservation} field changed
     */
    public MacOSGeneralDeviceConfiguration withClassroomAppForceUnpromptedScreenObservation(Boolean classroomAppForceUnpromptedScreenObservation) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomAppForceUnpromptedScreenObservation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to automatically give permission to the teacher's
     * requests, without prompting the student. Requires MDM enrollment via Apple
     * School Manager or Apple Business Manager.”</i>
     * 
     * @return property classroomForceAutomaticallyJoinClasses
     */
    @Property(name="classroomForceAutomaticallyJoinClasses")
    @JsonIgnore
    public Optional<Boolean> getClassroomForceAutomaticallyJoinClasses() {
        return Optional.ofNullable(classroomForceAutomaticallyJoinClasses);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomForceAutomaticallyJoinClasses} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to automatically give permission to the teacher's
     * requests, without prompting the student. Requires MDM enrollment via Apple
     * School Manager or Apple Business Manager.”</i>
     * 
     * @param classroomForceAutomaticallyJoinClasses
     *            new value of {@code classroomForceAutomaticallyJoinClasses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomForceAutomaticallyJoinClasses} field changed
     */
    public MacOSGeneralDeviceConfiguration withClassroomForceAutomaticallyJoinClasses(Boolean classroomForceAutomaticallyJoinClasses) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomForceAutomaticallyJoinClasses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
        return _x;
    }

    /**
     * <i>“Indicates whether a student enrolled in an unmanaged course via Classroom will
     * be required to request permission from the teacher when attempting to leave the
     * course. Requires MDM enrollment via Apple School Manager or Apple Business
     * Manager.”</i>
     * 
     * @return property classroomForceRequestPermissionToLeaveClasses
     */
    @Property(name="classroomForceRequestPermissionToLeaveClasses")
    @JsonIgnore
    public Optional<Boolean> getClassroomForceRequestPermissionToLeaveClasses() {
        return Optional.ofNullable(classroomForceRequestPermissionToLeaveClasses);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomForceRequestPermissionToLeaveClasses} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether a student enrolled in an unmanaged course via Classroom will
     * be required to request permission from the teacher when attempting to leave the
     * course. Requires MDM enrollment via Apple School Manager or Apple Business
     * Manager.”</i>
     * 
     * @param classroomForceRequestPermissionToLeaveClasses
     *            new value of {@code classroomForceRequestPermissionToLeaveClasses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomForceRequestPermissionToLeaveClasses} field changed
     */
    public MacOSGeneralDeviceConfiguration withClassroomForceRequestPermissionToLeaveClasses(Boolean classroomForceRequestPermissionToLeaveClasses) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomForceRequestPermissionToLeaveClasses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the teacher to lock apps or the device without
     * prompting the student. Requires MDM enrollment via Apple School Manager or Apple
     * Business Manager.”</i>
     * 
     * @return property classroomForceUnpromptedAppAndDeviceLock
     */
    @Property(name="classroomForceUnpromptedAppAndDeviceLock")
    @JsonIgnore
    public Optional<Boolean> getClassroomForceUnpromptedAppAndDeviceLock() {
        return Optional.ofNullable(classroomForceUnpromptedAppAndDeviceLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomForceUnpromptedAppAndDeviceLock} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the teacher to lock apps or the device without
     * prompting the student. Requires MDM enrollment via Apple School Manager or Apple
     * Business Manager.”</i>
     * 
     * @param classroomForceUnpromptedAppAndDeviceLock
     *            new value of {@code classroomForceUnpromptedAppAndDeviceLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomForceUnpromptedAppAndDeviceLock} field changed
     */
    public MacOSGeneralDeviceConfiguration withClassroomForceUnpromptedAppAndDeviceLock(Boolean classroomForceUnpromptedAppAndDeviceLock) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomForceUnpromptedAppAndDeviceLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from continuing work that they
     * started on a MacOS device on another iOS or MacOS device (MacOS 10.15 or later).”</i>
     * 
     * @return property iCloudBlockActivityContinuation
     */
    @Property(name="iCloudBlockActivityContinuation")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockActivityContinuation() {
        return Optional.ofNullable(iCloudBlockActivityContinuation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockActivityContinuation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from continuing work that they
     * started on a MacOS device on another iOS or MacOS device (MacOS 10.15 or later).”</i>
     * 
     * @param iCloudBlockActivityContinuation
     *            new value of {@code iCloudBlockActivityContinuation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockActivityContinuation} field changed
     */
    public MacOSGeneralDeviceConfiguration withICloudBlockActivityContinuation(Boolean iCloudBlockActivityContinuation) {
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockActivityContinuation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSGeneralDeviceConfiguration");
        _x.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
        return _x;
    }

    /**
     * <i>“List of privacy preference policy controls. This collection can contain a
     * maximum of 10000 elements.”</i>
     * 
     * @return property privacyAccessControls
     */
    @Property(name="privacyAccessControls")
    @JsonIgnore
    public CollectionPage<MacOSPrivacyAccessControlItem> getPrivacyAccessControls() {
        return new CollectionPage<MacOSPrivacyAccessControlItem>(contextPath, MacOSPrivacyAccessControlItem.class, privacyAccessControls, Optional.ofNullable(privacyAccessControlsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of privacy preference policy controls. This collection can contain a
     * maximum of 10000 elements.”</i>
     * 
     * @return property privacyAccessControls
     */
    @Property(name="privacyAccessControls")
    @JsonIgnore
    public CollectionPage<MacOSPrivacyAccessControlItem> getPrivacyAccessControls(HttpRequestOptions options) {
        return new CollectionPage<MacOSPrivacyAccessControlItem>(contextPath, MacOSPrivacyAccessControlItem.class, privacyAccessControls, Optional.ofNullable(privacyAccessControlsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSGeneralDeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSGeneralDeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSGeneralDeviceConfiguration _copy() {
        MacOSGeneralDeviceConfiguration _x = new MacOSGeneralDeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.compliantAppsList = compliantAppsList;
        _x.compliantAppListType = compliantAppListType;
        _x.emailInDomainSuffixes = emailInDomainSuffixes;
        _x.passwordBlockSimple = passwordBlockSimple;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordRequired = passwordRequired;
        _x.keychainBlockCloudSync = keychainBlockCloudSync;
        _x.airPrintBlocked = airPrintBlocked;
        _x.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
        _x.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
        _x.safariBlockAutofill = safariBlockAutofill;
        _x.cameraBlocked = cameraBlocked;
        _x.iTunesBlockMusicService = iTunesBlockMusicService;
        _x.spotlightBlockInternetResults = spotlightBlockInternetResults;
        _x.keyboardBlockDictation = keyboardBlockDictation;
        _x.definitionLookupBlocked = definitionLookupBlocked;
        _x.appleWatchBlockAutoUnlock = appleWatchBlockAutoUnlock;
        _x.iTunesBlockFileSharing = iTunesBlockFileSharing;
        _x.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
        _x.iCloudBlockMail = iCloudBlockMail;
        _x.iCloudBlockAddressBook = iCloudBlockAddressBook;
        _x.iCloudBlockCalendar = iCloudBlockCalendar;
        _x.iCloudBlockReminders = iCloudBlockReminders;
        _x.iCloudBlockBookmarks = iCloudBlockBookmarks;
        _x.iCloudBlockNotes = iCloudBlockNotes;
        _x.airDropBlocked = airDropBlocked;
        _x.passwordBlockModification = passwordBlockModification;
        _x.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
        _x.passwordBlockAutoFill = passwordBlockAutoFill;
        _x.passwordBlockProximityRequests = passwordBlockProximityRequests;
        _x.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
        _x.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
        _x.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
        _x.contentCachingBlocked = contentCachingBlocked;
        _x.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
        _x.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
        _x.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
        _x.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
        _x.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
        _x.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
        _x.privacyAccessControls = privacyAccessControls;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSGeneralDeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("compliantAppsList=");
        b.append(this.compliantAppsList);
        b.append(", ");
        b.append("compliantAppListType=");
        b.append(this.compliantAppListType);
        b.append(", ");
        b.append("emailInDomainSuffixes=");
        b.append(this.emailInDomainSuffixes);
        b.append(", ");
        b.append("passwordBlockSimple=");
        b.append(this.passwordBlockSimple);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeLock=");
        b.append(this.passwordMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("keychainBlockCloudSync=");
        b.append(this.keychainBlockCloudSync);
        b.append(", ");
        b.append("airPrintBlocked=");
        b.append(this.airPrintBlocked);
        b.append(", ");
        b.append("airPrintForceTrustedTLS=");
        b.append(this.airPrintForceTrustedTLS);
        b.append(", ");
        b.append("airPrintBlockiBeaconDiscovery=");
        b.append(this.airPrintBlockiBeaconDiscovery);
        b.append(", ");
        b.append("safariBlockAutofill=");
        b.append(this.safariBlockAutofill);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("iTunesBlockMusicService=");
        b.append(this.iTunesBlockMusicService);
        b.append(", ");
        b.append("spotlightBlockInternetResults=");
        b.append(this.spotlightBlockInternetResults);
        b.append(", ");
        b.append("keyboardBlockDictation=");
        b.append(this.keyboardBlockDictation);
        b.append(", ");
        b.append("definitionLookupBlocked=");
        b.append(this.definitionLookupBlocked);
        b.append(", ");
        b.append("appleWatchBlockAutoUnlock=");
        b.append(this.appleWatchBlockAutoUnlock);
        b.append(", ");
        b.append("iTunesBlockFileSharing=");
        b.append(this.iTunesBlockFileSharing);
        b.append(", ");
        b.append("iCloudBlockDocumentSync=");
        b.append(this.iCloudBlockDocumentSync);
        b.append(", ");
        b.append("iCloudBlockMail=");
        b.append(this.iCloudBlockMail);
        b.append(", ");
        b.append("iCloudBlockAddressBook=");
        b.append(this.iCloudBlockAddressBook);
        b.append(", ");
        b.append("iCloudBlockCalendar=");
        b.append(this.iCloudBlockCalendar);
        b.append(", ");
        b.append("iCloudBlockReminders=");
        b.append(this.iCloudBlockReminders);
        b.append(", ");
        b.append("iCloudBlockBookmarks=");
        b.append(this.iCloudBlockBookmarks);
        b.append(", ");
        b.append("iCloudBlockNotes=");
        b.append(this.iCloudBlockNotes);
        b.append(", ");
        b.append("airDropBlocked=");
        b.append(this.airDropBlocked);
        b.append(", ");
        b.append("passwordBlockModification=");
        b.append(this.passwordBlockModification);
        b.append(", ");
        b.append("passwordBlockFingerprintUnlock=");
        b.append(this.passwordBlockFingerprintUnlock);
        b.append(", ");
        b.append("passwordBlockAutoFill=");
        b.append(this.passwordBlockAutoFill);
        b.append(", ");
        b.append("passwordBlockProximityRequests=");
        b.append(this.passwordBlockProximityRequests);
        b.append(", ");
        b.append("passwordBlockAirDropSharing=");
        b.append(this.passwordBlockAirDropSharing);
        b.append(", ");
        b.append("softwareUpdatesEnforcedDelayInDays=");
        b.append(this.softwareUpdatesEnforcedDelayInDays);
        b.append(", ");
        b.append("softwareUpdatesForceDelayed=");
        b.append(this.softwareUpdatesForceDelayed);
        b.append(", ");
        b.append("contentCachingBlocked=");
        b.append(this.contentCachingBlocked);
        b.append(", ");
        b.append("iCloudBlockPhotoLibrary=");
        b.append(this.iCloudBlockPhotoLibrary);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("classroomAppBlockRemoteScreenObservation=");
        b.append(this.classroomAppBlockRemoteScreenObservation);
        b.append(", ");
        b.append("classroomAppForceUnpromptedScreenObservation=");
        b.append(this.classroomAppForceUnpromptedScreenObservation);
        b.append(", ");
        b.append("classroomForceAutomaticallyJoinClasses=");
        b.append(this.classroomForceAutomaticallyJoinClasses);
        b.append(", ");
        b.append("classroomForceRequestPermissionToLeaveClasses=");
        b.append(this.classroomForceRequestPermissionToLeaveClasses);
        b.append(", ");
        b.append("classroomForceUnpromptedAppAndDeviceLock=");
        b.append(this.classroomForceUnpromptedAppAndDeviceLock);
        b.append(", ");
        b.append("iCloudBlockActivityContinuation=");
        b.append(this.iCloudBlockActivityContinuation);
        b.append(", ");
        b.append("privacyAccessControls=");
        b.append(this.privacyAccessControls);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
