package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AirPrintDestination;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.IpRange;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.MacOSLaunchItem;
import odata.msgraph.client.beta.complex.MacOSSingleSignOnExtension;
import odata.msgraph.client.beta.complex.SingleSignOnExtension;
import odata.msgraph.client.beta.entity.request.MacOSCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.MacOSContentCachingClientPolicy;
import odata.msgraph.client.beta.enums.MacOSContentCachingParentSelectionPolicy;
import odata.msgraph.client.beta.enums.MacOSContentCachingPeerPolicy;
import odata.msgraph.client.beta.enums.MacOSContentCachingType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“MacOS device features configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "autoLaunchItems", 
    "adminShowHostInfo", 
    "loginWindowText", 
    "authorizedUsersListHidden", 
    "authorizedUsersListHideLocalUsers", 
    "authorizedUsersListHideMobileAccounts", 
    "authorizedUsersListIncludeNetworkUsers", 
    "authorizedUsersListHideAdminUsers", 
    "authorizedUsersListShowOtherManagedUsers", 
    "shutDownDisabled", 
    "restartDisabled", 
    "sleepDisabled", 
    "consoleAccessDisabled", 
    "shutDownDisabledWhileLoggedIn", 
    "restartDisabledWhileLoggedIn", 
    "powerOffDisabledWhileLoggedIn", 
    "logOutDisabledWhileLoggedIn", 
    "screenLockDisableImmediate", 
    "associatedDomains", 
    "singleSignOnExtension", 
    "macOSSingleSignOnExtension", 
    "contentCachingEnabled", 
    "contentCachingType", 
    "contentCachingMaxSizeBytes", 
    "contentCachingDataPath", 
    "contentCachingDisableConnectionSharing", 
    "contentCachingForceConnectionSharing", 
    "contentCachingClientPolicy", 
    "contentCachingClientListenRanges", 
    "contentCachingPeerPolicy", 
    "contentCachingPeerListenRanges", 
    "contentCachingPeerFilterRanges", 
    "contentCachingParentSelectionPolicy", 
    "contentCachingParents", 
    "contentCachingLogClientIdentities", 
    "contentCachingPublicRanges", 
    "contentCachingBlockDeletion", 
    "contentCachingShowAlerts", 
    "contentCachingKeepAwake", 
    "contentCachingPort"})
@JsonInclude(Include.NON_NULL)
public class MacOSDeviceFeaturesConfiguration extends AppleDeviceFeaturesConfigurationBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSDeviceFeaturesConfiguration";
    }

    @JsonProperty("autoLaunchItems")
    protected List<MacOSLaunchItem> autoLaunchItems;

    @JsonProperty("autoLaunchItems@nextLink")
    protected String autoLaunchItemsNextLink;

    @JsonProperty("adminShowHostInfo")
    protected Boolean adminShowHostInfo;

    @JsonProperty("loginWindowText")
    protected String loginWindowText;

    @JsonProperty("authorizedUsersListHidden")
    protected Boolean authorizedUsersListHidden;

    @JsonProperty("authorizedUsersListHideLocalUsers")
    protected Boolean authorizedUsersListHideLocalUsers;

    @JsonProperty("authorizedUsersListHideMobileAccounts")
    protected Boolean authorizedUsersListHideMobileAccounts;

    @JsonProperty("authorizedUsersListIncludeNetworkUsers")
    protected Boolean authorizedUsersListIncludeNetworkUsers;

    @JsonProperty("authorizedUsersListHideAdminUsers")
    protected Boolean authorizedUsersListHideAdminUsers;

    @JsonProperty("authorizedUsersListShowOtherManagedUsers")
    protected Boolean authorizedUsersListShowOtherManagedUsers;

    @JsonProperty("shutDownDisabled")
    protected Boolean shutDownDisabled;

    @JsonProperty("restartDisabled")
    protected Boolean restartDisabled;

    @JsonProperty("sleepDisabled")
    protected Boolean sleepDisabled;

    @JsonProperty("consoleAccessDisabled")
    protected Boolean consoleAccessDisabled;

    @JsonProperty("shutDownDisabledWhileLoggedIn")
    protected Boolean shutDownDisabledWhileLoggedIn;

    @JsonProperty("restartDisabledWhileLoggedIn")
    protected Boolean restartDisabledWhileLoggedIn;

    @JsonProperty("powerOffDisabledWhileLoggedIn")
    protected Boolean powerOffDisabledWhileLoggedIn;

    @JsonProperty("logOutDisabledWhileLoggedIn")
    protected Boolean logOutDisabledWhileLoggedIn;

    @JsonProperty("screenLockDisableImmediate")
    protected Boolean screenLockDisableImmediate;

    @JsonProperty("associatedDomains")
    protected List<KeyValuePair> associatedDomains;

    @JsonProperty("associatedDomains@nextLink")
    protected String associatedDomainsNextLink;

    @JsonProperty("singleSignOnExtension")
    protected SingleSignOnExtension singleSignOnExtension;

    @JsonProperty("macOSSingleSignOnExtension")
    protected MacOSSingleSignOnExtension macOSSingleSignOnExtension;

    @JsonProperty("contentCachingEnabled")
    protected Boolean contentCachingEnabled;

    @JsonProperty("contentCachingType")
    protected MacOSContentCachingType contentCachingType;

    @JsonProperty("contentCachingMaxSizeBytes")
    protected Integer contentCachingMaxSizeBytes;

    @JsonProperty("contentCachingDataPath")
    protected String contentCachingDataPath;

    @JsonProperty("contentCachingDisableConnectionSharing")
    protected Boolean contentCachingDisableConnectionSharing;

    @JsonProperty("contentCachingForceConnectionSharing")
    protected Boolean contentCachingForceConnectionSharing;

    @JsonProperty("contentCachingClientPolicy")
    protected MacOSContentCachingClientPolicy contentCachingClientPolicy;

    @JsonProperty("contentCachingClientListenRanges")
    protected List<IpRange> contentCachingClientListenRanges;

    @JsonProperty("contentCachingClientListenRanges@nextLink")
    protected String contentCachingClientListenRangesNextLink;

    @JsonProperty("contentCachingPeerPolicy")
    protected MacOSContentCachingPeerPolicy contentCachingPeerPolicy;

    @JsonProperty("contentCachingPeerListenRanges")
    protected List<IpRange> contentCachingPeerListenRanges;

    @JsonProperty("contentCachingPeerListenRanges@nextLink")
    protected String contentCachingPeerListenRangesNextLink;

    @JsonProperty("contentCachingPeerFilterRanges")
    protected List<IpRange> contentCachingPeerFilterRanges;

    @JsonProperty("contentCachingPeerFilterRanges@nextLink")
    protected String contentCachingPeerFilterRangesNextLink;

    @JsonProperty("contentCachingParentSelectionPolicy")
    protected MacOSContentCachingParentSelectionPolicy contentCachingParentSelectionPolicy;

    @JsonProperty("contentCachingParents")
    protected List<String> contentCachingParents;

    @JsonProperty("contentCachingParents@nextLink")
    protected String contentCachingParentsNextLink;

    @JsonProperty("contentCachingLogClientIdentities")
    protected Boolean contentCachingLogClientIdentities;

    @JsonProperty("contentCachingPublicRanges")
    protected List<IpRange> contentCachingPublicRanges;

    @JsonProperty("contentCachingPublicRanges@nextLink")
    protected String contentCachingPublicRangesNextLink;

    @JsonProperty("contentCachingBlockDeletion")
    protected Boolean contentCachingBlockDeletion;

    @JsonProperty("contentCachingShowAlerts")
    protected Boolean contentCachingShowAlerts;

    @JsonProperty("contentCachingKeepAwake")
    protected Boolean contentCachingKeepAwake;

    @JsonProperty("contentCachingPort")
    protected Integer contentCachingPort;

    protected MacOSDeviceFeaturesConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSDeviceFeaturesConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private List<AirPrintDestination> airPrintDestinations;
        private String airPrintDestinationsNextLink;
        private List<MacOSLaunchItem> autoLaunchItems;
        private String autoLaunchItemsNextLink;
        private Boolean adminShowHostInfo;
        private String loginWindowText;
        private Boolean authorizedUsersListHidden;
        private Boolean authorizedUsersListHideLocalUsers;
        private Boolean authorizedUsersListHideMobileAccounts;
        private Boolean authorizedUsersListIncludeNetworkUsers;
        private Boolean authorizedUsersListHideAdminUsers;
        private Boolean authorizedUsersListShowOtherManagedUsers;
        private Boolean shutDownDisabled;
        private Boolean restartDisabled;
        private Boolean sleepDisabled;
        private Boolean consoleAccessDisabled;
        private Boolean shutDownDisabledWhileLoggedIn;
        private Boolean restartDisabledWhileLoggedIn;
        private Boolean powerOffDisabledWhileLoggedIn;
        private Boolean logOutDisabledWhileLoggedIn;
        private Boolean screenLockDisableImmediate;
        private List<KeyValuePair> associatedDomains;
        private String associatedDomainsNextLink;
        private SingleSignOnExtension singleSignOnExtension;
        private MacOSSingleSignOnExtension macOSSingleSignOnExtension;
        private Boolean contentCachingEnabled;
        private MacOSContentCachingType contentCachingType;
        private Integer contentCachingMaxSizeBytes;
        private String contentCachingDataPath;
        private Boolean contentCachingDisableConnectionSharing;
        private Boolean contentCachingForceConnectionSharing;
        private MacOSContentCachingClientPolicy contentCachingClientPolicy;
        private List<IpRange> contentCachingClientListenRanges;
        private String contentCachingClientListenRangesNextLink;
        private MacOSContentCachingPeerPolicy contentCachingPeerPolicy;
        private List<IpRange> contentCachingPeerListenRanges;
        private String contentCachingPeerListenRangesNextLink;
        private List<IpRange> contentCachingPeerFilterRanges;
        private String contentCachingPeerFilterRangesNextLink;
        private MacOSContentCachingParentSelectionPolicy contentCachingParentSelectionPolicy;
        private List<String> contentCachingParents;
        private String contentCachingParentsNextLink;
        private Boolean contentCachingLogClientIdentities;
        private List<IpRange> contentCachingPublicRanges;
        private String contentCachingPublicRangesNextLink;
        private Boolean contentCachingBlockDeletion;
        private Boolean contentCachingShowAlerts;
        private Boolean contentCachingKeepAwake;
        private Integer contentCachingPort;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder airPrintDestinations(List<AirPrintDestination> airPrintDestinations) {
            this.airPrintDestinations = airPrintDestinations;
            this.changedFields = changedFields.add("airPrintDestinations");
            return this;
        }

        public Builder airPrintDestinations(AirPrintDestination... airPrintDestinations) {
            return airPrintDestinations(Arrays.asList(airPrintDestinations));
        }

        public Builder airPrintDestinationsNextLink(String airPrintDestinationsNextLink) {
            this.airPrintDestinationsNextLink = airPrintDestinationsNextLink;
            this.changedFields = changedFields.add("airPrintDestinations");
            return this;
        }

        /**
         * <i>“List of applications, files, folders, and other items to launch when the user
         * logs in. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param autoLaunchItems
         *            value of {@code autoLaunchItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoLaunchItems(List<MacOSLaunchItem> autoLaunchItems) {
            this.autoLaunchItems = autoLaunchItems;
            this.changedFields = changedFields.add("autoLaunchItems");
            return this;
        }

        /**
         * <i>“List of applications, files, folders, and other items to launch when the user
         * logs in. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param autoLaunchItems
         *            value of {@code autoLaunchItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoLaunchItems(MacOSLaunchItem... autoLaunchItems) {
            return autoLaunchItems(Arrays.asList(autoLaunchItems));
        }

        /**
         * <i>“List of applications, files, folders, and other items to launch when the user
         * logs in. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param autoLaunchItemsNextLink
         *            value of {@code autoLaunchItems@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoLaunchItemsNextLink(String autoLaunchItemsNextLink) {
            this.autoLaunchItemsNextLink = autoLaunchItemsNextLink;
            this.changedFields = changedFields.add("autoLaunchItems");
            return this;
        }

        /**
         * <i>“Whether to show admin host information on the login window.”</i>
         * 
         * @param adminShowHostInfo
         *            value of {@code adminShowHostInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder adminShowHostInfo(Boolean adminShowHostInfo) {
            this.adminShowHostInfo = adminShowHostInfo;
            this.changedFields = changedFields.add("adminShowHostInfo");
            return this;
        }

        /**
         * <i>“Custom text to be displayed on the login window.”</i>
         * 
         * @param loginWindowText
         *            value of {@code loginWindowText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder loginWindowText(String loginWindowText) {
            this.loginWindowText = loginWindowText;
            this.changedFields = changedFields.add("loginWindowText");
            return this;
        }

        /**
         * <i>“Whether to show the name and password dialog or a list of users on the login
         * window.”</i>
         * 
         * @param authorizedUsersListHidden
         *            value of {@code authorizedUsersListHidden} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedUsersListHidden(Boolean authorizedUsersListHidden) {
            this.authorizedUsersListHidden = authorizedUsersListHidden;
            this.changedFields = changedFields.add("authorizedUsersListHidden");
            return this;
        }

        /**
         * <i>“Whether to show only network and system users in the authorized users list on
         * the login window.”</i>
         * 
         * @param authorizedUsersListHideLocalUsers
         *            value of {@code authorizedUsersListHideLocalUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedUsersListHideLocalUsers(Boolean authorizedUsersListHideLocalUsers) {
            this.authorizedUsersListHideLocalUsers = authorizedUsersListHideLocalUsers;
            this.changedFields = changedFields.add("authorizedUsersListHideLocalUsers");
            return this;
        }

        /**
         * <i>“Whether to hide mobile users in the authorized users list on the login window.”</i>
         * 
         * @param authorizedUsersListHideMobileAccounts
         *            value of {@code authorizedUsersListHideMobileAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedUsersListHideMobileAccounts(Boolean authorizedUsersListHideMobileAccounts) {
            this.authorizedUsersListHideMobileAccounts = authorizedUsersListHideMobileAccounts;
            this.changedFields = changedFields.add("authorizedUsersListHideMobileAccounts");
            return this;
        }

        /**
         * <i>“Whether to show network users in the authorized users list on the login window.”</i>
         * 
         * @param authorizedUsersListIncludeNetworkUsers
         *            value of {@code authorizedUsersListIncludeNetworkUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedUsersListIncludeNetworkUsers(Boolean authorizedUsersListIncludeNetworkUsers) {
            this.authorizedUsersListIncludeNetworkUsers = authorizedUsersListIncludeNetworkUsers;
            this.changedFields = changedFields.add("authorizedUsersListIncludeNetworkUsers");
            return this;
        }

        /**
         * <i>“Whether to hide admin users in the authorized users list on the login window.”</i>
         * 
         * @param authorizedUsersListHideAdminUsers
         *            value of {@code authorizedUsersListHideAdminUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedUsersListHideAdminUsers(Boolean authorizedUsersListHideAdminUsers) {
            this.authorizedUsersListHideAdminUsers = authorizedUsersListHideAdminUsers;
            this.changedFields = changedFields.add("authorizedUsersListHideAdminUsers");
            return this;
        }

        /**
         * <i>“Whether to show other users in the authorized users list on the login window.”</i>
         * 
         * @param authorizedUsersListShowOtherManagedUsers
         *            value of {@code authorizedUsersListShowOtherManagedUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authorizedUsersListShowOtherManagedUsers(Boolean authorizedUsersListShowOtherManagedUsers) {
            this.authorizedUsersListShowOtherManagedUsers = authorizedUsersListShowOtherManagedUsers;
            this.changedFields = changedFields.add("authorizedUsersListShowOtherManagedUsers");
            return this;
        }

        /**
         * <i>“Whether to hide the Shut Down button item on the login window.”</i>
         * 
         * @param shutDownDisabled
         *            value of {@code shutDownDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shutDownDisabled(Boolean shutDownDisabled) {
            this.shutDownDisabled = shutDownDisabled;
            this.changedFields = changedFields.add("shutDownDisabled");
            return this;
        }

        /**
         * <i>“Whether to hide the Restart button item on the login window.”</i>
         * 
         * @param restartDisabled
         *            value of {@code restartDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartDisabled(Boolean restartDisabled) {
            this.restartDisabled = restartDisabled;
            this.changedFields = changedFields.add("restartDisabled");
            return this;
        }

        /**
         * <i>“Whether to hide the Sleep menu item on the login window.”</i>
         * 
         * @param sleepDisabled
         *            value of {@code sleepDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sleepDisabled(Boolean sleepDisabled) {
            this.sleepDisabled = sleepDisabled;
            this.changedFields = changedFields.add("sleepDisabled");
            return this;
        }

        /**
         * <i>“Whether the Other user will disregard use of the `&amp;gt;console&amp;gt; special user name.”</i>
         * 
         * @param consoleAccessDisabled
         *            value of {@code consoleAccessDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder consoleAccessDisabled(Boolean consoleAccessDisabled) {
            this.consoleAccessDisabled = consoleAccessDisabled;
            this.changedFields = changedFields.add("consoleAccessDisabled");
            return this;
        }

        /**
         * <i>“Whether the Shut Down menu item on the login window will be disabled while the
         * user is logged in.”</i>
         * 
         * @param shutDownDisabledWhileLoggedIn
         *            value of {@code shutDownDisabledWhileLoggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shutDownDisabledWhileLoggedIn(Boolean shutDownDisabledWhileLoggedIn) {
            this.shutDownDisabledWhileLoggedIn = shutDownDisabledWhileLoggedIn;
            this.changedFields = changedFields.add("shutDownDisabledWhileLoggedIn");
            return this;
        }

        /**
         * <i>“Whether the Restart menu item on the login window will be disabled while the
         * user is logged in.”</i>
         * 
         * @param restartDisabledWhileLoggedIn
         *            value of {@code restartDisabledWhileLoggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartDisabledWhileLoggedIn(Boolean restartDisabledWhileLoggedIn) {
            this.restartDisabledWhileLoggedIn = restartDisabledWhileLoggedIn;
            this.changedFields = changedFields.add("restartDisabledWhileLoggedIn");
            return this;
        }

        /**
         * <i>“Whether the Power Off menu item on the login window will be disabled while the
         * user is logged in.”</i>
         * 
         * @param powerOffDisabledWhileLoggedIn
         *            value of {@code powerOffDisabledWhileLoggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerOffDisabledWhileLoggedIn(Boolean powerOffDisabledWhileLoggedIn) {
            this.powerOffDisabledWhileLoggedIn = powerOffDisabledWhileLoggedIn;
            this.changedFields = changedFields.add("powerOffDisabledWhileLoggedIn");
            return this;
        }

        /**
         * <i>“Whether the Log Out menu item on the login window will be disabled while the
         * user is logged in.”</i>
         * 
         * @param logOutDisabledWhileLoggedIn
         *            value of {@code logOutDisabledWhileLoggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder logOutDisabledWhileLoggedIn(Boolean logOutDisabledWhileLoggedIn) {
            this.logOutDisabledWhileLoggedIn = logOutDisabledWhileLoggedIn;
            this.changedFields = changedFields.add("logOutDisabledWhileLoggedIn");
            return this;
        }

        /**
         * <i>“Whether to disable the immediate screen lock functions.”</i>
         * 
         * @param screenLockDisableImmediate
         *            value of {@code screenLockDisableImmediate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenLockDisableImmediate(Boolean screenLockDisableImmediate) {
            this.screenLockDisableImmediate = screenLockDisableImmediate;
            this.changedFields = changedFields.add("screenLockDisableImmediate");
            return this;
        }

        /**
         * <i>“Gets or sets a list that maps apps to their associated domains. The key should
         * match the app's ID, and the value should be a string in the form of "service:
         * domain" where domain is a fully qualified hostname (e.g. webcredentials:example.
         * com). This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param associatedDomains
         *            value of {@code associatedDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder associatedDomains(List<KeyValuePair> associatedDomains) {
            this.associatedDomains = associatedDomains;
            this.changedFields = changedFields.add("associatedDomains");
            return this;
        }

        /**
         * <i>“Gets or sets a list that maps apps to their associated domains. The key should
         * match the app's ID, and the value should be a string in the form of "service:
         * domain" where domain is a fully qualified hostname (e.g. webcredentials:example.
         * com). This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param associatedDomains
         *            value of {@code associatedDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder associatedDomains(KeyValuePair... associatedDomains) {
            return associatedDomains(Arrays.asList(associatedDomains));
        }

        /**
         * <i>“Gets or sets a list that maps apps to their associated domains. The key should
         * match the app's ID, and the value should be a string in the form of "service:
         * domain" where domain is a fully qualified hostname (e.g. webcredentials:example.
         * com). This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param associatedDomainsNextLink
         *            value of {@code associatedDomains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder associatedDomainsNextLink(String associatedDomainsNextLink) {
            this.associatedDomainsNextLink = associatedDomainsNextLink;
            this.changedFields = changedFields.add("associatedDomains");
            return this;
        }

        /**
         * <i>“Gets or sets a single sign-on extension profile. Deprecated: use
         * MacOSSingleSignOnExtension instead.”</i>
         * 
         * @param singleSignOnExtension
         *            value of {@code singleSignOnExtension} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder singleSignOnExtension(SingleSignOnExtension singleSignOnExtension) {
            this.singleSignOnExtension = singleSignOnExtension;
            this.changedFields = changedFields.add("singleSignOnExtension");
            return this;
        }

        /**
         * <i>“Gets or sets a single sign-on extension profile.”</i>
         * 
         * @param macOSSingleSignOnExtension
         *            value of {@code macOSSingleSignOnExtension} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSSingleSignOnExtension(MacOSSingleSignOnExtension macOSSingleSignOnExtension) {
            this.macOSSingleSignOnExtension = macOSSingleSignOnExtension;
            this.changedFields = changedFields.add("macOSSingleSignOnExtension");
            return this;
        }

        /**
         * <i>“Enables content caching and prevents it from being disabled by the user.”</i>
         * 
         * @param contentCachingEnabled
         *            value of {@code contentCachingEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingEnabled(Boolean contentCachingEnabled) {
            this.contentCachingEnabled = contentCachingEnabled;
            this.changedFields = changedFields.add("contentCachingEnabled");
            return this;
        }

        /**
         * <i>“Determines what type of content is allowed to be cached by Apple's content
         * caching service.”</i>
         * 
         * @param contentCachingType
         *            value of {@code contentCachingType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingType(MacOSContentCachingType contentCachingType) {
            this.contentCachingType = contentCachingType;
            this.changedFields = changedFields.add("contentCachingType");
            return this;
        }

        /**
         * <i>“The maximum number of bytes of disk space that will be used for the content
         * cache. A value of 0 (default) indicates unlimited disk space.”</i>
         * 
         * @param contentCachingMaxSizeBytes
         *            value of {@code contentCachingMaxSizeBytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingMaxSizeBytes(Integer contentCachingMaxSizeBytes) {
            this.contentCachingMaxSizeBytes = contentCachingMaxSizeBytes;
            this.changedFields = changedFields.add("contentCachingMaxSizeBytes");
            return this;
        }

        /**
         * <i>“The path to the directory used to store cached content. The value must be (or
         * end with) /Library/Application Support/Apple/AssetCache/Data”</i>
         * 
         * @param contentCachingDataPath
         *            value of {@code contentCachingDataPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingDataPath(String contentCachingDataPath) {
            this.contentCachingDataPath = contentCachingDataPath;
            this.changedFields = changedFields.add("contentCachingDataPath");
            return this;
        }

        /**
         * <i>“Disables internet connection sharing.”</i>
         * 
         * @param contentCachingDisableConnectionSharing
         *            value of {@code contentCachingDisableConnectionSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingDisableConnectionSharing(Boolean contentCachingDisableConnectionSharing) {
            this.contentCachingDisableConnectionSharing = contentCachingDisableConnectionSharing;
            this.changedFields = changedFields.add("contentCachingDisableConnectionSharing");
            return this;
        }

        /**
         * <i>“Forces internet connection sharing. contentCachingDisableConnectionSharing
         * overrides this setting.”</i>
         * 
         * @param contentCachingForceConnectionSharing
         *            value of {@code contentCachingForceConnectionSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingForceConnectionSharing(Boolean contentCachingForceConnectionSharing) {
            this.contentCachingForceConnectionSharing = contentCachingForceConnectionSharing;
            this.changedFields = changedFields.add("contentCachingForceConnectionSharing");
            return this;
        }

        /**
         * <i>“Determines the method in which content caching servers will listen for clients.”</i>
         * 
         * @param contentCachingClientPolicy
         *            value of {@code contentCachingClientPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingClientPolicy(MacOSContentCachingClientPolicy contentCachingClientPolicy) {
            this.contentCachingClientPolicy = contentCachingClientPolicy;
            this.changedFields = changedFields.add("contentCachingClientPolicy");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to listen for clients. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingClientListenRanges
         *            value of {@code contentCachingClientListenRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingClientListenRanges(List<IpRange> contentCachingClientListenRanges) {
            this.contentCachingClientListenRanges = contentCachingClientListenRanges;
            this.changedFields = changedFields.add("contentCachingClientListenRanges");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to listen for clients. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingClientListenRanges
         *            value of {@code contentCachingClientListenRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingClientListenRanges(IpRange... contentCachingClientListenRanges) {
            return contentCachingClientListenRanges(Arrays.asList(contentCachingClientListenRanges));
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to listen for clients. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingClientListenRangesNextLink
         *            value of {@code contentCachingClientListenRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingClientListenRangesNextLink(String contentCachingClientListenRangesNextLink) {
            this.contentCachingClientListenRangesNextLink = contentCachingClientListenRangesNextLink;
            this.changedFields = changedFields.add("contentCachingClientListenRanges");
            return this;
        }

        /**
         * <i>“Determines the method in which content caches peer with other caches.”</i>
         * 
         * @param contentCachingPeerPolicy
         *            value of {@code contentCachingPeerPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerPolicy(MacOSContentCachingPeerPolicy contentCachingPeerPolicy) {
            this.contentCachingPeerPolicy = contentCachingPeerPolicy;
            this.changedFields = changedFields.add("contentCachingPeerPolicy");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to listen for peer caches.
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingPeerListenRanges
         *            value of {@code contentCachingPeerListenRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerListenRanges(List<IpRange> contentCachingPeerListenRanges) {
            this.contentCachingPeerListenRanges = contentCachingPeerListenRanges;
            this.changedFields = changedFields.add("contentCachingPeerListenRanges");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to listen for peer caches.
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingPeerListenRanges
         *            value of {@code contentCachingPeerListenRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerListenRanges(IpRange... contentCachingPeerListenRanges) {
            return contentCachingPeerListenRanges(Arrays.asList(contentCachingPeerListenRanges));
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to listen for peer caches.
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingPeerListenRangesNextLink
         *            value of {@code contentCachingPeerListenRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerListenRangesNextLink(String contentCachingPeerListenRangesNextLink) {
            this.contentCachingPeerListenRangesNextLink = contentCachingPeerListenRangesNextLink;
            this.changedFields = changedFields.add("contentCachingPeerListenRanges");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to query for content from
         * peers caches. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingPeerFilterRanges
         *            value of {@code contentCachingPeerFilterRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerFilterRanges(List<IpRange> contentCachingPeerFilterRanges) {
            this.contentCachingPeerFilterRanges = contentCachingPeerFilterRanges;
            this.changedFields = changedFields.add("contentCachingPeerFilterRanges");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to query for content from
         * peers caches. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingPeerFilterRanges
         *            value of {@code contentCachingPeerFilterRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerFilterRanges(IpRange... contentCachingPeerFilterRanges) {
            return contentCachingPeerFilterRanges(Arrays.asList(contentCachingPeerFilterRanges));
        }

        /**
         * <i>“A list of custom IP ranges content caches will use to query for content from
         * peers caches. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param contentCachingPeerFilterRangesNextLink
         *            value of {@code contentCachingPeerFilterRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPeerFilterRangesNextLink(String contentCachingPeerFilterRangesNextLink) {
            this.contentCachingPeerFilterRangesNextLink = contentCachingPeerFilterRangesNextLink;
            this.changedFields = changedFields.add("contentCachingPeerFilterRanges");
            return this;
        }

        /**
         * <i>“Determines the method in which content caching servers will select parents if
         * multiple are present.”</i>
         * 
         * @param contentCachingParentSelectionPolicy
         *            value of {@code contentCachingParentSelectionPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingParentSelectionPolicy(MacOSContentCachingParentSelectionPolicy contentCachingParentSelectionPolicy) {
            this.contentCachingParentSelectionPolicy = contentCachingParentSelectionPolicy;
            this.changedFields = changedFields.add("contentCachingParentSelectionPolicy");
            return this;
        }

        /**
         * <i>“A list of IP addresses representing parent content caches.”</i>
         * 
         * @param contentCachingParents
         *            value of {@code contentCachingParents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingParents(List<String> contentCachingParents) {
            this.contentCachingParents = contentCachingParents;
            this.changedFields = changedFields.add("contentCachingParents");
            return this;
        }

        /**
         * <i>“A list of IP addresses representing parent content caches.”</i>
         * 
         * @param contentCachingParents
         *            value of {@code contentCachingParents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingParents(String... contentCachingParents) {
            return contentCachingParents(Arrays.asList(contentCachingParents));
        }

        /**
         * <i>“A list of IP addresses representing parent content caches.”</i>
         * 
         * @param contentCachingParentsNextLink
         *            value of {@code contentCachingParents@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingParentsNextLink(String contentCachingParentsNextLink) {
            this.contentCachingParentsNextLink = contentCachingParentsNextLink;
            this.changedFields = changedFields.add("contentCachingParents");
            return this;
        }

        /**
         * <i>“Enables logging of IP addresses and ports of clients that request cached content
         * .”</i>
         * 
         * @param contentCachingLogClientIdentities
         *            value of {@code contentCachingLogClientIdentities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingLogClientIdentities(Boolean contentCachingLogClientIdentities) {
            this.contentCachingLogClientIdentities = contentCachingLogClientIdentities;
            this.changedFields = changedFields.add("contentCachingLogClientIdentities");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges that Apple's content caching service should use to
         * match clients to content caches. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param contentCachingPublicRanges
         *            value of {@code contentCachingPublicRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPublicRanges(List<IpRange> contentCachingPublicRanges) {
            this.contentCachingPublicRanges = contentCachingPublicRanges;
            this.changedFields = changedFields.add("contentCachingPublicRanges");
            return this;
        }

        /**
         * <i>“A list of custom IP ranges that Apple's content caching service should use to
         * match clients to content caches. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param contentCachingPublicRanges
         *            value of {@code contentCachingPublicRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPublicRanges(IpRange... contentCachingPublicRanges) {
            return contentCachingPublicRanges(Arrays.asList(contentCachingPublicRanges));
        }

        /**
         * <i>“A list of custom IP ranges that Apple's content caching service should use to
         * match clients to content caches. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param contentCachingPublicRangesNextLink
         *            value of {@code contentCachingPublicRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPublicRangesNextLink(String contentCachingPublicRangesNextLink) {
            this.contentCachingPublicRangesNextLink = contentCachingPublicRangesNextLink;
            this.changedFields = changedFields.add("contentCachingPublicRanges");
            return this;
        }

        /**
         * <i>“Prevents content caches from purging content to free up disk space for other
         * apps.”</i>
         * 
         * @param contentCachingBlockDeletion
         *            value of {@code contentCachingBlockDeletion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingBlockDeletion(Boolean contentCachingBlockDeletion) {
            this.contentCachingBlockDeletion = contentCachingBlockDeletion;
            this.changedFields = changedFields.add("contentCachingBlockDeletion");
            return this;
        }

        /**
         * <i>“Display content caching alerts as system notifications.”</i>
         * 
         * @param contentCachingShowAlerts
         *            value of {@code contentCachingShowAlerts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingShowAlerts(Boolean contentCachingShowAlerts) {
            this.contentCachingShowAlerts = contentCachingShowAlerts;
            this.changedFields = changedFields.add("contentCachingShowAlerts");
            return this;
        }

        /**
         * <i>“Prevent the device from sleeping if content caching is enabled.”</i>
         * 
         * @param contentCachingKeepAwake
         *            value of {@code contentCachingKeepAwake} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingKeepAwake(Boolean contentCachingKeepAwake) {
            this.contentCachingKeepAwake = contentCachingKeepAwake;
            this.changedFields = changedFields.add("contentCachingKeepAwake");
            return this;
        }

        /**
         * <i>“Sets the port used for content caching. If the value is 0, a random available
         * port will be selected. Valid values 0 to 65535”</i>
         * 
         * @param contentCachingPort
         *            value of {@code contentCachingPort} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentCachingPort(Integer contentCachingPort) {
            this.contentCachingPort = contentCachingPort;
            this.changedFields = changedFields.add("contentCachingPort");
            return this;
        }

        public MacOSDeviceFeaturesConfiguration build() {
            MacOSDeviceFeaturesConfiguration _x = new MacOSDeviceFeaturesConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSDeviceFeaturesConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.airPrintDestinations = airPrintDestinations;
            _x.airPrintDestinationsNextLink = airPrintDestinationsNextLink;
            _x.autoLaunchItems = autoLaunchItems;
            _x.autoLaunchItemsNextLink = autoLaunchItemsNextLink;
            _x.adminShowHostInfo = adminShowHostInfo;
            _x.loginWindowText = loginWindowText;
            _x.authorizedUsersListHidden = authorizedUsersListHidden;
            _x.authorizedUsersListHideLocalUsers = authorizedUsersListHideLocalUsers;
            _x.authorizedUsersListHideMobileAccounts = authorizedUsersListHideMobileAccounts;
            _x.authorizedUsersListIncludeNetworkUsers = authorizedUsersListIncludeNetworkUsers;
            _x.authorizedUsersListHideAdminUsers = authorizedUsersListHideAdminUsers;
            _x.authorizedUsersListShowOtherManagedUsers = authorizedUsersListShowOtherManagedUsers;
            _x.shutDownDisabled = shutDownDisabled;
            _x.restartDisabled = restartDisabled;
            _x.sleepDisabled = sleepDisabled;
            _x.consoleAccessDisabled = consoleAccessDisabled;
            _x.shutDownDisabledWhileLoggedIn = shutDownDisabledWhileLoggedIn;
            _x.restartDisabledWhileLoggedIn = restartDisabledWhileLoggedIn;
            _x.powerOffDisabledWhileLoggedIn = powerOffDisabledWhileLoggedIn;
            _x.logOutDisabledWhileLoggedIn = logOutDisabledWhileLoggedIn;
            _x.screenLockDisableImmediate = screenLockDisableImmediate;
            _x.associatedDomains = associatedDomains;
            _x.associatedDomainsNextLink = associatedDomainsNextLink;
            _x.singleSignOnExtension = singleSignOnExtension;
            _x.macOSSingleSignOnExtension = macOSSingleSignOnExtension;
            _x.contentCachingEnabled = contentCachingEnabled;
            _x.contentCachingType = contentCachingType;
            _x.contentCachingMaxSizeBytes = contentCachingMaxSizeBytes;
            _x.contentCachingDataPath = contentCachingDataPath;
            _x.contentCachingDisableConnectionSharing = contentCachingDisableConnectionSharing;
            _x.contentCachingForceConnectionSharing = contentCachingForceConnectionSharing;
            _x.contentCachingClientPolicy = contentCachingClientPolicy;
            _x.contentCachingClientListenRanges = contentCachingClientListenRanges;
            _x.contentCachingClientListenRangesNextLink = contentCachingClientListenRangesNextLink;
            _x.contentCachingPeerPolicy = contentCachingPeerPolicy;
            _x.contentCachingPeerListenRanges = contentCachingPeerListenRanges;
            _x.contentCachingPeerListenRangesNextLink = contentCachingPeerListenRangesNextLink;
            _x.contentCachingPeerFilterRanges = contentCachingPeerFilterRanges;
            _x.contentCachingPeerFilterRangesNextLink = contentCachingPeerFilterRangesNextLink;
            _x.contentCachingParentSelectionPolicy = contentCachingParentSelectionPolicy;
            _x.contentCachingParents = contentCachingParents;
            _x.contentCachingParentsNextLink = contentCachingParentsNextLink;
            _x.contentCachingLogClientIdentities = contentCachingLogClientIdentities;
            _x.contentCachingPublicRanges = contentCachingPublicRanges;
            _x.contentCachingPublicRangesNextLink = contentCachingPublicRangesNextLink;
            _x.contentCachingBlockDeletion = contentCachingBlockDeletion;
            _x.contentCachingShowAlerts = contentCachingShowAlerts;
            _x.contentCachingKeepAwake = contentCachingKeepAwake;
            _x.contentCachingPort = contentCachingPort;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“List of applications, files, folders, and other items to launch when the user
     * logs in. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property autoLaunchItems
     */
    @Property(name="autoLaunchItems")
    @JsonIgnore
    public CollectionPage<MacOSLaunchItem> getAutoLaunchItems() {
        return new CollectionPage<MacOSLaunchItem>(contextPath, MacOSLaunchItem.class, autoLaunchItems, Optional.ofNullable(autoLaunchItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of applications, files, folders, and other items to launch when the user
     * logs in. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property autoLaunchItems
     */
    @Property(name="autoLaunchItems")
    @JsonIgnore
    public CollectionPage<MacOSLaunchItem> getAutoLaunchItems(HttpRequestOptions options) {
        return new CollectionPage<MacOSLaunchItem>(contextPath, MacOSLaunchItem.class, autoLaunchItems, Optional.ofNullable(autoLaunchItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Whether to show admin host information on the login window.”</i>
     * 
     * @return property adminShowHostInfo
     */
    @Property(name="adminShowHostInfo")
    @JsonIgnore
    public Optional<Boolean> getAdminShowHostInfo() {
        return Optional.ofNullable(adminShowHostInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code adminShowHostInfo
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether to show admin host information on the login window.”</i>
     * 
     * @param adminShowHostInfo
     *            new value of {@code adminShowHostInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code adminShowHostInfo} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAdminShowHostInfo(Boolean adminShowHostInfo) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("adminShowHostInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.adminShowHostInfo = adminShowHostInfo;
        return _x;
    }

    /**
     * <i>“Custom text to be displayed on the login window.”</i>
     * 
     * @return property loginWindowText
     */
    @Property(name="loginWindowText")
    @JsonIgnore
    public Optional<String> getLoginWindowText() {
        return Optional.ofNullable(loginWindowText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code loginWindowText}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Custom text to be displayed on the login window.”</i>
     * 
     * @param loginWindowText
     *            new value of {@code loginWindowText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code loginWindowText} field changed
     */
    public MacOSDeviceFeaturesConfiguration withLoginWindowText(String loginWindowText) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("loginWindowText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.loginWindowText = loginWindowText;
        return _x;
    }

    /**
     * <i>“Whether to show the name and password dialog or a list of users on the login
     * window.”</i>
     * 
     * @return property authorizedUsersListHidden
     */
    @Property(name="authorizedUsersListHidden")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedUsersListHidden() {
        return Optional.ofNullable(authorizedUsersListHidden);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedUsersListHidden} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether to show the name and password dialog or a list of users on the login
     * window.”</i>
     * 
     * @param authorizedUsersListHidden
     *            new value of {@code authorizedUsersListHidden} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedUsersListHidden} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAuthorizedUsersListHidden(Boolean authorizedUsersListHidden) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authorizedUsersListHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.authorizedUsersListHidden = authorizedUsersListHidden;
        return _x;
    }

    /**
     * <i>“Whether to show only network and system users in the authorized users list on
     * the login window.”</i>
     * 
     * @return property authorizedUsersListHideLocalUsers
     */
    @Property(name="authorizedUsersListHideLocalUsers")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedUsersListHideLocalUsers() {
        return Optional.ofNullable(authorizedUsersListHideLocalUsers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedUsersListHideLocalUsers} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether to show only network and system users in the authorized users list on
     * the login window.”</i>
     * 
     * @param authorizedUsersListHideLocalUsers
     *            new value of {@code authorizedUsersListHideLocalUsers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedUsersListHideLocalUsers} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAuthorizedUsersListHideLocalUsers(Boolean authorizedUsersListHideLocalUsers) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authorizedUsersListHideLocalUsers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.authorizedUsersListHideLocalUsers = authorizedUsersListHideLocalUsers;
        return _x;
    }

    /**
     * <i>“Whether to hide mobile users in the authorized users list on the login window.”</i>
     * 
     * @return property authorizedUsersListHideMobileAccounts
     */
    @Property(name="authorizedUsersListHideMobileAccounts")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedUsersListHideMobileAccounts() {
        return Optional.ofNullable(authorizedUsersListHideMobileAccounts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedUsersListHideMobileAccounts} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether to hide mobile users in the authorized users list on the login window.”</i>
     * 
     * @param authorizedUsersListHideMobileAccounts
     *            new value of {@code authorizedUsersListHideMobileAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedUsersListHideMobileAccounts} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAuthorizedUsersListHideMobileAccounts(Boolean authorizedUsersListHideMobileAccounts) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authorizedUsersListHideMobileAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.authorizedUsersListHideMobileAccounts = authorizedUsersListHideMobileAccounts;
        return _x;
    }

    /**
     * <i>“Whether to show network users in the authorized users list on the login window.”</i>
     * 
     * @return property authorizedUsersListIncludeNetworkUsers
     */
    @Property(name="authorizedUsersListIncludeNetworkUsers")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedUsersListIncludeNetworkUsers() {
        return Optional.ofNullable(authorizedUsersListIncludeNetworkUsers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedUsersListIncludeNetworkUsers} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether to show network users in the authorized users list on the login window.”</i>
     * 
     * @param authorizedUsersListIncludeNetworkUsers
     *            new value of {@code authorizedUsersListIncludeNetworkUsers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedUsersListIncludeNetworkUsers} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAuthorizedUsersListIncludeNetworkUsers(Boolean authorizedUsersListIncludeNetworkUsers) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authorizedUsersListIncludeNetworkUsers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.authorizedUsersListIncludeNetworkUsers = authorizedUsersListIncludeNetworkUsers;
        return _x;
    }

    /**
     * <i>“Whether to hide admin users in the authorized users list on the login window.”</i>
     * 
     * @return property authorizedUsersListHideAdminUsers
     */
    @Property(name="authorizedUsersListHideAdminUsers")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedUsersListHideAdminUsers() {
        return Optional.ofNullable(authorizedUsersListHideAdminUsers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedUsersListHideAdminUsers} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether to hide admin users in the authorized users list on the login window.”</i>
     * 
     * @param authorizedUsersListHideAdminUsers
     *            new value of {@code authorizedUsersListHideAdminUsers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedUsersListHideAdminUsers} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAuthorizedUsersListHideAdminUsers(Boolean authorizedUsersListHideAdminUsers) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authorizedUsersListHideAdminUsers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.authorizedUsersListHideAdminUsers = authorizedUsersListHideAdminUsers;
        return _x;
    }

    /**
     * <i>“Whether to show other users in the authorized users list on the login window.”</i>
     * 
     * @return property authorizedUsersListShowOtherManagedUsers
     */
    @Property(name="authorizedUsersListShowOtherManagedUsers")
    @JsonIgnore
    public Optional<Boolean> getAuthorizedUsersListShowOtherManagedUsers() {
        return Optional.ofNullable(authorizedUsersListShowOtherManagedUsers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authorizedUsersListShowOtherManagedUsers} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether to show other users in the authorized users list on the login window.”</i>
     * 
     * @param authorizedUsersListShowOtherManagedUsers
     *            new value of {@code authorizedUsersListShowOtherManagedUsers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authorizedUsersListShowOtherManagedUsers} field changed
     */
    public MacOSDeviceFeaturesConfiguration withAuthorizedUsersListShowOtherManagedUsers(Boolean authorizedUsersListShowOtherManagedUsers) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authorizedUsersListShowOtherManagedUsers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.authorizedUsersListShowOtherManagedUsers = authorizedUsersListShowOtherManagedUsers;
        return _x;
    }

    /**
     * <i>“Whether to hide the Shut Down button item on the login window.”</i>
     * 
     * @return property shutDownDisabled
     */
    @Property(name="shutDownDisabled")
    @JsonIgnore
    public Optional<Boolean> getShutDownDisabled() {
        return Optional.ofNullable(shutDownDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code shutDownDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether to hide the Shut Down button item on the login window.”</i>
     * 
     * @param shutDownDisabled
     *            new value of {@code shutDownDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shutDownDisabled} field changed
     */
    public MacOSDeviceFeaturesConfiguration withShutDownDisabled(Boolean shutDownDisabled) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("shutDownDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.shutDownDisabled = shutDownDisabled;
        return _x;
    }

    /**
     * <i>“Whether to hide the Restart button item on the login window.”</i>
     * 
     * @return property restartDisabled
     */
    @Property(name="restartDisabled")
    @JsonIgnore
    public Optional<Boolean> getRestartDisabled() {
        return Optional.ofNullable(restartDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restartDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether to hide the Restart button item on the login window.”</i>
     * 
     * @param restartDisabled
     *            new value of {@code restartDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartDisabled} field changed
     */
    public MacOSDeviceFeaturesConfiguration withRestartDisabled(Boolean restartDisabled) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("restartDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.restartDisabled = restartDisabled;
        return _x;
    }

    /**
     * <i>“Whether to hide the Sleep menu item on the login window.”</i>
     * 
     * @return property sleepDisabled
     */
    @Property(name="sleepDisabled")
    @JsonIgnore
    public Optional<Boolean> getSleepDisabled() {
        return Optional.ofNullable(sleepDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sleepDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether to hide the Sleep menu item on the login window.”</i>
     * 
     * @param sleepDisabled
     *            new value of {@code sleepDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sleepDisabled} field changed
     */
    public MacOSDeviceFeaturesConfiguration withSleepDisabled(Boolean sleepDisabled) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("sleepDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.sleepDisabled = sleepDisabled;
        return _x;
    }

    /**
     * <i>“Whether the Other user will disregard use of the `&amp;gt;console&amp;gt; special user name.”</i>
     * 
     * @return property consoleAccessDisabled
     */
    @Property(name="consoleAccessDisabled")
    @JsonIgnore
    public Optional<Boolean> getConsoleAccessDisabled() {
        return Optional.ofNullable(consoleAccessDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * consoleAccessDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether the Other user will disregard use of the `&amp;gt;console&amp;gt; special user name.”</i>
     * 
     * @param consoleAccessDisabled
     *            new value of {@code consoleAccessDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code consoleAccessDisabled} field changed
     */
    public MacOSDeviceFeaturesConfiguration withConsoleAccessDisabled(Boolean consoleAccessDisabled) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("consoleAccessDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.consoleAccessDisabled = consoleAccessDisabled;
        return _x;
    }

    /**
     * <i>“Whether the Shut Down menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @return property shutDownDisabledWhileLoggedIn
     */
    @Property(name="shutDownDisabledWhileLoggedIn")
    @JsonIgnore
    public Optional<Boolean> getShutDownDisabledWhileLoggedIn() {
        return Optional.ofNullable(shutDownDisabledWhileLoggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * shutDownDisabledWhileLoggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether the Shut Down menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @param shutDownDisabledWhileLoggedIn
     *            new value of {@code shutDownDisabledWhileLoggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shutDownDisabledWhileLoggedIn} field changed
     */
    public MacOSDeviceFeaturesConfiguration withShutDownDisabledWhileLoggedIn(Boolean shutDownDisabledWhileLoggedIn) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("shutDownDisabledWhileLoggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.shutDownDisabledWhileLoggedIn = shutDownDisabledWhileLoggedIn;
        return _x;
    }

    /**
     * <i>“Whether the Restart menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @return property restartDisabledWhileLoggedIn
     */
    @Property(name="restartDisabledWhileLoggedIn")
    @JsonIgnore
    public Optional<Boolean> getRestartDisabledWhileLoggedIn() {
        return Optional.ofNullable(restartDisabledWhileLoggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restartDisabledWhileLoggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether the Restart menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @param restartDisabledWhileLoggedIn
     *            new value of {@code restartDisabledWhileLoggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartDisabledWhileLoggedIn} field changed
     */
    public MacOSDeviceFeaturesConfiguration withRestartDisabledWhileLoggedIn(Boolean restartDisabledWhileLoggedIn) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("restartDisabledWhileLoggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.restartDisabledWhileLoggedIn = restartDisabledWhileLoggedIn;
        return _x;
    }

    /**
     * <i>“Whether the Power Off menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @return property powerOffDisabledWhileLoggedIn
     */
    @Property(name="powerOffDisabledWhileLoggedIn")
    @JsonIgnore
    public Optional<Boolean> getPowerOffDisabledWhileLoggedIn() {
        return Optional.ofNullable(powerOffDisabledWhileLoggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerOffDisabledWhileLoggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether the Power Off menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @param powerOffDisabledWhileLoggedIn
     *            new value of {@code powerOffDisabledWhileLoggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerOffDisabledWhileLoggedIn} field changed
     */
    public MacOSDeviceFeaturesConfiguration withPowerOffDisabledWhileLoggedIn(Boolean powerOffDisabledWhileLoggedIn) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerOffDisabledWhileLoggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.powerOffDisabledWhileLoggedIn = powerOffDisabledWhileLoggedIn;
        return _x;
    }

    /**
     * <i>“Whether the Log Out menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @return property logOutDisabledWhileLoggedIn
     */
    @Property(name="logOutDisabledWhileLoggedIn")
    @JsonIgnore
    public Optional<Boolean> getLogOutDisabledWhileLoggedIn() {
        return Optional.ofNullable(logOutDisabledWhileLoggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * logOutDisabledWhileLoggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether the Log Out menu item on the login window will be disabled while the
     * user is logged in.”</i>
     * 
     * @param logOutDisabledWhileLoggedIn
     *            new value of {@code logOutDisabledWhileLoggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code logOutDisabledWhileLoggedIn} field changed
     */
    public MacOSDeviceFeaturesConfiguration withLogOutDisabledWhileLoggedIn(Boolean logOutDisabledWhileLoggedIn) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("logOutDisabledWhileLoggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.logOutDisabledWhileLoggedIn = logOutDisabledWhileLoggedIn;
        return _x;
    }

    /**
     * <i>“Whether to disable the immediate screen lock functions.”</i>
     * 
     * @return property screenLockDisableImmediate
     */
    @Property(name="screenLockDisableImmediate")
    @JsonIgnore
    public Optional<Boolean> getScreenLockDisableImmediate() {
        return Optional.ofNullable(screenLockDisableImmediate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenLockDisableImmediate} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether to disable the immediate screen lock functions.”</i>
     * 
     * @param screenLockDisableImmediate
     *            new value of {@code screenLockDisableImmediate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenLockDisableImmediate} field changed
     */
    public MacOSDeviceFeaturesConfiguration withScreenLockDisableImmediate(Boolean screenLockDisableImmediate) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenLockDisableImmediate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.screenLockDisableImmediate = screenLockDisableImmediate;
        return _x;
    }

    /**
     * <i>“Gets or sets a list that maps apps to their associated domains. The key should
     * match the app's ID, and the value should be a string in the form of "service:
     * domain" where domain is a fully qualified hostname (e.g. webcredentials:example.
     * com). This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property associatedDomains
     */
    @Property(name="associatedDomains")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAssociatedDomains() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, associatedDomains, Optional.ofNullable(associatedDomainsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list that maps apps to their associated domains. The key should
     * match the app's ID, and the value should be a string in the form of "service:
     * domain" where domain is a fully qualified hostname (e.g. webcredentials:example.
     * com). This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property associatedDomains
     */
    @Property(name="associatedDomains")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAssociatedDomains(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, associatedDomains, Optional.ofNullable(associatedDomainsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a single sign-on extension profile. Deprecated: use
     * MacOSSingleSignOnExtension instead.”</i>
     * 
     * @return property singleSignOnExtension
     */
    @Property(name="singleSignOnExtension")
    @JsonIgnore
    public Optional<SingleSignOnExtension> getSingleSignOnExtension() {
        return Optional.ofNullable(singleSignOnExtension);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * singleSignOnExtension} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a single sign-on extension profile. Deprecated: use
     * MacOSSingleSignOnExtension instead.”</i>
     * 
     * @param singleSignOnExtension
     *            new value of {@code singleSignOnExtension} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code singleSignOnExtension} field changed
     */
    public MacOSDeviceFeaturesConfiguration withSingleSignOnExtension(SingleSignOnExtension singleSignOnExtension) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("singleSignOnExtension");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.singleSignOnExtension = singleSignOnExtension;
        return _x;
    }

    /**
     * <i>“Gets or sets a single sign-on extension profile.”</i>
     * 
     * @return property macOSSingleSignOnExtension
     */
    @Property(name="macOSSingleSignOnExtension")
    @JsonIgnore
    public Optional<MacOSSingleSignOnExtension> getMacOSSingleSignOnExtension() {
        return Optional.ofNullable(macOSSingleSignOnExtension);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * macOSSingleSignOnExtension} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a single sign-on extension profile.”</i>
     * 
     * @param macOSSingleSignOnExtension
     *            new value of {@code macOSSingleSignOnExtension} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOSSingleSignOnExtension} field changed
     */
    public MacOSDeviceFeaturesConfiguration withMacOSSingleSignOnExtension(MacOSSingleSignOnExtension macOSSingleSignOnExtension) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("macOSSingleSignOnExtension");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.macOSSingleSignOnExtension = macOSSingleSignOnExtension;
        return _x;
    }

    /**
     * <i>“Enables content caching and prevents it from being disabled by the user.”</i>
     * 
     * @return property contentCachingEnabled
     */
    @Property(name="contentCachingEnabled")
    @JsonIgnore
    public Optional<Boolean> getContentCachingEnabled() {
        return Optional.ofNullable(contentCachingEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enables content caching and prevents it from being disabled by the user.”</i>
     * 
     * @param contentCachingEnabled
     *            new value of {@code contentCachingEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingEnabled} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingEnabled(Boolean contentCachingEnabled) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingEnabled = contentCachingEnabled;
        return _x;
    }

    /**
     * <i>“Determines what type of content is allowed to be cached by Apple's content
     * caching service.”</i>
     * 
     * @return property contentCachingType
     */
    @Property(name="contentCachingType")
    @JsonIgnore
    public Optional<MacOSContentCachingType> getContentCachingType() {
        return Optional.ofNullable(contentCachingType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Determines what type of content is allowed to be cached by Apple's content
     * caching service.”</i>
     * 
     * @param contentCachingType
     *            new value of {@code contentCachingType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingType} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingType(MacOSContentCachingType contentCachingType) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingType = contentCachingType;
        return _x;
    }

    /**
     * <i>“The maximum number of bytes of disk space that will be used for the content
     * cache. A value of 0 (default) indicates unlimited disk space.”</i>
     * 
     * @return property contentCachingMaxSizeBytes
     */
    @Property(name="contentCachingMaxSizeBytes")
    @JsonIgnore
    public Optional<Integer> getContentCachingMaxSizeBytes() {
        return Optional.ofNullable(contentCachingMaxSizeBytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingMaxSizeBytes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The maximum number of bytes of disk space that will be used for the content
     * cache. A value of 0 (default) indicates unlimited disk space.”</i>
     * 
     * @param contentCachingMaxSizeBytes
     *            new value of {@code contentCachingMaxSizeBytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingMaxSizeBytes} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingMaxSizeBytes(Integer contentCachingMaxSizeBytes) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingMaxSizeBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingMaxSizeBytes = contentCachingMaxSizeBytes;
        return _x;
    }

    /**
     * <i>“The path to the directory used to store cached content. The value must be (or
     * end with) /Library/Application Support/Apple/AssetCache/Data”</i>
     * 
     * @return property contentCachingDataPath
     */
    @Property(name="contentCachingDataPath")
    @JsonIgnore
    public Optional<String> getContentCachingDataPath() {
        return Optional.ofNullable(contentCachingDataPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingDataPath} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The path to the directory used to store cached content. The value must be (or
     * end with) /Library/Application Support/Apple/AssetCache/Data”</i>
     * 
     * @param contentCachingDataPath
     *            new value of {@code contentCachingDataPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingDataPath} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingDataPath(String contentCachingDataPath) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingDataPath");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingDataPath = contentCachingDataPath;
        return _x;
    }

    /**
     * <i>“Disables internet connection sharing.”</i>
     * 
     * @return property contentCachingDisableConnectionSharing
     */
    @Property(name="contentCachingDisableConnectionSharing")
    @JsonIgnore
    public Optional<Boolean> getContentCachingDisableConnectionSharing() {
        return Optional.ofNullable(contentCachingDisableConnectionSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingDisableConnectionSharing} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Disables internet connection sharing.”</i>
     * 
     * @param contentCachingDisableConnectionSharing
     *            new value of {@code contentCachingDisableConnectionSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingDisableConnectionSharing} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingDisableConnectionSharing(Boolean contentCachingDisableConnectionSharing) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingDisableConnectionSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingDisableConnectionSharing = contentCachingDisableConnectionSharing;
        return _x;
    }

    /**
     * <i>“Forces internet connection sharing. contentCachingDisableConnectionSharing
     * overrides this setting.”</i>
     * 
     * @return property contentCachingForceConnectionSharing
     */
    @Property(name="contentCachingForceConnectionSharing")
    @JsonIgnore
    public Optional<Boolean> getContentCachingForceConnectionSharing() {
        return Optional.ofNullable(contentCachingForceConnectionSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingForceConnectionSharing} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Forces internet connection sharing. contentCachingDisableConnectionSharing
     * overrides this setting.”</i>
     * 
     * @param contentCachingForceConnectionSharing
     *            new value of {@code contentCachingForceConnectionSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingForceConnectionSharing} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingForceConnectionSharing(Boolean contentCachingForceConnectionSharing) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingForceConnectionSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingForceConnectionSharing = contentCachingForceConnectionSharing;
        return _x;
    }

    /**
     * <i>“Determines the method in which content caching servers will listen for clients.”</i>
     * 
     * @return property contentCachingClientPolicy
     */
    @Property(name="contentCachingClientPolicy")
    @JsonIgnore
    public Optional<MacOSContentCachingClientPolicy> getContentCachingClientPolicy() {
        return Optional.ofNullable(contentCachingClientPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingClientPolicy} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines the method in which content caching servers will listen for clients.”</i>
     * 
     * @param contentCachingClientPolicy
     *            new value of {@code contentCachingClientPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingClientPolicy} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingClientPolicy(MacOSContentCachingClientPolicy contentCachingClientPolicy) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingClientPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingClientPolicy = contentCachingClientPolicy;
        return _x;
    }

    /**
     * <i>“A list of custom IP ranges content caches will use to listen for clients. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property contentCachingClientListenRanges
     */
    @Property(name="contentCachingClientListenRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingClientListenRanges() {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingClientListenRanges, Optional.ofNullable(contentCachingClientListenRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of custom IP ranges content caches will use to listen for clients. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property contentCachingClientListenRanges
     */
    @Property(name="contentCachingClientListenRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingClientListenRanges(HttpRequestOptions options) {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingClientListenRanges, Optional.ofNullable(contentCachingClientListenRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Determines the method in which content caches peer with other caches.”</i>
     * 
     * @return property contentCachingPeerPolicy
     */
    @Property(name="contentCachingPeerPolicy")
    @JsonIgnore
    public Optional<MacOSContentCachingPeerPolicy> getContentCachingPeerPolicy() {
        return Optional.ofNullable(contentCachingPeerPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingPeerPolicy} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines the method in which content caches peer with other caches.”</i>
     * 
     * @param contentCachingPeerPolicy
     *            new value of {@code contentCachingPeerPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingPeerPolicy} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingPeerPolicy(MacOSContentCachingPeerPolicy contentCachingPeerPolicy) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingPeerPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingPeerPolicy = contentCachingPeerPolicy;
        return _x;
    }

    /**
     * <i>“A list of custom IP ranges content caches will use to listen for peer caches.
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property contentCachingPeerListenRanges
     */
    @Property(name="contentCachingPeerListenRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingPeerListenRanges() {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingPeerListenRanges, Optional.ofNullable(contentCachingPeerListenRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of custom IP ranges content caches will use to listen for peer caches.
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property contentCachingPeerListenRanges
     */
    @Property(name="contentCachingPeerListenRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingPeerListenRanges(HttpRequestOptions options) {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingPeerListenRanges, Optional.ofNullable(contentCachingPeerListenRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“A list of custom IP ranges content caches will use to query for content from
     * peers caches. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property contentCachingPeerFilterRanges
     */
    @Property(name="contentCachingPeerFilterRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingPeerFilterRanges() {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingPeerFilterRanges, Optional.ofNullable(contentCachingPeerFilterRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of custom IP ranges content caches will use to query for content from
     * peers caches. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property contentCachingPeerFilterRanges
     */
    @Property(name="contentCachingPeerFilterRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingPeerFilterRanges(HttpRequestOptions options) {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingPeerFilterRanges, Optional.ofNullable(contentCachingPeerFilterRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Determines the method in which content caching servers will select parents if
     * multiple are present.”</i>
     * 
     * @return property contentCachingParentSelectionPolicy
     */
    @Property(name="contentCachingParentSelectionPolicy")
    @JsonIgnore
    public Optional<MacOSContentCachingParentSelectionPolicy> getContentCachingParentSelectionPolicy() {
        return Optional.ofNullable(contentCachingParentSelectionPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingParentSelectionPolicy} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Determines the method in which content caching servers will select parents if
     * multiple are present.”</i>
     * 
     * @param contentCachingParentSelectionPolicy
     *            new value of {@code contentCachingParentSelectionPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingParentSelectionPolicy} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingParentSelectionPolicy(MacOSContentCachingParentSelectionPolicy contentCachingParentSelectionPolicy) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingParentSelectionPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingParentSelectionPolicy = contentCachingParentSelectionPolicy;
        return _x;
    }

    /**
     * <i>“A list of IP addresses representing parent content caches.”</i>
     * 
     * @return property contentCachingParents
     */
    @Property(name="contentCachingParents")
    @JsonIgnore
    public CollectionPage<String> getContentCachingParents() {
        return new CollectionPage<String>(contextPath, String.class, contentCachingParents, Optional.ofNullable(contentCachingParentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of IP addresses representing parent content caches.”</i>
     * 
     * @return property contentCachingParents
     */
    @Property(name="contentCachingParents")
    @JsonIgnore
    public CollectionPage<String> getContentCachingParents(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, contentCachingParents, Optional.ofNullable(contentCachingParentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Enables logging of IP addresses and ports of clients that request cached content
     * .”</i>
     * 
     * @return property contentCachingLogClientIdentities
     */
    @Property(name="contentCachingLogClientIdentities")
    @JsonIgnore
    public Optional<Boolean> getContentCachingLogClientIdentities() {
        return Optional.ofNullable(contentCachingLogClientIdentities);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingLogClientIdentities} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enables logging of IP addresses and ports of clients that request cached content
     * .”</i>
     * 
     * @param contentCachingLogClientIdentities
     *            new value of {@code contentCachingLogClientIdentities} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingLogClientIdentities} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingLogClientIdentities(Boolean contentCachingLogClientIdentities) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingLogClientIdentities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingLogClientIdentities = contentCachingLogClientIdentities;
        return _x;
    }

    /**
     * <i>“A list of custom IP ranges that Apple's content caching service should use to
     * match clients to content caches. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property contentCachingPublicRanges
     */
    @Property(name="contentCachingPublicRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingPublicRanges() {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingPublicRanges, Optional.ofNullable(contentCachingPublicRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of custom IP ranges that Apple's content caching service should use to
     * match clients to content caches. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property contentCachingPublicRanges
     */
    @Property(name="contentCachingPublicRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getContentCachingPublicRanges(HttpRequestOptions options) {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, contentCachingPublicRanges, Optional.ofNullable(contentCachingPublicRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Prevents content caches from purging content to free up disk space for other
     * apps.”</i>
     * 
     * @return property contentCachingBlockDeletion
     */
    @Property(name="contentCachingBlockDeletion")
    @JsonIgnore
    public Optional<Boolean> getContentCachingBlockDeletion() {
        return Optional.ofNullable(contentCachingBlockDeletion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingBlockDeletion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Prevents content caches from purging content to free up disk space for other
     * apps.”</i>
     * 
     * @param contentCachingBlockDeletion
     *            new value of {@code contentCachingBlockDeletion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingBlockDeletion} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingBlockDeletion(Boolean contentCachingBlockDeletion) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingBlockDeletion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingBlockDeletion = contentCachingBlockDeletion;
        return _x;
    }

    /**
     * <i>“Display content caching alerts as system notifications.”</i>
     * 
     * @return property contentCachingShowAlerts
     */
    @Property(name="contentCachingShowAlerts")
    @JsonIgnore
    public Optional<Boolean> getContentCachingShowAlerts() {
        return Optional.ofNullable(contentCachingShowAlerts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingShowAlerts} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Display content caching alerts as system notifications.”</i>
     * 
     * @param contentCachingShowAlerts
     *            new value of {@code contentCachingShowAlerts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingShowAlerts} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingShowAlerts(Boolean contentCachingShowAlerts) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingShowAlerts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingShowAlerts = contentCachingShowAlerts;
        return _x;
    }

    /**
     * <i>“Prevent the device from sleeping if content caching is enabled.”</i>
     * 
     * @return property contentCachingKeepAwake
     */
    @Property(name="contentCachingKeepAwake")
    @JsonIgnore
    public Optional<Boolean> getContentCachingKeepAwake() {
        return Optional.ofNullable(contentCachingKeepAwake);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingKeepAwake} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Prevent the device from sleeping if content caching is enabled.”</i>
     * 
     * @param contentCachingKeepAwake
     *            new value of {@code contentCachingKeepAwake} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingKeepAwake} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingKeepAwake(Boolean contentCachingKeepAwake) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingKeepAwake");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingKeepAwake = contentCachingKeepAwake;
        return _x;
    }

    /**
     * <i>“Sets the port used for content caching. If the value is 0, a random available
     * port will be selected. Valid values 0 to 65535”</i>
     * 
     * @return property contentCachingPort
     */
    @Property(name="contentCachingPort")
    @JsonIgnore
    public Optional<Integer> getContentCachingPort() {
        return Optional.ofNullable(contentCachingPort);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentCachingPort} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Sets the port used for content caching. If the value is 0, a random available
     * port will be selected. Valid values 0 to 65535”</i>
     * 
     * @param contentCachingPort
     *            new value of {@code contentCachingPort} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentCachingPort} field changed
     */
    public MacOSDeviceFeaturesConfiguration withContentCachingPort(Integer contentCachingPort) {
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentCachingPort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDeviceFeaturesConfiguration");
        _x.contentCachingPort = contentCachingPort;
        return _x;
    }

    /**
     * <i>“PKINIT Certificate for the authentication with single sign-on extensions.”</i>
     * 
     * @return navigational property singleSignOnExtensionPkinitCertificate
     */
    @NavigationProperty(name="singleSignOnExtensionPkinitCertificate")
    @JsonIgnore
    public MacOSCertificateProfileBaseRequest getSingleSignOnExtensionPkinitCertificate() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("singleSignOnExtensionPkinitCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSDeviceFeaturesConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSDeviceFeaturesConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSDeviceFeaturesConfiguration _copy() {
        MacOSDeviceFeaturesConfiguration _x = new MacOSDeviceFeaturesConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.airPrintDestinations = airPrintDestinations;
        _x.autoLaunchItems = autoLaunchItems;
        _x.adminShowHostInfo = adminShowHostInfo;
        _x.loginWindowText = loginWindowText;
        _x.authorizedUsersListHidden = authorizedUsersListHidden;
        _x.authorizedUsersListHideLocalUsers = authorizedUsersListHideLocalUsers;
        _x.authorizedUsersListHideMobileAccounts = authorizedUsersListHideMobileAccounts;
        _x.authorizedUsersListIncludeNetworkUsers = authorizedUsersListIncludeNetworkUsers;
        _x.authorizedUsersListHideAdminUsers = authorizedUsersListHideAdminUsers;
        _x.authorizedUsersListShowOtherManagedUsers = authorizedUsersListShowOtherManagedUsers;
        _x.shutDownDisabled = shutDownDisabled;
        _x.restartDisabled = restartDisabled;
        _x.sleepDisabled = sleepDisabled;
        _x.consoleAccessDisabled = consoleAccessDisabled;
        _x.shutDownDisabledWhileLoggedIn = shutDownDisabledWhileLoggedIn;
        _x.restartDisabledWhileLoggedIn = restartDisabledWhileLoggedIn;
        _x.powerOffDisabledWhileLoggedIn = powerOffDisabledWhileLoggedIn;
        _x.logOutDisabledWhileLoggedIn = logOutDisabledWhileLoggedIn;
        _x.screenLockDisableImmediate = screenLockDisableImmediate;
        _x.associatedDomains = associatedDomains;
        _x.singleSignOnExtension = singleSignOnExtension;
        _x.macOSSingleSignOnExtension = macOSSingleSignOnExtension;
        _x.contentCachingEnabled = contentCachingEnabled;
        _x.contentCachingType = contentCachingType;
        _x.contentCachingMaxSizeBytes = contentCachingMaxSizeBytes;
        _x.contentCachingDataPath = contentCachingDataPath;
        _x.contentCachingDisableConnectionSharing = contentCachingDisableConnectionSharing;
        _x.contentCachingForceConnectionSharing = contentCachingForceConnectionSharing;
        _x.contentCachingClientPolicy = contentCachingClientPolicy;
        _x.contentCachingClientListenRanges = contentCachingClientListenRanges;
        _x.contentCachingPeerPolicy = contentCachingPeerPolicy;
        _x.contentCachingPeerListenRanges = contentCachingPeerListenRanges;
        _x.contentCachingPeerFilterRanges = contentCachingPeerFilterRanges;
        _x.contentCachingParentSelectionPolicy = contentCachingParentSelectionPolicy;
        _x.contentCachingParents = contentCachingParents;
        _x.contentCachingLogClientIdentities = contentCachingLogClientIdentities;
        _x.contentCachingPublicRanges = contentCachingPublicRanges;
        _x.contentCachingBlockDeletion = contentCachingBlockDeletion;
        _x.contentCachingShowAlerts = contentCachingShowAlerts;
        _x.contentCachingKeepAwake = contentCachingKeepAwake;
        _x.contentCachingPort = contentCachingPort;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSDeviceFeaturesConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("airPrintDestinations=");
        b.append(this.airPrintDestinations);
        b.append(", ");
        b.append("autoLaunchItems=");
        b.append(this.autoLaunchItems);
        b.append(", ");
        b.append("adminShowHostInfo=");
        b.append(this.adminShowHostInfo);
        b.append(", ");
        b.append("loginWindowText=");
        b.append(this.loginWindowText);
        b.append(", ");
        b.append("authorizedUsersListHidden=");
        b.append(this.authorizedUsersListHidden);
        b.append(", ");
        b.append("authorizedUsersListHideLocalUsers=");
        b.append(this.authorizedUsersListHideLocalUsers);
        b.append(", ");
        b.append("authorizedUsersListHideMobileAccounts=");
        b.append(this.authorizedUsersListHideMobileAccounts);
        b.append(", ");
        b.append("authorizedUsersListIncludeNetworkUsers=");
        b.append(this.authorizedUsersListIncludeNetworkUsers);
        b.append(", ");
        b.append("authorizedUsersListHideAdminUsers=");
        b.append(this.authorizedUsersListHideAdminUsers);
        b.append(", ");
        b.append("authorizedUsersListShowOtherManagedUsers=");
        b.append(this.authorizedUsersListShowOtherManagedUsers);
        b.append(", ");
        b.append("shutDownDisabled=");
        b.append(this.shutDownDisabled);
        b.append(", ");
        b.append("restartDisabled=");
        b.append(this.restartDisabled);
        b.append(", ");
        b.append("sleepDisabled=");
        b.append(this.sleepDisabled);
        b.append(", ");
        b.append("consoleAccessDisabled=");
        b.append(this.consoleAccessDisabled);
        b.append(", ");
        b.append("shutDownDisabledWhileLoggedIn=");
        b.append(this.shutDownDisabledWhileLoggedIn);
        b.append(", ");
        b.append("restartDisabledWhileLoggedIn=");
        b.append(this.restartDisabledWhileLoggedIn);
        b.append(", ");
        b.append("powerOffDisabledWhileLoggedIn=");
        b.append(this.powerOffDisabledWhileLoggedIn);
        b.append(", ");
        b.append("logOutDisabledWhileLoggedIn=");
        b.append(this.logOutDisabledWhileLoggedIn);
        b.append(", ");
        b.append("screenLockDisableImmediate=");
        b.append(this.screenLockDisableImmediate);
        b.append(", ");
        b.append("associatedDomains=");
        b.append(this.associatedDomains);
        b.append(", ");
        b.append("singleSignOnExtension=");
        b.append(this.singleSignOnExtension);
        b.append(", ");
        b.append("macOSSingleSignOnExtension=");
        b.append(this.macOSSingleSignOnExtension);
        b.append(", ");
        b.append("contentCachingEnabled=");
        b.append(this.contentCachingEnabled);
        b.append(", ");
        b.append("contentCachingType=");
        b.append(this.contentCachingType);
        b.append(", ");
        b.append("contentCachingMaxSizeBytes=");
        b.append(this.contentCachingMaxSizeBytes);
        b.append(", ");
        b.append("contentCachingDataPath=");
        b.append(this.contentCachingDataPath);
        b.append(", ");
        b.append("contentCachingDisableConnectionSharing=");
        b.append(this.contentCachingDisableConnectionSharing);
        b.append(", ");
        b.append("contentCachingForceConnectionSharing=");
        b.append(this.contentCachingForceConnectionSharing);
        b.append(", ");
        b.append("contentCachingClientPolicy=");
        b.append(this.contentCachingClientPolicy);
        b.append(", ");
        b.append("contentCachingClientListenRanges=");
        b.append(this.contentCachingClientListenRanges);
        b.append(", ");
        b.append("contentCachingPeerPolicy=");
        b.append(this.contentCachingPeerPolicy);
        b.append(", ");
        b.append("contentCachingPeerListenRanges=");
        b.append(this.contentCachingPeerListenRanges);
        b.append(", ");
        b.append("contentCachingPeerFilterRanges=");
        b.append(this.contentCachingPeerFilterRanges);
        b.append(", ");
        b.append("contentCachingParentSelectionPolicy=");
        b.append(this.contentCachingParentSelectionPolicy);
        b.append(", ");
        b.append("contentCachingParents=");
        b.append(this.contentCachingParents);
        b.append(", ");
        b.append("contentCachingLogClientIdentities=");
        b.append(this.contentCachingLogClientIdentities);
        b.append(", ");
        b.append("contentCachingPublicRanges=");
        b.append(this.contentCachingPublicRanges);
        b.append(", ");
        b.append("contentCachingBlockDeletion=");
        b.append(this.contentCachingBlockDeletion);
        b.append(", ");
        b.append("contentCachingShowAlerts=");
        b.append(this.contentCachingShowAlerts);
        b.append(", ");
        b.append("contentCachingKeepAwake=");
        b.append(this.contentCachingKeepAwake);
        b.append(", ");
        b.append("contentCachingPort=");
        b.append(this.contentCachingPort);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
