package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.LongRunningOperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "lastActionDateTime", 
    "status", 
    "statusDetail", 
    "resourceLocation"})
@JsonInclude(Include.NON_NULL)
public class LongRunningOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.longRunningOperation";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("status")
    protected LongRunningOperationStatus status;

    @JsonProperty("statusDetail")
    protected String statusDetail;

    @JsonProperty("resourceLocation")
    protected String resourceLocation;

    protected LongRunningOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLongRunningOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastActionDateTime;
        private LongRunningOperationStatus status;
        private String statusDetail;
        private String resourceLocation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder status(LongRunningOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            this.changedFields = changedFields.add("statusDetail");
            return this;
        }

        public Builder resourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            this.changedFields = changedFields.add("resourceLocation");
            return this;
        }

        public LongRunningOperation build() {
            LongRunningOperation _x = new LongRunningOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.longRunningOperation";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastActionDateTime = lastActionDateTime;
            _x.status = status;
            _x.statusDetail = statusDetail;
            _x.resourceLocation = resourceLocation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public LongRunningOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        LongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.longRunningOperation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public LongRunningOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        LongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.longRunningOperation");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<LongRunningOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public LongRunningOperation withStatus(LongRunningOperationStatus status) {
        LongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.longRunningOperation");
        _x.status = status;
        return _x;
    }

    @Property(name="statusDetail")
    @JsonIgnore
    public Optional<String> getStatusDetail() {
        return Optional.ofNullable(statusDetail);
    }

    public LongRunningOperation withStatusDetail(String statusDetail) {
        LongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("statusDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.longRunningOperation");
        _x.statusDetail = statusDetail;
        return _x;
    }

    @Property(name="resourceLocation")
    @JsonIgnore
    public Optional<String> getResourceLocation() {
        return Optional.ofNullable(resourceLocation);
    }

    public LongRunningOperation withResourceLocation(String resourceLocation) {
        LongRunningOperation _x = _copy();
        _x.changedFields = changedFields.add("resourceLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.longRunningOperation");
        _x.resourceLocation = resourceLocation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LongRunningOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        LongRunningOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LongRunningOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        LongRunningOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private LongRunningOperation _copy() {
        LongRunningOperation _x = new LongRunningOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastActionDateTime = lastActionDateTime;
        _x.status = status;
        _x.statusDetail = statusDetail;
        _x.resourceLocation = resourceLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongRunningOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("statusDetail=");
        b.append(this.statusDetail);
        b.append(", ");
        b.append("resourceLocation=");
        b.append(this.resourceLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
