package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The text content of a Notification Message Template for the specified locale.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastModifiedDateTime", 
    "locale", 
    "subject", 
    "messageTemplate", 
    "isDefault"})
@JsonInclude(Include.NON_NULL)
public class LocalizedNotificationMessage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.localizedNotificationMessage";
    }

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("locale")
    protected String locale;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("messageTemplate")
    protected String messageTemplate;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    protected LocalizedNotificationMessage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLocalizedNotificationMessage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private String locale;
        private String subject;
        private String messageTemplate;
        private Boolean isDefault;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“DateTime the object was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The Locale for which this message is destined.”</i>
         * 
         * @param locale
         *            value of {@code locale} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder locale(String locale) {
            this.locale = locale;
            this.changedFields = changedFields.add("locale");
            return this;
        }

        /**
         * <i>“The Message Template Subject.”</i>
         * 
         * @param subject
         *            value of {@code subject} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        /**
         * <i>“The Message Template content.”</i>
         * 
         * @param messageTemplate
         *            value of {@code messageTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messageTemplate(String messageTemplate) {
            this.messageTemplate = messageTemplate;
            this.changedFields = changedFields.add("messageTemplate");
            return this;
        }

        /**
         * <i>“Flag to indicate whether or not this is the default locale for language fallback
         * . This flag can only be set. To unset, set this property to true on another
         * Localized Notification Message.”</i>
         * 
         * @param isDefault
         *            value of {@code isDefault} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public LocalizedNotificationMessage build() {
            LocalizedNotificationMessage _x = new LocalizedNotificationMessage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.localizedNotificationMessage";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.locale = locale;
            _x.subject = subject;
            _x.messageTemplate = messageTemplate;
            _x.isDefault = isDefault;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public LocalizedNotificationMessage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localizedNotificationMessage");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The Locale for which this message is destined.”</i>
     * 
     * @return property locale
     */
    @Property(name="locale")
    @JsonIgnore
    public Optional<String> getLocale() {
        return Optional.ofNullable(locale);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code locale} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Locale for which this message is destined.”</i>
     * 
     * @param locale
     *            new value of {@code locale} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locale} field changed
     */
    public LocalizedNotificationMessage withLocale(String locale) {
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = changedFields.add("locale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localizedNotificationMessage");
        _x.locale = locale;
        return _x;
    }

    /**
     * <i>“The Message Template Subject.”</i>
     * 
     * @return property subject
     */
    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subject} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Message Template Subject.”</i>
     * 
     * @param subject
     *            new value of {@code subject} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subject} field changed
     */
    public LocalizedNotificationMessage withSubject(String subject) {
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localizedNotificationMessage");
        _x.subject = subject;
        return _x;
    }

    /**
     * <i>“The Message Template content.”</i>
     * 
     * @return property messageTemplate
     */
    @Property(name="messageTemplate")
    @JsonIgnore
    public Optional<String> getMessageTemplate() {
        return Optional.ofNullable(messageTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messageTemplate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Message Template content.”</i>
     * 
     * @param messageTemplate
     *            new value of {@code messageTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messageTemplate} field changed
     */
    public LocalizedNotificationMessage withMessageTemplate(String messageTemplate) {
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = changedFields.add("messageTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localizedNotificationMessage");
        _x.messageTemplate = messageTemplate;
        return _x;
    }

    /**
     * <i>“Flag to indicate whether or not this is the default locale for language fallback
     * . This flag can only be set. To unset, set this property to true on another
     * Localized Notification Message.”</i>
     * 
     * @return property isDefault
     */
    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDefault} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Flag to indicate whether or not this is the default locale for language fallback
     * . This flag can only be set. To unset, set this property to true on another
     * Localized Notification Message.”</i>
     * 
     * @param isDefault
     *            new value of {@code isDefault} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDefault} field changed
     */
    public LocalizedNotificationMessage withIsDefault(Boolean isDefault) {
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localizedNotificationMessage");
        _x.isDefault = isDefault;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LocalizedNotificationMessage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LocalizedNotificationMessage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        LocalizedNotificationMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private LocalizedNotificationMessage _copy() {
        LocalizedNotificationMessage _x = new LocalizedNotificationMessage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.locale = locale;
        _x.subject = subject;
        _x.messageTemplate = messageTemplate;
        _x.isDefault = isDefault;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedNotificationMessage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("locale=");
        b.append(this.locale);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("messageTemplate=");
        b.append(this.messageTemplate);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
