package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSource;
import odata.msgraph.client.beta.enums.AllowedAudiences;
import odata.msgraph.client.beta.enums.LanguageProficiencyLevel;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "tag", 
    "proficiency", 
    "spoken", 
    "written", 
    "reading"})
@JsonInclude(Include.NON_NULL)
public class LanguageProficiency extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.languageProficiency";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("tag")
    protected String tag;

    @JsonProperty("proficiency")
    protected LanguageProficiencyLevel proficiency;

    @JsonProperty("spoken")
    protected LanguageProficiencyLevel spoken;

    @JsonProperty("written")
    protected LanguageProficiencyLevel written;

    @JsonProperty("reading")
    protected LanguageProficiencyLevel reading;

    protected LanguageProficiency() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLanguageProficiency() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private InferenceData inference;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private PersonDataSource source;
        private String displayName;
        private String tag;
        private LanguageProficiencyLevel proficiency;
        private LanguageProficiencyLevel spoken;
        private LanguageProficiencyLevel written;
        private LanguageProficiencyLevel reading;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder source(PersonDataSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            this.changedFields = changedFields.add("tag");
            return this;
        }

        public Builder proficiency(LanguageProficiencyLevel proficiency) {
            this.proficiency = proficiency;
            this.changedFields = changedFields.add("proficiency");
            return this;
        }

        public Builder spoken(LanguageProficiencyLevel spoken) {
            this.spoken = spoken;
            this.changedFields = changedFields.add("spoken");
            return this;
        }

        public Builder written(LanguageProficiencyLevel written) {
            this.written = written;
            this.changedFields = changedFields.add("written");
            return this;
        }

        public Builder reading(LanguageProficiencyLevel reading) {
            this.reading = reading;
            this.changedFields = changedFields.add("reading");
            return this;
        }

        public LanguageProficiency build() {
            LanguageProficiency _x = new LanguageProficiency();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.languageProficiency";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.inference = inference;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.source = source;
            _x.displayName = displayName;
            _x.tag = tag;
            _x.proficiency = proficiency;
            _x.spoken = spoken;
            _x.written = written;
            _x.reading = reading;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public LanguageProficiency withDisplayName(String displayName) {
        LanguageProficiency _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.languageProficiency");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="tag")
    @JsonIgnore
    public Optional<String> getTag() {
        return Optional.ofNullable(tag);
    }

    public LanguageProficiency withTag(String tag) {
        LanguageProficiency _x = _copy();
        _x.changedFields = changedFields.add("tag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.languageProficiency");
        _x.tag = tag;
        return _x;
    }

    @Property(name="proficiency")
    @JsonIgnore
    public Optional<LanguageProficiencyLevel> getProficiency() {
        return Optional.ofNullable(proficiency);
    }

    public LanguageProficiency withProficiency(LanguageProficiencyLevel proficiency) {
        LanguageProficiency _x = _copy();
        _x.changedFields = changedFields.add("proficiency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.languageProficiency");
        _x.proficiency = proficiency;
        return _x;
    }

    @Property(name="spoken")
    @JsonIgnore
    public Optional<LanguageProficiencyLevel> getSpoken() {
        return Optional.ofNullable(spoken);
    }

    public LanguageProficiency withSpoken(LanguageProficiencyLevel spoken) {
        LanguageProficiency _x = _copy();
        _x.changedFields = changedFields.add("spoken");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.languageProficiency");
        _x.spoken = spoken;
        return _x;
    }

    @Property(name="written")
    @JsonIgnore
    public Optional<LanguageProficiencyLevel> getWritten() {
        return Optional.ofNullable(written);
    }

    public LanguageProficiency withWritten(LanguageProficiencyLevel written) {
        LanguageProficiency _x = _copy();
        _x.changedFields = changedFields.add("written");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.languageProficiency");
        _x.written = written;
        return _x;
    }

    @Property(name="reading")
    @JsonIgnore
    public Optional<LanguageProficiencyLevel> getReading() {
        return Optional.ofNullable(reading);
    }

    public LanguageProficiency withReading(LanguageProficiencyLevel reading) {
        LanguageProficiency _x = _copy();
        _x.changedFields = changedFields.add("reading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.languageProficiency");
        _x.reading = reading;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LanguageProficiency patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        LanguageProficiency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public LanguageProficiency put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        LanguageProficiency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private LanguageProficiency _copy() {
        LanguageProficiency _x = new LanguageProficiency();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.inference = inference;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.source = source;
        _x.displayName = displayName;
        _x.tag = tag;
        _x.proficiency = proficiency;
        _x.spoken = spoken;
        _x.written = written;
        _x.reading = reading;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LanguageProficiency[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("tag=");
        b.append(this.tag);
        b.append(", ");
        b.append("proficiency=");
        b.append(this.proficiency);
        b.append(", ");
        b.append("spoken=");
        b.append(this.spoken);
        b.append(", ");
        b.append("written=");
        b.append(this.written);
        b.append(", ");
        b.append("reading=");
        b.append(this.reading);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
