package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.JournalLineCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccountRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "displayName", 
    "lastModifiedDateTime", 
    "balancingAccountId", 
    "balancingAccountNumber"})
@JsonInclude(Include.NON_NULL)
public class Journal extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.journal";
    }

    @JsonProperty("code")
    protected String code;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("balancingAccountId")
    protected String balancingAccountId;

    @JsonProperty("balancingAccountNumber")
    protected String balancingAccountNumber;

    protected Journal() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderJournal() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String code;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private String balancingAccountId;
        private String balancingAccountNumber;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder balancingAccountId(String balancingAccountId) {
            this.balancingAccountId = balancingAccountId;
            this.changedFields = changedFields.add("balancingAccountId");
            return this;
        }

        public Builder balancingAccountNumber(String balancingAccountNumber) {
            this.balancingAccountNumber = balancingAccountNumber;
            this.changedFields = changedFields.add("balancingAccountNumber");
            return this;
        }

        public Journal build() {
            Journal _x = new Journal();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.journal";
            _x.id = id;
            _x.code = code;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.balancingAccountId = balancingAccountId;
            _x.balancingAccountNumber = balancingAccountNumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public Journal withCode(String code) {
        Journal _x = _copy();
        _x.changedFields = changedFields.add("code");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journal");
        _x.code = code;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Journal withDisplayName(String displayName) {
        Journal _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journal");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Journal withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Journal _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journal");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="balancingAccountId")
    @JsonIgnore
    public Optional<String> getBalancingAccountId() {
        return Optional.ofNullable(balancingAccountId);
    }

    public Journal withBalancingAccountId(String balancingAccountId) {
        Journal _x = _copy();
        _x.changedFields = changedFields.add("balancingAccountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journal");
        _x.balancingAccountId = balancingAccountId;
        return _x;
    }

    @Property(name="balancingAccountNumber")
    @JsonIgnore
    public Optional<String> getBalancingAccountNumber() {
        return Optional.ofNullable(balancingAccountNumber);
    }

    public Journal withBalancingAccountNumber(String balancingAccountNumber) {
        Journal _x = _copy();
        _x.changedFields = changedFields.add("balancingAccountNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.journal");
        _x.balancingAccountNumber = balancingAccountNumber;
        return _x;
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public AccountRequest getAccount() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

    @NavigationProperty(name="journalLines")
    @JsonIgnore
    public JournalLineCollectionRequest getJournalLines() {
        return new JournalLineCollectionRequest(
                        contextPath.addSegment("journalLines"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Journal patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Journal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Journal put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Journal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Journal _copy() {
        Journal _x = new Journal();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.code = code;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.balancingAccountId = balancingAccountId;
        _x.balancingAccountNumber = balancingAccountNumber;
        return _x;
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Journal[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("balancingAccountId=");
        b.append(this.balancingAccountId);
        b.append(", ");
        b.append("balancingAccountNumber=");
        b.append(this.balancingAccountNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
