package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isEnabledInOrganization", 
    "disabledForGroup"})
@JsonInclude(Include.NON_NULL)
public class ItemInsights extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemInsights";
    }

    @JsonProperty("isEnabledInOrganization")
    protected Boolean isEnabledInOrganization;

    @JsonProperty("disabledForGroup")
    protected String disabledForGroup;

    protected ItemInsights() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItemInsights() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isEnabledInOrganization;
        private String disabledForGroup;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEnabledInOrganization(Boolean isEnabledInOrganization) {
            this.isEnabledInOrganization = isEnabledInOrganization;
            this.changedFields = changedFields.add("isEnabledInOrganization");
            return this;
        }

        public Builder disabledForGroup(String disabledForGroup) {
            this.disabledForGroup = disabledForGroup;
            this.changedFields = changedFields.add("disabledForGroup");
            return this;
        }

        public ItemInsights build() {
            ItemInsights _x = new ItemInsights();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.itemInsights";
            _x.id = id;
            _x.isEnabledInOrganization = isEnabledInOrganization;
            _x.disabledForGroup = disabledForGroup;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="isEnabledInOrganization")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledInOrganization() {
        return Optional.ofNullable(isEnabledInOrganization);
    }

    public ItemInsights withIsEnabledInOrganization(Boolean isEnabledInOrganization) {
        ItemInsights _x = _copy();
        _x.changedFields = changedFields.add("isEnabledInOrganization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemInsights");
        _x.isEnabledInOrganization = isEnabledInOrganization;
        return _x;
    }

    @Property(name="disabledForGroup")
    @JsonIgnore
    public Optional<String> getDisabledForGroup() {
        return Optional.ofNullable(disabledForGroup);
    }

    public ItemInsights withDisabledForGroup(String disabledForGroup) {
        ItemInsights _x = _copy();
        _x.changedFields = changedFields.add("disabledForGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemInsights");
        _x.disabledForGroup = disabledForGroup;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemInsights patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemInsights _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemInsights put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemInsights _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemInsights _copy() {
        ItemInsights _x = new ItemInsights();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.isEnabledInOrganization = isEnabledInOrganization;
        _x.disabledForGroup = disabledForGroup;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemInsights[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEnabledInOrganization=");
        b.append(this.isEnabledInOrganization);
        b.append(", ");
        b.append("disabledForGroup=");
        b.append(this.disabledForGroup);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
