package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSource;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedAudiences", 
    "inference", 
    "createdDateTime", 
    "createdBy", 
    "lastModifiedDateTime", 
    "lastModifiedBy", 
    "source"})
@JsonInclude(Include.NON_NULL)
public class ItemFacet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemFacet";
    }

    @JsonProperty("allowedAudiences")
    protected AllowedAudiences allowedAudiences;

    @JsonProperty("inference")
    protected InferenceData inference;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("source")
    protected PersonDataSource source;

    protected ItemFacet() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="allowedAudiences")
    @JsonIgnore
    public Optional<AllowedAudiences> getAllowedAudiences() {
        return Optional.ofNullable(allowedAudiences);
    }

    public ItemFacet withAllowedAudiences(AllowedAudiences allowedAudiences) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("allowedAudiences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.allowedAudiences = allowedAudiences;
        return _x;
    }

    @Property(name="inference")
    @JsonIgnore
    public Optional<InferenceData> getInference() {
        return Optional.ofNullable(inference);
    }

    public ItemFacet withInference(InferenceData inference) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("inference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.inference = inference;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ItemFacet withCreatedDateTime(OffsetDateTime createdDateTime) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public ItemFacet withCreatedBy(IdentitySet createdBy) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ItemFacet withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public ItemFacet withLastModifiedBy(IdentitySet lastModifiedBy) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<PersonDataSource> getSource() {
        return Optional.ofNullable(source);
    }

    public ItemFacet withSource(PersonDataSource source) {
        ItemFacet _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemFacet");
        _x.source = source;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemFacet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemFacet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemFacet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemFacet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemFacet _copy() {
        ItemFacet _x = new ItemFacet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.inference = inference;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.source = source;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemFacet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
