package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemActionSet;
import odata.msgraph.client.beta.complex.ItemActivityTimeSet;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.ListItemRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "actor", 
    "times"})
@JsonInclude(Include.NON_NULL)
public class ItemActivityOLD extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemActivityOLD";
    }

    @JsonProperty("action")
    protected ItemActionSet action;

    @JsonProperty("actor")
    protected IdentitySet actor;

    @JsonProperty("times")
    protected ItemActivityTimeSet times;

    protected ItemActivityOLD() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItemActivityOLD() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ItemActionSet action;
        private IdentitySet actor;
        private ItemActivityTimeSet times;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder action(ItemActionSet action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder actor(IdentitySet actor) {
            this.actor = actor;
            this.changedFields = changedFields.add("actor");
            return this;
        }

        public Builder times(ItemActivityTimeSet times) {
            this.times = times;
            this.changedFields = changedFields.add("times");
            return this;
        }

        public ItemActivityOLD build() {
            ItemActivityOLD _x = new ItemActivityOLD();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.itemActivityOLD";
            _x.id = id;
            _x.action = action;
            _x.actor = actor;
            _x.times = times;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<ItemActionSet> getAction() {
        return Optional.ofNullable(action);
    }

    public ItemActivityOLD withAction(ItemActionSet action) {
        ItemActivityOLD _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityOLD");
        _x.action = action;
        return _x;
    }

    @Property(name="actor")
    @JsonIgnore
    public Optional<IdentitySet> getActor() {
        return Optional.ofNullable(actor);
    }

    public ItemActivityOLD withActor(IdentitySet actor) {
        ItemActivityOLD _x = _copy();
        _x.changedFields = changedFields.add("actor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityOLD");
        _x.actor = actor;
        return _x;
    }

    @Property(name="times")
    @JsonIgnore
    public Optional<ItemActivityTimeSet> getTimes() {
        return Optional.ofNullable(times);
    }

    public ItemActivityOLD withTimes(ItemActivityTimeSet times) {
        ItemActivityOLD _x = _copy();
        _x.changedFields = changedFields.add("times");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityOLD");
        _x.times = times;
        return _x;
    }

    @NavigationProperty(name="driveItem")
    @JsonIgnore
    public DriveItemRequest getDriveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"));
    }

    @NavigationProperty(name="listItem")
    @JsonIgnore
    public ListItemRequest getListItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemActivityOLD patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemActivityOLD _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemActivityOLD put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemActivityOLD _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemActivityOLD _copy() {
        ItemActivityOLD _x = new ItemActivityOLD();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.action = action;
        _x.actor = actor;
        _x.times = times;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemActivityOLD[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("actor=");
        b.append(this.actor);
        b.append(", ");
        b.append("times=");
        b.append(this.times);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
