package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.entity.request.ItemCategoryRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "number", 
    "displayName", 
    "type", 
    "itemCategoryId", 
    "itemCategoryCode", 
    "blocked", 
    "baseUnitOfMeasureId", 
    "gtin", 
    "inventory", 
    "unitPrice", 
    "priceIncludesTax", 
    "unitCost", 
    "taxGroupId", 
    "taxGroupCode", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Item extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.item";
    }

    @JsonProperty("number")
    protected String number;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("itemCategoryId")
    protected String itemCategoryId;

    @JsonProperty("itemCategoryCode")
    protected String itemCategoryCode;

    @JsonProperty("blocked")
    protected Boolean blocked;

    @JsonProperty("baseUnitOfMeasureId")
    protected String baseUnitOfMeasureId;

    @JsonProperty("gtin")
    protected String gtin;

    @JsonProperty("inventory")
    protected BigDecimal inventory;

    @JsonProperty("unitPrice")
    protected BigDecimal unitPrice;

    @JsonProperty("priceIncludesTax")
    protected Boolean priceIncludesTax;

    @JsonProperty("unitCost")
    protected BigDecimal unitCost;

    @JsonProperty("taxGroupId")
    protected String taxGroupId;

    @JsonProperty("taxGroupCode")
    protected String taxGroupCode;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected Item() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String number;
        private String displayName;
        private String type;
        private String itemCategoryId;
        private String itemCategoryCode;
        private Boolean blocked;
        private String baseUnitOfMeasureId;
        private String gtin;
        private BigDecimal inventory;
        private BigDecimal unitPrice;
        private Boolean priceIncludesTax;
        private BigDecimal unitCost;
        private String taxGroupId;
        private String taxGroupCode;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder itemCategoryId(String itemCategoryId) {
            this.itemCategoryId = itemCategoryId;
            this.changedFields = changedFields.add("itemCategoryId");
            return this;
        }

        public Builder itemCategoryCode(String itemCategoryCode) {
            this.itemCategoryCode = itemCategoryCode;
            this.changedFields = changedFields.add("itemCategoryCode");
            return this;
        }

        public Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            this.changedFields = changedFields.add("blocked");
            return this;
        }

        public Builder baseUnitOfMeasureId(String baseUnitOfMeasureId) {
            this.baseUnitOfMeasureId = baseUnitOfMeasureId;
            this.changedFields = changedFields.add("baseUnitOfMeasureId");
            return this;
        }

        public Builder gtin(String gtin) {
            this.gtin = gtin;
            this.changedFields = changedFields.add("gtin");
            return this;
        }

        public Builder inventory(BigDecimal inventory) {
            this.inventory = inventory;
            this.changedFields = changedFields.add("inventory");
            return this;
        }

        public Builder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            this.changedFields = changedFields.add("unitPrice");
            return this;
        }

        public Builder priceIncludesTax(Boolean priceIncludesTax) {
            this.priceIncludesTax = priceIncludesTax;
            this.changedFields = changedFields.add("priceIncludesTax");
            return this;
        }

        public Builder unitCost(BigDecimal unitCost) {
            this.unitCost = unitCost;
            this.changedFields = changedFields.add("unitCost");
            return this;
        }

        public Builder taxGroupId(String taxGroupId) {
            this.taxGroupId = taxGroupId;
            this.changedFields = changedFields.add("taxGroupId");
            return this;
        }

        public Builder taxGroupCode(String taxGroupCode) {
            this.taxGroupCode = taxGroupCode;
            this.changedFields = changedFields.add("taxGroupCode");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Item build() {
            Item _x = new Item();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.item";
            _x.id = id;
            _x.number = number;
            _x.displayName = displayName;
            _x.type = type;
            _x.itemCategoryId = itemCategoryId;
            _x.itemCategoryCode = itemCategoryCode;
            _x.blocked = blocked;
            _x.baseUnitOfMeasureId = baseUnitOfMeasureId;
            _x.gtin = gtin;
            _x.inventory = inventory;
            _x.unitPrice = unitPrice;
            _x.priceIncludesTax = priceIncludesTax;
            _x.unitCost = unitCost;
            _x.taxGroupId = taxGroupId;
            _x.taxGroupCode = taxGroupCode;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Item withNumber(String number) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.number = number;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Item withDisplayName(String displayName) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public Item withType(String type) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.type = type;
        return _x;
    }

    @Property(name="itemCategoryId")
    @JsonIgnore
    public Optional<String> getItemCategoryId() {
        return Optional.ofNullable(itemCategoryId);
    }

    public Item withItemCategoryId(String itemCategoryId) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("itemCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.itemCategoryId = itemCategoryId;
        return _x;
    }

    @Property(name="itemCategoryCode")
    @JsonIgnore
    public Optional<String> getItemCategoryCode() {
        return Optional.ofNullable(itemCategoryCode);
    }

    public Item withItemCategoryCode(String itemCategoryCode) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("itemCategoryCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.itemCategoryCode = itemCategoryCode;
        return _x;
    }

    @Property(name="blocked")
    @JsonIgnore
    public Optional<Boolean> getBlocked() {
        return Optional.ofNullable(blocked);
    }

    public Item withBlocked(Boolean blocked) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("blocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.blocked = blocked;
        return _x;
    }

    @Property(name="baseUnitOfMeasureId")
    @JsonIgnore
    public Optional<String> getBaseUnitOfMeasureId() {
        return Optional.ofNullable(baseUnitOfMeasureId);
    }

    public Item withBaseUnitOfMeasureId(String baseUnitOfMeasureId) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("baseUnitOfMeasureId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.baseUnitOfMeasureId = baseUnitOfMeasureId;
        return _x;
    }

    @Property(name="gtin")
    @JsonIgnore
    public Optional<String> getGtin() {
        return Optional.ofNullable(gtin);
    }

    public Item withGtin(String gtin) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("gtin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.gtin = gtin;
        return _x;
    }

    @Property(name="inventory")
    @JsonIgnore
    public Optional<BigDecimal> getInventory() {
        return Optional.ofNullable(inventory);
    }

    public Item withInventory(BigDecimal inventory) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("inventory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.inventory = inventory;
        return _x;
    }

    @Property(name="unitPrice")
    @JsonIgnore
    public Optional<BigDecimal> getUnitPrice() {
        return Optional.ofNullable(unitPrice);
    }

    public Item withUnitPrice(BigDecimal unitPrice) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("unitPrice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.unitPrice = unitPrice;
        return _x;
    }

    @Property(name="priceIncludesTax")
    @JsonIgnore
    public Optional<Boolean> getPriceIncludesTax() {
        return Optional.ofNullable(priceIncludesTax);
    }

    public Item withPriceIncludesTax(Boolean priceIncludesTax) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("priceIncludesTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.priceIncludesTax = priceIncludesTax;
        return _x;
    }

    @Property(name="unitCost")
    @JsonIgnore
    public Optional<BigDecimal> getUnitCost() {
        return Optional.ofNullable(unitCost);
    }

    public Item withUnitCost(BigDecimal unitCost) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("unitCost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.unitCost = unitCost;
        return _x;
    }

    @Property(name="taxGroupId")
    @JsonIgnore
    public Optional<String> getTaxGroupId() {
        return Optional.ofNullable(taxGroupId);
    }

    public Item withTaxGroupId(String taxGroupId) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("taxGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.taxGroupId = taxGroupId;
        return _x;
    }

    @Property(name="taxGroupCode")
    @JsonIgnore
    public Optional<String> getTaxGroupCode() {
        return Optional.ofNullable(taxGroupCode);
    }

    public Item withTaxGroupCode(String taxGroupCode) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("taxGroupCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.taxGroupCode = taxGroupCode;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Item withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @NavigationProperty(name="picture")
    @JsonIgnore
    public PictureCollectionRequest getPicture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"));
    }

    @NavigationProperty(name="itemCategory")
    @JsonIgnore
    public ItemCategoryRequest getItemCategory() {
        return new ItemCategoryRequest(contextPath.addSegment("itemCategory"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Item patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Item _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Item put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Item _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Item _copy() {
        Item _x = new Item();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.number = number;
        _x.displayName = displayName;
        _x.type = type;
        _x.itemCategoryId = itemCategoryId;
        _x.itemCategoryCode = itemCategoryCode;
        _x.blocked = blocked;
        _x.baseUnitOfMeasureId = baseUnitOfMeasureId;
        _x.gtin = gtin;
        _x.inventory = inventory;
        _x.unitPrice = unitPrice;
        _x.priceIncludesTax = priceIncludesTax;
        _x.unitCost = unitCost;
        _x.taxGroupId = taxGroupId;
        _x.taxGroupCode = taxGroupCode;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Item[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("itemCategoryId=");
        b.append(this.itemCategoryId);
        b.append(", ");
        b.append("itemCategoryCode=");
        b.append(this.itemCategoryCode);
        b.append(", ");
        b.append("blocked=");
        b.append(this.blocked);
        b.append(", ");
        b.append("baseUnitOfMeasureId=");
        b.append(this.baseUnitOfMeasureId);
        b.append(", ");
        b.append("gtin=");
        b.append(this.gtin);
        b.append(", ");
        b.append("inventory=");
        b.append(this.inventory);
        b.append(", ");
        b.append("unitPrice=");
        b.append(this.unitPrice);
        b.append(", ");
        b.append("priceIncludesTax=");
        b.append(this.priceIncludesTax);
        b.append(", ");
        b.append("unitCost=");
        b.append(this.unitCost);
        b.append(", ");
        b.append("taxGroupId=");
        b.append(this.taxGroupId);
        b.append(", ");
        b.append("taxGroupCode=");
        b.append(this.taxGroupCode);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
