package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IpCategory;
import odata.msgraph.client.beta.complex.IpReferenceData;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activityGroupNames", 
    "address", 
    "azureSubscriptionId", 
    "azureTenantId", 
    "countHits", 
    "countHosts", 
    "firstSeenDateTime", 
    "ipCategories", 
    "ipReferenceData", 
    "lastSeenDateTime", 
    "riskScore", 
    "tags", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class IpSecurityProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ipSecurityProfile";
    }

    @JsonProperty("activityGroupNames")
    protected List<String> activityGroupNames;

    @JsonProperty("activityGroupNames@nextLink")
    protected String activityGroupNamesNextLink;

    @JsonProperty("address")
    protected String address;

    @JsonProperty("azureSubscriptionId")
    protected String azureSubscriptionId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("countHits")
    protected Integer countHits;

    @JsonProperty("countHosts")
    protected Integer countHosts;

    @JsonProperty("firstSeenDateTime")
    protected OffsetDateTime firstSeenDateTime;

    @JsonProperty("ipCategories")
    protected List<IpCategory> ipCategories;

    @JsonProperty("ipCategories@nextLink")
    protected String ipCategoriesNextLink;

    @JsonProperty("ipReferenceData")
    protected List<IpReferenceData> ipReferenceData;

    @JsonProperty("ipReferenceData@nextLink")
    protected String ipReferenceDataNextLink;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected IpSecurityProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIpSecurityProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> activityGroupNames;
        private String activityGroupNamesNextLink;
        private String address;
        private String azureSubscriptionId;
        private String azureTenantId;
        private Integer countHits;
        private Integer countHosts;
        private OffsetDateTime firstSeenDateTime;
        private List<IpCategory> ipCategories;
        private String ipCategoriesNextLink;
        private List<IpReferenceData> ipReferenceData;
        private String ipReferenceDataNextLink;
        private OffsetDateTime lastSeenDateTime;
        private String riskScore;
        private List<String> tags;
        private String tagsNextLink;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activityGroupNames(List<String> activityGroupNames) {
            this.activityGroupNames = activityGroupNames;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder activityGroupNames(String... activityGroupNames) {
            return activityGroupNames(Arrays.asList(activityGroupNames));
        }

        public Builder activityGroupNamesNextLink(String activityGroupNamesNextLink) {
            this.activityGroupNamesNextLink = activityGroupNamesNextLink;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder azureSubscriptionId(String azureSubscriptionId) {
            this.azureSubscriptionId = azureSubscriptionId;
            this.changedFields = changedFields.add("azureSubscriptionId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder countHits(Integer countHits) {
            this.countHits = countHits;
            this.changedFields = changedFields.add("countHits");
            return this;
        }

        public Builder countHosts(Integer countHosts) {
            this.countHosts = countHosts;
            this.changedFields = changedFields.add("countHosts");
            return this;
        }

        public Builder firstSeenDateTime(OffsetDateTime firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            this.changedFields = changedFields.add("firstSeenDateTime");
            return this;
        }

        public Builder ipCategories(List<IpCategory> ipCategories) {
            this.ipCategories = ipCategories;
            this.changedFields = changedFields.add("ipCategories");
            return this;
        }

        public Builder ipCategories(IpCategory... ipCategories) {
            return ipCategories(Arrays.asList(ipCategories));
        }

        public Builder ipCategoriesNextLink(String ipCategoriesNextLink) {
            this.ipCategoriesNextLink = ipCategoriesNextLink;
            this.changedFields = changedFields.add("ipCategories");
            return this;
        }

        public Builder ipReferenceData(List<IpReferenceData> ipReferenceData) {
            this.ipReferenceData = ipReferenceData;
            this.changedFields = changedFields.add("ipReferenceData");
            return this;
        }

        public Builder ipReferenceData(IpReferenceData... ipReferenceData) {
            return ipReferenceData(Arrays.asList(ipReferenceData));
        }

        public Builder ipReferenceDataNextLink(String ipReferenceDataNextLink) {
            this.ipReferenceDataNextLink = ipReferenceDataNextLink;
            this.changedFields = changedFields.add("ipReferenceData");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public IpSecurityProfile build() {
            IpSecurityProfile _x = new IpSecurityProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.ipSecurityProfile";
            _x.id = id;
            _x.activityGroupNames = activityGroupNames;
            _x.activityGroupNamesNextLink = activityGroupNamesNextLink;
            _x.address = address;
            _x.azureSubscriptionId = azureSubscriptionId;
            _x.azureTenantId = azureTenantId;
            _x.countHits = countHits;
            _x.countHosts = countHosts;
            _x.firstSeenDateTime = firstSeenDateTime;
            _x.ipCategories = ipCategories;
            _x.ipCategoriesNextLink = ipCategoriesNextLink;
            _x.ipReferenceData = ipReferenceData;
            _x.ipReferenceDataNextLink = ipReferenceDataNextLink;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.riskScore = riskScore;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames() {
        return new CollectionPage<String>(contextPath, String.class, activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    public IpSecurityProfile withAddress(String address) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.address = address;
        return _x;
    }

    @Property(name="azureSubscriptionId")
    @JsonIgnore
    public Optional<String> getAzureSubscriptionId() {
        return Optional.ofNullable(azureSubscriptionId);
    }

    public IpSecurityProfile withAzureSubscriptionId(String azureSubscriptionId) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureSubscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.azureSubscriptionId = azureSubscriptionId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public IpSecurityProfile withAzureTenantId(String azureTenantId) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="countHits")
    @JsonIgnore
    public Optional<Integer> getCountHits() {
        return Optional.ofNullable(countHits);
    }

    public IpSecurityProfile withCountHits(Integer countHits) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("countHits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.countHits = countHits;
        return _x;
    }

    @Property(name="countHosts")
    @JsonIgnore
    public Optional<Integer> getCountHosts() {
        return Optional.ofNullable(countHosts);
    }

    public IpSecurityProfile withCountHosts(Integer countHosts) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("countHosts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.countHosts = countHosts;
        return _x;
    }

    @Property(name="firstSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenDateTime() {
        return Optional.ofNullable(firstSeenDateTime);
    }

    public IpSecurityProfile withFirstSeenDateTime(OffsetDateTime firstSeenDateTime) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("firstSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.firstSeenDateTime = firstSeenDateTime;
        return _x;
    }

    @Property(name="ipCategories")
    @JsonIgnore
    public CollectionPage<IpCategory> getIpCategories() {
        return new CollectionPage<IpCategory>(contextPath, IpCategory.class, ipCategories, Optional.ofNullable(ipCategoriesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ipCategories")
    @JsonIgnore
    public CollectionPage<IpCategory> getIpCategories(HttpRequestOptions options) {
        return new CollectionPage<IpCategory>(contextPath, IpCategory.class, ipCategories, Optional.ofNullable(ipCategoriesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="ipReferenceData")
    @JsonIgnore
    public CollectionPage<IpReferenceData> getIpReferenceData() {
        return new CollectionPage<IpReferenceData>(contextPath, IpReferenceData.class, ipReferenceData, Optional.ofNullable(ipReferenceDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ipReferenceData")
    @JsonIgnore
    public CollectionPage<IpReferenceData> getIpReferenceData(HttpRequestOptions options) {
        return new CollectionPage<IpReferenceData>(contextPath, IpReferenceData.class, ipReferenceData, Optional.ofNullable(ipReferenceDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public IpSecurityProfile withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("lastSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public IpSecurityProfile withRiskScore(String riskScore) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("riskScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public IpSecurityProfile withVendorInformation(SecurityVendorInformation vendorInformation) {
        IpSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipSecurityProfile");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IpSecurityProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IpSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IpSecurityProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IpSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IpSecurityProfile _copy() {
        IpSecurityProfile _x = new IpSecurityProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.activityGroupNames = activityGroupNames;
        _x.address = address;
        _x.azureSubscriptionId = azureSubscriptionId;
        _x.azureTenantId = azureTenantId;
        _x.countHits = countHits;
        _x.countHosts = countHosts;
        _x.firstSeenDateTime = firstSeenDateTime;
        _x.ipCategories = ipCategories;
        _x.ipReferenceData = ipReferenceData;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.riskScore = riskScore;
        _x.tags = tags;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IpSecurityProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activityGroupNames=");
        b.append(this.activityGroupNames);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("azureSubscriptionId=");
        b.append(this.azureSubscriptionId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("countHits=");
        b.append(this.countHits);
        b.append(", ");
        b.append("countHosts=");
        b.append(this.countHosts);
        b.append(", ");
        b.append("firstSeenDateTime=");
        b.append(this.firstSeenDateTime);
        b.append(", ");
        b.append("ipCategories=");
        b.append(this.ipCategories);
        b.append(", ");
        b.append("ipReferenceData=");
        b.append(this.ipReferenceData);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
