package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;


/**
 * <i>“A class containing the properties for iOS Vpp eBook.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "vppTokenId", 
    "appleId", 
    "vppOrganizationName", 
    "genres", 
    "language", 
    "seller", 
    "totalLicenseCount", 
    "usedLicenseCount", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class IosVppEBook extends ManagedEBook implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosVppEBook";
    }

    @JsonProperty("vppTokenId")
    protected String vppTokenId;

    @JsonProperty("appleId")
    protected String appleId;

    @JsonProperty("vppOrganizationName")
    protected String vppOrganizationName;

    @JsonProperty("genres")
    protected List<String> genres;

    @JsonProperty("genres@nextLink")
    protected String genresNextLink;

    @JsonProperty("language")
    protected String language;

    @JsonProperty("seller")
    protected String seller;

    @JsonProperty("totalLicenseCount")
    protected Integer totalLicenseCount;

    @JsonProperty("usedLicenseCount")
    protected Integer usedLicenseCount;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected IosVppEBook() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosVppEBook() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private OffsetDateTime publishedDateTime;
        private MimeContent largeCover;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String informationUrl;
        private String privacyInformationUrl;
        private String vppTokenId;
        private String appleId;
        private String vppOrganizationName;
        private List<String> genres;
        private String genresNextLink;
        private String language;
        private String seller;
        private Integer totalLicenseCount;
        private Integer usedLicenseCount;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishedDateTime(OffsetDateTime publishedDateTime) {
            this.publishedDateTime = publishedDateTime;
            this.changedFields = changedFields.add("publishedDateTime");
            return this;
        }

        public Builder largeCover(MimeContent largeCover) {
            this.largeCover = largeCover;
            this.changedFields = changedFields.add("largeCover");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        /**
         * <i>“The Vpp token ID.”</i>
         * 
         * @param vppTokenId
         *            value of {@code vppTokenId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenId(String vppTokenId) {
            this.vppTokenId = vppTokenId;
            this.changedFields = changedFields.add("vppTokenId");
            return this;
        }

        /**
         * <i>“The Apple ID associated with Vpp token.”</i>
         * 
         * @param appleId
         *            value of {@code appleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleId(String appleId) {
            this.appleId = appleId;
            this.changedFields = changedFields.add("appleId");
            return this;
        }

        /**
         * <i>“The Vpp token's organization name.”</i>
         * 
         * @param vppOrganizationName
         *            value of {@code vppOrganizationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppOrganizationName(String vppOrganizationName) {
            this.vppOrganizationName = vppOrganizationName;
            this.changedFields = changedFields.add("vppOrganizationName");
            return this;
        }

        /**
         * <i>“Genres.”</i>
         * 
         * @param genres
         *            value of {@code genres} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder genres(List<String> genres) {
            this.genres = genres;
            this.changedFields = changedFields.add("genres");
            return this;
        }

        /**
         * <i>“Genres.”</i>
         * 
         * @param genres
         *            value of {@code genres} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder genres(String... genres) {
            return genres(Arrays.asList(genres));
        }

        /**
         * <i>“Genres.”</i>
         * 
         * @param genresNextLink
         *            value of {@code genres@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder genresNextLink(String genresNextLink) {
            this.genresNextLink = genresNextLink;
            this.changedFields = changedFields.add("genres");
            return this;
        }

        /**
         * <i>“Language.”</i>
         * 
         * @param language
         *            value of {@code language} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        /**
         * <i>“Seller.”</i>
         * 
         * @param seller
         *            value of {@code seller} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder seller(String seller) {
            this.seller = seller;
            this.changedFields = changedFields.add("seller");
            return this;
        }

        /**
         * <i>“Total license count.”</i>
         * 
         * @param totalLicenseCount
         *            value of {@code totalLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        /**
         * <i>“Used license count.”</i>
         * 
         * @param usedLicenseCount
         *            value of {@code usedLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public IosVppEBook build() {
            IosVppEBook _x = new IosVppEBook();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosVppEBook";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.publishedDateTime = publishedDateTime;
            _x.largeCover = largeCover;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.informationUrl = informationUrl;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.vppTokenId = vppTokenId;
            _x.appleId = appleId;
            _x.vppOrganizationName = vppOrganizationName;
            _x.genres = genres;
            _x.genresNextLink = genresNextLink;
            _x.language = language;
            _x.seller = seller;
            _x.totalLicenseCount = totalLicenseCount;
            _x.usedLicenseCount = usedLicenseCount;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Vpp token ID.”</i>
     * 
     * @return property vppTokenId
     */
    @Property(name="vppTokenId")
    @JsonIgnore
    public Optional<String> getVppTokenId() {
        return Optional.ofNullable(vppTokenId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vppTokenId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Vpp token ID.”</i>
     * 
     * @param vppTokenId
     *            new value of {@code vppTokenId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenId} field changed
     */
    public IosVppEBook withVppTokenId(String vppTokenId) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("vppTokenId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.vppTokenId = vppTokenId;
        return _x;
    }

    /**
     * <i>“The Apple ID associated with Vpp token.”</i>
     * 
     * @return property appleId
     */
    @Property(name="appleId")
    @JsonIgnore
    public Optional<String> getAppleId() {
        return Optional.ofNullable(appleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Apple ID associated with Vpp token.”</i>
     * 
     * @param appleId
     *            new value of {@code appleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleId} field changed
     */
    public IosVppEBook withAppleId(String appleId) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("appleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.appleId = appleId;
        return _x;
    }

    /**
     * <i>“The Vpp token's organization name.”</i>
     * 
     * @return property vppOrganizationName
     */
    @Property(name="vppOrganizationName")
    @JsonIgnore
    public Optional<String> getVppOrganizationName() {
        return Optional.ofNullable(vppOrganizationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vppOrganizationName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Vpp token's organization name.”</i>
     * 
     * @param vppOrganizationName
     *            new value of {@code vppOrganizationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppOrganizationName} field changed
     */
    public IosVppEBook withVppOrganizationName(String vppOrganizationName) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("vppOrganizationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.vppOrganizationName = vppOrganizationName;
        return _x;
    }

    /**
     * <i>“Genres.”</i>
     * 
     * @return property genres
     */
    @Property(name="genres")
    @JsonIgnore
    public CollectionPage<String> getGenres() {
        return new CollectionPage<String>(contextPath, String.class, genres, Optional.ofNullable(genresNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Genres.”</i>
     * 
     * @return property genres
     */
    @Property(name="genres")
    @JsonIgnore
    public CollectionPage<String> getGenres(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, genres, Optional.ofNullable(genresNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Language.”</i>
     * 
     * @return property language
     */
    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(language);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code language} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Language.”</i>
     * 
     * @param language
     *            new value of {@code language} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code language} field changed
     */
    public IosVppEBook withLanguage(String language) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("language");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.language = language;
        return _x;
    }

    /**
     * <i>“Seller.”</i>
     * 
     * @return property seller
     */
    @Property(name="seller")
    @JsonIgnore
    public Optional<String> getSeller() {
        return Optional.ofNullable(seller);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code seller} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Seller.”</i>
     * 
     * @param seller
     *            new value of {@code seller} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code seller} field changed
     */
    public IosVppEBook withSeller(String seller) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("seller");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.seller = seller;
        return _x;
    }

    /**
     * <i>“Total license count.”</i>
     * 
     * @return property totalLicenseCount
     */
    @Property(name="totalLicenseCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicenseCount() {
        return Optional.ofNullable(totalLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalLicenseCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Total license count.”</i>
     * 
     * @param totalLicenseCount
     *            new value of {@code totalLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicenseCount} field changed
     */
    public IosVppEBook withTotalLicenseCount(Integer totalLicenseCount) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("totalLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.totalLicenseCount = totalLicenseCount;
        return _x;
    }

    /**
     * <i>“Used license count.”</i>
     * 
     * @return property usedLicenseCount
     */
    @Property(name="usedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getUsedLicenseCount() {
        return Optional.ofNullable(usedLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usedLicenseCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Used license count.”</i>
     * 
     * @param usedLicenseCount
     *            new value of {@code usedLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usedLicenseCount} field changed
     */
    public IosVppEBook withUsedLicenseCount(Integer usedLicenseCount) {
        IosVppEBook _x = _copy();
        _x.changedFields = changedFields.add("usedLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppEBook");
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppEBook patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosVppEBook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppEBook put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosVppEBook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosVppEBook _copy() {
        IosVppEBook _x = new IosVppEBook();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.publishedDateTime = publishedDateTime;
        _x.largeCover = largeCover;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.informationUrl = informationUrl;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.vppTokenId = vppTokenId;
        _x.appleId = appleId;
        _x.vppOrganizationName = vppOrganizationName;
        _x.genres = genres;
        _x.language = language;
        _x.seller = seller;
        _x.totalLicenseCount = totalLicenseCount;
        _x.usedLicenseCount = usedLicenseCount;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosVppEBook[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishedDateTime=");
        b.append(this.publishedDateTime);
        b.append(", ");
        b.append("largeCover=");
        b.append(this.largeCover);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("vppTokenId=");
        b.append(this.vppTokenId);
        b.append(", ");
        b.append("appleId=");
        b.append(this.appleId);
        b.append(", ");
        b.append("vppOrganizationName=");
        b.append(this.vppOrganizationName);
        b.append(", ");
        b.append("genres=");
        b.append(this.genres);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("seller=");
        b.append(this.seller);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
