package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“iOS Volume Purchase Program device license assignment. This class does not
 * support Create, Delete, or Update.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "managedDeviceId", 
    "deviceName"})
@JsonInclude(Include.NON_NULL)
public class IosVppAppAssignedDeviceLicense extends IosVppAppAssignedLicense implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosVppAppAssignedDeviceLicense";
    }

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("deviceName")
    protected String deviceName;

    protected IosVppAppAssignedDeviceLicense() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosVppAppAssignedDeviceLicense() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userEmailAddress;
        private String userId;
        private String userName;
        private String userPrincipalName;
        private String managedDeviceId;
        private String deviceName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder userEmailAddress(String userEmailAddress) {
            this.userEmailAddress = userEmailAddress;
            this.changedFields = changedFields.add("userEmailAddress");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“The managed device ID.”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“The device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public IosVppAppAssignedDeviceLicense build() {
            IosVppAppAssignedDeviceLicense _x = new IosVppAppAssignedDeviceLicense();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosVppAppAssignedDeviceLicense";
            _x.id = id;
            _x.userEmailAddress = userEmailAddress;
            _x.userId = userId;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            _x.managedDeviceId = managedDeviceId;
            _x.deviceName = deviceName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The managed device ID.”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The managed device ID.”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public IosVppAppAssignedDeviceLicense withManagedDeviceId(String managedDeviceId) {
        IosVppAppAssignedDeviceLicense _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppAssignedDeviceLicense");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“The device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public IosVppAppAssignedDeviceLicense withDeviceName(String deviceName) {
        IosVppAppAssignedDeviceLicense _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppAssignedDeviceLicense");
        _x.deviceName = deviceName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppAppAssignedDeviceLicense patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosVppAppAssignedDeviceLicense _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosVppAppAssignedDeviceLicense put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosVppAppAssignedDeviceLicense _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosVppAppAssignedDeviceLicense _copy() {
        IosVppAppAssignedDeviceLicense _x = new IosVppAppAssignedDeviceLicense();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userEmailAddress = userEmailAddress;
        _x.userId = userId;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        _x.managedDeviceId = managedDeviceId;
        _x.deviceName = deviceName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosVppAppAssignedDeviceLicense[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userEmailAddress=");
        b.append(this.userEmailAddress);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
