package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomUpdateTimeWindow;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.DayOfWeek;
import odata.msgraph.client.beta.enums.IosSoftwareUpdateScheduleType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“IOS Update Configuration, allows you to configure time window within week to
 * install iOS updates”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "isEnabled", 
    "activeHoursStart", 
    "activeHoursEnd", 
    "desiredOsVersion", 
    "scheduledInstallDays", 
    "utcTimeOffsetInMinutes", 
    "enforcedSoftwareUpdateDelayInDays", 
    "updateScheduleType", 
    "customUpdateTimeWindows"})
@JsonInclude(Include.NON_NULL)
public class IosUpdateConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosUpdateConfiguration";
    }

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("activeHoursStart")
    protected LocalTime activeHoursStart;

    @JsonProperty("activeHoursEnd")
    protected LocalTime activeHoursEnd;

    @JsonProperty("desiredOsVersion")
    protected String desiredOsVersion;

    @JsonProperty("scheduledInstallDays")
    protected List<DayOfWeek> scheduledInstallDays;

    @JsonProperty("scheduledInstallDays@nextLink")
    protected String scheduledInstallDaysNextLink;

    @JsonProperty("utcTimeOffsetInMinutes")
    protected Integer utcTimeOffsetInMinutes;

    @JsonProperty("enforcedSoftwareUpdateDelayInDays")
    protected Integer enforcedSoftwareUpdateDelayInDays;

    @JsonProperty("updateScheduleType")
    protected IosSoftwareUpdateScheduleType updateScheduleType;

    @JsonProperty("customUpdateTimeWindows")
    protected List<CustomUpdateTimeWindow> customUpdateTimeWindows;

    @JsonProperty("customUpdateTimeWindows@nextLink")
    protected String customUpdateTimeWindowsNextLink;

    protected IosUpdateConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosUpdateConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Boolean isEnabled;
        private LocalTime activeHoursStart;
        private LocalTime activeHoursEnd;
        private String desiredOsVersion;
        private List<DayOfWeek> scheduledInstallDays;
        private String scheduledInstallDaysNextLink;
        private Integer utcTimeOffsetInMinutes;
        private Integer enforcedSoftwareUpdateDelayInDays;
        private IosSoftwareUpdateScheduleType updateScheduleType;
        private List<CustomUpdateTimeWindow> customUpdateTimeWindows;
        private String customUpdateTimeWindowsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Is setting enabled in UI”</i>
         * 
         * @param isEnabled
         *            value of {@code isEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        /**
         * <i>“Active Hours Start (active hours mean the time window when updates install
         * should not happen)”</i>
         * 
         * @param activeHoursStart
         *            value of {@code activeHoursStart} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeHoursStart(LocalTime activeHoursStart) {
            this.activeHoursStart = activeHoursStart;
            this.changedFields = changedFields.add("activeHoursStart");
            return this;
        }

        /**
         * <i>“Active Hours End (active hours mean the time window when updates install should
         * not happen)”</i>
         * 
         * @param activeHoursEnd
         *            value of {@code activeHoursEnd} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeHoursEnd(LocalTime activeHoursEnd) {
            this.activeHoursEnd = activeHoursEnd;
            this.changedFields = changedFields.add("activeHoursEnd");
            return this;
        }

        /**
         * <i>“If left unspecified, devices will update to the latest version of the OS.”</i>
         * 
         * @param desiredOsVersion
         *            value of {@code desiredOsVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder desiredOsVersion(String desiredOsVersion) {
            this.desiredOsVersion = desiredOsVersion;
            this.changedFields = changedFields.add("desiredOsVersion");
            return this;
        }

        /**
         * <i>“Days in week for which active hours are configured. This collection can contain
         * a maximum of 7 elements.”</i>
         * 
         * @param scheduledInstallDays
         *            value of {@code scheduledInstallDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledInstallDays(List<DayOfWeek> scheduledInstallDays) {
            this.scheduledInstallDays = scheduledInstallDays;
            this.changedFields = changedFields.add("scheduledInstallDays");
            return this;
        }

        /**
         * <i>“Days in week for which active hours are configured. This collection can contain
         * a maximum of 7 elements.”</i>
         * 
         * @param scheduledInstallDays
         *            value of {@code scheduledInstallDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledInstallDays(DayOfWeek... scheduledInstallDays) {
            return scheduledInstallDays(Arrays.asList(scheduledInstallDays));
        }

        /**
         * <i>“Days in week for which active hours are configured. This collection can contain
         * a maximum of 7 elements.”</i>
         * 
         * @param scheduledInstallDaysNextLink
         *            value of {@code scheduledInstallDays@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledInstallDaysNextLink(String scheduledInstallDaysNextLink) {
            this.scheduledInstallDaysNextLink = scheduledInstallDaysNextLink;
            this.changedFields = changedFields.add("scheduledInstallDays");
            return this;
        }

        /**
         * <i>“UTC Time Offset indicated in minutes”</i>
         * 
         * @param utcTimeOffsetInMinutes
         *            value of {@code utcTimeOffsetInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder utcTimeOffsetInMinutes(Integer utcTimeOffsetInMinutes) {
            this.utcTimeOffsetInMinutes = utcTimeOffsetInMinutes;
            this.changedFields = changedFields.add("utcTimeOffsetInMinutes");
            return this;
        }

        /**
         * <i>“Days before software updates are visible to iOS devices ranging from 0 to 90
         * inclusive”</i>
         * 
         * @param enforcedSoftwareUpdateDelayInDays
         *            value of {@code enforcedSoftwareUpdateDelayInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enforcedSoftwareUpdateDelayInDays(Integer enforcedSoftwareUpdateDelayInDays) {
            this.enforcedSoftwareUpdateDelayInDays = enforcedSoftwareUpdateDelayInDays;
            this.changedFields = changedFields.add("enforcedSoftwareUpdateDelayInDays");
            return this;
        }

        /**
         * <i>“Update schedule type”</i>
         * 
         * @param updateScheduleType
         *            value of {@code updateScheduleType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateScheduleType(IosSoftwareUpdateScheduleType updateScheduleType) {
            this.updateScheduleType = updateScheduleType;
            this.changedFields = changedFields.add("updateScheduleType");
            return this;
        }

        /**
         * <i>“If update schedule type is set to use time window scheduling, custom time
         * windows when updates will be scheduled. This collection can contain a maximum of
         * 20 elements.”</i>
         * 
         * @param customUpdateTimeWindows
         *            value of {@code customUpdateTimeWindows} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customUpdateTimeWindows(List<CustomUpdateTimeWindow> customUpdateTimeWindows) {
            this.customUpdateTimeWindows = customUpdateTimeWindows;
            this.changedFields = changedFields.add("customUpdateTimeWindows");
            return this;
        }

        /**
         * <i>“If update schedule type is set to use time window scheduling, custom time
         * windows when updates will be scheduled. This collection can contain a maximum of
         * 20 elements.”</i>
         * 
         * @param customUpdateTimeWindows
         *            value of {@code customUpdateTimeWindows} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customUpdateTimeWindows(CustomUpdateTimeWindow... customUpdateTimeWindows) {
            return customUpdateTimeWindows(Arrays.asList(customUpdateTimeWindows));
        }

        /**
         * <i>“If update schedule type is set to use time window scheduling, custom time
         * windows when updates will be scheduled. This collection can contain a maximum of
         * 20 elements.”</i>
         * 
         * @param customUpdateTimeWindowsNextLink
         *            value of {@code customUpdateTimeWindows@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customUpdateTimeWindowsNextLink(String customUpdateTimeWindowsNextLink) {
            this.customUpdateTimeWindowsNextLink = customUpdateTimeWindowsNextLink;
            this.changedFields = changedFields.add("customUpdateTimeWindows");
            return this;
        }

        public IosUpdateConfiguration build() {
            IosUpdateConfiguration _x = new IosUpdateConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosUpdateConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.isEnabled = isEnabled;
            _x.activeHoursStart = activeHoursStart;
            _x.activeHoursEnd = activeHoursEnd;
            _x.desiredOsVersion = desiredOsVersion;
            _x.scheduledInstallDays = scheduledInstallDays;
            _x.scheduledInstallDaysNextLink = scheduledInstallDaysNextLink;
            _x.utcTimeOffsetInMinutes = utcTimeOffsetInMinutes;
            _x.enforcedSoftwareUpdateDelayInDays = enforcedSoftwareUpdateDelayInDays;
            _x.updateScheduleType = updateScheduleType;
            _x.customUpdateTimeWindows = customUpdateTimeWindows;
            _x.customUpdateTimeWindowsNextLink = customUpdateTimeWindowsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Is setting enabled in UI”</i>
     * 
     * @return property isEnabled
     */
    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isEnabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Is setting enabled in UI”</i>
     * 
     * @param isEnabled
     *            new value of {@code isEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEnabled} field changed
     */
    public IosUpdateConfiguration withIsEnabled(Boolean isEnabled) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.isEnabled = isEnabled;
        return _x;
    }

    /**
     * <i>“Active Hours Start (active hours mean the time window when updates install
     * should not happen)”</i>
     * 
     * @return property activeHoursStart
     */
    @Property(name="activeHoursStart")
    @JsonIgnore
    public Optional<LocalTime> getActiveHoursStart() {
        return Optional.ofNullable(activeHoursStart);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeHoursStart}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Active Hours Start (active hours mean the time window when updates install
     * should not happen)”</i>
     * 
     * @param activeHoursStart
     *            new value of {@code activeHoursStart} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeHoursStart} field changed
     */
    public IosUpdateConfiguration withActiveHoursStart(LocalTime activeHoursStart) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("activeHoursStart");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.activeHoursStart = activeHoursStart;
        return _x;
    }

    /**
     * <i>“Active Hours End (active hours mean the time window when updates install should
     * not happen)”</i>
     * 
     * @return property activeHoursEnd
     */
    @Property(name="activeHoursEnd")
    @JsonIgnore
    public Optional<LocalTime> getActiveHoursEnd() {
        return Optional.ofNullable(activeHoursEnd);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activeHoursEnd}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Active Hours End (active hours mean the time window when updates install should
     * not happen)”</i>
     * 
     * @param activeHoursEnd
     *            new value of {@code activeHoursEnd} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeHoursEnd} field changed
     */
    public IosUpdateConfiguration withActiveHoursEnd(LocalTime activeHoursEnd) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("activeHoursEnd");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.activeHoursEnd = activeHoursEnd;
        return _x;
    }

    /**
     * <i>“If left unspecified, devices will update to the latest version of the OS.”</i>
     * 
     * @return property desiredOsVersion
     */
    @Property(name="desiredOsVersion")
    @JsonIgnore
    public Optional<String> getDesiredOsVersion() {
        return Optional.ofNullable(desiredOsVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code desiredOsVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If left unspecified, devices will update to the latest version of the OS.”</i>
     * 
     * @param desiredOsVersion
     *            new value of {@code desiredOsVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code desiredOsVersion} field changed
     */
    public IosUpdateConfiguration withDesiredOsVersion(String desiredOsVersion) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("desiredOsVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.desiredOsVersion = desiredOsVersion;
        return _x;
    }

    /**
     * <i>“Days in week for which active hours are configured. This collection can contain
     * a maximum of 7 elements.”</i>
     * 
     * @return property scheduledInstallDays
     */
    @Property(name="scheduledInstallDays")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getScheduledInstallDays() {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, scheduledInstallDays, Optional.ofNullable(scheduledInstallDaysNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Days in week for which active hours are configured. This collection can contain
     * a maximum of 7 elements.”</i>
     * 
     * @return property scheduledInstallDays
     */
    @Property(name="scheduledInstallDays")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getScheduledInstallDays(HttpRequestOptions options) {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, scheduledInstallDays, Optional.ofNullable(scheduledInstallDaysNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“UTC Time Offset indicated in minutes”</i>
     * 
     * @return property utcTimeOffsetInMinutes
     */
    @Property(name="utcTimeOffsetInMinutes")
    @JsonIgnore
    public Optional<Integer> getUtcTimeOffsetInMinutes() {
        return Optional.ofNullable(utcTimeOffsetInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * utcTimeOffsetInMinutes} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“UTC Time Offset indicated in minutes”</i>
     * 
     * @param utcTimeOffsetInMinutes
     *            new value of {@code utcTimeOffsetInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code utcTimeOffsetInMinutes} field changed
     */
    public IosUpdateConfiguration withUtcTimeOffsetInMinutes(Integer utcTimeOffsetInMinutes) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("utcTimeOffsetInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.utcTimeOffsetInMinutes = utcTimeOffsetInMinutes;
        return _x;
    }

    /**
     * <i>“Days before software updates are visible to iOS devices ranging from 0 to 90
     * inclusive”</i>
     * 
     * @return property enforcedSoftwareUpdateDelayInDays
     */
    @Property(name="enforcedSoftwareUpdateDelayInDays")
    @JsonIgnore
    public Optional<Integer> getEnforcedSoftwareUpdateDelayInDays() {
        return Optional.ofNullable(enforcedSoftwareUpdateDelayInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enforcedSoftwareUpdateDelayInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Days before software updates are visible to iOS devices ranging from 0 to 90
     * inclusive”</i>
     * 
     * @param enforcedSoftwareUpdateDelayInDays
     *            new value of {@code enforcedSoftwareUpdateDelayInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enforcedSoftwareUpdateDelayInDays} field changed
     */
    public IosUpdateConfiguration withEnforcedSoftwareUpdateDelayInDays(Integer enforcedSoftwareUpdateDelayInDays) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enforcedSoftwareUpdateDelayInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.enforcedSoftwareUpdateDelayInDays = enforcedSoftwareUpdateDelayInDays;
        return _x;
    }

    /**
     * <i>“Update schedule type”</i>
     * 
     * @return property updateScheduleType
     */
    @Property(name="updateScheduleType")
    @JsonIgnore
    public Optional<IosSoftwareUpdateScheduleType> getUpdateScheduleType() {
        return Optional.ofNullable(updateScheduleType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * updateScheduleType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Update schedule type”</i>
     * 
     * @param updateScheduleType
     *            new value of {@code updateScheduleType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateScheduleType} field changed
     */
    public IosUpdateConfiguration withUpdateScheduleType(IosSoftwareUpdateScheduleType updateScheduleType) {
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = changedFields.add("updateScheduleType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosUpdateConfiguration");
        _x.updateScheduleType = updateScheduleType;
        return _x;
    }

    /**
     * <i>“If update schedule type is set to use time window scheduling, custom time
     * windows when updates will be scheduled. This collection can contain a maximum of
     * 20 elements.”</i>
     * 
     * @return property customUpdateTimeWindows
     */
    @Property(name="customUpdateTimeWindows")
    @JsonIgnore
    public CollectionPage<CustomUpdateTimeWindow> getCustomUpdateTimeWindows() {
        return new CollectionPage<CustomUpdateTimeWindow>(contextPath, CustomUpdateTimeWindow.class, customUpdateTimeWindows, Optional.ofNullable(customUpdateTimeWindowsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“If update schedule type is set to use time window scheduling, custom time
     * windows when updates will be scheduled. This collection can contain a maximum of
     * 20 elements.”</i>
     * 
     * @return property customUpdateTimeWindows
     */
    @Property(name="customUpdateTimeWindows")
    @JsonIgnore
    public CollectionPage<CustomUpdateTimeWindow> getCustomUpdateTimeWindows(HttpRequestOptions options) {
        return new CollectionPage<CustomUpdateTimeWindow>(contextPath, CustomUpdateTimeWindow.class, customUpdateTimeWindows, Optional.ofNullable(customUpdateTimeWindowsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosUpdateConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosUpdateConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosUpdateConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosUpdateConfiguration _copy() {
        IosUpdateConfiguration _x = new IosUpdateConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.isEnabled = isEnabled;
        _x.activeHoursStart = activeHoursStart;
        _x.activeHoursEnd = activeHoursEnd;
        _x.desiredOsVersion = desiredOsVersion;
        _x.scheduledInstallDays = scheduledInstallDays;
        _x.utcTimeOffsetInMinutes = utcTimeOffsetInMinutes;
        _x.enforcedSoftwareUpdateDelayInDays = enforcedSoftwareUpdateDelayInDays;
        _x.updateScheduleType = updateScheduleType;
        _x.customUpdateTimeWindows = customUpdateTimeWindows;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosUpdateConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("activeHoursStart=");
        b.append(this.activeHoursStart);
        b.append(", ");
        b.append("activeHoursEnd=");
        b.append(this.activeHoursEnd);
        b.append(", ");
        b.append("desiredOsVersion=");
        b.append(this.desiredOsVersion);
        b.append(", ");
        b.append("scheduledInstallDays=");
        b.append(this.scheduledInstallDays);
        b.append(", ");
        b.append("utcTimeOffsetInMinutes=");
        b.append(this.utcTimeOffsetInMinutes);
        b.append(", ");
        b.append("enforcedSoftwareUpdateDelayInDays=");
        b.append(this.enforcedSoftwareUpdateDelayInDays);
        b.append(", ");
        b.append("updateScheduleType=");
        b.append(this.updateScheduleType);
        b.append(", ");
        b.append("customUpdateTimeWindows=");
        b.append(this.customUpdateTimeWindows);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
