package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.MobileAppIdentifier;
import odata.msgraph.client.beta.enums.ManagedAppFlaggedReason;


/**
 * <i>“The ManagedAppRegistration resource represents the details of an app, with
 * management capability, used by a member of the organization.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class IosManagedAppRegistration extends ManagedAppRegistration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosManagedAppRegistration";
    }

    protected IosManagedAppRegistration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosManagedAppRegistration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastSyncDateTime;
        private String applicationVersion;
        private String managementSdkVersion;
        private String platformVersion;
        private String deviceType;
        private String deviceTag;
        private String deviceName;
        private String managedDeviceId;
        private String azureADDeviceId;
        private String deviceModel;
        private String deviceManufacturer;
        private List<ManagedAppFlaggedReason> flaggedReasons;
        private String flaggedReasonsNextLink;
        private String userId;
        private MobileAppIdentifier appIdentifier;
        private String version;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        public Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            this.changedFields = changedFields.add("applicationVersion");
            return this;
        }

        public Builder managementSdkVersion(String managementSdkVersion) {
            this.managementSdkVersion = managementSdkVersion;
            this.changedFields = changedFields.add("managementSdkVersion");
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            this.changedFields = changedFields.add("platformVersion");
            return this;
        }

        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        public Builder deviceTag(String deviceTag) {
            this.deviceTag = deviceTag;
            this.changedFields = changedFields.add("deviceTag");
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder azureADDeviceId(String azureADDeviceId) {
            this.azureADDeviceId = azureADDeviceId;
            this.changedFields = changedFields.add("azureADDeviceId");
            return this;
        }

        public Builder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            this.changedFields = changedFields.add("deviceModel");
            return this;
        }

        public Builder deviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
            this.changedFields = changedFields.add("deviceManufacturer");
            return this;
        }

        public Builder flaggedReasons(List<ManagedAppFlaggedReason> flaggedReasons) {
            this.flaggedReasons = flaggedReasons;
            this.changedFields = changedFields.add("flaggedReasons");
            return this;
        }

        public Builder flaggedReasons(ManagedAppFlaggedReason... flaggedReasons) {
            return flaggedReasons(Arrays.asList(flaggedReasons));
        }

        public Builder flaggedReasonsNextLink(String flaggedReasonsNextLink) {
            this.flaggedReasonsNextLink = flaggedReasonsNextLink;
            this.changedFields = changedFields.add("flaggedReasons");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder appIdentifier(MobileAppIdentifier appIdentifier) {
            this.appIdentifier = appIdentifier;
            this.changedFields = changedFields.add("appIdentifier");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public IosManagedAppRegistration build() {
            IosManagedAppRegistration _x = new IosManagedAppRegistration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosManagedAppRegistration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.applicationVersion = applicationVersion;
            _x.managementSdkVersion = managementSdkVersion;
            _x.platformVersion = platformVersion;
            _x.deviceType = deviceType;
            _x.deviceTag = deviceTag;
            _x.deviceName = deviceName;
            _x.managedDeviceId = managedDeviceId;
            _x.azureADDeviceId = azureADDeviceId;
            _x.deviceModel = deviceModel;
            _x.deviceManufacturer = deviceManufacturer;
            _x.flaggedReasons = flaggedReasons;
            _x.flaggedReasonsNextLink = flaggedReasonsNextLink;
            _x.userId = userId;
            _x.appIdentifier = appIdentifier;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosManagedAppRegistration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosManagedAppRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosManagedAppRegistration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosManagedAppRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosManagedAppRegistration _copy() {
        IosManagedAppRegistration _x = new IosManagedAppRegistration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.applicationVersion = applicationVersion;
        _x.managementSdkVersion = managementSdkVersion;
        _x.platformVersion = platformVersion;
        _x.deviceType = deviceType;
        _x.deviceTag = deviceTag;
        _x.deviceName = deviceName;
        _x.managedDeviceId = managedDeviceId;
        _x.azureADDeviceId = azureADDeviceId;
        _x.deviceModel = deviceModel;
        _x.deviceManufacturer = deviceManufacturer;
        _x.flaggedReasons = flaggedReasons;
        _x.userId = userId;
        _x.appIdentifier = appIdentifier;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosManagedAppRegistration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("applicationVersion=");
        b.append(this.applicationVersion);
        b.append(", ");
        b.append("managementSdkVersion=");
        b.append(this.managementSdkVersion);
        b.append(", ");
        b.append("platformVersion=");
        b.append(this.platformVersion);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("deviceTag=");
        b.append(this.deviceTag);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("azureADDeviceId=");
        b.append(this.azureADDeviceId);
        b.append(", ");
        b.append("deviceModel=");
        b.append(this.deviceModel);
        b.append(", ");
        b.append("deviceManufacturer=");
        b.append(this.deviceManufacturer);
        b.append(", ");
        b.append("flaggedReasons=");
        b.append(this.flaggedReasons);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("appIdentifier=");
        b.append(this.appIdentifier);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
