package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyDeploymentSummaryRequest;
import odata.msgraph.client.beta.enums.AppManagementLevel;
import odata.msgraph.client.beta.enums.ManagedAppClipboardSharingLevel;
import odata.msgraph.client.beta.enums.ManagedAppDataEncryptionType;
import odata.msgraph.client.beta.enums.ManagedAppDataIngestionLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataStorageLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataTransferLevel;
import odata.msgraph.client.beta.enums.ManagedAppDeviceThreatLevel;
import odata.msgraph.client.beta.enums.ManagedAppNotificationRestriction;
import odata.msgraph.client.beta.enums.ManagedAppPhoneNumberRedirectLevel;
import odata.msgraph.client.beta.enums.ManagedAppPinCharacterSet;
import odata.msgraph.client.beta.enums.ManagedAppRemediationAction;
import odata.msgraph.client.beta.enums.ManagedBrowserType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Policy used to configure detailed management settings targeted to specific
 * security groups and for a specified set of apps on an iOS device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appDataEncryptionType", 
    "minimumRequiredSdkVersion", 
    "deployedAppCount", 
    "faceIdBlocked", 
    "exemptedAppProtocols", 
    "minimumWipeSdkVersion", 
    "allowedIosDeviceModels", 
    "appActionIfIosDeviceModelNotAllowed", 
    "thirdPartyKeyboardsBlocked", 
    "filterOpenInToOnlyManagedApps", 
    "disableProtectionOfManagedOutboundOpenInData", 
    "protectInboundDataFromUnknownSources", 
    "customBrowserProtocol", 
    "customDialerAppProtocol"})
@JsonInclude(Include.NON_NULL)
public class IosManagedAppProtection extends TargetedManagedAppProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosManagedAppProtection";
    }

    @JsonProperty("appDataEncryptionType")
    protected ManagedAppDataEncryptionType appDataEncryptionType;

    @JsonProperty("minimumRequiredSdkVersion")
    protected String minimumRequiredSdkVersion;

    @JsonProperty("deployedAppCount")
    protected Integer deployedAppCount;

    @JsonProperty("faceIdBlocked")
    protected Boolean faceIdBlocked;

    @JsonProperty("exemptedAppProtocols")
    protected List<KeyValuePair> exemptedAppProtocols;

    @JsonProperty("exemptedAppProtocols@nextLink")
    protected String exemptedAppProtocolsNextLink;

    @JsonProperty("minimumWipeSdkVersion")
    protected String minimumWipeSdkVersion;

    @JsonProperty("allowedIosDeviceModels")
    protected String allowedIosDeviceModels;

    @JsonProperty("appActionIfIosDeviceModelNotAllowed")
    protected ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed;

    @JsonProperty("thirdPartyKeyboardsBlocked")
    protected Boolean thirdPartyKeyboardsBlocked;

    @JsonProperty("filterOpenInToOnlyManagedApps")
    protected Boolean filterOpenInToOnlyManagedApps;

    @JsonProperty("disableProtectionOfManagedOutboundOpenInData")
    protected Boolean disableProtectionOfManagedOutboundOpenInData;

    @JsonProperty("protectInboundDataFromUnknownSources")
    protected Boolean protectInboundDataFromUnknownSources;

    @JsonProperty("customBrowserProtocol")
    protected String customBrowserProtocol;

    @JsonProperty("customDialerAppProtocol")
    protected String customDialerAppProtocol;

    protected IosManagedAppProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosManagedAppProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private Duration periodOfflineBeforeAccessCheck;
        private Duration periodOnlineBeforeAccessCheck;
        private ManagedAppDataTransferLevel allowedInboundDataTransferSources;
        private ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations;
        private Boolean organizationalCredentialsRequired;
        private ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel;
        private Boolean dataBackupBlocked;
        private Boolean deviceComplianceRequired;
        private Boolean managedBrowserToOpenLinksRequired;
        private Boolean saveAsBlocked;
        private Duration periodOfflineBeforeWipeIsEnforced;
        private Boolean pinRequired;
        private Integer maximumPinRetries;
        private Boolean simplePinBlocked;
        private Integer minimumPinLength;
        private ManagedAppPinCharacterSet pinCharacterSet;
        private Duration periodBeforePinReset;
        private List<ManagedAppDataStorageLocation> allowedDataStorageLocations;
        private String allowedDataStorageLocationsNextLink;
        private Boolean contactSyncBlocked;
        private Boolean printBlocked;
        private Boolean fingerprintBlocked;
        private Boolean disableAppPinIfDevicePinIsSet;
        private String minimumRequiredOsVersion;
        private String minimumWarningOsVersion;
        private String minimumRequiredAppVersion;
        private String minimumWarningAppVersion;
        private String minimumWipeOsVersion;
        private String minimumWipeAppVersion;
        private ManagedAppRemediationAction appActionIfDeviceComplianceRequired;
        private ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded;
        private Duration pinRequiredInsteadOfBiometricTimeout;
        private Integer allowedOutboundClipboardSharingExceptionLength;
        private ManagedAppNotificationRestriction notificationRestriction;
        private Integer previousPinBlockCount;
        private ManagedBrowserType managedBrowser;
        private ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel;
        private ManagedAppRemediationAction mobileThreatDefenseRemediationAction;
        private Boolean blockDataIngestionIntoOrganizationDocuments;
        private List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations;
        private String allowedDataIngestionLocationsNextLink;
        private ManagedAppRemediationAction appActionIfUnableToAuthenticateUser;
        private ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel;
        private Boolean isAssigned;
        private AppManagementLevel targetedAppManagementLevels;
        private ManagedAppDataEncryptionType appDataEncryptionType;
        private String minimumRequiredSdkVersion;
        private Integer deployedAppCount;
        private Boolean faceIdBlocked;
        private List<KeyValuePair> exemptedAppProtocols;
        private String exemptedAppProtocolsNextLink;
        private String minimumWipeSdkVersion;
        private String allowedIosDeviceModels;
        private ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed;
        private Boolean thirdPartyKeyboardsBlocked;
        private Boolean filterOpenInToOnlyManagedApps;
        private Boolean disableProtectionOfManagedOutboundOpenInData;
        private Boolean protectInboundDataFromUnknownSources;
        private String customBrowserProtocol;
        private String customDialerAppProtocol;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder periodOfflineBeforeAccessCheck(Duration periodOfflineBeforeAccessCheck) {
            this.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOfflineBeforeAccessCheck");
            return this;
        }

        public Builder periodOnlineBeforeAccessCheck(Duration periodOnlineBeforeAccessCheck) {
            this.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOnlineBeforeAccessCheck");
            return this;
        }

        public Builder allowedInboundDataTransferSources(ManagedAppDataTransferLevel allowedInboundDataTransferSources) {
            this.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            this.changedFields = changedFields.add("allowedInboundDataTransferSources");
            return this;
        }

        public Builder allowedOutboundDataTransferDestinations(ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations) {
            this.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            this.changedFields = changedFields.add("allowedOutboundDataTransferDestinations");
            return this;
        }

        public Builder organizationalCredentialsRequired(Boolean organizationalCredentialsRequired) {
            this.organizationalCredentialsRequired = organizationalCredentialsRequired;
            this.changedFields = changedFields.add("organizationalCredentialsRequired");
            return this;
        }

        public Builder allowedOutboundClipboardSharingLevel(ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel) {
            this.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingLevel");
            return this;
        }

        public Builder dataBackupBlocked(Boolean dataBackupBlocked) {
            this.dataBackupBlocked = dataBackupBlocked;
            this.changedFields = changedFields.add("dataBackupBlocked");
            return this;
        }

        public Builder deviceComplianceRequired(Boolean deviceComplianceRequired) {
            this.deviceComplianceRequired = deviceComplianceRequired;
            this.changedFields = changedFields.add("deviceComplianceRequired");
            return this;
        }

        public Builder managedBrowserToOpenLinksRequired(Boolean managedBrowserToOpenLinksRequired) {
            this.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            this.changedFields = changedFields.add("managedBrowserToOpenLinksRequired");
            return this;
        }

        public Builder saveAsBlocked(Boolean saveAsBlocked) {
            this.saveAsBlocked = saveAsBlocked;
            this.changedFields = changedFields.add("saveAsBlocked");
            return this;
        }

        public Builder periodOfflineBeforeWipeIsEnforced(Duration periodOfflineBeforeWipeIsEnforced) {
            this.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            this.changedFields = changedFields.add("periodOfflineBeforeWipeIsEnforced");
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = pinRequired;
            this.changedFields = changedFields.add("pinRequired");
            return this;
        }

        public Builder maximumPinRetries(Integer maximumPinRetries) {
            this.maximumPinRetries = maximumPinRetries;
            this.changedFields = changedFields.add("maximumPinRetries");
            return this;
        }

        public Builder simplePinBlocked(Boolean simplePinBlocked) {
            this.simplePinBlocked = simplePinBlocked;
            this.changedFields = changedFields.add("simplePinBlocked");
            return this;
        }

        public Builder minimumPinLength(Integer minimumPinLength) {
            this.minimumPinLength = minimumPinLength;
            this.changedFields = changedFields.add("minimumPinLength");
            return this;
        }

        public Builder pinCharacterSet(ManagedAppPinCharacterSet pinCharacterSet) {
            this.pinCharacterSet = pinCharacterSet;
            this.changedFields = changedFields.add("pinCharacterSet");
            return this;
        }

        public Builder periodBeforePinReset(Duration periodBeforePinReset) {
            this.periodBeforePinReset = periodBeforePinReset;
            this.changedFields = changedFields.add("periodBeforePinReset");
            return this;
        }

        public Builder allowedDataStorageLocations(List<ManagedAppDataStorageLocation> allowedDataStorageLocations) {
            this.allowedDataStorageLocations = allowedDataStorageLocations;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder allowedDataStorageLocations(ManagedAppDataStorageLocation... allowedDataStorageLocations) {
            return allowedDataStorageLocations(Arrays.asList(allowedDataStorageLocations));
        }

        public Builder allowedDataStorageLocationsNextLink(String allowedDataStorageLocationsNextLink) {
            this.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder contactSyncBlocked(Boolean contactSyncBlocked) {
            this.contactSyncBlocked = contactSyncBlocked;
            this.changedFields = changedFields.add("contactSyncBlocked");
            return this;
        }

        public Builder printBlocked(Boolean printBlocked) {
            this.printBlocked = printBlocked;
            this.changedFields = changedFields.add("printBlocked");
            return this;
        }

        public Builder fingerprintBlocked(Boolean fingerprintBlocked) {
            this.fingerprintBlocked = fingerprintBlocked;
            this.changedFields = changedFields.add("fingerprintBlocked");
            return this;
        }

        public Builder disableAppPinIfDevicePinIsSet(Boolean disableAppPinIfDevicePinIsSet) {
            this.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            this.changedFields = changedFields.add("disableAppPinIfDevicePinIsSet");
            return this;
        }

        public Builder minimumRequiredOsVersion(String minimumRequiredOsVersion) {
            this.minimumRequiredOsVersion = minimumRequiredOsVersion;
            this.changedFields = changedFields.add("minimumRequiredOsVersion");
            return this;
        }

        public Builder minimumWarningOsVersion(String minimumWarningOsVersion) {
            this.minimumWarningOsVersion = minimumWarningOsVersion;
            this.changedFields = changedFields.add("minimumWarningOsVersion");
            return this;
        }

        public Builder minimumRequiredAppVersion(String minimumRequiredAppVersion) {
            this.minimumRequiredAppVersion = minimumRequiredAppVersion;
            this.changedFields = changedFields.add("minimumRequiredAppVersion");
            return this;
        }

        public Builder minimumWarningAppVersion(String minimumWarningAppVersion) {
            this.minimumWarningAppVersion = minimumWarningAppVersion;
            this.changedFields = changedFields.add("minimumWarningAppVersion");
            return this;
        }

        public Builder minimumWipeOsVersion(String minimumWipeOsVersion) {
            this.minimumWipeOsVersion = minimumWipeOsVersion;
            this.changedFields = changedFields.add("minimumWipeOsVersion");
            return this;
        }

        public Builder minimumWipeAppVersion(String minimumWipeAppVersion) {
            this.minimumWipeAppVersion = minimumWipeAppVersion;
            this.changedFields = changedFields.add("minimumWipeAppVersion");
            return this;
        }

        public Builder appActionIfDeviceComplianceRequired(ManagedAppRemediationAction appActionIfDeviceComplianceRequired) {
            this.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            this.changedFields = changedFields.add("appActionIfDeviceComplianceRequired");
            return this;
        }

        public Builder appActionIfMaximumPinRetriesExceeded(ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded) {
            this.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            this.changedFields = changedFields.add("appActionIfMaximumPinRetriesExceeded");
            return this;
        }

        public Builder pinRequiredInsteadOfBiometricTimeout(Duration pinRequiredInsteadOfBiometricTimeout) {
            this.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            this.changedFields = changedFields.add("pinRequiredInsteadOfBiometricTimeout");
            return this;
        }

        public Builder allowedOutboundClipboardSharingExceptionLength(Integer allowedOutboundClipboardSharingExceptionLength) {
            this.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingExceptionLength");
            return this;
        }

        public Builder notificationRestriction(ManagedAppNotificationRestriction notificationRestriction) {
            this.notificationRestriction = notificationRestriction;
            this.changedFields = changedFields.add("notificationRestriction");
            return this;
        }

        public Builder previousPinBlockCount(Integer previousPinBlockCount) {
            this.previousPinBlockCount = previousPinBlockCount;
            this.changedFields = changedFields.add("previousPinBlockCount");
            return this;
        }

        public Builder managedBrowser(ManagedBrowserType managedBrowser) {
            this.managedBrowser = managedBrowser;
            this.changedFields = changedFields.add("managedBrowser");
            return this;
        }

        public Builder maximumAllowedDeviceThreatLevel(ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel) {
            this.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            this.changedFields = changedFields.add("maximumAllowedDeviceThreatLevel");
            return this;
        }

        public Builder mobileThreatDefenseRemediationAction(ManagedAppRemediationAction mobileThreatDefenseRemediationAction) {
            this.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            this.changedFields = changedFields.add("mobileThreatDefenseRemediationAction");
            return this;
        }

        public Builder blockDataIngestionIntoOrganizationDocuments(Boolean blockDataIngestionIntoOrganizationDocuments) {
            this.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            this.changedFields = changedFields.add("blockDataIngestionIntoOrganizationDocuments");
            return this;
        }

        public Builder allowedDataIngestionLocations(List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations) {
            this.allowedDataIngestionLocations = allowedDataIngestionLocations;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder allowedDataIngestionLocations(ManagedAppDataIngestionLocation... allowedDataIngestionLocations) {
            return allowedDataIngestionLocations(Arrays.asList(allowedDataIngestionLocations));
        }

        public Builder allowedDataIngestionLocationsNextLink(String allowedDataIngestionLocationsNextLink) {
            this.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder appActionIfUnableToAuthenticateUser(ManagedAppRemediationAction appActionIfUnableToAuthenticateUser) {
            this.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            this.changedFields = changedFields.add("appActionIfUnableToAuthenticateUser");
            return this;
        }

        public Builder dialerRestrictionLevel(ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel) {
            this.dialerRestrictionLevel = dialerRestrictionLevel;
            this.changedFields = changedFields.add("dialerRestrictionLevel");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder targetedAppManagementLevels(AppManagementLevel targetedAppManagementLevels) {
            this.targetedAppManagementLevels = targetedAppManagementLevels;
            this.changedFields = changedFields.add("targetedAppManagementLevels");
            return this;
        }

        /**
         * <i>“Type of encryption which should be used for data in a managed app.”</i>
         * 
         * @param appDataEncryptionType
         *            value of {@code appDataEncryptionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDataEncryptionType(ManagedAppDataEncryptionType appDataEncryptionType) {
            this.appDataEncryptionType = appDataEncryptionType;
            this.changedFields = changedFields.add("appDataEncryptionType");
            return this;
        }

        /**
         * <i>“Versions less than the specified version will block the managed app from
         * accessing company data.”</i>
         * 
         * @param minimumRequiredSdkVersion
         *            value of {@code minimumRequiredSdkVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredSdkVersion(String minimumRequiredSdkVersion) {
            this.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
            this.changedFields = changedFields.add("minimumRequiredSdkVersion");
            return this;
        }

        /**
         * <i>“Count of apps to which the current policy is deployed.”</i>
         * 
         * @param deployedAppCount
         *            value of {@code deployedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployedAppCount(Integer deployedAppCount) {
            this.deployedAppCount = deployedAppCount;
            this.changedFields = changedFields.add("deployedAppCount");
            return this;
        }

        /**
         * <i>“Indicates whether use of the FaceID is allowed in place of a pin if PinRequired
         * is set to True.”</i>
         * 
         * @param faceIdBlocked
         *            value of {@code faceIdBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder faceIdBlocked(Boolean faceIdBlocked) {
            this.faceIdBlocked = faceIdBlocked;
            this.changedFields = changedFields.add("faceIdBlocked");
            return this;
        }

        /**
         * <i>“Apps in this list will be exempt from the policy and will be able to receive
         * data from managed apps.”</i>
         * 
         * @param exemptedAppProtocols
         *            value of {@code exemptedAppProtocols} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppProtocols(List<KeyValuePair> exemptedAppProtocols) {
            this.exemptedAppProtocols = exemptedAppProtocols;
            this.changedFields = changedFields.add("exemptedAppProtocols");
            return this;
        }

        /**
         * <i>“Apps in this list will be exempt from the policy and will be able to receive
         * data from managed apps.”</i>
         * 
         * @param exemptedAppProtocols
         *            value of {@code exemptedAppProtocols} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppProtocols(KeyValuePair... exemptedAppProtocols) {
            return exemptedAppProtocols(Arrays.asList(exemptedAppProtocols));
        }

        /**
         * <i>“Apps in this list will be exempt from the policy and will be able to receive
         * data from managed apps.”</i>
         * 
         * @param exemptedAppProtocolsNextLink
         *            value of {@code exemptedAppProtocols@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppProtocolsNextLink(String exemptedAppProtocolsNextLink) {
            this.exemptedAppProtocolsNextLink = exemptedAppProtocolsNextLink;
            this.changedFields = changedFields.add("exemptedAppProtocols");
            return this;
        }

        /**
         * <i>“Versions less than the specified version will block the managed app from
         * accessing company data.”</i>
         * 
         * @param minimumWipeSdkVersion
         *            value of {@code minimumWipeSdkVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipeSdkVersion(String minimumWipeSdkVersion) {
            this.minimumWipeSdkVersion = minimumWipeSdkVersion;
            this.changedFields = changedFields.add("minimumWipeSdkVersion");
            return this;
        }

        /**
         * <i>“Semicolon seperated list of device models allowed, as a string, for the managed
         * app to work.”</i>
         * 
         * @param allowedIosDeviceModels
         *            value of {@code allowedIosDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedIosDeviceModels(String allowedIosDeviceModels) {
            this.allowedIosDeviceModels = allowedIosDeviceModels;
            this.changedFields = changedFields.add("allowedIosDeviceModels");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * model is not allowed.”</i>
         * 
         * @param appActionIfIosDeviceModelNotAllowed
         *            value of {@code appActionIfIosDeviceModelNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfIosDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed) {
            this.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
            this.changedFields = changedFields.add("appActionIfIosDeviceModelNotAllowed");
            return this;
        }

        /**
         * <i>“Defines if third party keyboards are allowed while accessing a managed app”</i>
         * 
         * @param thirdPartyKeyboardsBlocked
         *            value of {@code thirdPartyKeyboardsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder thirdPartyKeyboardsBlocked(Boolean thirdPartyKeyboardsBlocked) {
            this.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
            this.changedFields = changedFields.add("thirdPartyKeyboardsBlocked");
            return this;
        }

        /**
         * <i>“Defines if open-in operation is supported from the managed app to the
         * filesharing locations selected. This setting only applies when
         * AllowedOutboundDataTransferDestinations is set to ManagedApps and
         * DisableProtectionOfManagedOutboundOpenInData is set to False.”</i>
         * 
         * @param filterOpenInToOnlyManagedApps
         *            value of {@code filterOpenInToOnlyManagedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filterOpenInToOnlyManagedApps(Boolean filterOpenInToOnlyManagedApps) {
            this.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
            this.changedFields = changedFields.add("filterOpenInToOnlyManagedApps");
            return this;
        }

        /**
         * <i>“Disable protection of data transferred to other apps through IOS OpenIn option.
         * This setting is only allowed to be True when
         * AllowedOutboundDataTransferDestinations is set to ManagedApps.”</i>
         * 
         * @param disableProtectionOfManagedOutboundOpenInData
         *            value of {@code disableProtectionOfManagedOutboundOpenInData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableProtectionOfManagedOutboundOpenInData(Boolean disableProtectionOfManagedOutboundOpenInData) {
            this.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
            this.changedFields = changedFields.add("disableProtectionOfManagedOutboundOpenInData");
            return this;
        }

        /**
         * <i>“Protect incoming data from unknown source. This setting is only allowed to be
         * True when AllowedInboundDataTransferSources is set to AllApps.”</i>
         * 
         * @param protectInboundDataFromUnknownSources
         *            value of {@code protectInboundDataFromUnknownSources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder protectInboundDataFromUnknownSources(Boolean protectInboundDataFromUnknownSources) {
            this.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
            this.changedFields = changedFields.add("protectInboundDataFromUnknownSources");
            return this;
        }

        /**
         * <i>“A custom browser protocol to open weblink on iOS. When this property is
         * configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
         * 
         * @param customBrowserProtocol
         *            value of {@code customBrowserProtocol} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserProtocol(String customBrowserProtocol) {
            this.customBrowserProtocol = customBrowserProtocol;
            this.changedFields = changedFields.add("customBrowserProtocol");
            return this;
        }

        /**
         * <i>“Protocol of a custom dialer app to click-to-open a phone number on iOS, for
         * example, skype:.”</i>
         * 
         * @param customDialerAppProtocol
         *            value of {@code customDialerAppProtocol} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppProtocol(String customDialerAppProtocol) {
            this.customDialerAppProtocol = customDialerAppProtocol;
            this.changedFields = changedFields.add("customDialerAppProtocol");
            return this;
        }

        public IosManagedAppProtection build() {
            IosManagedAppProtection _x = new IosManagedAppProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosManagedAppProtection";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
            _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            _x.dataBackupBlocked = dataBackupBlocked;
            _x.deviceComplianceRequired = deviceComplianceRequired;
            _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            _x.saveAsBlocked = saveAsBlocked;
            _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            _x.pinRequired = pinRequired;
            _x.maximumPinRetries = maximumPinRetries;
            _x.simplePinBlocked = simplePinBlocked;
            _x.minimumPinLength = minimumPinLength;
            _x.pinCharacterSet = pinCharacterSet;
            _x.periodBeforePinReset = periodBeforePinReset;
            _x.allowedDataStorageLocations = allowedDataStorageLocations;
            _x.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            _x.contactSyncBlocked = contactSyncBlocked;
            _x.printBlocked = printBlocked;
            _x.fingerprintBlocked = fingerprintBlocked;
            _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
            _x.minimumWarningOsVersion = minimumWarningOsVersion;
            _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
            _x.minimumWarningAppVersion = minimumWarningAppVersion;
            _x.minimumWipeOsVersion = minimumWipeOsVersion;
            _x.minimumWipeAppVersion = minimumWipeAppVersion;
            _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            _x.notificationRestriction = notificationRestriction;
            _x.previousPinBlockCount = previousPinBlockCount;
            _x.managedBrowser = managedBrowser;
            _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
            _x.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            _x.dialerRestrictionLevel = dialerRestrictionLevel;
            _x.isAssigned = isAssigned;
            _x.targetedAppManagementLevels = targetedAppManagementLevels;
            _x.appDataEncryptionType = appDataEncryptionType;
            _x.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
            _x.deployedAppCount = deployedAppCount;
            _x.faceIdBlocked = faceIdBlocked;
            _x.exemptedAppProtocols = exemptedAppProtocols;
            _x.exemptedAppProtocolsNextLink = exemptedAppProtocolsNextLink;
            _x.minimumWipeSdkVersion = minimumWipeSdkVersion;
            _x.allowedIosDeviceModels = allowedIosDeviceModels;
            _x.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
            _x.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
            _x.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
            _x.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
            _x.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
            _x.customBrowserProtocol = customBrowserProtocol;
            _x.customDialerAppProtocol = customDialerAppProtocol;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Type of encryption which should be used for data in a managed app.”</i>
     * 
     * @return property appDataEncryptionType
     */
    @Property(name="appDataEncryptionType")
    @JsonIgnore
    public Optional<ManagedAppDataEncryptionType> getAppDataEncryptionType() {
        return Optional.ofNullable(appDataEncryptionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appDataEncryptionType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of encryption which should be used for data in a managed app.”</i>
     * 
     * @param appDataEncryptionType
     *            new value of {@code appDataEncryptionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDataEncryptionType} field changed
     */
    public IosManagedAppProtection withAppDataEncryptionType(ManagedAppDataEncryptionType appDataEncryptionType) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appDataEncryptionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.appDataEncryptionType = appDataEncryptionType;
        return _x;
    }

    /**
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data.”</i>
     * 
     * @return property minimumRequiredSdkVersion
     */
    @Property(name="minimumRequiredSdkVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredSdkVersion() {
        return Optional.ofNullable(minimumRequiredSdkVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredSdkVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data.”</i>
     * 
     * @param minimumRequiredSdkVersion
     *            new value of {@code minimumRequiredSdkVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredSdkVersion} field changed
     */
    public IosManagedAppProtection withMinimumRequiredSdkVersion(String minimumRequiredSdkVersion) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredSdkVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
        return _x;
    }

    /**
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @return property deployedAppCount
     */
    @Property(name="deployedAppCount")
    @JsonIgnore
    public Optional<Integer> getDeployedAppCount() {
        return Optional.ofNullable(deployedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deployedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @param deployedAppCount
     *            new value of {@code deployedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployedAppCount} field changed
     */
    public IosManagedAppProtection withDeployedAppCount(Integer deployedAppCount) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deployedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.deployedAppCount = deployedAppCount;
        return _x;
    }

    /**
     * <i>“Indicates whether use of the FaceID is allowed in place of a pin if PinRequired
     * is set to True.”</i>
     * 
     * @return property faceIdBlocked
     */
    @Property(name="faceIdBlocked")
    @JsonIgnore
    public Optional<Boolean> getFaceIdBlocked() {
        return Optional.ofNullable(faceIdBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code faceIdBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether use of the FaceID is allowed in place of a pin if PinRequired
     * is set to True.”</i>
     * 
     * @param faceIdBlocked
     *            new value of {@code faceIdBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code faceIdBlocked} field changed
     */
    public IosManagedAppProtection withFaceIdBlocked(Boolean faceIdBlocked) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("faceIdBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.faceIdBlocked = faceIdBlocked;
        return _x;
    }

    /**
     * <i>“Apps in this list will be exempt from the policy and will be able to receive
     * data from managed apps.”</i>
     * 
     * @return property exemptedAppProtocols
     */
    @Property(name="exemptedAppProtocols")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppProtocols() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, exemptedAppProtocols, Optional.ofNullable(exemptedAppProtocolsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Apps in this list will be exempt from the policy and will be able to receive
     * data from managed apps.”</i>
     * 
     * @return property exemptedAppProtocols
     */
    @Property(name="exemptedAppProtocols")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppProtocols(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, exemptedAppProtocols, Optional.ofNullable(exemptedAppProtocolsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data.”</i>
     * 
     * @return property minimumWipeSdkVersion
     */
    @Property(name="minimumWipeSdkVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipeSdkVersion() {
        return Optional.ofNullable(minimumWipeSdkVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipeSdkVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data.”</i>
     * 
     * @param minimumWipeSdkVersion
     *            new value of {@code minimumWipeSdkVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipeSdkVersion} field changed
     */
    public IosManagedAppProtection withMinimumWipeSdkVersion(String minimumWipeSdkVersion) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipeSdkVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.minimumWipeSdkVersion = minimumWipeSdkVersion;
        return _x;
    }

    /**
     * <i>“Semicolon seperated list of device models allowed, as a string, for the managed
     * app to work.”</i>
     * 
     * @return property allowedIosDeviceModels
     */
    @Property(name="allowedIosDeviceModels")
    @JsonIgnore
    public Optional<String> getAllowedIosDeviceModels() {
        return Optional.ofNullable(allowedIosDeviceModels);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedIosDeviceModels} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Semicolon seperated list of device models allowed, as a string, for the managed
     * app to work.”</i>
     * 
     * @param allowedIosDeviceModels
     *            new value of {@code allowedIosDeviceModels} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedIosDeviceModels} field changed
     */
    public IosManagedAppProtection withAllowedIosDeviceModels(String allowedIosDeviceModels) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedIosDeviceModels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.allowedIosDeviceModels = allowedIosDeviceModels;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed.”</i>
     * 
     * @return property appActionIfIosDeviceModelNotAllowed
     */
    @Property(name="appActionIfIosDeviceModelNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfIosDeviceModelNotAllowed() {
        return Optional.ofNullable(appActionIfIosDeviceModelNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfIosDeviceModelNotAllowed} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed.”</i>
     * 
     * @param appActionIfIosDeviceModelNotAllowed
     *            new value of {@code appActionIfIosDeviceModelNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfIosDeviceModelNotAllowed} field changed
     */
    public IosManagedAppProtection withAppActionIfIosDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfIosDeviceModelNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
        return _x;
    }

    /**
     * <i>“Defines if third party keyboards are allowed while accessing a managed app”</i>
     * 
     * @return property thirdPartyKeyboardsBlocked
     */
    @Property(name="thirdPartyKeyboardsBlocked")
    @JsonIgnore
    public Optional<Boolean> getThirdPartyKeyboardsBlocked() {
        return Optional.ofNullable(thirdPartyKeyboardsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * thirdPartyKeyboardsBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines if third party keyboards are allowed while accessing a managed app”</i>
     * 
     * @param thirdPartyKeyboardsBlocked
     *            new value of {@code thirdPartyKeyboardsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code thirdPartyKeyboardsBlocked} field changed
     */
    public IosManagedAppProtection withThirdPartyKeyboardsBlocked(Boolean thirdPartyKeyboardsBlocked) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("thirdPartyKeyboardsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
        return _x;
    }

    /**
     * <i>“Defines if open-in operation is supported from the managed app to the
     * filesharing locations selected. This setting only applies when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps and
     * DisableProtectionOfManagedOutboundOpenInData is set to False.”</i>
     * 
     * @return property filterOpenInToOnlyManagedApps
     */
    @Property(name="filterOpenInToOnlyManagedApps")
    @JsonIgnore
    public Optional<Boolean> getFilterOpenInToOnlyManagedApps() {
        return Optional.ofNullable(filterOpenInToOnlyManagedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * filterOpenInToOnlyManagedApps} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines if open-in operation is supported from the managed app to the
     * filesharing locations selected. This setting only applies when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps and
     * DisableProtectionOfManagedOutboundOpenInData is set to False.”</i>
     * 
     * @param filterOpenInToOnlyManagedApps
     *            new value of {@code filterOpenInToOnlyManagedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filterOpenInToOnlyManagedApps} field changed
     */
    public IosManagedAppProtection withFilterOpenInToOnlyManagedApps(Boolean filterOpenInToOnlyManagedApps) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("filterOpenInToOnlyManagedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
        return _x;
    }

    /**
     * <i>“Disable protection of data transferred to other apps through IOS OpenIn option.
     * This setting is only allowed to be True when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps.”</i>
     * 
     * @return property disableProtectionOfManagedOutboundOpenInData
     */
    @Property(name="disableProtectionOfManagedOutboundOpenInData")
    @JsonIgnore
    public Optional<Boolean> getDisableProtectionOfManagedOutboundOpenInData() {
        return Optional.ofNullable(disableProtectionOfManagedOutboundOpenInData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableProtectionOfManagedOutboundOpenInData} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Disable protection of data transferred to other apps through IOS OpenIn option.
     * This setting is only allowed to be True when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps.”</i>
     * 
     * @param disableProtectionOfManagedOutboundOpenInData
     *            new value of {@code disableProtectionOfManagedOutboundOpenInData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableProtectionOfManagedOutboundOpenInData} field changed
     */
    public IosManagedAppProtection withDisableProtectionOfManagedOutboundOpenInData(Boolean disableProtectionOfManagedOutboundOpenInData) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("disableProtectionOfManagedOutboundOpenInData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
        return _x;
    }

    /**
     * <i>“Protect incoming data from unknown source. This setting is only allowed to be
     * True when AllowedInboundDataTransferSources is set to AllApps.”</i>
     * 
     * @return property protectInboundDataFromUnknownSources
     */
    @Property(name="protectInboundDataFromUnknownSources")
    @JsonIgnore
    public Optional<Boolean> getProtectInboundDataFromUnknownSources() {
        return Optional.ofNullable(protectInboundDataFromUnknownSources);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * protectInboundDataFromUnknownSources} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Protect incoming data from unknown source. This setting is only allowed to be
     * True when AllowedInboundDataTransferSources is set to AllApps.”</i>
     * 
     * @param protectInboundDataFromUnknownSources
     *            new value of {@code protectInboundDataFromUnknownSources} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code protectInboundDataFromUnknownSources} field changed
     */
    public IosManagedAppProtection withProtectInboundDataFromUnknownSources(Boolean protectInboundDataFromUnknownSources) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("protectInboundDataFromUnknownSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
        return _x;
    }

    /**
     * <i>“A custom browser protocol to open weblink on iOS. When this property is
     * configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
     * 
     * @return property customBrowserProtocol
     */
    @Property(name="customBrowserProtocol")
    @JsonIgnore
    public Optional<String> getCustomBrowserProtocol() {
        return Optional.ofNullable(customBrowserProtocol);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserProtocol} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A custom browser protocol to open weblink on iOS. When this property is
     * configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
     * 
     * @param customBrowserProtocol
     *            new value of {@code customBrowserProtocol} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserProtocol} field changed
     */
    public IosManagedAppProtection withCustomBrowserProtocol(String customBrowserProtocol) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.customBrowserProtocol = customBrowserProtocol;
        return _x;
    }

    /**
     * <i>“Protocol of a custom dialer app to click-to-open a phone number on iOS, for
     * example, skype:.”</i>
     * 
     * @return property customDialerAppProtocol
     */
    @Property(name="customDialerAppProtocol")
    @JsonIgnore
    public Optional<String> getCustomDialerAppProtocol() {
        return Optional.ofNullable(customDialerAppProtocol);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppProtocol} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Protocol of a custom dialer app to click-to-open a phone number on iOS, for
     * example, skype:.”</i>
     * 
     * @param customDialerAppProtocol
     *            new value of {@code customDialerAppProtocol} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppProtocol} field changed
     */
    public IosManagedAppProtection withCustomDialerAppProtocol(String customDialerAppProtocol) {
        IosManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosManagedAppProtection");
        _x.customDialerAppProtocol = customDialerAppProtocol;
        return _x;
    }

    /**
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @return navigational property apps
     */
    @NavigationProperty(name="apps")
    @JsonIgnore
    public ManagedMobileAppCollectionRequest getApps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"));
    }

    /**
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @return navigational property deploymentSummary
     */
    @NavigationProperty(name="deploymentSummary")
    @JsonIgnore
    public ManagedAppPolicyDeploymentSummaryRequest getDeploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosManagedAppProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosManagedAppProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosManagedAppProtection _copy() {
        IosManagedAppProtection _x = new IosManagedAppProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
        _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
        _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
        _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
        _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
        _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
        _x.dataBackupBlocked = dataBackupBlocked;
        _x.deviceComplianceRequired = deviceComplianceRequired;
        _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
        _x.saveAsBlocked = saveAsBlocked;
        _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
        _x.pinRequired = pinRequired;
        _x.maximumPinRetries = maximumPinRetries;
        _x.simplePinBlocked = simplePinBlocked;
        _x.minimumPinLength = minimumPinLength;
        _x.pinCharacterSet = pinCharacterSet;
        _x.periodBeforePinReset = periodBeforePinReset;
        _x.allowedDataStorageLocations = allowedDataStorageLocations;
        _x.contactSyncBlocked = contactSyncBlocked;
        _x.printBlocked = printBlocked;
        _x.fingerprintBlocked = fingerprintBlocked;
        _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
        _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
        _x.minimumWarningOsVersion = minimumWarningOsVersion;
        _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
        _x.minimumWarningAppVersion = minimumWarningAppVersion;
        _x.minimumWipeOsVersion = minimumWipeOsVersion;
        _x.minimumWipeAppVersion = minimumWipeAppVersion;
        _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
        _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
        _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
        _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
        _x.notificationRestriction = notificationRestriction;
        _x.previousPinBlockCount = previousPinBlockCount;
        _x.managedBrowser = managedBrowser;
        _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
        _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
        _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
        _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
        _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
        _x.dialerRestrictionLevel = dialerRestrictionLevel;
        _x.isAssigned = isAssigned;
        _x.targetedAppManagementLevels = targetedAppManagementLevels;
        _x.appDataEncryptionType = appDataEncryptionType;
        _x.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
        _x.deployedAppCount = deployedAppCount;
        _x.faceIdBlocked = faceIdBlocked;
        _x.exemptedAppProtocols = exemptedAppProtocols;
        _x.minimumWipeSdkVersion = minimumWipeSdkVersion;
        _x.allowedIosDeviceModels = allowedIosDeviceModels;
        _x.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
        _x.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
        _x.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
        _x.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
        _x.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
        _x.customBrowserProtocol = customBrowserProtocol;
        _x.customDialerAppProtocol = customDialerAppProtocol;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosManagedAppProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("periodOfflineBeforeAccessCheck=");
        b.append(this.periodOfflineBeforeAccessCheck);
        b.append(", ");
        b.append("periodOnlineBeforeAccessCheck=");
        b.append(this.periodOnlineBeforeAccessCheck);
        b.append(", ");
        b.append("allowedInboundDataTransferSources=");
        b.append(this.allowedInboundDataTransferSources);
        b.append(", ");
        b.append("allowedOutboundDataTransferDestinations=");
        b.append(this.allowedOutboundDataTransferDestinations);
        b.append(", ");
        b.append("organizationalCredentialsRequired=");
        b.append(this.organizationalCredentialsRequired);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingLevel=");
        b.append(this.allowedOutboundClipboardSharingLevel);
        b.append(", ");
        b.append("dataBackupBlocked=");
        b.append(this.dataBackupBlocked);
        b.append(", ");
        b.append("deviceComplianceRequired=");
        b.append(this.deviceComplianceRequired);
        b.append(", ");
        b.append("managedBrowserToOpenLinksRequired=");
        b.append(this.managedBrowserToOpenLinksRequired);
        b.append(", ");
        b.append("saveAsBlocked=");
        b.append(this.saveAsBlocked);
        b.append(", ");
        b.append("periodOfflineBeforeWipeIsEnforced=");
        b.append(this.periodOfflineBeforeWipeIsEnforced);
        b.append(", ");
        b.append("pinRequired=");
        b.append(this.pinRequired);
        b.append(", ");
        b.append("maximumPinRetries=");
        b.append(this.maximumPinRetries);
        b.append(", ");
        b.append("simplePinBlocked=");
        b.append(this.simplePinBlocked);
        b.append(", ");
        b.append("minimumPinLength=");
        b.append(this.minimumPinLength);
        b.append(", ");
        b.append("pinCharacterSet=");
        b.append(this.pinCharacterSet);
        b.append(", ");
        b.append("periodBeforePinReset=");
        b.append(this.periodBeforePinReset);
        b.append(", ");
        b.append("allowedDataStorageLocations=");
        b.append(this.allowedDataStorageLocations);
        b.append(", ");
        b.append("contactSyncBlocked=");
        b.append(this.contactSyncBlocked);
        b.append(", ");
        b.append("printBlocked=");
        b.append(this.printBlocked);
        b.append(", ");
        b.append("fingerprintBlocked=");
        b.append(this.fingerprintBlocked);
        b.append(", ");
        b.append("disableAppPinIfDevicePinIsSet=");
        b.append(this.disableAppPinIfDevicePinIsSet);
        b.append(", ");
        b.append("minimumRequiredOsVersion=");
        b.append(this.minimumRequiredOsVersion);
        b.append(", ");
        b.append("minimumWarningOsVersion=");
        b.append(this.minimumWarningOsVersion);
        b.append(", ");
        b.append("minimumRequiredAppVersion=");
        b.append(this.minimumRequiredAppVersion);
        b.append(", ");
        b.append("minimumWarningAppVersion=");
        b.append(this.minimumWarningAppVersion);
        b.append(", ");
        b.append("minimumWipeOsVersion=");
        b.append(this.minimumWipeOsVersion);
        b.append(", ");
        b.append("minimumWipeAppVersion=");
        b.append(this.minimumWipeAppVersion);
        b.append(", ");
        b.append("appActionIfDeviceComplianceRequired=");
        b.append(this.appActionIfDeviceComplianceRequired);
        b.append(", ");
        b.append("appActionIfMaximumPinRetriesExceeded=");
        b.append(this.appActionIfMaximumPinRetriesExceeded);
        b.append(", ");
        b.append("pinRequiredInsteadOfBiometricTimeout=");
        b.append(this.pinRequiredInsteadOfBiometricTimeout);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingExceptionLength=");
        b.append(this.allowedOutboundClipboardSharingExceptionLength);
        b.append(", ");
        b.append("notificationRestriction=");
        b.append(this.notificationRestriction);
        b.append(", ");
        b.append("previousPinBlockCount=");
        b.append(this.previousPinBlockCount);
        b.append(", ");
        b.append("managedBrowser=");
        b.append(this.managedBrowser);
        b.append(", ");
        b.append("maximumAllowedDeviceThreatLevel=");
        b.append(this.maximumAllowedDeviceThreatLevel);
        b.append(", ");
        b.append("mobileThreatDefenseRemediationAction=");
        b.append(this.mobileThreatDefenseRemediationAction);
        b.append(", ");
        b.append("blockDataIngestionIntoOrganizationDocuments=");
        b.append(this.blockDataIngestionIntoOrganizationDocuments);
        b.append(", ");
        b.append("allowedDataIngestionLocations=");
        b.append(this.allowedDataIngestionLocations);
        b.append(", ");
        b.append("appActionIfUnableToAuthenticateUser=");
        b.append(this.appActionIfUnableToAuthenticateUser);
        b.append(", ");
        b.append("dialerRestrictionLevel=");
        b.append(this.dialerRestrictionLevel);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("targetedAppManagementLevels=");
        b.append(this.targetedAppManagementLevels);
        b.append(", ");
        b.append("appDataEncryptionType=");
        b.append(this.appDataEncryptionType);
        b.append(", ");
        b.append("minimumRequiredSdkVersion=");
        b.append(this.minimumRequiredSdkVersion);
        b.append(", ");
        b.append("deployedAppCount=");
        b.append(this.deployedAppCount);
        b.append(", ");
        b.append("faceIdBlocked=");
        b.append(this.faceIdBlocked);
        b.append(", ");
        b.append("exemptedAppProtocols=");
        b.append(this.exemptedAppProtocols);
        b.append(", ");
        b.append("minimumWipeSdkVersion=");
        b.append(this.minimumWipeSdkVersion);
        b.append(", ");
        b.append("allowedIosDeviceModels=");
        b.append(this.allowedIosDeviceModels);
        b.append(", ");
        b.append("appActionIfIosDeviceModelNotAllowed=");
        b.append(this.appActionIfIosDeviceModelNotAllowed);
        b.append(", ");
        b.append("thirdPartyKeyboardsBlocked=");
        b.append(this.thirdPartyKeyboardsBlocked);
        b.append(", ");
        b.append("filterOpenInToOnlyManagedApps=");
        b.append(this.filterOpenInToOnlyManagedApps);
        b.append(", ");
        b.append("disableProtectionOfManagedOutboundOpenInData=");
        b.append(this.disableProtectionOfManagedOutboundOpenInData);
        b.append(", ");
        b.append("protectInboundDataFromUnknownSources=");
        b.append(this.protectInboundDataFromUnknownSources);
        b.append(", ");
        b.append("customBrowserProtocol=");
        b.append(this.customBrowserProtocol);
        b.append(", ");
        b.append("customDialerAppProtocol=");
        b.append(this.customDialerAppProtocol);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
