package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.IosNetworkUsageRule;
import odata.msgraph.client.beta.complex.MediaContentRatingAustralia;
import odata.msgraph.client.beta.complex.MediaContentRatingCanada;
import odata.msgraph.client.beta.complex.MediaContentRatingFrance;
import odata.msgraph.client.beta.complex.MediaContentRatingGermany;
import odata.msgraph.client.beta.complex.MediaContentRatingIreland;
import odata.msgraph.client.beta.complex.MediaContentRatingJapan;
import odata.msgraph.client.beta.complex.MediaContentRatingNewZealand;
import odata.msgraph.client.beta.complex.MediaContentRatingUnitedKingdom;
import odata.msgraph.client.beta.complex.MediaContentRatingUnitedStates;
import odata.msgraph.client.beta.enums.AppListType;
import odata.msgraph.client.beta.enums.IosKioskModeAppType;
import odata.msgraph.client.beta.enums.RatingAppsType;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.enums.WebBrowserCookieSettings;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the iosGeneralDeviceConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountBlockModification", 
    "activationLockAllowWhenSupervised", 
    "airDropBlocked", 
    "airDropForceUnmanagedDropTarget", 
    "airPlayForcePairingPasswordForOutgoingRequests", 
    "appleWatchBlockPairing", 
    "appleWatchForceWristDetection", 
    "appleNewsBlocked", 
    "appsSingleAppModeList", 
    "appsVisibilityList", 
    "appsVisibilityListType", 
    "appStoreBlockAutomaticDownloads", 
    "appStoreBlocked", 
    "appStoreBlockInAppPurchases", 
    "appStoreBlockUIAppInstallation", 
    "appStoreRequirePassword", 
    "autoFillForceAuthentication", 
    "bluetoothBlockModification", 
    "cameraBlocked", 
    "cellularBlockDataRoaming", 
    "cellularBlockGlobalBackgroundFetchWhileRoaming", 
    "cellularBlockPerAppDataModification", 
    "cellularBlockPersonalHotspot", 
    "cellularBlockPlanModification", 
    "cellularBlockVoiceRoaming", 
    "certificatesBlockUntrustedTlsCertificates", 
    "classroomAppBlockRemoteScreenObservation", 
    "classroomAppForceUnpromptedScreenObservation", 
    "classroomForceAutomaticallyJoinClasses", 
    "classroomForceUnpromptedAppAndDeviceLock", 
    "compliantAppsList", 
    "compliantAppListType", 
    "configurationProfileBlockChanges", 
    "definitionLookupBlocked", 
    "deviceBlockEnableRestrictions", 
    "deviceBlockEraseContentAndSettings", 
    "deviceBlockNameModification", 
    "diagnosticDataBlockSubmission", 
    "diagnosticDataBlockSubmissionModification", 
    "documentsBlockManagedDocumentsInUnmanagedApps", 
    "documentsBlockUnmanagedDocumentsInManagedApps", 
    "emailInDomainSuffixes", 
    "enterpriseAppBlockTrust", 
    "enterpriseAppBlockTrustModification", 
    "esimBlockModification", 
    "faceTimeBlocked", 
    "findMyFriendsBlocked", 
    "gamingBlockGameCenterFriends", 
    "gamingBlockMultiplayer", 
    "gameCenterBlocked", 
    "hostPairingBlocked", 
    "iBooksStoreBlocked", 
    "iBooksStoreBlockErotica", 
    "iCloudBlockActivityContinuation", 
    "iCloudBlockBackup", 
    "iCloudBlockDocumentSync", 
    "iCloudBlockManagedAppsSync", 
    "iCloudBlockPhotoLibrary", 
    "iCloudBlockPhotoStreamSync", 
    "iCloudBlockSharedPhotoStream", 
    "iCloudRequireEncryptedBackup", 
    "iTunesBlockExplicitContent", 
    "iTunesBlockMusicService", 
    "iTunesBlockRadio", 
    "keyboardBlockAutoCorrect", 
    "keyboardBlockDictation", 
    "keyboardBlockPredictive", 
    "keyboardBlockShortcuts", 
    "keyboardBlockSpellCheck", 
    "kioskModeAllowAssistiveSpeak", 
    "kioskModeAllowAssistiveTouchSettings", 
    "kioskModeAllowAutoLock", 
    "kioskModeBlockAutoLock", 
    "kioskModeAllowColorInversionSettings", 
    "kioskModeAllowRingerSwitch", 
    "kioskModeBlockRingerSwitch", 
    "kioskModeAllowScreenRotation", 
    "kioskModeBlockScreenRotation", 
    "kioskModeAllowSleepButton", 
    "kioskModeBlockSleepButton", 
    "kioskModeAllowTouchscreen", 
    "kioskModeBlockTouchscreen", 
    "kioskModeEnableVoiceControl", 
    "kioskModeAllowVoiceControlModification", 
    "kioskModeAllowVoiceOverSettings", 
    "kioskModeAllowVolumeButtons", 
    "kioskModeBlockVolumeButtons", 
    "kioskModeAllowZoomSettings", 
    "kioskModeAppStoreUrl", 
    "kioskModeBuiltInAppId", 
    "kioskModeRequireAssistiveTouch", 
    "kioskModeRequireColorInversion", 
    "kioskModeRequireMonoAudio", 
    "kioskModeRequireVoiceOver", 
    "kioskModeRequireZoom", 
    "kioskModeManagedAppId", 
    "lockScreenBlockControlCenter", 
    "lockScreenBlockNotificationView", 
    "lockScreenBlockPassbook", 
    "lockScreenBlockTodayView", 
    "mediaContentRatingAustralia", 
    "mediaContentRatingCanada", 
    "mediaContentRatingFrance", 
    "mediaContentRatingGermany", 
    "mediaContentRatingIreland", 
    "mediaContentRatingJapan", 
    "mediaContentRatingNewZealand", 
    "mediaContentRatingUnitedKingdom", 
    "mediaContentRatingUnitedStates", 
    "networkUsageRules", 
    "mediaContentRatingApps", 
    "messagesBlocked", 
    "notificationsBlockSettingsModification", 
    "passcodeBlockFingerprintUnlock", 
    "passcodeBlockFingerprintModification", 
    "passcodeBlockModification", 
    "passcodeBlockSimple", 
    "passcodeExpirationDays", 
    "passcodeMinimumLength", 
    "passcodeMinutesOfInactivityBeforeLock", 
    "passcodeMinutesOfInactivityBeforeScreenTimeout", 
    "passcodeMinimumCharacterSetCount", 
    "passcodePreviousPasscodeBlockCount", 
    "passcodeSignInFailureCountBeforeWipe", 
    "passcodeRequiredType", 
    "passcodeRequired", 
    "podcastsBlocked", 
    "proximityBlockSetupToNewDevice", 
    "safariBlockAutofill", 
    "safariBlockJavaScript", 
    "safariBlockPopups", 
    "safariBlocked", 
    "safariCookieSettings", 
    "safariManagedDomains", 
    "safariPasswordAutoFillDomains", 
    "safariRequireFraudWarning", 
    "screenCaptureBlocked", 
    "siriBlocked", 
    "siriBlockedWhenLocked", 
    "siriBlockUserGeneratedContent", 
    "siriRequireProfanityFilter", 
    "softwareUpdatesEnforcedDelayInDays", 
    "softwareUpdatesForceDelayed", 
    "spotlightBlockInternetResults", 
    "voiceDialingBlocked", 
    "wallpaperBlockModification", 
    "wiFiConnectOnlyToConfiguredNetworks", 
    "classroomForceRequestPermissionToLeaveClasses", 
    "keychainBlockCloudSync", 
    "pkiBlockOTAUpdates", 
    "privacyForceLimitAdTracking", 
    "enterpriseBookBlockBackup", 
    "enterpriseBookBlockMetadataSync", 
    "airPrintBlocked", 
    "airPrintBlockCredentialsStorage", 
    "airPrintForceTrustedTLS", 
    "airPrintBlockiBeaconDiscovery", 
    "filesNetworkDriveAccessBlocked", 
    "filesUsbDriveAccessBlocked", 
    "wifiPowerOnForced", 
    "blockSystemAppRemoval", 
    "vpnBlockCreation", 
    "appRemovalBlocked", 
    "usbRestrictedModeBlocked", 
    "passwordBlockAutoFill", 
    "passwordBlockProximityRequests", 
    "passwordBlockAirDropSharing", 
    "dateAndTimeForceSetAutomatically", 
    "contactsAllowManagedToUnmanagedWrite", 
    "contactsAllowUnmanagedToManagedRead", 
    "cellularBlockPersonalHotspotModification", 
    "continuousPathKeyboardBlocked", 
    "findMyDeviceInFindMyAppBlocked", 
    "findMyFriendsInFindMyAppBlocked", 
    "iTunesBlocked", 
    "sharedDeviceBlockTemporarySessions", 
    "kioskModeAppType"})
@JsonInclude(Include.NON_NULL)
public class IosGeneralDeviceConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosGeneralDeviceConfiguration";
    }

    @JsonProperty("accountBlockModification")
    protected Boolean accountBlockModification;

    @JsonProperty("activationLockAllowWhenSupervised")
    protected Boolean activationLockAllowWhenSupervised;

    @JsonProperty("airDropBlocked")
    protected Boolean airDropBlocked;

    @JsonProperty("airDropForceUnmanagedDropTarget")
    protected Boolean airDropForceUnmanagedDropTarget;

    @JsonProperty("airPlayForcePairingPasswordForOutgoingRequests")
    protected Boolean airPlayForcePairingPasswordForOutgoingRequests;

    @JsonProperty("appleWatchBlockPairing")
    protected Boolean appleWatchBlockPairing;

    @JsonProperty("appleWatchForceWristDetection")
    protected Boolean appleWatchForceWristDetection;

    @JsonProperty("appleNewsBlocked")
    protected Boolean appleNewsBlocked;

    @JsonProperty("appsSingleAppModeList")
    protected List<AppListItem> appsSingleAppModeList;

    @JsonProperty("appsSingleAppModeList@nextLink")
    protected String appsSingleAppModeListNextLink;

    @JsonProperty("appsVisibilityList")
    protected List<AppListItem> appsVisibilityList;

    @JsonProperty("appsVisibilityList@nextLink")
    protected String appsVisibilityListNextLink;

    @JsonProperty("appsVisibilityListType")
    protected AppListType appsVisibilityListType;

    @JsonProperty("appStoreBlockAutomaticDownloads")
    protected Boolean appStoreBlockAutomaticDownloads;

    @JsonProperty("appStoreBlocked")
    protected Boolean appStoreBlocked;

    @JsonProperty("appStoreBlockInAppPurchases")
    protected Boolean appStoreBlockInAppPurchases;

    @JsonProperty("appStoreBlockUIAppInstallation")
    protected Boolean appStoreBlockUIAppInstallation;

    @JsonProperty("appStoreRequirePassword")
    protected Boolean appStoreRequirePassword;

    @JsonProperty("autoFillForceAuthentication")
    protected Boolean autoFillForceAuthentication;

    @JsonProperty("bluetoothBlockModification")
    protected Boolean bluetoothBlockModification;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("cellularBlockDataRoaming")
    protected Boolean cellularBlockDataRoaming;

    @JsonProperty("cellularBlockGlobalBackgroundFetchWhileRoaming")
    protected Boolean cellularBlockGlobalBackgroundFetchWhileRoaming;

    @JsonProperty("cellularBlockPerAppDataModification")
    protected Boolean cellularBlockPerAppDataModification;

    @JsonProperty("cellularBlockPersonalHotspot")
    protected Boolean cellularBlockPersonalHotspot;

    @JsonProperty("cellularBlockPlanModification")
    protected Boolean cellularBlockPlanModification;

    @JsonProperty("cellularBlockVoiceRoaming")
    protected Boolean cellularBlockVoiceRoaming;

    @JsonProperty("certificatesBlockUntrustedTlsCertificates")
    protected Boolean certificatesBlockUntrustedTlsCertificates;

    @JsonProperty("classroomAppBlockRemoteScreenObservation")
    protected Boolean classroomAppBlockRemoteScreenObservation;

    @JsonProperty("classroomAppForceUnpromptedScreenObservation")
    protected Boolean classroomAppForceUnpromptedScreenObservation;

    @JsonProperty("classroomForceAutomaticallyJoinClasses")
    protected Boolean classroomForceAutomaticallyJoinClasses;

    @JsonProperty("classroomForceUnpromptedAppAndDeviceLock")
    protected Boolean classroomForceUnpromptedAppAndDeviceLock;

    @JsonProperty("compliantAppsList")
    protected List<AppListItem> compliantAppsList;

    @JsonProperty("compliantAppsList@nextLink")
    protected String compliantAppsListNextLink;

    @JsonProperty("compliantAppListType")
    protected AppListType compliantAppListType;

    @JsonProperty("configurationProfileBlockChanges")
    protected Boolean configurationProfileBlockChanges;

    @JsonProperty("definitionLookupBlocked")
    protected Boolean definitionLookupBlocked;

    @JsonProperty("deviceBlockEnableRestrictions")
    protected Boolean deviceBlockEnableRestrictions;

    @JsonProperty("deviceBlockEraseContentAndSettings")
    protected Boolean deviceBlockEraseContentAndSettings;

    @JsonProperty("deviceBlockNameModification")
    protected Boolean deviceBlockNameModification;

    @JsonProperty("diagnosticDataBlockSubmission")
    protected Boolean diagnosticDataBlockSubmission;

    @JsonProperty("diagnosticDataBlockSubmissionModification")
    protected Boolean diagnosticDataBlockSubmissionModification;

    @JsonProperty("documentsBlockManagedDocumentsInUnmanagedApps")
    protected Boolean documentsBlockManagedDocumentsInUnmanagedApps;

    @JsonProperty("documentsBlockUnmanagedDocumentsInManagedApps")
    protected Boolean documentsBlockUnmanagedDocumentsInManagedApps;

    @JsonProperty("emailInDomainSuffixes")
    protected List<String> emailInDomainSuffixes;

    @JsonProperty("emailInDomainSuffixes@nextLink")
    protected String emailInDomainSuffixesNextLink;

    @JsonProperty("enterpriseAppBlockTrust")
    protected Boolean enterpriseAppBlockTrust;

    @JsonProperty("enterpriseAppBlockTrustModification")
    protected Boolean enterpriseAppBlockTrustModification;

    @JsonProperty("esimBlockModification")
    protected Boolean esimBlockModification;

    @JsonProperty("faceTimeBlocked")
    protected Boolean faceTimeBlocked;

    @JsonProperty("findMyFriendsBlocked")
    protected Boolean findMyFriendsBlocked;

    @JsonProperty("gamingBlockGameCenterFriends")
    protected Boolean gamingBlockGameCenterFriends;

    @JsonProperty("gamingBlockMultiplayer")
    protected Boolean gamingBlockMultiplayer;

    @JsonProperty("gameCenterBlocked")
    protected Boolean gameCenterBlocked;

    @JsonProperty("hostPairingBlocked")
    protected Boolean hostPairingBlocked;

    @JsonProperty("iBooksStoreBlocked")
    protected Boolean iBooksStoreBlocked;

    @JsonProperty("iBooksStoreBlockErotica")
    protected Boolean iBooksStoreBlockErotica;

    @JsonProperty("iCloudBlockActivityContinuation")
    protected Boolean iCloudBlockActivityContinuation;

    @JsonProperty("iCloudBlockBackup")
    protected Boolean iCloudBlockBackup;

    @JsonProperty("iCloudBlockDocumentSync")
    protected Boolean iCloudBlockDocumentSync;

    @JsonProperty("iCloudBlockManagedAppsSync")
    protected Boolean iCloudBlockManagedAppsSync;

    @JsonProperty("iCloudBlockPhotoLibrary")
    protected Boolean iCloudBlockPhotoLibrary;

    @JsonProperty("iCloudBlockPhotoStreamSync")
    protected Boolean iCloudBlockPhotoStreamSync;

    @JsonProperty("iCloudBlockSharedPhotoStream")
    protected Boolean iCloudBlockSharedPhotoStream;

    @JsonProperty("iCloudRequireEncryptedBackup")
    protected Boolean iCloudRequireEncryptedBackup;

    @JsonProperty("iTunesBlockExplicitContent")
    protected Boolean iTunesBlockExplicitContent;

    @JsonProperty("iTunesBlockMusicService")
    protected Boolean iTunesBlockMusicService;

    @JsonProperty("iTunesBlockRadio")
    protected Boolean iTunesBlockRadio;

    @JsonProperty("keyboardBlockAutoCorrect")
    protected Boolean keyboardBlockAutoCorrect;

    @JsonProperty("keyboardBlockDictation")
    protected Boolean keyboardBlockDictation;

    @JsonProperty("keyboardBlockPredictive")
    protected Boolean keyboardBlockPredictive;

    @JsonProperty("keyboardBlockShortcuts")
    protected Boolean keyboardBlockShortcuts;

    @JsonProperty("keyboardBlockSpellCheck")
    protected Boolean keyboardBlockSpellCheck;

    @JsonProperty("kioskModeAllowAssistiveSpeak")
    protected Boolean kioskModeAllowAssistiveSpeak;

    @JsonProperty("kioskModeAllowAssistiveTouchSettings")
    protected Boolean kioskModeAllowAssistiveTouchSettings;

    @JsonProperty("kioskModeAllowAutoLock")
    protected Boolean kioskModeAllowAutoLock;

    @JsonProperty("kioskModeBlockAutoLock")
    protected Boolean kioskModeBlockAutoLock;

    @JsonProperty("kioskModeAllowColorInversionSettings")
    protected Boolean kioskModeAllowColorInversionSettings;

    @JsonProperty("kioskModeAllowRingerSwitch")
    protected Boolean kioskModeAllowRingerSwitch;

    @JsonProperty("kioskModeBlockRingerSwitch")
    protected Boolean kioskModeBlockRingerSwitch;

    @JsonProperty("kioskModeAllowScreenRotation")
    protected Boolean kioskModeAllowScreenRotation;

    @JsonProperty("kioskModeBlockScreenRotation")
    protected Boolean kioskModeBlockScreenRotation;

    @JsonProperty("kioskModeAllowSleepButton")
    protected Boolean kioskModeAllowSleepButton;

    @JsonProperty("kioskModeBlockSleepButton")
    protected Boolean kioskModeBlockSleepButton;

    @JsonProperty("kioskModeAllowTouchscreen")
    protected Boolean kioskModeAllowTouchscreen;

    @JsonProperty("kioskModeBlockTouchscreen")
    protected Boolean kioskModeBlockTouchscreen;

    @JsonProperty("kioskModeEnableVoiceControl")
    protected Boolean kioskModeEnableVoiceControl;

    @JsonProperty("kioskModeAllowVoiceControlModification")
    protected Boolean kioskModeAllowVoiceControlModification;

    @JsonProperty("kioskModeAllowVoiceOverSettings")
    protected Boolean kioskModeAllowVoiceOverSettings;

    @JsonProperty("kioskModeAllowVolumeButtons")
    protected Boolean kioskModeAllowVolumeButtons;

    @JsonProperty("kioskModeBlockVolumeButtons")
    protected Boolean kioskModeBlockVolumeButtons;

    @JsonProperty("kioskModeAllowZoomSettings")
    protected Boolean kioskModeAllowZoomSettings;

    @JsonProperty("kioskModeAppStoreUrl")
    protected String kioskModeAppStoreUrl;

    @JsonProperty("kioskModeBuiltInAppId")
    protected String kioskModeBuiltInAppId;

    @JsonProperty("kioskModeRequireAssistiveTouch")
    protected Boolean kioskModeRequireAssistiveTouch;

    @JsonProperty("kioskModeRequireColorInversion")
    protected Boolean kioskModeRequireColorInversion;

    @JsonProperty("kioskModeRequireMonoAudio")
    protected Boolean kioskModeRequireMonoAudio;

    @JsonProperty("kioskModeRequireVoiceOver")
    protected Boolean kioskModeRequireVoiceOver;

    @JsonProperty("kioskModeRequireZoom")
    protected Boolean kioskModeRequireZoom;

    @JsonProperty("kioskModeManagedAppId")
    protected String kioskModeManagedAppId;

    @JsonProperty("lockScreenBlockControlCenter")
    protected Boolean lockScreenBlockControlCenter;

    @JsonProperty("lockScreenBlockNotificationView")
    protected Boolean lockScreenBlockNotificationView;

    @JsonProperty("lockScreenBlockPassbook")
    protected Boolean lockScreenBlockPassbook;

    @JsonProperty("lockScreenBlockTodayView")
    protected Boolean lockScreenBlockTodayView;

    @JsonProperty("mediaContentRatingAustralia")
    protected MediaContentRatingAustralia mediaContentRatingAustralia;

    @JsonProperty("mediaContentRatingCanada")
    protected MediaContentRatingCanada mediaContentRatingCanada;

    @JsonProperty("mediaContentRatingFrance")
    protected MediaContentRatingFrance mediaContentRatingFrance;

    @JsonProperty("mediaContentRatingGermany")
    protected MediaContentRatingGermany mediaContentRatingGermany;

    @JsonProperty("mediaContentRatingIreland")
    protected MediaContentRatingIreland mediaContentRatingIreland;

    @JsonProperty("mediaContentRatingJapan")
    protected MediaContentRatingJapan mediaContentRatingJapan;

    @JsonProperty("mediaContentRatingNewZealand")
    protected MediaContentRatingNewZealand mediaContentRatingNewZealand;

    @JsonProperty("mediaContentRatingUnitedKingdom")
    protected MediaContentRatingUnitedKingdom mediaContentRatingUnitedKingdom;

    @JsonProperty("mediaContentRatingUnitedStates")
    protected MediaContentRatingUnitedStates mediaContentRatingUnitedStates;

    @JsonProperty("networkUsageRules")
    protected List<IosNetworkUsageRule> networkUsageRules;

    @JsonProperty("networkUsageRules@nextLink")
    protected String networkUsageRulesNextLink;

    @JsonProperty("mediaContentRatingApps")
    protected RatingAppsType mediaContentRatingApps;

    @JsonProperty("messagesBlocked")
    protected Boolean messagesBlocked;

    @JsonProperty("notificationsBlockSettingsModification")
    protected Boolean notificationsBlockSettingsModification;

    @JsonProperty("passcodeBlockFingerprintUnlock")
    protected Boolean passcodeBlockFingerprintUnlock;

    @JsonProperty("passcodeBlockFingerprintModification")
    protected Boolean passcodeBlockFingerprintModification;

    @JsonProperty("passcodeBlockModification")
    protected Boolean passcodeBlockModification;

    @JsonProperty("passcodeBlockSimple")
    protected Boolean passcodeBlockSimple;

    @JsonProperty("passcodeExpirationDays")
    protected Integer passcodeExpirationDays;

    @JsonProperty("passcodeMinimumLength")
    protected Integer passcodeMinimumLength;

    @JsonProperty("passcodeMinutesOfInactivityBeforeLock")
    protected Integer passcodeMinutesOfInactivityBeforeLock;

    @JsonProperty("passcodeMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passcodeMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passcodeMinimumCharacterSetCount")
    protected Integer passcodeMinimumCharacterSetCount;

    @JsonProperty("passcodePreviousPasscodeBlockCount")
    protected Integer passcodePreviousPasscodeBlockCount;

    @JsonProperty("passcodeSignInFailureCountBeforeWipe")
    protected Integer passcodeSignInFailureCountBeforeWipe;

    @JsonProperty("passcodeRequiredType")
    protected RequiredPasswordType passcodeRequiredType;

    @JsonProperty("passcodeRequired")
    protected Boolean passcodeRequired;

    @JsonProperty("podcastsBlocked")
    protected Boolean podcastsBlocked;

    @JsonProperty("proximityBlockSetupToNewDevice")
    protected Boolean proximityBlockSetupToNewDevice;

    @JsonProperty("safariBlockAutofill")
    protected Boolean safariBlockAutofill;

    @JsonProperty("safariBlockJavaScript")
    protected Boolean safariBlockJavaScript;

    @JsonProperty("safariBlockPopups")
    protected Boolean safariBlockPopups;

    @JsonProperty("safariBlocked")
    protected Boolean safariBlocked;

    @JsonProperty("safariCookieSettings")
    protected WebBrowserCookieSettings safariCookieSettings;

    @JsonProperty("safariManagedDomains")
    protected List<String> safariManagedDomains;

    @JsonProperty("safariManagedDomains@nextLink")
    protected String safariManagedDomainsNextLink;

    @JsonProperty("safariPasswordAutoFillDomains")
    protected List<String> safariPasswordAutoFillDomains;

    @JsonProperty("safariPasswordAutoFillDomains@nextLink")
    protected String safariPasswordAutoFillDomainsNextLink;

    @JsonProperty("safariRequireFraudWarning")
    protected Boolean safariRequireFraudWarning;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("siriBlocked")
    protected Boolean siriBlocked;

    @JsonProperty("siriBlockedWhenLocked")
    protected Boolean siriBlockedWhenLocked;

    @JsonProperty("siriBlockUserGeneratedContent")
    protected Boolean siriBlockUserGeneratedContent;

    @JsonProperty("siriRequireProfanityFilter")
    protected Boolean siriRequireProfanityFilter;

    @JsonProperty("softwareUpdatesEnforcedDelayInDays")
    protected Integer softwareUpdatesEnforcedDelayInDays;

    @JsonProperty("softwareUpdatesForceDelayed")
    protected Boolean softwareUpdatesForceDelayed;

    @JsonProperty("spotlightBlockInternetResults")
    protected Boolean spotlightBlockInternetResults;

    @JsonProperty("voiceDialingBlocked")
    protected Boolean voiceDialingBlocked;

    @JsonProperty("wallpaperBlockModification")
    protected Boolean wallpaperBlockModification;

    @JsonProperty("wiFiConnectOnlyToConfiguredNetworks")
    protected Boolean wiFiConnectOnlyToConfiguredNetworks;

    @JsonProperty("classroomForceRequestPermissionToLeaveClasses")
    protected Boolean classroomForceRequestPermissionToLeaveClasses;

    @JsonProperty("keychainBlockCloudSync")
    protected Boolean keychainBlockCloudSync;

    @JsonProperty("pkiBlockOTAUpdates")
    protected Boolean pkiBlockOTAUpdates;

    @JsonProperty("privacyForceLimitAdTracking")
    protected Boolean privacyForceLimitAdTracking;

    @JsonProperty("enterpriseBookBlockBackup")
    protected Boolean enterpriseBookBlockBackup;

    @JsonProperty("enterpriseBookBlockMetadataSync")
    protected Boolean enterpriseBookBlockMetadataSync;

    @JsonProperty("airPrintBlocked")
    protected Boolean airPrintBlocked;

    @JsonProperty("airPrintBlockCredentialsStorage")
    protected Boolean airPrintBlockCredentialsStorage;

    @JsonProperty("airPrintForceTrustedTLS")
    protected Boolean airPrintForceTrustedTLS;

    @JsonProperty("airPrintBlockiBeaconDiscovery")
    protected Boolean airPrintBlockiBeaconDiscovery;

    @JsonProperty("filesNetworkDriveAccessBlocked")
    protected Boolean filesNetworkDriveAccessBlocked;

    @JsonProperty("filesUsbDriveAccessBlocked")
    protected Boolean filesUsbDriveAccessBlocked;

    @JsonProperty("wifiPowerOnForced")
    protected Boolean wifiPowerOnForced;

    @JsonProperty("blockSystemAppRemoval")
    protected Boolean blockSystemAppRemoval;

    @JsonProperty("vpnBlockCreation")
    protected Boolean vpnBlockCreation;

    @JsonProperty("appRemovalBlocked")
    protected Boolean appRemovalBlocked;

    @JsonProperty("usbRestrictedModeBlocked")
    protected Boolean usbRestrictedModeBlocked;

    @JsonProperty("passwordBlockAutoFill")
    protected Boolean passwordBlockAutoFill;

    @JsonProperty("passwordBlockProximityRequests")
    protected Boolean passwordBlockProximityRequests;

    @JsonProperty("passwordBlockAirDropSharing")
    protected Boolean passwordBlockAirDropSharing;

    @JsonProperty("dateAndTimeForceSetAutomatically")
    protected Boolean dateAndTimeForceSetAutomatically;

    @JsonProperty("contactsAllowManagedToUnmanagedWrite")
    protected Boolean contactsAllowManagedToUnmanagedWrite;

    @JsonProperty("contactsAllowUnmanagedToManagedRead")
    protected Boolean contactsAllowUnmanagedToManagedRead;

    @JsonProperty("cellularBlockPersonalHotspotModification")
    protected Boolean cellularBlockPersonalHotspotModification;

    @JsonProperty("continuousPathKeyboardBlocked")
    protected Boolean continuousPathKeyboardBlocked;

    @JsonProperty("findMyDeviceInFindMyAppBlocked")
    protected Boolean findMyDeviceInFindMyAppBlocked;

    @JsonProperty("findMyFriendsInFindMyAppBlocked")
    protected Boolean findMyFriendsInFindMyAppBlocked;

    @JsonProperty("iTunesBlocked")
    protected Boolean iTunesBlocked;

    @JsonProperty("sharedDeviceBlockTemporarySessions")
    protected Boolean sharedDeviceBlockTemporarySessions;

    @JsonProperty("kioskModeAppType")
    protected IosKioskModeAppType kioskModeAppType;

    protected IosGeneralDeviceConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosGeneralDeviceConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Boolean accountBlockModification;
        private Boolean activationLockAllowWhenSupervised;
        private Boolean airDropBlocked;
        private Boolean airDropForceUnmanagedDropTarget;
        private Boolean airPlayForcePairingPasswordForOutgoingRequests;
        private Boolean appleWatchBlockPairing;
        private Boolean appleWatchForceWristDetection;
        private Boolean appleNewsBlocked;
        private List<AppListItem> appsSingleAppModeList;
        private String appsSingleAppModeListNextLink;
        private List<AppListItem> appsVisibilityList;
        private String appsVisibilityListNextLink;
        private AppListType appsVisibilityListType;
        private Boolean appStoreBlockAutomaticDownloads;
        private Boolean appStoreBlocked;
        private Boolean appStoreBlockInAppPurchases;
        private Boolean appStoreBlockUIAppInstallation;
        private Boolean appStoreRequirePassword;
        private Boolean autoFillForceAuthentication;
        private Boolean bluetoothBlockModification;
        private Boolean cameraBlocked;
        private Boolean cellularBlockDataRoaming;
        private Boolean cellularBlockGlobalBackgroundFetchWhileRoaming;
        private Boolean cellularBlockPerAppDataModification;
        private Boolean cellularBlockPersonalHotspot;
        private Boolean cellularBlockPlanModification;
        private Boolean cellularBlockVoiceRoaming;
        private Boolean certificatesBlockUntrustedTlsCertificates;
        private Boolean classroomAppBlockRemoteScreenObservation;
        private Boolean classroomAppForceUnpromptedScreenObservation;
        private Boolean classroomForceAutomaticallyJoinClasses;
        private Boolean classroomForceUnpromptedAppAndDeviceLock;
        private List<AppListItem> compliantAppsList;
        private String compliantAppsListNextLink;
        private AppListType compliantAppListType;
        private Boolean configurationProfileBlockChanges;
        private Boolean definitionLookupBlocked;
        private Boolean deviceBlockEnableRestrictions;
        private Boolean deviceBlockEraseContentAndSettings;
        private Boolean deviceBlockNameModification;
        private Boolean diagnosticDataBlockSubmission;
        private Boolean diagnosticDataBlockSubmissionModification;
        private Boolean documentsBlockManagedDocumentsInUnmanagedApps;
        private Boolean documentsBlockUnmanagedDocumentsInManagedApps;
        private List<String> emailInDomainSuffixes;
        private String emailInDomainSuffixesNextLink;
        private Boolean enterpriseAppBlockTrust;
        private Boolean enterpriseAppBlockTrustModification;
        private Boolean esimBlockModification;
        private Boolean faceTimeBlocked;
        private Boolean findMyFriendsBlocked;
        private Boolean gamingBlockGameCenterFriends;
        private Boolean gamingBlockMultiplayer;
        private Boolean gameCenterBlocked;
        private Boolean hostPairingBlocked;
        private Boolean iBooksStoreBlocked;
        private Boolean iBooksStoreBlockErotica;
        private Boolean iCloudBlockActivityContinuation;
        private Boolean iCloudBlockBackup;
        private Boolean iCloudBlockDocumentSync;
        private Boolean iCloudBlockManagedAppsSync;
        private Boolean iCloudBlockPhotoLibrary;
        private Boolean iCloudBlockPhotoStreamSync;
        private Boolean iCloudBlockSharedPhotoStream;
        private Boolean iCloudRequireEncryptedBackup;
        private Boolean iTunesBlockExplicitContent;
        private Boolean iTunesBlockMusicService;
        private Boolean iTunesBlockRadio;
        private Boolean keyboardBlockAutoCorrect;
        private Boolean keyboardBlockDictation;
        private Boolean keyboardBlockPredictive;
        private Boolean keyboardBlockShortcuts;
        private Boolean keyboardBlockSpellCheck;
        private Boolean kioskModeAllowAssistiveSpeak;
        private Boolean kioskModeAllowAssistiveTouchSettings;
        private Boolean kioskModeAllowAutoLock;
        private Boolean kioskModeBlockAutoLock;
        private Boolean kioskModeAllowColorInversionSettings;
        private Boolean kioskModeAllowRingerSwitch;
        private Boolean kioskModeBlockRingerSwitch;
        private Boolean kioskModeAllowScreenRotation;
        private Boolean kioskModeBlockScreenRotation;
        private Boolean kioskModeAllowSleepButton;
        private Boolean kioskModeBlockSleepButton;
        private Boolean kioskModeAllowTouchscreen;
        private Boolean kioskModeBlockTouchscreen;
        private Boolean kioskModeEnableVoiceControl;
        private Boolean kioskModeAllowVoiceControlModification;
        private Boolean kioskModeAllowVoiceOverSettings;
        private Boolean kioskModeAllowVolumeButtons;
        private Boolean kioskModeBlockVolumeButtons;
        private Boolean kioskModeAllowZoomSettings;
        private String kioskModeAppStoreUrl;
        private String kioskModeBuiltInAppId;
        private Boolean kioskModeRequireAssistiveTouch;
        private Boolean kioskModeRequireColorInversion;
        private Boolean kioskModeRequireMonoAudio;
        private Boolean kioskModeRequireVoiceOver;
        private Boolean kioskModeRequireZoom;
        private String kioskModeManagedAppId;
        private Boolean lockScreenBlockControlCenter;
        private Boolean lockScreenBlockNotificationView;
        private Boolean lockScreenBlockPassbook;
        private Boolean lockScreenBlockTodayView;
        private MediaContentRatingAustralia mediaContentRatingAustralia;
        private MediaContentRatingCanada mediaContentRatingCanada;
        private MediaContentRatingFrance mediaContentRatingFrance;
        private MediaContentRatingGermany mediaContentRatingGermany;
        private MediaContentRatingIreland mediaContentRatingIreland;
        private MediaContentRatingJapan mediaContentRatingJapan;
        private MediaContentRatingNewZealand mediaContentRatingNewZealand;
        private MediaContentRatingUnitedKingdom mediaContentRatingUnitedKingdom;
        private MediaContentRatingUnitedStates mediaContentRatingUnitedStates;
        private List<IosNetworkUsageRule> networkUsageRules;
        private String networkUsageRulesNextLink;
        private RatingAppsType mediaContentRatingApps;
        private Boolean messagesBlocked;
        private Boolean notificationsBlockSettingsModification;
        private Boolean passcodeBlockFingerprintUnlock;
        private Boolean passcodeBlockFingerprintModification;
        private Boolean passcodeBlockModification;
        private Boolean passcodeBlockSimple;
        private Integer passcodeExpirationDays;
        private Integer passcodeMinimumLength;
        private Integer passcodeMinutesOfInactivityBeforeLock;
        private Integer passcodeMinutesOfInactivityBeforeScreenTimeout;
        private Integer passcodeMinimumCharacterSetCount;
        private Integer passcodePreviousPasscodeBlockCount;
        private Integer passcodeSignInFailureCountBeforeWipe;
        private RequiredPasswordType passcodeRequiredType;
        private Boolean passcodeRequired;
        private Boolean podcastsBlocked;
        private Boolean proximityBlockSetupToNewDevice;
        private Boolean safariBlockAutofill;
        private Boolean safariBlockJavaScript;
        private Boolean safariBlockPopups;
        private Boolean safariBlocked;
        private WebBrowserCookieSettings safariCookieSettings;
        private List<String> safariManagedDomains;
        private String safariManagedDomainsNextLink;
        private List<String> safariPasswordAutoFillDomains;
        private String safariPasswordAutoFillDomainsNextLink;
        private Boolean safariRequireFraudWarning;
        private Boolean screenCaptureBlocked;
        private Boolean siriBlocked;
        private Boolean siriBlockedWhenLocked;
        private Boolean siriBlockUserGeneratedContent;
        private Boolean siriRequireProfanityFilter;
        private Integer softwareUpdatesEnforcedDelayInDays;
        private Boolean softwareUpdatesForceDelayed;
        private Boolean spotlightBlockInternetResults;
        private Boolean voiceDialingBlocked;
        private Boolean wallpaperBlockModification;
        private Boolean wiFiConnectOnlyToConfiguredNetworks;
        private Boolean classroomForceRequestPermissionToLeaveClasses;
        private Boolean keychainBlockCloudSync;
        private Boolean pkiBlockOTAUpdates;
        private Boolean privacyForceLimitAdTracking;
        private Boolean enterpriseBookBlockBackup;
        private Boolean enterpriseBookBlockMetadataSync;
        private Boolean airPrintBlocked;
        private Boolean airPrintBlockCredentialsStorage;
        private Boolean airPrintForceTrustedTLS;
        private Boolean airPrintBlockiBeaconDiscovery;
        private Boolean filesNetworkDriveAccessBlocked;
        private Boolean filesUsbDriveAccessBlocked;
        private Boolean wifiPowerOnForced;
        private Boolean blockSystemAppRemoval;
        private Boolean vpnBlockCreation;
        private Boolean appRemovalBlocked;
        private Boolean usbRestrictedModeBlocked;
        private Boolean passwordBlockAutoFill;
        private Boolean passwordBlockProximityRequests;
        private Boolean passwordBlockAirDropSharing;
        private Boolean dateAndTimeForceSetAutomatically;
        private Boolean contactsAllowManagedToUnmanagedWrite;
        private Boolean contactsAllowUnmanagedToManagedRead;
        private Boolean cellularBlockPersonalHotspotModification;
        private Boolean continuousPathKeyboardBlocked;
        private Boolean findMyDeviceInFindMyAppBlocked;
        private Boolean findMyFriendsInFindMyAppBlocked;
        private Boolean iTunesBlocked;
        private Boolean sharedDeviceBlockTemporarySessions;
        private IosKioskModeAppType kioskModeAppType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow account modification when the device is in
         * supervised mode.”</i>
         * 
         * @param accountBlockModification
         *            value of {@code accountBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountBlockModification(Boolean accountBlockModification) {
            this.accountBlockModification = accountBlockModification;
            this.changedFields = changedFields.add("accountBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow activation lock when the device is in the
         * supervised mode.”</i>
         * 
         * @param activationLockAllowWhenSupervised
         *            value of {@code activationLockAllowWhenSupervised} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activationLockAllowWhenSupervised(Boolean activationLockAllowWhenSupervised) {
            this.activationLockAllowWhenSupervised = activationLockAllowWhenSupervised;
            this.changedFields = changedFields.add("activationLockAllowWhenSupervised");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow AirDrop when the device is in supervised mode.”</i>
         * 
         * @param airDropBlocked
         *            value of {@code airDropBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airDropBlocked(Boolean airDropBlocked) {
            this.airDropBlocked = airDropBlocked;
            this.changedFields = changedFields.add("airDropBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to cause AirDrop to be considered an unmanaged drop
         * target (iOS 9.0 and later).”</i>
         * 
         * @param airDropForceUnmanagedDropTarget
         *            value of {@code airDropForceUnmanagedDropTarget} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airDropForceUnmanagedDropTarget(Boolean airDropForceUnmanagedDropTarget) {
            this.airDropForceUnmanagedDropTarget = airDropForceUnmanagedDropTarget;
            this.changedFields = changedFields.add("airDropForceUnmanagedDropTarget");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enforce all devices receiving AirPlay requests from
         * this device to use a pairing password.”</i>
         * 
         * @param airPlayForcePairingPasswordForOutgoingRequests
         *            value of {@code airPlayForcePairingPasswordForOutgoingRequests} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPlayForcePairingPasswordForOutgoingRequests(Boolean airPlayForcePairingPasswordForOutgoingRequests) {
            this.airPlayForcePairingPasswordForOutgoingRequests = airPlayForcePairingPasswordForOutgoingRequests;
            this.changedFields = changedFields.add("airPlayForcePairingPasswordForOutgoingRequests");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow Apple Watch pairing when the device is in
         * supervised mode (iOS 9.0 and later).”</i>
         * 
         * @param appleWatchBlockPairing
         *            value of {@code appleWatchBlockPairing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleWatchBlockPairing(Boolean appleWatchBlockPairing) {
            this.appleWatchBlockPairing = appleWatchBlockPairing;
            this.changedFields = changedFields.add("appleWatchBlockPairing");
            return this;
        }

        /**
         * <i>“Indicates whether or not to force a paired Apple Watch to use Wrist Detection (
         * iOS 8.2 and later).”</i>
         * 
         * @param appleWatchForceWristDetection
         *            value of {@code appleWatchForceWristDetection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleWatchForceWristDetection(Boolean appleWatchForceWristDetection) {
            this.appleWatchForceWristDetection = appleWatchForceWristDetection;
            this.changedFields = changedFields.add("appleWatchForceWristDetection");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using News when the device is in
         * supervised mode (iOS 9.0 and later).”</i>
         * 
         * @param appleNewsBlocked
         *            value of {@code appleNewsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleNewsBlocked(Boolean appleNewsBlocked) {
            this.appleNewsBlocked = appleNewsBlocked;
            this.changedFields = changedFields.add("appleNewsBlocked");
            return this;
        }

        /**
         * <i>“Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode.
         * Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param appsSingleAppModeList
         *            value of {@code appsSingleAppModeList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsSingleAppModeList(List<AppListItem> appsSingleAppModeList) {
            this.appsSingleAppModeList = appsSingleAppModeList;
            this.changedFields = changedFields.add("appsSingleAppModeList");
            return this;
        }

        /**
         * <i>“Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode.
         * Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param appsSingleAppModeList
         *            value of {@code appsSingleAppModeList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsSingleAppModeList(AppListItem... appsSingleAppModeList) {
            return appsSingleAppModeList(Arrays.asList(appsSingleAppModeList));
        }

        /**
         * <i>“Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode.
         * Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param appsSingleAppModeListNextLink
         *            value of {@code appsSingleAppModeList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsSingleAppModeListNextLink(String appsSingleAppModeListNextLink) {
            this.appsSingleAppModeListNextLink = appsSingleAppModeListNextLink;
            this.changedFields = changedFields.add("appsSingleAppModeList");
            return this;
        }

        /**
         * <i>“List of apps in the visibility list (either visible/launchable apps list or
         * hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3
         * and later). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param appsVisibilityList
         *            value of {@code appsVisibilityList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsVisibilityList(List<AppListItem> appsVisibilityList) {
            this.appsVisibilityList = appsVisibilityList;
            this.changedFields = changedFields.add("appsVisibilityList");
            return this;
        }

        /**
         * <i>“List of apps in the visibility list (either visible/launchable apps list or
         * hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3
         * and later). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param appsVisibilityList
         *            value of {@code appsVisibilityList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsVisibilityList(AppListItem... appsVisibilityList) {
            return appsVisibilityList(Arrays.asList(appsVisibilityList));
        }

        /**
         * <i>“List of apps in the visibility list (either visible/launchable apps list or
         * hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3
         * and later). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param appsVisibilityListNextLink
         *            value of {@code appsVisibilityList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsVisibilityListNextLink(String appsVisibilityListNextLink) {
            this.appsVisibilityListNextLink = appsVisibilityListNextLink;
            this.changedFields = changedFields.add("appsVisibilityList");
            return this;
        }

        /**
         * <i>“Type of list that is in the AppsVisibilityList.”</i>
         * 
         * @param appsVisibilityListType
         *            value of {@code appsVisibilityListType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsVisibilityListType(AppListType appsVisibilityListType) {
            this.appsVisibilityListType = appsVisibilityListType;
            this.changedFields = changedFields.add("appsVisibilityListType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the automatic downloading of apps purchased on
         * other devices when the device is in supervised mode (iOS 9.0 and later).”</i>
         * 
         * @param appStoreBlockAutomaticDownloads
         *            value of {@code appStoreBlockAutomaticDownloads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreBlockAutomaticDownloads(Boolean appStoreBlockAutomaticDownloads) {
            this.appStoreBlockAutomaticDownloads = appStoreBlockAutomaticDownloads;
            this.changedFields = changedFields.add("appStoreBlockAutomaticDownloads");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using the App Store. Requires a
         * supervised device for iOS 13 and later.”</i>
         * 
         * @param appStoreBlocked
         *            value of {@code appStoreBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreBlocked(Boolean appStoreBlocked) {
            this.appStoreBlocked = appStoreBlocked;
            this.changedFields = changedFields.add("appStoreBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from making in app purchases.”</i>
         * 
         * @param appStoreBlockInAppPurchases
         *            value of {@code appStoreBlockInAppPurchases} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreBlockInAppPurchases(Boolean appStoreBlockInAppPurchases) {
            this.appStoreBlockInAppPurchases = appStoreBlockInAppPurchases;
            this.changedFields = changedFields.add("appStoreBlockInAppPurchases");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the App Store app, not restricting
         * installation through Host apps. Applies to supervised mode only (iOS 9.0 and
         * later).”</i>
         * 
         * @param appStoreBlockUIAppInstallation
         *            value of {@code appStoreBlockUIAppInstallation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreBlockUIAppInstallation(Boolean appStoreBlockUIAppInstallation) {
            this.appStoreBlockUIAppInstallation = appStoreBlockUIAppInstallation;
            this.changedFields = changedFields.add("appStoreBlockUIAppInstallation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a password when using the app store.”</i>
         * 
         * @param appStoreRequirePassword
         *            value of {@code appStoreRequirePassword} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreRequirePassword(Boolean appStoreRequirePassword) {
            this.appStoreRequirePassword = appStoreRequirePassword;
            this.changedFields = changedFields.add("appStoreRequirePassword");
            return this;
        }

        /**
         * <i>“Indicates whether or not to force user authentication before autofilling
         * passwords and credit card information in Safari and other apps on supervised
         * devices.”</i>
         * 
         * @param autoFillForceAuthentication
         *            value of {@code autoFillForceAuthentication} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoFillForceAuthentication(Boolean autoFillForceAuthentication) {
            this.autoFillForceAuthentication = autoFillForceAuthentication;
            this.changedFields = changedFields.add("autoFillForceAuthentication");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow modification of Bluetooth settings when the
         * device is in supervised mode (iOS 10.0 and later).”</i>
         * 
         * @param bluetoothBlockModification
         *            value of {@code bluetoothBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockModification(Boolean bluetoothBlockModification) {
            this.bluetoothBlockModification = bluetoothBlockModification;
            this.changedFields = changedFields.add("bluetoothBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from accessing the camera of the
         * device. Requires a supervised device for iOS 13 and later.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block data roaming.”</i>
         * 
         * @param cellularBlockDataRoaming
         *            value of {@code cellularBlockDataRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockDataRoaming(Boolean cellularBlockDataRoaming) {
            this.cellularBlockDataRoaming = cellularBlockDataRoaming;
            this.changedFields = changedFields.add("cellularBlockDataRoaming");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block global background fetch while roaming.”</i>
         * 
         * @param cellularBlockGlobalBackgroundFetchWhileRoaming
         *            value of {@code cellularBlockGlobalBackgroundFetchWhileRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockGlobalBackgroundFetchWhileRoaming(Boolean cellularBlockGlobalBackgroundFetchWhileRoaming) {
            this.cellularBlockGlobalBackgroundFetchWhileRoaming = cellularBlockGlobalBackgroundFetchWhileRoaming;
            this.changedFields = changedFields.add("cellularBlockGlobalBackgroundFetchWhileRoaming");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow changes to cellular app data usage settings
         * when the device is in supervised mode.”</i>
         * 
         * @param cellularBlockPerAppDataModification
         *            value of {@code cellularBlockPerAppDataModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockPerAppDataModification(Boolean cellularBlockPerAppDataModification) {
            this.cellularBlockPerAppDataModification = cellularBlockPerAppDataModification;
            this.changedFields = changedFields.add("cellularBlockPerAppDataModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Personal Hotspot.”</i>
         * 
         * @param cellularBlockPersonalHotspot
         *            value of {@code cellularBlockPersonalHotspot} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockPersonalHotspot(Boolean cellularBlockPersonalHotspot) {
            this.cellularBlockPersonalHotspot = cellularBlockPersonalHotspot;
            this.changedFields = changedFields.add("cellularBlockPersonalHotspot");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow users to change the settings of the cellular
         * plan on a supervised device.”</i>
         * 
         * @param cellularBlockPlanModification
         *            value of {@code cellularBlockPlanModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockPlanModification(Boolean cellularBlockPlanModification) {
            this.cellularBlockPlanModification = cellularBlockPlanModification;
            this.changedFields = changedFields.add("cellularBlockPlanModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block voice roaming.”</i>
         * 
         * @param cellularBlockVoiceRoaming
         *            value of {@code cellularBlockVoiceRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockVoiceRoaming(Boolean cellularBlockVoiceRoaming) {
            this.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
            this.changedFields = changedFields.add("cellularBlockVoiceRoaming");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block untrusted TLS certificates.”</i>
         * 
         * @param certificatesBlockUntrustedTlsCertificates
         *            value of {@code certificatesBlockUntrustedTlsCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificatesBlockUntrustedTlsCertificates(Boolean certificatesBlockUntrustedTlsCertificates) {
            this.certificatesBlockUntrustedTlsCertificates = certificatesBlockUntrustedTlsCertificates;
            this.changedFields = changedFields.add("certificatesBlockUntrustedTlsCertificates");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow remote screen observation by Classroom app
         * when the device is in supervised mode (iOS 9.3 and later).”</i>
         * 
         * @param classroomAppBlockRemoteScreenObservation
         *            value of {@code classroomAppBlockRemoteScreenObservation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomAppBlockRemoteScreenObservation(Boolean classroomAppBlockRemoteScreenObservation) {
            this.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
            this.changedFields = changedFields.add("classroomAppBlockRemoteScreenObservation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to automatically give permission to the teacher of a
         * managed course on the Classroom app to view a student's screen without prompting
         * when the device is in supervised mode.”</i>
         * 
         * @param classroomAppForceUnpromptedScreenObservation
         *            value of {@code classroomAppForceUnpromptedScreenObservation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomAppForceUnpromptedScreenObservation(Boolean classroomAppForceUnpromptedScreenObservation) {
            this.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
            this.changedFields = changedFields.add("classroomAppForceUnpromptedScreenObservation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to automatically give permission to the teacher's
         * requests, without prompting the student, when the device is in supervised mode.”</i>
         * 
         * @param classroomForceAutomaticallyJoinClasses
         *            value of {@code classroomForceAutomaticallyJoinClasses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomForceAutomaticallyJoinClasses(Boolean classroomForceAutomaticallyJoinClasses) {
            this.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
            this.changedFields = changedFields.add("classroomForceAutomaticallyJoinClasses");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the teacher to lock apps or the device without
         * prompting the student. Supervised only.”</i>
         * 
         * @param classroomForceUnpromptedAppAndDeviceLock
         *            value of {@code classroomForceUnpromptedAppAndDeviceLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomForceUnpromptedAppAndDeviceLock(Boolean classroomForceUnpromptedAppAndDeviceLock) {
            this.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
            this.changedFields = changedFields.add("classroomForceUnpromptedAppAndDeviceLock");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(List<AppListItem> compliantAppsList) {
            this.compliantAppsList = compliantAppsList;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(AppListItem... compliantAppsList) {
            return compliantAppsList(Arrays.asList(compliantAppsList));
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsListNextLink
         *            value of {@code compliantAppsList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsListNextLink(String compliantAppsListNextLink) {
            this.compliantAppsListNextLink = compliantAppsListNextLink;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“List that is in the AppComplianceList.”</i>
         * 
         * @param compliantAppListType
         *            value of {@code compliantAppListType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppListType(AppListType compliantAppListType) {
            this.compliantAppListType = compliantAppListType;
            this.changedFields = changedFields.add("compliantAppListType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from installing configuration
         * profiles and certificates interactively when the device is in supervised mode.”</i>
         * 
         * @param configurationProfileBlockChanges
         *            value of {@code configurationProfileBlockChanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationProfileBlockChanges(Boolean configurationProfileBlockChanges) {
            this.configurationProfileBlockChanges = configurationProfileBlockChanges;
            this.changedFields = changedFields.add("configurationProfileBlockChanges");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block definition lookup when the device is in
         * supervised mode (iOS 8.1.3 and later ).”</i>
         * 
         * @param definitionLookupBlocked
         *            value of {@code definitionLookupBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder definitionLookupBlocked(Boolean definitionLookupBlocked) {
            this.definitionLookupBlocked = definitionLookupBlocked;
            this.changedFields = changedFields.add("definitionLookupBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the user to enables restrictions in the device
         * settings when the device is in supervised mode.”</i>
         * 
         * @param deviceBlockEnableRestrictions
         *            value of {@code deviceBlockEnableRestrictions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceBlockEnableRestrictions(Boolean deviceBlockEnableRestrictions) {
            this.deviceBlockEnableRestrictions = deviceBlockEnableRestrictions;
            this.changedFields = changedFields.add("deviceBlockEnableRestrictions");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the use of the 'Erase all content and settings
         * ' option on the device when the device is in supervised mode.”</i>
         * 
         * @param deviceBlockEraseContentAndSettings
         *            value of {@code deviceBlockEraseContentAndSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceBlockEraseContentAndSettings(Boolean deviceBlockEraseContentAndSettings) {
            this.deviceBlockEraseContentAndSettings = deviceBlockEraseContentAndSettings;
            this.changedFields = changedFields.add("deviceBlockEraseContentAndSettings");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow device name modification when the device is in
         * supervised mode (iOS 9.0 and later).”</i>
         * 
         * @param deviceBlockNameModification
         *            value of {@code deviceBlockNameModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceBlockNameModification(Boolean deviceBlockNameModification) {
            this.deviceBlockNameModification = deviceBlockNameModification;
            this.changedFields = changedFields.add("deviceBlockNameModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block diagnostic data submission.”</i>
         * 
         * @param diagnosticDataBlockSubmission
         *            value of {@code diagnosticDataBlockSubmission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticDataBlockSubmission(Boolean diagnosticDataBlockSubmission) {
            this.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
            this.changedFields = changedFields.add("diagnosticDataBlockSubmission");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow diagnostics submission settings modification
         * when the device is in supervised mode (iOS 9.3.2 and later).”</i>
         * 
         * @param diagnosticDataBlockSubmissionModification
         *            value of {@code diagnosticDataBlockSubmissionModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticDataBlockSubmissionModification(Boolean diagnosticDataBlockSubmissionModification) {
            this.diagnosticDataBlockSubmissionModification = diagnosticDataBlockSubmissionModification;
            this.changedFields = changedFields.add("diagnosticDataBlockSubmissionModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from viewing managed documents in
         * unmanaged apps.”</i>
         * 
         * @param documentsBlockManagedDocumentsInUnmanagedApps
         *            value of {@code documentsBlockManagedDocumentsInUnmanagedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder documentsBlockManagedDocumentsInUnmanagedApps(Boolean documentsBlockManagedDocumentsInUnmanagedApps) {
            this.documentsBlockManagedDocumentsInUnmanagedApps = documentsBlockManagedDocumentsInUnmanagedApps;
            this.changedFields = changedFields.add("documentsBlockManagedDocumentsInUnmanagedApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from viewing unmanaged documents in
         * managed apps.”</i>
         * 
         * @param documentsBlockUnmanagedDocumentsInManagedApps
         *            value of {@code documentsBlockUnmanagedDocumentsInManagedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder documentsBlockUnmanagedDocumentsInManagedApps(Boolean documentsBlockUnmanagedDocumentsInManagedApps) {
            this.documentsBlockUnmanagedDocumentsInManagedApps = documentsBlockUnmanagedDocumentsInManagedApps;
            this.changedFields = changedFields.add("documentsBlockUnmanagedDocumentsInManagedApps");
            return this;
        }

        /**
         * <i>“An email address lacking a suffix that matches any of these strings will be
         * considered out-of-domain.”</i>
         * 
         * @param emailInDomainSuffixes
         *            value of {@code emailInDomainSuffixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailInDomainSuffixes(List<String> emailInDomainSuffixes) {
            this.emailInDomainSuffixes = emailInDomainSuffixes;
            this.changedFields = changedFields.add("emailInDomainSuffixes");
            return this;
        }

        /**
         * <i>“An email address lacking a suffix that matches any of these strings will be
         * considered out-of-domain.”</i>
         * 
         * @param emailInDomainSuffixes
         *            value of {@code emailInDomainSuffixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailInDomainSuffixes(String... emailInDomainSuffixes) {
            return emailInDomainSuffixes(Arrays.asList(emailInDomainSuffixes));
        }

        /**
         * <i>“An email address lacking a suffix that matches any of these strings will be
         * considered out-of-domain.”</i>
         * 
         * @param emailInDomainSuffixesNextLink
         *            value of {@code emailInDomainSuffixes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailInDomainSuffixesNextLink(String emailInDomainSuffixesNextLink) {
            this.emailInDomainSuffixesNextLink = emailInDomainSuffixesNextLink;
            this.changedFields = changedFields.add("emailInDomainSuffixes");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from trusting an enterprise app.”</i>
         * 
         * @param enterpriseAppBlockTrust
         *            value of {@code enterpriseAppBlockTrust} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseAppBlockTrust(Boolean enterpriseAppBlockTrust) {
            this.enterpriseAppBlockTrust = enterpriseAppBlockTrust;
            this.changedFields = changedFields.add("enterpriseAppBlockTrust");
            return this;
        }

        /**
         * <i>“[Deprecated] Configuring this setting and setting the value to 'true' has no
         * effect on the device.”</i>
         * 
         * @param enterpriseAppBlockTrustModification
         *            value of {@code enterpriseAppBlockTrustModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseAppBlockTrustModification(Boolean enterpriseAppBlockTrustModification) {
            this.enterpriseAppBlockTrustModification = enterpriseAppBlockTrustModification;
            this.changedFields = changedFields.add("enterpriseAppBlockTrustModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the addition or removal of cellular plans on
         * the eSIM of a supervised device.”</i>
         * 
         * @param esimBlockModification
         *            value of {@code esimBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder esimBlockModification(Boolean esimBlockModification) {
            this.esimBlockModification = esimBlockModification;
            this.changedFields = changedFields.add("esimBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using FaceTime. Requires a
         * supervised device for iOS 13 and later.”</i>
         * 
         * @param faceTimeBlocked
         *            value of {@code faceTimeBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder faceTimeBlocked(Boolean faceTimeBlocked) {
            this.faceTimeBlocked = faceTimeBlocked;
            this.changedFields = changedFields.add("faceTimeBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block changes to Find My Friends when the device is
         * in supervised mode.”</i>
         * 
         * @param findMyFriendsBlocked
         *            value of {@code findMyFriendsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder findMyFriendsBlocked(Boolean findMyFriendsBlocked) {
            this.findMyFriendsBlocked = findMyFriendsBlocked;
            this.changedFields = changedFields.add("findMyFriendsBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from having friends in Game Center.
         * Requires a supervised device for iOS 13 and later.”</i>
         * 
         * @param gamingBlockGameCenterFriends
         *            value of {@code gamingBlockGameCenterFriends} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder gamingBlockGameCenterFriends(Boolean gamingBlockGameCenterFriends) {
            this.gamingBlockGameCenterFriends = gamingBlockGameCenterFriends;
            this.changedFields = changedFields.add("gamingBlockGameCenterFriends");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using multiplayer gaming.
         * Requires a supervised device for iOS 13 and later.”</i>
         * 
         * @param gamingBlockMultiplayer
         *            value of {@code gamingBlockMultiplayer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder gamingBlockMultiplayer(Boolean gamingBlockMultiplayer) {
            this.gamingBlockMultiplayer = gamingBlockMultiplayer;
            this.changedFields = changedFields.add("gamingBlockMultiplayer");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using Game Center when the
         * device is in supervised mode.”</i>
         * 
         * @param gameCenterBlocked
         *            value of {@code gameCenterBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder gameCenterBlocked(Boolean gameCenterBlocked) {
            this.gameCenterBlocked = gameCenterBlocked;
            this.changedFields = changedFields.add("gameCenterBlocked");
            return this;
        }

        /**
         * <i>“indicates whether or not to allow host pairing to control the devices an iOS
         * device can pair with when the iOS device is in supervised mode.”</i>
         * 
         * @param hostPairingBlocked
         *            value of {@code hostPairingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hostPairingBlocked(Boolean hostPairingBlocked) {
            this.hostPairingBlocked = hostPairingBlocked;
            this.changedFields = changedFields.add("hostPairingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using the iBooks Store when the
         * device is in supervised mode.”</i>
         * 
         * @param iBooksStoreBlocked
         *            value of {@code iBooksStoreBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iBooksStoreBlocked(Boolean iBooksStoreBlocked) {
            this.iBooksStoreBlocked = iBooksStoreBlocked;
            this.changedFields = changedFields.add("iBooksStoreBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from downloading media from the
         * iBookstore that has been tagged as erotica.”</i>
         * 
         * @param iBooksStoreBlockErotica
         *            value of {@code iBooksStoreBlockErotica} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iBooksStoreBlockErotica(Boolean iBooksStoreBlockErotica) {
            this.iBooksStoreBlockErotica = iBooksStoreBlockErotica;
            this.changedFields = changedFields.add("iBooksStoreBlockErotica");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from continuing work they started on
         * iOS device to another iOS or macOS device.”</i>
         * 
         * @param iCloudBlockActivityContinuation
         *            value of {@code iCloudBlockActivityContinuation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockActivityContinuation(Boolean iCloudBlockActivityContinuation) {
            this.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
            this.changedFields = changedFields.add("iCloudBlockActivityContinuation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud backup. Requires a supervised device
         * for iOS 13 and later.”</i>
         * 
         * @param iCloudBlockBackup
         *            value of {@code iCloudBlockBackup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockBackup(Boolean iCloudBlockBackup) {
            this.iCloudBlockBackup = iCloudBlockBackup;
            this.changedFields = changedFields.add("iCloudBlockBackup");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud document sync. Requires a supervised
         * device for iOS 13 and later.”</i>
         * 
         * @param iCloudBlockDocumentSync
         *            value of {@code iCloudBlockDocumentSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockDocumentSync(Boolean iCloudBlockDocumentSync) {
            this.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
            this.changedFields = changedFields.add("iCloudBlockDocumentSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Managed Apps Cloud Sync.”</i>
         * 
         * @param iCloudBlockManagedAppsSync
         *            value of {@code iCloudBlockManagedAppsSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockManagedAppsSync(Boolean iCloudBlockManagedAppsSync) {
            this.iCloudBlockManagedAppsSync = iCloudBlockManagedAppsSync;
            this.changedFields = changedFields.add("iCloudBlockManagedAppsSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud Photo Library.”</i>
         * 
         * @param iCloudBlockPhotoLibrary
         *            value of {@code iCloudBlockPhotoLibrary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockPhotoLibrary(Boolean iCloudBlockPhotoLibrary) {
            this.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
            this.changedFields = changedFields.add("iCloudBlockPhotoLibrary");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block iCloud Photo Stream Sync.”</i>
         * 
         * @param iCloudBlockPhotoStreamSync
         *            value of {@code iCloudBlockPhotoStreamSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockPhotoStreamSync(Boolean iCloudBlockPhotoStreamSync) {
            this.iCloudBlockPhotoStreamSync = iCloudBlockPhotoStreamSync;
            this.changedFields = changedFields.add("iCloudBlockPhotoStreamSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Shared Photo Stream.”</i>
         * 
         * @param iCloudBlockSharedPhotoStream
         *            value of {@code iCloudBlockSharedPhotoStream} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudBlockSharedPhotoStream(Boolean iCloudBlockSharedPhotoStream) {
            this.iCloudBlockSharedPhotoStream = iCloudBlockSharedPhotoStream;
            this.changedFields = changedFields.add("iCloudBlockSharedPhotoStream");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require backups to iCloud be encrypted.”</i>
         * 
         * @param iCloudRequireEncryptedBackup
         *            value of {@code iCloudRequireEncryptedBackup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iCloudRequireEncryptedBackup(Boolean iCloudRequireEncryptedBackup) {
            this.iCloudRequireEncryptedBackup = iCloudRequireEncryptedBackup;
            this.changedFields = changedFields.add("iCloudRequireEncryptedBackup");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from accessing explicit content in
         * iTunes and the App Store. Requires a supervised device for iOS 13 and later.”</i>
         * 
         * @param iTunesBlockExplicitContent
         *            value of {@code iTunesBlockExplicitContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesBlockExplicitContent(Boolean iTunesBlockExplicitContent) {
            this.iTunesBlockExplicitContent = iTunesBlockExplicitContent;
            this.changedFields = changedFields.add("iTunesBlockExplicitContent");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Music service and revert Music app to classic
         * mode when the device is in supervised mode (iOS 9.3 and later and macOS 10.12
         * and later).”</i>
         * 
         * @param iTunesBlockMusicService
         *            value of {@code iTunesBlockMusicService} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesBlockMusicService(Boolean iTunesBlockMusicService) {
            this.iTunesBlockMusicService = iTunesBlockMusicService;
            this.changedFields = changedFields.add("iTunesBlockMusicService");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using iTunes Radio when the
         * device is in supervised mode (iOS 9.3 and later).”</i>
         * 
         * @param iTunesBlockRadio
         *            value of {@code iTunesBlockRadio} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesBlockRadio(Boolean iTunesBlockRadio) {
            this.iTunesBlockRadio = iTunesBlockRadio;
            this.changedFields = changedFields.add("iTunesBlockRadio");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block keyboard auto-correction when the device is in
         * supervised mode (iOS 8.1.3 and later).”</i>
         * 
         * @param keyboardBlockAutoCorrect
         *            value of {@code keyboardBlockAutoCorrect} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardBlockAutoCorrect(Boolean keyboardBlockAutoCorrect) {
            this.keyboardBlockAutoCorrect = keyboardBlockAutoCorrect;
            this.changedFields = changedFields.add("keyboardBlockAutoCorrect");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using dictation input when the
         * device is in supervised mode.”</i>
         * 
         * @param keyboardBlockDictation
         *            value of {@code keyboardBlockDictation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardBlockDictation(Boolean keyboardBlockDictation) {
            this.keyboardBlockDictation = keyboardBlockDictation;
            this.changedFields = changedFields.add("keyboardBlockDictation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block predictive keyboards when device is in
         * supervised mode (iOS 8.1.3 and later).”</i>
         * 
         * @param keyboardBlockPredictive
         *            value of {@code keyboardBlockPredictive} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardBlockPredictive(Boolean keyboardBlockPredictive) {
            this.keyboardBlockPredictive = keyboardBlockPredictive;
            this.changedFields = changedFields.add("keyboardBlockPredictive");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block keyboard shortcuts when the device is in
         * supervised mode (iOS 9.0 and later).”</i>
         * 
         * @param keyboardBlockShortcuts
         *            value of {@code keyboardBlockShortcuts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardBlockShortcuts(Boolean keyboardBlockShortcuts) {
            this.keyboardBlockShortcuts = keyboardBlockShortcuts;
            this.changedFields = changedFields.add("keyboardBlockShortcuts");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block keyboard spell-checking when the device is in
         * supervised mode (iOS 8.1.3 and later).”</i>
         * 
         * @param keyboardBlockSpellCheck
         *            value of {@code keyboardBlockSpellCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardBlockSpellCheck(Boolean keyboardBlockSpellCheck) {
            this.keyboardBlockSpellCheck = keyboardBlockSpellCheck;
            this.changedFields = changedFields.add("keyboardBlockSpellCheck");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow assistive speak while in kiosk mode.”</i>
         * 
         * @param kioskModeAllowAssistiveSpeak
         *            value of {@code kioskModeAllowAssistiveSpeak} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowAssistiveSpeak(Boolean kioskModeAllowAssistiveSpeak) {
            this.kioskModeAllowAssistiveSpeak = kioskModeAllowAssistiveSpeak;
            this.changedFields = changedFields.add("kioskModeAllowAssistiveSpeak");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow access to the Assistive Touch Settings while
         * in kiosk mode.”</i>
         * 
         * @param kioskModeAllowAssistiveTouchSettings
         *            value of {@code kioskModeAllowAssistiveTouchSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowAssistiveTouchSettings(Boolean kioskModeAllowAssistiveTouchSettings) {
            this.kioskModeAllowAssistiveTouchSettings = kioskModeAllowAssistiveTouchSettings;
            this.changedFields = changedFields.add("kioskModeAllowAssistiveTouchSettings");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow device auto lock while in kiosk mode. This
         * property's functionality is redundant with the OS default and is deprecated. Use
         * KioskModeBlockAutoLock instead.”</i>
         * 
         * @param kioskModeAllowAutoLock
         *            value of {@code kioskModeAllowAutoLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowAutoLock(Boolean kioskModeAllowAutoLock) {
            this.kioskModeAllowAutoLock = kioskModeAllowAutoLock;
            this.changedFields = changedFields.add("kioskModeAllowAutoLock");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block device auto lock while in kiosk mode.”</i>
         * 
         * @param kioskModeBlockAutoLock
         *            value of {@code kioskModeBlockAutoLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockAutoLock(Boolean kioskModeBlockAutoLock) {
            this.kioskModeBlockAutoLock = kioskModeBlockAutoLock;
            this.changedFields = changedFields.add("kioskModeBlockAutoLock");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow access to the Color Inversion Settings while
         * in kiosk mode.”</i>
         * 
         * @param kioskModeAllowColorInversionSettings
         *            value of {@code kioskModeAllowColorInversionSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowColorInversionSettings(Boolean kioskModeAllowColorInversionSettings) {
            this.kioskModeAllowColorInversionSettings = kioskModeAllowColorInversionSettings;
            this.changedFields = changedFields.add("kioskModeAllowColorInversionSettings");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow use of the ringer switch while in kiosk mode.
         * This property's functionality is redundant with the OS default and is deprecated
         * . Use KioskModeBlockRingerSwitch instead.”</i>
         * 
         * @param kioskModeAllowRingerSwitch
         *            value of {@code kioskModeAllowRingerSwitch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowRingerSwitch(Boolean kioskModeAllowRingerSwitch) {
            this.kioskModeAllowRingerSwitch = kioskModeAllowRingerSwitch;
            this.changedFields = changedFields.add("kioskModeAllowRingerSwitch");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block use of the ringer switch while in kiosk mode.”</i>
         * 
         * @param kioskModeBlockRingerSwitch
         *            value of {@code kioskModeBlockRingerSwitch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockRingerSwitch(Boolean kioskModeBlockRingerSwitch) {
            this.kioskModeBlockRingerSwitch = kioskModeBlockRingerSwitch;
            this.changedFields = changedFields.add("kioskModeBlockRingerSwitch");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow screen rotation while in kiosk mode. This
         * property's functionality is redundant with the OS default and is deprecated. Use
         * KioskModeBlockScreenRotation instead.”</i>
         * 
         * @param kioskModeAllowScreenRotation
         *            value of {@code kioskModeAllowScreenRotation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowScreenRotation(Boolean kioskModeAllowScreenRotation) {
            this.kioskModeAllowScreenRotation = kioskModeAllowScreenRotation;
            this.changedFields = changedFields.add("kioskModeAllowScreenRotation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block screen rotation while in kiosk mode.”</i>
         * 
         * @param kioskModeBlockScreenRotation
         *            value of {@code kioskModeBlockScreenRotation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockScreenRotation(Boolean kioskModeBlockScreenRotation) {
            this.kioskModeBlockScreenRotation = kioskModeBlockScreenRotation;
            this.changedFields = changedFields.add("kioskModeBlockScreenRotation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow use of the sleep button while in kiosk mode.
         * This property's functionality is redundant with the OS default and is deprecated
         * . Use KioskModeBlockSleepButton instead.”</i>
         * 
         * @param kioskModeAllowSleepButton
         *            value of {@code kioskModeAllowSleepButton} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowSleepButton(Boolean kioskModeAllowSleepButton) {
            this.kioskModeAllowSleepButton = kioskModeAllowSleepButton;
            this.changedFields = changedFields.add("kioskModeAllowSleepButton");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block use of the sleep button while in kiosk mode.”</i>
         * 
         * @param kioskModeBlockSleepButton
         *            value of {@code kioskModeBlockSleepButton} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockSleepButton(Boolean kioskModeBlockSleepButton) {
            this.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
            this.changedFields = changedFields.add("kioskModeBlockSleepButton");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow use of the touchscreen while in kiosk mode.
         * This property's functionality is redundant with the OS default and is deprecated
         * . Use KioskModeBlockTouchscreen instead.”</i>
         * 
         * @param kioskModeAllowTouchscreen
         *            value of {@code kioskModeAllowTouchscreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowTouchscreen(Boolean kioskModeAllowTouchscreen) {
            this.kioskModeAllowTouchscreen = kioskModeAllowTouchscreen;
            this.changedFields = changedFields.add("kioskModeAllowTouchscreen");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block use of the touchscreen while in kiosk mode.”</i>
         * 
         * @param kioskModeBlockTouchscreen
         *            value of {@code kioskModeBlockTouchscreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockTouchscreen(Boolean kioskModeBlockTouchscreen) {
            this.kioskModeBlockTouchscreen = kioskModeBlockTouchscreen;
            this.changedFields = changedFields.add("kioskModeBlockTouchscreen");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enable voice control in kiosk mode.”</i>
         * 
         * @param kioskModeEnableVoiceControl
         *            value of {@code kioskModeEnableVoiceControl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeEnableVoiceControl(Boolean kioskModeEnableVoiceControl) {
            this.kioskModeEnableVoiceControl = kioskModeEnableVoiceControl;
            this.changedFields = changedFields.add("kioskModeEnableVoiceControl");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the user to toggle voice control in kiosk mode
         * .”</i>
         * 
         * @param kioskModeAllowVoiceControlModification
         *            value of {@code kioskModeAllowVoiceControlModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowVoiceControlModification(Boolean kioskModeAllowVoiceControlModification) {
            this.kioskModeAllowVoiceControlModification = kioskModeAllowVoiceControlModification;
            this.changedFields = changedFields.add("kioskModeAllowVoiceControlModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow access to the voice over settings while in
         * kiosk mode.”</i>
         * 
         * @param kioskModeAllowVoiceOverSettings
         *            value of {@code kioskModeAllowVoiceOverSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowVoiceOverSettings(Boolean kioskModeAllowVoiceOverSettings) {
            this.kioskModeAllowVoiceOverSettings = kioskModeAllowVoiceOverSettings;
            this.changedFields = changedFields.add("kioskModeAllowVoiceOverSettings");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow use of the volume buttons while in kiosk mode.
         * This property's functionality is redundant with the OS default and is deprecated
         * . Use KioskModeBlockVolumeButtons instead.”</i>
         * 
         * @param kioskModeAllowVolumeButtons
         *            value of {@code kioskModeAllowVolumeButtons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowVolumeButtons(Boolean kioskModeAllowVolumeButtons) {
            this.kioskModeAllowVolumeButtons = kioskModeAllowVolumeButtons;
            this.changedFields = changedFields.add("kioskModeAllowVolumeButtons");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the volume buttons while in Kiosk Mode.”</i>
         * 
         * @param kioskModeBlockVolumeButtons
         *            value of {@code kioskModeBlockVolumeButtons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockVolumeButtons(Boolean kioskModeBlockVolumeButtons) {
            this.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
            this.changedFields = changedFields.add("kioskModeBlockVolumeButtons");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow access to the zoom settings while in kiosk
         * mode.”</i>
         * 
         * @param kioskModeAllowZoomSettings
         *            value of {@code kioskModeAllowZoomSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAllowZoomSettings(Boolean kioskModeAllowZoomSettings) {
            this.kioskModeAllowZoomSettings = kioskModeAllowZoomSettings;
            this.changedFields = changedFields.add("kioskModeAllowZoomSettings");
            return this;
        }

        /**
         * <i>“URL in the app store to the app to use for kiosk mode. Use if
         * KioskModeManagedAppId is not known.”</i>
         * 
         * @param kioskModeAppStoreUrl
         *            value of {@code kioskModeAppStoreUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAppStoreUrl(String kioskModeAppStoreUrl) {
            this.kioskModeAppStoreUrl = kioskModeAppStoreUrl;
            this.changedFields = changedFields.add("kioskModeAppStoreUrl");
            return this;
        }

        /**
         * <i>“ID for built-in apps to use for kiosk mode. Used when KioskModeManagedAppId and
         * KioskModeAppStoreUrl are not set.”</i>
         * 
         * @param kioskModeBuiltInAppId
         *            value of {@code kioskModeBuiltInAppId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBuiltInAppId(String kioskModeBuiltInAppId) {
            this.kioskModeBuiltInAppId = kioskModeBuiltInAppId;
            this.changedFields = changedFields.add("kioskModeBuiltInAppId");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require assistive touch while in kiosk mode.”</i>
         * 
         * @param kioskModeRequireAssistiveTouch
         *            value of {@code kioskModeRequireAssistiveTouch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeRequireAssistiveTouch(Boolean kioskModeRequireAssistiveTouch) {
            this.kioskModeRequireAssistiveTouch = kioskModeRequireAssistiveTouch;
            this.changedFields = changedFields.add("kioskModeRequireAssistiveTouch");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require color inversion while in kiosk mode.”</i>
         * 
         * @param kioskModeRequireColorInversion
         *            value of {@code kioskModeRequireColorInversion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeRequireColorInversion(Boolean kioskModeRequireColorInversion) {
            this.kioskModeRequireColorInversion = kioskModeRequireColorInversion;
            this.changedFields = changedFields.add("kioskModeRequireColorInversion");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require mono audio while in kiosk mode.”</i>
         * 
         * @param kioskModeRequireMonoAudio
         *            value of {@code kioskModeRequireMonoAudio} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeRequireMonoAudio(Boolean kioskModeRequireMonoAudio) {
            this.kioskModeRequireMonoAudio = kioskModeRequireMonoAudio;
            this.changedFields = changedFields.add("kioskModeRequireMonoAudio");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require voice over while in kiosk mode.”</i>
         * 
         * @param kioskModeRequireVoiceOver
         *            value of {@code kioskModeRequireVoiceOver} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeRequireVoiceOver(Boolean kioskModeRequireVoiceOver) {
            this.kioskModeRequireVoiceOver = kioskModeRequireVoiceOver;
            this.changedFields = changedFields.add("kioskModeRequireVoiceOver");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require zoom while in kiosk mode.”</i>
         * 
         * @param kioskModeRequireZoom
         *            value of {@code kioskModeRequireZoom} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeRequireZoom(Boolean kioskModeRequireZoom) {
            this.kioskModeRequireZoom = kioskModeRequireZoom;
            this.changedFields = changedFields.add("kioskModeRequireZoom");
            return this;
        }

        /**
         * <i>“Managed app id of the app to use for kiosk mode. If KioskModeManagedAppId is
         * specified then KioskModeAppStoreUrl will be ignored.”</i>
         * 
         * @param kioskModeManagedAppId
         *            value of {@code kioskModeManagedAppId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeManagedAppId(String kioskModeManagedAppId) {
            this.kioskModeManagedAppId = kioskModeManagedAppId;
            this.changedFields = changedFields.add("kioskModeManagedAppId");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using control center on the lock
         * screen.”</i>
         * 
         * @param lockScreenBlockControlCenter
         *            value of {@code lockScreenBlockControlCenter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockControlCenter(Boolean lockScreenBlockControlCenter) {
            this.lockScreenBlockControlCenter = lockScreenBlockControlCenter;
            this.changedFields = changedFields.add("lockScreenBlockControlCenter");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using the notification view on
         * the lock screen.”</i>
         * 
         * @param lockScreenBlockNotificationView
         *            value of {@code lockScreenBlockNotificationView} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockNotificationView(Boolean lockScreenBlockNotificationView) {
            this.lockScreenBlockNotificationView = lockScreenBlockNotificationView;
            this.changedFields = changedFields.add("lockScreenBlockNotificationView");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using passbook when the device
         * is locked.”</i>
         * 
         * @param lockScreenBlockPassbook
         *            value of {@code lockScreenBlockPassbook} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockPassbook(Boolean lockScreenBlockPassbook) {
            this.lockScreenBlockPassbook = lockScreenBlockPassbook;
            this.changedFields = changedFields.add("lockScreenBlockPassbook");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using the Today View on the lock
         * screen.”</i>
         * 
         * @param lockScreenBlockTodayView
         *            value of {@code lockScreenBlockTodayView} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockTodayView(Boolean lockScreenBlockTodayView) {
            this.lockScreenBlockTodayView = lockScreenBlockTodayView;
            this.changedFields = changedFields.add("lockScreenBlockTodayView");
            return this;
        }

        /**
         * <i>“Media content rating settings for Australia”</i>
         * 
         * @param mediaContentRatingAustralia
         *            value of {@code mediaContentRatingAustralia} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingAustralia(MediaContentRatingAustralia mediaContentRatingAustralia) {
            this.mediaContentRatingAustralia = mediaContentRatingAustralia;
            this.changedFields = changedFields.add("mediaContentRatingAustralia");
            return this;
        }

        /**
         * <i>“Media content rating settings for Canada”</i>
         * 
         * @param mediaContentRatingCanada
         *            value of {@code mediaContentRatingCanada} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingCanada(MediaContentRatingCanada mediaContentRatingCanada) {
            this.mediaContentRatingCanada = mediaContentRatingCanada;
            this.changedFields = changedFields.add("mediaContentRatingCanada");
            return this;
        }

        /**
         * <i>“Media content rating settings for France”</i>
         * 
         * @param mediaContentRatingFrance
         *            value of {@code mediaContentRatingFrance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingFrance(MediaContentRatingFrance mediaContentRatingFrance) {
            this.mediaContentRatingFrance = mediaContentRatingFrance;
            this.changedFields = changedFields.add("mediaContentRatingFrance");
            return this;
        }

        /**
         * <i>“Media content rating settings for Germany”</i>
         * 
         * @param mediaContentRatingGermany
         *            value of {@code mediaContentRatingGermany} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingGermany(MediaContentRatingGermany mediaContentRatingGermany) {
            this.mediaContentRatingGermany = mediaContentRatingGermany;
            this.changedFields = changedFields.add("mediaContentRatingGermany");
            return this;
        }

        /**
         * <i>“Media content rating settings for Ireland”</i>
         * 
         * @param mediaContentRatingIreland
         *            value of {@code mediaContentRatingIreland} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingIreland(MediaContentRatingIreland mediaContentRatingIreland) {
            this.mediaContentRatingIreland = mediaContentRatingIreland;
            this.changedFields = changedFields.add("mediaContentRatingIreland");
            return this;
        }

        /**
         * <i>“Media content rating settings for Japan”</i>
         * 
         * @param mediaContentRatingJapan
         *            value of {@code mediaContentRatingJapan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingJapan(MediaContentRatingJapan mediaContentRatingJapan) {
            this.mediaContentRatingJapan = mediaContentRatingJapan;
            this.changedFields = changedFields.add("mediaContentRatingJapan");
            return this;
        }

        /**
         * <i>“Media content rating settings for New Zealand”</i>
         * 
         * @param mediaContentRatingNewZealand
         *            value of {@code mediaContentRatingNewZealand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingNewZealand(MediaContentRatingNewZealand mediaContentRatingNewZealand) {
            this.mediaContentRatingNewZealand = mediaContentRatingNewZealand;
            this.changedFields = changedFields.add("mediaContentRatingNewZealand");
            return this;
        }

        /**
         * <i>“Media content rating settings for United Kingdom”</i>
         * 
         * @param mediaContentRatingUnitedKingdom
         *            value of {@code mediaContentRatingUnitedKingdom} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingUnitedKingdom(MediaContentRatingUnitedKingdom mediaContentRatingUnitedKingdom) {
            this.mediaContentRatingUnitedKingdom = mediaContentRatingUnitedKingdom;
            this.changedFields = changedFields.add("mediaContentRatingUnitedKingdom");
            return this;
        }

        /**
         * <i>“Media content rating settings for United States”</i>
         * 
         * @param mediaContentRatingUnitedStates
         *            value of {@code mediaContentRatingUnitedStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingUnitedStates(MediaContentRatingUnitedStates mediaContentRatingUnitedStates) {
            this.mediaContentRatingUnitedStates = mediaContentRatingUnitedStates;
            this.changedFields = changedFields.add("mediaContentRatingUnitedStates");
            return this;
        }

        /**
         * <i>“List of managed apps and the network rules that applies to them. This collection
         * can contain a maximum of 1000 elements.”</i>
         * 
         * @param networkUsageRules
         *            value of {@code networkUsageRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkUsageRules(List<IosNetworkUsageRule> networkUsageRules) {
            this.networkUsageRules = networkUsageRules;
            this.changedFields = changedFields.add("networkUsageRules");
            return this;
        }

        /**
         * <i>“List of managed apps and the network rules that applies to them. This collection
         * can contain a maximum of 1000 elements.”</i>
         * 
         * @param networkUsageRules
         *            value of {@code networkUsageRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkUsageRules(IosNetworkUsageRule... networkUsageRules) {
            return networkUsageRules(Arrays.asList(networkUsageRules));
        }

        /**
         * <i>“List of managed apps and the network rules that applies to them. This collection
         * can contain a maximum of 1000 elements.”</i>
         * 
         * @param networkUsageRulesNextLink
         *            value of {@code networkUsageRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkUsageRulesNextLink(String networkUsageRulesNextLink) {
            this.networkUsageRulesNextLink = networkUsageRulesNextLink;
            this.changedFields = changedFields.add("networkUsageRules");
            return this;
        }

        /**
         * <i>“Media content rating settings for Apps”</i>
         * 
         * @param mediaContentRatingApps
         *            value of {@code mediaContentRatingApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaContentRatingApps(RatingAppsType mediaContentRatingApps) {
            this.mediaContentRatingApps = mediaContentRatingApps;
            this.changedFields = changedFields.add("mediaContentRatingApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using the Messages app on the
         * supervised device.”</i>
         * 
         * @param messagesBlocked
         *            value of {@code messagesBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messagesBlocked(Boolean messagesBlocked) {
            this.messagesBlocked = messagesBlocked;
            this.changedFields = changedFields.add("messagesBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow notifications settings modification (iOS 9.3
         * and later).”</i>
         * 
         * @param notificationsBlockSettingsModification
         *            value of {@code notificationsBlockSettingsModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationsBlockSettingsModification(Boolean notificationsBlockSettingsModification) {
            this.notificationsBlockSettingsModification = notificationsBlockSettingsModification;
            this.changedFields = changedFields.add("notificationsBlockSettingsModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block fingerprint unlock.”</i>
         * 
         * @param passcodeBlockFingerprintUnlock
         *            value of {@code passcodeBlockFingerprintUnlock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeBlockFingerprintUnlock(Boolean passcodeBlockFingerprintUnlock) {
            this.passcodeBlockFingerprintUnlock = passcodeBlockFingerprintUnlock;
            this.changedFields = changedFields.add("passcodeBlockFingerprintUnlock");
            return this;
        }

        /**
         * <i>“Block modification of registered Touch ID fingerprints when in supervised mode.”</i>
         * 
         * @param passcodeBlockFingerprintModification
         *            value of {@code passcodeBlockFingerprintModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeBlockFingerprintModification(Boolean passcodeBlockFingerprintModification) {
            this.passcodeBlockFingerprintModification = passcodeBlockFingerprintModification;
            this.changedFields = changedFields.add("passcodeBlockFingerprintModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow passcode modification on the supervised device
         * (iOS 9.0 and later).”</i>
         * 
         * @param passcodeBlockModification
         *            value of {@code passcodeBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeBlockModification(Boolean passcodeBlockModification) {
            this.passcodeBlockModification = passcodeBlockModification;
            this.changedFields = changedFields.add("passcodeBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block simple passcodes.”</i>
         * 
         * @param passcodeBlockSimple
         *            value of {@code passcodeBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeBlockSimple(Boolean passcodeBlockSimple) {
            this.passcodeBlockSimple = passcodeBlockSimple;
            this.changedFields = changedFields.add("passcodeBlockSimple");
            return this;
        }

        /**
         * <i>“Number of days before the passcode expires. Valid values 1 to 65535”</i>
         * 
         * @param passcodeExpirationDays
         *            value of {@code passcodeExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeExpirationDays(Integer passcodeExpirationDays) {
            this.passcodeExpirationDays = passcodeExpirationDays;
            this.changedFields = changedFields.add("passcodeExpirationDays");
            return this;
        }

        /**
         * <i>“Minimum length of passcode. Valid values 4 to 14”</i>
         * 
         * @param passcodeMinimumLength
         *            value of {@code passcodeMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinimumLength(Integer passcodeMinimumLength) {
            this.passcodeMinimumLength = passcodeMinimumLength;
            this.changedFields = changedFields.add("passcodeMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a passcode is required.”</i>
         * 
         * @param passcodeMinutesOfInactivityBeforeLock
         *            value of {@code passcodeMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinutesOfInactivityBeforeLock(Integer passcodeMinutesOfInactivityBeforeLock) {
            this.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before the screen times out.”</i>
         * 
         * @param passcodeMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passcodeMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinutesOfInactivityBeforeScreenTimeout(Integer passcodeMinutesOfInactivityBeforeScreenTimeout) {
            this.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Number of character sets a passcode must contain. Valid values 0 to 4”</i>
         * 
         * @param passcodeMinimumCharacterSetCount
         *            value of {@code passcodeMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinimumCharacterSetCount(Integer passcodeMinimumCharacterSetCount) {
            this.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passcodeMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“Number of previous passcodes to block. Valid values 1 to 24”</i>
         * 
         * @param passcodePreviousPasscodeBlockCount
         *            value of {@code passcodePreviousPasscodeBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodePreviousPasscodeBlockCount(Integer passcodePreviousPasscodeBlockCount) {
            this.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
            this.changedFields = changedFields.add("passcodePreviousPasscodeBlockCount");
            return this;
        }

        /**
         * <i>“Number of sign in failures allowed before wiping the device. Valid values 4 to
         * 11”</i>
         * 
         * @param passcodeSignInFailureCountBeforeWipe
         *            value of {@code passcodeSignInFailureCountBeforeWipe} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeSignInFailureCountBeforeWipe(Integer passcodeSignInFailureCountBeforeWipe) {
            this.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
            this.changedFields = changedFields.add("passcodeSignInFailureCountBeforeWipe");
            return this;
        }

        /**
         * <i>“Type of passcode that is required.”</i>
         * 
         * @param passcodeRequiredType
         *            value of {@code passcodeRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeRequiredType(RequiredPasswordType passcodeRequiredType) {
            this.passcodeRequiredType = passcodeRequiredType;
            this.changedFields = changedFields.add("passcodeRequiredType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a passcode.”</i>
         * 
         * @param passcodeRequired
         *            value of {@code passcodeRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeRequired(Boolean passcodeRequired) {
            this.passcodeRequired = passcodeRequired;
            this.changedFields = changedFields.add("passcodeRequired");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using podcasts on the supervised
         * device (iOS 8.0 and later).”</i>
         * 
         * @param podcastsBlocked
         *            value of {@code podcastsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder podcastsBlocked(Boolean podcastsBlocked) {
            this.podcastsBlocked = podcastsBlocked;
            this.changedFields = changedFields.add("podcastsBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enable the prompt to setup nearby devices with a
         * supervised device.”</i>
         * 
         * @param proximityBlockSetupToNewDevice
         *            value of {@code proximityBlockSetupToNewDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proximityBlockSetupToNewDevice(Boolean proximityBlockSetupToNewDevice) {
            this.proximityBlockSetupToNewDevice = proximityBlockSetupToNewDevice;
            this.changedFields = changedFields.add("proximityBlockSetupToNewDevice");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using Auto fill in Safari.
         * Requires a supervised device for iOS 13 and later.”</i>
         * 
         * @param safariBlockAutofill
         *            value of {@code safariBlockAutofill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariBlockAutofill(Boolean safariBlockAutofill) {
            this.safariBlockAutofill = safariBlockAutofill;
            this.changedFields = changedFields.add("safariBlockAutofill");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block JavaScript in Safari.”</i>
         * 
         * @param safariBlockJavaScript
         *            value of {@code safariBlockJavaScript} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariBlockJavaScript(Boolean safariBlockJavaScript) {
            this.safariBlockJavaScript = safariBlockJavaScript;
            this.changedFields = changedFields.add("safariBlockJavaScript");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block popups in Safari.”</i>
         * 
         * @param safariBlockPopups
         *            value of {@code safariBlockPopups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariBlockPopups(Boolean safariBlockPopups) {
            this.safariBlockPopups = safariBlockPopups;
            this.changedFields = changedFields.add("safariBlockPopups");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using Safari. Requires a
         * supervised device for iOS 13 and later.”</i>
         * 
         * @param safariBlocked
         *            value of {@code safariBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariBlocked(Boolean safariBlocked) {
            this.safariBlocked = safariBlocked;
            this.changedFields = changedFields.add("safariBlocked");
            return this;
        }

        /**
         * <i>“Cookie settings for Safari.”</i>
         * 
         * @param safariCookieSettings
         *            value of {@code safariCookieSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariCookieSettings(WebBrowserCookieSettings safariCookieSettings) {
            this.safariCookieSettings = safariCookieSettings;
            this.changedFields = changedFields.add("safariCookieSettings");
            return this;
        }

        /**
         * <i>“URLs matching the patterns listed here will be considered managed.”</i>
         * 
         * @param safariManagedDomains
         *            value of {@code safariManagedDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariManagedDomains(List<String> safariManagedDomains) {
            this.safariManagedDomains = safariManagedDomains;
            this.changedFields = changedFields.add("safariManagedDomains");
            return this;
        }

        /**
         * <i>“URLs matching the patterns listed here will be considered managed.”</i>
         * 
         * @param safariManagedDomains
         *            value of {@code safariManagedDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariManagedDomains(String... safariManagedDomains) {
            return safariManagedDomains(Arrays.asList(safariManagedDomains));
        }

        /**
         * <i>“URLs matching the patterns listed here will be considered managed.”</i>
         * 
         * @param safariManagedDomainsNextLink
         *            value of {@code safariManagedDomains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariManagedDomainsNextLink(String safariManagedDomainsNextLink) {
            this.safariManagedDomainsNextLink = safariManagedDomainsNextLink;
            this.changedFields = changedFields.add("safariManagedDomains");
            return this;
        }

        /**
         * <i>“Users can save passwords in Safari only from URLs matching the patterns listed
         * here. Applies to devices in supervised mode (iOS 9.3 and later).”</i>
         * 
         * @param safariPasswordAutoFillDomains
         *            value of {@code safariPasswordAutoFillDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariPasswordAutoFillDomains(List<String> safariPasswordAutoFillDomains) {
            this.safariPasswordAutoFillDomains = safariPasswordAutoFillDomains;
            this.changedFields = changedFields.add("safariPasswordAutoFillDomains");
            return this;
        }

        /**
         * <i>“Users can save passwords in Safari only from URLs matching the patterns listed
         * here. Applies to devices in supervised mode (iOS 9.3 and later).”</i>
         * 
         * @param safariPasswordAutoFillDomains
         *            value of {@code safariPasswordAutoFillDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariPasswordAutoFillDomains(String... safariPasswordAutoFillDomains) {
            return safariPasswordAutoFillDomains(Arrays.asList(safariPasswordAutoFillDomains));
        }

        /**
         * <i>“Users can save passwords in Safari only from URLs matching the patterns listed
         * here. Applies to devices in supervised mode (iOS 9.3 and later).”</i>
         * 
         * @param safariPasswordAutoFillDomainsNextLink
         *            value of {@code safariPasswordAutoFillDomains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariPasswordAutoFillDomainsNextLink(String safariPasswordAutoFillDomainsNextLink) {
            this.safariPasswordAutoFillDomainsNextLink = safariPasswordAutoFillDomainsNextLink;
            this.changedFields = changedFields.add("safariPasswordAutoFillDomains");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require fraud warning in Safari.”</i>
         * 
         * @param safariRequireFraudWarning
         *            value of {@code safariRequireFraudWarning} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safariRequireFraudWarning(Boolean safariRequireFraudWarning) {
            this.safariRequireFraudWarning = safariRequireFraudWarning;
            this.changedFields = changedFields.add("safariRequireFraudWarning");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from taking Screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using Siri.”</i>
         * 
         * @param siriBlocked
         *            value of {@code siriBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder siriBlocked(Boolean siriBlocked) {
            this.siriBlocked = siriBlocked;
            this.changedFields = changedFields.add("siriBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using Siri when locked.”</i>
         * 
         * @param siriBlockedWhenLocked
         *            value of {@code siriBlockedWhenLocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder siriBlockedWhenLocked(Boolean siriBlockedWhenLocked) {
            this.siriBlockedWhenLocked = siriBlockedWhenLocked;
            this.changedFields = changedFields.add("siriBlockedWhenLocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Siri from querying user-generated content when
         * used on a supervised device.”</i>
         * 
         * @param siriBlockUserGeneratedContent
         *            value of {@code siriBlockUserGeneratedContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder siriBlockUserGeneratedContent(Boolean siriBlockUserGeneratedContent) {
            this.siriBlockUserGeneratedContent = siriBlockUserGeneratedContent;
            this.changedFields = changedFields.add("siriBlockUserGeneratedContent");
            return this;
        }

        /**
         * <i>“Indicates whether or not to prevent Siri from dictating, or speaking profane
         * language on supervised device.”</i>
         * 
         * @param siriRequireProfanityFilter
         *            value of {@code siriRequireProfanityFilter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder siriRequireProfanityFilter(Boolean siriRequireProfanityFilter) {
            this.siriRequireProfanityFilter = siriRequireProfanityFilter;
            this.changedFields = changedFields.add("siriRequireProfanityFilter");
            return this;
        }

        /**
         * <i>“Sets how many days a software update will be delyed for a supervised device.
         * Valid values 0 to 90”</i>
         * 
         * @param softwareUpdatesEnforcedDelayInDays
         *            value of {@code softwareUpdatesEnforcedDelayInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder softwareUpdatesEnforcedDelayInDays(Integer softwareUpdatesEnforcedDelayInDays) {
            this.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
            this.changedFields = changedFields.add("softwareUpdatesEnforcedDelayInDays");
            return this;
        }

        /**
         * <i>“Indicates whether or not to delay user visibility of software updates when the
         * device is in supervised mode.”</i>
         * 
         * @param softwareUpdatesForceDelayed
         *            value of {@code softwareUpdatesForceDelayed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder softwareUpdatesForceDelayed(Boolean softwareUpdatesForceDelayed) {
            this.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
            this.changedFields = changedFields.add("softwareUpdatesForceDelayed");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Spotlight search from returning internet
         * results on supervised device.”</i>
         * 
         * @param spotlightBlockInternetResults
         *            value of {@code spotlightBlockInternetResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder spotlightBlockInternetResults(Boolean spotlightBlockInternetResults) {
            this.spotlightBlockInternetResults = spotlightBlockInternetResults;
            this.changedFields = changedFields.add("spotlightBlockInternetResults");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block voice dialing.”</i>
         * 
         * @param voiceDialingBlocked
         *            value of {@code voiceDialingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder voiceDialingBlocked(Boolean voiceDialingBlocked) {
            this.voiceDialingBlocked = voiceDialingBlocked;
            this.changedFields = changedFields.add("voiceDialingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow wallpaper modification on supervised device (
         * iOS 9.0 and later) .”</i>
         * 
         * @param wallpaperBlockModification
         *            value of {@code wallpaperBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wallpaperBlockModification(Boolean wallpaperBlockModification) {
            this.wallpaperBlockModification = wallpaperBlockModification;
            this.changedFields = changedFields.add("wallpaperBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to force the device to use only Wi-Fi networks from
         * configuration profiles when the device is in supervised mode.”</i>
         * 
         * @param wiFiConnectOnlyToConfiguredNetworks
         *            value of {@code wiFiConnectOnlyToConfiguredNetworks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiConnectOnlyToConfiguredNetworks(Boolean wiFiConnectOnlyToConfiguredNetworks) {
            this.wiFiConnectOnlyToConfiguredNetworks = wiFiConnectOnlyToConfiguredNetworks;
            this.changedFields = changedFields.add("wiFiConnectOnlyToConfiguredNetworks");
            return this;
        }

        /**
         * <i>“Indicates whether a student enrolled in an unmanaged course via Classroom will
         * request permission from the teacher when attempting to leave the course (iOS 11.
         * 3 and later).”</i>
         * 
         * @param classroomForceRequestPermissionToLeaveClasses
         *            value of {@code classroomForceRequestPermissionToLeaveClasses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomForceRequestPermissionToLeaveClasses(Boolean classroomForceRequestPermissionToLeaveClasses) {
            this.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
            this.changedFields = changedFields.add("classroomForceRequestPermissionToLeaveClasses");
            return this;
        }

        /**
         * <i>“Indicates whether or not iCloud keychain synchronization is blocked. Requires a
         * supervised device for iOS 13 and later.”</i>
         * 
         * @param keychainBlockCloudSync
         *            value of {@code keychainBlockCloudSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keychainBlockCloudSync(Boolean keychainBlockCloudSync) {
            this.keychainBlockCloudSync = keychainBlockCloudSync;
            this.changedFields = changedFields.add("keychainBlockCloudSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not over-the-air PKI updates are blocked. Setting this
         * restriction to false does not disable CRL and OCSP checks (iOS 7.0 and later).”</i>
         * 
         * @param pkiBlockOTAUpdates
         *            value of {@code pkiBlockOTAUpdates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pkiBlockOTAUpdates(Boolean pkiBlockOTAUpdates) {
            this.pkiBlockOTAUpdates = pkiBlockOTAUpdates;
            this.changedFields = changedFields.add("pkiBlockOTAUpdates");
            return this;
        }

        /**
         * <i>“Indicates if ad tracking is limited.(iOS 7.0 and later).”</i>
         * 
         * @param privacyForceLimitAdTracking
         *            value of {@code privacyForceLimitAdTracking} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyForceLimitAdTracking(Boolean privacyForceLimitAdTracking) {
            this.privacyForceLimitAdTracking = privacyForceLimitAdTracking;
            this.changedFields = changedFields.add("privacyForceLimitAdTracking");
            return this;
        }

        /**
         * <i>“Indicates whether or not Enterprise book back up is blocked.”</i>
         * 
         * @param enterpriseBookBlockBackup
         *            value of {@code enterpriseBookBlockBackup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseBookBlockBackup(Boolean enterpriseBookBlockBackup) {
            this.enterpriseBookBlockBackup = enterpriseBookBlockBackup;
            this.changedFields = changedFields.add("enterpriseBookBlockBackup");
            return this;
        }

        /**
         * <i>“Indicates whether or not Enterprise book notes and highlights sync is blocked.”</i>
         * 
         * @param enterpriseBookBlockMetadataSync
         *            value of {@code enterpriseBookBlockMetadataSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseBookBlockMetadataSync(Boolean enterpriseBookBlockMetadataSync) {
            this.enterpriseBookBlockMetadataSync = enterpriseBookBlockMetadataSync;
            this.changedFields = changedFields.add("enterpriseBookBlockMetadataSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not AirPrint is blocked (iOS 11.0 and later).”</i>
         * 
         * @param airPrintBlocked
         *            value of {@code airPrintBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintBlocked(Boolean airPrintBlocked) {
            this.airPrintBlocked = airPrintBlocked;
            this.changedFields = changedFields.add("airPrintBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not keychain storage of username and password for Airprint
         * is blocked (iOS 11.0 and later).”</i>
         * 
         * @param airPrintBlockCredentialsStorage
         *            value of {@code airPrintBlockCredentialsStorage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintBlockCredentialsStorage(Boolean airPrintBlockCredentialsStorage) {
            this.airPrintBlockCredentialsStorage = airPrintBlockCredentialsStorage;
            this.changedFields = changedFields.add("airPrintBlockCredentialsStorage");
            return this;
        }

        /**
         * <i>“Indicates if trusted certificates are required for TLS printing communication (
         * iOS 11.0 and later).”</i>
         * 
         * @param airPrintForceTrustedTLS
         *            value of {@code airPrintForceTrustedTLS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintForceTrustedTLS(Boolean airPrintForceTrustedTLS) {
            this.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
            this.changedFields = changedFields.add("airPrintForceTrustedTLS");
            return this;
        }

        /**
         * <i>“Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This
         * prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (
         * iOS 11.0 and later).”</i>
         * 
         * @param airPrintBlockiBeaconDiscovery
         *            value of {@code airPrintBlockiBeaconDiscovery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintBlockiBeaconDiscovery(Boolean airPrintBlockiBeaconDiscovery) {
            this.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
            this.changedFields = changedFields.add("airPrintBlockiBeaconDiscovery");
            return this;
        }

        /**
         * <i>“Indicates if devices can access files or other resources on a network server
         * using the Server Message Block (SMB) protocol. Available for devices running iOS
         * and iPadOS, versions 13.0 and later.”</i>
         * 
         * @param filesNetworkDriveAccessBlocked
         *            value of {@code filesNetworkDriveAccessBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filesNetworkDriveAccessBlocked(Boolean filesNetworkDriveAccessBlocked) {
            this.filesNetworkDriveAccessBlocked = filesNetworkDriveAccessBlocked;
            this.changedFields = changedFields.add("filesNetworkDriveAccessBlocked");
            return this;
        }

        /**
         * <i>“Indicates if sevices with access can connect to and open files on a USB drive.
         * Available for devices running iOS and iPadOS, versions 13.0 and later.”</i>
         * 
         * @param filesUsbDriveAccessBlocked
         *            value of {@code filesUsbDriveAccessBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filesUsbDriveAccessBlocked(Boolean filesUsbDriveAccessBlocked) {
            this.filesUsbDriveAccessBlocked = filesUsbDriveAccessBlocked;
            this.changedFields = changedFields.add("filesUsbDriveAccessBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not Wi-Fi remains on, even when device is in airplane mode.
         * Available for devices running iOS and iPadOS, versions 13.0 and later.”</i>
         * 
         * @param wifiPowerOnForced
         *            value of {@code wifiPowerOnForced} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiPowerOnForced(Boolean wifiPowerOnForced) {
            this.wifiPowerOnForced = wifiPowerOnForced;
            this.changedFields = changedFields.add("wifiPowerOnForced");
            return this;
        }

        /**
         * <i>“Indicates whether or not the removal of system apps from the device is blocked
         * on a supervised device (iOS 11.0 and later).”</i>
         * 
         * @param blockSystemAppRemoval
         *            value of {@code blockSystemAppRemoval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockSystemAppRemoval(Boolean blockSystemAppRemoval) {
            this.blockSystemAppRemoval = blockSystemAppRemoval;
            this.changedFields = changedFields.add("blockSystemAppRemoval");
            return this;
        }

        /**
         * <i>“Indicates whether or not the creation of VPN configurations is blocked (iOS 11.0
         * and later).”</i>
         * 
         * @param vpnBlockCreation
         *            value of {@code vpnBlockCreation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vpnBlockCreation(Boolean vpnBlockCreation) {
            this.vpnBlockCreation = vpnBlockCreation;
            this.changedFields = changedFields.add("vpnBlockCreation");
            return this;
        }

        /**
         * <i>“Indicates if the removal of apps is allowed.”</i>
         * 
         * @param appRemovalBlocked
         *            value of {@code appRemovalBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appRemovalBlocked(Boolean appRemovalBlocked) {
            this.appRemovalBlocked = appRemovalBlocked;
            this.changedFields = changedFields.add("appRemovalBlocked");
            return this;
        }

        /**
         * <i>“Indicates if connecting to USB accessories while the device is locked is allowed
         * (iOS 11.4.1 and later).”</i>
         * 
         * @param usbRestrictedModeBlocked
         *            value of {@code usbRestrictedModeBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usbRestrictedModeBlocked(Boolean usbRestrictedModeBlocked) {
            this.usbRestrictedModeBlocked = usbRestrictedModeBlocked;
            this.changedFields = changedFields.add("usbRestrictedModeBlocked");
            return this;
        }

        /**
         * <i>“Indicates if the AutoFill passwords feature is allowed (iOS 12.0 and later).”</i>
         * 
         * @param passwordBlockAutoFill
         *            value of {@code passwordBlockAutoFill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockAutoFill(Boolean passwordBlockAutoFill) {
            this.passwordBlockAutoFill = passwordBlockAutoFill;
            this.changedFields = changedFields.add("passwordBlockAutoFill");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block requesting passwords from nearby devices (iOS
         * 12.0 and later).”</i>
         * 
         * @param passwordBlockProximityRequests
         *            value of {@code passwordBlockProximityRequests} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockProximityRequests(Boolean passwordBlockProximityRequests) {
            this.passwordBlockProximityRequests = passwordBlockProximityRequests;
            this.changedFields = changedFields.add("passwordBlockProximityRequests");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block sharing passwords with the AirDrop passwords
         * feature iOS 12.0 and later).”</i>
         * 
         * @param passwordBlockAirDropSharing
         *            value of {@code passwordBlockAirDropSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockAirDropSharing(Boolean passwordBlockAirDropSharing) {
            this.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
            this.changedFields = changedFields.add("passwordBlockAirDropSharing");
            return this;
        }

        /**
         * <i>“Indicates whether or not the Date and Time "Set Automatically" feature is
         * enabled and cannot be turned off by the user (iOS 12.0 and later).”</i>
         * 
         * @param dateAndTimeForceSetAutomatically
         *            value of {@code dateAndTimeForceSetAutomatically} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dateAndTimeForceSetAutomatically(Boolean dateAndTimeForceSetAutomatically) {
            this.dateAndTimeForceSetAutomatically = dateAndTimeForceSetAutomatically;
            this.changedFields = changedFields.add("dateAndTimeForceSetAutomatically");
            return this;
        }

        /**
         * <i>“Indicates whether or not managed apps can write contacts to unmanaged contacts
         * accounts (iOS 12.0 and later).”</i>
         * 
         * @param contactsAllowManagedToUnmanagedWrite
         *            value of {@code contactsAllowManagedToUnmanagedWrite} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactsAllowManagedToUnmanagedWrite(Boolean contactsAllowManagedToUnmanagedWrite) {
            this.contactsAllowManagedToUnmanagedWrite = contactsAllowManagedToUnmanagedWrite;
            this.changedFields = changedFields.add("contactsAllowManagedToUnmanagedWrite");
            return this;
        }

        /**
         * <i>“Indicates whether or not unmanaged apps can read from managed contacts accounts
         * (iOS 12.0 or later).”</i>
         * 
         * @param contactsAllowUnmanagedToManagedRead
         *            value of {@code contactsAllowUnmanagedToManagedRead} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactsAllowUnmanagedToManagedRead(Boolean contactsAllowUnmanagedToManagedRead) {
            this.contactsAllowUnmanagedToManagedRead = contactsAllowUnmanagedToManagedRead;
            this.changedFields = changedFields.add("contactsAllowUnmanagedToManagedRead");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from modifying the personal hotspot
         * setting (iOS 12.2 or later).”</i>
         * 
         * @param cellularBlockPersonalHotspotModification
         *            value of {@code cellularBlockPersonalHotspotModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockPersonalHotspotModification(Boolean cellularBlockPersonalHotspotModification) {
            this.cellularBlockPersonalHotspotModification = cellularBlockPersonalHotspotModification;
            this.changedFields = changedFields.add("cellularBlockPersonalHotspotModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the continuous path keyboard when the device
         * is supervised (iOS 13 or later).”</i>
         * 
         * @param continuousPathKeyboardBlocked
         *            value of {@code continuousPathKeyboardBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder continuousPathKeyboardBlocked(Boolean continuousPathKeyboardBlocked) {
            this.continuousPathKeyboardBlocked = continuousPathKeyboardBlocked;
            this.changedFields = changedFields.add("continuousPathKeyboardBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Find My Device when the device is supervised (
         * iOS 13 or later).”</i>
         * 
         * @param findMyDeviceInFindMyAppBlocked
         *            value of {@code findMyDeviceInFindMyAppBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder findMyDeviceInFindMyAppBlocked(Boolean findMyDeviceInFindMyAppBlocked) {
            this.findMyDeviceInFindMyAppBlocked = findMyDeviceInFindMyAppBlocked;
            this.changedFields = changedFields.add("findMyDeviceInFindMyAppBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Find My Friends when the device is supervised
         * (iOS 13 or later).”</i>
         * 
         * @param findMyFriendsInFindMyAppBlocked
         *            value of {@code findMyFriendsInFindMyAppBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder findMyFriendsInFindMyAppBlocked(Boolean findMyFriendsInFindMyAppBlocked) {
            this.findMyFriendsInFindMyAppBlocked = findMyFriendsInFindMyAppBlocked;
            this.changedFields = changedFields.add("findMyFriendsInFindMyAppBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the iTunes app. Requires a supervised device
         * for iOS 13 and later.”</i>
         * 
         * @param iTunesBlocked
         *            value of {@code iTunesBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iTunesBlocked(Boolean iTunesBlocked) {
            this.iTunesBlocked = iTunesBlocked;
            this.changedFields = changedFields.add("iTunesBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block temporary sessions on Shared iPads (iOS 13.4
         * or later).”</i>
         * 
         * @param sharedDeviceBlockTemporarySessions
         *            value of {@code sharedDeviceBlockTemporarySessions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceBlockTemporarySessions(Boolean sharedDeviceBlockTemporarySessions) {
            this.sharedDeviceBlockTemporarySessions = sharedDeviceBlockTemporarySessions;
            this.changedFields = changedFields.add("sharedDeviceBlockTemporarySessions");
            return this;
        }

        /**
         * <i>“Type of app to run in kiosk mode.”</i>
         * 
         * @param kioskModeAppType
         *            value of {@code kioskModeAppType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAppType(IosKioskModeAppType kioskModeAppType) {
            this.kioskModeAppType = kioskModeAppType;
            this.changedFields = changedFields.add("kioskModeAppType");
            return this;
        }

        public IosGeneralDeviceConfiguration build() {
            IosGeneralDeviceConfiguration _x = new IosGeneralDeviceConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosGeneralDeviceConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.accountBlockModification = accountBlockModification;
            _x.activationLockAllowWhenSupervised = activationLockAllowWhenSupervised;
            _x.airDropBlocked = airDropBlocked;
            _x.airDropForceUnmanagedDropTarget = airDropForceUnmanagedDropTarget;
            _x.airPlayForcePairingPasswordForOutgoingRequests = airPlayForcePairingPasswordForOutgoingRequests;
            _x.appleWatchBlockPairing = appleWatchBlockPairing;
            _x.appleWatchForceWristDetection = appleWatchForceWristDetection;
            _x.appleNewsBlocked = appleNewsBlocked;
            _x.appsSingleAppModeList = appsSingleAppModeList;
            _x.appsSingleAppModeListNextLink = appsSingleAppModeListNextLink;
            _x.appsVisibilityList = appsVisibilityList;
            _x.appsVisibilityListNextLink = appsVisibilityListNextLink;
            _x.appsVisibilityListType = appsVisibilityListType;
            _x.appStoreBlockAutomaticDownloads = appStoreBlockAutomaticDownloads;
            _x.appStoreBlocked = appStoreBlocked;
            _x.appStoreBlockInAppPurchases = appStoreBlockInAppPurchases;
            _x.appStoreBlockUIAppInstallation = appStoreBlockUIAppInstallation;
            _x.appStoreRequirePassword = appStoreRequirePassword;
            _x.autoFillForceAuthentication = autoFillForceAuthentication;
            _x.bluetoothBlockModification = bluetoothBlockModification;
            _x.cameraBlocked = cameraBlocked;
            _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
            _x.cellularBlockGlobalBackgroundFetchWhileRoaming = cellularBlockGlobalBackgroundFetchWhileRoaming;
            _x.cellularBlockPerAppDataModification = cellularBlockPerAppDataModification;
            _x.cellularBlockPersonalHotspot = cellularBlockPersonalHotspot;
            _x.cellularBlockPlanModification = cellularBlockPlanModification;
            _x.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
            _x.certificatesBlockUntrustedTlsCertificates = certificatesBlockUntrustedTlsCertificates;
            _x.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
            _x.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
            _x.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
            _x.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
            _x.compliantAppsList = compliantAppsList;
            _x.compliantAppsListNextLink = compliantAppsListNextLink;
            _x.compliantAppListType = compliantAppListType;
            _x.configurationProfileBlockChanges = configurationProfileBlockChanges;
            _x.definitionLookupBlocked = definitionLookupBlocked;
            _x.deviceBlockEnableRestrictions = deviceBlockEnableRestrictions;
            _x.deviceBlockEraseContentAndSettings = deviceBlockEraseContentAndSettings;
            _x.deviceBlockNameModification = deviceBlockNameModification;
            _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
            _x.diagnosticDataBlockSubmissionModification = diagnosticDataBlockSubmissionModification;
            _x.documentsBlockManagedDocumentsInUnmanagedApps = documentsBlockManagedDocumentsInUnmanagedApps;
            _x.documentsBlockUnmanagedDocumentsInManagedApps = documentsBlockUnmanagedDocumentsInManagedApps;
            _x.emailInDomainSuffixes = emailInDomainSuffixes;
            _x.emailInDomainSuffixesNextLink = emailInDomainSuffixesNextLink;
            _x.enterpriseAppBlockTrust = enterpriseAppBlockTrust;
            _x.enterpriseAppBlockTrustModification = enterpriseAppBlockTrustModification;
            _x.esimBlockModification = esimBlockModification;
            _x.faceTimeBlocked = faceTimeBlocked;
            _x.findMyFriendsBlocked = findMyFriendsBlocked;
            _x.gamingBlockGameCenterFriends = gamingBlockGameCenterFriends;
            _x.gamingBlockMultiplayer = gamingBlockMultiplayer;
            _x.gameCenterBlocked = gameCenterBlocked;
            _x.hostPairingBlocked = hostPairingBlocked;
            _x.iBooksStoreBlocked = iBooksStoreBlocked;
            _x.iBooksStoreBlockErotica = iBooksStoreBlockErotica;
            _x.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
            _x.iCloudBlockBackup = iCloudBlockBackup;
            _x.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
            _x.iCloudBlockManagedAppsSync = iCloudBlockManagedAppsSync;
            _x.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
            _x.iCloudBlockPhotoStreamSync = iCloudBlockPhotoStreamSync;
            _x.iCloudBlockSharedPhotoStream = iCloudBlockSharedPhotoStream;
            _x.iCloudRequireEncryptedBackup = iCloudRequireEncryptedBackup;
            _x.iTunesBlockExplicitContent = iTunesBlockExplicitContent;
            _x.iTunesBlockMusicService = iTunesBlockMusicService;
            _x.iTunesBlockRadio = iTunesBlockRadio;
            _x.keyboardBlockAutoCorrect = keyboardBlockAutoCorrect;
            _x.keyboardBlockDictation = keyboardBlockDictation;
            _x.keyboardBlockPredictive = keyboardBlockPredictive;
            _x.keyboardBlockShortcuts = keyboardBlockShortcuts;
            _x.keyboardBlockSpellCheck = keyboardBlockSpellCheck;
            _x.kioskModeAllowAssistiveSpeak = kioskModeAllowAssistiveSpeak;
            _x.kioskModeAllowAssistiveTouchSettings = kioskModeAllowAssistiveTouchSettings;
            _x.kioskModeAllowAutoLock = kioskModeAllowAutoLock;
            _x.kioskModeBlockAutoLock = kioskModeBlockAutoLock;
            _x.kioskModeAllowColorInversionSettings = kioskModeAllowColorInversionSettings;
            _x.kioskModeAllowRingerSwitch = kioskModeAllowRingerSwitch;
            _x.kioskModeBlockRingerSwitch = kioskModeBlockRingerSwitch;
            _x.kioskModeAllowScreenRotation = kioskModeAllowScreenRotation;
            _x.kioskModeBlockScreenRotation = kioskModeBlockScreenRotation;
            _x.kioskModeAllowSleepButton = kioskModeAllowSleepButton;
            _x.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
            _x.kioskModeAllowTouchscreen = kioskModeAllowTouchscreen;
            _x.kioskModeBlockTouchscreen = kioskModeBlockTouchscreen;
            _x.kioskModeEnableVoiceControl = kioskModeEnableVoiceControl;
            _x.kioskModeAllowVoiceControlModification = kioskModeAllowVoiceControlModification;
            _x.kioskModeAllowVoiceOverSettings = kioskModeAllowVoiceOverSettings;
            _x.kioskModeAllowVolumeButtons = kioskModeAllowVolumeButtons;
            _x.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
            _x.kioskModeAllowZoomSettings = kioskModeAllowZoomSettings;
            _x.kioskModeAppStoreUrl = kioskModeAppStoreUrl;
            _x.kioskModeBuiltInAppId = kioskModeBuiltInAppId;
            _x.kioskModeRequireAssistiveTouch = kioskModeRequireAssistiveTouch;
            _x.kioskModeRequireColorInversion = kioskModeRequireColorInversion;
            _x.kioskModeRequireMonoAudio = kioskModeRequireMonoAudio;
            _x.kioskModeRequireVoiceOver = kioskModeRequireVoiceOver;
            _x.kioskModeRequireZoom = kioskModeRequireZoom;
            _x.kioskModeManagedAppId = kioskModeManagedAppId;
            _x.lockScreenBlockControlCenter = lockScreenBlockControlCenter;
            _x.lockScreenBlockNotificationView = lockScreenBlockNotificationView;
            _x.lockScreenBlockPassbook = lockScreenBlockPassbook;
            _x.lockScreenBlockTodayView = lockScreenBlockTodayView;
            _x.mediaContentRatingAustralia = mediaContentRatingAustralia;
            _x.mediaContentRatingCanada = mediaContentRatingCanada;
            _x.mediaContentRatingFrance = mediaContentRatingFrance;
            _x.mediaContentRatingGermany = mediaContentRatingGermany;
            _x.mediaContentRatingIreland = mediaContentRatingIreland;
            _x.mediaContentRatingJapan = mediaContentRatingJapan;
            _x.mediaContentRatingNewZealand = mediaContentRatingNewZealand;
            _x.mediaContentRatingUnitedKingdom = mediaContentRatingUnitedKingdom;
            _x.mediaContentRatingUnitedStates = mediaContentRatingUnitedStates;
            _x.networkUsageRules = networkUsageRules;
            _x.networkUsageRulesNextLink = networkUsageRulesNextLink;
            _x.mediaContentRatingApps = mediaContentRatingApps;
            _x.messagesBlocked = messagesBlocked;
            _x.notificationsBlockSettingsModification = notificationsBlockSettingsModification;
            _x.passcodeBlockFingerprintUnlock = passcodeBlockFingerprintUnlock;
            _x.passcodeBlockFingerprintModification = passcodeBlockFingerprintModification;
            _x.passcodeBlockModification = passcodeBlockModification;
            _x.passcodeBlockSimple = passcodeBlockSimple;
            _x.passcodeExpirationDays = passcodeExpirationDays;
            _x.passcodeMinimumLength = passcodeMinimumLength;
            _x.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
            _x.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
            _x.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
            _x.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
            _x.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
            _x.passcodeRequiredType = passcodeRequiredType;
            _x.passcodeRequired = passcodeRequired;
            _x.podcastsBlocked = podcastsBlocked;
            _x.proximityBlockSetupToNewDevice = proximityBlockSetupToNewDevice;
            _x.safariBlockAutofill = safariBlockAutofill;
            _x.safariBlockJavaScript = safariBlockJavaScript;
            _x.safariBlockPopups = safariBlockPopups;
            _x.safariBlocked = safariBlocked;
            _x.safariCookieSettings = safariCookieSettings;
            _x.safariManagedDomains = safariManagedDomains;
            _x.safariManagedDomainsNextLink = safariManagedDomainsNextLink;
            _x.safariPasswordAutoFillDomains = safariPasswordAutoFillDomains;
            _x.safariPasswordAutoFillDomainsNextLink = safariPasswordAutoFillDomainsNextLink;
            _x.safariRequireFraudWarning = safariRequireFraudWarning;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.siriBlocked = siriBlocked;
            _x.siriBlockedWhenLocked = siriBlockedWhenLocked;
            _x.siriBlockUserGeneratedContent = siriBlockUserGeneratedContent;
            _x.siriRequireProfanityFilter = siriRequireProfanityFilter;
            _x.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
            _x.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
            _x.spotlightBlockInternetResults = spotlightBlockInternetResults;
            _x.voiceDialingBlocked = voiceDialingBlocked;
            _x.wallpaperBlockModification = wallpaperBlockModification;
            _x.wiFiConnectOnlyToConfiguredNetworks = wiFiConnectOnlyToConfiguredNetworks;
            _x.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
            _x.keychainBlockCloudSync = keychainBlockCloudSync;
            _x.pkiBlockOTAUpdates = pkiBlockOTAUpdates;
            _x.privacyForceLimitAdTracking = privacyForceLimitAdTracking;
            _x.enterpriseBookBlockBackup = enterpriseBookBlockBackup;
            _x.enterpriseBookBlockMetadataSync = enterpriseBookBlockMetadataSync;
            _x.airPrintBlocked = airPrintBlocked;
            _x.airPrintBlockCredentialsStorage = airPrintBlockCredentialsStorage;
            _x.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
            _x.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
            _x.filesNetworkDriveAccessBlocked = filesNetworkDriveAccessBlocked;
            _x.filesUsbDriveAccessBlocked = filesUsbDriveAccessBlocked;
            _x.wifiPowerOnForced = wifiPowerOnForced;
            _x.blockSystemAppRemoval = blockSystemAppRemoval;
            _x.vpnBlockCreation = vpnBlockCreation;
            _x.appRemovalBlocked = appRemovalBlocked;
            _x.usbRestrictedModeBlocked = usbRestrictedModeBlocked;
            _x.passwordBlockAutoFill = passwordBlockAutoFill;
            _x.passwordBlockProximityRequests = passwordBlockProximityRequests;
            _x.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
            _x.dateAndTimeForceSetAutomatically = dateAndTimeForceSetAutomatically;
            _x.contactsAllowManagedToUnmanagedWrite = contactsAllowManagedToUnmanagedWrite;
            _x.contactsAllowUnmanagedToManagedRead = contactsAllowUnmanagedToManagedRead;
            _x.cellularBlockPersonalHotspotModification = cellularBlockPersonalHotspotModification;
            _x.continuousPathKeyboardBlocked = continuousPathKeyboardBlocked;
            _x.findMyDeviceInFindMyAppBlocked = findMyDeviceInFindMyAppBlocked;
            _x.findMyFriendsInFindMyAppBlocked = findMyFriendsInFindMyAppBlocked;
            _x.iTunesBlocked = iTunesBlocked;
            _x.sharedDeviceBlockTemporarySessions = sharedDeviceBlockTemporarySessions;
            _x.kioskModeAppType = kioskModeAppType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates whether or not to allow account modification when the device is in
     * supervised mode.”</i>
     * 
     * @return property accountBlockModification
     */
    @Property(name="accountBlockModification")
    @JsonIgnore
    public Optional<Boolean> getAccountBlockModification() {
        return Optional.ofNullable(accountBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountBlockModification} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow account modification when the device is in
     * supervised mode.”</i>
     * 
     * @param accountBlockModification
     *            new value of {@code accountBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountBlockModification} field changed
     */
    public IosGeneralDeviceConfiguration withAccountBlockModification(Boolean accountBlockModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.accountBlockModification = accountBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow activation lock when the device is in the
     * supervised mode.”</i>
     * 
     * @return property activationLockAllowWhenSupervised
     */
    @Property(name="activationLockAllowWhenSupervised")
    @JsonIgnore
    public Optional<Boolean> getActivationLockAllowWhenSupervised() {
        return Optional.ofNullable(activationLockAllowWhenSupervised);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activationLockAllowWhenSupervised} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow activation lock when the device is in the
     * supervised mode.”</i>
     * 
     * @param activationLockAllowWhenSupervised
     *            new value of {@code activationLockAllowWhenSupervised} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activationLockAllowWhenSupervised} field changed
     */
    public IosGeneralDeviceConfiguration withActivationLockAllowWhenSupervised(Boolean activationLockAllowWhenSupervised) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("activationLockAllowWhenSupervised");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.activationLockAllowWhenSupervised = activationLockAllowWhenSupervised;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow AirDrop when the device is in supervised mode.”</i>
     * 
     * @return property airDropBlocked
     */
    @Property(name="airDropBlocked")
    @JsonIgnore
    public Optional<Boolean> getAirDropBlocked() {
        return Optional.ofNullable(airDropBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code airDropBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to allow AirDrop when the device is in supervised mode.”</i>
     * 
     * @param airDropBlocked
     *            new value of {@code airDropBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airDropBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withAirDropBlocked(Boolean airDropBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airDropBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airDropBlocked = airDropBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to cause AirDrop to be considered an unmanaged drop
     * target (iOS 9.0 and later).”</i>
     * 
     * @return property airDropForceUnmanagedDropTarget
     */
    @Property(name="airDropForceUnmanagedDropTarget")
    @JsonIgnore
    public Optional<Boolean> getAirDropForceUnmanagedDropTarget() {
        return Optional.ofNullable(airDropForceUnmanagedDropTarget);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airDropForceUnmanagedDropTarget} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to cause AirDrop to be considered an unmanaged drop
     * target (iOS 9.0 and later).”</i>
     * 
     * @param airDropForceUnmanagedDropTarget
     *            new value of {@code airDropForceUnmanagedDropTarget} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airDropForceUnmanagedDropTarget} field changed
     */
    public IosGeneralDeviceConfiguration withAirDropForceUnmanagedDropTarget(Boolean airDropForceUnmanagedDropTarget) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airDropForceUnmanagedDropTarget");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airDropForceUnmanagedDropTarget = airDropForceUnmanagedDropTarget;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enforce all devices receiving AirPlay requests from
     * this device to use a pairing password.”</i>
     * 
     * @return property airPlayForcePairingPasswordForOutgoingRequests
     */
    @Property(name="airPlayForcePairingPasswordForOutgoingRequests")
    @JsonIgnore
    public Optional<Boolean> getAirPlayForcePairingPasswordForOutgoingRequests() {
        return Optional.ofNullable(airPlayForcePairingPasswordForOutgoingRequests);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPlayForcePairingPasswordForOutgoingRequests} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enforce all devices receiving AirPlay requests from
     * this device to use a pairing password.”</i>
     * 
     * @param airPlayForcePairingPasswordForOutgoingRequests
     *            new value of {@code airPlayForcePairingPasswordForOutgoingRequests} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPlayForcePairingPasswordForOutgoingRequests} field changed
     */
    public IosGeneralDeviceConfiguration withAirPlayForcePairingPasswordForOutgoingRequests(Boolean airPlayForcePairingPasswordForOutgoingRequests) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPlayForcePairingPasswordForOutgoingRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airPlayForcePairingPasswordForOutgoingRequests = airPlayForcePairingPasswordForOutgoingRequests;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow Apple Watch pairing when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @return property appleWatchBlockPairing
     */
    @Property(name="appleWatchBlockPairing")
    @JsonIgnore
    public Optional<Boolean> getAppleWatchBlockPairing() {
        return Optional.ofNullable(appleWatchBlockPairing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appleWatchBlockPairing} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow Apple Watch pairing when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @param appleWatchBlockPairing
     *            new value of {@code appleWatchBlockPairing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleWatchBlockPairing} field changed
     */
    public IosGeneralDeviceConfiguration withAppleWatchBlockPairing(Boolean appleWatchBlockPairing) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appleWatchBlockPairing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appleWatchBlockPairing = appleWatchBlockPairing;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to force a paired Apple Watch to use Wrist Detection (
     * iOS 8.2 and later).”</i>
     * 
     * @return property appleWatchForceWristDetection
     */
    @Property(name="appleWatchForceWristDetection")
    @JsonIgnore
    public Optional<Boolean> getAppleWatchForceWristDetection() {
        return Optional.ofNullable(appleWatchForceWristDetection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appleWatchForceWristDetection} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to force a paired Apple Watch to use Wrist Detection (
     * iOS 8.2 and later).”</i>
     * 
     * @param appleWatchForceWristDetection
     *            new value of {@code appleWatchForceWristDetection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleWatchForceWristDetection} field changed
     */
    public IosGeneralDeviceConfiguration withAppleWatchForceWristDetection(Boolean appleWatchForceWristDetection) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appleWatchForceWristDetection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appleWatchForceWristDetection = appleWatchForceWristDetection;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using News when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @return property appleNewsBlocked
     */
    @Property(name="appleNewsBlocked")
    @JsonIgnore
    public Optional<Boolean> getAppleNewsBlocked() {
        return Optional.ofNullable(appleNewsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleNewsBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using News when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @param appleNewsBlocked
     *            new value of {@code appleNewsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleNewsBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withAppleNewsBlocked(Boolean appleNewsBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appleNewsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appleNewsBlocked = appleNewsBlocked;
        return _x;
    }

    /**
     * <i>“Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode.
     * Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property appsSingleAppModeList
     */
    @Property(name="appsSingleAppModeList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsSingleAppModeList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, appsSingleAppModeList, Optional.ofNullable(appsSingleAppModeListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode.
     * Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property appsSingleAppModeList
     */
    @Property(name="appsSingleAppModeList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsSingleAppModeList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, appsSingleAppModeList, Optional.ofNullable(appsSingleAppModeListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List of apps in the visibility list (either visible/launchable apps list or
     * hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3
     * and later). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property appsVisibilityList
     */
    @Property(name="appsVisibilityList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsVisibilityList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, appsVisibilityList, Optional.ofNullable(appsVisibilityListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of apps in the visibility list (either visible/launchable apps list or
     * hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3
     * and later). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property appsVisibilityList
     */
    @Property(name="appsVisibilityList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsVisibilityList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, appsVisibilityList, Optional.ofNullable(appsVisibilityListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Type of list that is in the AppsVisibilityList.”</i>
     * 
     * @return property appsVisibilityListType
     */
    @Property(name="appsVisibilityListType")
    @JsonIgnore
    public Optional<AppListType> getAppsVisibilityListType() {
        return Optional.ofNullable(appsVisibilityListType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsVisibilityListType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Type of list that is in the AppsVisibilityList.”</i>
     * 
     * @param appsVisibilityListType
     *            new value of {@code appsVisibilityListType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsVisibilityListType} field changed
     */
    public IosGeneralDeviceConfiguration withAppsVisibilityListType(AppListType appsVisibilityListType) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsVisibilityListType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appsVisibilityListType = appsVisibilityListType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the automatic downloading of apps purchased on
     * other devices when the device is in supervised mode (iOS 9.0 and later).”</i>
     * 
     * @return property appStoreBlockAutomaticDownloads
     */
    @Property(name="appStoreBlockAutomaticDownloads")
    @JsonIgnore
    public Optional<Boolean> getAppStoreBlockAutomaticDownloads() {
        return Optional.ofNullable(appStoreBlockAutomaticDownloads);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appStoreBlockAutomaticDownloads} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the automatic downloading of apps purchased on
     * other devices when the device is in supervised mode (iOS 9.0 and later).”</i>
     * 
     * @param appStoreBlockAutomaticDownloads
     *            new value of {@code appStoreBlockAutomaticDownloads} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreBlockAutomaticDownloads} field changed
     */
    public IosGeneralDeviceConfiguration withAppStoreBlockAutomaticDownloads(Boolean appStoreBlockAutomaticDownloads) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appStoreBlockAutomaticDownloads");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appStoreBlockAutomaticDownloads = appStoreBlockAutomaticDownloads;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using the App Store. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @return property appStoreBlocked
     */
    @Property(name="appStoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getAppStoreBlocked() {
        return Optional.ofNullable(appStoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appStoreBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using the App Store. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @param appStoreBlocked
     *            new value of {@code appStoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withAppStoreBlocked(Boolean appStoreBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appStoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appStoreBlocked = appStoreBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from making in app purchases.”</i>
     * 
     * @return property appStoreBlockInAppPurchases
     */
    @Property(name="appStoreBlockInAppPurchases")
    @JsonIgnore
    public Optional<Boolean> getAppStoreBlockInAppPurchases() {
        return Optional.ofNullable(appStoreBlockInAppPurchases);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appStoreBlockInAppPurchases} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from making in app purchases.”</i>
     * 
     * @param appStoreBlockInAppPurchases
     *            new value of {@code appStoreBlockInAppPurchases} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreBlockInAppPurchases} field changed
     */
    public IosGeneralDeviceConfiguration withAppStoreBlockInAppPurchases(Boolean appStoreBlockInAppPurchases) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appStoreBlockInAppPurchases");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appStoreBlockInAppPurchases = appStoreBlockInAppPurchases;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the App Store app, not restricting
     * installation through Host apps. Applies to supervised mode only (iOS 9.0 and
     * later).”</i>
     * 
     * @return property appStoreBlockUIAppInstallation
     */
    @Property(name="appStoreBlockUIAppInstallation")
    @JsonIgnore
    public Optional<Boolean> getAppStoreBlockUIAppInstallation() {
        return Optional.ofNullable(appStoreBlockUIAppInstallation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appStoreBlockUIAppInstallation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the App Store app, not restricting
     * installation through Host apps. Applies to supervised mode only (iOS 9.0 and
     * later).”</i>
     * 
     * @param appStoreBlockUIAppInstallation
     *            new value of {@code appStoreBlockUIAppInstallation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreBlockUIAppInstallation} field changed
     */
    public IosGeneralDeviceConfiguration withAppStoreBlockUIAppInstallation(Boolean appStoreBlockUIAppInstallation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appStoreBlockUIAppInstallation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appStoreBlockUIAppInstallation = appStoreBlockUIAppInstallation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a password when using the app store.”</i>
     * 
     * @return property appStoreRequirePassword
     */
    @Property(name="appStoreRequirePassword")
    @JsonIgnore
    public Optional<Boolean> getAppStoreRequirePassword() {
        return Optional.ofNullable(appStoreRequirePassword);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appStoreRequirePassword} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require a password when using the app store.”</i>
     * 
     * @param appStoreRequirePassword
     *            new value of {@code appStoreRequirePassword} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreRequirePassword} field changed
     */
    public IosGeneralDeviceConfiguration withAppStoreRequirePassword(Boolean appStoreRequirePassword) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appStoreRequirePassword");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appStoreRequirePassword = appStoreRequirePassword;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to force user authentication before autofilling
     * passwords and credit card information in Safari and other apps on supervised
     * devices.”</i>
     * 
     * @return property autoFillForceAuthentication
     */
    @Property(name="autoFillForceAuthentication")
    @JsonIgnore
    public Optional<Boolean> getAutoFillForceAuthentication() {
        return Optional.ofNullable(autoFillForceAuthentication);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autoFillForceAuthentication} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to force user authentication before autofilling
     * passwords and credit card information in Safari and other apps on supervised
     * devices.”</i>
     * 
     * @param autoFillForceAuthentication
     *            new value of {@code autoFillForceAuthentication} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoFillForceAuthentication} field changed
     */
    public IosGeneralDeviceConfiguration withAutoFillForceAuthentication(Boolean autoFillForceAuthentication) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("autoFillForceAuthentication");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.autoFillForceAuthentication = autoFillForceAuthentication;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow modification of Bluetooth settings when the
     * device is in supervised mode (iOS 10.0 and later).”</i>
     * 
     * @return property bluetoothBlockModification
     */
    @Property(name="bluetoothBlockModification")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockModification() {
        return Optional.ofNullable(bluetoothBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow modification of Bluetooth settings when the
     * device is in supervised mode (iOS 10.0 and later).”</i>
     * 
     * @param bluetoothBlockModification
     *            new value of {@code bluetoothBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockModification} field changed
     */
    public IosGeneralDeviceConfiguration withBluetoothBlockModification(Boolean bluetoothBlockModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.bluetoothBlockModification = bluetoothBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from accessing the camera of the
     * device. Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from accessing the camera of the
     * device. Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withCameraBlocked(Boolean cameraBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block data roaming.”</i>
     * 
     * @return property cellularBlockDataRoaming
     */
    @Property(name="cellularBlockDataRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockDataRoaming() {
        return Optional.ofNullable(cellularBlockDataRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockDataRoaming} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block data roaming.”</i>
     * 
     * @param cellularBlockDataRoaming
     *            new value of {@code cellularBlockDataRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockDataRoaming} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockDataRoaming(Boolean cellularBlockDataRoaming) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockDataRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block global background fetch while roaming.”</i>
     * 
     * @return property cellularBlockGlobalBackgroundFetchWhileRoaming
     */
    @Property(name="cellularBlockGlobalBackgroundFetchWhileRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockGlobalBackgroundFetchWhileRoaming() {
        return Optional.ofNullable(cellularBlockGlobalBackgroundFetchWhileRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockGlobalBackgroundFetchWhileRoaming} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block global background fetch while roaming.”</i>
     * 
     * @param cellularBlockGlobalBackgroundFetchWhileRoaming
     *            new value of {@code cellularBlockGlobalBackgroundFetchWhileRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockGlobalBackgroundFetchWhileRoaming} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockGlobalBackgroundFetchWhileRoaming(Boolean cellularBlockGlobalBackgroundFetchWhileRoaming) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockGlobalBackgroundFetchWhileRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockGlobalBackgroundFetchWhileRoaming = cellularBlockGlobalBackgroundFetchWhileRoaming;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow changes to cellular app data usage settings
     * when the device is in supervised mode.”</i>
     * 
     * @return property cellularBlockPerAppDataModification
     */
    @Property(name="cellularBlockPerAppDataModification")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockPerAppDataModification() {
        return Optional.ofNullable(cellularBlockPerAppDataModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockPerAppDataModification} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow changes to cellular app data usage settings
     * when the device is in supervised mode.”</i>
     * 
     * @param cellularBlockPerAppDataModification
     *            new value of {@code cellularBlockPerAppDataModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockPerAppDataModification} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockPerAppDataModification(Boolean cellularBlockPerAppDataModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockPerAppDataModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockPerAppDataModification = cellularBlockPerAppDataModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Personal Hotspot.”</i>
     * 
     * @return property cellularBlockPersonalHotspot
     */
    @Property(name="cellularBlockPersonalHotspot")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockPersonalHotspot() {
        return Optional.ofNullable(cellularBlockPersonalHotspot);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockPersonalHotspot} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Personal Hotspot.”</i>
     * 
     * @param cellularBlockPersonalHotspot
     *            new value of {@code cellularBlockPersonalHotspot} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockPersonalHotspot} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockPersonalHotspot(Boolean cellularBlockPersonalHotspot) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockPersonalHotspot");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockPersonalHotspot = cellularBlockPersonalHotspot;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow users to change the settings of the cellular
     * plan on a supervised device.”</i>
     * 
     * @return property cellularBlockPlanModification
     */
    @Property(name="cellularBlockPlanModification")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockPlanModification() {
        return Optional.ofNullable(cellularBlockPlanModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockPlanModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow users to change the settings of the cellular
     * plan on a supervised device.”</i>
     * 
     * @param cellularBlockPlanModification
     *            new value of {@code cellularBlockPlanModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockPlanModification} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockPlanModification(Boolean cellularBlockPlanModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockPlanModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockPlanModification = cellularBlockPlanModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block voice roaming.”</i>
     * 
     * @return property cellularBlockVoiceRoaming
     */
    @Property(name="cellularBlockVoiceRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockVoiceRoaming() {
        return Optional.ofNullable(cellularBlockVoiceRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockVoiceRoaming} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block voice roaming.”</i>
     * 
     * @param cellularBlockVoiceRoaming
     *            new value of {@code cellularBlockVoiceRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockVoiceRoaming} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockVoiceRoaming(Boolean cellularBlockVoiceRoaming) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockVoiceRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block untrusted TLS certificates.”</i>
     * 
     * @return property certificatesBlockUntrustedTlsCertificates
     */
    @Property(name="certificatesBlockUntrustedTlsCertificates")
    @JsonIgnore
    public Optional<Boolean> getCertificatesBlockUntrustedTlsCertificates() {
        return Optional.ofNullable(certificatesBlockUntrustedTlsCertificates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificatesBlockUntrustedTlsCertificates} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block untrusted TLS certificates.”</i>
     * 
     * @param certificatesBlockUntrustedTlsCertificates
     *            new value of {@code certificatesBlockUntrustedTlsCertificates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificatesBlockUntrustedTlsCertificates} field changed
     */
    public IosGeneralDeviceConfiguration withCertificatesBlockUntrustedTlsCertificates(Boolean certificatesBlockUntrustedTlsCertificates) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("certificatesBlockUntrustedTlsCertificates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.certificatesBlockUntrustedTlsCertificates = certificatesBlockUntrustedTlsCertificates;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow remote screen observation by Classroom app
     * when the device is in supervised mode (iOS 9.3 and later).”</i>
     * 
     * @return property classroomAppBlockRemoteScreenObservation
     */
    @Property(name="classroomAppBlockRemoteScreenObservation")
    @JsonIgnore
    public Optional<Boolean> getClassroomAppBlockRemoteScreenObservation() {
        return Optional.ofNullable(classroomAppBlockRemoteScreenObservation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomAppBlockRemoteScreenObservation} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow remote screen observation by Classroom app
     * when the device is in supervised mode (iOS 9.3 and later).”</i>
     * 
     * @param classroomAppBlockRemoteScreenObservation
     *            new value of {@code classroomAppBlockRemoteScreenObservation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomAppBlockRemoteScreenObservation} field changed
     */
    public IosGeneralDeviceConfiguration withClassroomAppBlockRemoteScreenObservation(Boolean classroomAppBlockRemoteScreenObservation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomAppBlockRemoteScreenObservation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to automatically give permission to the teacher of a
     * managed course on the Classroom app to view a student's screen without prompting
     * when the device is in supervised mode.”</i>
     * 
     * @return property classroomAppForceUnpromptedScreenObservation
     */
    @Property(name="classroomAppForceUnpromptedScreenObservation")
    @JsonIgnore
    public Optional<Boolean> getClassroomAppForceUnpromptedScreenObservation() {
        return Optional.ofNullable(classroomAppForceUnpromptedScreenObservation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomAppForceUnpromptedScreenObservation} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to automatically give permission to the teacher of a
     * managed course on the Classroom app to view a student's screen without prompting
     * when the device is in supervised mode.”</i>
     * 
     * @param classroomAppForceUnpromptedScreenObservation
     *            new value of {@code classroomAppForceUnpromptedScreenObservation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomAppForceUnpromptedScreenObservation} field changed
     */
    public IosGeneralDeviceConfiguration withClassroomAppForceUnpromptedScreenObservation(Boolean classroomAppForceUnpromptedScreenObservation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomAppForceUnpromptedScreenObservation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to automatically give permission to the teacher's
     * requests, without prompting the student, when the device is in supervised mode.”</i>
     * 
     * @return property classroomForceAutomaticallyJoinClasses
     */
    @Property(name="classroomForceAutomaticallyJoinClasses")
    @JsonIgnore
    public Optional<Boolean> getClassroomForceAutomaticallyJoinClasses() {
        return Optional.ofNullable(classroomForceAutomaticallyJoinClasses);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomForceAutomaticallyJoinClasses} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to automatically give permission to the teacher's
     * requests, without prompting the student, when the device is in supervised mode.”</i>
     * 
     * @param classroomForceAutomaticallyJoinClasses
     *            new value of {@code classroomForceAutomaticallyJoinClasses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomForceAutomaticallyJoinClasses} field changed
     */
    public IosGeneralDeviceConfiguration withClassroomForceAutomaticallyJoinClasses(Boolean classroomForceAutomaticallyJoinClasses) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomForceAutomaticallyJoinClasses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the teacher to lock apps or the device without
     * prompting the student. Supervised only.”</i>
     * 
     * @return property classroomForceUnpromptedAppAndDeviceLock
     */
    @Property(name="classroomForceUnpromptedAppAndDeviceLock")
    @JsonIgnore
    public Optional<Boolean> getClassroomForceUnpromptedAppAndDeviceLock() {
        return Optional.ofNullable(classroomForceUnpromptedAppAndDeviceLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomForceUnpromptedAppAndDeviceLock} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the teacher to lock apps or the device without
     * prompting the student. Supervised only.”</i>
     * 
     * @param classroomForceUnpromptedAppAndDeviceLock
     *            new value of {@code classroomForceUnpromptedAppAndDeviceLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomForceUnpromptedAppAndDeviceLock} field changed
     */
    public IosGeneralDeviceConfiguration withClassroomForceUnpromptedAppAndDeviceLock(Boolean classroomForceUnpromptedAppAndDeviceLock) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomForceUnpromptedAppAndDeviceLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
        return _x;
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List that is in the AppComplianceList.”</i>
     * 
     * @return property compliantAppListType
     */
    @Property(name="compliantAppListType")
    @JsonIgnore
    public Optional<AppListType> getCompliantAppListType() {
        return Optional.ofNullable(compliantAppListType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantAppListType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List that is in the AppComplianceList.”</i>
     * 
     * @param compliantAppListType
     *            new value of {@code compliantAppListType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantAppListType} field changed
     */
    public IosGeneralDeviceConfiguration withCompliantAppListType(AppListType compliantAppListType) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("compliantAppListType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.compliantAppListType = compliantAppListType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from installing configuration
     * profiles and certificates interactively when the device is in supervised mode.”</i>
     * 
     * @return property configurationProfileBlockChanges
     */
    @Property(name="configurationProfileBlockChanges")
    @JsonIgnore
    public Optional<Boolean> getConfigurationProfileBlockChanges() {
        return Optional.ofNullable(configurationProfileBlockChanges);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationProfileBlockChanges} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from installing configuration
     * profiles and certificates interactively when the device is in supervised mode.”</i>
     * 
     * @param configurationProfileBlockChanges
     *            new value of {@code configurationProfileBlockChanges} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationProfileBlockChanges} field changed
     */
    public IosGeneralDeviceConfiguration withConfigurationProfileBlockChanges(Boolean configurationProfileBlockChanges) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configurationProfileBlockChanges");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.configurationProfileBlockChanges = configurationProfileBlockChanges;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block definition lookup when the device is in
     * supervised mode (iOS 8.1.3 and later ).”</i>
     * 
     * @return property definitionLookupBlocked
     */
    @Property(name="definitionLookupBlocked")
    @JsonIgnore
    public Optional<Boolean> getDefinitionLookupBlocked() {
        return Optional.ofNullable(definitionLookupBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * definitionLookupBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block definition lookup when the device is in
     * supervised mode (iOS 8.1.3 and later ).”</i>
     * 
     * @param definitionLookupBlocked
     *            new value of {@code definitionLookupBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code definitionLookupBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withDefinitionLookupBlocked(Boolean definitionLookupBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("definitionLookupBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.definitionLookupBlocked = definitionLookupBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the user to enables restrictions in the device
     * settings when the device is in supervised mode.”</i>
     * 
     * @return property deviceBlockEnableRestrictions
     */
    @Property(name="deviceBlockEnableRestrictions")
    @JsonIgnore
    public Optional<Boolean> getDeviceBlockEnableRestrictions() {
        return Optional.ofNullable(deviceBlockEnableRestrictions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceBlockEnableRestrictions} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the user to enables restrictions in the device
     * settings when the device is in supervised mode.”</i>
     * 
     * @param deviceBlockEnableRestrictions
     *            new value of {@code deviceBlockEnableRestrictions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceBlockEnableRestrictions} field changed
     */
    public IosGeneralDeviceConfiguration withDeviceBlockEnableRestrictions(Boolean deviceBlockEnableRestrictions) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceBlockEnableRestrictions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.deviceBlockEnableRestrictions = deviceBlockEnableRestrictions;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the use of the 'Erase all content and settings
     * ' option on the device when the device is in supervised mode.”</i>
     * 
     * @return property deviceBlockEraseContentAndSettings
     */
    @Property(name="deviceBlockEraseContentAndSettings")
    @JsonIgnore
    public Optional<Boolean> getDeviceBlockEraseContentAndSettings() {
        return Optional.ofNullable(deviceBlockEraseContentAndSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceBlockEraseContentAndSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the use of the 'Erase all content and settings
     * ' option on the device when the device is in supervised mode.”</i>
     * 
     * @param deviceBlockEraseContentAndSettings
     *            new value of {@code deviceBlockEraseContentAndSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceBlockEraseContentAndSettings} field changed
     */
    public IosGeneralDeviceConfiguration withDeviceBlockEraseContentAndSettings(Boolean deviceBlockEraseContentAndSettings) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceBlockEraseContentAndSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.deviceBlockEraseContentAndSettings = deviceBlockEraseContentAndSettings;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow device name modification when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @return property deviceBlockNameModification
     */
    @Property(name="deviceBlockNameModification")
    @JsonIgnore
    public Optional<Boolean> getDeviceBlockNameModification() {
        return Optional.ofNullable(deviceBlockNameModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceBlockNameModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow device name modification when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @param deviceBlockNameModification
     *            new value of {@code deviceBlockNameModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceBlockNameModification} field changed
     */
    public IosGeneralDeviceConfiguration withDeviceBlockNameModification(Boolean deviceBlockNameModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceBlockNameModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.deviceBlockNameModification = deviceBlockNameModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @return property diagnosticDataBlockSubmission
     */
    @Property(name="diagnosticDataBlockSubmission")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticDataBlockSubmission() {
        return Optional.ofNullable(diagnosticDataBlockSubmission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticDataBlockSubmission} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @param diagnosticDataBlockSubmission
     *            new value of {@code diagnosticDataBlockSubmission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticDataBlockSubmission} field changed
     */
    public IosGeneralDeviceConfiguration withDiagnosticDataBlockSubmission(Boolean diagnosticDataBlockSubmission) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("diagnosticDataBlockSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow diagnostics submission settings modification
     * when the device is in supervised mode (iOS 9.3.2 and later).”</i>
     * 
     * @return property diagnosticDataBlockSubmissionModification
     */
    @Property(name="diagnosticDataBlockSubmissionModification")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticDataBlockSubmissionModification() {
        return Optional.ofNullable(diagnosticDataBlockSubmissionModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticDataBlockSubmissionModification} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow diagnostics submission settings modification
     * when the device is in supervised mode (iOS 9.3.2 and later).”</i>
     * 
     * @param diagnosticDataBlockSubmissionModification
     *            new value of {@code diagnosticDataBlockSubmissionModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticDataBlockSubmissionModification} field changed
     */
    public IosGeneralDeviceConfiguration withDiagnosticDataBlockSubmissionModification(Boolean diagnosticDataBlockSubmissionModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("diagnosticDataBlockSubmissionModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.diagnosticDataBlockSubmissionModification = diagnosticDataBlockSubmissionModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from viewing managed documents in
     * unmanaged apps.”</i>
     * 
     * @return property documentsBlockManagedDocumentsInUnmanagedApps
     */
    @Property(name="documentsBlockManagedDocumentsInUnmanagedApps")
    @JsonIgnore
    public Optional<Boolean> getDocumentsBlockManagedDocumentsInUnmanagedApps() {
        return Optional.ofNullable(documentsBlockManagedDocumentsInUnmanagedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * documentsBlockManagedDocumentsInUnmanagedApps} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from viewing managed documents in
     * unmanaged apps.”</i>
     * 
     * @param documentsBlockManagedDocumentsInUnmanagedApps
     *            new value of {@code documentsBlockManagedDocumentsInUnmanagedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code documentsBlockManagedDocumentsInUnmanagedApps} field changed
     */
    public IosGeneralDeviceConfiguration withDocumentsBlockManagedDocumentsInUnmanagedApps(Boolean documentsBlockManagedDocumentsInUnmanagedApps) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("documentsBlockManagedDocumentsInUnmanagedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.documentsBlockManagedDocumentsInUnmanagedApps = documentsBlockManagedDocumentsInUnmanagedApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from viewing unmanaged documents in
     * managed apps.”</i>
     * 
     * @return property documentsBlockUnmanagedDocumentsInManagedApps
     */
    @Property(name="documentsBlockUnmanagedDocumentsInManagedApps")
    @JsonIgnore
    public Optional<Boolean> getDocumentsBlockUnmanagedDocumentsInManagedApps() {
        return Optional.ofNullable(documentsBlockUnmanagedDocumentsInManagedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * documentsBlockUnmanagedDocumentsInManagedApps} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from viewing unmanaged documents in
     * managed apps.”</i>
     * 
     * @param documentsBlockUnmanagedDocumentsInManagedApps
     *            new value of {@code documentsBlockUnmanagedDocumentsInManagedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code documentsBlockUnmanagedDocumentsInManagedApps} field changed
     */
    public IosGeneralDeviceConfiguration withDocumentsBlockUnmanagedDocumentsInManagedApps(Boolean documentsBlockUnmanagedDocumentsInManagedApps) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("documentsBlockUnmanagedDocumentsInManagedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.documentsBlockUnmanagedDocumentsInManagedApps = documentsBlockUnmanagedDocumentsInManagedApps;
        return _x;
    }

    /**
     * <i>“An email address lacking a suffix that matches any of these strings will be
     * considered out-of-domain.”</i>
     * 
     * @return property emailInDomainSuffixes
     */
    @Property(name="emailInDomainSuffixes")
    @JsonIgnore
    public CollectionPage<String> getEmailInDomainSuffixes() {
        return new CollectionPage<String>(contextPath, String.class, emailInDomainSuffixes, Optional.ofNullable(emailInDomainSuffixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“An email address lacking a suffix that matches any of these strings will be
     * considered out-of-domain.”</i>
     * 
     * @return property emailInDomainSuffixes
     */
    @Property(name="emailInDomainSuffixes")
    @JsonIgnore
    public CollectionPage<String> getEmailInDomainSuffixes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, emailInDomainSuffixes, Optional.ofNullable(emailInDomainSuffixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to block the user from trusting an enterprise app.”</i>
     * 
     * @return property enterpriseAppBlockTrust
     */
    @Property(name="enterpriseAppBlockTrust")
    @JsonIgnore
    public Optional<Boolean> getEnterpriseAppBlockTrust() {
        return Optional.ofNullable(enterpriseAppBlockTrust);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseAppBlockTrust} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from trusting an enterprise app.”</i>
     * 
     * @param enterpriseAppBlockTrust
     *            new value of {@code enterpriseAppBlockTrust} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseAppBlockTrust} field changed
     */
    public IosGeneralDeviceConfiguration withEnterpriseAppBlockTrust(Boolean enterpriseAppBlockTrust) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseAppBlockTrust");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.enterpriseAppBlockTrust = enterpriseAppBlockTrust;
        return _x;
    }

    /**
     * <i>“[Deprecated] Configuring this setting and setting the value to 'true' has no
     * effect on the device.”</i>
     * 
     * @return property enterpriseAppBlockTrustModification
     */
    @Property(name="enterpriseAppBlockTrustModification")
    @JsonIgnore
    public Optional<Boolean> getEnterpriseAppBlockTrustModification() {
        return Optional.ofNullable(enterpriseAppBlockTrustModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseAppBlockTrustModification} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“[Deprecated] Configuring this setting and setting the value to 'true' has no
     * effect on the device.”</i>
     * 
     * @param enterpriseAppBlockTrustModification
     *            new value of {@code enterpriseAppBlockTrustModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseAppBlockTrustModification} field changed
     */
    public IosGeneralDeviceConfiguration withEnterpriseAppBlockTrustModification(Boolean enterpriseAppBlockTrustModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseAppBlockTrustModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.enterpriseAppBlockTrustModification = enterpriseAppBlockTrustModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the addition or removal of cellular plans on
     * the eSIM of a supervised device.”</i>
     * 
     * @return property esimBlockModification
     */
    @Property(name="esimBlockModification")
    @JsonIgnore
    public Optional<Boolean> getEsimBlockModification() {
        return Optional.ofNullable(esimBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * esimBlockModification} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the addition or removal of cellular plans on
     * the eSIM of a supervised device.”</i>
     * 
     * @param esimBlockModification
     *            new value of {@code esimBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code esimBlockModification} field changed
     */
    public IosGeneralDeviceConfiguration withEsimBlockModification(Boolean esimBlockModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("esimBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.esimBlockModification = esimBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using FaceTime. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @return property faceTimeBlocked
     */
    @Property(name="faceTimeBlocked")
    @JsonIgnore
    public Optional<Boolean> getFaceTimeBlocked() {
        return Optional.ofNullable(faceTimeBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code faceTimeBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using FaceTime. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @param faceTimeBlocked
     *            new value of {@code faceTimeBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code faceTimeBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withFaceTimeBlocked(Boolean faceTimeBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("faceTimeBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.faceTimeBlocked = faceTimeBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block changes to Find My Friends when the device is
     * in supervised mode.”</i>
     * 
     * @return property findMyFriendsBlocked
     */
    @Property(name="findMyFriendsBlocked")
    @JsonIgnore
    public Optional<Boolean> getFindMyFriendsBlocked() {
        return Optional.ofNullable(findMyFriendsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * findMyFriendsBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block changes to Find My Friends when the device is
     * in supervised mode.”</i>
     * 
     * @param findMyFriendsBlocked
     *            new value of {@code findMyFriendsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code findMyFriendsBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withFindMyFriendsBlocked(Boolean findMyFriendsBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("findMyFriendsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.findMyFriendsBlocked = findMyFriendsBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from having friends in Game Center.
     * Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @return property gamingBlockGameCenterFriends
     */
    @Property(name="gamingBlockGameCenterFriends")
    @JsonIgnore
    public Optional<Boolean> getGamingBlockGameCenterFriends() {
        return Optional.ofNullable(gamingBlockGameCenterFriends);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * gamingBlockGameCenterFriends} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from having friends in Game Center.
     * Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @param gamingBlockGameCenterFriends
     *            new value of {@code gamingBlockGameCenterFriends} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code gamingBlockGameCenterFriends} field changed
     */
    public IosGeneralDeviceConfiguration withGamingBlockGameCenterFriends(Boolean gamingBlockGameCenterFriends) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("gamingBlockGameCenterFriends");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.gamingBlockGameCenterFriends = gamingBlockGameCenterFriends;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using multiplayer gaming.
     * Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @return property gamingBlockMultiplayer
     */
    @Property(name="gamingBlockMultiplayer")
    @JsonIgnore
    public Optional<Boolean> getGamingBlockMultiplayer() {
        return Optional.ofNullable(gamingBlockMultiplayer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * gamingBlockMultiplayer} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using multiplayer gaming.
     * Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @param gamingBlockMultiplayer
     *            new value of {@code gamingBlockMultiplayer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code gamingBlockMultiplayer} field changed
     */
    public IosGeneralDeviceConfiguration withGamingBlockMultiplayer(Boolean gamingBlockMultiplayer) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("gamingBlockMultiplayer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.gamingBlockMultiplayer = gamingBlockMultiplayer;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using Game Center when the
     * device is in supervised mode.”</i>
     * 
     * @return property gameCenterBlocked
     */
    @Property(name="gameCenterBlocked")
    @JsonIgnore
    public Optional<Boolean> getGameCenterBlocked() {
        return Optional.ofNullable(gameCenterBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code gameCenterBlocked
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using Game Center when the
     * device is in supervised mode.”</i>
     * 
     * @param gameCenterBlocked
     *            new value of {@code gameCenterBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code gameCenterBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withGameCenterBlocked(Boolean gameCenterBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("gameCenterBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.gameCenterBlocked = gameCenterBlocked;
        return _x;
    }

    /**
     * <i>“indicates whether or not to allow host pairing to control the devices an iOS
     * device can pair with when the iOS device is in supervised mode.”</i>
     * 
     * @return property hostPairingBlocked
     */
    @Property(name="hostPairingBlocked")
    @JsonIgnore
    public Optional<Boolean> getHostPairingBlocked() {
        return Optional.ofNullable(hostPairingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hostPairingBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“indicates whether or not to allow host pairing to control the devices an iOS
     * device can pair with when the iOS device is in supervised mode.”</i>
     * 
     * @param hostPairingBlocked
     *            new value of {@code hostPairingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hostPairingBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withHostPairingBlocked(Boolean hostPairingBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("hostPairingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.hostPairingBlocked = hostPairingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using the iBooks Store when the
     * device is in supervised mode.”</i>
     * 
     * @return property iBooksStoreBlocked
     */
    @Property(name="iBooksStoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getIBooksStoreBlocked() {
        return Optional.ofNullable(iBooksStoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iBooksStoreBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using the iBooks Store when the
     * device is in supervised mode.”</i>
     * 
     * @param iBooksStoreBlocked
     *            new value of {@code iBooksStoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iBooksStoreBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withIBooksStoreBlocked(Boolean iBooksStoreBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iBooksStoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iBooksStoreBlocked = iBooksStoreBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from downloading media from the
     * iBookstore that has been tagged as erotica.”</i>
     * 
     * @return property iBooksStoreBlockErotica
     */
    @Property(name="iBooksStoreBlockErotica")
    @JsonIgnore
    public Optional<Boolean> getIBooksStoreBlockErotica() {
        return Optional.ofNullable(iBooksStoreBlockErotica);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iBooksStoreBlockErotica} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from downloading media from the
     * iBookstore that has been tagged as erotica.”</i>
     * 
     * @param iBooksStoreBlockErotica
     *            new value of {@code iBooksStoreBlockErotica} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iBooksStoreBlockErotica} field changed
     */
    public IosGeneralDeviceConfiguration withIBooksStoreBlockErotica(Boolean iBooksStoreBlockErotica) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iBooksStoreBlockErotica");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iBooksStoreBlockErotica = iBooksStoreBlockErotica;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from continuing work they started on
     * iOS device to another iOS or macOS device.”</i>
     * 
     * @return property iCloudBlockActivityContinuation
     */
    @Property(name="iCloudBlockActivityContinuation")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockActivityContinuation() {
        return Optional.ofNullable(iCloudBlockActivityContinuation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockActivityContinuation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from continuing work they started on
     * iOS device to another iOS or macOS device.”</i>
     * 
     * @param iCloudBlockActivityContinuation
     *            new value of {@code iCloudBlockActivityContinuation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockActivityContinuation} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockActivityContinuation(Boolean iCloudBlockActivityContinuation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockActivityContinuation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud backup. Requires a supervised device
     * for iOS 13 and later.”</i>
     * 
     * @return property iCloudBlockBackup
     */
    @Property(name="iCloudBlockBackup")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockBackup() {
        return Optional.ofNullable(iCloudBlockBackup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iCloudBlockBackup
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud backup. Requires a supervised device
     * for iOS 13 and later.”</i>
     * 
     * @param iCloudBlockBackup
     *            new value of {@code iCloudBlockBackup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockBackup} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockBackup(Boolean iCloudBlockBackup) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockBackup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockBackup = iCloudBlockBackup;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud document sync. Requires a supervised
     * device for iOS 13 and later.”</i>
     * 
     * @return property iCloudBlockDocumentSync
     */
    @Property(name="iCloudBlockDocumentSync")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockDocumentSync() {
        return Optional.ofNullable(iCloudBlockDocumentSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockDocumentSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud document sync. Requires a supervised
     * device for iOS 13 and later.”</i>
     * 
     * @param iCloudBlockDocumentSync
     *            new value of {@code iCloudBlockDocumentSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockDocumentSync} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockDocumentSync(Boolean iCloudBlockDocumentSync) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockDocumentSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Managed Apps Cloud Sync.”</i>
     * 
     * @return property iCloudBlockManagedAppsSync
     */
    @Property(name="iCloudBlockManagedAppsSync")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockManagedAppsSync() {
        return Optional.ofNullable(iCloudBlockManagedAppsSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockManagedAppsSync} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Managed Apps Cloud Sync.”</i>
     * 
     * @param iCloudBlockManagedAppsSync
     *            new value of {@code iCloudBlockManagedAppsSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockManagedAppsSync} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockManagedAppsSync(Boolean iCloudBlockManagedAppsSync) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockManagedAppsSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockManagedAppsSync = iCloudBlockManagedAppsSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud Photo Library.”</i>
     * 
     * @return property iCloudBlockPhotoLibrary
     */
    @Property(name="iCloudBlockPhotoLibrary")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockPhotoLibrary() {
        return Optional.ofNullable(iCloudBlockPhotoLibrary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockPhotoLibrary} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud Photo Library.”</i>
     * 
     * @param iCloudBlockPhotoLibrary
     *            new value of {@code iCloudBlockPhotoLibrary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockPhotoLibrary} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockPhotoLibrary(Boolean iCloudBlockPhotoLibrary) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockPhotoLibrary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block iCloud Photo Stream Sync.”</i>
     * 
     * @return property iCloudBlockPhotoStreamSync
     */
    @Property(name="iCloudBlockPhotoStreamSync")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockPhotoStreamSync() {
        return Optional.ofNullable(iCloudBlockPhotoStreamSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockPhotoStreamSync} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block iCloud Photo Stream Sync.”</i>
     * 
     * @param iCloudBlockPhotoStreamSync
     *            new value of {@code iCloudBlockPhotoStreamSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockPhotoStreamSync} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockPhotoStreamSync(Boolean iCloudBlockPhotoStreamSync) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockPhotoStreamSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockPhotoStreamSync = iCloudBlockPhotoStreamSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Shared Photo Stream.”</i>
     * 
     * @return property iCloudBlockSharedPhotoStream
     */
    @Property(name="iCloudBlockSharedPhotoStream")
    @JsonIgnore
    public Optional<Boolean> getICloudBlockSharedPhotoStream() {
        return Optional.ofNullable(iCloudBlockSharedPhotoStream);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudBlockSharedPhotoStream} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Shared Photo Stream.”</i>
     * 
     * @param iCloudBlockSharedPhotoStream
     *            new value of {@code iCloudBlockSharedPhotoStream} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudBlockSharedPhotoStream} field changed
     */
    public IosGeneralDeviceConfiguration withICloudBlockSharedPhotoStream(Boolean iCloudBlockSharedPhotoStream) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudBlockSharedPhotoStream");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudBlockSharedPhotoStream = iCloudBlockSharedPhotoStream;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require backups to iCloud be encrypted.”</i>
     * 
     * @return property iCloudRequireEncryptedBackup
     */
    @Property(name="iCloudRequireEncryptedBackup")
    @JsonIgnore
    public Optional<Boolean> getICloudRequireEncryptedBackup() {
        return Optional.ofNullable(iCloudRequireEncryptedBackup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iCloudRequireEncryptedBackup} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require backups to iCloud be encrypted.”</i>
     * 
     * @param iCloudRequireEncryptedBackup
     *            new value of {@code iCloudRequireEncryptedBackup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iCloudRequireEncryptedBackup} field changed
     */
    public IosGeneralDeviceConfiguration withICloudRequireEncryptedBackup(Boolean iCloudRequireEncryptedBackup) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iCloudRequireEncryptedBackup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iCloudRequireEncryptedBackup = iCloudRequireEncryptedBackup;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from accessing explicit content in
     * iTunes and the App Store. Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @return property iTunesBlockExplicitContent
     */
    @Property(name="iTunesBlockExplicitContent")
    @JsonIgnore
    public Optional<Boolean> getITunesBlockExplicitContent() {
        return Optional.ofNullable(iTunesBlockExplicitContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iTunesBlockExplicitContent} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from accessing explicit content in
     * iTunes and the App Store. Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @param iTunesBlockExplicitContent
     *            new value of {@code iTunesBlockExplicitContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesBlockExplicitContent} field changed
     */
    public IosGeneralDeviceConfiguration withITunesBlockExplicitContent(Boolean iTunesBlockExplicitContent) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iTunesBlockExplicitContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iTunesBlockExplicitContent = iTunesBlockExplicitContent;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Music service and revert Music app to classic
     * mode when the device is in supervised mode (iOS 9.3 and later and macOS 10.12
     * and later).”</i>
     * 
     * @return property iTunesBlockMusicService
     */
    @Property(name="iTunesBlockMusicService")
    @JsonIgnore
    public Optional<Boolean> getITunesBlockMusicService() {
        return Optional.ofNullable(iTunesBlockMusicService);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iTunesBlockMusicService} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Music service and revert Music app to classic
     * mode when the device is in supervised mode (iOS 9.3 and later and macOS 10.12
     * and later).”</i>
     * 
     * @param iTunesBlockMusicService
     *            new value of {@code iTunesBlockMusicService} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesBlockMusicService} field changed
     */
    public IosGeneralDeviceConfiguration withITunesBlockMusicService(Boolean iTunesBlockMusicService) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iTunesBlockMusicService");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iTunesBlockMusicService = iTunesBlockMusicService;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using iTunes Radio when the
     * device is in supervised mode (iOS 9.3 and later).”</i>
     * 
     * @return property iTunesBlockRadio
     */
    @Property(name="iTunesBlockRadio")
    @JsonIgnore
    public Optional<Boolean> getITunesBlockRadio() {
        return Optional.ofNullable(iTunesBlockRadio);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iTunesBlockRadio}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using iTunes Radio when the
     * device is in supervised mode (iOS 9.3 and later).”</i>
     * 
     * @param iTunesBlockRadio
     *            new value of {@code iTunesBlockRadio} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesBlockRadio} field changed
     */
    public IosGeneralDeviceConfiguration withITunesBlockRadio(Boolean iTunesBlockRadio) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iTunesBlockRadio");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iTunesBlockRadio = iTunesBlockRadio;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block keyboard auto-correction when the device is in
     * supervised mode (iOS 8.1.3 and later).”</i>
     * 
     * @return property keyboardBlockAutoCorrect
     */
    @Property(name="keyboardBlockAutoCorrect")
    @JsonIgnore
    public Optional<Boolean> getKeyboardBlockAutoCorrect() {
        return Optional.ofNullable(keyboardBlockAutoCorrect);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardBlockAutoCorrect} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block keyboard auto-correction when the device is in
     * supervised mode (iOS 8.1.3 and later).”</i>
     * 
     * @param keyboardBlockAutoCorrect
     *            new value of {@code keyboardBlockAutoCorrect} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardBlockAutoCorrect} field changed
     */
    public IosGeneralDeviceConfiguration withKeyboardBlockAutoCorrect(Boolean keyboardBlockAutoCorrect) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyboardBlockAutoCorrect");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.keyboardBlockAutoCorrect = keyboardBlockAutoCorrect;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using dictation input when the
     * device is in supervised mode.”</i>
     * 
     * @return property keyboardBlockDictation
     */
    @Property(name="keyboardBlockDictation")
    @JsonIgnore
    public Optional<Boolean> getKeyboardBlockDictation() {
        return Optional.ofNullable(keyboardBlockDictation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardBlockDictation} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using dictation input when the
     * device is in supervised mode.”</i>
     * 
     * @param keyboardBlockDictation
     *            new value of {@code keyboardBlockDictation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardBlockDictation} field changed
     */
    public IosGeneralDeviceConfiguration withKeyboardBlockDictation(Boolean keyboardBlockDictation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyboardBlockDictation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.keyboardBlockDictation = keyboardBlockDictation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block predictive keyboards when device is in
     * supervised mode (iOS 8.1.3 and later).”</i>
     * 
     * @return property keyboardBlockPredictive
     */
    @Property(name="keyboardBlockPredictive")
    @JsonIgnore
    public Optional<Boolean> getKeyboardBlockPredictive() {
        return Optional.ofNullable(keyboardBlockPredictive);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardBlockPredictive} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block predictive keyboards when device is in
     * supervised mode (iOS 8.1.3 and later).”</i>
     * 
     * @param keyboardBlockPredictive
     *            new value of {@code keyboardBlockPredictive} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardBlockPredictive} field changed
     */
    public IosGeneralDeviceConfiguration withKeyboardBlockPredictive(Boolean keyboardBlockPredictive) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyboardBlockPredictive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.keyboardBlockPredictive = keyboardBlockPredictive;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block keyboard shortcuts when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @return property keyboardBlockShortcuts
     */
    @Property(name="keyboardBlockShortcuts")
    @JsonIgnore
    public Optional<Boolean> getKeyboardBlockShortcuts() {
        return Optional.ofNullable(keyboardBlockShortcuts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardBlockShortcuts} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block keyboard shortcuts when the device is in
     * supervised mode (iOS 9.0 and later).”</i>
     * 
     * @param keyboardBlockShortcuts
     *            new value of {@code keyboardBlockShortcuts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardBlockShortcuts} field changed
     */
    public IosGeneralDeviceConfiguration withKeyboardBlockShortcuts(Boolean keyboardBlockShortcuts) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyboardBlockShortcuts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.keyboardBlockShortcuts = keyboardBlockShortcuts;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block keyboard spell-checking when the device is in
     * supervised mode (iOS 8.1.3 and later).”</i>
     * 
     * @return property keyboardBlockSpellCheck
     */
    @Property(name="keyboardBlockSpellCheck")
    @JsonIgnore
    public Optional<Boolean> getKeyboardBlockSpellCheck() {
        return Optional.ofNullable(keyboardBlockSpellCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardBlockSpellCheck} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block keyboard spell-checking when the device is in
     * supervised mode (iOS 8.1.3 and later).”</i>
     * 
     * @param keyboardBlockSpellCheck
     *            new value of {@code keyboardBlockSpellCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardBlockSpellCheck} field changed
     */
    public IosGeneralDeviceConfiguration withKeyboardBlockSpellCheck(Boolean keyboardBlockSpellCheck) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyboardBlockSpellCheck");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.keyboardBlockSpellCheck = keyboardBlockSpellCheck;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow assistive speak while in kiosk mode.”</i>
     * 
     * @return property kioskModeAllowAssistiveSpeak
     */
    @Property(name="kioskModeAllowAssistiveSpeak")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowAssistiveSpeak() {
        return Optional.ofNullable(kioskModeAllowAssistiveSpeak);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowAssistiveSpeak} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow assistive speak while in kiosk mode.”</i>
     * 
     * @param kioskModeAllowAssistiveSpeak
     *            new value of {@code kioskModeAllowAssistiveSpeak} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowAssistiveSpeak} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowAssistiveSpeak(Boolean kioskModeAllowAssistiveSpeak) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowAssistiveSpeak");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowAssistiveSpeak = kioskModeAllowAssistiveSpeak;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow access to the Assistive Touch Settings while
     * in kiosk mode.”</i>
     * 
     * @return property kioskModeAllowAssistiveTouchSettings
     */
    @Property(name="kioskModeAllowAssistiveTouchSettings")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowAssistiveTouchSettings() {
        return Optional.ofNullable(kioskModeAllowAssistiveTouchSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowAssistiveTouchSettings} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow access to the Assistive Touch Settings while
     * in kiosk mode.”</i>
     * 
     * @param kioskModeAllowAssistiveTouchSettings
     *            new value of {@code kioskModeAllowAssistiveTouchSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowAssistiveTouchSettings} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowAssistiveTouchSettings(Boolean kioskModeAllowAssistiveTouchSettings) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowAssistiveTouchSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowAssistiveTouchSettings = kioskModeAllowAssistiveTouchSettings;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow device auto lock while in kiosk mode. This
     * property's functionality is redundant with the OS default and is deprecated. Use
     * KioskModeBlockAutoLock instead.”</i>
     * 
     * @return property kioskModeAllowAutoLock
     */
    @Property(name="kioskModeAllowAutoLock")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowAutoLock() {
        return Optional.ofNullable(kioskModeAllowAutoLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowAutoLock} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow device auto lock while in kiosk mode. This
     * property's functionality is redundant with the OS default and is deprecated. Use
     * KioskModeBlockAutoLock instead.”</i>
     * 
     * @param kioskModeAllowAutoLock
     *            new value of {@code kioskModeAllowAutoLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowAutoLock} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowAutoLock(Boolean kioskModeAllowAutoLock) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowAutoLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowAutoLock = kioskModeAllowAutoLock;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block device auto lock while in kiosk mode.”</i>
     * 
     * @return property kioskModeBlockAutoLock
     */
    @Property(name="kioskModeBlockAutoLock")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockAutoLock() {
        return Optional.ofNullable(kioskModeBlockAutoLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockAutoLock} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block device auto lock while in kiosk mode.”</i>
     * 
     * @param kioskModeBlockAutoLock
     *            new value of {@code kioskModeBlockAutoLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockAutoLock} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBlockAutoLock(Boolean kioskModeBlockAutoLock) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockAutoLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBlockAutoLock = kioskModeBlockAutoLock;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow access to the Color Inversion Settings while
     * in kiosk mode.”</i>
     * 
     * @return property kioskModeAllowColorInversionSettings
     */
    @Property(name="kioskModeAllowColorInversionSettings")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowColorInversionSettings() {
        return Optional.ofNullable(kioskModeAllowColorInversionSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowColorInversionSettings} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow access to the Color Inversion Settings while
     * in kiosk mode.”</i>
     * 
     * @param kioskModeAllowColorInversionSettings
     *            new value of {@code kioskModeAllowColorInversionSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowColorInversionSettings} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowColorInversionSettings(Boolean kioskModeAllowColorInversionSettings) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowColorInversionSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowColorInversionSettings = kioskModeAllowColorInversionSettings;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow use of the ringer switch while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockRingerSwitch instead.”</i>
     * 
     * @return property kioskModeAllowRingerSwitch
     */
    @Property(name="kioskModeAllowRingerSwitch")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowRingerSwitch() {
        return Optional.ofNullable(kioskModeAllowRingerSwitch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowRingerSwitch} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow use of the ringer switch while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockRingerSwitch instead.”</i>
     * 
     * @param kioskModeAllowRingerSwitch
     *            new value of {@code kioskModeAllowRingerSwitch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowRingerSwitch} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowRingerSwitch(Boolean kioskModeAllowRingerSwitch) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowRingerSwitch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowRingerSwitch = kioskModeAllowRingerSwitch;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block use of the ringer switch while in kiosk mode.”</i>
     * 
     * @return property kioskModeBlockRingerSwitch
     */
    @Property(name="kioskModeBlockRingerSwitch")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockRingerSwitch() {
        return Optional.ofNullable(kioskModeBlockRingerSwitch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockRingerSwitch} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block use of the ringer switch while in kiosk mode.”</i>
     * 
     * @param kioskModeBlockRingerSwitch
     *            new value of {@code kioskModeBlockRingerSwitch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockRingerSwitch} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBlockRingerSwitch(Boolean kioskModeBlockRingerSwitch) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockRingerSwitch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBlockRingerSwitch = kioskModeBlockRingerSwitch;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow screen rotation while in kiosk mode. This
     * property's functionality is redundant with the OS default and is deprecated. Use
     * KioskModeBlockScreenRotation instead.”</i>
     * 
     * @return property kioskModeAllowScreenRotation
     */
    @Property(name="kioskModeAllowScreenRotation")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowScreenRotation() {
        return Optional.ofNullable(kioskModeAllowScreenRotation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowScreenRotation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow screen rotation while in kiosk mode. This
     * property's functionality is redundant with the OS default and is deprecated. Use
     * KioskModeBlockScreenRotation instead.”</i>
     * 
     * @param kioskModeAllowScreenRotation
     *            new value of {@code kioskModeAllowScreenRotation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowScreenRotation} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowScreenRotation(Boolean kioskModeAllowScreenRotation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowScreenRotation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowScreenRotation = kioskModeAllowScreenRotation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block screen rotation while in kiosk mode.”</i>
     * 
     * @return property kioskModeBlockScreenRotation
     */
    @Property(name="kioskModeBlockScreenRotation")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockScreenRotation() {
        return Optional.ofNullable(kioskModeBlockScreenRotation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockScreenRotation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block screen rotation while in kiosk mode.”</i>
     * 
     * @param kioskModeBlockScreenRotation
     *            new value of {@code kioskModeBlockScreenRotation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockScreenRotation} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBlockScreenRotation(Boolean kioskModeBlockScreenRotation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockScreenRotation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBlockScreenRotation = kioskModeBlockScreenRotation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow use of the sleep button while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockSleepButton instead.”</i>
     * 
     * @return property kioskModeAllowSleepButton
     */
    @Property(name="kioskModeAllowSleepButton")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowSleepButton() {
        return Optional.ofNullable(kioskModeAllowSleepButton);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowSleepButton} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow use of the sleep button while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockSleepButton instead.”</i>
     * 
     * @param kioskModeAllowSleepButton
     *            new value of {@code kioskModeAllowSleepButton} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowSleepButton} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowSleepButton(Boolean kioskModeAllowSleepButton) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowSleepButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowSleepButton = kioskModeAllowSleepButton;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block use of the sleep button while in kiosk mode.”</i>
     * 
     * @return property kioskModeBlockSleepButton
     */
    @Property(name="kioskModeBlockSleepButton")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockSleepButton() {
        return Optional.ofNullable(kioskModeBlockSleepButton);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockSleepButton} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block use of the sleep button while in kiosk mode.”</i>
     * 
     * @param kioskModeBlockSleepButton
     *            new value of {@code kioskModeBlockSleepButton} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockSleepButton} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBlockSleepButton(Boolean kioskModeBlockSleepButton) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockSleepButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow use of the touchscreen while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockTouchscreen instead.”</i>
     * 
     * @return property kioskModeAllowTouchscreen
     */
    @Property(name="kioskModeAllowTouchscreen")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowTouchscreen() {
        return Optional.ofNullable(kioskModeAllowTouchscreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowTouchscreen} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow use of the touchscreen while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockTouchscreen instead.”</i>
     * 
     * @param kioskModeAllowTouchscreen
     *            new value of {@code kioskModeAllowTouchscreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowTouchscreen} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowTouchscreen(Boolean kioskModeAllowTouchscreen) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowTouchscreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowTouchscreen = kioskModeAllowTouchscreen;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block use of the touchscreen while in kiosk mode.”</i>
     * 
     * @return property kioskModeBlockTouchscreen
     */
    @Property(name="kioskModeBlockTouchscreen")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockTouchscreen() {
        return Optional.ofNullable(kioskModeBlockTouchscreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockTouchscreen} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block use of the touchscreen while in kiosk mode.”</i>
     * 
     * @param kioskModeBlockTouchscreen
     *            new value of {@code kioskModeBlockTouchscreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockTouchscreen} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBlockTouchscreen(Boolean kioskModeBlockTouchscreen) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockTouchscreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBlockTouchscreen = kioskModeBlockTouchscreen;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enable voice control in kiosk mode.”</i>
     * 
     * @return property kioskModeEnableVoiceControl
     */
    @Property(name="kioskModeEnableVoiceControl")
    @JsonIgnore
    public Optional<Boolean> getKioskModeEnableVoiceControl() {
        return Optional.ofNullable(kioskModeEnableVoiceControl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeEnableVoiceControl} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enable voice control in kiosk mode.”</i>
     * 
     * @param kioskModeEnableVoiceControl
     *            new value of {@code kioskModeEnableVoiceControl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeEnableVoiceControl} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeEnableVoiceControl(Boolean kioskModeEnableVoiceControl) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeEnableVoiceControl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeEnableVoiceControl = kioskModeEnableVoiceControl;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the user to toggle voice control in kiosk mode
     * .”</i>
     * 
     * @return property kioskModeAllowVoiceControlModification
     */
    @Property(name="kioskModeAllowVoiceControlModification")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowVoiceControlModification() {
        return Optional.ofNullable(kioskModeAllowVoiceControlModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowVoiceControlModification} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the user to toggle voice control in kiosk mode
     * .”</i>
     * 
     * @param kioskModeAllowVoiceControlModification
     *            new value of {@code kioskModeAllowVoiceControlModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowVoiceControlModification} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowVoiceControlModification(Boolean kioskModeAllowVoiceControlModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowVoiceControlModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowVoiceControlModification = kioskModeAllowVoiceControlModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow access to the voice over settings while in
     * kiosk mode.”</i>
     * 
     * @return property kioskModeAllowVoiceOverSettings
     */
    @Property(name="kioskModeAllowVoiceOverSettings")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowVoiceOverSettings() {
        return Optional.ofNullable(kioskModeAllowVoiceOverSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowVoiceOverSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow access to the voice over settings while in
     * kiosk mode.”</i>
     * 
     * @param kioskModeAllowVoiceOverSettings
     *            new value of {@code kioskModeAllowVoiceOverSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowVoiceOverSettings} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowVoiceOverSettings(Boolean kioskModeAllowVoiceOverSettings) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowVoiceOverSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowVoiceOverSettings = kioskModeAllowVoiceOverSettings;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow use of the volume buttons while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockVolumeButtons instead.”</i>
     * 
     * @return property kioskModeAllowVolumeButtons
     */
    @Property(name="kioskModeAllowVolumeButtons")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowVolumeButtons() {
        return Optional.ofNullable(kioskModeAllowVolumeButtons);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowVolumeButtons} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow use of the volume buttons while in kiosk mode.
     * This property's functionality is redundant with the OS default and is deprecated
     * . Use KioskModeBlockVolumeButtons instead.”</i>
     * 
     * @param kioskModeAllowVolumeButtons
     *            new value of {@code kioskModeAllowVolumeButtons} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowVolumeButtons} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowVolumeButtons(Boolean kioskModeAllowVolumeButtons) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowVolumeButtons");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowVolumeButtons = kioskModeAllowVolumeButtons;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the volume buttons while in Kiosk Mode.”</i>
     * 
     * @return property kioskModeBlockVolumeButtons
     */
    @Property(name="kioskModeBlockVolumeButtons")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockVolumeButtons() {
        return Optional.ofNullable(kioskModeBlockVolumeButtons);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockVolumeButtons} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the volume buttons while in Kiosk Mode.”</i>
     * 
     * @param kioskModeBlockVolumeButtons
     *            new value of {@code kioskModeBlockVolumeButtons} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockVolumeButtons} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBlockVolumeButtons(Boolean kioskModeBlockVolumeButtons) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockVolumeButtons");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow access to the zoom settings while in kiosk
     * mode.”</i>
     * 
     * @return property kioskModeAllowZoomSettings
     */
    @Property(name="kioskModeAllowZoomSettings")
    @JsonIgnore
    public Optional<Boolean> getKioskModeAllowZoomSettings() {
        return Optional.ofNullable(kioskModeAllowZoomSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAllowZoomSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow access to the zoom settings while in kiosk
     * mode.”</i>
     * 
     * @param kioskModeAllowZoomSettings
     *            new value of {@code kioskModeAllowZoomSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAllowZoomSettings} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAllowZoomSettings(Boolean kioskModeAllowZoomSettings) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAllowZoomSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAllowZoomSettings = kioskModeAllowZoomSettings;
        return _x;
    }

    /**
     * <i>“URL in the app store to the app to use for kiosk mode. Use if
     * KioskModeManagedAppId is not known.”</i>
     * 
     * @return property kioskModeAppStoreUrl
     */
    @Property(name="kioskModeAppStoreUrl")
    @JsonIgnore
    public Optional<String> getKioskModeAppStoreUrl() {
        return Optional.ofNullable(kioskModeAppStoreUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeAppStoreUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“URL in the app store to the app to use for kiosk mode. Use if
     * KioskModeManagedAppId is not known.”</i>
     * 
     * @param kioskModeAppStoreUrl
     *            new value of {@code kioskModeAppStoreUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAppStoreUrl} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAppStoreUrl(String kioskModeAppStoreUrl) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAppStoreUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAppStoreUrl = kioskModeAppStoreUrl;
        return _x;
    }

    /**
     * <i>“ID for built-in apps to use for kiosk mode. Used when KioskModeManagedAppId and
     * KioskModeAppStoreUrl are not set.”</i>
     * 
     * @return property kioskModeBuiltInAppId
     */
    @Property(name="kioskModeBuiltInAppId")
    @JsonIgnore
    public Optional<String> getKioskModeBuiltInAppId() {
        return Optional.ofNullable(kioskModeBuiltInAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBuiltInAppId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“ID for built-in apps to use for kiosk mode. Used when KioskModeManagedAppId and
     * KioskModeAppStoreUrl are not set.”</i>
     * 
     * @param kioskModeBuiltInAppId
     *            new value of {@code kioskModeBuiltInAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBuiltInAppId} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeBuiltInAppId(String kioskModeBuiltInAppId) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBuiltInAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeBuiltInAppId = kioskModeBuiltInAppId;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require assistive touch while in kiosk mode.”</i>
     * 
     * @return property kioskModeRequireAssistiveTouch
     */
    @Property(name="kioskModeRequireAssistiveTouch")
    @JsonIgnore
    public Optional<Boolean> getKioskModeRequireAssistiveTouch() {
        return Optional.ofNullable(kioskModeRequireAssistiveTouch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeRequireAssistiveTouch} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require assistive touch while in kiosk mode.”</i>
     * 
     * @param kioskModeRequireAssistiveTouch
     *            new value of {@code kioskModeRequireAssistiveTouch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeRequireAssistiveTouch} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeRequireAssistiveTouch(Boolean kioskModeRequireAssistiveTouch) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeRequireAssistiveTouch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeRequireAssistiveTouch = kioskModeRequireAssistiveTouch;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require color inversion while in kiosk mode.”</i>
     * 
     * @return property kioskModeRequireColorInversion
     */
    @Property(name="kioskModeRequireColorInversion")
    @JsonIgnore
    public Optional<Boolean> getKioskModeRequireColorInversion() {
        return Optional.ofNullable(kioskModeRequireColorInversion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeRequireColorInversion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require color inversion while in kiosk mode.”</i>
     * 
     * @param kioskModeRequireColorInversion
     *            new value of {@code kioskModeRequireColorInversion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeRequireColorInversion} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeRequireColorInversion(Boolean kioskModeRequireColorInversion) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeRequireColorInversion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeRequireColorInversion = kioskModeRequireColorInversion;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require mono audio while in kiosk mode.”</i>
     * 
     * @return property kioskModeRequireMonoAudio
     */
    @Property(name="kioskModeRequireMonoAudio")
    @JsonIgnore
    public Optional<Boolean> getKioskModeRequireMonoAudio() {
        return Optional.ofNullable(kioskModeRequireMonoAudio);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeRequireMonoAudio} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require mono audio while in kiosk mode.”</i>
     * 
     * @param kioskModeRequireMonoAudio
     *            new value of {@code kioskModeRequireMonoAudio} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeRequireMonoAudio} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeRequireMonoAudio(Boolean kioskModeRequireMonoAudio) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeRequireMonoAudio");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeRequireMonoAudio = kioskModeRequireMonoAudio;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require voice over while in kiosk mode.”</i>
     * 
     * @return property kioskModeRequireVoiceOver
     */
    @Property(name="kioskModeRequireVoiceOver")
    @JsonIgnore
    public Optional<Boolean> getKioskModeRequireVoiceOver() {
        return Optional.ofNullable(kioskModeRequireVoiceOver);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeRequireVoiceOver} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require voice over while in kiosk mode.”</i>
     * 
     * @param kioskModeRequireVoiceOver
     *            new value of {@code kioskModeRequireVoiceOver} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeRequireVoiceOver} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeRequireVoiceOver(Boolean kioskModeRequireVoiceOver) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeRequireVoiceOver");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeRequireVoiceOver = kioskModeRequireVoiceOver;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require zoom while in kiosk mode.”</i>
     * 
     * @return property kioskModeRequireZoom
     */
    @Property(name="kioskModeRequireZoom")
    @JsonIgnore
    public Optional<Boolean> getKioskModeRequireZoom() {
        return Optional.ofNullable(kioskModeRequireZoom);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeRequireZoom} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require zoom while in kiosk mode.”</i>
     * 
     * @param kioskModeRequireZoom
     *            new value of {@code kioskModeRequireZoom} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeRequireZoom} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeRequireZoom(Boolean kioskModeRequireZoom) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeRequireZoom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeRequireZoom = kioskModeRequireZoom;
        return _x;
    }

    /**
     * <i>“Managed app id of the app to use for kiosk mode. If KioskModeManagedAppId is
     * specified then KioskModeAppStoreUrl will be ignored.”</i>
     * 
     * @return property kioskModeManagedAppId
     */
    @Property(name="kioskModeManagedAppId")
    @JsonIgnore
    public Optional<String> getKioskModeManagedAppId() {
        return Optional.ofNullable(kioskModeManagedAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeManagedAppId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Managed app id of the app to use for kiosk mode. If KioskModeManagedAppId is
     * specified then KioskModeAppStoreUrl will be ignored.”</i>
     * 
     * @param kioskModeManagedAppId
     *            new value of {@code kioskModeManagedAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeManagedAppId} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeManagedAppId(String kioskModeManagedAppId) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeManagedAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeManagedAppId = kioskModeManagedAppId;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using control center on the lock
     * screen.”</i>
     * 
     * @return property lockScreenBlockControlCenter
     */
    @Property(name="lockScreenBlockControlCenter")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockControlCenter() {
        return Optional.ofNullable(lockScreenBlockControlCenter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockControlCenter} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using control center on the lock
     * screen.”</i>
     * 
     * @param lockScreenBlockControlCenter
     *            new value of {@code lockScreenBlockControlCenter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockControlCenter} field changed
     */
    public IosGeneralDeviceConfiguration withLockScreenBlockControlCenter(Boolean lockScreenBlockControlCenter) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockControlCenter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.lockScreenBlockControlCenter = lockScreenBlockControlCenter;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using the notification view on
     * the lock screen.”</i>
     * 
     * @return property lockScreenBlockNotificationView
     */
    @Property(name="lockScreenBlockNotificationView")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockNotificationView() {
        return Optional.ofNullable(lockScreenBlockNotificationView);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockNotificationView} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using the notification view on
     * the lock screen.”</i>
     * 
     * @param lockScreenBlockNotificationView
     *            new value of {@code lockScreenBlockNotificationView} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockNotificationView} field changed
     */
    public IosGeneralDeviceConfiguration withLockScreenBlockNotificationView(Boolean lockScreenBlockNotificationView) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockNotificationView");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.lockScreenBlockNotificationView = lockScreenBlockNotificationView;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using passbook when the device
     * is locked.”</i>
     * 
     * @return property lockScreenBlockPassbook
     */
    @Property(name="lockScreenBlockPassbook")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockPassbook() {
        return Optional.ofNullable(lockScreenBlockPassbook);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockPassbook} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using passbook when the device
     * is locked.”</i>
     * 
     * @param lockScreenBlockPassbook
     *            new value of {@code lockScreenBlockPassbook} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockPassbook} field changed
     */
    public IosGeneralDeviceConfiguration withLockScreenBlockPassbook(Boolean lockScreenBlockPassbook) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockPassbook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.lockScreenBlockPassbook = lockScreenBlockPassbook;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using the Today View on the lock
     * screen.”</i>
     * 
     * @return property lockScreenBlockTodayView
     */
    @Property(name="lockScreenBlockTodayView")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockTodayView() {
        return Optional.ofNullable(lockScreenBlockTodayView);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockTodayView} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using the Today View on the lock
     * screen.”</i>
     * 
     * @param lockScreenBlockTodayView
     *            new value of {@code lockScreenBlockTodayView} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockTodayView} field changed
     */
    public IosGeneralDeviceConfiguration withLockScreenBlockTodayView(Boolean lockScreenBlockTodayView) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockTodayView");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.lockScreenBlockTodayView = lockScreenBlockTodayView;
        return _x;
    }

    /**
     * <i>“Media content rating settings for Australia”</i>
     * 
     * @return property mediaContentRatingAustralia
     */
    @Property(name="mediaContentRatingAustralia")
    @JsonIgnore
    public Optional<MediaContentRatingAustralia> getMediaContentRatingAustralia() {
        return Optional.ofNullable(mediaContentRatingAustralia);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingAustralia} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for Australia”</i>
     * 
     * @param mediaContentRatingAustralia
     *            new value of {@code mediaContentRatingAustralia} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingAustralia} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingAustralia(MediaContentRatingAustralia mediaContentRatingAustralia) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingAustralia");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingAustralia = mediaContentRatingAustralia;
        return _x;
    }

    /**
     * <i>“Media content rating settings for Canada”</i>
     * 
     * @return property mediaContentRatingCanada
     */
    @Property(name="mediaContentRatingCanada")
    @JsonIgnore
    public Optional<MediaContentRatingCanada> getMediaContentRatingCanada() {
        return Optional.ofNullable(mediaContentRatingCanada);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingCanada} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for Canada”</i>
     * 
     * @param mediaContentRatingCanada
     *            new value of {@code mediaContentRatingCanada} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingCanada} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingCanada(MediaContentRatingCanada mediaContentRatingCanada) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingCanada");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingCanada = mediaContentRatingCanada;
        return _x;
    }

    /**
     * <i>“Media content rating settings for France”</i>
     * 
     * @return property mediaContentRatingFrance
     */
    @Property(name="mediaContentRatingFrance")
    @JsonIgnore
    public Optional<MediaContentRatingFrance> getMediaContentRatingFrance() {
        return Optional.ofNullable(mediaContentRatingFrance);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingFrance} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for France”</i>
     * 
     * @param mediaContentRatingFrance
     *            new value of {@code mediaContentRatingFrance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingFrance} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingFrance(MediaContentRatingFrance mediaContentRatingFrance) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingFrance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingFrance = mediaContentRatingFrance;
        return _x;
    }

    /**
     * <i>“Media content rating settings for Germany”</i>
     * 
     * @return property mediaContentRatingGermany
     */
    @Property(name="mediaContentRatingGermany")
    @JsonIgnore
    public Optional<MediaContentRatingGermany> getMediaContentRatingGermany() {
        return Optional.ofNullable(mediaContentRatingGermany);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingGermany} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for Germany”</i>
     * 
     * @param mediaContentRatingGermany
     *            new value of {@code mediaContentRatingGermany} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingGermany} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingGermany(MediaContentRatingGermany mediaContentRatingGermany) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingGermany");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingGermany = mediaContentRatingGermany;
        return _x;
    }

    /**
     * <i>“Media content rating settings for Ireland”</i>
     * 
     * @return property mediaContentRatingIreland
     */
    @Property(name="mediaContentRatingIreland")
    @JsonIgnore
    public Optional<MediaContentRatingIreland> getMediaContentRatingIreland() {
        return Optional.ofNullable(mediaContentRatingIreland);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingIreland} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for Ireland”</i>
     * 
     * @param mediaContentRatingIreland
     *            new value of {@code mediaContentRatingIreland} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingIreland} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingIreland(MediaContentRatingIreland mediaContentRatingIreland) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingIreland");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingIreland = mediaContentRatingIreland;
        return _x;
    }

    /**
     * <i>“Media content rating settings for Japan”</i>
     * 
     * @return property mediaContentRatingJapan
     */
    @Property(name="mediaContentRatingJapan")
    @JsonIgnore
    public Optional<MediaContentRatingJapan> getMediaContentRatingJapan() {
        return Optional.ofNullable(mediaContentRatingJapan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingJapan} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for Japan”</i>
     * 
     * @param mediaContentRatingJapan
     *            new value of {@code mediaContentRatingJapan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingJapan} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingJapan(MediaContentRatingJapan mediaContentRatingJapan) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingJapan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingJapan = mediaContentRatingJapan;
        return _x;
    }

    /**
     * <i>“Media content rating settings for New Zealand”</i>
     * 
     * @return property mediaContentRatingNewZealand
     */
    @Property(name="mediaContentRatingNewZealand")
    @JsonIgnore
    public Optional<MediaContentRatingNewZealand> getMediaContentRatingNewZealand() {
        return Optional.ofNullable(mediaContentRatingNewZealand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingNewZealand} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for New Zealand”</i>
     * 
     * @param mediaContentRatingNewZealand
     *            new value of {@code mediaContentRatingNewZealand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingNewZealand} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingNewZealand(MediaContentRatingNewZealand mediaContentRatingNewZealand) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingNewZealand");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingNewZealand = mediaContentRatingNewZealand;
        return _x;
    }

    /**
     * <i>“Media content rating settings for United Kingdom”</i>
     * 
     * @return property mediaContentRatingUnitedKingdom
     */
    @Property(name="mediaContentRatingUnitedKingdom")
    @JsonIgnore
    public Optional<MediaContentRatingUnitedKingdom> getMediaContentRatingUnitedKingdom() {
        return Optional.ofNullable(mediaContentRatingUnitedKingdom);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingUnitedKingdom} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for United Kingdom”</i>
     * 
     * @param mediaContentRatingUnitedKingdom
     *            new value of {@code mediaContentRatingUnitedKingdom} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingUnitedKingdom} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingUnitedKingdom(MediaContentRatingUnitedKingdom mediaContentRatingUnitedKingdom) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingUnitedKingdom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingUnitedKingdom = mediaContentRatingUnitedKingdom;
        return _x;
    }

    /**
     * <i>“Media content rating settings for United States”</i>
     * 
     * @return property mediaContentRatingUnitedStates
     */
    @Property(name="mediaContentRatingUnitedStates")
    @JsonIgnore
    public Optional<MediaContentRatingUnitedStates> getMediaContentRatingUnitedStates() {
        return Optional.ofNullable(mediaContentRatingUnitedStates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingUnitedStates} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for United States”</i>
     * 
     * @param mediaContentRatingUnitedStates
     *            new value of {@code mediaContentRatingUnitedStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingUnitedStates} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingUnitedStates(MediaContentRatingUnitedStates mediaContentRatingUnitedStates) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingUnitedStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingUnitedStates = mediaContentRatingUnitedStates;
        return _x;
    }

    /**
     * <i>“List of managed apps and the network rules that applies to them. This collection
     * can contain a maximum of 1000 elements.”</i>
     * 
     * @return property networkUsageRules
     */
    @Property(name="networkUsageRules")
    @JsonIgnore
    public CollectionPage<IosNetworkUsageRule> getNetworkUsageRules() {
        return new CollectionPage<IosNetworkUsageRule>(contextPath, IosNetworkUsageRule.class, networkUsageRules, Optional.ofNullable(networkUsageRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of managed apps and the network rules that applies to them. This collection
     * can contain a maximum of 1000 elements.”</i>
     * 
     * @return property networkUsageRules
     */
    @Property(name="networkUsageRules")
    @JsonIgnore
    public CollectionPage<IosNetworkUsageRule> getNetworkUsageRules(HttpRequestOptions options) {
        return new CollectionPage<IosNetworkUsageRule>(contextPath, IosNetworkUsageRule.class, networkUsageRules, Optional.ofNullable(networkUsageRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Media content rating settings for Apps”</i>
     * 
     * @return property mediaContentRatingApps
     */
    @Property(name="mediaContentRatingApps")
    @JsonIgnore
    public Optional<RatingAppsType> getMediaContentRatingApps() {
        return Optional.ofNullable(mediaContentRatingApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mediaContentRatingApps} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Media content rating settings for Apps”</i>
     * 
     * @param mediaContentRatingApps
     *            new value of {@code mediaContentRatingApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaContentRatingApps} field changed
     */
    public IosGeneralDeviceConfiguration withMediaContentRatingApps(RatingAppsType mediaContentRatingApps) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mediaContentRatingApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.mediaContentRatingApps = mediaContentRatingApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using the Messages app on the
     * supervised device.”</i>
     * 
     * @return property messagesBlocked
     */
    @Property(name="messagesBlocked")
    @JsonIgnore
    public Optional<Boolean> getMessagesBlocked() {
        return Optional.ofNullable(messagesBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messagesBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using the Messages app on the
     * supervised device.”</i>
     * 
     * @param messagesBlocked
     *            new value of {@code messagesBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messagesBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withMessagesBlocked(Boolean messagesBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("messagesBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.messagesBlocked = messagesBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow notifications settings modification (iOS 9.3
     * and later).”</i>
     * 
     * @return property notificationsBlockSettingsModification
     */
    @Property(name="notificationsBlockSettingsModification")
    @JsonIgnore
    public Optional<Boolean> getNotificationsBlockSettingsModification() {
        return Optional.ofNullable(notificationsBlockSettingsModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notificationsBlockSettingsModification} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow notifications settings modification (iOS 9.3
     * and later).”</i>
     * 
     * @param notificationsBlockSettingsModification
     *            new value of {@code notificationsBlockSettingsModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notificationsBlockSettingsModification} field changed
     */
    public IosGeneralDeviceConfiguration withNotificationsBlockSettingsModification(Boolean notificationsBlockSettingsModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("notificationsBlockSettingsModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.notificationsBlockSettingsModification = notificationsBlockSettingsModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block fingerprint unlock.”</i>
     * 
     * @return property passcodeBlockFingerprintUnlock
     */
    @Property(name="passcodeBlockFingerprintUnlock")
    @JsonIgnore
    public Optional<Boolean> getPasscodeBlockFingerprintUnlock() {
        return Optional.ofNullable(passcodeBlockFingerprintUnlock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeBlockFingerprintUnlock} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block fingerprint unlock.”</i>
     * 
     * @param passcodeBlockFingerprintUnlock
     *            new value of {@code passcodeBlockFingerprintUnlock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeBlockFingerprintUnlock} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeBlockFingerprintUnlock(Boolean passcodeBlockFingerprintUnlock) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeBlockFingerprintUnlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeBlockFingerprintUnlock = passcodeBlockFingerprintUnlock;
        return _x;
    }

    /**
     * <i>“Block modification of registered Touch ID fingerprints when in supervised mode.”</i>
     * 
     * @return property passcodeBlockFingerprintModification
     */
    @Property(name="passcodeBlockFingerprintModification")
    @JsonIgnore
    public Optional<Boolean> getPasscodeBlockFingerprintModification() {
        return Optional.ofNullable(passcodeBlockFingerprintModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeBlockFingerprintModification} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Block modification of registered Touch ID fingerprints when in supervised mode.”</i>
     * 
     * @param passcodeBlockFingerprintModification
     *            new value of {@code passcodeBlockFingerprintModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeBlockFingerprintModification} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeBlockFingerprintModification(Boolean passcodeBlockFingerprintModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeBlockFingerprintModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeBlockFingerprintModification = passcodeBlockFingerprintModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow passcode modification on the supervised device
     * (iOS 9.0 and later).”</i>
     * 
     * @return property passcodeBlockModification
     */
    @Property(name="passcodeBlockModification")
    @JsonIgnore
    public Optional<Boolean> getPasscodeBlockModification() {
        return Optional.ofNullable(passcodeBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow passcode modification on the supervised device
     * (iOS 9.0 and later).”</i>
     * 
     * @param passcodeBlockModification
     *            new value of {@code passcodeBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeBlockModification} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeBlockModification(Boolean passcodeBlockModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeBlockModification = passcodeBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block simple passcodes.”</i>
     * 
     * @return property passcodeBlockSimple
     */
    @Property(name="passcodeBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasscodeBlockSimple() {
        return Optional.ofNullable(passcodeBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block simple passcodes.”</i>
     * 
     * @param passcodeBlockSimple
     *            new value of {@code passcodeBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeBlockSimple} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeBlockSimple(Boolean passcodeBlockSimple) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeBlockSimple = passcodeBlockSimple;
        return _x;
    }

    /**
     * <i>“Number of days before the passcode expires. Valid values 1 to 65535”</i>
     * 
     * @return property passcodeExpirationDays
     */
    @Property(name="passcodeExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasscodeExpirationDays() {
        return Optional.ofNullable(passcodeExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before the passcode expires. Valid values 1 to 65535”</i>
     * 
     * @param passcodeExpirationDays
     *            new value of {@code passcodeExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeExpirationDays} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeExpirationDays(Integer passcodeExpirationDays) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeExpirationDays = passcodeExpirationDays;
        return _x;
    }

    /**
     * <i>“Minimum length of passcode. Valid values 4 to 14”</i>
     * 
     * @return property passcodeMinimumLength
     */
    @Property(name="passcodeMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinimumLength() {
        return Optional.ofNullable(passcodeMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum length of passcode. Valid values 4 to 14”</i>
     * 
     * @param passcodeMinimumLength
     *            new value of {@code passcodeMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinimumLength} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeMinimumLength(Integer passcodeMinimumLength) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeMinimumLength = passcodeMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a passcode is required.”</i>
     * 
     * @return property passcodeMinutesOfInactivityBeforeLock
     */
    @Property(name="passcodeMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passcodeMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a passcode is required.”</i>
     * 
     * @param passcodeMinutesOfInactivityBeforeLock
     *            new value of {@code passcodeMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinutesOfInactivityBeforeLock} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeMinutesOfInactivityBeforeLock(Integer passcodeMinutesOfInactivityBeforeLock) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @return property passcodeMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passcodeMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passcodeMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @param passcodeMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passcodeMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeMinutesOfInactivityBeforeScreenTimeout(Integer passcodeMinutesOfInactivityBeforeScreenTimeout) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Number of character sets a passcode must contain. Valid values 0 to 4”</i>
     * 
     * @return property passcodeMinimumCharacterSetCount
     */
    @Property(name="passcodeMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinimumCharacterSetCount() {
        return Optional.ofNullable(passcodeMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of character sets a passcode must contain. Valid values 0 to 4”</i>
     * 
     * @param passcodeMinimumCharacterSetCount
     *            new value of {@code passcodeMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinimumCharacterSetCount} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeMinimumCharacterSetCount(Integer passcodeMinimumCharacterSetCount) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“Number of previous passcodes to block. Valid values 1 to 24”</i>
     * 
     * @return property passcodePreviousPasscodeBlockCount
     */
    @Property(name="passcodePreviousPasscodeBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasscodePreviousPasscodeBlockCount() {
        return Optional.ofNullable(passcodePreviousPasscodeBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodePreviousPasscodeBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of previous passcodes to block. Valid values 1 to 24”</i>
     * 
     * @param passcodePreviousPasscodeBlockCount
     *            new value of {@code passcodePreviousPasscodeBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodePreviousPasscodeBlockCount} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodePreviousPasscodeBlockCount(Integer passcodePreviousPasscodeBlockCount) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodePreviousPasscodeBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
        return _x;
    }

    /**
     * <i>“Number of sign in failures allowed before wiping the device. Valid values 4 to
     * 11”</i>
     * 
     * @return property passcodeSignInFailureCountBeforeWipe
     */
    @Property(name="passcodeSignInFailureCountBeforeWipe")
    @JsonIgnore
    public Optional<Integer> getPasscodeSignInFailureCountBeforeWipe() {
        return Optional.ofNullable(passcodeSignInFailureCountBeforeWipe);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeSignInFailureCountBeforeWipe} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of sign in failures allowed before wiping the device. Valid values 4 to
     * 11”</i>
     * 
     * @param passcodeSignInFailureCountBeforeWipe
     *            new value of {@code passcodeSignInFailureCountBeforeWipe} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeSignInFailureCountBeforeWipe} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeSignInFailureCountBeforeWipe(Integer passcodeSignInFailureCountBeforeWipe) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeSignInFailureCountBeforeWipe");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
        return _x;
    }

    /**
     * <i>“Type of passcode that is required.”</i>
     * 
     * @return property passcodeRequiredType
     */
    @Property(name="passcodeRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasscodeRequiredType() {
        return Optional.ofNullable(passcodeRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of passcode that is required.”</i>
     * 
     * @param passcodeRequiredType
     *            new value of {@code passcodeRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeRequiredType} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeRequiredType(RequiredPasswordType passcodeRequiredType) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeRequiredType = passcodeRequiredType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a passcode.”</i>
     * 
     * @return property passcodeRequired
     */
    @Property(name="passcodeRequired")
    @JsonIgnore
    public Optional<Boolean> getPasscodeRequired() {
        return Optional.ofNullable(passcodeRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passcodeRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to require a passcode.”</i>
     * 
     * @param passcodeRequired
     *            new value of {@code passcodeRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeRequired} field changed
     */
    public IosGeneralDeviceConfiguration withPasscodeRequired(Boolean passcodeRequired) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passcodeRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passcodeRequired = passcodeRequired;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using podcasts on the supervised
     * device (iOS 8.0 and later).”</i>
     * 
     * @return property podcastsBlocked
     */
    @Property(name="podcastsBlocked")
    @JsonIgnore
    public Optional<Boolean> getPodcastsBlocked() {
        return Optional.ofNullable(podcastsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code podcastsBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using podcasts on the supervised
     * device (iOS 8.0 and later).”</i>
     * 
     * @param podcastsBlocked
     *            new value of {@code podcastsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code podcastsBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withPodcastsBlocked(Boolean podcastsBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("podcastsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.podcastsBlocked = podcastsBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enable the prompt to setup nearby devices with a
     * supervised device.”</i>
     * 
     * @return property proximityBlockSetupToNewDevice
     */
    @Property(name="proximityBlockSetupToNewDevice")
    @JsonIgnore
    public Optional<Boolean> getProximityBlockSetupToNewDevice() {
        return Optional.ofNullable(proximityBlockSetupToNewDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * proximityBlockSetupToNewDevice} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enable the prompt to setup nearby devices with a
     * supervised device.”</i>
     * 
     * @param proximityBlockSetupToNewDevice
     *            new value of {@code proximityBlockSetupToNewDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proximityBlockSetupToNewDevice} field changed
     */
    public IosGeneralDeviceConfiguration withProximityBlockSetupToNewDevice(Boolean proximityBlockSetupToNewDevice) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proximityBlockSetupToNewDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.proximityBlockSetupToNewDevice = proximityBlockSetupToNewDevice;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using Auto fill in Safari.
     * Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @return property safariBlockAutofill
     */
    @Property(name="safariBlockAutofill")
    @JsonIgnore
    public Optional<Boolean> getSafariBlockAutofill() {
        return Optional.ofNullable(safariBlockAutofill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * safariBlockAutofill} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using Auto fill in Safari.
     * Requires a supervised device for iOS 13 and later.”</i>
     * 
     * @param safariBlockAutofill
     *            new value of {@code safariBlockAutofill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariBlockAutofill} field changed
     */
    public IosGeneralDeviceConfiguration withSafariBlockAutofill(Boolean safariBlockAutofill) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariBlockAutofill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.safariBlockAutofill = safariBlockAutofill;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block JavaScript in Safari.”</i>
     * 
     * @return property safariBlockJavaScript
     */
    @Property(name="safariBlockJavaScript")
    @JsonIgnore
    public Optional<Boolean> getSafariBlockJavaScript() {
        return Optional.ofNullable(safariBlockJavaScript);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * safariBlockJavaScript} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block JavaScript in Safari.”</i>
     * 
     * @param safariBlockJavaScript
     *            new value of {@code safariBlockJavaScript} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariBlockJavaScript} field changed
     */
    public IosGeneralDeviceConfiguration withSafariBlockJavaScript(Boolean safariBlockJavaScript) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariBlockJavaScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.safariBlockJavaScript = safariBlockJavaScript;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block popups in Safari.”</i>
     * 
     * @return property safariBlockPopups
     */
    @Property(name="safariBlockPopups")
    @JsonIgnore
    public Optional<Boolean> getSafariBlockPopups() {
        return Optional.ofNullable(safariBlockPopups);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code safariBlockPopups
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block popups in Safari.”</i>
     * 
     * @param safariBlockPopups
     *            new value of {@code safariBlockPopups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariBlockPopups} field changed
     */
    public IosGeneralDeviceConfiguration withSafariBlockPopups(Boolean safariBlockPopups) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariBlockPopups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.safariBlockPopups = safariBlockPopups;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using Safari. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @return property safariBlocked
     */
    @Property(name="safariBlocked")
    @JsonIgnore
    public Optional<Boolean> getSafariBlocked() {
        return Optional.ofNullable(safariBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code safariBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using Safari. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @param safariBlocked
     *            new value of {@code safariBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withSafariBlocked(Boolean safariBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.safariBlocked = safariBlocked;
        return _x;
    }

    /**
     * <i>“Cookie settings for Safari.”</i>
     * 
     * @return property safariCookieSettings
     */
    @Property(name="safariCookieSettings")
    @JsonIgnore
    public Optional<WebBrowserCookieSettings> getSafariCookieSettings() {
        return Optional.ofNullable(safariCookieSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * safariCookieSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Cookie settings for Safari.”</i>
     * 
     * @param safariCookieSettings
     *            new value of {@code safariCookieSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariCookieSettings} field changed
     */
    public IosGeneralDeviceConfiguration withSafariCookieSettings(WebBrowserCookieSettings safariCookieSettings) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariCookieSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.safariCookieSettings = safariCookieSettings;
        return _x;
    }

    /**
     * <i>“URLs matching the patterns listed here will be considered managed.”</i>
     * 
     * @return property safariManagedDomains
     */
    @Property(name="safariManagedDomains")
    @JsonIgnore
    public CollectionPage<String> getSafariManagedDomains() {
        return new CollectionPage<String>(contextPath, String.class, safariManagedDomains, Optional.ofNullable(safariManagedDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“URLs matching the patterns listed here will be considered managed.”</i>
     * 
     * @return property safariManagedDomains
     */
    @Property(name="safariManagedDomains")
    @JsonIgnore
    public CollectionPage<String> getSafariManagedDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, safariManagedDomains, Optional.ofNullable(safariManagedDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Users can save passwords in Safari only from URLs matching the patterns listed
     * here. Applies to devices in supervised mode (iOS 9.3 and later).”</i>
     * 
     * @return property safariPasswordAutoFillDomains
     */
    @Property(name="safariPasswordAutoFillDomains")
    @JsonIgnore
    public CollectionPage<String> getSafariPasswordAutoFillDomains() {
        return new CollectionPage<String>(contextPath, String.class, safariPasswordAutoFillDomains, Optional.ofNullable(safariPasswordAutoFillDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Users can save passwords in Safari only from URLs matching the patterns listed
     * here. Applies to devices in supervised mode (iOS 9.3 and later).”</i>
     * 
     * @return property safariPasswordAutoFillDomains
     */
    @Property(name="safariPasswordAutoFillDomains")
    @JsonIgnore
    public CollectionPage<String> getSafariPasswordAutoFillDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, safariPasswordAutoFillDomains, Optional.ofNullable(safariPasswordAutoFillDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to require fraud warning in Safari.”</i>
     * 
     * @return property safariRequireFraudWarning
     */
    @Property(name="safariRequireFraudWarning")
    @JsonIgnore
    public Optional<Boolean> getSafariRequireFraudWarning() {
        return Optional.ofNullable(safariRequireFraudWarning);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * safariRequireFraudWarning} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require fraud warning in Safari.”</i>
     * 
     * @param safariRequireFraudWarning
     *            new value of {@code safariRequireFraudWarning} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safariRequireFraudWarning} field changed
     */
    public IosGeneralDeviceConfiguration withSafariRequireFraudWarning(Boolean safariRequireFraudWarning) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safariRequireFraudWarning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.safariRequireFraudWarning = safariRequireFraudWarning;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from taking Screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from taking Screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using Siri.”</i>
     * 
     * @return property siriBlocked
     */
    @Property(name="siriBlocked")
    @JsonIgnore
    public Optional<Boolean> getSiriBlocked() {
        return Optional.ofNullable(siriBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code siriBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using Siri.”</i>
     * 
     * @param siriBlocked
     *            new value of {@code siriBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code siriBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withSiriBlocked(Boolean siriBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("siriBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.siriBlocked = siriBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using Siri when locked.”</i>
     * 
     * @return property siriBlockedWhenLocked
     */
    @Property(name="siriBlockedWhenLocked")
    @JsonIgnore
    public Optional<Boolean> getSiriBlockedWhenLocked() {
        return Optional.ofNullable(siriBlockedWhenLocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * siriBlockedWhenLocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using Siri when locked.”</i>
     * 
     * @param siriBlockedWhenLocked
     *            new value of {@code siriBlockedWhenLocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code siriBlockedWhenLocked} field changed
     */
    public IosGeneralDeviceConfiguration withSiriBlockedWhenLocked(Boolean siriBlockedWhenLocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("siriBlockedWhenLocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.siriBlockedWhenLocked = siriBlockedWhenLocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Siri from querying user-generated content when
     * used on a supervised device.”</i>
     * 
     * @return property siriBlockUserGeneratedContent
     */
    @Property(name="siriBlockUserGeneratedContent")
    @JsonIgnore
    public Optional<Boolean> getSiriBlockUserGeneratedContent() {
        return Optional.ofNullable(siriBlockUserGeneratedContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * siriBlockUserGeneratedContent} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Siri from querying user-generated content when
     * used on a supervised device.”</i>
     * 
     * @param siriBlockUserGeneratedContent
     *            new value of {@code siriBlockUserGeneratedContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code siriBlockUserGeneratedContent} field changed
     */
    public IosGeneralDeviceConfiguration withSiriBlockUserGeneratedContent(Boolean siriBlockUserGeneratedContent) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("siriBlockUserGeneratedContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.siriBlockUserGeneratedContent = siriBlockUserGeneratedContent;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to prevent Siri from dictating, or speaking profane
     * language on supervised device.”</i>
     * 
     * @return property siriRequireProfanityFilter
     */
    @Property(name="siriRequireProfanityFilter")
    @JsonIgnore
    public Optional<Boolean> getSiriRequireProfanityFilter() {
        return Optional.ofNullable(siriRequireProfanityFilter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * siriRequireProfanityFilter} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to prevent Siri from dictating, or speaking profane
     * language on supervised device.”</i>
     * 
     * @param siriRequireProfanityFilter
     *            new value of {@code siriRequireProfanityFilter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code siriRequireProfanityFilter} field changed
     */
    public IosGeneralDeviceConfiguration withSiriRequireProfanityFilter(Boolean siriRequireProfanityFilter) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("siriRequireProfanityFilter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.siriRequireProfanityFilter = siriRequireProfanityFilter;
        return _x;
    }

    /**
     * <i>“Sets how many days a software update will be delyed for a supervised device.
     * Valid values 0 to 90”</i>
     * 
     * @return property softwareUpdatesEnforcedDelayInDays
     */
    @Property(name="softwareUpdatesEnforcedDelayInDays")
    @JsonIgnore
    public Optional<Integer> getSoftwareUpdatesEnforcedDelayInDays() {
        return Optional.ofNullable(softwareUpdatesEnforcedDelayInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * softwareUpdatesEnforcedDelayInDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Sets how many days a software update will be delyed for a supervised device.
     * Valid values 0 to 90”</i>
     * 
     * @param softwareUpdatesEnforcedDelayInDays
     *            new value of {@code softwareUpdatesEnforcedDelayInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code softwareUpdatesEnforcedDelayInDays} field changed
     */
    public IosGeneralDeviceConfiguration withSoftwareUpdatesEnforcedDelayInDays(Integer softwareUpdatesEnforcedDelayInDays) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("softwareUpdatesEnforcedDelayInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to delay user visibility of software updates when the
     * device is in supervised mode.”</i>
     * 
     * @return property softwareUpdatesForceDelayed
     */
    @Property(name="softwareUpdatesForceDelayed")
    @JsonIgnore
    public Optional<Boolean> getSoftwareUpdatesForceDelayed() {
        return Optional.ofNullable(softwareUpdatesForceDelayed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * softwareUpdatesForceDelayed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to delay user visibility of software updates when the
     * device is in supervised mode.”</i>
     * 
     * @param softwareUpdatesForceDelayed
     *            new value of {@code softwareUpdatesForceDelayed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code softwareUpdatesForceDelayed} field changed
     */
    public IosGeneralDeviceConfiguration withSoftwareUpdatesForceDelayed(Boolean softwareUpdatesForceDelayed) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("softwareUpdatesForceDelayed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Spotlight search from returning internet
     * results on supervised device.”</i>
     * 
     * @return property spotlightBlockInternetResults
     */
    @Property(name="spotlightBlockInternetResults")
    @JsonIgnore
    public Optional<Boolean> getSpotlightBlockInternetResults() {
        return Optional.ofNullable(spotlightBlockInternetResults);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * spotlightBlockInternetResults} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Spotlight search from returning internet
     * results on supervised device.”</i>
     * 
     * @param spotlightBlockInternetResults
     *            new value of {@code spotlightBlockInternetResults} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code spotlightBlockInternetResults} field changed
     */
    public IosGeneralDeviceConfiguration withSpotlightBlockInternetResults(Boolean spotlightBlockInternetResults) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("spotlightBlockInternetResults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.spotlightBlockInternetResults = spotlightBlockInternetResults;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block voice dialing.”</i>
     * 
     * @return property voiceDialingBlocked
     */
    @Property(name="voiceDialingBlocked")
    @JsonIgnore
    public Optional<Boolean> getVoiceDialingBlocked() {
        return Optional.ofNullable(voiceDialingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * voiceDialingBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block voice dialing.”</i>
     * 
     * @param voiceDialingBlocked
     *            new value of {@code voiceDialingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code voiceDialingBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withVoiceDialingBlocked(Boolean voiceDialingBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("voiceDialingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.voiceDialingBlocked = voiceDialingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow wallpaper modification on supervised device (
     * iOS 9.0 and later) .”</i>
     * 
     * @return property wallpaperBlockModification
     */
    @Property(name="wallpaperBlockModification")
    @JsonIgnore
    public Optional<Boolean> getWallpaperBlockModification() {
        return Optional.ofNullable(wallpaperBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wallpaperBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow wallpaper modification on supervised device (
     * iOS 9.0 and later) .”</i>
     * 
     * @param wallpaperBlockModification
     *            new value of {@code wallpaperBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wallpaperBlockModification} field changed
     */
    public IosGeneralDeviceConfiguration withWallpaperBlockModification(Boolean wallpaperBlockModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wallpaperBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.wallpaperBlockModification = wallpaperBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to force the device to use only Wi-Fi networks from
     * configuration profiles when the device is in supervised mode.”</i>
     * 
     * @return property wiFiConnectOnlyToConfiguredNetworks
     */
    @Property(name="wiFiConnectOnlyToConfiguredNetworks")
    @JsonIgnore
    public Optional<Boolean> getWiFiConnectOnlyToConfiguredNetworks() {
        return Optional.ofNullable(wiFiConnectOnlyToConfiguredNetworks);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wiFiConnectOnlyToConfiguredNetworks} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to force the device to use only Wi-Fi networks from
     * configuration profiles when the device is in supervised mode.”</i>
     * 
     * @param wiFiConnectOnlyToConfiguredNetworks
     *            new value of {@code wiFiConnectOnlyToConfiguredNetworks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiConnectOnlyToConfiguredNetworks} field changed
     */
    public IosGeneralDeviceConfiguration withWiFiConnectOnlyToConfiguredNetworks(Boolean wiFiConnectOnlyToConfiguredNetworks) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiConnectOnlyToConfiguredNetworks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.wiFiConnectOnlyToConfiguredNetworks = wiFiConnectOnlyToConfiguredNetworks;
        return _x;
    }

    /**
     * <i>“Indicates whether a student enrolled in an unmanaged course via Classroom will
     * request permission from the teacher when attempting to leave the course (iOS 11.
     * 3 and later).”</i>
     * 
     * @return property classroomForceRequestPermissionToLeaveClasses
     */
    @Property(name="classroomForceRequestPermissionToLeaveClasses")
    @JsonIgnore
    public Optional<Boolean> getClassroomForceRequestPermissionToLeaveClasses() {
        return Optional.ofNullable(classroomForceRequestPermissionToLeaveClasses);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * classroomForceRequestPermissionToLeaveClasses} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether a student enrolled in an unmanaged course via Classroom will
     * request permission from the teacher when attempting to leave the course (iOS 11.
     * 3 and later).”</i>
     * 
     * @param classroomForceRequestPermissionToLeaveClasses
     *            new value of {@code classroomForceRequestPermissionToLeaveClasses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomForceRequestPermissionToLeaveClasses} field changed
     */
    public IosGeneralDeviceConfiguration withClassroomForceRequestPermissionToLeaveClasses(Boolean classroomForceRequestPermissionToLeaveClasses) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("classroomForceRequestPermissionToLeaveClasses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
        return _x;
    }

    /**
     * <i>“Indicates whether or not iCloud keychain synchronization is blocked. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @return property keychainBlockCloudSync
     */
    @Property(name="keychainBlockCloudSync")
    @JsonIgnore
    public Optional<Boolean> getKeychainBlockCloudSync() {
        return Optional.ofNullable(keychainBlockCloudSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keychainBlockCloudSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not iCloud keychain synchronization is blocked. Requires a
     * supervised device for iOS 13 and later.”</i>
     * 
     * @param keychainBlockCloudSync
     *            new value of {@code keychainBlockCloudSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keychainBlockCloudSync} field changed
     */
    public IosGeneralDeviceConfiguration withKeychainBlockCloudSync(Boolean keychainBlockCloudSync) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keychainBlockCloudSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.keychainBlockCloudSync = keychainBlockCloudSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not over-the-air PKI updates are blocked. Setting this
     * restriction to false does not disable CRL and OCSP checks (iOS 7.0 and later).”</i>
     * 
     * @return property pkiBlockOTAUpdates
     */
    @Property(name="pkiBlockOTAUpdates")
    @JsonIgnore
    public Optional<Boolean> getPkiBlockOTAUpdates() {
        return Optional.ofNullable(pkiBlockOTAUpdates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pkiBlockOTAUpdates} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not over-the-air PKI updates are blocked. Setting this
     * restriction to false does not disable CRL and OCSP checks (iOS 7.0 and later).”</i>
     * 
     * @param pkiBlockOTAUpdates
     *            new value of {@code pkiBlockOTAUpdates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pkiBlockOTAUpdates} field changed
     */
    public IosGeneralDeviceConfiguration withPkiBlockOTAUpdates(Boolean pkiBlockOTAUpdates) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("pkiBlockOTAUpdates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.pkiBlockOTAUpdates = pkiBlockOTAUpdates;
        return _x;
    }

    /**
     * <i>“Indicates if ad tracking is limited.(iOS 7.0 and later).”</i>
     * 
     * @return property privacyForceLimitAdTracking
     */
    @Property(name="privacyForceLimitAdTracking")
    @JsonIgnore
    public Optional<Boolean> getPrivacyForceLimitAdTracking() {
        return Optional.ofNullable(privacyForceLimitAdTracking);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyForceLimitAdTracking} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if ad tracking is limited.(iOS 7.0 and later).”</i>
     * 
     * @param privacyForceLimitAdTracking
     *            new value of {@code privacyForceLimitAdTracking} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyForceLimitAdTracking} field changed
     */
    public IosGeneralDeviceConfiguration withPrivacyForceLimitAdTracking(Boolean privacyForceLimitAdTracking) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyForceLimitAdTracking");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.privacyForceLimitAdTracking = privacyForceLimitAdTracking;
        return _x;
    }

    /**
     * <i>“Indicates whether or not Enterprise book back up is blocked.”</i>
     * 
     * @return property enterpriseBookBlockBackup
     */
    @Property(name="enterpriseBookBlockBackup")
    @JsonIgnore
    public Optional<Boolean> getEnterpriseBookBlockBackup() {
        return Optional.ofNullable(enterpriseBookBlockBackup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseBookBlockBackup} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not Enterprise book back up is blocked.”</i>
     * 
     * @param enterpriseBookBlockBackup
     *            new value of {@code enterpriseBookBlockBackup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseBookBlockBackup} field changed
     */
    public IosGeneralDeviceConfiguration withEnterpriseBookBlockBackup(Boolean enterpriseBookBlockBackup) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseBookBlockBackup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.enterpriseBookBlockBackup = enterpriseBookBlockBackup;
        return _x;
    }

    /**
     * <i>“Indicates whether or not Enterprise book notes and highlights sync is blocked.”</i>
     * 
     * @return property enterpriseBookBlockMetadataSync
     */
    @Property(name="enterpriseBookBlockMetadataSync")
    @JsonIgnore
    public Optional<Boolean> getEnterpriseBookBlockMetadataSync() {
        return Optional.ofNullable(enterpriseBookBlockMetadataSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseBookBlockMetadataSync} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not Enterprise book notes and highlights sync is blocked.”</i>
     * 
     * @param enterpriseBookBlockMetadataSync
     *            new value of {@code enterpriseBookBlockMetadataSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseBookBlockMetadataSync} field changed
     */
    public IosGeneralDeviceConfiguration withEnterpriseBookBlockMetadataSync(Boolean enterpriseBookBlockMetadataSync) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseBookBlockMetadataSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.enterpriseBookBlockMetadataSync = enterpriseBookBlockMetadataSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not AirPrint is blocked (iOS 11.0 and later).”</i>
     * 
     * @return property airPrintBlocked
     */
    @Property(name="airPrintBlocked")
    @JsonIgnore
    public Optional<Boolean> getAirPrintBlocked() {
        return Optional.ofNullable(airPrintBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code airPrintBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not AirPrint is blocked (iOS 11.0 and later).”</i>
     * 
     * @param airPrintBlocked
     *            new value of {@code airPrintBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withAirPrintBlocked(Boolean airPrintBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airPrintBlocked = airPrintBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not keychain storage of username and password for Airprint
     * is blocked (iOS 11.0 and later).”</i>
     * 
     * @return property airPrintBlockCredentialsStorage
     */
    @Property(name="airPrintBlockCredentialsStorage")
    @JsonIgnore
    public Optional<Boolean> getAirPrintBlockCredentialsStorage() {
        return Optional.ofNullable(airPrintBlockCredentialsStorage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintBlockCredentialsStorage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not keychain storage of username and password for Airprint
     * is blocked (iOS 11.0 and later).”</i>
     * 
     * @param airPrintBlockCredentialsStorage
     *            new value of {@code airPrintBlockCredentialsStorage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintBlockCredentialsStorage} field changed
     */
    public IosGeneralDeviceConfiguration withAirPrintBlockCredentialsStorage(Boolean airPrintBlockCredentialsStorage) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintBlockCredentialsStorage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airPrintBlockCredentialsStorage = airPrintBlockCredentialsStorage;
        return _x;
    }

    /**
     * <i>“Indicates if trusted certificates are required for TLS printing communication (
     * iOS 11.0 and later).”</i>
     * 
     * @return property airPrintForceTrustedTLS
     */
    @Property(name="airPrintForceTrustedTLS")
    @JsonIgnore
    public Optional<Boolean> getAirPrintForceTrustedTLS() {
        return Optional.ofNullable(airPrintForceTrustedTLS);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintForceTrustedTLS} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if trusted certificates are required for TLS printing communication (
     * iOS 11.0 and later).”</i>
     * 
     * @param airPrintForceTrustedTLS
     *            new value of {@code airPrintForceTrustedTLS} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintForceTrustedTLS} field changed
     */
    public IosGeneralDeviceConfiguration withAirPrintForceTrustedTLS(Boolean airPrintForceTrustedTLS) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintForceTrustedTLS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
        return _x;
    }

    /**
     * <i>“Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This
     * prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (
     * iOS 11.0 and later).”</i>
     * 
     * @return property airPrintBlockiBeaconDiscovery
     */
    @Property(name="airPrintBlockiBeaconDiscovery")
    @JsonIgnore
    public Optional<Boolean> getAirPrintBlockiBeaconDiscovery() {
        return Optional.ofNullable(airPrintBlockiBeaconDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintBlockiBeaconDiscovery} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not iBeacon discovery of AirPrint printers is blocked. This
     * prevents spurious AirPrint Bluetooth beacons from phishing for network traffic (
     * iOS 11.0 and later).”</i>
     * 
     * @param airPrintBlockiBeaconDiscovery
     *            new value of {@code airPrintBlockiBeaconDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintBlockiBeaconDiscovery} field changed
     */
    public IosGeneralDeviceConfiguration withAirPrintBlockiBeaconDiscovery(Boolean airPrintBlockiBeaconDiscovery) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("airPrintBlockiBeaconDiscovery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
        return _x;
    }

    /**
     * <i>“Indicates if devices can access files or other resources on a network server
     * using the Server Message Block (SMB) protocol. Available for devices running iOS
     * and iPadOS, versions 13.0 and later.”</i>
     * 
     * @return property filesNetworkDriveAccessBlocked
     */
    @Property(name="filesNetworkDriveAccessBlocked")
    @JsonIgnore
    public Optional<Boolean> getFilesNetworkDriveAccessBlocked() {
        return Optional.ofNullable(filesNetworkDriveAccessBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * filesNetworkDriveAccessBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates if devices can access files or other resources on a network server
     * using the Server Message Block (SMB) protocol. Available for devices running iOS
     * and iPadOS, versions 13.0 and later.”</i>
     * 
     * @param filesNetworkDriveAccessBlocked
     *            new value of {@code filesNetworkDriveAccessBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filesNetworkDriveAccessBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withFilesNetworkDriveAccessBlocked(Boolean filesNetworkDriveAccessBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("filesNetworkDriveAccessBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.filesNetworkDriveAccessBlocked = filesNetworkDriveAccessBlocked;
        return _x;
    }

    /**
     * <i>“Indicates if sevices with access can connect to and open files on a USB drive.
     * Available for devices running iOS and iPadOS, versions 13.0 and later.”</i>
     * 
     * @return property filesUsbDriveAccessBlocked
     */
    @Property(name="filesUsbDriveAccessBlocked")
    @JsonIgnore
    public Optional<Boolean> getFilesUsbDriveAccessBlocked() {
        return Optional.ofNullable(filesUsbDriveAccessBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * filesUsbDriveAccessBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if sevices with access can connect to and open files on a USB drive.
     * Available for devices running iOS and iPadOS, versions 13.0 and later.”</i>
     * 
     * @param filesUsbDriveAccessBlocked
     *            new value of {@code filesUsbDriveAccessBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filesUsbDriveAccessBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withFilesUsbDriveAccessBlocked(Boolean filesUsbDriveAccessBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("filesUsbDriveAccessBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.filesUsbDriveAccessBlocked = filesUsbDriveAccessBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not Wi-Fi remains on, even when device is in airplane mode.
     * Available for devices running iOS and iPadOS, versions 13.0 and later.”</i>
     * 
     * @return property wifiPowerOnForced
     */
    @Property(name="wifiPowerOnForced")
    @JsonIgnore
    public Optional<Boolean> getWifiPowerOnForced() {
        return Optional.ofNullable(wifiPowerOnForced);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wifiPowerOnForced
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not Wi-Fi remains on, even when device is in airplane mode.
     * Available for devices running iOS and iPadOS, versions 13.0 and later.”</i>
     * 
     * @param wifiPowerOnForced
     *            new value of {@code wifiPowerOnForced} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiPowerOnForced} field changed
     */
    public IosGeneralDeviceConfiguration withWifiPowerOnForced(Boolean wifiPowerOnForced) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiPowerOnForced");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.wifiPowerOnForced = wifiPowerOnForced;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the removal of system apps from the device is blocked
     * on a supervised device (iOS 11.0 and later).”</i>
     * 
     * @return property blockSystemAppRemoval
     */
    @Property(name="blockSystemAppRemoval")
    @JsonIgnore
    public Optional<Boolean> getBlockSystemAppRemoval() {
        return Optional.ofNullable(blockSystemAppRemoval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockSystemAppRemoval} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the removal of system apps from the device is blocked
     * on a supervised device (iOS 11.0 and later).”</i>
     * 
     * @param blockSystemAppRemoval
     *            new value of {@code blockSystemAppRemoval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockSystemAppRemoval} field changed
     */
    public IosGeneralDeviceConfiguration withBlockSystemAppRemoval(Boolean blockSystemAppRemoval) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("blockSystemAppRemoval");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.blockSystemAppRemoval = blockSystemAppRemoval;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the creation of VPN configurations is blocked (iOS 11.0
     * and later).”</i>
     * 
     * @return property vpnBlockCreation
     */
    @Property(name="vpnBlockCreation")
    @JsonIgnore
    public Optional<Boolean> getVpnBlockCreation() {
        return Optional.ofNullable(vpnBlockCreation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vpnBlockCreation}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not the creation of VPN configurations is blocked (iOS 11.0
     * and later).”</i>
     * 
     * @param vpnBlockCreation
     *            new value of {@code vpnBlockCreation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vpnBlockCreation} field changed
     */
    public IosGeneralDeviceConfiguration withVpnBlockCreation(Boolean vpnBlockCreation) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("vpnBlockCreation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.vpnBlockCreation = vpnBlockCreation;
        return _x;
    }

    /**
     * <i>“Indicates if the removal of apps is allowed.”</i>
     * 
     * @return property appRemovalBlocked
     */
    @Property(name="appRemovalBlocked")
    @JsonIgnore
    public Optional<Boolean> getAppRemovalBlocked() {
        return Optional.ofNullable(appRemovalBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appRemovalBlocked
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if the removal of apps is allowed.”</i>
     * 
     * @param appRemovalBlocked
     *            new value of {@code appRemovalBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appRemovalBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withAppRemovalBlocked(Boolean appRemovalBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appRemovalBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.appRemovalBlocked = appRemovalBlocked;
        return _x;
    }

    /**
     * <i>“Indicates if connecting to USB accessories while the device is locked is allowed
     * (iOS 11.4.1 and later).”</i>
     * 
     * @return property usbRestrictedModeBlocked
     */
    @Property(name="usbRestrictedModeBlocked")
    @JsonIgnore
    public Optional<Boolean> getUsbRestrictedModeBlocked() {
        return Optional.ofNullable(usbRestrictedModeBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * usbRestrictedModeBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if connecting to USB accessories while the device is locked is allowed
     * (iOS 11.4.1 and later).”</i>
     * 
     * @param usbRestrictedModeBlocked
     *            new value of {@code usbRestrictedModeBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usbRestrictedModeBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withUsbRestrictedModeBlocked(Boolean usbRestrictedModeBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usbRestrictedModeBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.usbRestrictedModeBlocked = usbRestrictedModeBlocked;
        return _x;
    }

    /**
     * <i>“Indicates if the AutoFill passwords feature is allowed (iOS 12.0 and later).”</i>
     * 
     * @return property passwordBlockAutoFill
     */
    @Property(name="passwordBlockAutoFill")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockAutoFill() {
        return Optional.ofNullable(passwordBlockAutoFill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockAutoFill} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if the AutoFill passwords feature is allowed (iOS 12.0 and later).”</i>
     * 
     * @param passwordBlockAutoFill
     *            new value of {@code passwordBlockAutoFill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockAutoFill} field changed
     */
    public IosGeneralDeviceConfiguration withPasswordBlockAutoFill(Boolean passwordBlockAutoFill) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockAutoFill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passwordBlockAutoFill = passwordBlockAutoFill;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block requesting passwords from nearby devices (iOS
     * 12.0 and later).”</i>
     * 
     * @return property passwordBlockProximityRequests
     */
    @Property(name="passwordBlockProximityRequests")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockProximityRequests() {
        return Optional.ofNullable(passwordBlockProximityRequests);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockProximityRequests} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block requesting passwords from nearby devices (iOS
     * 12.0 and later).”</i>
     * 
     * @param passwordBlockProximityRequests
     *            new value of {@code passwordBlockProximityRequests} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockProximityRequests} field changed
     */
    public IosGeneralDeviceConfiguration withPasswordBlockProximityRequests(Boolean passwordBlockProximityRequests) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockProximityRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passwordBlockProximityRequests = passwordBlockProximityRequests;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block sharing passwords with the AirDrop passwords
     * feature iOS 12.0 and later).”</i>
     * 
     * @return property passwordBlockAirDropSharing
     */
    @Property(name="passwordBlockAirDropSharing")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockAirDropSharing() {
        return Optional.ofNullable(passwordBlockAirDropSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockAirDropSharing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block sharing passwords with the AirDrop passwords
     * feature iOS 12.0 and later).”</i>
     * 
     * @param passwordBlockAirDropSharing
     *            new value of {@code passwordBlockAirDropSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockAirDropSharing} field changed
     */
    public IosGeneralDeviceConfiguration withPasswordBlockAirDropSharing(Boolean passwordBlockAirDropSharing) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockAirDropSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the Date and Time "Set Automatically" feature is
     * enabled and cannot be turned off by the user (iOS 12.0 and later).”</i>
     * 
     * @return property dateAndTimeForceSetAutomatically
     */
    @Property(name="dateAndTimeForceSetAutomatically")
    @JsonIgnore
    public Optional<Boolean> getDateAndTimeForceSetAutomatically() {
        return Optional.ofNullable(dateAndTimeForceSetAutomatically);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dateAndTimeForceSetAutomatically} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the Date and Time "Set Automatically" feature is
     * enabled and cannot be turned off by the user (iOS 12.0 and later).”</i>
     * 
     * @param dateAndTimeForceSetAutomatically
     *            new value of {@code dateAndTimeForceSetAutomatically} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dateAndTimeForceSetAutomatically} field changed
     */
    public IosGeneralDeviceConfiguration withDateAndTimeForceSetAutomatically(Boolean dateAndTimeForceSetAutomatically) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dateAndTimeForceSetAutomatically");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.dateAndTimeForceSetAutomatically = dateAndTimeForceSetAutomatically;
        return _x;
    }

    /**
     * <i>“Indicates whether or not managed apps can write contacts to unmanaged contacts
     * accounts (iOS 12.0 and later).”</i>
     * 
     * @return property contactsAllowManagedToUnmanagedWrite
     */
    @Property(name="contactsAllowManagedToUnmanagedWrite")
    @JsonIgnore
    public Optional<Boolean> getContactsAllowManagedToUnmanagedWrite() {
        return Optional.ofNullable(contactsAllowManagedToUnmanagedWrite);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contactsAllowManagedToUnmanagedWrite} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not managed apps can write contacts to unmanaged contacts
     * accounts (iOS 12.0 and later).”</i>
     * 
     * @param contactsAllowManagedToUnmanagedWrite
     *            new value of {@code contactsAllowManagedToUnmanagedWrite} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactsAllowManagedToUnmanagedWrite} field changed
     */
    public IosGeneralDeviceConfiguration withContactsAllowManagedToUnmanagedWrite(Boolean contactsAllowManagedToUnmanagedWrite) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contactsAllowManagedToUnmanagedWrite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.contactsAllowManagedToUnmanagedWrite = contactsAllowManagedToUnmanagedWrite;
        return _x;
    }

    /**
     * <i>“Indicates whether or not unmanaged apps can read from managed contacts accounts
     * (iOS 12.0 or later).”</i>
     * 
     * @return property contactsAllowUnmanagedToManagedRead
     */
    @Property(name="contactsAllowUnmanagedToManagedRead")
    @JsonIgnore
    public Optional<Boolean> getContactsAllowUnmanagedToManagedRead() {
        return Optional.ofNullable(contactsAllowUnmanagedToManagedRead);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contactsAllowUnmanagedToManagedRead} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not unmanaged apps can read from managed contacts accounts
     * (iOS 12.0 or later).”</i>
     * 
     * @param contactsAllowUnmanagedToManagedRead
     *            new value of {@code contactsAllowUnmanagedToManagedRead} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactsAllowUnmanagedToManagedRead} field changed
     */
    public IosGeneralDeviceConfiguration withContactsAllowUnmanagedToManagedRead(Boolean contactsAllowUnmanagedToManagedRead) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contactsAllowUnmanagedToManagedRead");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.contactsAllowUnmanagedToManagedRead = contactsAllowUnmanagedToManagedRead;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from modifying the personal hotspot
     * setting (iOS 12.2 or later).”</i>
     * 
     * @return property cellularBlockPersonalHotspotModification
     */
    @Property(name="cellularBlockPersonalHotspotModification")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockPersonalHotspotModification() {
        return Optional.ofNullable(cellularBlockPersonalHotspotModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockPersonalHotspotModification} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from modifying the personal hotspot
     * setting (iOS 12.2 or later).”</i>
     * 
     * @param cellularBlockPersonalHotspotModification
     *            new value of {@code cellularBlockPersonalHotspotModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockPersonalHotspotModification} field changed
     */
    public IosGeneralDeviceConfiguration withCellularBlockPersonalHotspotModification(Boolean cellularBlockPersonalHotspotModification) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockPersonalHotspotModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.cellularBlockPersonalHotspotModification = cellularBlockPersonalHotspotModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the continuous path keyboard when the device
     * is supervised (iOS 13 or later).”</i>
     * 
     * @return property continuousPathKeyboardBlocked
     */
    @Property(name="continuousPathKeyboardBlocked")
    @JsonIgnore
    public Optional<Boolean> getContinuousPathKeyboardBlocked() {
        return Optional.ofNullable(continuousPathKeyboardBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * continuousPathKeyboardBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the continuous path keyboard when the device
     * is supervised (iOS 13 or later).”</i>
     * 
     * @param continuousPathKeyboardBlocked
     *            new value of {@code continuousPathKeyboardBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code continuousPathKeyboardBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withContinuousPathKeyboardBlocked(Boolean continuousPathKeyboardBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("continuousPathKeyboardBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.continuousPathKeyboardBlocked = continuousPathKeyboardBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Find My Device when the device is supervised (
     * iOS 13 or later).”</i>
     * 
     * @return property findMyDeviceInFindMyAppBlocked
     */
    @Property(name="findMyDeviceInFindMyAppBlocked")
    @JsonIgnore
    public Optional<Boolean> getFindMyDeviceInFindMyAppBlocked() {
        return Optional.ofNullable(findMyDeviceInFindMyAppBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * findMyDeviceInFindMyAppBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Find My Device when the device is supervised (
     * iOS 13 or later).”</i>
     * 
     * @param findMyDeviceInFindMyAppBlocked
     *            new value of {@code findMyDeviceInFindMyAppBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code findMyDeviceInFindMyAppBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withFindMyDeviceInFindMyAppBlocked(Boolean findMyDeviceInFindMyAppBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("findMyDeviceInFindMyAppBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.findMyDeviceInFindMyAppBlocked = findMyDeviceInFindMyAppBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Find My Friends when the device is supervised
     * (iOS 13 or later).”</i>
     * 
     * @return property findMyFriendsInFindMyAppBlocked
     */
    @Property(name="findMyFriendsInFindMyAppBlocked")
    @JsonIgnore
    public Optional<Boolean> getFindMyFriendsInFindMyAppBlocked() {
        return Optional.ofNullable(findMyFriendsInFindMyAppBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * findMyFriendsInFindMyAppBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Find My Friends when the device is supervised
     * (iOS 13 or later).”</i>
     * 
     * @param findMyFriendsInFindMyAppBlocked
     *            new value of {@code findMyFriendsInFindMyAppBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code findMyFriendsInFindMyAppBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withFindMyFriendsInFindMyAppBlocked(Boolean findMyFriendsInFindMyAppBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("findMyFriendsInFindMyAppBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.findMyFriendsInFindMyAppBlocked = findMyFriendsInFindMyAppBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the iTunes app. Requires a supervised device
     * for iOS 13 and later.”</i>
     * 
     * @return property iTunesBlocked
     */
    @Property(name="iTunesBlocked")
    @JsonIgnore
    public Optional<Boolean> getITunesBlocked() {
        return Optional.ofNullable(iTunesBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iTunesBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the iTunes app. Requires a supervised device
     * for iOS 13 and later.”</i>
     * 
     * @param iTunesBlocked
     *            new value of {@code iTunesBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iTunesBlocked} field changed
     */
    public IosGeneralDeviceConfiguration withITunesBlocked(Boolean iTunesBlocked) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iTunesBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.iTunesBlocked = iTunesBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block temporary sessions on Shared iPads (iOS 13.4
     * or later).”</i>
     * 
     * @return property sharedDeviceBlockTemporarySessions
     */
    @Property(name="sharedDeviceBlockTemporarySessions")
    @JsonIgnore
    public Optional<Boolean> getSharedDeviceBlockTemporarySessions() {
        return Optional.ofNullable(sharedDeviceBlockTemporarySessions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sharedDeviceBlockTemporarySessions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block temporary sessions on Shared iPads (iOS 13.4
     * or later).”</i>
     * 
     * @param sharedDeviceBlockTemporarySessions
     *            new value of {@code sharedDeviceBlockTemporarySessions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharedDeviceBlockTemporarySessions} field changed
     */
    public IosGeneralDeviceConfiguration withSharedDeviceBlockTemporarySessions(Boolean sharedDeviceBlockTemporarySessions) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("sharedDeviceBlockTemporarySessions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.sharedDeviceBlockTemporarySessions = sharedDeviceBlockTemporarySessions;
        return _x;
    }

    /**
     * <i>“Type of app to run in kiosk mode.”</i>
     * 
     * @return property kioskModeAppType
     */
    @Property(name="kioskModeAppType")
    @JsonIgnore
    public Optional<IosKioskModeAppType> getKioskModeAppType() {
        return Optional.ofNullable(kioskModeAppType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code kioskModeAppType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Type of app to run in kiosk mode.”</i>
     * 
     * @param kioskModeAppType
     *            new value of {@code kioskModeAppType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeAppType} field changed
     */
    public IosGeneralDeviceConfiguration withKioskModeAppType(IosKioskModeAppType kioskModeAppType) {
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeAppType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosGeneralDeviceConfiguration");
        _x.kioskModeAppType = kioskModeAppType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosGeneralDeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosGeneralDeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosGeneralDeviceConfiguration _copy() {
        IosGeneralDeviceConfiguration _x = new IosGeneralDeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.accountBlockModification = accountBlockModification;
        _x.activationLockAllowWhenSupervised = activationLockAllowWhenSupervised;
        _x.airDropBlocked = airDropBlocked;
        _x.airDropForceUnmanagedDropTarget = airDropForceUnmanagedDropTarget;
        _x.airPlayForcePairingPasswordForOutgoingRequests = airPlayForcePairingPasswordForOutgoingRequests;
        _x.appleWatchBlockPairing = appleWatchBlockPairing;
        _x.appleWatchForceWristDetection = appleWatchForceWristDetection;
        _x.appleNewsBlocked = appleNewsBlocked;
        _x.appsSingleAppModeList = appsSingleAppModeList;
        _x.appsVisibilityList = appsVisibilityList;
        _x.appsVisibilityListType = appsVisibilityListType;
        _x.appStoreBlockAutomaticDownloads = appStoreBlockAutomaticDownloads;
        _x.appStoreBlocked = appStoreBlocked;
        _x.appStoreBlockInAppPurchases = appStoreBlockInAppPurchases;
        _x.appStoreBlockUIAppInstallation = appStoreBlockUIAppInstallation;
        _x.appStoreRequirePassword = appStoreRequirePassword;
        _x.autoFillForceAuthentication = autoFillForceAuthentication;
        _x.bluetoothBlockModification = bluetoothBlockModification;
        _x.cameraBlocked = cameraBlocked;
        _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
        _x.cellularBlockGlobalBackgroundFetchWhileRoaming = cellularBlockGlobalBackgroundFetchWhileRoaming;
        _x.cellularBlockPerAppDataModification = cellularBlockPerAppDataModification;
        _x.cellularBlockPersonalHotspot = cellularBlockPersonalHotspot;
        _x.cellularBlockPlanModification = cellularBlockPlanModification;
        _x.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
        _x.certificatesBlockUntrustedTlsCertificates = certificatesBlockUntrustedTlsCertificates;
        _x.classroomAppBlockRemoteScreenObservation = classroomAppBlockRemoteScreenObservation;
        _x.classroomAppForceUnpromptedScreenObservation = classroomAppForceUnpromptedScreenObservation;
        _x.classroomForceAutomaticallyJoinClasses = classroomForceAutomaticallyJoinClasses;
        _x.classroomForceUnpromptedAppAndDeviceLock = classroomForceUnpromptedAppAndDeviceLock;
        _x.compliantAppsList = compliantAppsList;
        _x.compliantAppListType = compliantAppListType;
        _x.configurationProfileBlockChanges = configurationProfileBlockChanges;
        _x.definitionLookupBlocked = definitionLookupBlocked;
        _x.deviceBlockEnableRestrictions = deviceBlockEnableRestrictions;
        _x.deviceBlockEraseContentAndSettings = deviceBlockEraseContentAndSettings;
        _x.deviceBlockNameModification = deviceBlockNameModification;
        _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
        _x.diagnosticDataBlockSubmissionModification = diagnosticDataBlockSubmissionModification;
        _x.documentsBlockManagedDocumentsInUnmanagedApps = documentsBlockManagedDocumentsInUnmanagedApps;
        _x.documentsBlockUnmanagedDocumentsInManagedApps = documentsBlockUnmanagedDocumentsInManagedApps;
        _x.emailInDomainSuffixes = emailInDomainSuffixes;
        _x.enterpriseAppBlockTrust = enterpriseAppBlockTrust;
        _x.enterpriseAppBlockTrustModification = enterpriseAppBlockTrustModification;
        _x.esimBlockModification = esimBlockModification;
        _x.faceTimeBlocked = faceTimeBlocked;
        _x.findMyFriendsBlocked = findMyFriendsBlocked;
        _x.gamingBlockGameCenterFriends = gamingBlockGameCenterFriends;
        _x.gamingBlockMultiplayer = gamingBlockMultiplayer;
        _x.gameCenterBlocked = gameCenterBlocked;
        _x.hostPairingBlocked = hostPairingBlocked;
        _x.iBooksStoreBlocked = iBooksStoreBlocked;
        _x.iBooksStoreBlockErotica = iBooksStoreBlockErotica;
        _x.iCloudBlockActivityContinuation = iCloudBlockActivityContinuation;
        _x.iCloudBlockBackup = iCloudBlockBackup;
        _x.iCloudBlockDocumentSync = iCloudBlockDocumentSync;
        _x.iCloudBlockManagedAppsSync = iCloudBlockManagedAppsSync;
        _x.iCloudBlockPhotoLibrary = iCloudBlockPhotoLibrary;
        _x.iCloudBlockPhotoStreamSync = iCloudBlockPhotoStreamSync;
        _x.iCloudBlockSharedPhotoStream = iCloudBlockSharedPhotoStream;
        _x.iCloudRequireEncryptedBackup = iCloudRequireEncryptedBackup;
        _x.iTunesBlockExplicitContent = iTunesBlockExplicitContent;
        _x.iTunesBlockMusicService = iTunesBlockMusicService;
        _x.iTunesBlockRadio = iTunesBlockRadio;
        _x.keyboardBlockAutoCorrect = keyboardBlockAutoCorrect;
        _x.keyboardBlockDictation = keyboardBlockDictation;
        _x.keyboardBlockPredictive = keyboardBlockPredictive;
        _x.keyboardBlockShortcuts = keyboardBlockShortcuts;
        _x.keyboardBlockSpellCheck = keyboardBlockSpellCheck;
        _x.kioskModeAllowAssistiveSpeak = kioskModeAllowAssistiveSpeak;
        _x.kioskModeAllowAssistiveTouchSettings = kioskModeAllowAssistiveTouchSettings;
        _x.kioskModeAllowAutoLock = kioskModeAllowAutoLock;
        _x.kioskModeBlockAutoLock = kioskModeBlockAutoLock;
        _x.kioskModeAllowColorInversionSettings = kioskModeAllowColorInversionSettings;
        _x.kioskModeAllowRingerSwitch = kioskModeAllowRingerSwitch;
        _x.kioskModeBlockRingerSwitch = kioskModeBlockRingerSwitch;
        _x.kioskModeAllowScreenRotation = kioskModeAllowScreenRotation;
        _x.kioskModeBlockScreenRotation = kioskModeBlockScreenRotation;
        _x.kioskModeAllowSleepButton = kioskModeAllowSleepButton;
        _x.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
        _x.kioskModeAllowTouchscreen = kioskModeAllowTouchscreen;
        _x.kioskModeBlockTouchscreen = kioskModeBlockTouchscreen;
        _x.kioskModeEnableVoiceControl = kioskModeEnableVoiceControl;
        _x.kioskModeAllowVoiceControlModification = kioskModeAllowVoiceControlModification;
        _x.kioskModeAllowVoiceOverSettings = kioskModeAllowVoiceOverSettings;
        _x.kioskModeAllowVolumeButtons = kioskModeAllowVolumeButtons;
        _x.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
        _x.kioskModeAllowZoomSettings = kioskModeAllowZoomSettings;
        _x.kioskModeAppStoreUrl = kioskModeAppStoreUrl;
        _x.kioskModeBuiltInAppId = kioskModeBuiltInAppId;
        _x.kioskModeRequireAssistiveTouch = kioskModeRequireAssistiveTouch;
        _x.kioskModeRequireColorInversion = kioskModeRequireColorInversion;
        _x.kioskModeRequireMonoAudio = kioskModeRequireMonoAudio;
        _x.kioskModeRequireVoiceOver = kioskModeRequireVoiceOver;
        _x.kioskModeRequireZoom = kioskModeRequireZoom;
        _x.kioskModeManagedAppId = kioskModeManagedAppId;
        _x.lockScreenBlockControlCenter = lockScreenBlockControlCenter;
        _x.lockScreenBlockNotificationView = lockScreenBlockNotificationView;
        _x.lockScreenBlockPassbook = lockScreenBlockPassbook;
        _x.lockScreenBlockTodayView = lockScreenBlockTodayView;
        _x.mediaContentRatingAustralia = mediaContentRatingAustralia;
        _x.mediaContentRatingCanada = mediaContentRatingCanada;
        _x.mediaContentRatingFrance = mediaContentRatingFrance;
        _x.mediaContentRatingGermany = mediaContentRatingGermany;
        _x.mediaContentRatingIreland = mediaContentRatingIreland;
        _x.mediaContentRatingJapan = mediaContentRatingJapan;
        _x.mediaContentRatingNewZealand = mediaContentRatingNewZealand;
        _x.mediaContentRatingUnitedKingdom = mediaContentRatingUnitedKingdom;
        _x.mediaContentRatingUnitedStates = mediaContentRatingUnitedStates;
        _x.networkUsageRules = networkUsageRules;
        _x.mediaContentRatingApps = mediaContentRatingApps;
        _x.messagesBlocked = messagesBlocked;
        _x.notificationsBlockSettingsModification = notificationsBlockSettingsModification;
        _x.passcodeBlockFingerprintUnlock = passcodeBlockFingerprintUnlock;
        _x.passcodeBlockFingerprintModification = passcodeBlockFingerprintModification;
        _x.passcodeBlockModification = passcodeBlockModification;
        _x.passcodeBlockSimple = passcodeBlockSimple;
        _x.passcodeExpirationDays = passcodeExpirationDays;
        _x.passcodeMinimumLength = passcodeMinimumLength;
        _x.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
        _x.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
        _x.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
        _x.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
        _x.passcodeSignInFailureCountBeforeWipe = passcodeSignInFailureCountBeforeWipe;
        _x.passcodeRequiredType = passcodeRequiredType;
        _x.passcodeRequired = passcodeRequired;
        _x.podcastsBlocked = podcastsBlocked;
        _x.proximityBlockSetupToNewDevice = proximityBlockSetupToNewDevice;
        _x.safariBlockAutofill = safariBlockAutofill;
        _x.safariBlockJavaScript = safariBlockJavaScript;
        _x.safariBlockPopups = safariBlockPopups;
        _x.safariBlocked = safariBlocked;
        _x.safariCookieSettings = safariCookieSettings;
        _x.safariManagedDomains = safariManagedDomains;
        _x.safariPasswordAutoFillDomains = safariPasswordAutoFillDomains;
        _x.safariRequireFraudWarning = safariRequireFraudWarning;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.siriBlocked = siriBlocked;
        _x.siriBlockedWhenLocked = siriBlockedWhenLocked;
        _x.siriBlockUserGeneratedContent = siriBlockUserGeneratedContent;
        _x.siriRequireProfanityFilter = siriRequireProfanityFilter;
        _x.softwareUpdatesEnforcedDelayInDays = softwareUpdatesEnforcedDelayInDays;
        _x.softwareUpdatesForceDelayed = softwareUpdatesForceDelayed;
        _x.spotlightBlockInternetResults = spotlightBlockInternetResults;
        _x.voiceDialingBlocked = voiceDialingBlocked;
        _x.wallpaperBlockModification = wallpaperBlockModification;
        _x.wiFiConnectOnlyToConfiguredNetworks = wiFiConnectOnlyToConfiguredNetworks;
        _x.classroomForceRequestPermissionToLeaveClasses = classroomForceRequestPermissionToLeaveClasses;
        _x.keychainBlockCloudSync = keychainBlockCloudSync;
        _x.pkiBlockOTAUpdates = pkiBlockOTAUpdates;
        _x.privacyForceLimitAdTracking = privacyForceLimitAdTracking;
        _x.enterpriseBookBlockBackup = enterpriseBookBlockBackup;
        _x.enterpriseBookBlockMetadataSync = enterpriseBookBlockMetadataSync;
        _x.airPrintBlocked = airPrintBlocked;
        _x.airPrintBlockCredentialsStorage = airPrintBlockCredentialsStorage;
        _x.airPrintForceTrustedTLS = airPrintForceTrustedTLS;
        _x.airPrintBlockiBeaconDiscovery = airPrintBlockiBeaconDiscovery;
        _x.filesNetworkDriveAccessBlocked = filesNetworkDriveAccessBlocked;
        _x.filesUsbDriveAccessBlocked = filesUsbDriveAccessBlocked;
        _x.wifiPowerOnForced = wifiPowerOnForced;
        _x.blockSystemAppRemoval = blockSystemAppRemoval;
        _x.vpnBlockCreation = vpnBlockCreation;
        _x.appRemovalBlocked = appRemovalBlocked;
        _x.usbRestrictedModeBlocked = usbRestrictedModeBlocked;
        _x.passwordBlockAutoFill = passwordBlockAutoFill;
        _x.passwordBlockProximityRequests = passwordBlockProximityRequests;
        _x.passwordBlockAirDropSharing = passwordBlockAirDropSharing;
        _x.dateAndTimeForceSetAutomatically = dateAndTimeForceSetAutomatically;
        _x.contactsAllowManagedToUnmanagedWrite = contactsAllowManagedToUnmanagedWrite;
        _x.contactsAllowUnmanagedToManagedRead = contactsAllowUnmanagedToManagedRead;
        _x.cellularBlockPersonalHotspotModification = cellularBlockPersonalHotspotModification;
        _x.continuousPathKeyboardBlocked = continuousPathKeyboardBlocked;
        _x.findMyDeviceInFindMyAppBlocked = findMyDeviceInFindMyAppBlocked;
        _x.findMyFriendsInFindMyAppBlocked = findMyFriendsInFindMyAppBlocked;
        _x.iTunesBlocked = iTunesBlocked;
        _x.sharedDeviceBlockTemporarySessions = sharedDeviceBlockTemporarySessions;
        _x.kioskModeAppType = kioskModeAppType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosGeneralDeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("accountBlockModification=");
        b.append(this.accountBlockModification);
        b.append(", ");
        b.append("activationLockAllowWhenSupervised=");
        b.append(this.activationLockAllowWhenSupervised);
        b.append(", ");
        b.append("airDropBlocked=");
        b.append(this.airDropBlocked);
        b.append(", ");
        b.append("airDropForceUnmanagedDropTarget=");
        b.append(this.airDropForceUnmanagedDropTarget);
        b.append(", ");
        b.append("airPlayForcePairingPasswordForOutgoingRequests=");
        b.append(this.airPlayForcePairingPasswordForOutgoingRequests);
        b.append(", ");
        b.append("appleWatchBlockPairing=");
        b.append(this.appleWatchBlockPairing);
        b.append(", ");
        b.append("appleWatchForceWristDetection=");
        b.append(this.appleWatchForceWristDetection);
        b.append(", ");
        b.append("appleNewsBlocked=");
        b.append(this.appleNewsBlocked);
        b.append(", ");
        b.append("appsSingleAppModeList=");
        b.append(this.appsSingleAppModeList);
        b.append(", ");
        b.append("appsVisibilityList=");
        b.append(this.appsVisibilityList);
        b.append(", ");
        b.append("appsVisibilityListType=");
        b.append(this.appsVisibilityListType);
        b.append(", ");
        b.append("appStoreBlockAutomaticDownloads=");
        b.append(this.appStoreBlockAutomaticDownloads);
        b.append(", ");
        b.append("appStoreBlocked=");
        b.append(this.appStoreBlocked);
        b.append(", ");
        b.append("appStoreBlockInAppPurchases=");
        b.append(this.appStoreBlockInAppPurchases);
        b.append(", ");
        b.append("appStoreBlockUIAppInstallation=");
        b.append(this.appStoreBlockUIAppInstallation);
        b.append(", ");
        b.append("appStoreRequirePassword=");
        b.append(this.appStoreRequirePassword);
        b.append(", ");
        b.append("autoFillForceAuthentication=");
        b.append(this.autoFillForceAuthentication);
        b.append(", ");
        b.append("bluetoothBlockModification=");
        b.append(this.bluetoothBlockModification);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("cellularBlockDataRoaming=");
        b.append(this.cellularBlockDataRoaming);
        b.append(", ");
        b.append("cellularBlockGlobalBackgroundFetchWhileRoaming=");
        b.append(this.cellularBlockGlobalBackgroundFetchWhileRoaming);
        b.append(", ");
        b.append("cellularBlockPerAppDataModification=");
        b.append(this.cellularBlockPerAppDataModification);
        b.append(", ");
        b.append("cellularBlockPersonalHotspot=");
        b.append(this.cellularBlockPersonalHotspot);
        b.append(", ");
        b.append("cellularBlockPlanModification=");
        b.append(this.cellularBlockPlanModification);
        b.append(", ");
        b.append("cellularBlockVoiceRoaming=");
        b.append(this.cellularBlockVoiceRoaming);
        b.append(", ");
        b.append("certificatesBlockUntrustedTlsCertificates=");
        b.append(this.certificatesBlockUntrustedTlsCertificates);
        b.append(", ");
        b.append("classroomAppBlockRemoteScreenObservation=");
        b.append(this.classroomAppBlockRemoteScreenObservation);
        b.append(", ");
        b.append("classroomAppForceUnpromptedScreenObservation=");
        b.append(this.classroomAppForceUnpromptedScreenObservation);
        b.append(", ");
        b.append("classroomForceAutomaticallyJoinClasses=");
        b.append(this.classroomForceAutomaticallyJoinClasses);
        b.append(", ");
        b.append("classroomForceUnpromptedAppAndDeviceLock=");
        b.append(this.classroomForceUnpromptedAppAndDeviceLock);
        b.append(", ");
        b.append("compliantAppsList=");
        b.append(this.compliantAppsList);
        b.append(", ");
        b.append("compliantAppListType=");
        b.append(this.compliantAppListType);
        b.append(", ");
        b.append("configurationProfileBlockChanges=");
        b.append(this.configurationProfileBlockChanges);
        b.append(", ");
        b.append("definitionLookupBlocked=");
        b.append(this.definitionLookupBlocked);
        b.append(", ");
        b.append("deviceBlockEnableRestrictions=");
        b.append(this.deviceBlockEnableRestrictions);
        b.append(", ");
        b.append("deviceBlockEraseContentAndSettings=");
        b.append(this.deviceBlockEraseContentAndSettings);
        b.append(", ");
        b.append("deviceBlockNameModification=");
        b.append(this.deviceBlockNameModification);
        b.append(", ");
        b.append("diagnosticDataBlockSubmission=");
        b.append(this.diagnosticDataBlockSubmission);
        b.append(", ");
        b.append("diagnosticDataBlockSubmissionModification=");
        b.append(this.diagnosticDataBlockSubmissionModification);
        b.append(", ");
        b.append("documentsBlockManagedDocumentsInUnmanagedApps=");
        b.append(this.documentsBlockManagedDocumentsInUnmanagedApps);
        b.append(", ");
        b.append("documentsBlockUnmanagedDocumentsInManagedApps=");
        b.append(this.documentsBlockUnmanagedDocumentsInManagedApps);
        b.append(", ");
        b.append("emailInDomainSuffixes=");
        b.append(this.emailInDomainSuffixes);
        b.append(", ");
        b.append("enterpriseAppBlockTrust=");
        b.append(this.enterpriseAppBlockTrust);
        b.append(", ");
        b.append("enterpriseAppBlockTrustModification=");
        b.append(this.enterpriseAppBlockTrustModification);
        b.append(", ");
        b.append("esimBlockModification=");
        b.append(this.esimBlockModification);
        b.append(", ");
        b.append("faceTimeBlocked=");
        b.append(this.faceTimeBlocked);
        b.append(", ");
        b.append("findMyFriendsBlocked=");
        b.append(this.findMyFriendsBlocked);
        b.append(", ");
        b.append("gamingBlockGameCenterFriends=");
        b.append(this.gamingBlockGameCenterFriends);
        b.append(", ");
        b.append("gamingBlockMultiplayer=");
        b.append(this.gamingBlockMultiplayer);
        b.append(", ");
        b.append("gameCenterBlocked=");
        b.append(this.gameCenterBlocked);
        b.append(", ");
        b.append("hostPairingBlocked=");
        b.append(this.hostPairingBlocked);
        b.append(", ");
        b.append("iBooksStoreBlocked=");
        b.append(this.iBooksStoreBlocked);
        b.append(", ");
        b.append("iBooksStoreBlockErotica=");
        b.append(this.iBooksStoreBlockErotica);
        b.append(", ");
        b.append("iCloudBlockActivityContinuation=");
        b.append(this.iCloudBlockActivityContinuation);
        b.append(", ");
        b.append("iCloudBlockBackup=");
        b.append(this.iCloudBlockBackup);
        b.append(", ");
        b.append("iCloudBlockDocumentSync=");
        b.append(this.iCloudBlockDocumentSync);
        b.append(", ");
        b.append("iCloudBlockManagedAppsSync=");
        b.append(this.iCloudBlockManagedAppsSync);
        b.append(", ");
        b.append("iCloudBlockPhotoLibrary=");
        b.append(this.iCloudBlockPhotoLibrary);
        b.append(", ");
        b.append("iCloudBlockPhotoStreamSync=");
        b.append(this.iCloudBlockPhotoStreamSync);
        b.append(", ");
        b.append("iCloudBlockSharedPhotoStream=");
        b.append(this.iCloudBlockSharedPhotoStream);
        b.append(", ");
        b.append("iCloudRequireEncryptedBackup=");
        b.append(this.iCloudRequireEncryptedBackup);
        b.append(", ");
        b.append("iTunesBlockExplicitContent=");
        b.append(this.iTunesBlockExplicitContent);
        b.append(", ");
        b.append("iTunesBlockMusicService=");
        b.append(this.iTunesBlockMusicService);
        b.append(", ");
        b.append("iTunesBlockRadio=");
        b.append(this.iTunesBlockRadio);
        b.append(", ");
        b.append("keyboardBlockAutoCorrect=");
        b.append(this.keyboardBlockAutoCorrect);
        b.append(", ");
        b.append("keyboardBlockDictation=");
        b.append(this.keyboardBlockDictation);
        b.append(", ");
        b.append("keyboardBlockPredictive=");
        b.append(this.keyboardBlockPredictive);
        b.append(", ");
        b.append("keyboardBlockShortcuts=");
        b.append(this.keyboardBlockShortcuts);
        b.append(", ");
        b.append("keyboardBlockSpellCheck=");
        b.append(this.keyboardBlockSpellCheck);
        b.append(", ");
        b.append("kioskModeAllowAssistiveSpeak=");
        b.append(this.kioskModeAllowAssistiveSpeak);
        b.append(", ");
        b.append("kioskModeAllowAssistiveTouchSettings=");
        b.append(this.kioskModeAllowAssistiveTouchSettings);
        b.append(", ");
        b.append("kioskModeAllowAutoLock=");
        b.append(this.kioskModeAllowAutoLock);
        b.append(", ");
        b.append("kioskModeBlockAutoLock=");
        b.append(this.kioskModeBlockAutoLock);
        b.append(", ");
        b.append("kioskModeAllowColorInversionSettings=");
        b.append(this.kioskModeAllowColorInversionSettings);
        b.append(", ");
        b.append("kioskModeAllowRingerSwitch=");
        b.append(this.kioskModeAllowRingerSwitch);
        b.append(", ");
        b.append("kioskModeBlockRingerSwitch=");
        b.append(this.kioskModeBlockRingerSwitch);
        b.append(", ");
        b.append("kioskModeAllowScreenRotation=");
        b.append(this.kioskModeAllowScreenRotation);
        b.append(", ");
        b.append("kioskModeBlockScreenRotation=");
        b.append(this.kioskModeBlockScreenRotation);
        b.append(", ");
        b.append("kioskModeAllowSleepButton=");
        b.append(this.kioskModeAllowSleepButton);
        b.append(", ");
        b.append("kioskModeBlockSleepButton=");
        b.append(this.kioskModeBlockSleepButton);
        b.append(", ");
        b.append("kioskModeAllowTouchscreen=");
        b.append(this.kioskModeAllowTouchscreen);
        b.append(", ");
        b.append("kioskModeBlockTouchscreen=");
        b.append(this.kioskModeBlockTouchscreen);
        b.append(", ");
        b.append("kioskModeEnableVoiceControl=");
        b.append(this.kioskModeEnableVoiceControl);
        b.append(", ");
        b.append("kioskModeAllowVoiceControlModification=");
        b.append(this.kioskModeAllowVoiceControlModification);
        b.append(", ");
        b.append("kioskModeAllowVoiceOverSettings=");
        b.append(this.kioskModeAllowVoiceOverSettings);
        b.append(", ");
        b.append("kioskModeAllowVolumeButtons=");
        b.append(this.kioskModeAllowVolumeButtons);
        b.append(", ");
        b.append("kioskModeBlockVolumeButtons=");
        b.append(this.kioskModeBlockVolumeButtons);
        b.append(", ");
        b.append("kioskModeAllowZoomSettings=");
        b.append(this.kioskModeAllowZoomSettings);
        b.append(", ");
        b.append("kioskModeAppStoreUrl=");
        b.append(this.kioskModeAppStoreUrl);
        b.append(", ");
        b.append("kioskModeBuiltInAppId=");
        b.append(this.kioskModeBuiltInAppId);
        b.append(", ");
        b.append("kioskModeRequireAssistiveTouch=");
        b.append(this.kioskModeRequireAssistiveTouch);
        b.append(", ");
        b.append("kioskModeRequireColorInversion=");
        b.append(this.kioskModeRequireColorInversion);
        b.append(", ");
        b.append("kioskModeRequireMonoAudio=");
        b.append(this.kioskModeRequireMonoAudio);
        b.append(", ");
        b.append("kioskModeRequireVoiceOver=");
        b.append(this.kioskModeRequireVoiceOver);
        b.append(", ");
        b.append("kioskModeRequireZoom=");
        b.append(this.kioskModeRequireZoom);
        b.append(", ");
        b.append("kioskModeManagedAppId=");
        b.append(this.kioskModeManagedAppId);
        b.append(", ");
        b.append("lockScreenBlockControlCenter=");
        b.append(this.lockScreenBlockControlCenter);
        b.append(", ");
        b.append("lockScreenBlockNotificationView=");
        b.append(this.lockScreenBlockNotificationView);
        b.append(", ");
        b.append("lockScreenBlockPassbook=");
        b.append(this.lockScreenBlockPassbook);
        b.append(", ");
        b.append("lockScreenBlockTodayView=");
        b.append(this.lockScreenBlockTodayView);
        b.append(", ");
        b.append("mediaContentRatingAustralia=");
        b.append(this.mediaContentRatingAustralia);
        b.append(", ");
        b.append("mediaContentRatingCanada=");
        b.append(this.mediaContentRatingCanada);
        b.append(", ");
        b.append("mediaContentRatingFrance=");
        b.append(this.mediaContentRatingFrance);
        b.append(", ");
        b.append("mediaContentRatingGermany=");
        b.append(this.mediaContentRatingGermany);
        b.append(", ");
        b.append("mediaContentRatingIreland=");
        b.append(this.mediaContentRatingIreland);
        b.append(", ");
        b.append("mediaContentRatingJapan=");
        b.append(this.mediaContentRatingJapan);
        b.append(", ");
        b.append("mediaContentRatingNewZealand=");
        b.append(this.mediaContentRatingNewZealand);
        b.append(", ");
        b.append("mediaContentRatingUnitedKingdom=");
        b.append(this.mediaContentRatingUnitedKingdom);
        b.append(", ");
        b.append("mediaContentRatingUnitedStates=");
        b.append(this.mediaContentRatingUnitedStates);
        b.append(", ");
        b.append("networkUsageRules=");
        b.append(this.networkUsageRules);
        b.append(", ");
        b.append("mediaContentRatingApps=");
        b.append(this.mediaContentRatingApps);
        b.append(", ");
        b.append("messagesBlocked=");
        b.append(this.messagesBlocked);
        b.append(", ");
        b.append("notificationsBlockSettingsModification=");
        b.append(this.notificationsBlockSettingsModification);
        b.append(", ");
        b.append("passcodeBlockFingerprintUnlock=");
        b.append(this.passcodeBlockFingerprintUnlock);
        b.append(", ");
        b.append("passcodeBlockFingerprintModification=");
        b.append(this.passcodeBlockFingerprintModification);
        b.append(", ");
        b.append("passcodeBlockModification=");
        b.append(this.passcodeBlockModification);
        b.append(", ");
        b.append("passcodeBlockSimple=");
        b.append(this.passcodeBlockSimple);
        b.append(", ");
        b.append("passcodeExpirationDays=");
        b.append(this.passcodeExpirationDays);
        b.append(", ");
        b.append("passcodeMinimumLength=");
        b.append(this.passcodeMinimumLength);
        b.append(", ");
        b.append("passcodeMinutesOfInactivityBeforeLock=");
        b.append(this.passcodeMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passcodeMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passcodeMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passcodeMinimumCharacterSetCount=");
        b.append(this.passcodeMinimumCharacterSetCount);
        b.append(", ");
        b.append("passcodePreviousPasscodeBlockCount=");
        b.append(this.passcodePreviousPasscodeBlockCount);
        b.append(", ");
        b.append("passcodeSignInFailureCountBeforeWipe=");
        b.append(this.passcodeSignInFailureCountBeforeWipe);
        b.append(", ");
        b.append("passcodeRequiredType=");
        b.append(this.passcodeRequiredType);
        b.append(", ");
        b.append("passcodeRequired=");
        b.append(this.passcodeRequired);
        b.append(", ");
        b.append("podcastsBlocked=");
        b.append(this.podcastsBlocked);
        b.append(", ");
        b.append("proximityBlockSetupToNewDevice=");
        b.append(this.proximityBlockSetupToNewDevice);
        b.append(", ");
        b.append("safariBlockAutofill=");
        b.append(this.safariBlockAutofill);
        b.append(", ");
        b.append("safariBlockJavaScript=");
        b.append(this.safariBlockJavaScript);
        b.append(", ");
        b.append("safariBlockPopups=");
        b.append(this.safariBlockPopups);
        b.append(", ");
        b.append("safariBlocked=");
        b.append(this.safariBlocked);
        b.append(", ");
        b.append("safariCookieSettings=");
        b.append(this.safariCookieSettings);
        b.append(", ");
        b.append("safariManagedDomains=");
        b.append(this.safariManagedDomains);
        b.append(", ");
        b.append("safariPasswordAutoFillDomains=");
        b.append(this.safariPasswordAutoFillDomains);
        b.append(", ");
        b.append("safariRequireFraudWarning=");
        b.append(this.safariRequireFraudWarning);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("siriBlocked=");
        b.append(this.siriBlocked);
        b.append(", ");
        b.append("siriBlockedWhenLocked=");
        b.append(this.siriBlockedWhenLocked);
        b.append(", ");
        b.append("siriBlockUserGeneratedContent=");
        b.append(this.siriBlockUserGeneratedContent);
        b.append(", ");
        b.append("siriRequireProfanityFilter=");
        b.append(this.siriRequireProfanityFilter);
        b.append(", ");
        b.append("softwareUpdatesEnforcedDelayInDays=");
        b.append(this.softwareUpdatesEnforcedDelayInDays);
        b.append(", ");
        b.append("softwareUpdatesForceDelayed=");
        b.append(this.softwareUpdatesForceDelayed);
        b.append(", ");
        b.append("spotlightBlockInternetResults=");
        b.append(this.spotlightBlockInternetResults);
        b.append(", ");
        b.append("voiceDialingBlocked=");
        b.append(this.voiceDialingBlocked);
        b.append(", ");
        b.append("wallpaperBlockModification=");
        b.append(this.wallpaperBlockModification);
        b.append(", ");
        b.append("wiFiConnectOnlyToConfiguredNetworks=");
        b.append(this.wiFiConnectOnlyToConfiguredNetworks);
        b.append(", ");
        b.append("classroomForceRequestPermissionToLeaveClasses=");
        b.append(this.classroomForceRequestPermissionToLeaveClasses);
        b.append(", ");
        b.append("keychainBlockCloudSync=");
        b.append(this.keychainBlockCloudSync);
        b.append(", ");
        b.append("pkiBlockOTAUpdates=");
        b.append(this.pkiBlockOTAUpdates);
        b.append(", ");
        b.append("privacyForceLimitAdTracking=");
        b.append(this.privacyForceLimitAdTracking);
        b.append(", ");
        b.append("enterpriseBookBlockBackup=");
        b.append(this.enterpriseBookBlockBackup);
        b.append(", ");
        b.append("enterpriseBookBlockMetadataSync=");
        b.append(this.enterpriseBookBlockMetadataSync);
        b.append(", ");
        b.append("airPrintBlocked=");
        b.append(this.airPrintBlocked);
        b.append(", ");
        b.append("airPrintBlockCredentialsStorage=");
        b.append(this.airPrintBlockCredentialsStorage);
        b.append(", ");
        b.append("airPrintForceTrustedTLS=");
        b.append(this.airPrintForceTrustedTLS);
        b.append(", ");
        b.append("airPrintBlockiBeaconDiscovery=");
        b.append(this.airPrintBlockiBeaconDiscovery);
        b.append(", ");
        b.append("filesNetworkDriveAccessBlocked=");
        b.append(this.filesNetworkDriveAccessBlocked);
        b.append(", ");
        b.append("filesUsbDriveAccessBlocked=");
        b.append(this.filesUsbDriveAccessBlocked);
        b.append(", ");
        b.append("wifiPowerOnForced=");
        b.append(this.wifiPowerOnForced);
        b.append(", ");
        b.append("blockSystemAppRemoval=");
        b.append(this.blockSystemAppRemoval);
        b.append(", ");
        b.append("vpnBlockCreation=");
        b.append(this.vpnBlockCreation);
        b.append(", ");
        b.append("appRemovalBlocked=");
        b.append(this.appRemovalBlocked);
        b.append(", ");
        b.append("usbRestrictedModeBlocked=");
        b.append(this.usbRestrictedModeBlocked);
        b.append(", ");
        b.append("passwordBlockAutoFill=");
        b.append(this.passwordBlockAutoFill);
        b.append(", ");
        b.append("passwordBlockProximityRequests=");
        b.append(this.passwordBlockProximityRequests);
        b.append(", ");
        b.append("passwordBlockAirDropSharing=");
        b.append(this.passwordBlockAirDropSharing);
        b.append(", ");
        b.append("dateAndTimeForceSetAutomatically=");
        b.append(this.dateAndTimeForceSetAutomatically);
        b.append(", ");
        b.append("contactsAllowManagedToUnmanagedWrite=");
        b.append(this.contactsAllowManagedToUnmanagedWrite);
        b.append(", ");
        b.append("contactsAllowUnmanagedToManagedRead=");
        b.append(this.contactsAllowUnmanagedToManagedRead);
        b.append(", ");
        b.append("cellularBlockPersonalHotspotModification=");
        b.append(this.cellularBlockPersonalHotspotModification);
        b.append(", ");
        b.append("continuousPathKeyboardBlocked=");
        b.append(this.continuousPathKeyboardBlocked);
        b.append(", ");
        b.append("findMyDeviceInFindMyAppBlocked=");
        b.append(this.findMyDeviceInFindMyAppBlocked);
        b.append(", ");
        b.append("findMyFriendsInFindMyAppBlocked=");
        b.append(this.findMyFriendsInFindMyAppBlocked);
        b.append(", ");
        b.append("iTunesBlocked=");
        b.append(this.iTunesBlocked);
        b.append(", ");
        b.append("sharedDeviceBlockTemporarySessions=");
        b.append(this.sharedDeviceBlockTemporarySessions);
        b.append(", ");
        b.append("kioskModeAppType=");
        b.append(this.kioskModeAppType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
