package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.collection.request.IosTrustedRootCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementDerivedCredentialSettingsRequest;
import odata.msgraph.client.beta.entity.request.IosCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.EapFastConfiguration;
import odata.msgraph.client.beta.enums.EapType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForEapTtlsType;
import odata.msgraph.client.beta.enums.WiFiAuthenticationMethod;
import odata.msgraph.client.beta.enums.WiFiProxySetting;
import odata.msgraph.client.beta.enums.WiFiSecurityType;


/**
 * <i>“By providing the configurations in this profile you can instruct the iOS device
 * to connect to desired Wi-Fi endpoint. By specifying the authentication method
 * and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection
 * seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "eapType", 
    "eapFastConfiguration", 
    "trustedServerCertificateNames", 
    "authenticationMethod", 
    "innerAuthenticationProtocolForEapTtls", 
    "outerIdentityPrivacyTemporaryValue", 
    "usernameFormatString", 
    "passwordFormatString"})
@JsonInclude(Include.NON_NULL)
public class IosEnterpriseWiFiConfiguration extends IosWiFiConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosEnterpriseWiFiConfiguration";
    }

    @JsonProperty("eapType")
    protected EapType eapType;

    @JsonProperty("eapFastConfiguration")
    protected EapFastConfiguration eapFastConfiguration;

    @JsonProperty("trustedServerCertificateNames")
    protected List<String> trustedServerCertificateNames;

    @JsonProperty("trustedServerCertificateNames@nextLink")
    protected String trustedServerCertificateNamesNextLink;

    @JsonProperty("authenticationMethod")
    protected WiFiAuthenticationMethod authenticationMethod;

    @JsonProperty("innerAuthenticationProtocolForEapTtls")
    protected NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;

    @JsonProperty("outerIdentityPrivacyTemporaryValue")
    protected String outerIdentityPrivacyTemporaryValue;

    @JsonProperty("usernameFormatString")
    protected String usernameFormatString;

    @JsonProperty("passwordFormatString")
    protected String passwordFormatString;

    protected IosEnterpriseWiFiConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosEnterpriseWiFiConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String networkName;
        private String ssid;
        private Boolean connectAutomatically;
        private Boolean connectWhenNetworkNameIsHidden;
        private WiFiSecurityType wiFiSecurityType;
        private WiFiProxySetting proxySettings;
        private String proxyManualAddress;
        private Integer proxyManualPort;
        private String proxyAutomaticConfigurationUrl;
        private String preSharedKey;
        private EapType eapType;
        private EapFastConfiguration eapFastConfiguration;
        private List<String> trustedServerCertificateNames;
        private String trustedServerCertificateNamesNextLink;
        private WiFiAuthenticationMethod authenticationMethod;
        private NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;
        private String outerIdentityPrivacyTemporaryValue;
        private String usernameFormatString;
        private String passwordFormatString;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        public Builder wiFiSecurityType(WiFiSecurityType wiFiSecurityType) {
            this.wiFiSecurityType = wiFiSecurityType;
            this.changedFields = changedFields.add("wiFiSecurityType");
            return this;
        }

        public Builder proxySettings(WiFiProxySetting proxySettings) {
            this.proxySettings = proxySettings;
            this.changedFields = changedFields.add("proxySettings");
            return this;
        }

        public Builder proxyManualAddress(String proxyManualAddress) {
            this.proxyManualAddress = proxyManualAddress;
            this.changedFields = changedFields.add("proxyManualAddress");
            return this;
        }

        public Builder proxyManualPort(Integer proxyManualPort) {
            this.proxyManualPort = proxyManualPort;
            this.changedFields = changedFields.add("proxyManualPort");
            return this;
        }

        public Builder proxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
            this.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            this.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
            return this;
        }

        public Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            this.changedFields = changedFields.add("preSharedKey");
            return this;
        }

        /**
         * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
         * on the Wi-Fi endpoint (router).”</i>
         * 
         * @param eapType
         *            value of {@code eapType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapType(EapType eapType) {
            this.eapType = eapType;
            this.changedFields = changedFields.add("eapType");
            return this;
        }

        /**
         * <i>“EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.”</i>
         * 
         * @param eapFastConfiguration
         *            value of {@code eapFastConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapFastConfiguration(EapFastConfiguration eapFastConfiguration) {
            this.eapFastConfiguration = eapFastConfiguration;
            this.changedFields = changedFields.add("eapFastConfiguration");
            return this;
        }

        /**
         * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
         * FAST or PEAP. This is the common name used in the certificates issued by your
         * trusted certificate authority (CA). If you provide this information, you can
         * bypass the dynamic trust dialog that is displayed on end users' devices when
         * they connect to this Wi-Fi network.”</i>
         * 
         * @param trustedServerCertificateNames
         *            value of {@code trustedServerCertificateNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNames(List<String> trustedServerCertificateNames) {
            this.trustedServerCertificateNames = trustedServerCertificateNames;
            this.changedFields = changedFields.add("trustedServerCertificateNames");
            return this;
        }

        /**
         * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
         * FAST or PEAP. This is the common name used in the certificates issued by your
         * trusted certificate authority (CA). If you provide this information, you can
         * bypass the dynamic trust dialog that is displayed on end users' devices when
         * they connect to this Wi-Fi network.”</i>
         * 
         * @param trustedServerCertificateNames
         *            value of {@code trustedServerCertificateNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNames(String... trustedServerCertificateNames) {
            return trustedServerCertificateNames(Arrays.asList(trustedServerCertificateNames));
        }

        /**
         * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
         * FAST or PEAP. This is the common name used in the certificates issued by your
         * trusted certificate authority (CA). If you provide this information, you can
         * bypass the dynamic trust dialog that is displayed on end users' devices when
         * they connect to this Wi-Fi network.”</i>
         * 
         * @param trustedServerCertificateNamesNextLink
         *            value of {@code trustedServerCertificateNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNamesNextLink(String trustedServerCertificateNamesNextLink) {
            this.trustedServerCertificateNamesNextLink = trustedServerCertificateNamesNextLink;
            this.changedFields = changedFields.add("trustedServerCertificateNames");
            return this;
        }

        /**
         * <i>“Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Non-EAP Method for Authentication when EAP Type is EAP-TTLS and
         * Authenticationmethod is Username and Password.”</i>
         * 
         * @param innerAuthenticationProtocolForEapTtls
         *            value of {@code innerAuthenticationProtocolForEapTtls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
            this.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
            return this;
        }

        /**
         * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP -
         * TTLS, EAP - FAST or PEAP. This property masks usernames with the text you enter.
         * For example, if you use 'anonymous', each user that authenticates with this Wi-
         * Fi connection using their real username is displayed as 'anonymous'.”</i>
         * 
         * @param outerIdentityPrivacyTemporaryValue
         *            value of {@code outerIdentityPrivacyTemporaryValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outerIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
            this.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            this.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
            return this;
        }

        /**
         * <i>“Username format string used to build the username to connect to wifi”</i>
         * 
         * @param usernameFormatString
         *            value of {@code usernameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usernameFormatString(String usernameFormatString) {
            this.usernameFormatString = usernameFormatString;
            this.changedFields = changedFields.add("usernameFormatString");
            return this;
        }

        /**
         * <i>“Password format string used to build the password to connect to wifi”</i>
         * 
         * @param passwordFormatString
         *            value of {@code passwordFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordFormatString(String passwordFormatString) {
            this.passwordFormatString = passwordFormatString;
            this.changedFields = changedFields.add("passwordFormatString");
            return this;
        }

        public IosEnterpriseWiFiConfiguration build() {
            IosEnterpriseWiFiConfiguration _x = new IosEnterpriseWiFiConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosEnterpriseWiFiConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.networkName = networkName;
            _x.ssid = ssid;
            _x.connectAutomatically = connectAutomatically;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.wiFiSecurityType = wiFiSecurityType;
            _x.proxySettings = proxySettings;
            _x.proxyManualAddress = proxyManualAddress;
            _x.proxyManualPort = proxyManualPort;
            _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            _x.preSharedKey = preSharedKey;
            _x.eapType = eapType;
            _x.eapFastConfiguration = eapFastConfiguration;
            _x.trustedServerCertificateNames = trustedServerCertificateNames;
            _x.trustedServerCertificateNamesNextLink = trustedServerCertificateNamesNextLink;
            _x.authenticationMethod = authenticationMethod;
            _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            _x.usernameFormatString = usernameFormatString;
            _x.passwordFormatString = passwordFormatString;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
     * on the Wi-Fi endpoint (router).”</i>
     * 
     * @return property eapType
     */
    @Property(name="eapType")
    @JsonIgnore
    public Optional<EapType> getEapType() {
        return Optional.ofNullable(eapType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eapType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
     * on the Wi-Fi endpoint (router).”</i>
     * 
     * @param eapType
     *            new value of {@code eapType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapType} field changed
     */
    public IosEnterpriseWiFiConfiguration withEapType(EapType eapType) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.eapType = eapType;
        return _x;
    }

    /**
     * <i>“EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.”</i>
     * 
     * @return property eapFastConfiguration
     */
    @Property(name="eapFastConfiguration")
    @JsonIgnore
    public Optional<EapFastConfiguration> getEapFastConfiguration() {
        return Optional.ofNullable(eapFastConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * eapFastConfiguration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.”</i>
     * 
     * @param eapFastConfiguration
     *            new value of {@code eapFastConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapFastConfiguration} field changed
     */
    public IosEnterpriseWiFiConfiguration withEapFastConfiguration(EapFastConfiguration eapFastConfiguration) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapFastConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.eapFastConfiguration = eapFastConfiguration;
        return _x;
    }

    /**
     * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
     * FAST or PEAP. This is the common name used in the certificates issued by your
     * trusted certificate authority (CA). If you provide this information, you can
     * bypass the dynamic trust dialog that is displayed on end users' devices when
     * they connect to this Wi-Fi network.”</i>
     * 
     * @return property trustedServerCertificateNames
     */
    @Property(name="trustedServerCertificateNames")
    @JsonIgnore
    public CollectionPage<String> getTrustedServerCertificateNames() {
        return new CollectionPage<String>(contextPath, String.class, trustedServerCertificateNames, Optional.ofNullable(trustedServerCertificateNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
     * FAST or PEAP. This is the common name used in the certificates issued by your
     * trusted certificate authority (CA). If you provide this information, you can
     * bypass the dynamic trust dialog that is displayed on end users' devices when
     * they connect to this Wi-Fi network.”</i>
     * 
     * @return property trustedServerCertificateNames
     */
    @Property(name="trustedServerCertificateNames")
    @JsonIgnore
    public CollectionPage<String> getTrustedServerCertificateNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, trustedServerCertificateNames, Optional.ofNullable(trustedServerCertificateNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<WiFiAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public IosEnterpriseWiFiConfiguration withAuthenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Non-EAP Method for Authentication when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @return property innerAuthenticationProtocolForEapTtls
     */
    @Property(name="innerAuthenticationProtocolForEapTtls")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForEapTtlsType> getInnerAuthenticationProtocolForEapTtls() {
        return Optional.ofNullable(innerAuthenticationProtocolForEapTtls);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForEapTtls} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Non-EAP Method for Authentication when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @param innerAuthenticationProtocolForEapTtls
     *            new value of {@code innerAuthenticationProtocolForEapTtls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForEapTtls} field changed
     */
    public IosEnterpriseWiFiConfiguration withInnerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        return _x;
    }

    /**
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP -
     * TTLS, EAP - FAST or PEAP. This property masks usernames with the text you enter.
     * For example, if you use 'anonymous', each user that authenticates with this Wi-
     * Fi connection using their real username is displayed as 'anonymous'.”</i>
     * 
     * @return property outerIdentityPrivacyTemporaryValue
     */
    @Property(name="outerIdentityPrivacyTemporaryValue")
    @JsonIgnore
    public Optional<String> getOuterIdentityPrivacyTemporaryValue() {
        return Optional.ofNullable(outerIdentityPrivacyTemporaryValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outerIdentityPrivacyTemporaryValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP -
     * TTLS, EAP - FAST or PEAP. This property masks usernames with the text you enter.
     * For example, if you use 'anonymous', each user that authenticates with this Wi-
     * Fi connection using their real username is displayed as 'anonymous'.”</i>
     * 
     * @param outerIdentityPrivacyTemporaryValue
     *            new value of {@code outerIdentityPrivacyTemporaryValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outerIdentityPrivacyTemporaryValue} field changed
     */
    public IosEnterpriseWiFiConfiguration withOuterIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        return _x;
    }

    /**
     * <i>“Username format string used to build the username to connect to wifi”</i>
     * 
     * @return property usernameFormatString
     */
    @Property(name="usernameFormatString")
    @JsonIgnore
    public Optional<String> getUsernameFormatString() {
        return Optional.ofNullable(usernameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * usernameFormatString} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Username format string used to build the username to connect to wifi”</i>
     * 
     * @param usernameFormatString
     *            new value of {@code usernameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usernameFormatString} field changed
     */
    public IosEnterpriseWiFiConfiguration withUsernameFormatString(String usernameFormatString) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usernameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.usernameFormatString = usernameFormatString;
        return _x;
    }

    /**
     * <i>“Password format string used to build the password to connect to wifi”</i>
     * 
     * @return property passwordFormatString
     */
    @Property(name="passwordFormatString")
    @JsonIgnore
    public Optional<String> getPasswordFormatString() {
        return Optional.ofNullable(passwordFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordFormatString} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Password format string used to build the password to connect to wifi”</i>
     * 
     * @param passwordFormatString
     *            new value of {@code passwordFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordFormatString} field changed
     */
    public IosEnterpriseWiFiConfiguration withPasswordFormatString(String passwordFormatString) {
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEnterpriseWiFiConfiguration");
        _x.passwordFormatString = passwordFormatString;
        return _x;
    }

    /**
     * <i>“Trusted Root Certificates for Server Validation when EAP Type is configured to
     * EAP-TLS/TTLS/FAST or PEAP. If you provide this value you do not need to provide
     * trustedServerCertificateNames, and vice versa.”</i>
     * 
     * @return navigational property rootCertificatesForServerValidation
     */
    @NavigationProperty(name="rootCertificatesForServerValidation")
    @JsonIgnore
    public IosTrustedRootCertificateCollectionRequest getRootCertificatesForServerValidation() {
        return new IosTrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"));
    }

    /**
     * <i>“Identity Certificate for client authentication when EAP Type is configured to
     * EAP-TLS, EAP-TTLS (with Certificate Authentication), or PEAP (with Certificate
     * Authentication).”</i>
     * 
     * @return navigational property identityCertificateForClientAuthentication
     */
    @NavigationProperty(name="identityCertificateForClientAuthentication")
    @JsonIgnore
    public IosCertificateProfileBaseRequest getIdentityCertificateForClientAuthentication() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    /**
     * <i>“Tenant level settings for the Derived Credentials to be used for authentication.”</i>
     * 
     * @return navigational property derivedCredentialSettings
     */
    @NavigationProperty(name="derivedCredentialSettings")
    @JsonIgnore
    public DeviceManagementDerivedCredentialSettingsRequest getDerivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosEnterpriseWiFiConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosEnterpriseWiFiConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosEnterpriseWiFiConfiguration _copy() {
        IosEnterpriseWiFiConfiguration _x = new IosEnterpriseWiFiConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.networkName = networkName;
        _x.ssid = ssid;
        _x.connectAutomatically = connectAutomatically;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.wiFiSecurityType = wiFiSecurityType;
        _x.proxySettings = proxySettings;
        _x.proxyManualAddress = proxyManualAddress;
        _x.proxyManualPort = proxyManualPort;
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        _x.preSharedKey = preSharedKey;
        _x.eapType = eapType;
        _x.eapFastConfiguration = eapFastConfiguration;
        _x.trustedServerCertificateNames = trustedServerCertificateNames;
        _x.authenticationMethod = authenticationMethod;
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        _x.usernameFormatString = usernameFormatString;
        _x.passwordFormatString = passwordFormatString;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosEnterpriseWiFiConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("wiFiSecurityType=");
        b.append(this.wiFiSecurityType);
        b.append(", ");
        b.append("proxySettings=");
        b.append(this.proxySettings);
        b.append(", ");
        b.append("proxyManualAddress=");
        b.append(this.proxyManualAddress);
        b.append(", ");
        b.append("proxyManualPort=");
        b.append(this.proxyManualPort);
        b.append(", ");
        b.append("proxyAutomaticConfigurationUrl=");
        b.append(this.proxyAutomaticConfigurationUrl);
        b.append(", ");
        b.append("preSharedKey=");
        b.append(this.preSharedKey);
        b.append(", ");
        b.append("eapType=");
        b.append(this.eapType);
        b.append(", ");
        b.append("eapFastConfiguration=");
        b.append(this.eapFastConfiguration);
        b.append(", ");
        b.append("trustedServerCertificateNames=");
        b.append(this.trustedServerCertificateNames);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("innerAuthenticationProtocolForEapTtls=");
        b.append(this.innerAuthenticationProtocolForEapTtls);
        b.append(", ");
        b.append("outerIdentityPrivacyTemporaryValue=");
        b.append(this.outerIdentityPrivacyTemporaryValue);
        b.append(", ");
        b.append("usernameFormatString=");
        b.append(this.usernameFormatString);
        b.append(", ");
        b.append("passwordFormatString=");
        b.append(this.passwordFormatString);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
