package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.request.DeviceManagementDerivedCredentialSettingsRequest;
import odata.msgraph.client.beta.entity.request.IosCertificateProfileBaseRequest;
import odata.msgraph.client.beta.entity.request.IosCertificateProfileRequest;
import odata.msgraph.client.beta.enums.DomainNameSource;
import odata.msgraph.client.beta.enums.EasAuthenticationMethod;
import odata.msgraph.client.beta.enums.EasServices;
import odata.msgraph.client.beta.enums.EmailCertificateType;
import odata.msgraph.client.beta.enums.EmailSyncDuration;
import odata.msgraph.client.beta.enums.UserEmailSource;
import odata.msgraph.client.beta.enums.UsernameSource;


/**
 * <i>“By providing configurations in this profile you can instruct the native email
 * client on iOS devices to communicate with an Exchange server and get email,
 * contacts, calendar, reminders, and notes. Furthermore, you can also specify how
 * much email to sync and how often the device should sync.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountName", 
    "authenticationMethod", 
    "blockMovingMessagesToOtherEmailAccounts", 
    "blockSendingEmailFromThirdPartyApps", 
    "blockSyncingRecentlyUsedEmailAddresses", 
    "durationOfEmailToSync", 
    "emailAddressSource", 
    "easServices", 
    "easServicesUserOverrideEnabled", 
    "hostName", 
    "requireSmime", 
    "smimeEnablePerMessageSwitch", 
    "smimeEncryptByDefaultEnabled", 
    "smimeSigningEnabled", 
    "smimeSigningUserOverrideEnabled", 
    "smimeEncryptByDefaultUserOverrideEnabled", 
    "smimeSigningCertificateUserOverrideEnabled", 
    "smimeEncryptionCertificateUserOverrideEnabled", 
    "requireSsl", 
    "useOAuth", 
    "signingCertificateType", 
    "encryptionCertificateType"})
@JsonInclude(Include.NON_NULL)
public class IosEasEmailProfileConfiguration extends EasEmailProfileConfigurationBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosEasEmailProfileConfiguration";
    }

    @JsonProperty("accountName")
    protected String accountName;

    @JsonProperty("authenticationMethod")
    protected EasAuthenticationMethod authenticationMethod;

    @JsonProperty("blockMovingMessagesToOtherEmailAccounts")
    protected Boolean blockMovingMessagesToOtherEmailAccounts;

    @JsonProperty("blockSendingEmailFromThirdPartyApps")
    protected Boolean blockSendingEmailFromThirdPartyApps;

    @JsonProperty("blockSyncingRecentlyUsedEmailAddresses")
    protected Boolean blockSyncingRecentlyUsedEmailAddresses;

    @JsonProperty("durationOfEmailToSync")
    protected EmailSyncDuration durationOfEmailToSync;

    @JsonProperty("emailAddressSource")
    protected UserEmailSource emailAddressSource;

    @JsonProperty("easServices")
    protected EasServices easServices;

    @JsonProperty("easServicesUserOverrideEnabled")
    protected Boolean easServicesUserOverrideEnabled;

    @JsonProperty("hostName")
    protected String hostName;

    @JsonProperty("requireSmime")
    protected Boolean requireSmime;

    @JsonProperty("smimeEnablePerMessageSwitch")
    protected Boolean smimeEnablePerMessageSwitch;

    @JsonProperty("smimeEncryptByDefaultEnabled")
    protected Boolean smimeEncryptByDefaultEnabled;

    @JsonProperty("smimeSigningEnabled")
    protected Boolean smimeSigningEnabled;

    @JsonProperty("smimeSigningUserOverrideEnabled")
    protected Boolean smimeSigningUserOverrideEnabled;

    @JsonProperty("smimeEncryptByDefaultUserOverrideEnabled")
    protected Boolean smimeEncryptByDefaultUserOverrideEnabled;

    @JsonProperty("smimeSigningCertificateUserOverrideEnabled")
    protected Boolean smimeSigningCertificateUserOverrideEnabled;

    @JsonProperty("smimeEncryptionCertificateUserOverrideEnabled")
    protected Boolean smimeEncryptionCertificateUserOverrideEnabled;

    @JsonProperty("requireSsl")
    protected Boolean requireSsl;

    @JsonProperty("useOAuth")
    protected Boolean useOAuth;

    @JsonProperty("signingCertificateType")
    protected EmailCertificateType signingCertificateType;

    @JsonProperty("encryptionCertificateType")
    protected EmailCertificateType encryptionCertificateType;

    protected IosEasEmailProfileConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosEasEmailProfileConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private UserEmailSource usernameSource;
        private UsernameSource usernameAADSource;
        private DomainNameSource userDomainNameSource;
        private String customDomainName;
        private String accountName;
        private EasAuthenticationMethod authenticationMethod;
        private Boolean blockMovingMessagesToOtherEmailAccounts;
        private Boolean blockSendingEmailFromThirdPartyApps;
        private Boolean blockSyncingRecentlyUsedEmailAddresses;
        private EmailSyncDuration durationOfEmailToSync;
        private UserEmailSource emailAddressSource;
        private EasServices easServices;
        private Boolean easServicesUserOverrideEnabled;
        private String hostName;
        private Boolean requireSmime;
        private Boolean smimeEnablePerMessageSwitch;
        private Boolean smimeEncryptByDefaultEnabled;
        private Boolean smimeSigningEnabled;
        private Boolean smimeSigningUserOverrideEnabled;
        private Boolean smimeEncryptByDefaultUserOverrideEnabled;
        private Boolean smimeSigningCertificateUserOverrideEnabled;
        private Boolean smimeEncryptionCertificateUserOverrideEnabled;
        private Boolean requireSsl;
        private Boolean useOAuth;
        private EmailCertificateType signingCertificateType;
        private EmailCertificateType encryptionCertificateType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder usernameSource(UserEmailSource usernameSource) {
            this.usernameSource = usernameSource;
            this.changedFields = changedFields.add("usernameSource");
            return this;
        }

        public Builder usernameAADSource(UsernameSource usernameAADSource) {
            this.usernameAADSource = usernameAADSource;
            this.changedFields = changedFields.add("usernameAADSource");
            return this;
        }

        public Builder userDomainNameSource(DomainNameSource userDomainNameSource) {
            this.userDomainNameSource = userDomainNameSource;
            this.changedFields = changedFields.add("userDomainNameSource");
            return this;
        }

        public Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            this.changedFields = changedFields.add("customDomainName");
            return this;
        }

        /**
         * <i>“Account name.”</i>
         * 
         * @param accountName
         *            value of {@code accountName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountName(String accountName) {
            this.accountName = accountName;
            this.changedFields = changedFields.add("accountName");
            return this;
        }

        /**
         * <i>“Authentication method for this Email profile.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(EasAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block moving messages to other email accounts.”</i>
         * 
         * @param blockMovingMessagesToOtherEmailAccounts
         *            value of {@code blockMovingMessagesToOtherEmailAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockMovingMessagesToOtherEmailAccounts(Boolean blockMovingMessagesToOtherEmailAccounts) {
            this.blockMovingMessagesToOtherEmailAccounts = blockMovingMessagesToOtherEmailAccounts;
            this.changedFields = changedFields.add("blockMovingMessagesToOtherEmailAccounts");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block sending email from third party apps.”</i>
         * 
         * @param blockSendingEmailFromThirdPartyApps
         *            value of {@code blockSendingEmailFromThirdPartyApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockSendingEmailFromThirdPartyApps(Boolean blockSendingEmailFromThirdPartyApps) {
            this.blockSendingEmailFromThirdPartyApps = blockSendingEmailFromThirdPartyApps;
            this.changedFields = changedFields.add("blockSendingEmailFromThirdPartyApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block syncing recently used email addresses, for
         * instance - when composing new email.”</i>
         * 
         * @param blockSyncingRecentlyUsedEmailAddresses
         *            value of {@code blockSyncingRecentlyUsedEmailAddresses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockSyncingRecentlyUsedEmailAddresses(Boolean blockSyncingRecentlyUsedEmailAddresses) {
            this.blockSyncingRecentlyUsedEmailAddresses = blockSyncingRecentlyUsedEmailAddresses;
            this.changedFields = changedFields.add("blockSyncingRecentlyUsedEmailAddresses");
            return this;
        }

        /**
         * <i>“Duration of time email should be synced back to.”</i>
         * 
         * @param durationOfEmailToSync
         *            value of {@code durationOfEmailToSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder durationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
            this.durationOfEmailToSync = durationOfEmailToSync;
            this.changedFields = changedFields.add("durationOfEmailToSync");
            return this;
        }

        /**
         * <i>“Email attribute that is picked from AAD and injected into this profile before
         * installing on the device.”</i>
         * 
         * @param emailAddressSource
         *            value of {@code emailAddressSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailAddressSource(UserEmailSource emailAddressSource) {
            this.emailAddressSource = emailAddressSource;
            this.changedFields = changedFields.add("emailAddressSource");
            return this;
        }

        /**
         * <i>“Exchange data to sync.”</i>
         * 
         * @param easServices
         *            value of {@code easServices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder easServices(EasServices easServices) {
            this.easServices = easServices;
            this.changedFields = changedFields.add("easServices");
            return this;
        }

        /**
         * <i>“Allow users to change sync settings.”</i>
         * 
         * @param easServicesUserOverrideEnabled
         *            value of {@code easServicesUserOverrideEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder easServicesUserOverrideEnabled(Boolean easServicesUserOverrideEnabled) {
            this.easServicesUserOverrideEnabled = easServicesUserOverrideEnabled;
            this.changedFields = changedFields.add("easServicesUserOverrideEnabled");
            return this;
        }

        /**
         * <i>“Exchange location that (URL) that the native mail app connects to.”</i>
         * 
         * @param hostName
         *            value of {@code hostName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.changedFields = changedFields.add("hostName");
            return this;
        }

        /**
         * <i>“Indicates whether or not to use S/MIME certificate.”</i>
         * 
         * @param requireSmime
         *            value of {@code requireSmime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireSmime(Boolean requireSmime) {
            this.requireSmime = requireSmime;
            this.changedFields = changedFields.add("requireSmime");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow unencrypted emails.”</i>
         * 
         * @param smimeEnablePerMessageSwitch
         *            value of {@code smimeEnablePerMessageSwitch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeEnablePerMessageSwitch(Boolean smimeEnablePerMessageSwitch) {
            this.smimeEnablePerMessageSwitch = smimeEnablePerMessageSwitch;
            this.changedFields = changedFields.add("smimeEnablePerMessageSwitch");
            return this;
        }

        /**
         * <i>“If set to true S/MIME encryption is enabled by default.”</i>
         * 
         * @param smimeEncryptByDefaultEnabled
         *            value of {@code smimeEncryptByDefaultEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeEncryptByDefaultEnabled(Boolean smimeEncryptByDefaultEnabled) {
            this.smimeEncryptByDefaultEnabled = smimeEncryptByDefaultEnabled;
            this.changedFields = changedFields.add("smimeEncryptByDefaultEnabled");
            return this;
        }

        /**
         * <i>“If set to true S/MIME signing is enabled for this account”</i>
         * 
         * @param smimeSigningEnabled
         *            value of {@code smimeSigningEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeSigningEnabled(Boolean smimeSigningEnabled) {
            this.smimeSigningEnabled = smimeSigningEnabled;
            this.changedFields = changedFields.add("smimeSigningEnabled");
            return this;
        }

        /**
         * <i>“If set to true, the user can toggle S/MIME signing on or off.”</i>
         * 
         * @param smimeSigningUserOverrideEnabled
         *            value of {@code smimeSigningUserOverrideEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeSigningUserOverrideEnabled(Boolean smimeSigningUserOverrideEnabled) {
            this.smimeSigningUserOverrideEnabled = smimeSigningUserOverrideEnabled;
            this.changedFields = changedFields.add("smimeSigningUserOverrideEnabled");
            return this;
        }

        /**
         * <i>“If set to true, the user can toggle the encryption by default setting.”</i>
         * 
         * @param smimeEncryptByDefaultUserOverrideEnabled
         *            value of {@code smimeEncryptByDefaultUserOverrideEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeEncryptByDefaultUserOverrideEnabled(Boolean smimeEncryptByDefaultUserOverrideEnabled) {
            this.smimeEncryptByDefaultUserOverrideEnabled = smimeEncryptByDefaultUserOverrideEnabled;
            this.changedFields = changedFields.add("smimeEncryptByDefaultUserOverrideEnabled");
            return this;
        }

        /**
         * <i>“If set to true, the user can select the signing identity.”</i>
         * 
         * @param smimeSigningCertificateUserOverrideEnabled
         *            value of {@code smimeSigningCertificateUserOverrideEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeSigningCertificateUserOverrideEnabled(Boolean smimeSigningCertificateUserOverrideEnabled) {
            this.smimeSigningCertificateUserOverrideEnabled = smimeSigningCertificateUserOverrideEnabled;
            this.changedFields = changedFields.add("smimeSigningCertificateUserOverrideEnabled");
            return this;
        }

        /**
         * <i>“If set to true the user can select the S/MIME encryption identity.”</i>
         * 
         * @param smimeEncryptionCertificateUserOverrideEnabled
         *            value of {@code smimeEncryptionCertificateUserOverrideEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smimeEncryptionCertificateUserOverrideEnabled(Boolean smimeEncryptionCertificateUserOverrideEnabled) {
            this.smimeEncryptionCertificateUserOverrideEnabled = smimeEncryptionCertificateUserOverrideEnabled;
            this.changedFields = changedFields.add("smimeEncryptionCertificateUserOverrideEnabled");
            return this;
        }

        /**
         * <i>“Indicates whether or not to use SSL.”</i>
         * 
         * @param requireSsl
         *            value of {@code requireSsl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireSsl(Boolean requireSsl) {
            this.requireSsl = requireSsl;
            this.changedFields = changedFields.add("requireSsl");
            return this;
        }

        /**
         * <i>“Specifies whether the connection should use OAuth for authentication.”</i>
         * 
         * @param useOAuth
         *            value of {@code useOAuth} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useOAuth(Boolean useOAuth) {
            this.useOAuth = useOAuth;
            this.changedFields = changedFields.add("useOAuth");
            return this;
        }

        /**
         * <i>“Signing Certificate type for this Email profile.”</i>
         * 
         * @param signingCertificateType
         *            value of {@code signingCertificateType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder signingCertificateType(EmailCertificateType signingCertificateType) {
            this.signingCertificateType = signingCertificateType;
            this.changedFields = changedFields.add("signingCertificateType");
            return this;
        }

        /**
         * <i>“Encryption Certificate type for this Email profile.”</i>
         * 
         * @param encryptionCertificateType
         *            value of {@code encryptionCertificateType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionCertificateType(EmailCertificateType encryptionCertificateType) {
            this.encryptionCertificateType = encryptionCertificateType;
            this.changedFields = changedFields.add("encryptionCertificateType");
            return this;
        }

        public IosEasEmailProfileConfiguration build() {
            IosEasEmailProfileConfiguration _x = new IosEasEmailProfileConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosEasEmailProfileConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.usernameSource = usernameSource;
            _x.usernameAADSource = usernameAADSource;
            _x.userDomainNameSource = userDomainNameSource;
            _x.customDomainName = customDomainName;
            _x.accountName = accountName;
            _x.authenticationMethod = authenticationMethod;
            _x.blockMovingMessagesToOtherEmailAccounts = blockMovingMessagesToOtherEmailAccounts;
            _x.blockSendingEmailFromThirdPartyApps = blockSendingEmailFromThirdPartyApps;
            _x.blockSyncingRecentlyUsedEmailAddresses = blockSyncingRecentlyUsedEmailAddresses;
            _x.durationOfEmailToSync = durationOfEmailToSync;
            _x.emailAddressSource = emailAddressSource;
            _x.easServices = easServices;
            _x.easServicesUserOverrideEnabled = easServicesUserOverrideEnabled;
            _x.hostName = hostName;
            _x.requireSmime = requireSmime;
            _x.smimeEnablePerMessageSwitch = smimeEnablePerMessageSwitch;
            _x.smimeEncryptByDefaultEnabled = smimeEncryptByDefaultEnabled;
            _x.smimeSigningEnabled = smimeSigningEnabled;
            _x.smimeSigningUserOverrideEnabled = smimeSigningUserOverrideEnabled;
            _x.smimeEncryptByDefaultUserOverrideEnabled = smimeEncryptByDefaultUserOverrideEnabled;
            _x.smimeSigningCertificateUserOverrideEnabled = smimeSigningCertificateUserOverrideEnabled;
            _x.smimeEncryptionCertificateUserOverrideEnabled = smimeEncryptionCertificateUserOverrideEnabled;
            _x.requireSsl = requireSsl;
            _x.useOAuth = useOAuth;
            _x.signingCertificateType = signingCertificateType;
            _x.encryptionCertificateType = encryptionCertificateType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Account name.”</i>
     * 
     * @return property accountName
     */
    @Property(name="accountName")
    @JsonIgnore
    public Optional<String> getAccountName() {
        return Optional.ofNullable(accountName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accountName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Account name.”</i>
     * 
     * @param accountName
     *            new value of {@code accountName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountName} field changed
     */
    public IosEasEmailProfileConfiguration withAccountName(String accountName) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.accountName = accountName;
        return _x;
    }

    /**
     * <i>“Authentication method for this Email profile.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<EasAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method for this Email profile.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public IosEasEmailProfileConfiguration withAuthenticationMethod(EasAuthenticationMethod authenticationMethod) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block moving messages to other email accounts.”</i>
     * 
     * @return property blockMovingMessagesToOtherEmailAccounts
     */
    @Property(name="blockMovingMessagesToOtherEmailAccounts")
    @JsonIgnore
    public Optional<Boolean> getBlockMovingMessagesToOtherEmailAccounts() {
        return Optional.ofNullable(blockMovingMessagesToOtherEmailAccounts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockMovingMessagesToOtherEmailAccounts} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block moving messages to other email accounts.”</i>
     * 
     * @param blockMovingMessagesToOtherEmailAccounts
     *            new value of {@code blockMovingMessagesToOtherEmailAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockMovingMessagesToOtherEmailAccounts} field changed
     */
    public IosEasEmailProfileConfiguration withBlockMovingMessagesToOtherEmailAccounts(Boolean blockMovingMessagesToOtherEmailAccounts) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("blockMovingMessagesToOtherEmailAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.blockMovingMessagesToOtherEmailAccounts = blockMovingMessagesToOtherEmailAccounts;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block sending email from third party apps.”</i>
     * 
     * @return property blockSendingEmailFromThirdPartyApps
     */
    @Property(name="blockSendingEmailFromThirdPartyApps")
    @JsonIgnore
    public Optional<Boolean> getBlockSendingEmailFromThirdPartyApps() {
        return Optional.ofNullable(blockSendingEmailFromThirdPartyApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockSendingEmailFromThirdPartyApps} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block sending email from third party apps.”</i>
     * 
     * @param blockSendingEmailFromThirdPartyApps
     *            new value of {@code blockSendingEmailFromThirdPartyApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockSendingEmailFromThirdPartyApps} field changed
     */
    public IosEasEmailProfileConfiguration withBlockSendingEmailFromThirdPartyApps(Boolean blockSendingEmailFromThirdPartyApps) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("blockSendingEmailFromThirdPartyApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.blockSendingEmailFromThirdPartyApps = blockSendingEmailFromThirdPartyApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block syncing recently used email addresses, for
     * instance - when composing new email.”</i>
     * 
     * @return property blockSyncingRecentlyUsedEmailAddresses
     */
    @Property(name="blockSyncingRecentlyUsedEmailAddresses")
    @JsonIgnore
    public Optional<Boolean> getBlockSyncingRecentlyUsedEmailAddresses() {
        return Optional.ofNullable(blockSyncingRecentlyUsedEmailAddresses);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockSyncingRecentlyUsedEmailAddresses} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block syncing recently used email addresses, for
     * instance - when composing new email.”</i>
     * 
     * @param blockSyncingRecentlyUsedEmailAddresses
     *            new value of {@code blockSyncingRecentlyUsedEmailAddresses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockSyncingRecentlyUsedEmailAddresses} field changed
     */
    public IosEasEmailProfileConfiguration withBlockSyncingRecentlyUsedEmailAddresses(Boolean blockSyncingRecentlyUsedEmailAddresses) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("blockSyncingRecentlyUsedEmailAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.blockSyncingRecentlyUsedEmailAddresses = blockSyncingRecentlyUsedEmailAddresses;
        return _x;
    }

    /**
     * <i>“Duration of time email should be synced back to.”</i>
     * 
     * @return property durationOfEmailToSync
     */
    @Property(name="durationOfEmailToSync")
    @JsonIgnore
    public Optional<EmailSyncDuration> getDurationOfEmailToSync() {
        return Optional.ofNullable(durationOfEmailToSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * durationOfEmailToSync} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Duration of time email should be synced back to.”</i>
     * 
     * @param durationOfEmailToSync
     *            new value of {@code durationOfEmailToSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code durationOfEmailToSync} field changed
     */
    public IosEasEmailProfileConfiguration withDurationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("durationOfEmailToSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.durationOfEmailToSync = durationOfEmailToSync;
        return _x;
    }

    /**
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property emailAddressSource
     */
    @Property(name="emailAddressSource")
    @JsonIgnore
    public Optional<UserEmailSource> getEmailAddressSource() {
        return Optional.ofNullable(emailAddressSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * emailAddressSource} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param emailAddressSource
     *            new value of {@code emailAddressSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailAddressSource} field changed
     */
    public IosEasEmailProfileConfiguration withEmailAddressSource(UserEmailSource emailAddressSource) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("emailAddressSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.emailAddressSource = emailAddressSource;
        return _x;
    }

    /**
     * <i>“Exchange data to sync.”</i>
     * 
     * @return property easServices
     */
    @Property(name="easServices")
    @JsonIgnore
    public Optional<EasServices> getEasServices() {
        return Optional.ofNullable(easServices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code easServices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Exchange data to sync.”</i>
     * 
     * @param easServices
     *            new value of {@code easServices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code easServices} field changed
     */
    public IosEasEmailProfileConfiguration withEasServices(EasServices easServices) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("easServices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.easServices = easServices;
        return _x;
    }

    /**
     * <i>“Allow users to change sync settings.”</i>
     * 
     * @return property easServicesUserOverrideEnabled
     */
    @Property(name="easServicesUserOverrideEnabled")
    @JsonIgnore
    public Optional<Boolean> getEasServicesUserOverrideEnabled() {
        return Optional.ofNullable(easServicesUserOverrideEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * easServicesUserOverrideEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow users to change sync settings.”</i>
     * 
     * @param easServicesUserOverrideEnabled
     *            new value of {@code easServicesUserOverrideEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code easServicesUserOverrideEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withEasServicesUserOverrideEnabled(Boolean easServicesUserOverrideEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("easServicesUserOverrideEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.easServicesUserOverrideEnabled = easServicesUserOverrideEnabled;
        return _x;
    }

    /**
     * <i>“Exchange location that (URL) that the native mail app connects to.”</i>
     * 
     * @return property hostName
     */
    @Property(name="hostName")
    @JsonIgnore
    public Optional<String> getHostName() {
        return Optional.ofNullable(hostName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hostName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Exchange location that (URL) that the native mail app connects to.”</i>
     * 
     * @param hostName
     *            new value of {@code hostName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hostName} field changed
     */
    public IosEasEmailProfileConfiguration withHostName(String hostName) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("hostName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.hostName = hostName;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to use S/MIME certificate.”</i>
     * 
     * @return property requireSmime
     */
    @Property(name="requireSmime")
    @JsonIgnore
    public Optional<Boolean> getRequireSmime() {
        return Optional.ofNullable(requireSmime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requireSmime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to use S/MIME certificate.”</i>
     * 
     * @param requireSmime
     *            new value of {@code requireSmime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireSmime} field changed
     */
    public IosEasEmailProfileConfiguration withRequireSmime(Boolean requireSmime) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requireSmime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.requireSmime = requireSmime;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow unencrypted emails.”</i>
     * 
     * @return property smimeEnablePerMessageSwitch
     */
    @Property(name="smimeEnablePerMessageSwitch")
    @JsonIgnore
    public Optional<Boolean> getSmimeEnablePerMessageSwitch() {
        return Optional.ofNullable(smimeEnablePerMessageSwitch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeEnablePerMessageSwitch} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow unencrypted emails.”</i>
     * 
     * @param smimeEnablePerMessageSwitch
     *            new value of {@code smimeEnablePerMessageSwitch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeEnablePerMessageSwitch} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeEnablePerMessageSwitch(Boolean smimeEnablePerMessageSwitch) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeEnablePerMessageSwitch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeEnablePerMessageSwitch = smimeEnablePerMessageSwitch;
        return _x;
    }

    /**
     * <i>“If set to true S/MIME encryption is enabled by default.”</i>
     * 
     * @return property smimeEncryptByDefaultEnabled
     */
    @Property(name="smimeEncryptByDefaultEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmimeEncryptByDefaultEnabled() {
        return Optional.ofNullable(smimeEncryptByDefaultEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeEncryptByDefaultEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“If set to true S/MIME encryption is enabled by default.”</i>
     * 
     * @param smimeEncryptByDefaultEnabled
     *            new value of {@code smimeEncryptByDefaultEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeEncryptByDefaultEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeEncryptByDefaultEnabled(Boolean smimeEncryptByDefaultEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeEncryptByDefaultEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeEncryptByDefaultEnabled = smimeEncryptByDefaultEnabled;
        return _x;
    }

    /**
     * <i>“If set to true S/MIME signing is enabled for this account”</i>
     * 
     * @return property smimeSigningEnabled
     */
    @Property(name="smimeSigningEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmimeSigningEnabled() {
        return Optional.ofNullable(smimeSigningEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeSigningEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“If set to true S/MIME signing is enabled for this account”</i>
     * 
     * @param smimeSigningEnabled
     *            new value of {@code smimeSigningEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeSigningEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeSigningEnabled(Boolean smimeSigningEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeSigningEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeSigningEnabled = smimeSigningEnabled;
        return _x;
    }

    /**
     * <i>“If set to true, the user can toggle S/MIME signing on or off.”</i>
     * 
     * @return property smimeSigningUserOverrideEnabled
     */
    @Property(name="smimeSigningUserOverrideEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmimeSigningUserOverrideEnabled() {
        return Optional.ofNullable(smimeSigningUserOverrideEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeSigningUserOverrideEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If set to true, the user can toggle S/MIME signing on or off.”</i>
     * 
     * @param smimeSigningUserOverrideEnabled
     *            new value of {@code smimeSigningUserOverrideEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeSigningUserOverrideEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeSigningUserOverrideEnabled(Boolean smimeSigningUserOverrideEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeSigningUserOverrideEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeSigningUserOverrideEnabled = smimeSigningUserOverrideEnabled;
        return _x;
    }

    /**
     * <i>“If set to true, the user can toggle the encryption by default setting.”</i>
     * 
     * @return property smimeEncryptByDefaultUserOverrideEnabled
     */
    @Property(name="smimeEncryptByDefaultUserOverrideEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmimeEncryptByDefaultUserOverrideEnabled() {
        return Optional.ofNullable(smimeEncryptByDefaultUserOverrideEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeEncryptByDefaultUserOverrideEnabled} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“If set to true, the user can toggle the encryption by default setting.”</i>
     * 
     * @param smimeEncryptByDefaultUserOverrideEnabled
     *            new value of {@code smimeEncryptByDefaultUserOverrideEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeEncryptByDefaultUserOverrideEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeEncryptByDefaultUserOverrideEnabled(Boolean smimeEncryptByDefaultUserOverrideEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeEncryptByDefaultUserOverrideEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeEncryptByDefaultUserOverrideEnabled = smimeEncryptByDefaultUserOverrideEnabled;
        return _x;
    }

    /**
     * <i>“If set to true, the user can select the signing identity.”</i>
     * 
     * @return property smimeSigningCertificateUserOverrideEnabled
     */
    @Property(name="smimeSigningCertificateUserOverrideEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmimeSigningCertificateUserOverrideEnabled() {
        return Optional.ofNullable(smimeSigningCertificateUserOverrideEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeSigningCertificateUserOverrideEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“If set to true, the user can select the signing identity.”</i>
     * 
     * @param smimeSigningCertificateUserOverrideEnabled
     *            new value of {@code smimeSigningCertificateUserOverrideEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeSigningCertificateUserOverrideEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeSigningCertificateUserOverrideEnabled(Boolean smimeSigningCertificateUserOverrideEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeSigningCertificateUserOverrideEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeSigningCertificateUserOverrideEnabled = smimeSigningCertificateUserOverrideEnabled;
        return _x;
    }

    /**
     * <i>“If set to true the user can select the S/MIME encryption identity.”</i>
     * 
     * @return property smimeEncryptionCertificateUserOverrideEnabled
     */
    @Property(name="smimeEncryptionCertificateUserOverrideEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmimeEncryptionCertificateUserOverrideEnabled() {
        return Optional.ofNullable(smimeEncryptionCertificateUserOverrideEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smimeEncryptionCertificateUserOverrideEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“If set to true the user can select the S/MIME encryption identity.”</i>
     * 
     * @param smimeEncryptionCertificateUserOverrideEnabled
     *            new value of {@code smimeEncryptionCertificateUserOverrideEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smimeEncryptionCertificateUserOverrideEnabled} field changed
     */
    public IosEasEmailProfileConfiguration withSmimeEncryptionCertificateUserOverrideEnabled(Boolean smimeEncryptionCertificateUserOverrideEnabled) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smimeEncryptionCertificateUserOverrideEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.smimeEncryptionCertificateUserOverrideEnabled = smimeEncryptionCertificateUserOverrideEnabled;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @return property requireSsl
     */
    @Property(name="requireSsl")
    @JsonIgnore
    public Optional<Boolean> getRequireSsl() {
        return Optional.ofNullable(requireSsl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requireSsl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @param requireSsl
     *            new value of {@code requireSsl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireSsl} field changed
     */
    public IosEasEmailProfileConfiguration withRequireSsl(Boolean requireSsl) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requireSsl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.requireSsl = requireSsl;
        return _x;
    }

    /**
     * <i>“Specifies whether the connection should use OAuth for authentication.”</i>
     * 
     * @return property useOAuth
     */
    @Property(name="useOAuth")
    @JsonIgnore
    public Optional<Boolean> getUseOAuth() {
        return Optional.ofNullable(useOAuth);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code useOAuth} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies whether the connection should use OAuth for authentication.”</i>
     * 
     * @param useOAuth
     *            new value of {@code useOAuth} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useOAuth} field changed
     */
    public IosEasEmailProfileConfiguration withUseOAuth(Boolean useOAuth) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("useOAuth");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.useOAuth = useOAuth;
        return _x;
    }

    /**
     * <i>“Signing Certificate type for this Email profile.”</i>
     * 
     * @return property signingCertificateType
     */
    @Property(name="signingCertificateType")
    @JsonIgnore
    public Optional<EmailCertificateType> getSigningCertificateType() {
        return Optional.ofNullable(signingCertificateType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * signingCertificateType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Signing Certificate type for this Email profile.”</i>
     * 
     * @param signingCertificateType
     *            new value of {@code signingCertificateType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code signingCertificateType} field changed
     */
    public IosEasEmailProfileConfiguration withSigningCertificateType(EmailCertificateType signingCertificateType) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("signingCertificateType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.signingCertificateType = signingCertificateType;
        return _x;
    }

    /**
     * <i>“Encryption Certificate type for this Email profile.”</i>
     * 
     * @return property encryptionCertificateType
     */
    @Property(name="encryptionCertificateType")
    @JsonIgnore
    public Optional<EmailCertificateType> getEncryptionCertificateType() {
        return Optional.ofNullable(encryptionCertificateType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * encryptionCertificateType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Encryption Certificate type for this Email profile.”</i>
     * 
     * @param encryptionCertificateType
     *            new value of {@code encryptionCertificateType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionCertificateType} field changed
     */
    public IosEasEmailProfileConfiguration withEncryptionCertificateType(EmailCertificateType encryptionCertificateType) {
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("encryptionCertificateType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEasEmailProfileConfiguration");
        _x.encryptionCertificateType = encryptionCertificateType;
        return _x;
    }

    /**
     * <i>“Identity certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public IosCertificateProfileBaseRequest getIdentityCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    /**
     * <i>“S/MIME signing certificate.”</i>
     * 
     * @return navigational property smimeSigningCertificate
     */
    @NavigationProperty(name="smimeSigningCertificate")
    @JsonIgnore
    public IosCertificateProfileRequest getSmimeSigningCertificate() {
        return new IosCertificateProfileRequest(contextPath.addSegment("smimeSigningCertificate"));
    }

    /**
     * <i>“S/MIME encryption certificate.”</i>
     * 
     * @return navigational property smimeEncryptionCertificate
     */
    @NavigationProperty(name="smimeEncryptionCertificate")
    @JsonIgnore
    public IosCertificateProfileRequest getSmimeEncryptionCertificate() {
        return new IosCertificateProfileRequest(contextPath.addSegment("smimeEncryptionCertificate"));
    }

    /**
     * <i>“Tenant level settings for the Derived Credentials to be used for authentication.”</i>
     * 
     * @return navigational property derivedCredentialSettings
     */
    @NavigationProperty(name="derivedCredentialSettings")
    @JsonIgnore
    public DeviceManagementDerivedCredentialSettingsRequest getDerivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosEasEmailProfileConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosEasEmailProfileConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosEasEmailProfileConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosEasEmailProfileConfiguration _copy() {
        IosEasEmailProfileConfiguration _x = new IosEasEmailProfileConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.usernameSource = usernameSource;
        _x.usernameAADSource = usernameAADSource;
        _x.userDomainNameSource = userDomainNameSource;
        _x.customDomainName = customDomainName;
        _x.accountName = accountName;
        _x.authenticationMethod = authenticationMethod;
        _x.blockMovingMessagesToOtherEmailAccounts = blockMovingMessagesToOtherEmailAccounts;
        _x.blockSendingEmailFromThirdPartyApps = blockSendingEmailFromThirdPartyApps;
        _x.blockSyncingRecentlyUsedEmailAddresses = blockSyncingRecentlyUsedEmailAddresses;
        _x.durationOfEmailToSync = durationOfEmailToSync;
        _x.emailAddressSource = emailAddressSource;
        _x.easServices = easServices;
        _x.easServicesUserOverrideEnabled = easServicesUserOverrideEnabled;
        _x.hostName = hostName;
        _x.requireSmime = requireSmime;
        _x.smimeEnablePerMessageSwitch = smimeEnablePerMessageSwitch;
        _x.smimeEncryptByDefaultEnabled = smimeEncryptByDefaultEnabled;
        _x.smimeSigningEnabled = smimeSigningEnabled;
        _x.smimeSigningUserOverrideEnabled = smimeSigningUserOverrideEnabled;
        _x.smimeEncryptByDefaultUserOverrideEnabled = smimeEncryptByDefaultUserOverrideEnabled;
        _x.smimeSigningCertificateUserOverrideEnabled = smimeSigningCertificateUserOverrideEnabled;
        _x.smimeEncryptionCertificateUserOverrideEnabled = smimeEncryptionCertificateUserOverrideEnabled;
        _x.requireSsl = requireSsl;
        _x.useOAuth = useOAuth;
        _x.signingCertificateType = signingCertificateType;
        _x.encryptionCertificateType = encryptionCertificateType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosEasEmailProfileConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("usernameSource=");
        b.append(this.usernameSource);
        b.append(", ");
        b.append("usernameAADSource=");
        b.append(this.usernameAADSource);
        b.append(", ");
        b.append("userDomainNameSource=");
        b.append(this.userDomainNameSource);
        b.append(", ");
        b.append("customDomainName=");
        b.append(this.customDomainName);
        b.append(", ");
        b.append("accountName=");
        b.append(this.accountName);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("blockMovingMessagesToOtherEmailAccounts=");
        b.append(this.blockMovingMessagesToOtherEmailAccounts);
        b.append(", ");
        b.append("blockSendingEmailFromThirdPartyApps=");
        b.append(this.blockSendingEmailFromThirdPartyApps);
        b.append(", ");
        b.append("blockSyncingRecentlyUsedEmailAddresses=");
        b.append(this.blockSyncingRecentlyUsedEmailAddresses);
        b.append(", ");
        b.append("durationOfEmailToSync=");
        b.append(this.durationOfEmailToSync);
        b.append(", ");
        b.append("emailAddressSource=");
        b.append(this.emailAddressSource);
        b.append(", ");
        b.append("easServices=");
        b.append(this.easServices);
        b.append(", ");
        b.append("easServicesUserOverrideEnabled=");
        b.append(this.easServicesUserOverrideEnabled);
        b.append(", ");
        b.append("hostName=");
        b.append(this.hostName);
        b.append(", ");
        b.append("requireSmime=");
        b.append(this.requireSmime);
        b.append(", ");
        b.append("smimeEnablePerMessageSwitch=");
        b.append(this.smimeEnablePerMessageSwitch);
        b.append(", ");
        b.append("smimeEncryptByDefaultEnabled=");
        b.append(this.smimeEncryptByDefaultEnabled);
        b.append(", ");
        b.append("smimeSigningEnabled=");
        b.append(this.smimeSigningEnabled);
        b.append(", ");
        b.append("smimeSigningUserOverrideEnabled=");
        b.append(this.smimeSigningUserOverrideEnabled);
        b.append(", ");
        b.append("smimeEncryptByDefaultUserOverrideEnabled=");
        b.append(this.smimeEncryptByDefaultUserOverrideEnabled);
        b.append(", ");
        b.append("smimeSigningCertificateUserOverrideEnabled=");
        b.append(this.smimeSigningCertificateUserOverrideEnabled);
        b.append(", ");
        b.append("smimeEncryptionCertificateUserOverrideEnabled=");
        b.append(this.smimeEncryptionCertificateUserOverrideEnabled);
        b.append(", ");
        b.append("requireSsl=");
        b.append(this.requireSsl);
        b.append(", ");
        b.append("useOAuth=");
        b.append(this.useOAuth);
        b.append(", ");
        b.append("signingCertificateType=");
        b.append(this.signingCertificateType);
        b.append(", ");
        b.append("encryptionCertificateType=");
        b.append(this.encryptionCertificateType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
