package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AirPrintDestination;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.IosHomeScreenItem;
import odata.msgraph.client.beta.complex.IosHomeScreenPage;
import odata.msgraph.client.beta.complex.IosNotificationSettings;
import odata.msgraph.client.beta.complex.IosSingleSignOnExtension;
import odata.msgraph.client.beta.complex.IosSingleSignOnSettings;
import odata.msgraph.client.beta.complex.IosWebContentFilterBase;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.SingleSignOnExtension;
import odata.msgraph.client.beta.entity.request.IosCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.IosWallpaperDisplayLocation;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“iOS Device Features Configuration Profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "assetTagTemplate", 
    "contentFilterSettings", 
    "lockScreenFootnote", 
    "homeScreenDockIcons", 
    "homeScreenPages", 
    "notificationSettings", 
    "singleSignOnSettings", 
    "wallpaperDisplayLocation", 
    "wallpaperImage", 
    "singleSignOnExtension", 
    "iosSingleSignOnExtension"})
@JsonInclude(Include.NON_NULL)
public class IosDeviceFeaturesConfiguration extends AppleDeviceFeaturesConfigurationBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosDeviceFeaturesConfiguration";
    }

    @JsonProperty("assetTagTemplate")
    protected String assetTagTemplate;

    @JsonProperty("contentFilterSettings")
    protected IosWebContentFilterBase contentFilterSettings;

    @JsonProperty("lockScreenFootnote")
    protected String lockScreenFootnote;

    @JsonProperty("homeScreenDockIcons")
    protected List<IosHomeScreenItem> homeScreenDockIcons;

    @JsonProperty("homeScreenDockIcons@nextLink")
    protected String homeScreenDockIconsNextLink;

    @JsonProperty("homeScreenPages")
    protected List<IosHomeScreenPage> homeScreenPages;

    @JsonProperty("homeScreenPages@nextLink")
    protected String homeScreenPagesNextLink;

    @JsonProperty("notificationSettings")
    protected List<IosNotificationSettings> notificationSettings;

    @JsonProperty("notificationSettings@nextLink")
    protected String notificationSettingsNextLink;

    @JsonProperty("singleSignOnSettings")
    protected IosSingleSignOnSettings singleSignOnSettings;

    @JsonProperty("wallpaperDisplayLocation")
    protected IosWallpaperDisplayLocation wallpaperDisplayLocation;

    @JsonProperty("wallpaperImage")
    protected MimeContent wallpaperImage;

    @JsonProperty("singleSignOnExtension")
    protected SingleSignOnExtension singleSignOnExtension;

    @JsonProperty("iosSingleSignOnExtension")
    protected IosSingleSignOnExtension iosSingleSignOnExtension;

    protected IosDeviceFeaturesConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosDeviceFeaturesConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private List<AirPrintDestination> airPrintDestinations;
        private String airPrintDestinationsNextLink;
        private String assetTagTemplate;
        private IosWebContentFilterBase contentFilterSettings;
        private String lockScreenFootnote;
        private List<IosHomeScreenItem> homeScreenDockIcons;
        private String homeScreenDockIconsNextLink;
        private List<IosHomeScreenPage> homeScreenPages;
        private String homeScreenPagesNextLink;
        private List<IosNotificationSettings> notificationSettings;
        private String notificationSettingsNextLink;
        private IosSingleSignOnSettings singleSignOnSettings;
        private IosWallpaperDisplayLocation wallpaperDisplayLocation;
        private MimeContent wallpaperImage;
        private SingleSignOnExtension singleSignOnExtension;
        private IosSingleSignOnExtension iosSingleSignOnExtension;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder airPrintDestinations(List<AirPrintDestination> airPrintDestinations) {
            this.airPrintDestinations = airPrintDestinations;
            this.changedFields = changedFields.add("airPrintDestinations");
            return this;
        }

        public Builder airPrintDestinations(AirPrintDestination... airPrintDestinations) {
            return airPrintDestinations(Arrays.asList(airPrintDestinations));
        }

        public Builder airPrintDestinationsNextLink(String airPrintDestinationsNextLink) {
            this.airPrintDestinationsNextLink = airPrintDestinationsNextLink;
            this.changedFields = changedFields.add("airPrintDestinations");
            return this;
        }

        /**
         * <i>“Asset tag information for the device, displayed on the login window and lock
         * screen.”</i>
         * 
         * @param assetTagTemplate
         *            value of {@code assetTagTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assetTagTemplate(String assetTagTemplate) {
            this.assetTagTemplate = assetTagTemplate;
            this.changedFields = changedFields.add("assetTagTemplate");
            return this;
        }

        /**
         * <i>“Gets or sets iOS Web Content Filter settings, supervised mode only”</i>
         * 
         * @param contentFilterSettings
         *            value of {@code contentFilterSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentFilterSettings(IosWebContentFilterBase contentFilterSettings) {
            this.contentFilterSettings = contentFilterSettings;
            this.changedFields = changedFields.add("contentFilterSettings");
            return this;
        }

        /**
         * <i>“A footnote displayed on the login window and lock screen. Available in iOS 9.3.1
         * and later.”</i>
         * 
         * @param lockScreenFootnote
         *            value of {@code lockScreenFootnote} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenFootnote(String lockScreenFootnote) {
            this.lockScreenFootnote = lockScreenFootnote;
            this.changedFields = changedFields.add("lockScreenFootnote");
            return this;
        }

        /**
         * <i>“A list of app and folders to appear on the Home Screen Dock. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param homeScreenDockIcons
         *            value of {@code homeScreenDockIcons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeScreenDockIcons(List<IosHomeScreenItem> homeScreenDockIcons) {
            this.homeScreenDockIcons = homeScreenDockIcons;
            this.changedFields = changedFields.add("homeScreenDockIcons");
            return this;
        }

        /**
         * <i>“A list of app and folders to appear on the Home Screen Dock. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param homeScreenDockIcons
         *            value of {@code homeScreenDockIcons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeScreenDockIcons(IosHomeScreenItem... homeScreenDockIcons) {
            return homeScreenDockIcons(Arrays.asList(homeScreenDockIcons));
        }

        /**
         * <i>“A list of app and folders to appear on the Home Screen Dock. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param homeScreenDockIconsNextLink
         *            value of {@code homeScreenDockIcons@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeScreenDockIconsNextLink(String homeScreenDockIconsNextLink) {
            this.homeScreenDockIconsNextLink = homeScreenDockIconsNextLink;
            this.changedFields = changedFields.add("homeScreenDockIcons");
            return this;
        }

        /**
         * <i>“A list of pages on the Home Screen. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param homeScreenPages
         *            value of {@code homeScreenPages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeScreenPages(List<IosHomeScreenPage> homeScreenPages) {
            this.homeScreenPages = homeScreenPages;
            this.changedFields = changedFields.add("homeScreenPages");
            return this;
        }

        /**
         * <i>“A list of pages on the Home Screen. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param homeScreenPages
         *            value of {@code homeScreenPages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeScreenPages(IosHomeScreenPage... homeScreenPages) {
            return homeScreenPages(Arrays.asList(homeScreenPages));
        }

        /**
         * <i>“A list of pages on the Home Screen. This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param homeScreenPagesNextLink
         *            value of {@code homeScreenPages@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder homeScreenPagesNextLink(String homeScreenPagesNextLink) {
            this.homeScreenPagesNextLink = homeScreenPagesNextLink;
            this.changedFields = changedFields.add("homeScreenPages");
            return this;
        }

        /**
         * <i>“Notification settings for each bundle id. Applicable to devices in supervised
         * mode only (iOS 9.3 and later). This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param notificationSettings
         *            value of {@code notificationSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationSettings(List<IosNotificationSettings> notificationSettings) {
            this.notificationSettings = notificationSettings;
            this.changedFields = changedFields.add("notificationSettings");
            return this;
        }

        /**
         * <i>“Notification settings for each bundle id. Applicable to devices in supervised
         * mode only (iOS 9.3 and later). This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param notificationSettings
         *            value of {@code notificationSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationSettings(IosNotificationSettings... notificationSettings) {
            return notificationSettings(Arrays.asList(notificationSettings));
        }

        /**
         * <i>“Notification settings for each bundle id. Applicable to devices in supervised
         * mode only (iOS 9.3 and later). This collection can contain a maximum of 500
         * elements.”</i>
         * 
         * @param notificationSettingsNextLink
         *            value of {@code notificationSettings@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationSettingsNextLink(String notificationSettingsNextLink) {
            this.notificationSettingsNextLink = notificationSettingsNextLink;
            this.changedFields = changedFields.add("notificationSettings");
            return this;
        }

        /**
         * <i>“The Kerberos login settings that enable apps on receiving devices to
         * authenticate smoothly.”</i>
         * 
         * @param singleSignOnSettings
         *            value of {@code singleSignOnSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder singleSignOnSettings(IosSingleSignOnSettings singleSignOnSettings) {
            this.singleSignOnSettings = singleSignOnSettings;
            this.changedFields = changedFields.add("singleSignOnSettings");
            return this;
        }

        /**
         * <i>“A wallpaper display location specifier.”</i>
         * 
         * @param wallpaperDisplayLocation
         *            value of {@code wallpaperDisplayLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wallpaperDisplayLocation(IosWallpaperDisplayLocation wallpaperDisplayLocation) {
            this.wallpaperDisplayLocation = wallpaperDisplayLocation;
            this.changedFields = changedFields.add("wallpaperDisplayLocation");
            return this;
        }

        /**
         * <i>“A wallpaper image must be in either PNG or JPEG format. It requires a supervised
         * device with iOS 8 or later version.”</i>
         * 
         * @param wallpaperImage
         *            value of {@code wallpaperImage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wallpaperImage(MimeContent wallpaperImage) {
            this.wallpaperImage = wallpaperImage;
            this.changedFields = changedFields.add("wallpaperImage");
            return this;
        }

        /**
         * <i>“Gets or sets a single sign-on extension profile. Deprecated: use
         * IOSSingleSignOnExtension instead.”</i>
         * 
         * @param singleSignOnExtension
         *            value of {@code singleSignOnExtension} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder singleSignOnExtension(SingleSignOnExtension singleSignOnExtension) {
            this.singleSignOnExtension = singleSignOnExtension;
            this.changedFields = changedFields.add("singleSignOnExtension");
            return this;
        }

        /**
         * <i>“Gets or sets a single sign-on extension profile.”</i>
         * 
         * @param iosSingleSignOnExtension
         *            value of {@code iosSingleSignOnExtension} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosSingleSignOnExtension(IosSingleSignOnExtension iosSingleSignOnExtension) {
            this.iosSingleSignOnExtension = iosSingleSignOnExtension;
            this.changedFields = changedFields.add("iosSingleSignOnExtension");
            return this;
        }

        public IosDeviceFeaturesConfiguration build() {
            IosDeviceFeaturesConfiguration _x = new IosDeviceFeaturesConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosDeviceFeaturesConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.airPrintDestinations = airPrintDestinations;
            _x.airPrintDestinationsNextLink = airPrintDestinationsNextLink;
            _x.assetTagTemplate = assetTagTemplate;
            _x.contentFilterSettings = contentFilterSettings;
            _x.lockScreenFootnote = lockScreenFootnote;
            _x.homeScreenDockIcons = homeScreenDockIcons;
            _x.homeScreenDockIconsNextLink = homeScreenDockIconsNextLink;
            _x.homeScreenPages = homeScreenPages;
            _x.homeScreenPagesNextLink = homeScreenPagesNextLink;
            _x.notificationSettings = notificationSettings;
            _x.notificationSettingsNextLink = notificationSettingsNextLink;
            _x.singleSignOnSettings = singleSignOnSettings;
            _x.wallpaperDisplayLocation = wallpaperDisplayLocation;
            _x.wallpaperImage = wallpaperImage;
            _x.singleSignOnExtension = singleSignOnExtension;
            _x.iosSingleSignOnExtension = iosSingleSignOnExtension;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Asset tag information for the device, displayed on the login window and lock
     * screen.”</i>
     * 
     * @return property assetTagTemplate
     */
    @Property(name="assetTagTemplate")
    @JsonIgnore
    public Optional<String> getAssetTagTemplate() {
        return Optional.ofNullable(assetTagTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assetTagTemplate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Asset tag information for the device, displayed on the login window and lock
     * screen.”</i>
     * 
     * @param assetTagTemplate
     *            new value of {@code assetTagTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assetTagTemplate} field changed
     */
    public IosDeviceFeaturesConfiguration withAssetTagTemplate(String assetTagTemplate) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("assetTagTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.assetTagTemplate = assetTagTemplate;
        return _x;
    }

    /**
     * <i>“Gets or sets iOS Web Content Filter settings, supervised mode only”</i>
     * 
     * @return property contentFilterSettings
     */
    @Property(name="contentFilterSettings")
    @JsonIgnore
    public Optional<IosWebContentFilterBase> getContentFilterSettings() {
        return Optional.ofNullable(contentFilterSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contentFilterSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets iOS Web Content Filter settings, supervised mode only”</i>
     * 
     * @param contentFilterSettings
     *            new value of {@code contentFilterSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentFilterSettings} field changed
     */
    public IosDeviceFeaturesConfiguration withContentFilterSettings(IosWebContentFilterBase contentFilterSettings) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("contentFilterSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.contentFilterSettings = contentFilterSettings;
        return _x;
    }

    /**
     * <i>“A footnote displayed on the login window and lock screen. Available in iOS 9.3.1
     * and later.”</i>
     * 
     * @return property lockScreenFootnote
     */
    @Property(name="lockScreenFootnote")
    @JsonIgnore
    public Optional<String> getLockScreenFootnote() {
        return Optional.ofNullable(lockScreenFootnote);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenFootnote} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A footnote displayed on the login window and lock screen. Available in iOS 9.3.1
     * and later.”</i>
     * 
     * @param lockScreenFootnote
     *            new value of {@code lockScreenFootnote} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenFootnote} field changed
     */
    public IosDeviceFeaturesConfiguration withLockScreenFootnote(String lockScreenFootnote) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenFootnote");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.lockScreenFootnote = lockScreenFootnote;
        return _x;
    }

    /**
     * <i>“A list of app and folders to appear on the Home Screen Dock. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property homeScreenDockIcons
     */
    @Property(name="homeScreenDockIcons")
    @JsonIgnore
    public CollectionPage<IosHomeScreenItem> getHomeScreenDockIcons() {
        return new CollectionPage<IosHomeScreenItem>(contextPath, IosHomeScreenItem.class, homeScreenDockIcons, Optional.ofNullable(homeScreenDockIconsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of app and folders to appear on the Home Screen Dock. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property homeScreenDockIcons
     */
    @Property(name="homeScreenDockIcons")
    @JsonIgnore
    public CollectionPage<IosHomeScreenItem> getHomeScreenDockIcons(HttpRequestOptions options) {
        return new CollectionPage<IosHomeScreenItem>(contextPath, IosHomeScreenItem.class, homeScreenDockIcons, Optional.ofNullable(homeScreenDockIconsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“A list of pages on the Home Screen. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property homeScreenPages
     */
    @Property(name="homeScreenPages")
    @JsonIgnore
    public CollectionPage<IosHomeScreenPage> getHomeScreenPages() {
        return new CollectionPage<IosHomeScreenPage>(contextPath, IosHomeScreenPage.class, homeScreenPages, Optional.ofNullable(homeScreenPagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of pages on the Home Screen. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property homeScreenPages
     */
    @Property(name="homeScreenPages")
    @JsonIgnore
    public CollectionPage<IosHomeScreenPage> getHomeScreenPages(HttpRequestOptions options) {
        return new CollectionPage<IosHomeScreenPage>(contextPath, IosHomeScreenPage.class, homeScreenPages, Optional.ofNullable(homeScreenPagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Notification settings for each bundle id. Applicable to devices in supervised
     * mode only (iOS 9.3 and later). This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property notificationSettings
     */
    @Property(name="notificationSettings")
    @JsonIgnore
    public CollectionPage<IosNotificationSettings> getNotificationSettings() {
        return new CollectionPage<IosNotificationSettings>(contextPath, IosNotificationSettings.class, notificationSettings, Optional.ofNullable(notificationSettingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Notification settings for each bundle id. Applicable to devices in supervised
     * mode only (iOS 9.3 and later). This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property notificationSettings
     */
    @Property(name="notificationSettings")
    @JsonIgnore
    public CollectionPage<IosNotificationSettings> getNotificationSettings(HttpRequestOptions options) {
        return new CollectionPage<IosNotificationSettings>(contextPath, IosNotificationSettings.class, notificationSettings, Optional.ofNullable(notificationSettingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The Kerberos login settings that enable apps on receiving devices to
     * authenticate smoothly.”</i>
     * 
     * @return property singleSignOnSettings
     */
    @Property(name="singleSignOnSettings")
    @JsonIgnore
    public Optional<IosSingleSignOnSettings> getSingleSignOnSettings() {
        return Optional.ofNullable(singleSignOnSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * singleSignOnSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Kerberos login settings that enable apps on receiving devices to
     * authenticate smoothly.”</i>
     * 
     * @param singleSignOnSettings
     *            new value of {@code singleSignOnSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code singleSignOnSettings} field changed
     */
    public IosDeviceFeaturesConfiguration withSingleSignOnSettings(IosSingleSignOnSettings singleSignOnSettings) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("singleSignOnSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.singleSignOnSettings = singleSignOnSettings;
        return _x;
    }

    /**
     * <i>“A wallpaper display location specifier.”</i>
     * 
     * @return property wallpaperDisplayLocation
     */
    @Property(name="wallpaperDisplayLocation")
    @JsonIgnore
    public Optional<IosWallpaperDisplayLocation> getWallpaperDisplayLocation() {
        return Optional.ofNullable(wallpaperDisplayLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wallpaperDisplayLocation} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A wallpaper display location specifier.”</i>
     * 
     * @param wallpaperDisplayLocation
     *            new value of {@code wallpaperDisplayLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wallpaperDisplayLocation} field changed
     */
    public IosDeviceFeaturesConfiguration withWallpaperDisplayLocation(IosWallpaperDisplayLocation wallpaperDisplayLocation) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wallpaperDisplayLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.wallpaperDisplayLocation = wallpaperDisplayLocation;
        return _x;
    }

    /**
     * <i>“A wallpaper image must be in either PNG or JPEG format. It requires a supervised
     * device with iOS 8 or later version.”</i>
     * 
     * @return property wallpaperImage
     */
    @Property(name="wallpaperImage")
    @JsonIgnore
    public Optional<MimeContent> getWallpaperImage() {
        return Optional.ofNullable(wallpaperImage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wallpaperImage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A wallpaper image must be in either PNG or JPEG format. It requires a supervised
     * device with iOS 8 or later version.”</i>
     * 
     * @param wallpaperImage
     *            new value of {@code wallpaperImage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wallpaperImage} field changed
     */
    public IosDeviceFeaturesConfiguration withWallpaperImage(MimeContent wallpaperImage) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wallpaperImage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.wallpaperImage = wallpaperImage;
        return _x;
    }

    /**
     * <i>“Gets or sets a single sign-on extension profile. Deprecated: use
     * IOSSingleSignOnExtension instead.”</i>
     * 
     * @return property singleSignOnExtension
     */
    @Property(name="singleSignOnExtension")
    @JsonIgnore
    public Optional<SingleSignOnExtension> getSingleSignOnExtension() {
        return Optional.ofNullable(singleSignOnExtension);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * singleSignOnExtension} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a single sign-on extension profile. Deprecated: use
     * IOSSingleSignOnExtension instead.”</i>
     * 
     * @param singleSignOnExtension
     *            new value of {@code singleSignOnExtension} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code singleSignOnExtension} field changed
     */
    public IosDeviceFeaturesConfiguration withSingleSignOnExtension(SingleSignOnExtension singleSignOnExtension) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("singleSignOnExtension");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.singleSignOnExtension = singleSignOnExtension;
        return _x;
    }

    /**
     * <i>“Gets or sets a single sign-on extension profile.”</i>
     * 
     * @return property iosSingleSignOnExtension
     */
    @Property(name="iosSingleSignOnExtension")
    @JsonIgnore
    public Optional<IosSingleSignOnExtension> getIosSingleSignOnExtension() {
        return Optional.ofNullable(iosSingleSignOnExtension);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iosSingleSignOnExtension} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a single sign-on extension profile.”</i>
     * 
     * @param iosSingleSignOnExtension
     *            new value of {@code iosSingleSignOnExtension} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosSingleSignOnExtension} field changed
     */
    public IosDeviceFeaturesConfiguration withIosSingleSignOnExtension(IosSingleSignOnExtension iosSingleSignOnExtension) {
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = changedFields.add("iosSingleSignOnExtension");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceFeaturesConfiguration");
        _x.iosSingleSignOnExtension = iosSingleSignOnExtension;
        return _x;
    }

    /**
     * <i>“Identity Certificate for the renewal of Kerberos ticket used in single sign-on
     * settings.”</i>
     * 
     * @return navigational property identityCertificateForClientAuthentication
     */
    @NavigationProperty(name="identityCertificateForClientAuthentication")
    @JsonIgnore
    public IosCertificateProfileBaseRequest getIdentityCertificateForClientAuthentication() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    /**
     * <i>“PKINIT Certificate for the authentication with single sign-on extension settings
     * .”</i>
     * 
     * @return navigational property singleSignOnExtensionPkinitCertificate
     */
    @NavigationProperty(name="singleSignOnExtensionPkinitCertificate")
    @JsonIgnore
    public IosCertificateProfileBaseRequest getSingleSignOnExtensionPkinitCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("singleSignOnExtensionPkinitCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosDeviceFeaturesConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosDeviceFeaturesConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosDeviceFeaturesConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosDeviceFeaturesConfiguration _copy() {
        IosDeviceFeaturesConfiguration _x = new IosDeviceFeaturesConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.airPrintDestinations = airPrintDestinations;
        _x.assetTagTemplate = assetTagTemplate;
        _x.contentFilterSettings = contentFilterSettings;
        _x.lockScreenFootnote = lockScreenFootnote;
        _x.homeScreenDockIcons = homeScreenDockIcons;
        _x.homeScreenPages = homeScreenPages;
        _x.notificationSettings = notificationSettings;
        _x.singleSignOnSettings = singleSignOnSettings;
        _x.wallpaperDisplayLocation = wallpaperDisplayLocation;
        _x.wallpaperImage = wallpaperImage;
        _x.singleSignOnExtension = singleSignOnExtension;
        _x.iosSingleSignOnExtension = iosSingleSignOnExtension;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosDeviceFeaturesConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("airPrintDestinations=");
        b.append(this.airPrintDestinations);
        b.append(", ");
        b.append("assetTagTemplate=");
        b.append(this.assetTagTemplate);
        b.append(", ");
        b.append("contentFilterSettings=");
        b.append(this.contentFilterSettings);
        b.append(", ");
        b.append("lockScreenFootnote=");
        b.append(this.lockScreenFootnote);
        b.append(", ");
        b.append("homeScreenDockIcons=");
        b.append(this.homeScreenDockIcons);
        b.append(", ");
        b.append("homeScreenPages=");
        b.append(this.homeScreenPages);
        b.append(", ");
        b.append("notificationSettings=");
        b.append(this.notificationSettings);
        b.append(", ");
        b.append("singleSignOnSettings=");
        b.append(this.singleSignOnSettings);
        b.append(", ");
        b.append("wallpaperDisplayLocation=");
        b.append(this.wallpaperDisplayLocation);
        b.append(", ");
        b.append("wallpaperImage=");
        b.append(this.wallpaperImage);
        b.append(", ");
        b.append("singleSignOnExtension=");
        b.append(this.singleSignOnExtension);
        b.append(", ");
        b.append("iosSingleSignOnExtension=");
        b.append(this.iosSingleSignOnExtension);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
