package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.enums.DeviceThreatProtectionLevel;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This class contains compliance settings for IOS.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "passcodeBlockSimple", 
    "passcodeExpirationDays", 
    "passcodeMinimumLength", 
    "passcodeMinutesOfInactivityBeforeLock", 
    "passcodeMinutesOfInactivityBeforeScreenTimeout", 
    "passcodePreviousPasscodeBlockCount", 
    "passcodeMinimumCharacterSetCount", 
    "passcodeRequiredType", 
    "passcodeRequired", 
    "osMinimumVersion", 
    "osMaximumVersion", 
    "osMinimumBuildVersion", 
    "osMaximumBuildVersion", 
    "securityBlockJailbrokenDevices", 
    "deviceThreatProtectionEnabled", 
    "deviceThreatProtectionRequiredSecurityLevel", 
    "managedEmailProfileRequired", 
    "restrictedApps"})
@JsonInclude(Include.NON_NULL)
public class IosCompliancePolicy extends DeviceCompliancePolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosCompliancePolicy";
    }

    @JsonProperty("passcodeBlockSimple")
    protected Boolean passcodeBlockSimple;

    @JsonProperty("passcodeExpirationDays")
    protected Integer passcodeExpirationDays;

    @JsonProperty("passcodeMinimumLength")
    protected Integer passcodeMinimumLength;

    @JsonProperty("passcodeMinutesOfInactivityBeforeLock")
    protected Integer passcodeMinutesOfInactivityBeforeLock;

    @JsonProperty("passcodeMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passcodeMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passcodePreviousPasscodeBlockCount")
    protected Integer passcodePreviousPasscodeBlockCount;

    @JsonProperty("passcodeMinimumCharacterSetCount")
    protected Integer passcodeMinimumCharacterSetCount;

    @JsonProperty("passcodeRequiredType")
    protected RequiredPasswordType passcodeRequiredType;

    @JsonProperty("passcodeRequired")
    protected Boolean passcodeRequired;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("osMinimumBuildVersion")
    protected String osMinimumBuildVersion;

    @JsonProperty("osMaximumBuildVersion")
    protected String osMaximumBuildVersion;

    @JsonProperty("securityBlockJailbrokenDevices")
    protected Boolean securityBlockJailbrokenDevices;

    @JsonProperty("deviceThreatProtectionEnabled")
    protected Boolean deviceThreatProtectionEnabled;

    @JsonProperty("deviceThreatProtectionRequiredSecurityLevel")
    protected DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel;

    @JsonProperty("managedEmailProfileRequired")
    protected Boolean managedEmailProfileRequired;

    @JsonProperty("restrictedApps")
    protected List<AppListItem> restrictedApps;

    @JsonProperty("restrictedApps@nextLink")
    protected String restrictedAppsNextLink;

    protected IosCompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosCompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private OffsetDateTime lastModifiedDateTime;
        private String displayName;
        private Integer version;
        private Boolean passcodeBlockSimple;
        private Integer passcodeExpirationDays;
        private Integer passcodeMinimumLength;
        private Integer passcodeMinutesOfInactivityBeforeLock;
        private Integer passcodeMinutesOfInactivityBeforeScreenTimeout;
        private Integer passcodePreviousPasscodeBlockCount;
        private Integer passcodeMinimumCharacterSetCount;
        private RequiredPasswordType passcodeRequiredType;
        private Boolean passcodeRequired;
        private String osMinimumVersion;
        private String osMaximumVersion;
        private String osMinimumBuildVersion;
        private String osMaximumBuildVersion;
        private Boolean securityBlockJailbrokenDevices;
        private Boolean deviceThreatProtectionEnabled;
        private DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel;
        private Boolean managedEmailProfileRequired;
        private List<AppListItem> restrictedApps;
        private String restrictedAppsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block simple passcodes.”</i>
         * 
         * @param passcodeBlockSimple
         *            value of {@code passcodeBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeBlockSimple(Boolean passcodeBlockSimple) {
            this.passcodeBlockSimple = passcodeBlockSimple;
            this.changedFields = changedFields.add("passcodeBlockSimple");
            return this;
        }

        /**
         * <i>“Number of days before the passcode expires. Valid values 1 to 65535”</i>
         * 
         * @param passcodeExpirationDays
         *            value of {@code passcodeExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeExpirationDays(Integer passcodeExpirationDays) {
            this.passcodeExpirationDays = passcodeExpirationDays;
            this.changedFields = changedFields.add("passcodeExpirationDays");
            return this;
        }

        /**
         * <i>“Minimum length of passcode. Valid values 4 to 14”</i>
         * 
         * @param passcodeMinimumLength
         *            value of {@code passcodeMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinimumLength(Integer passcodeMinimumLength) {
            this.passcodeMinimumLength = passcodeMinimumLength;
            this.changedFields = changedFields.add("passcodeMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a passcode is required.”</i>
         * 
         * @param passcodeMinutesOfInactivityBeforeLock
         *            value of {@code passcodeMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinutesOfInactivityBeforeLock(Integer passcodeMinutesOfInactivityBeforeLock) {
            this.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before the screen times out.”</i>
         * 
         * @param passcodeMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passcodeMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinutesOfInactivityBeforeScreenTimeout(Integer passcodeMinutesOfInactivityBeforeScreenTimeout) {
            this.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Number of previous passcodes to block. Valid values 1 to 24”</i>
         * 
         * @param passcodePreviousPasscodeBlockCount
         *            value of {@code passcodePreviousPasscodeBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodePreviousPasscodeBlockCount(Integer passcodePreviousPasscodeBlockCount) {
            this.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
            this.changedFields = changedFields.add("passcodePreviousPasscodeBlockCount");
            return this;
        }

        /**
         * <i>“The number of character sets required in the password.”</i>
         * 
         * @param passcodeMinimumCharacterSetCount
         *            value of {@code passcodeMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeMinimumCharacterSetCount(Integer passcodeMinimumCharacterSetCount) {
            this.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passcodeMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“The required passcode type.”</i>
         * 
         * @param passcodeRequiredType
         *            value of {@code passcodeRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeRequiredType(RequiredPasswordType passcodeRequiredType) {
            this.passcodeRequiredType = passcodeRequiredType;
            this.changedFields = changedFields.add("passcodeRequiredType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a passcode.”</i>
         * 
         * @param passcodeRequired
         *            value of {@code passcodeRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcodeRequired(Boolean passcodeRequired) {
            this.passcodeRequired = passcodeRequired;
            this.changedFields = changedFields.add("passcodeRequired");
            return this;
        }

        /**
         * <i>“Minimum IOS version.”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Maximum IOS version.”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Minimum IOS build version.”</i>
         * 
         * @param osMinimumBuildVersion
         *            value of {@code osMinimumBuildVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumBuildVersion(String osMinimumBuildVersion) {
            this.osMinimumBuildVersion = osMinimumBuildVersion;
            this.changedFields = changedFields.add("osMinimumBuildVersion");
            return this;
        }

        /**
         * <i>“Maximum IOS build version.”</i>
         * 
         * @param osMaximumBuildVersion
         *            value of {@code osMaximumBuildVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumBuildVersion(String osMaximumBuildVersion) {
            this.osMaximumBuildVersion = osMaximumBuildVersion;
            this.changedFields = changedFields.add("osMaximumBuildVersion");
            return this;
        }

        /**
         * <i>“Devices must not be jailbroken or rooted.”</i>
         * 
         * @param securityBlockJailbrokenDevices
         *            value of {@code securityBlockJailbrokenDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityBlockJailbrokenDevices(Boolean securityBlockJailbrokenDevices) {
            this.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
            this.changedFields = changedFields.add("securityBlockJailbrokenDevices");
            return this;
        }

        /**
         * <i>“Require that devices have enabled device threat protection .”</i>
         * 
         * @param deviceThreatProtectionEnabled
         *            value of {@code deviceThreatProtectionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceThreatProtectionEnabled(Boolean deviceThreatProtectionEnabled) {
            this.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
            this.changedFields = changedFields.add("deviceThreatProtectionEnabled");
            return this;
        }

        /**
         * <i>“Require Mobile Threat Protection minimum risk level to report noncompliance.”</i>
         * 
         * @param deviceThreatProtectionRequiredSecurityLevel
         *            value of {@code deviceThreatProtectionRequiredSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel) {
            this.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
            this.changedFields = changedFields.add("deviceThreatProtectionRequiredSecurityLevel");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a managed email profile.”</i>
         * 
         * @param managedEmailProfileRequired
         *            value of {@code managedEmailProfileRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedEmailProfileRequired(Boolean managedEmailProfileRequired) {
            this.managedEmailProfileRequired = managedEmailProfileRequired;
            this.changedFields = changedFields.add("managedEmailProfileRequired");
            return this;
        }

        /**
         * <i>“Require the device to not have the specified apps installed. This collection can
         * contain a maximum of 100 elements.”</i>
         * 
         * @param restrictedApps
         *            value of {@code restrictedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedApps(List<AppListItem> restrictedApps) {
            this.restrictedApps = restrictedApps;
            this.changedFields = changedFields.add("restrictedApps");
            return this;
        }

        /**
         * <i>“Require the device to not have the specified apps installed. This collection can
         * contain a maximum of 100 elements.”</i>
         * 
         * @param restrictedApps
         *            value of {@code restrictedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedApps(AppListItem... restrictedApps) {
            return restrictedApps(Arrays.asList(restrictedApps));
        }

        /**
         * <i>“Require the device to not have the specified apps installed. This collection can
         * contain a maximum of 100 elements.”</i>
         * 
         * @param restrictedAppsNextLink
         *            value of {@code restrictedApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictedAppsNextLink(String restrictedAppsNextLink) {
            this.restrictedAppsNextLink = restrictedAppsNextLink;
            this.changedFields = changedFields.add("restrictedApps");
            return this;
        }

        public IosCompliancePolicy build() {
            IosCompliancePolicy _x = new IosCompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosCompliancePolicy";
            _x.id = id;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.displayName = displayName;
            _x.version = version;
            _x.passcodeBlockSimple = passcodeBlockSimple;
            _x.passcodeExpirationDays = passcodeExpirationDays;
            _x.passcodeMinimumLength = passcodeMinimumLength;
            _x.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
            _x.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
            _x.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
            _x.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
            _x.passcodeRequiredType = passcodeRequiredType;
            _x.passcodeRequired = passcodeRequired;
            _x.osMinimumVersion = osMinimumVersion;
            _x.osMaximumVersion = osMaximumVersion;
            _x.osMinimumBuildVersion = osMinimumBuildVersion;
            _x.osMaximumBuildVersion = osMaximumBuildVersion;
            _x.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
            _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
            _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
            _x.managedEmailProfileRequired = managedEmailProfileRequired;
            _x.restrictedApps = restrictedApps;
            _x.restrictedAppsNextLink = restrictedAppsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates whether or not to block simple passcodes.”</i>
     * 
     * @return property passcodeBlockSimple
     */
    @Property(name="passcodeBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasscodeBlockSimple() {
        return Optional.ofNullable(passcodeBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block simple passcodes.”</i>
     * 
     * @param passcodeBlockSimple
     *            new value of {@code passcodeBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeBlockSimple} field changed
     */
    public IosCompliancePolicy withPasscodeBlockSimple(Boolean passcodeBlockSimple) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeBlockSimple = passcodeBlockSimple;
        return _x;
    }

    /**
     * <i>“Number of days before the passcode expires. Valid values 1 to 65535”</i>
     * 
     * @return property passcodeExpirationDays
     */
    @Property(name="passcodeExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasscodeExpirationDays() {
        return Optional.ofNullable(passcodeExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before the passcode expires. Valid values 1 to 65535”</i>
     * 
     * @param passcodeExpirationDays
     *            new value of {@code passcodeExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeExpirationDays} field changed
     */
    public IosCompliancePolicy withPasscodeExpirationDays(Integer passcodeExpirationDays) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeExpirationDays = passcodeExpirationDays;
        return _x;
    }

    /**
     * <i>“Minimum length of passcode. Valid values 4 to 14”</i>
     * 
     * @return property passcodeMinimumLength
     */
    @Property(name="passcodeMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinimumLength() {
        return Optional.ofNullable(passcodeMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum length of passcode. Valid values 4 to 14”</i>
     * 
     * @param passcodeMinimumLength
     *            new value of {@code passcodeMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinimumLength} field changed
     */
    public IosCompliancePolicy withPasscodeMinimumLength(Integer passcodeMinimumLength) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeMinimumLength = passcodeMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a passcode is required.”</i>
     * 
     * @return property passcodeMinutesOfInactivityBeforeLock
     */
    @Property(name="passcodeMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passcodeMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a passcode is required.”</i>
     * 
     * @param passcodeMinutesOfInactivityBeforeLock
     *            new value of {@code passcodeMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinutesOfInactivityBeforeLock} field changed
     */
    public IosCompliancePolicy withPasscodeMinutesOfInactivityBeforeLock(Integer passcodeMinutesOfInactivityBeforeLock) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @return property passcodeMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passcodeMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passcodeMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @param passcodeMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passcodeMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public IosCompliancePolicy withPasscodeMinutesOfInactivityBeforeScreenTimeout(Integer passcodeMinutesOfInactivityBeforeScreenTimeout) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Number of previous passcodes to block. Valid values 1 to 24”</i>
     * 
     * @return property passcodePreviousPasscodeBlockCount
     */
    @Property(name="passcodePreviousPasscodeBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasscodePreviousPasscodeBlockCount() {
        return Optional.ofNullable(passcodePreviousPasscodeBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodePreviousPasscodeBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of previous passcodes to block. Valid values 1 to 24”</i>
     * 
     * @param passcodePreviousPasscodeBlockCount
     *            new value of {@code passcodePreviousPasscodeBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodePreviousPasscodeBlockCount} field changed
     */
    public IosCompliancePolicy withPasscodePreviousPasscodeBlockCount(Integer passcodePreviousPasscodeBlockCount) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodePreviousPasscodeBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
        return _x;
    }

    /**
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @return property passcodeMinimumCharacterSetCount
     */
    @Property(name="passcodeMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasscodeMinimumCharacterSetCount() {
        return Optional.ofNullable(passcodeMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @param passcodeMinimumCharacterSetCount
     *            new value of {@code passcodeMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeMinimumCharacterSetCount} field changed
     */
    public IosCompliancePolicy withPasscodeMinimumCharacterSetCount(Integer passcodeMinimumCharacterSetCount) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“The required passcode type.”</i>
     * 
     * @return property passcodeRequiredType
     */
    @Property(name="passcodeRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasscodeRequiredType() {
        return Optional.ofNullable(passcodeRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passcodeRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The required passcode type.”</i>
     * 
     * @param passcodeRequiredType
     *            new value of {@code passcodeRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeRequiredType} field changed
     */
    public IosCompliancePolicy withPasscodeRequiredType(RequiredPasswordType passcodeRequiredType) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeRequiredType = passcodeRequiredType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a passcode.”</i>
     * 
     * @return property passcodeRequired
     */
    @Property(name="passcodeRequired")
    @JsonIgnore
    public Optional<Boolean> getPasscodeRequired() {
        return Optional.ofNullable(passcodeRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passcodeRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to require a passcode.”</i>
     * 
     * @param passcodeRequired
     *            new value of {@code passcodeRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcodeRequired} field changed
     */
    public IosCompliancePolicy withPasscodeRequired(Boolean passcodeRequired) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passcodeRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.passcodeRequired = passcodeRequired;
        return _x;
    }

    /**
     * <i>“Minimum IOS version.”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum IOS version.”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public IosCompliancePolicy withOsMinimumVersion(String osMinimumVersion) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Maximum IOS version.”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum IOS version.”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public IosCompliancePolicy withOsMaximumVersion(String osMaximumVersion) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Minimum IOS build version.”</i>
     * 
     * @return property osMinimumBuildVersion
     */
    @Property(name="osMinimumBuildVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumBuildVersion() {
        return Optional.ofNullable(osMinimumBuildVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * osMinimumBuildVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum IOS build version.”</i>
     * 
     * @param osMinimumBuildVersion
     *            new value of {@code osMinimumBuildVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumBuildVersion} field changed
     */
    public IosCompliancePolicy withOsMinimumBuildVersion(String osMinimumBuildVersion) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumBuildVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.osMinimumBuildVersion = osMinimumBuildVersion;
        return _x;
    }

    /**
     * <i>“Maximum IOS build version.”</i>
     * 
     * @return property osMaximumBuildVersion
     */
    @Property(name="osMaximumBuildVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumBuildVersion() {
        return Optional.ofNullable(osMaximumBuildVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * osMaximumBuildVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Maximum IOS build version.”</i>
     * 
     * @param osMaximumBuildVersion
     *            new value of {@code osMaximumBuildVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumBuildVersion} field changed
     */
    public IosCompliancePolicy withOsMaximumBuildVersion(String osMaximumBuildVersion) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumBuildVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.osMaximumBuildVersion = osMaximumBuildVersion;
        return _x;
    }

    /**
     * <i>“Devices must not be jailbroken or rooted.”</i>
     * 
     * @return property securityBlockJailbrokenDevices
     */
    @Property(name="securityBlockJailbrokenDevices")
    @JsonIgnore
    public Optional<Boolean> getSecurityBlockJailbrokenDevices() {
        return Optional.ofNullable(securityBlockJailbrokenDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityBlockJailbrokenDevices} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Devices must not be jailbroken or rooted.”</i>
     * 
     * @param securityBlockJailbrokenDevices
     *            new value of {@code securityBlockJailbrokenDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityBlockJailbrokenDevices} field changed
     */
    public IosCompliancePolicy withSecurityBlockJailbrokenDevices(Boolean securityBlockJailbrokenDevices) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("securityBlockJailbrokenDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
        return _x;
    }

    /**
     * <i>“Require that devices have enabled device threat protection .”</i>
     * 
     * @return property deviceThreatProtectionEnabled
     */
    @Property(name="deviceThreatProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getDeviceThreatProtectionEnabled() {
        return Optional.ofNullable(deviceThreatProtectionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceThreatProtectionEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require that devices have enabled device threat protection .”</i>
     * 
     * @param deviceThreatProtectionEnabled
     *            new value of {@code deviceThreatProtectionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceThreatProtectionEnabled} field changed
     */
    public IosCompliancePolicy withDeviceThreatProtectionEnabled(Boolean deviceThreatProtectionEnabled) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceThreatProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
        return _x;
    }

    /**
     * <i>“Require Mobile Threat Protection minimum risk level to report noncompliance.”</i>
     * 
     * @return property deviceThreatProtectionRequiredSecurityLevel
     */
    @Property(name="deviceThreatProtectionRequiredSecurityLevel")
    @JsonIgnore
    public Optional<DeviceThreatProtectionLevel> getDeviceThreatProtectionRequiredSecurityLevel() {
        return Optional.ofNullable(deviceThreatProtectionRequiredSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceThreatProtectionRequiredSecurityLevel} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Require Mobile Threat Protection minimum risk level to report noncompliance.”</i>
     * 
     * @param deviceThreatProtectionRequiredSecurityLevel
     *            new value of {@code deviceThreatProtectionRequiredSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceThreatProtectionRequiredSecurityLevel} field changed
     */
    public IosCompliancePolicy withDeviceThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceThreatProtectionRequiredSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a managed email profile.”</i>
     * 
     * @return property managedEmailProfileRequired
     */
    @Property(name="managedEmailProfileRequired")
    @JsonIgnore
    public Optional<Boolean> getManagedEmailProfileRequired() {
        return Optional.ofNullable(managedEmailProfileRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedEmailProfileRequired} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require a managed email profile.”</i>
     * 
     * @param managedEmailProfileRequired
     *            new value of {@code managedEmailProfileRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedEmailProfileRequired} field changed
     */
    public IosCompliancePolicy withManagedEmailProfileRequired(Boolean managedEmailProfileRequired) {
        IosCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("managedEmailProfileRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCompliancePolicy");
        _x.managedEmailProfileRequired = managedEmailProfileRequired;
        return _x;
    }

    /**
     * <i>“Require the device to not have the specified apps installed. This collection can
     * contain a maximum of 100 elements.”</i>
     * 
     * @return property restrictedApps
     */
    @Property(name="restrictedApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getRestrictedApps() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, restrictedApps, Optional.ofNullable(restrictedAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Require the device to not have the specified apps installed. This collection can
     * contain a maximum of 100 elements.”</i>
     * 
     * @return property restrictedApps
     */
    @Property(name="restrictedApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getRestrictedApps(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, restrictedApps, Optional.ofNullable(restrictedAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosCompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosCompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosCompliancePolicy _copy() {
        IosCompliancePolicy _x = new IosCompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.displayName = displayName;
        _x.version = version;
        _x.passcodeBlockSimple = passcodeBlockSimple;
        _x.passcodeExpirationDays = passcodeExpirationDays;
        _x.passcodeMinimumLength = passcodeMinimumLength;
        _x.passcodeMinutesOfInactivityBeforeLock = passcodeMinutesOfInactivityBeforeLock;
        _x.passcodeMinutesOfInactivityBeforeScreenTimeout = passcodeMinutesOfInactivityBeforeScreenTimeout;
        _x.passcodePreviousPasscodeBlockCount = passcodePreviousPasscodeBlockCount;
        _x.passcodeMinimumCharacterSetCount = passcodeMinimumCharacterSetCount;
        _x.passcodeRequiredType = passcodeRequiredType;
        _x.passcodeRequired = passcodeRequired;
        _x.osMinimumVersion = osMinimumVersion;
        _x.osMaximumVersion = osMaximumVersion;
        _x.osMinimumBuildVersion = osMinimumBuildVersion;
        _x.osMaximumBuildVersion = osMaximumBuildVersion;
        _x.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
        _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
        _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
        _x.managedEmailProfileRequired = managedEmailProfileRequired;
        _x.restrictedApps = restrictedApps;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosCompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("passcodeBlockSimple=");
        b.append(this.passcodeBlockSimple);
        b.append(", ");
        b.append("passcodeExpirationDays=");
        b.append(this.passcodeExpirationDays);
        b.append(", ");
        b.append("passcodeMinimumLength=");
        b.append(this.passcodeMinimumLength);
        b.append(", ");
        b.append("passcodeMinutesOfInactivityBeforeLock=");
        b.append(this.passcodeMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passcodeMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passcodeMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passcodePreviousPasscodeBlockCount=");
        b.append(this.passcodePreviousPasscodeBlockCount);
        b.append(", ");
        b.append("passcodeMinimumCharacterSetCount=");
        b.append(this.passcodeMinimumCharacterSetCount);
        b.append(", ");
        b.append("passcodeRequiredType=");
        b.append(this.passcodeRequiredType);
        b.append(", ");
        b.append("passcodeRequired=");
        b.append(this.passcodeRequired);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("osMinimumBuildVersion=");
        b.append(this.osMinimumBuildVersion);
        b.append(", ");
        b.append("osMaximumBuildVersion=");
        b.append(this.osMaximumBuildVersion);
        b.append(", ");
        b.append("securityBlockJailbrokenDevices=");
        b.append(this.securityBlockJailbrokenDevices);
        b.append(", ");
        b.append("deviceThreatProtectionEnabled=");
        b.append(this.deviceThreatProtectionEnabled);
        b.append(", ");
        b.append("deviceThreatProtectionRequiredSecurityLevel=");
        b.append(this.deviceThreatProtectionRequiredSecurityLevel);
        b.append(", ");
        b.append("managedEmailProfileRequired=");
        b.append(this.managedEmailProfileRequired);
        b.append(", ");
        b.append("restrictedApps=");
        b.append(this.restrictedApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
