package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AppleSubjectNameFormat;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;


/**
 * <i>“iOS certificate profile base.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "renewalThresholdPercentage", 
    "subjectNameFormat", 
    "subjectAlternativeNameType", 
    "certificateValidityPeriodValue", 
    "certificateValidityPeriodScale"})
@JsonInclude(Include.NON_NULL)
public class IosCertificateProfileBase extends IosCertificateProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosCertificateProfileBase";
    }

    @JsonProperty("renewalThresholdPercentage")
    protected Integer renewalThresholdPercentage;

    @JsonProperty("subjectNameFormat")
    protected AppleSubjectNameFormat subjectNameFormat;

    @JsonProperty("subjectAlternativeNameType")
    protected SubjectAlternativeNameType subjectAlternativeNameType;

    @JsonProperty("certificateValidityPeriodValue")
    protected Integer certificateValidityPeriodValue;

    @JsonProperty("certificateValidityPeriodScale")
    protected CertificateValidityPeriodScale certificateValidityPeriodScale;

    protected IosCertificateProfileBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Certificate renewal threshold percentage. Valid values 1 to 99”</i>
     * 
     * @return property renewalThresholdPercentage
     */
    @Property(name="renewalThresholdPercentage")
    @JsonIgnore
    public Optional<Integer> getRenewalThresholdPercentage() {
        return Optional.ofNullable(renewalThresholdPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * renewalThresholdPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate renewal threshold percentage. Valid values 1 to 99”</i>
     * 
     * @param renewalThresholdPercentage
     *            new value of {@code renewalThresholdPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code renewalThresholdPercentage} field changed
     */
    public IosCertificateProfileBase withRenewalThresholdPercentage(Integer renewalThresholdPercentage) {
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("renewalThresholdPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCertificateProfileBase");
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        return _x;
    }

    /**
     * <i>“Certificate Subject Name Format.”</i>
     * 
     * @return property subjectNameFormat
     */
    @Property(name="subjectNameFormat")
    @JsonIgnore
    public Optional<AppleSubjectNameFormat> getSubjectNameFormat() {
        return Optional.ofNullable(subjectNameFormat);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subjectNameFormat
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Certificate Subject Name Format.”</i>
     * 
     * @param subjectNameFormat
     *            new value of {@code subjectNameFormat} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectNameFormat} field changed
     */
    public IosCertificateProfileBase withSubjectNameFormat(AppleSubjectNameFormat subjectNameFormat) {
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("subjectNameFormat");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCertificateProfileBase");
        _x.subjectNameFormat = subjectNameFormat;
        return _x;
    }

    /**
     * <i>“Certificate Subject Alternative Name type.”</i>
     * 
     * @return property subjectAlternativeNameType
     */
    @Property(name="subjectAlternativeNameType")
    @JsonIgnore
    public Optional<SubjectAlternativeNameType> getSubjectAlternativeNameType() {
        return Optional.ofNullable(subjectAlternativeNameType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectAlternativeNameType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate Subject Alternative Name type.”</i>
     * 
     * @param subjectAlternativeNameType
     *            new value of {@code subjectAlternativeNameType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectAlternativeNameType} field changed
     */
    public IosCertificateProfileBase withSubjectAlternativeNameType(SubjectAlternativeNameType subjectAlternativeNameType) {
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("subjectAlternativeNameType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCertificateProfileBase");
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        return _x;
    }

    /**
     * <i>“Value for the Certificate Validity Period.”</i>
     * 
     * @return property certificateValidityPeriodValue
     */
    @Property(name="certificateValidityPeriodValue")
    @JsonIgnore
    public Optional<Integer> getCertificateValidityPeriodValue() {
        return Optional.ofNullable(certificateValidityPeriodValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value for the Certificate Validity Period.”</i>
     * 
     * @param certificateValidityPeriodValue
     *            new value of {@code certificateValidityPeriodValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodValue} field changed
     */
    public IosCertificateProfileBase withCertificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCertificateProfileBase");
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        return _x;
    }

    /**
     * <i>“Scale for the Certificate Validity Period.”</i>
     * 
     * @return property certificateValidityPeriodScale
     */
    @Property(name="certificateValidityPeriodScale")
    @JsonIgnore
    public Optional<CertificateValidityPeriodScale> getCertificateValidityPeriodScale() {
        return Optional.ofNullable(certificateValidityPeriodScale);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodScale} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Scale for the Certificate Validity Period.”</i>
     * 
     * @param certificateValidityPeriodScale
     *            new value of {@code certificateValidityPeriodScale} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodScale} field changed
     */
    public IosCertificateProfileBase withCertificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodScale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosCertificateProfileBase");
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosCertificateProfileBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosCertificateProfileBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosCertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosCertificateProfileBase _copy() {
        IosCertificateProfileBase _x = new IosCertificateProfileBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectNameFormat = subjectNameFormat;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosCertificateProfileBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
