package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.InvitedUserMessageInfo;
import odata.msgraph.client.beta.entity.request.UserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "invitedUserDisplayName", 
    "invitedUserType", 
    "invitedUserEmailAddress", 
    "invitedUserMessageInfo", 
    "sendInvitationMessage", 
    "inviteRedirectUrl", 
    "inviteRedeemUrl", 
    "status", 
    "resetRedemption"})
@JsonInclude(Include.NON_NULL)
public class Invitation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.invitation";
    }

    @JsonProperty("invitedUserDisplayName")
    protected String invitedUserDisplayName;

    @JsonProperty("invitedUserType")
    protected String invitedUserType;

    @JsonProperty("invitedUserEmailAddress")
    protected String invitedUserEmailAddress;

    @JsonProperty("invitedUserMessageInfo")
    protected InvitedUserMessageInfo invitedUserMessageInfo;

    @JsonProperty("sendInvitationMessage")
    protected Boolean sendInvitationMessage;

    @JsonProperty("inviteRedirectUrl")
    protected String inviteRedirectUrl;

    @JsonProperty("inviteRedeemUrl")
    protected String inviteRedeemUrl;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("resetRedemption")
    protected Boolean resetRedemption;

    protected Invitation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInvitation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String invitedUserDisplayName;
        private String invitedUserType;
        private String invitedUserEmailAddress;
        private InvitedUserMessageInfo invitedUserMessageInfo;
        private Boolean sendInvitationMessage;
        private String inviteRedirectUrl;
        private String inviteRedeemUrl;
        private String status;
        private Boolean resetRedemption;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder invitedUserDisplayName(String invitedUserDisplayName) {
            this.invitedUserDisplayName = invitedUserDisplayName;
            this.changedFields = changedFields.add("invitedUserDisplayName");
            return this;
        }

        public Builder invitedUserType(String invitedUserType) {
            this.invitedUserType = invitedUserType;
            this.changedFields = changedFields.add("invitedUserType");
            return this;
        }

        public Builder invitedUserEmailAddress(String invitedUserEmailAddress) {
            this.invitedUserEmailAddress = invitedUserEmailAddress;
            this.changedFields = changedFields.add("invitedUserEmailAddress");
            return this;
        }

        public Builder invitedUserMessageInfo(InvitedUserMessageInfo invitedUserMessageInfo) {
            this.invitedUserMessageInfo = invitedUserMessageInfo;
            this.changedFields = changedFields.add("invitedUserMessageInfo");
            return this;
        }

        public Builder sendInvitationMessage(Boolean sendInvitationMessage) {
            this.sendInvitationMessage = sendInvitationMessage;
            this.changedFields = changedFields.add("sendInvitationMessage");
            return this;
        }

        public Builder inviteRedirectUrl(String inviteRedirectUrl) {
            this.inviteRedirectUrl = inviteRedirectUrl;
            this.changedFields = changedFields.add("inviteRedirectUrl");
            return this;
        }

        public Builder inviteRedeemUrl(String inviteRedeemUrl) {
            this.inviteRedeemUrl = inviteRedeemUrl;
            this.changedFields = changedFields.add("inviteRedeemUrl");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder resetRedemption(Boolean resetRedemption) {
            this.resetRedemption = resetRedemption;
            this.changedFields = changedFields.add("resetRedemption");
            return this;
        }

        public Invitation build() {
            Invitation _x = new Invitation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.invitation";
            _x.id = id;
            _x.invitedUserDisplayName = invitedUserDisplayName;
            _x.invitedUserType = invitedUserType;
            _x.invitedUserEmailAddress = invitedUserEmailAddress;
            _x.invitedUserMessageInfo = invitedUserMessageInfo;
            _x.sendInvitationMessage = sendInvitationMessage;
            _x.inviteRedirectUrl = inviteRedirectUrl;
            _x.inviteRedeemUrl = inviteRedeemUrl;
            _x.status = status;
            _x.resetRedemption = resetRedemption;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="invitedUserDisplayName")
    @JsonIgnore
    public Optional<String> getInvitedUserDisplayName() {
        return Optional.ofNullable(invitedUserDisplayName);
    }

    public Invitation withInvitedUserDisplayName(String invitedUserDisplayName) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("invitedUserDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.invitedUserDisplayName = invitedUserDisplayName;
        return _x;
    }

    @Property(name="invitedUserType")
    @JsonIgnore
    public Optional<String> getInvitedUserType() {
        return Optional.ofNullable(invitedUserType);
    }

    public Invitation withInvitedUserType(String invitedUserType) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("invitedUserType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.invitedUserType = invitedUserType;
        return _x;
    }

    @Property(name="invitedUserEmailAddress")
    @JsonIgnore
    public Optional<String> getInvitedUserEmailAddress() {
        return Optional.ofNullable(invitedUserEmailAddress);
    }

    public Invitation withInvitedUserEmailAddress(String invitedUserEmailAddress) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("invitedUserEmailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.invitedUserEmailAddress = invitedUserEmailAddress;
        return _x;
    }

    @Property(name="invitedUserMessageInfo")
    @JsonIgnore
    public Optional<InvitedUserMessageInfo> getInvitedUserMessageInfo() {
        return Optional.ofNullable(invitedUserMessageInfo);
    }

    public Invitation withInvitedUserMessageInfo(InvitedUserMessageInfo invitedUserMessageInfo) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("invitedUserMessageInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.invitedUserMessageInfo = invitedUserMessageInfo;
        return _x;
    }

    @Property(name="sendInvitationMessage")
    @JsonIgnore
    public Optional<Boolean> getSendInvitationMessage() {
        return Optional.ofNullable(sendInvitationMessage);
    }

    public Invitation withSendInvitationMessage(Boolean sendInvitationMessage) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("sendInvitationMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.sendInvitationMessage = sendInvitationMessage;
        return _x;
    }

    @Property(name="inviteRedirectUrl")
    @JsonIgnore
    public Optional<String> getInviteRedirectUrl() {
        return Optional.ofNullable(inviteRedirectUrl);
    }

    public Invitation withInviteRedirectUrl(String inviteRedirectUrl) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("inviteRedirectUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.inviteRedirectUrl = inviteRedirectUrl;
        return _x;
    }

    @Property(name="inviteRedeemUrl")
    @JsonIgnore
    public Optional<String> getInviteRedeemUrl() {
        return Optional.ofNullable(inviteRedeemUrl);
    }

    public Invitation withInviteRedeemUrl(String inviteRedeemUrl) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("inviteRedeemUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.inviteRedeemUrl = inviteRedeemUrl;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Invitation withStatus(String status) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.status = status;
        return _x;
    }

    @Property(name="resetRedemption")
    @JsonIgnore
    public Optional<Boolean> getResetRedemption() {
        return Optional.ofNullable(resetRedemption);
    }

    public Invitation withResetRedemption(Boolean resetRedemption) {
        Invitation _x = _copy();
        _x.changedFields = changedFields.add("resetRedemption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitation");
        _x.resetRedemption = resetRedemption;
        return _x;
    }

    @NavigationProperty(name="invitedUser")
    @JsonIgnore
    public UserRequest getInvitedUser() {
        return new UserRequest(contextPath.addSegment("invitedUser"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Invitation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Invitation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Invitation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Invitation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Invitation _copy() {
        Invitation _x = new Invitation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.invitedUserDisplayName = invitedUserDisplayName;
        _x.invitedUserType = invitedUserType;
        _x.invitedUserEmailAddress = invitedUserEmailAddress;
        _x.invitedUserMessageInfo = invitedUserMessageInfo;
        _x.sendInvitationMessage = sendInvitationMessage;
        _x.inviteRedirectUrl = inviteRedirectUrl;
        _x.inviteRedeemUrl = inviteRedeemUrl;
        _x.status = status;
        _x.resetRedemption = resetRedemption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Invitation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("invitedUserDisplayName=");
        b.append(this.invitedUserDisplayName);
        b.append(", ");
        b.append("invitedUserType=");
        b.append(this.invitedUserType);
        b.append(", ");
        b.append("invitedUserEmailAddress=");
        b.append(this.invitedUserEmailAddress);
        b.append(", ");
        b.append("invitedUserMessageInfo=");
        b.append(this.invitedUserMessageInfo);
        b.append(", ");
        b.append("sendInvitationMessage=");
        b.append(this.sendInvitationMessage);
        b.append(", ");
        b.append("inviteRedirectUrl=");
        b.append(this.inviteRedirectUrl);
        b.append(", ");
        b.append("inviteRedeemUrl=");
        b.append(this.inviteRedeemUrl);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("resetRedemption=");
        b.append(this.resetRedemption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
