package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.enums.ImportedWindowsAutopilotDeviceIdentityUploadStatus;


/**
 * <i>“Import windows autopilot devices using upload.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTimeUtc", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ImportedWindowsAutopilotDeviceIdentityUpload extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.importedWindowsAutopilotDeviceIdentityUpload";
    }

    @JsonProperty("createdDateTimeUtc")
    protected OffsetDateTime createdDateTimeUtc;

    @JsonProperty("status")
    protected ImportedWindowsAutopilotDeviceIdentityUploadStatus status;

    protected ImportedWindowsAutopilotDeviceIdentityUpload() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportedWindowsAutopilotDeviceIdentityUpload() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTimeUtc;
        private ImportedWindowsAutopilotDeviceIdentityUploadStatus status;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“DateTime when the entity is created.”</i>
         * 
         * @param createdDateTimeUtc
         *            value of {@code createdDateTimeUtc} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTimeUtc(OffsetDateTime createdDateTimeUtc) {
            this.createdDateTimeUtc = createdDateTimeUtc;
            this.changedFields = changedFields.add("createdDateTimeUtc");
            return this;
        }

        /**
         * <i>“Upload status.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(ImportedWindowsAutopilotDeviceIdentityUploadStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ImportedWindowsAutopilotDeviceIdentityUpload build() {
            ImportedWindowsAutopilotDeviceIdentityUpload _x = new ImportedWindowsAutopilotDeviceIdentityUpload();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.importedWindowsAutopilotDeviceIdentityUpload";
            _x.id = id;
            _x.createdDateTimeUtc = createdDateTimeUtc;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“DateTime when the entity is created.”</i>
     * 
     * @return property createdDateTimeUtc
     */
    @Property(name="createdDateTimeUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTimeUtc() {
        return Optional.ofNullable(createdDateTimeUtc);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * createdDateTimeUtc} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime when the entity is created.”</i>
     * 
     * @param createdDateTimeUtc
     *            new value of {@code createdDateTimeUtc} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTimeUtc} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentityUpload withCreatedDateTimeUtc(OffsetDateTime createdDateTimeUtc) {
        ImportedWindowsAutopilotDeviceIdentityUpload _x = _copy();
        _x.changedFields = changedFields.add("createdDateTimeUtc");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentityUpload");
        _x.createdDateTimeUtc = createdDateTimeUtc;
        return _x;
    }

    /**
     * <i>“Upload status.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<ImportedWindowsAutopilotDeviceIdentityUploadStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Upload status.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentityUpload withStatus(ImportedWindowsAutopilotDeviceIdentityUploadStatus status) {
        ImportedWindowsAutopilotDeviceIdentityUpload _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentityUpload");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“Collection of all Autopilot devices as a part of this upload.”</i>
     * 
     * @return navigational property deviceIdentities
     */
    @NavigationProperty(name="deviceIdentities")
    @JsonIgnore
    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest getDeviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("deviceIdentities"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedWindowsAutopilotDeviceIdentityUpload patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ImportedWindowsAutopilotDeviceIdentityUpload _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedWindowsAutopilotDeviceIdentityUpload put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ImportedWindowsAutopilotDeviceIdentityUpload _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ImportedWindowsAutopilotDeviceIdentityUpload _copy() {
        ImportedWindowsAutopilotDeviceIdentityUpload _x = new ImportedWindowsAutopilotDeviceIdentityUpload();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTimeUtc = createdDateTimeUtc;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImportedWindowsAutopilotDeviceIdentityUpload[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTimeUtc=");
        b.append(this.createdDateTimeUtc);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
