package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.ImportedWindowsAutopilotDeviceIdentityState;


/**
 * <i>“Imported windows autopilot devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "orderIdentifier", 
    "groupTag", 
    "serialNumber", 
    "productKey", 
    "importId", 
    "hardwareIdentifier", 
    "state", 
    "assignedUserPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class ImportedWindowsAutopilotDeviceIdentity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.importedWindowsAutopilotDeviceIdentity";
    }

    @JsonProperty("orderIdentifier")
    protected String orderIdentifier;

    @JsonProperty("groupTag")
    protected String groupTag;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("productKey")
    protected String productKey;

    @JsonProperty("importId")
    protected String importId;

    @JsonProperty("hardwareIdentifier")
    protected byte[] hardwareIdentifier;

    @JsonProperty("state")
    protected ImportedWindowsAutopilotDeviceIdentityState state;

    @JsonProperty("assignedUserPrincipalName")
    protected String assignedUserPrincipalName;

    protected ImportedWindowsAutopilotDeviceIdentity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportedWindowsAutopilotDeviceIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String orderIdentifier;
        private String groupTag;
        private String serialNumber;
        private String productKey;
        private String importId;
        private byte[] hardwareIdentifier;
        private ImportedWindowsAutopilotDeviceIdentityState state;
        private String assignedUserPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Order Id of the Windows autopilot device. - Deprecate”</i>
         * 
         * @param orderIdentifier
         *            value of {@code orderIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderIdentifier(String orderIdentifier) {
            this.orderIdentifier = orderIdentifier;
            this.changedFields = changedFields.add("orderIdentifier");
            return this;
        }

        /**
         * <i>“Group Tag of the Windows autopilot device.”</i>
         * 
         * @param groupTag
         *            value of {@code groupTag} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupTag(String groupTag) {
            this.groupTag = groupTag;
            this.changedFields = changedFields.add("groupTag");
            return this;
        }

        /**
         * <i>“Serial number of the Windows autopilot device.”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“Product Key of the Windows autopilot device.”</i>
         * 
         * @param productKey
         *            value of {@code productKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productKey(String productKey) {
            this.productKey = productKey;
            this.changedFields = changedFields.add("productKey");
            return this;
        }

        /**
         * <i>“The Import Id of the Windows autopilot device.”</i>
         * 
         * @param importId
         *            value of {@code importId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder importId(String importId) {
            this.importId = importId;
            this.changedFields = changedFields.add("importId");
            return this;
        }

        /**
         * <i>“Hardware Blob of the Windows autopilot device.”</i>
         * 
         * @param hardwareIdentifier
         *            value of {@code hardwareIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hardwareIdentifier(byte[] hardwareIdentifier) {
            this.hardwareIdentifier = hardwareIdentifier;
            this.changedFields = changedFields.add("hardwareIdentifier");
            return this;
        }

        /**
         * <i>“Current state of the imported device.”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(ImportedWindowsAutopilotDeviceIdentityState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“UPN of the user the device will be assigned”</i>
         * 
         * @param assignedUserPrincipalName
         *            value of {@code assignedUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignedUserPrincipalName(String assignedUserPrincipalName) {
            this.assignedUserPrincipalName = assignedUserPrincipalName;
            this.changedFields = changedFields.add("assignedUserPrincipalName");
            return this;
        }

        public ImportedWindowsAutopilotDeviceIdentity build() {
            ImportedWindowsAutopilotDeviceIdentity _x = new ImportedWindowsAutopilotDeviceIdentity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.importedWindowsAutopilotDeviceIdentity";
            _x.id = id;
            _x.orderIdentifier = orderIdentifier;
            _x.groupTag = groupTag;
            _x.serialNumber = serialNumber;
            _x.productKey = productKey;
            _x.importId = importId;
            _x.hardwareIdentifier = hardwareIdentifier;
            _x.state = state;
            _x.assignedUserPrincipalName = assignedUserPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Order Id of the Windows autopilot device. - Deprecate”</i>
     * 
     * @return property orderIdentifier
     */
    @Property(name="orderIdentifier")
    @JsonIgnore
    public Optional<String> getOrderIdentifier() {
        return Optional.ofNullable(orderIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code orderIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Order Id of the Windows autopilot device. - Deprecate”</i>
     * 
     * @param orderIdentifier
     *            new value of {@code orderIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code orderIdentifier} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withOrderIdentifier(String orderIdentifier) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("orderIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.orderIdentifier = orderIdentifier;
        return _x;
    }

    /**
     * <i>“Group Tag of the Windows autopilot device.”</i>
     * 
     * @return property groupTag
     */
    @Property(name="groupTag")
    @JsonIgnore
    public Optional<String> getGroupTag() {
        return Optional.ofNullable(groupTag);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupTag} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Group Tag of the Windows autopilot device.”</i>
     * 
     * @param groupTag
     *            new value of {@code groupTag} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupTag} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withGroupTag(String groupTag) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("groupTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.groupTag = groupTag;
        return _x;
    }

    /**
     * <i>“Serial number of the Windows autopilot device.”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Serial number of the Windows autopilot device.”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withSerialNumber(String serialNumber) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“Product Key of the Windows autopilot device.”</i>
     * 
     * @return property productKey
     */
    @Property(name="productKey")
    @JsonIgnore
    public Optional<String> getProductKey() {
        return Optional.ofNullable(productKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Product Key of the Windows autopilot device.”</i>
     * 
     * @param productKey
     *            new value of {@code productKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productKey} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withProductKey(String productKey) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("productKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.productKey = productKey;
        return _x;
    }

    /**
     * <i>“The Import Id of the Windows autopilot device.”</i>
     * 
     * @return property importId
     */
    @Property(name="importId")
    @JsonIgnore
    public Optional<String> getImportId() {
        return Optional.ofNullable(importId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code importId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Import Id of the Windows autopilot device.”</i>
     * 
     * @param importId
     *            new value of {@code importId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code importId} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withImportId(String importId) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("importId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.importId = importId;
        return _x;
    }

    /**
     * <i>“Hardware Blob of the Windows autopilot device.”</i>
     * 
     * @return property hardwareIdentifier
     */
    @Property(name="hardwareIdentifier")
    @JsonIgnore
    public Optional<byte[]> getHardwareIdentifier() {
        return Optional.ofNullable(hardwareIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hardwareIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Hardware Blob of the Windows autopilot device.”</i>
     * 
     * @param hardwareIdentifier
     *            new value of {@code hardwareIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hardwareIdentifier} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withHardwareIdentifier(byte[] hardwareIdentifier) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("hardwareIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.hardwareIdentifier = hardwareIdentifier;
        return _x;
    }

    /**
     * <i>“Current state of the imported device.”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<ImportedWindowsAutopilotDeviceIdentityState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Current state of the imported device.”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withState(ImportedWindowsAutopilotDeviceIdentityState state) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“UPN of the user the device will be assigned”</i>
     * 
     * @return property assignedUserPrincipalName
     */
    @Property(name="assignedUserPrincipalName")
    @JsonIgnore
    public Optional<String> getAssignedUserPrincipalName() {
        return Optional.ofNullable(assignedUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assignedUserPrincipalName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“UPN of the user the device will be assigned”</i>
     * 
     * @param assignedUserPrincipalName
     *            new value of {@code assignedUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignedUserPrincipalName} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentity withAssignedUserPrincipalName(String assignedUserPrincipalName) {
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("assignedUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentity");
        _x.assignedUserPrincipalName = assignedUserPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedWindowsAutopilotDeviceIdentity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedWindowsAutopilotDeviceIdentity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ImportedWindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ImportedWindowsAutopilotDeviceIdentity _copy() {
        ImportedWindowsAutopilotDeviceIdentity _x = new ImportedWindowsAutopilotDeviceIdentity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.orderIdentifier = orderIdentifier;
        _x.groupTag = groupTag;
        _x.serialNumber = serialNumber;
        _x.productKey = productKey;
        _x.importId = importId;
        _x.hardwareIdentifier = hardwareIdentifier;
        _x.state = state;
        _x.assignedUserPrincipalName = assignedUserPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImportedWindowsAutopilotDeviceIdentity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("orderIdentifier=");
        b.append(this.orderIdentifier);
        b.append(", ");
        b.append("groupTag=");
        b.append(this.groupTag);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("productKey=");
        b.append(this.productKey);
        b.append(", ");
        b.append("importId=");
        b.append(this.importId);
        b.append(", ");
        b.append("hardwareIdentifier=");
        b.append(this.hardwareIdentifier);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("assignedUserPrincipalName=");
        b.append(this.assignedUserPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
