package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "name", 
    "clientId", 
    "clientSecret"})
@JsonInclude(Include.NON_NULL)
public class IdentityProvider extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identityProvider";
    }

    @JsonProperty("type")
    protected String type;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("clientId")
    protected String clientId;

    @JsonProperty("clientSecret")
    protected String clientSecret;

    protected IdentityProvider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIdentityProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String type;
        private String name;
        private String clientId;
        private String clientSecret;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public IdentityProvider build() {
            IdentityProvider _x = new IdentityProvider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.identityProvider";
            _x.id = id;
            _x.type = type;
            _x.name = name;
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public IdentityProvider withType(String type) {
        IdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProvider");
        _x.type = type;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public IdentityProvider withName(String name) {
        IdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProvider");
        _x.name = name;
        return _x;
    }

    @Property(name="clientId")
    @JsonIgnore
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    public IdentityProvider withClientId(String clientId) {
        IdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("clientId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProvider");
        _x.clientId = clientId;
        return _x;
    }

    @Property(name="clientSecret")
    @JsonIgnore
    public Optional<String> getClientSecret() {
        return Optional.ofNullable(clientSecret);
    }

    public IdentityProvider withClientSecret(String clientSecret) {
        IdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("clientSecret");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityProvider");
        _x.clientSecret = clientSecret;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IdentityProvider _copy() {
        IdentityProvider _x = new IdentityProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.type = type;
        _x.name = name;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentityProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
