package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LogonUser;
import odata.msgraph.client.beta.complex.NetworkInterface;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "azureSubscriptionId", 
    "azureTenantId", 
    "firstSeenDateTime", 
    "fqdn", 
    "isAzureAdJoined", 
    "isAzureAdRegistered", 
    "isHybridAzureDomainJoined", 
    "lastSeenDateTime", 
    "logonUsers", 
    "netBiosName", 
    "networkInterfaces", 
    "os", 
    "osVersion", 
    "parentHost", 
    "relatedHostIds", 
    "riskScore", 
    "tags", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class HostSecurityProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hostSecurityProfile";
    }

    @JsonProperty("azureSubscriptionId")
    protected String azureSubscriptionId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("firstSeenDateTime")
    protected OffsetDateTime firstSeenDateTime;

    @JsonProperty("fqdn")
    protected String fqdn;

    @JsonProperty("isAzureAdJoined")
    protected Boolean isAzureAdJoined;

    @JsonProperty("isAzureAdRegistered")
    protected Boolean isAzureAdRegistered;

    @JsonProperty("isHybridAzureDomainJoined")
    protected Boolean isHybridAzureDomainJoined;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("logonUsers")
    protected List<LogonUser> logonUsers;

    @JsonProperty("logonUsers@nextLink")
    protected String logonUsersNextLink;

    @JsonProperty("netBiosName")
    protected String netBiosName;

    @JsonProperty("networkInterfaces")
    protected List<NetworkInterface> networkInterfaces;

    @JsonProperty("networkInterfaces@nextLink")
    protected String networkInterfacesNextLink;

    @JsonProperty("os")
    protected String os;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("parentHost")
    protected String parentHost;

    @JsonProperty("relatedHostIds")
    protected List<String> relatedHostIds;

    @JsonProperty("relatedHostIds@nextLink")
    protected String relatedHostIdsNextLink;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected HostSecurityProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderHostSecurityProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String azureSubscriptionId;
        private String azureTenantId;
        private OffsetDateTime firstSeenDateTime;
        private String fqdn;
        private Boolean isAzureAdJoined;
        private Boolean isAzureAdRegistered;
        private Boolean isHybridAzureDomainJoined;
        private OffsetDateTime lastSeenDateTime;
        private List<LogonUser> logonUsers;
        private String logonUsersNextLink;
        private String netBiosName;
        private List<NetworkInterface> networkInterfaces;
        private String networkInterfacesNextLink;
        private String os;
        private String osVersion;
        private String parentHost;
        private List<String> relatedHostIds;
        private String relatedHostIdsNextLink;
        private String riskScore;
        private List<String> tags;
        private String tagsNextLink;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder azureSubscriptionId(String azureSubscriptionId) {
            this.azureSubscriptionId = azureSubscriptionId;
            this.changedFields = changedFields.add("azureSubscriptionId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder firstSeenDateTime(OffsetDateTime firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            this.changedFields = changedFields.add("firstSeenDateTime");
            return this;
        }

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            this.changedFields = changedFields.add("fqdn");
            return this;
        }

        public Builder isAzureAdJoined(Boolean isAzureAdJoined) {
            this.isAzureAdJoined = isAzureAdJoined;
            this.changedFields = changedFields.add("isAzureAdJoined");
            return this;
        }

        public Builder isAzureAdRegistered(Boolean isAzureAdRegistered) {
            this.isAzureAdRegistered = isAzureAdRegistered;
            this.changedFields = changedFields.add("isAzureAdRegistered");
            return this;
        }

        public Builder isHybridAzureDomainJoined(Boolean isHybridAzureDomainJoined) {
            this.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
            this.changedFields = changedFields.add("isHybridAzureDomainJoined");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder logonUsers(List<LogonUser> logonUsers) {
            this.logonUsers = logonUsers;
            this.changedFields = changedFields.add("logonUsers");
            return this;
        }

        public Builder logonUsers(LogonUser... logonUsers) {
            return logonUsers(Arrays.asList(logonUsers));
        }

        public Builder logonUsersNextLink(String logonUsersNextLink) {
            this.logonUsersNextLink = logonUsersNextLink;
            this.changedFields = changedFields.add("logonUsers");
            return this;
        }

        public Builder netBiosName(String netBiosName) {
            this.netBiosName = netBiosName;
            this.changedFields = changedFields.add("netBiosName");
            return this;
        }

        public Builder networkInterfaces(List<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            this.changedFields = changedFields.add("networkInterfaces");
            return this;
        }

        public Builder networkInterfaces(NetworkInterface... networkInterfaces) {
            return networkInterfaces(Arrays.asList(networkInterfaces));
        }

        public Builder networkInterfacesNextLink(String networkInterfacesNextLink) {
            this.networkInterfacesNextLink = networkInterfacesNextLink;
            this.changedFields = changedFields.add("networkInterfaces");
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            this.changedFields = changedFields.add("os");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public Builder parentHost(String parentHost) {
            this.parentHost = parentHost;
            this.changedFields = changedFields.add("parentHost");
            return this;
        }

        public Builder relatedHostIds(List<String> relatedHostIds) {
            this.relatedHostIds = relatedHostIds;
            this.changedFields = changedFields.add("relatedHostIds");
            return this;
        }

        public Builder relatedHostIds(String... relatedHostIds) {
            return relatedHostIds(Arrays.asList(relatedHostIds));
        }

        public Builder relatedHostIdsNextLink(String relatedHostIdsNextLink) {
            this.relatedHostIdsNextLink = relatedHostIdsNextLink;
            this.changedFields = changedFields.add("relatedHostIds");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public HostSecurityProfile build() {
            HostSecurityProfile _x = new HostSecurityProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.hostSecurityProfile";
            _x.id = id;
            _x.azureSubscriptionId = azureSubscriptionId;
            _x.azureTenantId = azureTenantId;
            _x.firstSeenDateTime = firstSeenDateTime;
            _x.fqdn = fqdn;
            _x.isAzureAdJoined = isAzureAdJoined;
            _x.isAzureAdRegistered = isAzureAdRegistered;
            _x.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.logonUsers = logonUsers;
            _x.logonUsersNextLink = logonUsersNextLink;
            _x.netBiosName = netBiosName;
            _x.networkInterfaces = networkInterfaces;
            _x.networkInterfacesNextLink = networkInterfacesNextLink;
            _x.os = os;
            _x.osVersion = osVersion;
            _x.parentHost = parentHost;
            _x.relatedHostIds = relatedHostIds;
            _x.relatedHostIdsNextLink = relatedHostIdsNextLink;
            _x.riskScore = riskScore;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="azureSubscriptionId")
    @JsonIgnore
    public Optional<String> getAzureSubscriptionId() {
        return Optional.ofNullable(azureSubscriptionId);
    }

    public HostSecurityProfile withAzureSubscriptionId(String azureSubscriptionId) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureSubscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.azureSubscriptionId = azureSubscriptionId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public HostSecurityProfile withAzureTenantId(String azureTenantId) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="firstSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenDateTime() {
        return Optional.ofNullable(firstSeenDateTime);
    }

    public HostSecurityProfile withFirstSeenDateTime(OffsetDateTime firstSeenDateTime) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("firstSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.firstSeenDateTime = firstSeenDateTime;
        return _x;
    }

    @Property(name="fqdn")
    @JsonIgnore
    public Optional<String> getFqdn() {
        return Optional.ofNullable(fqdn);
    }

    public HostSecurityProfile withFqdn(String fqdn) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("fqdn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.fqdn = fqdn;
        return _x;
    }

    @Property(name="isAzureAdJoined")
    @JsonIgnore
    public Optional<Boolean> getIsAzureAdJoined() {
        return Optional.ofNullable(isAzureAdJoined);
    }

    public HostSecurityProfile withIsAzureAdJoined(Boolean isAzureAdJoined) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("isAzureAdJoined");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.isAzureAdJoined = isAzureAdJoined;
        return _x;
    }

    @Property(name="isAzureAdRegistered")
    @JsonIgnore
    public Optional<Boolean> getIsAzureAdRegistered() {
        return Optional.ofNullable(isAzureAdRegistered);
    }

    public HostSecurityProfile withIsAzureAdRegistered(Boolean isAzureAdRegistered) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("isAzureAdRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.isAzureAdRegistered = isAzureAdRegistered;
        return _x;
    }

    @Property(name="isHybridAzureDomainJoined")
    @JsonIgnore
    public Optional<Boolean> getIsHybridAzureDomainJoined() {
        return Optional.ofNullable(isHybridAzureDomainJoined);
    }

    public HostSecurityProfile withIsHybridAzureDomainJoined(Boolean isHybridAzureDomainJoined) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("isHybridAzureDomainJoined");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
        return _x;
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public HostSecurityProfile withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("lastSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="logonUsers")
    @JsonIgnore
    public CollectionPage<LogonUser> getLogonUsers() {
        return new CollectionPage<LogonUser>(contextPath, LogonUser.class, logonUsers, Optional.ofNullable(logonUsersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="logonUsers")
    @JsonIgnore
    public CollectionPage<LogonUser> getLogonUsers(HttpRequestOptions options) {
        return new CollectionPage<LogonUser>(contextPath, LogonUser.class, logonUsers, Optional.ofNullable(logonUsersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="netBiosName")
    @JsonIgnore
    public Optional<String> getNetBiosName() {
        return Optional.ofNullable(netBiosName);
    }

    public HostSecurityProfile withNetBiosName(String netBiosName) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("netBiosName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.netBiosName = netBiosName;
        return _x;
    }

    @Property(name="networkInterfaces")
    @JsonIgnore
    public CollectionPage<NetworkInterface> getNetworkInterfaces() {
        return new CollectionPage<NetworkInterface>(contextPath, NetworkInterface.class, networkInterfaces, Optional.ofNullable(networkInterfacesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="networkInterfaces")
    @JsonIgnore
    public CollectionPage<NetworkInterface> getNetworkInterfaces(HttpRequestOptions options) {
        return new CollectionPage<NetworkInterface>(contextPath, NetworkInterface.class, networkInterfaces, Optional.ofNullable(networkInterfacesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="os")
    @JsonIgnore
    public Optional<String> getOs() {
        return Optional.ofNullable(os);
    }

    public HostSecurityProfile withOs(String os) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("os");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.os = os;
        return _x;
    }

    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    public HostSecurityProfile withOsVersion(String osVersion) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.osVersion = osVersion;
        return _x;
    }

    @Property(name="parentHost")
    @JsonIgnore
    public Optional<String> getParentHost() {
        return Optional.ofNullable(parentHost);
    }

    public HostSecurityProfile withParentHost(String parentHost) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("parentHost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.parentHost = parentHost;
        return _x;
    }

    @Property(name="relatedHostIds")
    @JsonIgnore
    public CollectionPage<String> getRelatedHostIds() {
        return new CollectionPage<String>(contextPath, String.class, relatedHostIds, Optional.ofNullable(relatedHostIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="relatedHostIds")
    @JsonIgnore
    public CollectionPage<String> getRelatedHostIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, relatedHostIds, Optional.ofNullable(relatedHostIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public HostSecurityProfile withRiskScore(String riskScore) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("riskScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public HostSecurityProfile withVendorInformation(SecurityVendorInformation vendorInformation) {
        HostSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityProfile");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public HostSecurityProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        HostSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public HostSecurityProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        HostSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private HostSecurityProfile _copy() {
        HostSecurityProfile _x = new HostSecurityProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.azureSubscriptionId = azureSubscriptionId;
        _x.azureTenantId = azureTenantId;
        _x.firstSeenDateTime = firstSeenDateTime;
        _x.fqdn = fqdn;
        _x.isAzureAdJoined = isAzureAdJoined;
        _x.isAzureAdRegistered = isAzureAdRegistered;
        _x.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.logonUsers = logonUsers;
        _x.netBiosName = netBiosName;
        _x.networkInterfaces = networkInterfaces;
        _x.os = os;
        _x.osVersion = osVersion;
        _x.parentHost = parentHost;
        _x.relatedHostIds = relatedHostIds;
        _x.riskScore = riskScore;
        _x.tags = tags;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HostSecurityProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("azureSubscriptionId=");
        b.append(this.azureSubscriptionId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("firstSeenDateTime=");
        b.append(this.firstSeenDateTime);
        b.append(", ");
        b.append("fqdn=");
        b.append(this.fqdn);
        b.append(", ");
        b.append("isAzureAdJoined=");
        b.append(this.isAzureAdJoined);
        b.append(", ");
        b.append("isAzureAdRegistered=");
        b.append(this.isAzureAdRegistered);
        b.append(", ");
        b.append("isHybridAzureDomainJoined=");
        b.append(this.isHybridAzureDomainJoined);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("logonUsers=");
        b.append(this.logonUsers);
        b.append(", ");
        b.append("netBiosName=");
        b.append(this.netBiosName);
        b.append(", ");
        b.append("networkInterfaces=");
        b.append(this.networkInterfaces);
        b.append(", ");
        b.append("os=");
        b.append(this.os);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("parentHost=");
        b.append(this.parentHost);
        b.append(", ");
        b.append("relatedHostIds=");
        b.append(this.relatedHostIds);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
