package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The entity represents a collection of name/value pairs of a list box
 * presentation on a policy definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationValueList extends GroupPolicyPresentationValue implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationValueList";
    }

    @JsonProperty("values")
    protected List<KeyValuePair> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    protected GroupPolicyPresentationValueList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationValueList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime createdDateTime;
        private List<KeyValuePair> values;
        private String valuesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“A list of pairs for the associated presentation.”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(List<KeyValuePair> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        /**
         * <i>“A list of pairs for the associated presentation.”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(KeyValuePair... values) {
            return values(Arrays.asList(values));
        }

        /**
         * <i>“A list of pairs for the associated presentation.”</i>
         * 
         * @param valuesNextLink
         *            value of {@code values@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public GroupPolicyPresentationValueList build() {
            GroupPolicyPresentationValueList _x = new GroupPolicyPresentationValueList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyPresentationValueList";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.createdDateTime = createdDateTime;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“A list of pairs for the associated presentation.”</i>
     * 
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getValues() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, values, Optional.ofNullable(valuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of pairs for the associated presentation.”</i>
     * 
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getValues(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, values, Optional.ofNullable(valuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationValueList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationValueList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationValueList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationValueList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationValueList _copy() {
        GroupPolicyPresentationValueList _x = new GroupPolicyPresentationValueList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationValueList[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
