package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Represents an ADMX listBox element and an ADMX list element.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "explicitValue", 
    "valuePrefix"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationListBox extends GroupPolicyPresentation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationListBox";
    }

    @JsonProperty("explicitValue")
    protected Boolean explicitValue;

    @JsonProperty("valuePrefix")
    protected String valuePrefix;

    protected GroupPolicyPresentationListBox() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationListBox() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String label;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean explicitValue;
        private String valuePrefix;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“If this option is specified true the user must specify the registry subkey value
         * and the registry subkey name. The list box shows two columns, one for the name
         * and one for the data. The default value is false.”</i>
         * 
         * @param explicitValue
         *            value of {@code explicitValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder explicitValue(Boolean explicitValue) {
            this.explicitValue = explicitValue;
            this.changedFields = changedFields.add("explicitValue");
            return this;
        }

        public Builder valuePrefix(String valuePrefix) {
            this.valuePrefix = valuePrefix;
            this.changedFields = changedFields.add("valuePrefix");
            return this;
        }

        public GroupPolicyPresentationListBox build() {
            GroupPolicyPresentationListBox _x = new GroupPolicyPresentationListBox();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyPresentationListBox";
            _x.id = id;
            _x.label = label;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.explicitValue = explicitValue;
            _x.valuePrefix = valuePrefix;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“If this option is specified true the user must specify the registry subkey value
     * and the registry subkey name. The list box shows two columns, one for the name
     * and one for the data. The default value is false.”</i>
     * 
     * @return property explicitValue
     */
    @Property(name="explicitValue")
    @JsonIgnore
    public Optional<Boolean> getExplicitValue() {
        return Optional.ofNullable(explicitValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code explicitValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If this option is specified true the user must specify the registry subkey value
     * and the registry subkey name. The list box shows two columns, one for the name
     * and one for the data. The default value is false.”</i>
     * 
     * @param explicitValue
     *            new value of {@code explicitValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code explicitValue} field changed
     */
    public GroupPolicyPresentationListBox withExplicitValue(Boolean explicitValue) {
        GroupPolicyPresentationListBox _x = _copy();
        _x.changedFields = changedFields.add("explicitValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationListBox");
        _x.explicitValue = explicitValue;
        return _x;
    }

    @Property(name="valuePrefix")
    @JsonIgnore
    public Optional<String> getValuePrefix() {
        return Optional.ofNullable(valuePrefix);
    }

    public GroupPolicyPresentationListBox withValuePrefix(String valuePrefix) {
        GroupPolicyPresentationListBox _x = _copy();
        _x.changedFields = changedFields.add("valuePrefix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationListBox");
        _x.valuePrefix = valuePrefix;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationListBox patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationListBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationListBox put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationListBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationListBox _copy() {
        GroupPolicyPresentationListBox _x = new GroupPolicyPresentationListBox();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.label = label;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.explicitValue = explicitValue;
        _x.valuePrefix = valuePrefix;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationListBox[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("explicitValue=");
        b.append(this.explicitValue);
        b.append(", ");
        b.append("valuePrefix=");
        b.append(this.valuePrefix);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
