package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represents an ADMX comboBox element and an ADMX text element.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue", 
    "suggestions", 
    "required", 
    "maxLength"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationComboBox extends GroupPolicyPresentation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationComboBox";
    }

    @JsonProperty("defaultValue")
    protected String defaultValue;

    @JsonProperty("suggestions")
    protected List<String> suggestions;

    @JsonProperty("suggestions@nextLink")
    protected String suggestionsNextLink;

    @JsonProperty("required")
    protected Boolean required;

    @JsonProperty("maxLength")
    protected Long maxLength;

    protected GroupPolicyPresentationComboBox() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationComboBox() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String label;
        private OffsetDateTime lastModifiedDateTime;
        private String defaultValue;
        private List<String> suggestions;
        private String suggestionsNextLink;
        private Boolean required;
        private Long maxLength;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Localized default string displayed in the combo box. The default value is empty.”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        /**
         * <i>“Localized strings listed in the drop-down list of the combo box. The default
         * value is empty.”</i>
         * 
         * @param suggestions
         *            value of {@code suggestions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder suggestions(List<String> suggestions) {
            this.suggestions = suggestions;
            this.changedFields = changedFields.add("suggestions");
            return this;
        }

        /**
         * <i>“Localized strings listed in the drop-down list of the combo box. The default
         * value is empty.”</i>
         * 
         * @param suggestions
         *            value of {@code suggestions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder suggestions(String... suggestions) {
            return suggestions(Arrays.asList(suggestions));
        }

        /**
         * <i>“Localized strings listed in the drop-down list of the combo box. The default
         * value is empty.”</i>
         * 
         * @param suggestionsNextLink
         *            value of {@code suggestions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder suggestionsNextLink(String suggestionsNextLink) {
            this.suggestionsNextLink = suggestionsNextLink;
            this.changedFields = changedFields.add("suggestions");
            return this;
        }

        /**
         * <i>“Specifies whether a value must be specified for the parameter. The default value
         * is false.”</i>
         * 
         * @param required
         *            value of {@code required} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the maximum number of text characters for the
         * parameter. The default value is 1023.”</i>
         * 
         * @param maxLength
         *            value of {@code maxLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxLength(Long maxLength) {
            this.maxLength = maxLength;
            this.changedFields = changedFields.add("maxLength");
            return this;
        }

        public GroupPolicyPresentationComboBox build() {
            GroupPolicyPresentationComboBox _x = new GroupPolicyPresentationComboBox();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyPresentationComboBox";
            _x.id = id;
            _x.label = label;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.defaultValue = defaultValue;
            _x.suggestions = suggestions;
            _x.suggestionsNextLink = suggestionsNextLink;
            _x.required = required;
            _x.maxLength = maxLength;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Localized default string displayed in the combo box. The default value is empty.”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Localized default string displayed in the combo box. The default value is empty.”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public GroupPolicyPresentationComboBox withDefaultValue(String defaultValue) {
        GroupPolicyPresentationComboBox _x = _copy();
        _x.changedFields = changedFields.add("defaultValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationComboBox");
        _x.defaultValue = defaultValue;
        return _x;
    }

    /**
     * <i>“Localized strings listed in the drop-down list of the combo box. The default
     * value is empty.”</i>
     * 
     * @return property suggestions
     */
    @Property(name="suggestions")
    @JsonIgnore
    public CollectionPage<String> getSuggestions() {
        return new CollectionPage<String>(contextPath, String.class, suggestions, Optional.ofNullable(suggestionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Localized strings listed in the drop-down list of the combo box. The default
     * value is empty.”</i>
     * 
     * @return property suggestions
     */
    @Property(name="suggestions")
    @JsonIgnore
    public CollectionPage<String> getSuggestions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, suggestions, Optional.ofNullable(suggestionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Specifies whether a value must be specified for the parameter. The default value
     * is false.”</i>
     * 
     * @return property required
     */
    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code required} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies whether a value must be specified for the parameter. The default value
     * is false.”</i>
     * 
     * @param required
     *            new value of {@code required} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code required} field changed
     */
    public GroupPolicyPresentationComboBox withRequired(Boolean required) {
        GroupPolicyPresentationComboBox _x = _copy();
        _x.changedFields = changedFields.add("required");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationComboBox");
        _x.required = required;
        return _x;
    }

    /**
     * <i>“An unsigned integer that specifies the maximum number of text characters for the
     * parameter. The default value is 1023.”</i>
     * 
     * @return property maxLength
     */
    @Property(name="maxLength")
    @JsonIgnore
    public Optional<Long> getMaxLength() {
        return Optional.ofNullable(maxLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maxLength} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“An unsigned integer that specifies the maximum number of text characters for the
     * parameter. The default value is 1023.”</i>
     * 
     * @param maxLength
     *            new value of {@code maxLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxLength} field changed
     */
    public GroupPolicyPresentationComboBox withMaxLength(Long maxLength) {
        GroupPolicyPresentationComboBox _x = _copy();
        _x.changedFields = changedFields.add("maxLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationComboBox");
        _x.maxLength = maxLength;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationComboBox patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationComboBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationComboBox put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationComboBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationComboBox _copy() {
        GroupPolicyPresentationComboBox _x = new GroupPolicyPresentationComboBox();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.label = label;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.defaultValue = defaultValue;
        _x.suggestions = suggestions;
        _x.required = required;
        _x.maxLength = maxLength;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationComboBox[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("suggestions=");
        b.append(this.suggestions);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append(", ");
        b.append("maxLength=");
        b.append(this.maxLength);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
