package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.GroupPolicyOperationStatus;
import odata.msgraph.client.beta.enums.GroupPolicyOperationType;


/**
 * <i>“The entity represents an group policy operation.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "operationType", 
    "operationStatus", 
    "statusDetails", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyOperation";
    }

    @JsonProperty("operationType")
    protected GroupPolicyOperationType operationType;

    @JsonProperty("operationStatus")
    protected GroupPolicyOperationStatus operationStatus;

    @JsonProperty("statusDetails")
    protected String statusDetails;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected GroupPolicyOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private GroupPolicyOperationType operationType;
        private GroupPolicyOperationStatus operationStatus;
        private String statusDetails;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The type of group policy operation.”</i>
         * 
         * @param operationType
         *            value of {@code operationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operationType(GroupPolicyOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        /**
         * <i>“The group policy operation status.”</i>
         * 
         * @param operationStatus
         *            value of {@code operationStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operationStatus(GroupPolicyOperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            this.changedFields = changedFields.add("operationStatus");
            return this;
        }

        /**
         * <i>“The group policy operation status detail.”</i>
         * 
         * @param statusDetails
         *            value of {@code statusDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            this.changedFields = changedFields.add("statusDetails");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public GroupPolicyOperation build() {
            GroupPolicyOperation _x = new GroupPolicyOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyOperation";
            _x.id = id;
            _x.operationType = operationType;
            _x.operationStatus = operationStatus;
            _x.statusDetails = statusDetails;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The type of group policy operation.”</i>
     * 
     * @return property operationType
     */
    @Property(name="operationType")
    @JsonIgnore
    public Optional<GroupPolicyOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The type of group policy operation.”</i>
     * 
     * @param operationType
     *            new value of {@code operationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operationType} field changed
     */
    public GroupPolicyOperation withOperationType(GroupPolicyOperationType operationType) {
        GroupPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("operationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyOperation");
        _x.operationType = operationType;
        return _x;
    }

    /**
     * <i>“The group policy operation status.”</i>
     * 
     * @return property operationStatus
     */
    @Property(name="operationStatus")
    @JsonIgnore
    public Optional<GroupPolicyOperationStatus> getOperationStatus() {
        return Optional.ofNullable(operationStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operationStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The group policy operation status.”</i>
     * 
     * @param operationStatus
     *            new value of {@code operationStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operationStatus} field changed
     */
    public GroupPolicyOperation withOperationStatus(GroupPolicyOperationStatus operationStatus) {
        GroupPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("operationStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyOperation");
        _x.operationStatus = operationStatus;
        return _x;
    }

    /**
     * <i>“The group policy operation status detail.”</i>
     * 
     * @return property statusDetails
     */
    @Property(name="statusDetails")
    @JsonIgnore
    public Optional<String> getStatusDetails() {
        return Optional.ofNullable(statusDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code statusDetails}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The group policy operation status detail.”</i>
     * 
     * @param statusDetails
     *            new value of {@code statusDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code statusDetails} field changed
     */
    public GroupPolicyOperation withStatusDetails(String statusDetails) {
        GroupPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("statusDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyOperation");
        _x.statusDetails = statusDetails;
        return _x;
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyOperation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyOperation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyOperation _copy() {
        GroupPolicyOperation _x = new GroupPolicyOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.operationType = operationType;
        _x.operationStatus = operationStatus;
        _x.statusDetails = statusDetails;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("operationStatus=");
        b.append(this.operationStatus);
        b.append(", ");
        b.append("statusDetails=");
        b.append(this.statusDetails);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
