package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The Group Policy Object file uploaded by admin.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupPolicyObjectId", 
    "ouDistinguishedName", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "content"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyObjectFile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyObjectFile";
    }

    @JsonProperty("groupPolicyObjectId")
    protected String groupPolicyObjectId;

    @JsonProperty("ouDistinguishedName")
    protected String ouDistinguishedName;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("content")
    protected String content;

    protected GroupPolicyObjectFile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyObjectFile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String groupPolicyObjectId;
        private String ouDistinguishedName;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String content;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Group Policy Object GUID from GPO Xml content”</i>
         * 
         * @param groupPolicyObjectId
         *            value of {@code groupPolicyObjectId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyObjectId(String groupPolicyObjectId) {
            this.groupPolicyObjectId = groupPolicyObjectId;
            this.changedFields = changedFields.add("groupPolicyObjectId");
            return this;
        }

        /**
         * <i>“The distinguished name of the OU.”</i>
         * 
         * @param ouDistinguishedName
         *            value of {@code ouDistinguishedName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ouDistinguishedName(String ouDistinguishedName) {
            this.ouDistinguishedName = ouDistinguishedName;
            this.changedFields = changedFields.add("ouDistinguishedName");
            return this;
        }

        /**
         * <i>“The date and time at which the GroupPolicy was first uploaded.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The date and time at which the GroupPolicyObjectFile was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The Group Policy Object file content.”</i>
         * 
         * @param content
         *            value of {@code content} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public GroupPolicyObjectFile build() {
            GroupPolicyObjectFile _x = new GroupPolicyObjectFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyObjectFile";
            _x.id = id;
            _x.groupPolicyObjectId = groupPolicyObjectId;
            _x.ouDistinguishedName = ouDistinguishedName;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.content = content;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Group Policy Object GUID from GPO Xml content”</i>
     * 
     * @return property groupPolicyObjectId
     */
    @Property(name="groupPolicyObjectId")
    @JsonIgnore
    public Optional<String> getGroupPolicyObjectId() {
        return Optional.ofNullable(groupPolicyObjectId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyObjectId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Group Policy Object GUID from GPO Xml content”</i>
     * 
     * @param groupPolicyObjectId
     *            new value of {@code groupPolicyObjectId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyObjectId} field changed
     */
    public GroupPolicyObjectFile withGroupPolicyObjectId(String groupPolicyObjectId) {
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyObjectId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyObjectFile");
        _x.groupPolicyObjectId = groupPolicyObjectId;
        return _x;
    }

    /**
     * <i>“The distinguished name of the OU.”</i>
     * 
     * @return property ouDistinguishedName
     */
    @Property(name="ouDistinguishedName")
    @JsonIgnore
    public Optional<String> getOuDistinguishedName() {
        return Optional.ofNullable(ouDistinguishedName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ouDistinguishedName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The distinguished name of the OU.”</i>
     * 
     * @param ouDistinguishedName
     *            new value of {@code ouDistinguishedName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ouDistinguishedName} field changed
     */
    public GroupPolicyObjectFile withOuDistinguishedName(String ouDistinguishedName) {
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = changedFields.add("ouDistinguishedName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyObjectFile");
        _x.ouDistinguishedName = ouDistinguishedName;
        return _x;
    }

    /**
     * <i>“The date and time at which the GroupPolicy was first uploaded.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time at which the GroupPolicy was first uploaded.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public GroupPolicyObjectFile withCreatedDateTime(OffsetDateTime createdDateTime) {
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyObjectFile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The date and time at which the GroupPolicyObjectFile was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time at which the GroupPolicyObjectFile was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyObjectFile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyObjectFile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The Group Policy Object file content.”</i>
     * 
     * @return property content
     */
    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code content} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Group Policy Object file content.”</i>
     * 
     * @param content
     *            new value of {@code content} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code content} field changed
     */
    public GroupPolicyObjectFile withContent(String content) {
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyObjectFile");
        _x.content = content;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyObjectFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyObjectFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyObjectFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyObjectFile _copy() {
        GroupPolicyObjectFile _x = new GroupPolicyObjectFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.groupPolicyObjectId = groupPolicyObjectId;
        _x.ouDistinguishedName = ouDistinguishedName;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.content = content;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyObjectFile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("groupPolicyObjectId=");
        b.append(this.groupPolicyObjectId);
        b.append(", ");
        b.append("ouDistinguishedName=");
        b.append(this.ouDistinguishedName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
