package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GroupPolicyPresentationCollectionRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyCategoryRequest;
import odata.msgraph.client.beta.entity.request.GroupPolicyDefinitionFileRequest;
import odata.msgraph.client.beta.enums.GroupPolicyDefinitionClassType;
import odata.msgraph.client.beta.enums.GroupPolicyType;


/**
 * <i>“The entity describes all of the information about a single group policy.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "classType", 
    "displayName", 
    "explainText", 
    "categoryPath", 
    "supportedOn", 
    "policyType", 
    "groupPolicyCategoryId", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyDefinition";
    }

    @JsonProperty("classType")
    protected GroupPolicyDefinitionClassType classType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("explainText")
    protected String explainText;

    @JsonProperty("categoryPath")
    protected String categoryPath;

    @JsonProperty("supportedOn")
    protected String supportedOn;

    @JsonProperty("policyType")
    protected GroupPolicyType policyType;

    @JsonProperty("groupPolicyCategoryId")
    protected String groupPolicyCategoryId;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected GroupPolicyDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private GroupPolicyDefinitionClassType classType;
        private String displayName;
        private String explainText;
        private String categoryPath;
        private String supportedOn;
        private GroupPolicyType policyType;
        private String groupPolicyCategoryId;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Identifies the type of groups the policy can be applied to.”</i>
         * 
         * @param classType
         *            value of {@code classType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classType(GroupPolicyDefinitionClassType classType) {
            this.classType = classType;
            this.changedFields = changedFields.add("classType");
            return this;
        }

        /**
         * <i>“The localized policy name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The localized explanation or help text associated with the policy. The default
         * value is empty.”</i>
         * 
         * @param explainText
         *            value of {@code explainText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder explainText(String explainText) {
            this.explainText = explainText;
            this.changedFields = changedFields.add("explainText");
            return this;
        }

        /**
         * <i>“The localized full category path for the policy.”</i>
         * 
         * @param categoryPath
         *            value of {@code categoryPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            this.changedFields = changedFields.add("categoryPath");
            return this;
        }

        /**
         * <i>“Localized string used to specify what operating system or application version is
         * affected by the policy.”</i>
         * 
         * @param supportedOn
         *            value of {@code supportedOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedOn(String supportedOn) {
            this.supportedOn = supportedOn;
            this.changedFields = changedFields.add("supportedOn");
            return this;
        }

        /**
         * <i>“Specifies the type of group policy.”</i>
         * 
         * @param policyType
         *            value of {@code policyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyType(GroupPolicyType policyType) {
            this.policyType = policyType;
            this.changedFields = changedFields.add("policyType");
            return this;
        }

        /**
         * <i>“The category id of the parent category”</i>
         * 
         * @param groupPolicyCategoryId
         *            value of {@code groupPolicyCategoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyCategoryId(String groupPolicyCategoryId) {
            this.groupPolicyCategoryId = groupPolicyCategoryId;
            this.changedFields = changedFields.add("groupPolicyCategoryId");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public GroupPolicyDefinition build() {
            GroupPolicyDefinition _x = new GroupPolicyDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyDefinition";
            _x.id = id;
            _x.classType = classType;
            _x.displayName = displayName;
            _x.explainText = explainText;
            _x.categoryPath = categoryPath;
            _x.supportedOn = supportedOn;
            _x.policyType = policyType;
            _x.groupPolicyCategoryId = groupPolicyCategoryId;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Identifies the type of groups the policy can be applied to.”</i>
     * 
     * @return property classType
     */
    @Property(name="classType")
    @JsonIgnore
    public Optional<GroupPolicyDefinitionClassType> getClassType() {
        return Optional.ofNullable(classType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code classType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifies the type of groups the policy can be applied to.”</i>
     * 
     * @param classType
     *            new value of {@code classType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classType} field changed
     */
    public GroupPolicyDefinition withClassType(GroupPolicyDefinitionClassType classType) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("classType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.classType = classType;
        return _x;
    }

    /**
     * <i>“The localized policy name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized policy name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public GroupPolicyDefinition withDisplayName(String displayName) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The localized explanation or help text associated with the policy. The default
     * value is empty.”</i>
     * 
     * @return property explainText
     */
    @Property(name="explainText")
    @JsonIgnore
    public Optional<String> getExplainText() {
        return Optional.ofNullable(explainText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code explainText}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized explanation or help text associated with the policy. The default
     * value is empty.”</i>
     * 
     * @param explainText
     *            new value of {@code explainText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code explainText} field changed
     */
    public GroupPolicyDefinition withExplainText(String explainText) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("explainText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.explainText = explainText;
        return _x;
    }

    /**
     * <i>“The localized full category path for the policy.”</i>
     * 
     * @return property categoryPath
     */
    @Property(name="categoryPath")
    @JsonIgnore
    public Optional<String> getCategoryPath() {
        return Optional.ofNullable(categoryPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code categoryPath}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The localized full category path for the policy.”</i>
     * 
     * @param categoryPath
     *            new value of {@code categoryPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categoryPath} field changed
     */
    public GroupPolicyDefinition withCategoryPath(String categoryPath) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("categoryPath");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.categoryPath = categoryPath;
        return _x;
    }

    /**
     * <i>“Localized string used to specify what operating system or application version is
     * affected by the policy.”</i>
     * 
     * @return property supportedOn
     */
    @Property(name="supportedOn")
    @JsonIgnore
    public Optional<String> getSupportedOn() {
        return Optional.ofNullable(supportedOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportedOn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Localized string used to specify what operating system or application version is
     * affected by the policy.”</i>
     * 
     * @param supportedOn
     *            new value of {@code supportedOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportedOn} field changed
     */
    public GroupPolicyDefinition withSupportedOn(String supportedOn) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("supportedOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.supportedOn = supportedOn;
        return _x;
    }

    /**
     * <i>“Specifies the type of group policy.”</i>
     * 
     * @return property policyType
     */
    @Property(name="policyType")
    @JsonIgnore
    public Optional<GroupPolicyType> getPolicyType() {
        return Optional.ofNullable(policyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies the type of group policy.”</i>
     * 
     * @param policyType
     *            new value of {@code policyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyType} field changed
     */
    public GroupPolicyDefinition withPolicyType(GroupPolicyType policyType) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("policyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.policyType = policyType;
        return _x;
    }

    /**
     * <i>“The category id of the parent category”</i>
     * 
     * @return property groupPolicyCategoryId
     */
    @Property(name="groupPolicyCategoryId")
    @JsonIgnore
    public Optional<String> getGroupPolicyCategoryId() {
        return Optional.ofNullable(groupPolicyCategoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyCategoryId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The category id of the parent category”</i>
     * 
     * @param groupPolicyCategoryId
     *            new value of {@code groupPolicyCategoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyCategoryId} field changed
     */
    public GroupPolicyDefinition withGroupPolicyCategoryId(String groupPolicyCategoryId) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.groupPolicyCategoryId = groupPolicyCategoryId;
        return _x;
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyDefinition withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyDefinition");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The group policy file associated with the definition.”</i>
     * 
     * @return navigational property definitionFile
     */
    @NavigationProperty(name="definitionFile")
    @JsonIgnore
    public GroupPolicyDefinitionFileRequest getDefinitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"));
    }

    /**
     * <i>“The group policy category associated with the definition.”</i>
     * 
     * @return navigational property category
     */
    @NavigationProperty(name="category")
    @JsonIgnore
    public GroupPolicyCategoryRequest getCategory() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("category"));
    }

    /**
     * <i>“The group policy presentations associated with the definition.”</i>
     * 
     * @return navigational property presentations
     */
    @NavigationProperty(name="presentations")
    @JsonIgnore
    public GroupPolicyPresentationCollectionRequest getPresentations() {
        return new GroupPolicyPresentationCollectionRequest(
                        contextPath.addSegment("presentations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyDefinition _copy() {
        GroupPolicyDefinition _x = new GroupPolicyDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.classType = classType;
        _x.displayName = displayName;
        _x.explainText = explainText;
        _x.categoryPath = categoryPath;
        _x.supportedOn = supportedOn;
        _x.policyType = policyType;
        _x.groupPolicyCategoryId = groupPolicyCategoryId;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classType=");
        b.append(this.classType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("explainText=");
        b.append(this.explainText);
        b.append(", ");
        b.append("categoryPath=");
        b.append(this.categoryPath);
        b.append(", ");
        b.append("supportedOn=");
        b.append(this.supportedOn);
        b.append(", ");
        b.append("policyType=");
        b.append(this.policyType);
        b.append(", ");
        b.append("groupPolicyCategoryId=");
        b.append(this.groupPolicyCategoryId);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
