package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "groupLifetimeInDays", 
    "managedGroupTypes", 
    "alternateNotificationEmails"})
@JsonInclude(Include.NON_NULL)
public class GroupLifecyclePolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupLifecyclePolicy";
    }

    @JsonProperty("groupLifetimeInDays")
    protected Integer groupLifetimeInDays;

    @JsonProperty("managedGroupTypes")
    protected String managedGroupTypes;

    @JsonProperty("alternateNotificationEmails")
    protected String alternateNotificationEmails;

    protected GroupLifecyclePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupLifecyclePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer groupLifetimeInDays;
        private String managedGroupTypes;
        private String alternateNotificationEmails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder groupLifetimeInDays(Integer groupLifetimeInDays) {
            this.groupLifetimeInDays = groupLifetimeInDays;
            this.changedFields = changedFields.add("groupLifetimeInDays");
            return this;
        }

        public Builder managedGroupTypes(String managedGroupTypes) {
            this.managedGroupTypes = managedGroupTypes;
            this.changedFields = changedFields.add("managedGroupTypes");
            return this;
        }

        public Builder alternateNotificationEmails(String alternateNotificationEmails) {
            this.alternateNotificationEmails = alternateNotificationEmails;
            this.changedFields = changedFields.add("alternateNotificationEmails");
            return this;
        }

        public GroupLifecyclePolicy build() {
            GroupLifecyclePolicy _x = new GroupLifecyclePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupLifecyclePolicy";
            _x.id = id;
            _x.groupLifetimeInDays = groupLifetimeInDays;
            _x.managedGroupTypes = managedGroupTypes;
            _x.alternateNotificationEmails = alternateNotificationEmails;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="groupLifetimeInDays")
    @JsonIgnore
    public Optional<Integer> getGroupLifetimeInDays() {
        return Optional.ofNullable(groupLifetimeInDays);
    }

    public GroupLifecyclePolicy withGroupLifetimeInDays(Integer groupLifetimeInDays) {
        GroupLifecyclePolicy _x = _copy();
        _x.changedFields = changedFields.add("groupLifetimeInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupLifecyclePolicy");
        _x.groupLifetimeInDays = groupLifetimeInDays;
        return _x;
    }

    @Property(name="managedGroupTypes")
    @JsonIgnore
    public Optional<String> getManagedGroupTypes() {
        return Optional.ofNullable(managedGroupTypes);
    }

    public GroupLifecyclePolicy withManagedGroupTypes(String managedGroupTypes) {
        GroupLifecyclePolicy _x = _copy();
        _x.changedFields = changedFields.add("managedGroupTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupLifecyclePolicy");
        _x.managedGroupTypes = managedGroupTypes;
        return _x;
    }

    @Property(name="alternateNotificationEmails")
    @JsonIgnore
    public Optional<String> getAlternateNotificationEmails() {
        return Optional.ofNullable(alternateNotificationEmails);
    }

    public GroupLifecyclePolicy withAlternateNotificationEmails(String alternateNotificationEmails) {
        GroupLifecyclePolicy _x = _copy();
        _x.changedFields = changedFields.add("alternateNotificationEmails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupLifecyclePolicy");
        _x.alternateNotificationEmails = alternateNotificationEmails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupLifecyclePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupLifecyclePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupLifecyclePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupLifecyclePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupLifecyclePolicy _copy() {
        GroupLifecyclePolicy _x = new GroupLifecyclePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.groupLifetimeInDays = groupLifetimeInDays;
        _x.managedGroupTypes = managedGroupTypes;
        _x.alternateNotificationEmails = alternateNotificationEmails;
        return _x;
    }

    @Action(name = "addGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> addGroup(String groupId) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addGroup"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "removeGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> removeGroup(String groupId) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeGroup"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupLifecyclePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("groupLifetimeInDays=");
        b.append(this.groupLifetimeInDays);
        b.append(", ");
        b.append("managedGroupTypes=");
        b.append(this.managedGroupTypes);
        b.append(", ");
        b.append("alternateNotificationEmails=");
        b.append(this.alternateNotificationEmails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
